/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Properties;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.net.nt.SocketChannelWrapper;

public class WSSSocketChannel
extends SocketChannelWrapper
implements Monitor {
    private static final byte WS_OPCODE_CONTINUE = 0;
    private static final byte WS_OPCODE_TEXTDATA = 1;
    private static final byte WS_OPCODE_BINARYDATA = 2;
    private static final byte WS_OPCODE_CLOSE = 8;
    private static final byte WS_OPCODE_PING = 9;
    private static final byte WS_OPCODE_PONG = 10;
    private static final int HANDSHAKE_RESPONSE_BUFFER_SIZE = 1024;
    private static final byte MASK_BYTE_OPCODE = 15;
    private static final byte MASK_BYTE_FIN = -127;
    public static final byte[] WS_DUMMY_MASK_KEY = new byte[]{0, 0, 0, 0};
    private ByteBuffer payloadBuffer;
    private boolean isClosed = false;
    private final Monitor.CloseableLock monitorLock = this.newDefaultLock();

    public WSSSocketChannel(SocketChannel socketChannel, String string, String string2, int n2, String string3, OpaqueString opaqueString) throws IOException {
        super(socketChannel);
        this.payloadBuffer = ByteBuffer.allocate(this.bufferSize);
        this.payloadBuffer.limit(0);
        this.doWSHandShake(string, string2, n2, string3, opaqueString);
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        int n2 = byteBuffer.position();
        if (!this.payloadBuffer.hasRemaining()) {
            this.readFromSocket();
        }
        while (this.payloadBuffer.hasRemaining() && byteBuffer.hasRemaining()) {
            byteBuffer.put(this.payloadBuffer.get());
        }
        return byteBuffer.position() - n2;
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        int n2 = byteBuffer.remaining();
        if (n2 > 0) {
            WSFrame.writeFrame(this.socketChannel, new WSBinaryFrame(byteBuffer));
        }
        return n2;
    }

    public void sendPing(ByteBuffer byteBuffer) throws IOException {
        WSPingFrame wSPingFrame = new WSPingFrame(byteBuffer, this.socketChannel);
        WSFrame.writeFrame(this.socketChannel, wSPingFrame);
    }

    @Override
    public void setBufferSize(int n2) {
        if (this.bufferSize == n2) {
            return;
        }
        this.bufferSize = n2;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
        if (this.payloadBuffer.hasRemaining()) {
            byteBuffer.put(this.payloadBuffer);
        }
        byteBuffer.flip();
        this.payloadBuffer = byteBuffer;
    }

    private void doWSHandShake(String string, String string2, int n2, String string3, OpaqueString opaqueString) throws IOException {
        WSHandshakeHelper wSHandshakeHelper = new WSHandshakeHelper(string, null, string2, n2, string3, opaqueString);
        wSHandshakeHelper.sendHandshakeData(this.socketChannel);
        wSHandshakeHelper.receiveHandshakeResponse(this.socketChannel);
    }

    private void readFromSocket() throws IOException {
        WSFrame wSFrame = WSFrame.readFrame(this.socketChannel, this.payloadBuffer);
        if (wSFrame.header.opCode == 9) {
            WSPongFrame wSPongFrame = new WSPongFrame(this.payloadBuffer);
            WSFrame.writeFrame(this.socketChannel, wSPongFrame);
            this.readFromSocket();
        } else if (wSFrame.header.opCode == 8) {
            throw new IOException("WebSocket : Connection closed. (Error code : " + ((WSCloseFrame)wSFrame).errorCode + ")");
        }
    }

    @Override
    public void disconnect() {
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            try {
                if (!this.isClosed && this.socketChannel != null && this.socketChannel.isOpen()) {
                    WSCloseFrame wSCloseFrame = new WSCloseFrame();
                    WSFrame.writeFrame(this.socketChannel, wSCloseFrame);
                    while (WSFrame.readFrame((SocketChannel)this.socketChannel, (ByteBuffer)this.payloadBuffer).header.opCode != 8) {
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.isClosed = true;
            try {
                if (this.socketChannel instanceof SocketChannelWrapper) {
                    ((SocketChannelWrapper)this.socketChannel).disconnect();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public final Monitor.CloseableLock getMonitorLock() {
        return this.monitorLock;
    }

    private static class WSPongFrame
    extends WSFrame {
        private WSPongFrame(WSHeader wSHeader, ByteBuffer byteBuffer, SocketChannel socketChannel) {
            super(wSHeader, byteBuffer, socketChannel);
        }

        private WSPongFrame(ByteBuffer byteBuffer) {
            this.payloadBuffer = byteBuffer;
        }

        @Override
        void prepareForWrite() throws IOException {
            this.header = new WSHeader();
            this.header.isFinalChunk = true;
            this.header.isPayloadMasked = true;
            this.header.maskingKey = WS_DUMMY_MASK_KEY;
            this.header.opCode = (byte)10;
            this.header.payloadLength = this.payloadBuffer != null ? this.payloadBuffer.remaining() : 0;
        }

        @Override
        void readPayload() throws IOException {
            this.readPayloadFromSocket();
            if (this.header.payloadLength > 0) {
                byte[] byArray = new byte[this.payloadBuffer.remaining()];
                this.payloadBuffer.get(byArray);
            }
        }
    }

    private static class WSPingFrame
    extends WSFrame {
        private WSPingFrame(WSHeader wSHeader, ByteBuffer byteBuffer, SocketChannel socketChannel) {
            super(wSHeader, byteBuffer, socketChannel);
        }

        private WSPingFrame(ByteBuffer byteBuffer, SocketChannel socketChannel) {
            super(null, byteBuffer, socketChannel);
        }

        @Override
        void prepareForWrite() throws IOException {
            this.header = new WSHeader();
            this.header.isFinalChunk = true;
            this.header.isPayloadMasked = true;
            this.header.maskingKey = WS_DUMMY_MASK_KEY;
            this.header.opCode = (byte)9;
            this.header.payloadLength = this.payloadBuffer != null ? this.payloadBuffer.remaining() : 0;
        }

        @Override
        void readPayload() throws IOException {
            this.readPayloadFromSocket();
        }
    }

    private static class WSBinaryFrame
    extends WSFrame {
        private WSBinaryFrame(WSHeader wSHeader, ByteBuffer byteBuffer, SocketChannel socketChannel) {
            super(wSHeader, byteBuffer, socketChannel);
        }

        private WSBinaryFrame(ByteBuffer byteBuffer) {
            this.payloadBuffer = byteBuffer;
        }

        @Override
        void prepareForWrite() throws IOException {
            this.header = new WSHeader();
            this.header.isFinalChunk = true;
            this.header.isPayloadMasked = true;
            this.header.maskingKey = WS_DUMMY_MASK_KEY;
            this.header.opCode = (byte)2;
            this.header.payloadLength = this.payloadBuffer.remaining();
        }

        @Override
        void readPayload() throws IOException {
            this.readPayloadFromSocket();
        }
    }

    private static class WSCloseFrame
    extends WSFrame {
        int errorCode;

        private WSCloseFrame(WSHeader wSHeader, ByteBuffer byteBuffer, SocketChannel socketChannel) {
            super(wSHeader, byteBuffer, socketChannel);
        }

        private WSCloseFrame() {
        }

        @Override
        void prepareForWrite() throws IOException {
            this.header = new WSHeader();
            this.header.isFinalChunk = true;
            this.header.isPayloadMasked = true;
            this.header.maskingKey = WS_DUMMY_MASK_KEY;
            this.header.opCode = (byte)8;
            this.header.payloadLength = 0;
        }

        @Override
        void readPayload() throws IOException {
            this.readPayloadFromSocket();
            this.errorCode = this.payloadBuffer.getShort();
        }
    }

    private static abstract class WSFrame {
        protected WSHeader header;
        protected ByteBuffer payloadBuffer;
        protected SocketChannel socketChannel;

        private WSFrame(WSHeader wSHeader, ByteBuffer byteBuffer, SocketChannel socketChannel) {
            this.header = wSHeader;
            this.payloadBuffer = byteBuffer;
            this.socketChannel = socketChannel;
        }

        private WSFrame() {
        }

        static WSFrame readFrame(SocketChannel socketChannel, ByteBuffer byteBuffer) throws IOException {
            WSHeader wSHeader = new WSHeader();
            wSHeader.read(socketChannel);
            WSFrame wSFrame = null;
            switch (wSHeader.opCode) {
                case 0: 
                case 2: {
                    wSFrame = new WSBinaryFrame(wSHeader, byteBuffer, socketChannel);
                    break;
                }
                case 9: {
                    wSFrame = new WSPingFrame(wSHeader, byteBuffer, socketChannel);
                    break;
                }
                case 10: {
                    wSFrame = new WSPongFrame(wSHeader, byteBuffer, socketChannel);
                    break;
                }
                case 8: {
                    wSFrame = new WSCloseFrame(wSHeader, byteBuffer, socketChannel);
                    break;
                }
                default: {
                    throw new IOException("Websocket : Invalid frame type : " + wSHeader.opCode);
                }
            }
            wSFrame.readPayload();
            wSFrame.maskOrUnmaskPayload();
            return wSFrame;
        }

        static void writeFrame(SocketChannel socketChannel, WSFrame wSFrame) throws IOException {
            wSFrame.prepareForWrite();
            wSFrame.header.write(socketChannel);
            if (wSFrame.payloadBuffer != null) {
                wSFrame.maskOrUnmaskPayload();
                while (wSFrame.payloadBuffer.hasRemaining()) {
                    socketChannel.write(wSFrame.payloadBuffer);
                }
            }
        }

        private void maskOrUnmaskPayload() {
            if (this.header.isPayloadMasked && this.header.payloadLength > 0) {
                int n2;
                for (int i2 = n2 = this.payloadBuffer.position(); i2 < this.payloadBuffer.limit(); ++i2) {
                    byte by = this.payloadBuffer.get(i2);
                    by = (byte)(by ^ this.header.maskingKey[i2 % 4]);
                    this.payloadBuffer.put(i2, by);
                }
                this.payloadBuffer.rewind();
                this.payloadBuffer.position(n2);
            }
        }

        protected void readPayloadFromSocket() throws IOException {
            this.payloadBuffer.clear();
            this.payloadBuffer.limit(this.header.payloadLength);
            if (this.header.payloadLength <= 0) {
                return;
            }
            while (this.payloadBuffer.hasRemaining()) {
                this.socketChannel.read(this.payloadBuffer);
            }
            this.payloadBuffer.flip();
        }

        abstract void readPayload() throws IOException;

        abstract void prepareForWrite() throws IOException;
    }

    private static class WSHeader {
        private boolean isFinalChunk;
        private byte opCode;
        private int payloadLength;
        private boolean isPayloadMasked;
        private byte[] maskingKey;

        private WSHeader() {
        }

        void read(SocketChannel socketChannel) throws IOException {
            ByteBuffer byteBuffer = ByteBuffer.allocate(14);
            byteBuffer.limit(2);
            while (byteBuffer.hasRemaining()) {
                socketChannel.read(byteBuffer);
            }
            byteBuffer.flip();
            byte by = byteBuffer.get();
            byte by2 = byteBuffer.get();
            this.isFinalChunk = (by & 0x80) != 0;
            this.opCode = (byte)(by & 0xF);
            this.isPayloadMasked = (by2 & 0x80) != 0;
            this.payloadLength = (byte)(0x7F & by2);
            this.readRemainingHeaderBytes(socketChannel, byteBuffer);
            if (this.payloadLength == 126) {
                this.payloadLength = byteBuffer.getShort() & 0xFFFF;
            } else if (this.payloadLength >= 127) {
                this.payloadLength = (int)byteBuffer.getLong();
            }
            if (this.isPayloadMasked) {
                this.maskingKey = new byte[4];
                byteBuffer.get(this.maskingKey);
            }
        }

        private void readRemainingHeaderBytes(SocketChannel socketChannel, ByteBuffer byteBuffer) throws IOException {
            int n2 = 2;
            if (this.payloadLength == 126) {
                n2 += 2;
            } else if (this.payloadLength >= 127) {
                n2 += 8;
            }
            if (this.isPayloadMasked) {
                n2 += 4;
            }
            byteBuffer.position(2);
            byteBuffer.limit(n2);
            while (byteBuffer.hasRemaining()) {
                socketChannel.read(byteBuffer);
            }
            byteBuffer.flip();
            byteBuffer.position(2);
        }

        private void write(SocketChannel socketChannel) throws IOException {
            ByteBuffer byteBuffer = ByteBuffer.allocate(14);
            byte by = this.opCode;
            if (this.isFinalChunk) {
                by = (byte)(by | 0x80);
            }
            byte by2 = 0;
            if (this.isPayloadMasked) {
                by2 = -128;
            }
            byteBuffer.put(by);
            if (this.payloadLength > 65535) {
                by2 = (byte)(by2 | 0x7F);
                byteBuffer.put(by2);
                byteBuffer.putLong(this.payloadLength);
            } else if (this.payloadLength >= 126) {
                by2 = (byte)(by2 | 0x7E);
                byteBuffer.put(by2);
                byteBuffer.putShort((short)this.payloadLength);
            } else {
                if (this.payloadLength != 0) {
                    by2 = (byte)(by2 | this.payloadLength & 0x7F);
                }
                byteBuffer.put(by2);
            }
            if (this.isPayloadMasked) {
                byteBuffer.put(this.maskingKey);
            }
            byteBuffer.flip();
            socketChannel.write(byteBuffer);
        }
    }

    private static class WSHandshakeHelper {
        private final byte[] MAGIC = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11".getBytes(StandardCharsets.UTF_8);
        private final int SWITCHING_PROTOCOLS = 101;
        private final Pattern PAT_STATUS_LINE = Pattern.compile("^HTTP/1.[01]\\s+(\\d+)\\s+(.*)", 2);
        private final Pattern PAT_HEADER = Pattern.compile("([^:]+):\\s*(.*)");
        private final String uri;
        private final String queryParam;
        private final String host;
        private final int port;
        private final String key;
        private final OpaqueString httpBasicAuthKey;

        WSHandshakeHelper(String string, String string2, String string3, int n2, String string4, OpaqueString opaqueString) {
            this.uri = string;
            this.queryParam = string2;
            this.host = string3;
            this.port = n2;
            this.key = this.genRandomKey();
            this.httpBasicAuthKey = string4 != null && opaqueString != null && opaqueString != OpaqueString.NULL ? this.getHTTPAuthHeader(string4, opaqueString) : null;
        }

        void sendHandshakeData(SocketChannel socketChannel) throws IOException {
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.generateUpgradeRequest().getBytes(StandardCharsets.ISO_8859_1));
            while (byteBuffer.hasRemaining()) {
                socketChannel.write(byteBuffer);
            }
        }

        void receiveHandshakeResponse(SocketChannel socketChannel) throws IOException {
            ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
            socketChannel.read(byteBuffer);
            byteBuffer.flip();
            String string = new String(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.limit(), StandardCharsets.ISO_8859_1);
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            String string2 = bufferedReader.readLine();
            this.validateStatus(string2);
            Properties properties = new Properties();
            string2 = bufferedReader.readLine();
            while (string2 != null && string2.trim().length() > 0) {
                this.parseHeader(string2, properties);
                string2 = bufferedReader.readLine();
            }
            this.validateResponseHeaders(properties);
        }

        private String generateUpgradeRequest() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("GET ");
            if (this.uri != null && this.uri.length() > 0) {
                if (!this.uri.startsWith("/")) {
                    stringBuilder.append("/");
                }
                stringBuilder.append(this.uri);
            } else {
                stringBuilder.append("/");
            }
            if (this.queryParam != null && this.queryParam.length() != 0) {
                stringBuilder.append("?").append(this.queryParam);
            }
            stringBuilder.append(" HTTP/1.1\r\n");
            stringBuilder.append("Host: ").append(this.host);
            if (this.port > 0) {
                stringBuilder.append(':').append(this.port);
            }
            stringBuilder.append("\r\n");
            stringBuilder.append("Upgrade: websocket\r\n");
            stringBuilder.append("Connection: Upgrade\r\n");
            stringBuilder.append("Sec-WebSocket-Key: ").append(this.key).append("\r\n");
            stringBuilder.append("Sec-WebSocket-Version: 13\r\n");
            stringBuilder.append("Sec-WebSocket-Protocol: sqlnet\r\n");
            if (this.httpBasicAuthKey != null) {
                stringBuilder.append("Authorization: " + this.httpBasicAuthKey.get() + "\r\n");
            }
            stringBuilder.append("Pragma: no-cache\r\n");
            stringBuilder.append("Cache-Control: no-cache\r\n");
            stringBuilder.append("\r\n");
            return stringBuilder.toString();
        }

        private void validateStatus(String string) throws IOException {
            Matcher matcher = this.PAT_STATUS_LINE.matcher(string);
            if (!matcher.matches()) {
                throw new IOException("WebSocket: Unexpected HTTP response status line [" + string + "]");
            }
            int n2 = Integer.parseInt(matcher.group(1));
            String string2 = matcher.group(2);
            if (n2 != 101) {
                throw new IOException("WebSocket: Unable to upgrade to websocket protocol [" + n2 + " : " + string2 + "]");
            }
        }

        private void validateResponseHeaders(@Blind(value=PropertiesBlinder.class) Properties properties) throws IOException {
            byte[] byArray;
            String string = properties.getProperty("Connection");
            if (!"upgrade".equalsIgnoreCase(string)) {
                throw new IOException("WebSocket: value of the header Connection is  " + string + " (expected 'upgrade')");
            }
            String string2 = properties.getProperty("Upgrade");
            if (!"websocket".equalsIgnoreCase(string2)) {
                throw new IOException("WebSocket: value of the header Upgrade is  " + string + " (expected 'websocket')");
            }
            String string3 = properties.getProperty("Sec-WebSocket-Accept");
            byte[] byArray2 = byArray = string3 == null ? null : string3.getBytes(StandardCharsets.ISO_8859_1);
            if (byArray == null || byArray.length < 20) {
                throw new IOException("Invalid Sec-WebSocket-Accept hash");
            }
            byte[] byArray3 = this.expectedAcceptHash(this.key);
            for (int i2 = 0; i2 < 20; ++i2) {
                if (byArray[i2] == byArray3[i2]) continue;
                throw new IOException("Sec-WebSocket-Accept hash does not match");
            }
        }

        private OpaqueString getHTTPAuthHeader(String string, OpaqueString opaqueString) {
            String string2 = string + ":" + opaqueString.get();
            byte[] byArray = Base64.getEncoder().encode(string2.getBytes(StandardCharsets.ISO_8859_1));
            String string3 = "Basic " + new String(byArray, StandardCharsets.ISO_8859_1);
            return OpaqueString.newOpaqueString(string3);
        }

        private void parseHeader(String string, @Blind(value=PropertiesBlinder.class) Properties properties) {
            Matcher matcher = this.PAT_HEADER.matcher(string);
            if (matcher.matches()) {
                properties.setProperty(matcher.group(1), matcher.group(2));
            }
        }

        private final String genRandomKey() {
            byte[] byArray = new byte[16];
            ThreadLocalRandom.current().nextBytes(byArray);
            return Base64.getEncoder().encodeToString(byArray);
        }

        private final byte[] expectedAcceptHash(String string) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
                messageDigest.update(this.key.getBytes(StandardCharsets.UTF_8));
                messageDigest.update(this.MAGIC);
                return Base64.getEncoder().encode(messageDigest.digest());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new RuntimeException(noSuchAlgorithmException);
            }
        }
    }
}

