/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.SyncObject;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.FirebirdBlob;
import org.firebirdsql.jdbc.Synchronizable;

public final class FBCachedBlob
implements FirebirdBlob,
Synchronizable {
    private static final byte[] BYTES_NULL_VALUE = null;
    private static final InputStream STREAM_NULL_VALUE = null;
    private static final byte[] FREED_MARKER = new byte[0];
    static final String BLOB_READ_ONLY = "Cached blob is read-only";
    private final Object syncObject = new SyncObject();
    private volatile byte[] blobData;

    public FBCachedBlob(byte[] data) {
        this.blobData = data;
    }

    @Override
    public FirebirdBlob detach() throws SQLException {
        this.checkClosed();
        return new FBCachedBlob(this.blobData);
    }

    @Override
    public boolean isSegmented() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public long length() throws SQLException {
        this.checkClosed();
        return this.blobData != null ? (long)this.blobData.length : -1L;
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        if (pos < 1L) {
            throw new SQLException("Expected value of pos > 0, got " + pos, "HY009");
        }
        if (length < 0) {
            throw new SQLException("Expected value of length >= 0, got " + length, "HY009");
        }
        this.checkClosed();
        if (this.blobData == null) {
            return BYTES_NULL_VALUE;
        }
        byte[] result = new byte[length];
        System.arraycopy(this.blobData, (int)pos - 1, result, 0, length);
        return result;
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        throw new FBDriverNotCapableException("Method Method position(byte[], long) is not supported");
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        throw new FBDriverNotCapableException("Method position(Blob, long) is not supported");
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        this.checkClosed();
        if (this.blobData == null) {
            return STREAM_NULL_VALUE;
        }
        return new ByteArrayInputStream(this.blobData);
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        throw new FBDriverNotCapableException("Method getBinaryStream(long, long) is not supported");
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        throw new FBSQLException(BLOB_READ_ONLY);
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        throw new FBSQLException(BLOB_READ_ONLY);
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        throw new FBSQLException(BLOB_READ_ONLY);
    }

    @Override
    public void truncate(long length) throws SQLException {
        throw new FBDriverNotCapableException("Method truncate(long) is not supported");
    }

    @Override
    public final Object getSynchronizationObject() {
        return this.syncObject;
    }

    @Override
    public void free() throws SQLException {
        this.blobData = FREED_MARKER;
    }

    private void checkClosed() throws SQLException {
        if (this.blobData == FREED_MARKER) {
            throw FbExceptionBuilder.forException(337248295).toFlatSQLException();
        }
    }
}

