/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.version13;

import java.sql.SQLException;
import java.util.ResourceBundle;
import org.firebirdsql.encodings.Encoding;
import org.firebirdsql.gds.ConnectionParameterBuffer;
import org.firebirdsql.gds.DatabaseParameterBuffer;
import org.firebirdsql.gds.ParameterTagMapping;
import org.firebirdsql.gds.ServiceParameterBuffer;
import org.firebirdsql.gds.impl.DatabaseParameterBufferImp;
import org.firebirdsql.gds.impl.ServiceParameterBufferImp;
import org.firebirdsql.gds.ng.AbstractConnection;
import org.firebirdsql.gds.ng.wire.WireConnection;
import org.firebirdsql.gds.ng.wire.WireDatabaseConnection;
import org.firebirdsql.gds.ng.wire.WireServiceConnection;
import org.firebirdsql.gds.ng.wire.auth.ClientAuthBlock;
import org.firebirdsql.gds.ng.wire.version12.V12ParameterConverter;

public class V13ParameterConverter
extends V12ParameterConverter {
    private static final String JAYBIRD_VERSION;

    @Override
    protected DatabaseParameterBuffer createDatabaseParameterBuffer(WireDatabaseConnection connection) {
        Encoding stringEncoding = connection.getEncodingFactory().getEncodingForFirebirdName("UTF8");
        DatabaseParameterBufferImp dpb = new DatabaseParameterBufferImp(DatabaseParameterBufferImp.DpbMetaData.DPB_VERSION_2, stringEncoding);
        dpb.addArgument(77, 1);
        return dpb;
    }

    @Override
    protected ServiceParameterBuffer createServiceParameterBuffer(WireServiceConnection connection) {
        Encoding stringEncoding = connection.getEncodingFactory().getEncodingForFirebirdName("UTF8");
        ServiceParameterBufferImp spb = new ServiceParameterBufferImp(ServiceParameterBufferImp.SpbMetaData.SPB_VERSION_3_ATTACH, stringEncoding);
        spb.addArgument(118, 1);
        return spb;
    }

    @Override
    protected void populateDefaultProperties(WireDatabaseConnection connection, DatabaseParameterBuffer dpb) throws SQLException {
        super.populateDefaultProperties(connection, dpb);
        dpb.addArgument(80, JAYBIRD_VERSION);
    }

    @Override
    protected void populateAuthenticationProperties(AbstractConnection connection, ConnectionParameterBuffer pb) throws SQLException {
        if (!(connection instanceof WireConnection)) {
            throw new IllegalArgumentException("populateAuthenticationProperties should have been called with a WireConnection instance, was " + connection.getClass().getName());
        }
        ClientAuthBlock clientAuthBlock = ((WireConnection)connection).getClientAuthBlock();
        if (clientAuthBlock == null || clientAuthBlock.isAuthComplete()) {
            return;
        }
        Object props = connection.getAttachProperties();
        ParameterTagMapping tagMapping = pb.getTagMapping();
        if (props.getUser() != null) {
            pb.addArgument(tagMapping.getUserNameTag(), props.getUser());
        }
        clientAuthBlock.authFillParametersBlock(pb);
    }

    @Override
    protected void populateDefaultProperties(WireServiceConnection connection, ServiceParameterBuffer spb) throws SQLException {
        super.populateDefaultProperties(connection, spb);
        spb.addArgument(119, JAYBIRD_VERSION);
    }

    static {
        String jaybirdVersion;
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("org.firebirdsql.version");
            jaybirdVersion = resourceBundle.getString("jaybird.version.display");
        }
        catch (Exception ex) {
            jaybirdVersion = "Jaybird (version unknown)";
        }
        JAYBIRD_VERSION = jaybirdVersion;
    }
}

