/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.verb.migrate.migrators;

import java.util.List;
import org.flywaydb.core.ProgressLogger;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.output.MigrateResult;
import org.flywaydb.core.experimental.ExperimentalDatabase;
import org.flywaydb.core.experimental.schemahistory.SchemaHistoryItem;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.nc.callbacks.CallbackManager;
import org.flywaydb.verb.migrate.MigrationExecutionGroup;

public abstract class Migrator {
    private static final Log LOG = LogFactory.getLog(Migrator.class);

    public abstract List<MigrationExecutionGroup> createGroups(MigrationInfo[] var1, Configuration var2, ExperimentalDatabase var3, MigrateResult var4, ParsingContext var5);

    public abstract int doExecutionGroup(Configuration var1, MigrationExecutionGroup var2, ExperimentalDatabase var3, MigrateResult var4, ParsingContext var5, int var6, CallbackManager var7, ProgressLogger var8);

    static void updateSchemaHistoryTable(String tableName, MigrationInfo migrationInfo, int totalTimeMillis, int installedRank, ExperimentalDatabase experimentalDatabase, String installedBy, boolean success) {
        SchemaHistoryItem.SchemaHistoryItemBuilder schemaHistoryItem = SchemaHistoryItem.builder().executionTime(totalTimeMillis).type(migrationInfo.getType().name()).description(migrationInfo.getDescription()).script(migrationInfo.getScript()).installedRank(installedRank).checksum(migrationInfo.getChecksum()).installedBy(installedBy).success(success);
        if (migrationInfo.isVersioned()) {
            schemaHistoryItem.version(migrationInfo.getVersion().getVersion());
        }
        experimentalDatabase.appendSchemaHistoryItem(schemaHistoryItem.build(), tableName);
    }
}

