/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.InternalApi;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.annotation.Nullable;

@InternalApi
public class ThreadFactoryUtil {
    @InternalApi
    public static ThreadFactory createVirtualOrPlatformDaemonThreadFactory(String baseNameFormat, boolean tryVirtualThreads) {
        ThreadFactory virtualThreadFactory;
        ThreadFactory threadFactory = virtualThreadFactory = tryVirtualThreads ? ThreadFactoryUtil.tryCreateVirtualThreadFactory(baseNameFormat) : null;
        if (virtualThreadFactory != null) {
            return virtualThreadFactory;
        }
        return new ThreadFactoryBuilder().setDaemon(true).setNameFormat(baseNameFormat + "-%d").build();
    }

    @InternalApi
    @Nullable
    public static ThreadFactory tryCreateVirtualThreadFactory(String baseNameFormat) {
        try {
            Class<?> threadBuilderClass = Class.forName("java.lang.Thread$Builder");
            Method ofVirtualMethod = Thread.class.getDeclaredMethod("ofVirtual", new Class[0]);
            Object virtualBuilder = ofVirtualMethod.invoke(null, new Object[0]);
            Method nameMethod = threadBuilderClass.getDeclaredMethod("name", String.class, Long.TYPE);
            virtualBuilder = nameMethod.invoke(virtualBuilder, baseNameFormat + "-", 0);
            Method factoryMethod = threadBuilderClass.getDeclaredMethod("factory", new Class[0]);
            return (ThreadFactory)factoryMethod.invoke(virtualBuilder, new Object[0]);
        }
        catch (ClassNotFoundException | NoSuchMethodException ignore) {
            return null;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            if (e.getCause() instanceof UnsupportedOperationException) {
                return null;
            }
            throw new RuntimeException(e);
        }
    }

    @InternalApi
    @Nullable
    public static ExecutorService tryCreateVirtualThreadPerTaskExecutor(String baseNameFormat) {
        ThreadFactory factory = ThreadFactoryUtil.tryCreateVirtualThreadFactory(baseNameFormat);
        if (factory != null) {
            try {
                Method newThreadPerTaskExecutorMethod = Executors.class.getDeclaredMethod("newThreadPerTaskExecutor", ThreadFactory.class);
                return (ExecutorService)newThreadPerTaskExecutorMethod.invoke(null, factory);
            }
            catch (NoSuchMethodException ignore) {
                return null;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                if (e.getCause() instanceof UnsupportedOperationException) {
                    return null;
                }
                throw new RuntimeException(e);
            }
        }
        return null;
    }
}

