/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.rpc.ServerStream;
import com.google.cloud.Timestamp;
import com.google.cloud.Tuple;
import com.google.cloud.grpc.GrpcTransportOptions;
import com.google.cloud.spanner.AbstractReadContext;
import com.google.cloud.spanner.AsyncResultSet;
import com.google.cloud.spanner.AsyncResultSetImpl;
import com.google.cloud.spanner.AsyncRunner;
import com.google.cloud.spanner.AsyncTransactionManager;
import com.google.cloud.spanner.AsyncTransactionManagerImpl;
import com.google.cloud.spanner.Clock;
import com.google.cloud.spanner.CommitResponse;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseNotFoundException;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.ForwardingAsyncResultSet;
import com.google.cloud.spanner.ForwardingResultSet;
import com.google.cloud.spanner.IScope;
import com.google.cloud.spanner.ISpan;
import com.google.cloud.spanner.InstanceNotFoundException;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.MetricRegistryConstants;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.MutationGroup;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.RetryOnDifferentGrpcChannelErrorHandler;
import com.google.cloud.spanner.RetryOnDifferentGrpcChannelException;
import com.google.cloud.spanner.Session;
import com.google.cloud.spanner.SessionClient;
import com.google.cloud.spanner.SessionImpl;
import com.google.cloud.spanner.SessionNotFoundException;
import com.google.cloud.spanner.SessionPoolAsyncTransactionManager;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerImpl;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.TraceWrapper;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionManager;
import com.google.cloud.spanner.TransactionRunner;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Ticker;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ForwardingListenableFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.protobuf.Empty;
import com.google.spanner.v1.BatchWriteResponse;
import com.google.spanner.v1.ResultSetStats;
import io.opencensus.metrics.DerivedLongCumulative;
import io.opencensus.metrics.DerivedLongGauge;
import io.opencensus.metrics.LabelValue;
import io.opencensus.metrics.MetricOptions;
import io.opencensus.metrics.MetricRegistry;
import io.opencensus.metrics.Metrics;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.metrics.Meter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.threeten.bp.Duration;
import org.threeten.bp.Instant;
import org.threeten.bp.temporal.Temporal;
import org.threeten.bp.temporal.TemporalAmount;

class SessionPool {
    private static final Logger logger = Logger.getLogger(SessionPool.class.getName());
    private final TraceWrapper tracer;
    static final String WAIT_FOR_SESSION = "SessionPool.WaitForSession";
    @VisibleForTesting
    static final Statement DETERMINE_DIALECT_STATEMENT = Statement.newBuilder("SELECT 'POSTGRESQL' AS DIALECT\nFROM INFORMATION_SCHEMA.SCHEMATA\nWHERE SCHEMA_NAME='information_schema'\nUNION ALL\nSELECT 'GOOGLE_STANDARD_SQL' AS DIALECT\nFROM INFORMATION_SCHEMA.SCHEMATA\nWHERE SCHEMA_NAME='INFORMATION_SCHEMA' AND CATALOG_NAME=''").build();
    private final SessionPoolOptions options;
    private final SettableFuture<Dialect> dialect = SettableFuture.create();
    private final String databaseRole;
    private final SessionClient sessionClient;
    private final int numChannels;
    private final ScheduledExecutorService executor;
    private final GrpcTransportOptions.ExecutorFactory<ScheduledExecutorService> executorFactory;
    final PoolMaintainer poolMaintainer;
    private final Clock clock;
    private final Position initialReleasePosition;
    private final Object lock = new Object();
    private final Random random = new Random();
    @GuardedBy(value="lock")
    private boolean detectDialectStarted;
    @GuardedBy(value="lock")
    private int pendingClosure;
    @GuardedBy(value="lock")
    private SettableFuture<Void> closureFuture;
    @GuardedBy(value="lock")
    private SpannerImpl.ClosedException closedException;
    @GuardedBy(value="lock")
    private SpannerException.ResourceNotFoundException resourceNotFoundException;
    @GuardedBy(value="lock")
    private final LinkedList<PooledSession> sessions = new LinkedList();
    @GuardedBy(value="lock")
    private final Queue<WaiterFuture> waiters = new LinkedList<WaiterFuture>();
    @GuardedBy(value="lock")
    private int numSessionsBeingCreated = 0;
    @GuardedBy(value="lock")
    private int numSessionsInUse = 0;
    @GuardedBy(value="lock")
    private int maxSessionsInUse = 0;
    @GuardedBy(value="lock")
    private long numSessionsAcquired = 0L;
    @GuardedBy(value="lock")
    private long numSessionsReleased = 0L;
    @GuardedBy(value="lock")
    private long numIdleSessionsRemoved = 0L;
    @GuardedBy(value="lock")
    private long transactionsPerSecond = 0L;
    @GuardedBy(value="lock")
    private long numLeakedSessionsRemoved = 0L;
    private final AtomicLong numWaiterTimeouts = new AtomicLong();
    @GuardedBy(value="lock")
    private final Set<PooledSession> allSessions = new HashSet<PooledSession>();
    @GuardedBy(value="lock")
    @VisibleForTesting
    final Set<PooledSessionFuture> checkedOutSessions = new HashSet<PooledSessionFuture>();
    @GuardedBy(value="lock")
    private final Set<PooledSessionFuture> markedCheckedOutSessions = new HashSet<PooledSessionFuture>();
    private final SessionClient.SessionConsumer sessionConsumer = new SessionConsumerImpl();
    @VisibleForTesting
    Function<PooledSession, Void> idleSessionRemovedListener;
    @VisibleForTesting
    Function<PooledSession, Void> longRunningSessionRemovedListener;
    private final CountDownLatch waitOnMinSessionsLatch;
    private final PooledSessionReplacementHandler pooledSessionReplacementHandler = new PooledSessionReplacementHandler();
    private static final Object DENY_LISTED = new Object();
    private final Cache<Integer, Object> denyListedChannels;

    void maybeWaitOnMinSessions() {
        long timeoutNanos = this.options.getWaitForMinSessions().toNanos();
        if (timeoutNanos <= 0L) {
            return;
        }
        try {
            if (!this.waitOnMinSessionsLatch.await(timeoutNanos, TimeUnit.NANOSECONDS)) {
                long timeoutMillis = this.options.getWaitForMinSessions().toMillis();
                throw SpannerExceptionFactory.newSpannerException(ErrorCode.DEADLINE_EXCEEDED, "Timed out after waiting " + timeoutMillis + "ms for session pool creation");
            }
        }
        catch (InterruptedException e) {
            throw SpannerExceptionFactory.propagateInterrupt(e);
        }
    }

    private PooledSessionFuture createPooledSessionFuture(ListenableFuture<PooledSession> future, ISpan span) {
        return new PooledSessionFuture(future, span);
    }

    static SessionPool createPool(SpannerOptions spannerOptions, SessionClient sessionClient, TraceWrapper tracer, List<LabelValue> labelValues, Attributes attributes, AtomicLong numMultiplexedSessionsAcquired, AtomicLong numMultiplexedSessionsReleased) {
        SessionPoolOptions sessionPoolOptions = spannerOptions.getSessionPoolOptions();
        Clock poolMaintainerClock = sessionPoolOptions.getPoolMaintainerClock();
        return SessionPool.createPool(sessionPoolOptions, spannerOptions.getDatabaseRole(), (GrpcTransportOptions.ExecutorFactory<ScheduledExecutorService>)((GrpcTransportOptions)spannerOptions.getTransportOptions()).getExecutorFactory(), sessionClient, poolMaintainerClock == null ? new Clock() : poolMaintainerClock, Position.RANDOM, Metrics.getMetricRegistry(), tracer, labelValues, spannerOptions.getOpenTelemetry(), attributes, numMultiplexedSessionsAcquired, numMultiplexedSessionsReleased);
    }

    static SessionPool createPool(SessionPoolOptions poolOptions, GrpcTransportOptions.ExecutorFactory<ScheduledExecutorService> executorFactory, SessionClient sessionClient, TraceWrapper tracer, OpenTelemetry openTelemetry) {
        return SessionPool.createPool(poolOptions, executorFactory, sessionClient, new Clock(), Position.RANDOM, tracer, openTelemetry);
    }

    static SessionPool createPool(SessionPoolOptions poolOptions, GrpcTransportOptions.ExecutorFactory<ScheduledExecutorService> executorFactory, SessionClient sessionClient, Clock clock, Position initialReleasePosition, TraceWrapper tracer, OpenTelemetry openTelemetry) {
        return SessionPool.createPool(poolOptions, null, executorFactory, sessionClient, clock, initialReleasePosition, Metrics.getMetricRegistry(), tracer, MetricRegistryConstants.SPANNER_DEFAULT_LABEL_VALUES, openTelemetry, null, new AtomicLong(), new AtomicLong());
    }

    static SessionPool createPool(SessionPoolOptions poolOptions, String databaseRole, GrpcTransportOptions.ExecutorFactory<ScheduledExecutorService> executorFactory, SessionClient sessionClient, Clock clock, Position initialReleasePosition, MetricRegistry metricRegistry, TraceWrapper tracer, List<LabelValue> labelValues, OpenTelemetry openTelemetry, Attributes attributes, AtomicLong numMultiplexedSessionsAcquired, AtomicLong numMultiplexedSessionsReleased) {
        SessionPool pool = new SessionPool(poolOptions, databaseRole, executorFactory, (ScheduledExecutorService)executorFactory.get(), sessionClient, clock, initialReleasePosition, metricRegistry, tracer, labelValues, openTelemetry, attributes, numMultiplexedSessionsAcquired, numMultiplexedSessionsReleased);
        pool.initPool();
        return pool;
    }

    private SessionPool(SessionPoolOptions options, String databaseRole, GrpcTransportOptions.ExecutorFactory<ScheduledExecutorService> executorFactory, ScheduledExecutorService executor, SessionClient sessionClient, final Clock clock, Position initialReleasePosition, MetricRegistry metricRegistry, TraceWrapper tracer, List<LabelValue> labelValues, OpenTelemetry openTelemetry, Attributes attributes, AtomicLong numMultiplexedSessionsAcquired, AtomicLong numMultiplexedSessionsReleased) {
        this.options = options;
        this.databaseRole = databaseRole;
        this.executorFactory = executorFactory;
        this.executor = executor;
        this.sessionClient = sessionClient;
        this.numChannels = ((SpannerOptions)sessionClient.getSpanner().getOptions()).getNumChannels();
        this.clock = clock;
        this.initialReleasePosition = initialReleasePosition;
        this.poolMaintainer = new PoolMaintainer();
        this.tracer = tracer;
        this.initOpenCensusMetricsCollection(metricRegistry, labelValues, numMultiplexedSessionsAcquired, numMultiplexedSessionsReleased);
        this.initOpenTelemetryMetricsCollection(openTelemetry, attributes, numMultiplexedSessionsAcquired, numMultiplexedSessionsReleased);
        this.waitOnMinSessionsLatch = options.getMinSessions() > 0 ? new CountDownLatch(1) : new CountDownLatch(0);
        this.denyListedChannels = RetryOnDifferentGrpcChannelErrorHandler.isEnabled() ? CacheBuilder.newBuilder().expireAfterWrite(java.time.Duration.ofMinutes(1L)).maximumSize((long)this.numChannels).concurrencyLevel(1).ticker(new Ticker(){

            public long read() {
                return TimeUnit.NANOSECONDS.convert(clock.instant().toEpochMilli(), TimeUnit.MILLISECONDS);
            }
        }).build() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Dialect getDialect() {
        boolean mustDetectDialect = false;
        Object object = this.lock;
        synchronized (object) {
            if (!this.detectDialectStarted) {
                mustDetectDialect = true;
                this.detectDialectStarted = true;
            }
        }
        if (mustDetectDialect) {
            try (PooledSessionFuture session = this.getSession();){
                this.dialect.set((Object)session.get().determineDialect());
            }
        }
        try {
            return (Dialect)((Object)this.dialect.get(60L, TimeUnit.SECONDS));
        }
        catch (ExecutionException executionException) {
            throw SpannerExceptionFactory.asSpannerException(executionException);
        }
        catch (InterruptedException interruptedException) {
            throw SpannerExceptionFactory.propagateInterrupt(interruptedException);
        }
        catch (TimeoutException timeoutException) {
            throw SpannerExceptionFactory.propagateTimeout(timeoutException);
        }
    }

    PooledSessionReplacementHandler getPooledSessionReplacementHandler() {
        return this.pooledSessionReplacementHandler;
    }

    @Nullable
    public String getDatabaseRole() {
        return this.databaseRole;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int getNumberOfSessionsInUse() {
        Object object = this.lock;
        synchronized (object) {
            return this.numSessionsInUse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int getMaxSessionsInUse() {
        Object object = this.lock;
        synchronized (object) {
            return this.maxSessionsInUse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    double getRatioOfSessionsInUse() {
        Object object = this.lock;
        synchronized (object) {
            int maxSessions = this.options.getMaxSessions();
            if (maxSessions == 0) {
                return 0.0;
            }
            return (double)this.numSessionsInUse / (double)maxSessions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeFromPool(PooledSession session) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed()) {
                this.decrementPendingClosures(1);
                return false;
            }
            session.markClosing();
            this.allSessions.remove(session);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long numIdleSessionsRemoved() {
        Object object = this.lock;
        synchronized (object) {
            return this.numIdleSessionsRemoved;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    long numLeakedSessionsRemoved() {
        Object object = this.lock;
        synchronized (object) {
            return this.numLeakedSessionsRemoved;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int getNumberOfSessionsInPool() {
        Object object = this.lock;
        synchronized (object) {
            return this.sessions.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int getNumberOfSessionsBeingCreated() {
        Object object = this.lock;
        synchronized (object) {
            return this.numSessionsBeingCreated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int getTotalSessionsPlusNumSessionsBeingCreated() {
        Object object = this.lock;
        synchronized (object) {
            return this.numSessionsBeingCreated + this.allSessions.size();
        }
    }

    @VisibleForTesting
    long getNumWaiterTimeouts() {
        return this.numWaiterTimeouts.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initPool() {
        Object object = this.lock;
        synchronized (object) {
            this.poolMaintainer.init();
            if (this.options.getMinSessions() > 0) {
                this.createSessions(this.options.getMinSessions(), true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isClosed() {
        Object object = this.lock;
        synchronized (object) {
            return this.closureFuture != null;
        }
    }

    private void handleException(SpannerException e, Tuple<PooledSession, Integer> session) {
        if (this.isSessionNotFound(e)) {
            this.invalidateSession((PooledSession)session.x());
        } else {
            this.releaseSession(session);
        }
    }

    private boolean isSessionNotFound(SpannerException e) {
        return e.getErrorCode() == ErrorCode.NOT_FOUND && e.getMessage().contains("Session not found");
    }

    private boolean isDatabaseOrInstanceNotFound(SpannerException e) {
        return e instanceof DatabaseNotFoundException || e instanceof InstanceNotFoundException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateSession(PooledSession session) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed()) {
                this.decrementPendingClosures(1);
                return;
            }
            this.allSessions.remove(session);
            this.createSessions(this.getAllowedCreateSessions(1), false);
        }
    }

    private Tuple<PooledSession, Integer> findSessionToKeepAlive(Queue<PooledSession> queue, Instant keepAliveThreshold, int numAlreadyChecked) {
        int numChecked = 0;
        Iterator iterator = queue.iterator();
        while (iterator.hasNext() && numChecked + numAlreadyChecked < this.options.getMinSessions() + this.options.getMaxIdleSessions() - this.numSessionsInUse) {
            PooledSession session = (PooledSession)iterator.next();
            if (session.delegate.getLastUseTime() != null && session.delegate.getLastUseTime().isBefore(keepAliveThreshold)) {
                iterator.remove();
                return Tuple.of((Object)session, (Object)numChecked);
            }
            ++numChecked;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isValid() {
        Object object = this.lock;
        synchronized (object) {
            return this.closureFuture == null && this.resourceNotFoundException == null;
        }
    }

    PooledSessionFutureWrapper getMultiplexedSessionWithFallback() throws SpannerException {
        return new PooledSessionFutureWrapper(this.getSession());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PooledSessionFuture getSession() throws SpannerException {
        ISpan span = this.tracer.getCurrentSpan();
        span.addAnnotation("Acquiring session");
        WaiterFuture waiter = null;
        PooledSession sess = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.closureFuture != null) {
                span.addAnnotation("Pool has been closed");
                throw new IllegalStateException("Pool has been closed", this.closedException);
            }
            if (this.resourceNotFoundException != null) {
                span.addAnnotation("Database has been deleted");
                throw SpannerExceptionFactory.newSpannerException(ErrorCode.NOT_FOUND, String.format("The session pool has been invalidated because a previous RPC returned 'Database not found': %s", this.resourceNotFoundException.getMessage()), (Throwable)((Object)this.resourceNotFoundException));
            }
            if (this.denyListedChannels != null && this.denyListedChannels.size() > 0L && this.denyListedChannels.size() < (long)this.numChannels) {
                for (PooledSession session : this.sessions) {
                    if (this.denyListedChannels.getIfPresent((Object)session.getChannel()) == null) {
                        this.sessions.remove(session);
                        sess = session;
                        break;
                    }
                    if (this.denyListedChannels.size() != 0L) continue;
                    break;
                }
            }
            if (sess == null) {
                sess = this.sessions.poll();
            }
            if (sess == null) {
                span.addAnnotation("No session available");
                this.maybeCreateSession();
                waiter = new WaiterFuture();
                this.waiters.add(waiter);
            } else {
                span.addAnnotation("Acquired session");
            }
            return this.checkoutSession(span, sess, waiter);
        }
    }

    private PooledSessionFuture checkoutSession(ISpan span, PooledSession readySession, WaiterFuture waiter) {
        Object sessionFuture;
        if (waiter != null) {
            logger.log(Level.FINE, "No session available in the pool. Blocking for one to become available/created");
            span.addAnnotation("Waiting for a session to come available");
            sessionFuture = waiter;
        } else {
            SettableFuture fut = SettableFuture.create();
            fut.set((Object)readySession);
            sessionFuture = fut;
        }
        PooledSessionFuture res = this.createPooledSessionFuture((ListenableFuture<PooledSession>)sessionFuture, span);
        res.markCheckedOut();
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementNumSessionsInUse() {
        Object object = this.lock;
        synchronized (object) {
            if (this.maxSessionsInUse < ++this.numSessionsInUse) {
                this.maxSessionsInUse = this.numSessionsInUse;
            }
            ++this.numSessionsAcquired;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeCreateSession() {
        ISpan span = this.tracer.getCurrentSpan();
        boolean throwResourceExhaustedException = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.numWaiters() >= this.numSessionsBeingCreated) {
                if (this.canCreateSession()) {
                    span.addAnnotation("Creating sessions");
                    this.createSessions(this.getAllowedCreateSessions(this.options.getIncStep()), false);
                } else if (this.options.isFailIfPoolExhausted()) {
                    throwResourceExhaustedException = true;
                }
            }
        }
        if (!throwResourceExhaustedException) {
            return;
        }
        span.addAnnotation("Pool exhausted. Failing");
        String message = "No session available in the pool. Maximum number of sessions in the pool can be overridden by invoking SessionPoolOptions#Builder#setMaxSessions. Client can be made to block rather than fail by setting SessionPoolOptions#Builder#setBlockIfPoolExhausted.\n" + this.createCheckedOutSessionsStackTraces();
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.RESOURCE_EXHAUSTED, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuilder createCheckedOutSessionsStackTraces() {
        ArrayList<PooledSessionFuture> currentlyCheckedOutSessions;
        Object object = this.lock;
        synchronized (object) {
            currentlyCheckedOutSessions = new ArrayList<PooledSessionFuture>(this.markedCheckedOutSessions);
        }
        StringBuilder stackTraces = new StringBuilder("There are currently " + currentlyCheckedOutSessions.size() + " sessions checked out:\n\n");
        if (this.options.isTrackStackTraceOfSessionCheckout()) {
            for (PooledSessionFuture session : currentlyCheckedOutSessions) {
                if (session.leakedException == null) continue;
                StringWriter writer = new StringWriter();
                PrintWriter printWriter = new PrintWriter(writer);
                session.leakedException.printStackTrace(printWriter);
                stackTraces.append(writer).append("\n\n");
            }
        }
        return stackTraces;
    }

    private void releaseSession(Tuple<PooledSession, Integer> sessionWithPosition) {
        this.releaseSession((PooledSession)sessionWithPosition.x(), false, (Integer)sessionWithPosition.y());
    }

    private void releaseSession(PooledSession session, boolean isNewSession) {
        this.releaseSession(session, isNewSession, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseSession(PooledSession session, boolean isNewSession, @Nullable Integer position) {
        Preconditions.checkNotNull((Object)session);
        Object object = this.lock;
        synchronized (object) {
            if (this.closureFuture != null) {
                return;
            }
            if (this.waiters.isEmpty()) {
                if (session.releaseToPosition != Position.RANDOM && this.shouldRandomize()) {
                    session.releaseToPosition = Position.RANDOM;
                } else if (session.releaseToPosition == Position.FIRST && this.isUnbalanced(session)) {
                    session.releaseToPosition = Position.RANDOM;
                } else if (session.releaseToPosition == Position.RANDOM && !isNewSession && this.checkedOutSessions.size() <= 2) {
                    session.releaseToPosition = this.options.getReleaseToPosition();
                }
                if (position != null) {
                    int actualPosition = Math.min(position, this.sessions.size());
                    this.sessions.add(actualPosition, session);
                } else if (session.releaseToPosition == Position.RANDOM && !this.sessions.isEmpty()) {
                    session.releaseToPosition = this.options.getReleaseToPosition();
                    int pos = this.random.nextInt(this.sessions.size() + 1);
                    this.sessions.add(pos, session);
                } else if (session.releaseToPosition == Position.LAST) {
                    this.sessions.addLast(session);
                } else {
                    this.sessions.addFirst(session);
                }
                session.releaseToPosition = this.options.getReleaseToPosition();
            } else {
                this.waiters.poll().put(session);
            }
        }
    }

    @VisibleForTesting
    boolean shouldRandomize() {
        return this.options.getRandomizePositionQPSThreshold() > 0L && this.transactionsPerSecond >= this.options.getRandomizePositionQPSThreshold() && this.numSessionsInUse >= this.numChannels;
    }

    private boolean isUnbalanced(PooledSession session) {
        int channel = session.getChannel();
        int numChannels = ((SpannerOptions)this.sessionClient.getSpanner().getOptions()).getNumChannels();
        return SessionPool.isUnbalanced(channel, this.sessions, this.checkedOutSessions, numChannels);
    }

    @VisibleForTesting
    static boolean isUnbalanced(int channelOfSessionBeingAdded, List<PooledSession> sessions, Set<PooledSessionFuture> checkedOutSessions, int numChannels) {
        if (sessions.isEmpty() || checkedOutSessions.size() <= 2) {
            return false;
        }
        if (numChannels == 1) {
            return false;
        }
        int maxSessionsAtHeadOfPool = Math.min(numChannels, 3);
        int count = 0;
        for (int i = 0; i < Math.min(numChannels, sessions.size()); ++i) {
            PooledSession otherSession = sessions.get(i);
            if (channelOfSessionBeingAdded != otherSession.getChannel() || ++count < maxSessionsAtHeadOfPool) continue;
            return true;
        }
        count = 0;
        int checkedOutThreshold = Math.max(2, 2 * checkedOutSessions.size() / numChannels);
        for (PooledSessionFuture otherSession : checkedOutSessions) {
            if (!otherSession.isDone() || channelOfSessionBeingAdded != otherSession.get().getChannel() || ++count <= checkedOutThreshold) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCreateSessionsFailure(SpannerException e, int count) {
        Object object = this.lock;
        synchronized (object) {
            for (int i = 0; i < count && !this.waiters.isEmpty(); ++i) {
                this.waiters.poll().put(e);
            }
            if (!this.dialect.isDone()) {
                this.dialect.setException((Throwable)((Object)e));
            }
            if (this.isDatabaseOrInstanceNotFound(e)) {
                this.setResourceNotFoundException((SpannerException.ResourceNotFoundException)e);
                this.poolMaintainer.close();
            }
        }
    }

    void setResourceNotFoundException(SpannerException.ResourceNotFoundException e) {
        this.resourceNotFoundException = (SpannerException.ResourceNotFoundException)((Object)MoreObjects.firstNonNull((Object)((Object)this.resourceNotFoundException), (Object)((Object)e)));
    }

    private void decrementPendingClosures(int count) {
        this.pendingClosure -= count;
        if (this.pendingClosure == 0) {
            this.closureFuture.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ListenableFuture<Void> closeAsync(SpannerImpl.ClosedException closedException) {
        SettableFuture<Void> retFuture = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.closureFuture != null) {
                throw new IllegalStateException("Close has already been invoked", this.closedException);
            }
            this.closedException = closedException;
            WaiterFuture waiter = this.waiters.poll();
            while (waiter != null) {
                waiter.put(SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Client has been closed"));
                waiter = this.waiters.poll();
            }
            this.closureFuture = SettableFuture.create();
            retFuture = this.closureFuture;
            this.pendingClosure = this.totalSessions() + this.numSessionsBeingCreated;
            if (!this.poolMaintainer.isClosed()) {
                ++this.pendingClosure;
                this.poolMaintainer.close();
            }
            this.sessions.clear();
            for (Session session : this.checkedOutSessions) {
                if (((PooledSessionFuture)session).leakedException != null) {
                    if (this.options.isFailOnSessionLeak()) {
                        throw ((PooledSessionFuture)session).leakedException;
                    }
                    logger.log(Level.WARNING, "Leaked session", ((PooledSessionFuture)session).leakedException);
                    continue;
                }
                String message = "Leaked session. Call SessionOptions.Builder#setTrackStackTraceOfSessionCheckout(true) to start tracking the call stack trace of the thread that checked out the session.";
                if (this.options.isFailOnSessionLeak()) {
                    throw new LeakedSessionException(message);
                }
                logger.log(Level.WARNING, message);
            }
            for (Session session : ImmutableList.copyOf(this.allSessions)) {
                if (((PooledSession)session).state == SessionState.CLOSING) continue;
                this.closeSessionAsync((PooledSession)session);
            }
            if (this.pendingClosure == 0) {
                this.closureFuture.set(null);
            }
        }
        retFuture.addListener(() -> this.executorFactory.release((ExecutorService)this.executor), MoreExecutors.directExecutor());
        return retFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int numWaiters() {
        Object object = this.lock;
        synchronized (object) {
            return this.waiters.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int totalSessions() {
        Object object = this.lock;
        synchronized (object) {
            return this.allSessions.size();
        }
    }

    private ApiFuture<Empty> closeSessionAsync(PooledSession sess) {
        ApiFuture<Empty> res = sess.delegate.asyncClose();
        res.addListener(() -> {
            Object object = this.lock;
            synchronized (object) {
                this.allSessions.remove(sess);
                if (this.isClosed()) {
                    this.decrementPendingClosures(1);
                    return;
                }
                if (this.numWaiters() > this.numSessionsBeingCreated) {
                    this.createSessions(this.getAllowedCreateSessions(this.numWaiters() - this.numSessionsBeingCreated), false);
                }
            }
        }, MoreExecutors.directExecutor());
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getAllowedCreateSessions(int wantedSessions) {
        Object object = this.lock;
        synchronized (object) {
            return Math.min(wantedSessions, this.options.getMaxSessions() - (this.totalSessions() + this.numSessionsBeingCreated));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canCreateSession() {
        Object object = this.lock;
        synchronized (object) {
            return this.totalSessions() + this.numSessionsBeingCreated < this.options.getMaxSessions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSessions(int sessionCount, boolean distributeOverChannels) {
        logger.log(Level.FINE, String.format("Creating %d sessions", sessionCount));
        Object object = this.lock;
        synchronized (object) {
            this.numSessionsBeingCreated += sessionCount;
            try {
                this.sessionClient.asyncBatchCreateSessions(sessionCount, distributeOverChannels, this.sessionConsumer);
            }
            catch (Throwable t) {
                this.numSessionsBeingCreated -= sessionCount;
                if (this.isClosed()) {
                    this.decrementPendingClosures(sessionCount);
                }
                this.handleCreateSessionsFailure(SpannerExceptionFactory.newSpannerException(t), sessionCount);
            }
        }
    }

    private void initOpenCensusMetricsCollection(MetricRegistry metricRegistry, List<LabelValue> labelValues, AtomicLong numMultiplexedSessionsAcquired, AtomicLong numMultiplexedSessionsReleased) {
        if (!SpannerOptions.isEnabledOpenCensusMetrics()) {
            return;
        }
        DerivedLongGauge maxInUseSessionsMetric = metricRegistry.addDerivedLongGauge("cloud.google.com/java/spanner/max_in_use_sessions", MetricOptions.builder().setDescription("The maximum number of sessions in use during the last 10 minute interval.").setUnit("1").setLabelKeys(MetricRegistryConstants.SPANNER_LABEL_KEYS).build());
        DerivedLongGauge maxAllowedSessionsMetric = metricRegistry.addDerivedLongGauge("cloud.google.com/java/spanner/max_allowed_sessions", MetricOptions.builder().setDescription("The maximum number of sessions allowed. Configurable by the user.").setUnit("1").setLabelKeys(MetricRegistryConstants.SPANNER_LABEL_KEYS).build());
        DerivedLongCumulative sessionsTimeouts = metricRegistry.addDerivedLongCumulative("cloud.google.com/java/spanner/get_session_timeouts", MetricOptions.builder().setDescription("The number of get sessions timeouts due to pool exhaustion").setUnit("1").setLabelKeys(MetricRegistryConstants.SPANNER_LABEL_KEYS).build());
        DerivedLongCumulative numAcquiredSessionsMetric = metricRegistry.addDerivedLongCumulative("cloud.google.com/java/spanner/num_acquired_sessions", MetricOptions.builder().setDescription("The number of sessions acquired from the session pool.").setUnit("1").setLabelKeys(MetricRegistryConstants.SPANNER_LABEL_KEYS_WITH_MULTIPLEXED_SESSIONS).build());
        DerivedLongCumulative numReleasedSessionsMetric = metricRegistry.addDerivedLongCumulative("cloud.google.com/java/spanner/num_released_sessions", MetricOptions.builder().setDescription("The number of sessions released by the user and pool maintainer.").setUnit("1").setLabelKeys(MetricRegistryConstants.SPANNER_LABEL_KEYS_WITH_MULTIPLEXED_SESSIONS).build());
        DerivedLongGauge numSessionsInPoolMetric = metricRegistry.addDerivedLongGauge("cloud.google.com/java/spanner/num_sessions_in_pool", MetricOptions.builder().setDescription("The number of sessions in the pool.").setUnit("1").setLabelKeys(MetricRegistryConstants.SPANNER_LABEL_KEYS_WITH_TYPE).build());
        maxInUseSessionsMetric.removeTimeSeries(labelValues);
        maxInUseSessionsMetric.createTimeSeries(labelValues, (Object)this, sessionPool -> sessionPool.maxSessionsInUse);
        maxAllowedSessionsMetric.removeTimeSeries(labelValues);
        maxAllowedSessionsMetric.createTimeSeries(labelValues, (Object)this.options, SessionPoolOptions::getMaxSessions);
        sessionsTimeouts.removeTimeSeries(labelValues);
        sessionsTimeouts.createTimeSeries(labelValues, (Object)this, SessionPool::getNumWaiterTimeouts);
        ArrayList<LabelValue> labelValuesWithRegularSessions = new ArrayList<LabelValue>(labelValues);
        ArrayList<LabelValue> labelValuesWithMultiplexedSessions = new ArrayList<LabelValue>(labelValues);
        labelValuesWithMultiplexedSessions.add(LabelValue.create((String)"true"));
        labelValuesWithRegularSessions.add(LabelValue.create((String)"false"));
        numAcquiredSessionsMetric.removeTimeSeries(labelValuesWithRegularSessions);
        numAcquiredSessionsMetric.createTimeSeries(labelValuesWithRegularSessions, (Object)this, sessionPool -> sessionPool.numSessionsAcquired);
        numAcquiredSessionsMetric.removeTimeSeries(labelValuesWithMultiplexedSessions);
        numAcquiredSessionsMetric.createTimeSeries(labelValuesWithMultiplexedSessions, (Object)this, unused -> numMultiplexedSessionsAcquired.get());
        numReleasedSessionsMetric.removeTimeSeries(labelValuesWithRegularSessions);
        numReleasedSessionsMetric.createTimeSeries(labelValuesWithRegularSessions, (Object)this, sessionPool -> sessionPool.numSessionsReleased);
        numReleasedSessionsMetric.removeTimeSeries(labelValuesWithMultiplexedSessions);
        numReleasedSessionsMetric.createTimeSeries(labelValuesWithMultiplexedSessions, (Object)this, unused -> numMultiplexedSessionsReleased.get());
        ArrayList<LabelValue> labelValuesWithBeingPreparedType = new ArrayList<LabelValue>(labelValues);
        labelValuesWithBeingPreparedType.add(MetricRegistryConstants.NUM_SESSIONS_BEING_PREPARED);
        numSessionsInPoolMetric.removeTimeSeries(labelValuesWithBeingPreparedType);
        numSessionsInPoolMetric.createTimeSeries(labelValuesWithBeingPreparedType, (Object)this, ignored -> 0L);
        ArrayList<LabelValue> labelValuesWithInUseType = new ArrayList<LabelValue>(labelValues);
        labelValuesWithInUseType.add(MetricRegistryConstants.NUM_IN_USE_SESSIONS);
        numSessionsInPoolMetric.removeTimeSeries(labelValuesWithInUseType);
        numSessionsInPoolMetric.createTimeSeries(labelValuesWithInUseType, (Object)this, sessionPool -> sessionPool.numSessionsInUse);
        ArrayList<LabelValue> labelValuesWithReadType = new ArrayList<LabelValue>(labelValues);
        labelValuesWithReadType.add(MetricRegistryConstants.NUM_READ_SESSIONS);
        numSessionsInPoolMetric.removeTimeSeries(labelValuesWithReadType);
        numSessionsInPoolMetric.createTimeSeries(labelValuesWithReadType, (Object)this, sessionPool -> sessionPool.sessions.size());
        ArrayList<LabelValue> labelValuesWithWriteType = new ArrayList<LabelValue>(labelValues);
        labelValuesWithWriteType.add(MetricRegistryConstants.NUM_WRITE_SESSIONS);
        numSessionsInPoolMetric.removeTimeSeries(labelValuesWithWriteType);
        numSessionsInPoolMetric.createTimeSeries(labelValuesWithWriteType, (Object)this, ignored -> 0L);
    }

    private void initOpenTelemetryMetricsCollection(OpenTelemetry openTelemetry, Attributes attributes, AtomicLong numMultiplexedSessionsAcquired, AtomicLong numMultiplexedSessionsReleased) {
        if (openTelemetry == null || !SpannerOptions.isEnabledOpenTelemetryMetrics()) {
            return;
        }
        Meter meter = openTelemetry.getMeter("cloud.google.com/java");
        meter.gaugeBuilder("spanner/max_allowed_sessions").setDescription("The maximum number of sessions allowed. Configurable by the user.").setUnit("1").buildWithCallback(measurement -> measurement.record((double)this.options.getMaxSessions(), attributes));
        meter.gaugeBuilder("spanner/max_in_use_sessions").setDescription("The maximum number of sessions in use during the last 10 minute interval.").setUnit("1").buildWithCallback(measurement -> measurement.record((double)this.maxSessionsInUse, attributes));
        AttributesBuilder attributesBuilder = attributes != null ? attributes.toBuilder() : Attributes.builder();
        Attributes attributesInUseSessions = attributesBuilder.put("session_type", "spanner/num_in_use_sessions").build();
        Attributes attributesAvailableSessions = attributesBuilder.put("session_type", "spanner/num_available_sessions").build();
        meter.upDownCounterBuilder("spanner/num_sessions_in_pool").setDescription("The number of sessions in the pool.").setUnit("1").buildWithCallback(measurement -> {
            measurement.record((long)this.numSessionsInUse, attributesInUseSessions);
            measurement.record((long)this.sessions.size(), attributesAvailableSessions);
        });
        AttributesBuilder attributesBuilderIsMultiplexed = attributes != null ? attributes.toBuilder() : Attributes.builder();
        Attributes attributesRegularSession = attributesBuilderIsMultiplexed.put("is_multiplexed", false).build();
        Attributes attributesMultiplexedSession = attributesBuilderIsMultiplexed.put("is_multiplexed", true).build();
        meter.counterBuilder("spanner/get_session_timeouts").setDescription("The number of get sessions timeouts due to pool exhaustion").setUnit("1").buildWithCallback(measurement -> measurement.record(this.getNumWaiterTimeouts(), attributes));
        meter.counterBuilder("spanner/num_acquired_sessions").setDescription("The number of sessions acquired from the session pool.").setUnit("1").buildWithCallback(measurement -> {
            measurement.record(this.numSessionsAcquired, attributesRegularSession);
            measurement.record(numMultiplexedSessionsAcquired.get(), attributesMultiplexedSession);
        });
        meter.counterBuilder("spanner/num_released_sessions").setDescription("The number of sessions released by the user and pool maintainer.").setUnit("1").buildWithCallback(measurement -> {
            measurement.record(this.numSessionsReleased, attributesRegularSession);
            measurement.record(numMultiplexedSessionsReleased.get(), attributesMultiplexedSession);
        });
    }

    static /* synthetic */ Position access$3100(SessionPool x0) {
        return x0.initialReleasePosition;
    }

    class PooledSession
    implements CachedSession {
        @VisibleForTesting
        final SessionImpl delegate;
        private volatile SpannerException lastException;
        private volatile boolean allowReplacing = true;
        @GuardedBy(value="lock")
        private Position releaseToPosition = SessionPool.access$3100(SessionPool.this);
        private volatile boolean eligibleForLongRunning = false;
        private volatile boolean isRemovedFromPool = false;
        private volatile boolean isLeakedExceptionLogged = false;
        @GuardedBy(value="lock")
        private SessionState state;

        private PooledSession(SessionImpl delegate) {
            this.delegate = (SessionImpl)Preconditions.checkNotNull((Object)delegate);
            this.state = SessionState.AVAILABLE;
            this.markUsed();
        }

        int getChannel() {
            Long channelHint = (Long)this.delegate.getOptions().get((Object)SpannerRpc.Option.CHANNEL_HINT);
            return channelHint == null ? 0 : (int)(channelHint % (long)((SpannerOptions)SessionPool.this.sessionClient.getSpanner().getOptions()).getNumChannels());
        }

        public String toString() {
            return this.getName();
        }

        @Override
        @VisibleForTesting
        public void setAllowReplacing(boolean allowReplacing) {
            this.allowReplacing = allowReplacing;
        }

        @VisibleForTesting
        void setEligibleForLongRunning(boolean eligibleForLongRunning) {
            this.eligibleForLongRunning = eligibleForLongRunning;
        }

        @Override
        public Timestamp write(Iterable<Mutation> mutations) throws SpannerException {
            return this.writeWithOptions(mutations, new Options.TransactionOption[0]).getCommitTimestamp();
        }

        @Override
        public CommitResponse writeWithOptions(Iterable<Mutation> mutations, Options.TransactionOption ... options) throws SpannerException {
            try {
                this.markUsed();
                return this.delegate.writeWithOptions(mutations, options);
            }
            catch (SpannerException e) {
                this.lastException = e;
                throw this.lastException;
            }
        }

        @Override
        public Timestamp writeAtLeastOnce(Iterable<Mutation> mutations) throws SpannerException {
            return this.writeAtLeastOnceWithOptions(mutations, new Options.TransactionOption[0]).getCommitTimestamp();
        }

        @Override
        public CommitResponse writeAtLeastOnceWithOptions(Iterable<Mutation> mutations, Options.TransactionOption ... options) throws SpannerException {
            try {
                this.markUsed();
                return this.delegate.writeAtLeastOnceWithOptions(mutations, options);
            }
            catch (SpannerException e) {
                this.lastException = e;
                throw this.lastException;
            }
        }

        @Override
        public ServerStream<BatchWriteResponse> batchWriteAtLeastOnce(Iterable<MutationGroup> mutationGroups, Options.TransactionOption ... options) throws SpannerException {
            try {
                this.markUsed();
                return this.delegate.batchWriteAtLeastOnce(mutationGroups, options);
            }
            catch (SpannerException e) {
                this.lastException = e;
                throw this.lastException;
            }
        }

        @Override
        public long executePartitionedUpdate(Statement stmt, Options.UpdateOption ... options) throws SpannerException {
            try {
                this.markUsed();
                return this.delegate.executePartitionedUpdate(stmt, options);
            }
            catch (SpannerException e) {
                this.lastException = e;
                throw this.lastException;
            }
        }

        @Override
        public ReadContext singleUse() {
            return this.delegate.singleUse();
        }

        @Override
        public ReadContext singleUse(TimestampBound bound) {
            return this.delegate.singleUse(bound);
        }

        @Override
        public ReadOnlyTransaction singleUseReadOnlyTransaction() {
            return this.delegate.singleUseReadOnlyTransaction();
        }

        @Override
        public ReadOnlyTransaction singleUseReadOnlyTransaction(TimestampBound bound) {
            return this.delegate.singleUseReadOnlyTransaction(bound);
        }

        @Override
        public ReadOnlyTransaction readOnlyTransaction() {
            return this.delegate.readOnlyTransaction();
        }

        @Override
        public ReadOnlyTransaction readOnlyTransaction(TimestampBound bound) {
            return this.delegate.readOnlyTransaction(bound);
        }

        @Override
        public TransactionRunner readWriteTransaction(Options.TransactionOption ... options) {
            return this.delegate.readWriteTransaction(options);
        }

        @Override
        public AsyncRunner runAsync(Options.TransactionOption ... options) {
            return this.delegate.runAsync(options);
        }

        @Override
        public AsyncTransactionManagerImpl transactionManagerAsync(Options.TransactionOption ... options) {
            return this.delegate.transactionManagerAsync(options);
        }

        @Override
        public ApiFuture<Empty> asyncClose() {
            this.close();
            return ApiFutures.immediateFuture((Object)Empty.getDefaultInstance());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Object object = SessionPool.this.lock;
            synchronized (object) {
                SessionPool.this.numSessionsInUse--;
                SessionPool.this.numSessionsReleased++;
            }
            if (this.lastException != null && SessionPool.this.isSessionNotFound(this.lastException) || this.isRemovedFromPool) {
                SessionPool.this.invalidateSession(this);
            } else {
                if (SessionPool.this.isDatabaseOrInstanceNotFound(this.lastException)) {
                    object = SessionPool.this.lock;
                    synchronized (object) {
                        SessionPool.this.resourceNotFoundException = (SpannerException.ResourceNotFoundException)((Object)MoreObjects.firstNonNull((Object)((Object)SessionPool.this.resourceNotFoundException), (Object)((Object)((SpannerException.ResourceNotFoundException)this.lastException))));
                    }
                }
                this.lastException = null;
                this.isRemovedFromPool = false;
                if (this.state != SessionState.CLOSING) {
                    this.state = SessionState.AVAILABLE;
                }
                SessionPool.this.releaseSession(this, false);
            }
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void keepAlive() {
            this.markUsed();
            ISpan previousSpan = this.delegate.getCurrentSpan();
            this.delegate.setCurrentSpan(SessionPool.this.tracer.getBlankSpan());
            try (ResultSet resultSet = this.delegate.singleUse(TimestampBound.ofMaxStaleness(60L, TimeUnit.SECONDS)).executeQuery(Statement.newBuilder("SELECT 1").build(), new Options.QueryOption[0]);){
                resultSet.next();
            }
            finally {
                this.delegate.setCurrentSpan(previousSpan);
            }
        }

        private void determineDialectAsync(SettableFuture<Dialect> dialect) {
            Preconditions.checkNotNull(dialect);
            SessionPool.this.executor.submit(() -> {
                try {
                    dialect.set((Object)this.determineDialect());
                }
                catch (Throwable t) {
                    dialect.setException(t);
                }
                finally {
                    SessionPool.this.releaseSession(this, false);
                }
            });
        }

        private Dialect determineDialect() {
            try (ResultSet dialectResultSet = this.delegate.singleUse().executeQuery(DETERMINE_DIALECT_STATEMENT, new Options.QueryOption[0]);){
                if (dialectResultSet.next()) {
                    Dialect dialect = Dialect.fromName(dialectResultSet.getString(0));
                    return dialect;
                }
                throw SpannerExceptionFactory.newSpannerException(ErrorCode.NOT_FOUND, "No dialect found for database");
            }
        }

        @Override
        public SessionImpl getDelegate() {
            return this.delegate;
        }

        @Override
        public void markBusy(ISpan span) {
            this.delegate.setCurrentSpan(span);
            this.state = SessionState.BUSY;
        }

        private void markClosing() {
            this.state = SessionState.CLOSING;
        }

        @Override
        public void markUsed() {
            this.delegate.markUsed(SessionPool.this.clock.instant());
        }

        @Override
        public SpannerException setLastException(SpannerException exception) {
            this.lastException = exception;
            return exception;
        }

        boolean isAllowReplacing() {
            return this.allowReplacing;
        }

        @Override
        public TransactionManager transactionManager(Options.TransactionOption ... options) {
            return this.delegate.transactionManager(options);
        }
    }

    static enum Position {
        FIRST,
        LAST,
        RANDOM;

    }

    class PooledSessionReplacementHandler
    implements SessionReplacementHandler<PooledSessionFuture> {
        PooledSessionReplacementHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public PooledSessionFuture replaceSession(SessionNotFoundException e, PooledSessionFuture session) {
            if (!SessionPool.this.options.isFailIfSessionNotFound() && session.get().isAllowReplacing()) {
                Object object = SessionPool.this.lock;
                synchronized (object) {
                    SessionPool.this.numSessionsInUse--;
                    SessionPool.this.numSessionsReleased++;
                    SessionPool.this.checkedOutSessions.remove(session);
                    SessionPool.this.markedCheckedOutSessions.remove(session);
                }
                session.leakedException = null;
                SessionPool.this.invalidateSession(session.get());
                return SessionPool.this.getSession();
            }
            throw e;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public PooledSessionFuture denyListSession(RetryOnDifferentGrpcChannelException retryException, PooledSessionFuture session) {
            if (SessionPool.this.denyListedChannels == null) {
                throw SpannerExceptionFactory.asSpannerException(retryException.getCause());
            }
            int channel = session.get().getChannel();
            Object object = SessionPool.this.lock;
            synchronized (object) {
                int currentSize = 0;
                for (int i = 0; i < SessionPool.this.numChannels; ++i) {
                    if (SessionPool.this.denyListedChannels.getIfPresent((Object)i) == null) continue;
                    ++currentSize;
                }
                if (currentSize >= SessionPool.this.numChannels - 1) {
                    throw SpannerExceptionFactory.asSpannerException(retryException.getCause());
                }
                SessionPool.this.denyListedChannels.put((Object)channel, DENY_LISTED);
            }
            session.get().releaseToPosition = Position.LAST;
            session.close();
            return SessionPool.this.getSession();
        }
    }

    class PooledSessionFuture
    extends ForwardingListenableFuture.SimpleForwardingListenableFuture<PooledSession>
    implements SessionFuture {
        private volatile LeakedSessionException leakedException;
        private final AtomicBoolean inUse;
        private final CountDownLatch initialized;
        private final ISpan span;

        @VisibleForTesting
        PooledSessionFuture(ListenableFuture<PooledSession> delegate, ISpan span) {
            super(delegate);
            this.inUse = new AtomicBoolean();
            this.initialized = new CountDownLatch(1);
            this.span = span;
        }

        @VisibleForTesting
        void clearLeakedException() {
            this.leakedException = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void markCheckedOut() {
            if (SessionPool.this.options.isTrackStackTraceOfSessionCheckout()) {
                this.leakedException = new LeakedSessionException();
                Object object = SessionPool.this.lock;
                synchronized (object) {
                    SessionPool.this.markedCheckedOutSessions.add(this);
                }
            }
        }

        @Override
        public Timestamp write(Iterable<Mutation> mutations) throws SpannerException {
            return this.writeWithOptions(mutations, new Options.TransactionOption[0]).getCommitTimestamp();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CommitResponse writeWithOptions(Iterable<Mutation> mutations, Options.TransactionOption ... options) throws SpannerException {
            try {
                CommitResponse commitResponse = this.get().writeWithOptions(mutations, options);
                return commitResponse;
            }
            finally {
                this.close();
            }
        }

        @Override
        public Timestamp writeAtLeastOnce(Iterable<Mutation> mutations) throws SpannerException {
            return this.writeAtLeastOnceWithOptions(mutations, new Options.TransactionOption[0]).getCommitTimestamp();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CommitResponse writeAtLeastOnceWithOptions(Iterable<Mutation> mutations, Options.TransactionOption ... options) throws SpannerException {
            try {
                CommitResponse commitResponse = this.get().writeAtLeastOnceWithOptions(mutations, options);
                return commitResponse;
            }
            finally {
                this.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ServerStream<BatchWriteResponse> batchWriteAtLeastOnce(Iterable<MutationGroup> mutationGroups, Options.TransactionOption ... options) throws SpannerException {
            try {
                ServerStream<BatchWriteResponse> serverStream = this.get().batchWriteAtLeastOnce(mutationGroups, options);
                return serverStream;
            }
            finally {
                this.close();
            }
        }

        @Override
        public ReadContext singleUse() {
            try {
                return new AutoClosingReadContext(session -> {
                    PooledSession ps = session.get();
                    return ps.delegate.singleUse();
                }, SessionPool.this, SessionPool.this.pooledSessionReplacementHandler, this, true, null);
            }
            catch (Exception e) {
                this.close();
                throw e;
            }
        }

        @Override
        public ReadContext singleUse(TimestampBound bound) {
            try {
                return new AutoClosingReadContext(session -> {
                    PooledSession ps = session.get();
                    return ps.delegate.singleUse(bound);
                }, SessionPool.this, SessionPool.this.pooledSessionReplacementHandler, this, true, null);
            }
            catch (Exception e) {
                this.close();
                throw e;
            }
        }

        @Override
        public ReadOnlyTransaction singleUseReadOnlyTransaction() {
            return this.internalReadOnlyTransaction(session -> {
                PooledSession ps = session.get();
                return ps.delegate.singleUseReadOnlyTransaction();
            }, true);
        }

        @Override
        public ReadOnlyTransaction singleUseReadOnlyTransaction(TimestampBound bound) {
            return this.internalReadOnlyTransaction(session -> {
                PooledSession ps = session.get();
                return ps.delegate.singleUseReadOnlyTransaction(bound);
            }, true);
        }

        @Override
        public ReadOnlyTransaction readOnlyTransaction() {
            return this.internalReadOnlyTransaction(session -> {
                PooledSession ps = session.get();
                return ps.delegate.readOnlyTransaction();
            }, false);
        }

        @Override
        public ReadOnlyTransaction readOnlyTransaction(TimestampBound bound) {
            return this.internalReadOnlyTransaction(session -> {
                PooledSession ps = session.get();
                return ps.delegate.readOnlyTransaction(bound);
            }, false);
        }

        private ReadOnlyTransaction internalReadOnlyTransaction(Function<PooledSessionFuture, ReadOnlyTransaction> transactionSupplier, boolean isSingleUse) {
            try {
                return new AutoClosingReadTransaction<PooledSessionFuture>(transactionSupplier, SessionPool.this, SessionPool.this.pooledSessionReplacementHandler, this, isSingleUse);
            }
            catch (Exception e) {
                this.close();
                throw e;
            }
        }

        @Override
        public TransactionRunner readWriteTransaction(Options.TransactionOption ... options) {
            return new SessionPoolTransactionRunner(this, (SessionReplacementHandler)SessionPool.this.pooledSessionReplacementHandler, options, null);
        }

        @Override
        public TransactionManager transactionManager(Options.TransactionOption ... options) {
            return new AutoClosingTransactionManager<PooledSessionFuture>(this, SessionPool.this.pooledSessionReplacementHandler, options);
        }

        @Override
        public AsyncRunner runAsync(Options.TransactionOption ... options) {
            return new SessionPoolAsyncRunner(this, (SessionReplacementHandler)SessionPool.this.pooledSessionReplacementHandler, options, null);
        }

        @Override
        public AsyncTransactionManager transactionManagerAsync(Options.TransactionOption ... options) {
            return new SessionPoolAsyncTransactionManager<PooledSessionFuture>(SessionPool.this.pooledSessionReplacementHandler, this, options);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long executePartitionedUpdate(Statement stmt, Options.UpdateOption ... options) {
            try {
                long l = this.get(true).executePartitionedUpdate(stmt, options);
                return l;
            }
            finally {
                this.close();
            }
        }

        @Override
        public String getName() {
            return this.get().getName();
        }

        @Override
        public void close() {
            try {
                this.asyncClose().get();
            }
            catch (InterruptedException e) {
                throw SpannerExceptionFactory.propagateInterrupt(e);
            }
            catch (ExecutionException e) {
                throw SpannerExceptionFactory.asSpannerException(e.getCause());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ApiFuture<Empty> asyncClose() {
            try {
                PooledSession delegate = this.getOrNull();
                if (delegate != null) {
                    ApiFuture<Empty> apiFuture = delegate.asyncClose();
                    return apiFuture;
                }
            }
            finally {
                Object object = SessionPool.this.lock;
                synchronized (object) {
                    this.leakedException = null;
                    SessionPool.this.checkedOutSessions.remove(this);
                    SessionPool.this.markedCheckedOutSessions.remove(this);
                }
            }
            return ApiFutures.immediateFuture((Object)Empty.getDefaultInstance());
        }

        private PooledSession getOrNull() {
            try {
                return this.get();
            }
            catch (Throwable t) {
                return null;
            }
        }

        @Override
        public PooledSession get() {
            return this.get(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        PooledSession get(boolean eligibleForLongRunning) {
            if (this.inUse.compareAndSet(false, true)) {
                PooledSession res = null;
                try {
                    res = (PooledSession)super.get();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (res != null) {
                    res.markBusy(this.span);
                    this.span.addAnnotation("Using Session", "sessionId", res.getName());
                    Object object = SessionPool.this.lock;
                    synchronized (object) {
                        SessionPool.this.incrementNumSessionsInUse();
                        SessionPool.this.checkedOutSessions.add(this);
                    }
                    res.eligibleForLongRunning = eligibleForLongRunning;
                }
                this.initialized.countDown();
            }
            try {
                this.initialized.await();
                return (PooledSession)super.get();
            }
            catch (ExecutionException e) {
                throw SpannerExceptionFactory.newSpannerException(e.getCause());
            }
            catch (InterruptedException e) {
                throw SpannerExceptionFactory.propagateInterrupt(e);
            }
        }
    }

    class SessionConsumerImpl
    implements SessionClient.SessionConsumer {
        SessionConsumerImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSessionReady(SessionImpl session) {
            PooledSession pooledSession = null;
            boolean closeSession = false;
            Object object = SessionPool.this.lock;
            synchronized (object) {
                int minSessions = SessionPool.this.options.getMinSessions();
                pooledSession = new PooledSession(session);
                SessionPool.this.numSessionsBeingCreated--;
                if (SessionPool.this.closureFuture != null) {
                    closeSession = true;
                } else {
                    Preconditions.checkState((SessionPool.this.totalSessions() <= SessionPool.this.options.getMaxSessions() - 1 ? 1 : 0) != 0);
                    SessionPool.this.allSessions.add(pooledSession);
                    if (SessionPool.this.allSessions.size() >= minSessions) {
                        SessionPool.this.waitOnMinSessionsLatch.countDown();
                    }
                    if (SessionPool.this.options.isAutoDetectDialect() && !SessionPool.this.detectDialectStarted) {
                        SessionPool.this.detectDialectStarted = true;
                        pooledSession.determineDialectAsync((SettableFuture<Dialect>)SessionPool.this.dialect);
                    } else {
                        SessionPool.this.releaseSession(pooledSession, true);
                    }
                }
            }
            if (closeSession) {
                SessionPool.this.closeSessionAsync(pooledSession);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSessionCreateFailure(Throwable t, int createFailureForSessionCount) {
            Object object = SessionPool.this.lock;
            synchronized (object) {
                SessionPool.this.numSessionsBeingCreated -= createFailureForSessionCount;
                if (SessionPool.this.numSessionsBeingCreated == 0) {
                    SessionPool.this.waitOnMinSessionsLatch.countDown();
                }
                if (SessionPool.this.isClosed()) {
                    SessionPool.this.decrementPendingClosures(createFailureForSessionCount);
                }
                SessionPool.this.handleCreateSessionsFailure(SpannerExceptionFactory.newSpannerException(t), createFailureForSessionCount);
            }
        }
    }

    final class PoolMaintainer {
        private final Duration windowLength = Duration.ofMillis((long)TimeUnit.MINUTES.toMillis(10L));
        @VisibleForTesting
        final long loopFrequency = SessionPool.access$1100(SessionPool.this).getLoopFrequency();
        @VisibleForTesting
        final long numClosureCycles = this.windowLength.toMillis() / this.loopFrequency;
        private final Duration keepAliveMillis = Duration.ofMillis((long)TimeUnit.MINUTES.toMillis(SessionPool.access$1100(SessionPool.this).getKeepAliveIntervalMinutes()));
        @VisibleForTesting
        final long numKeepAliveCycles = this.keepAliveMillis.toMillis() / this.loopFrequency;
        @VisibleForTesting
        Instant lastExecutionTime;
        private long prevNumSessionsAcquired;
        boolean closed = false;
        @GuardedBy(value="lock")
        ScheduledFuture<?> scheduledFuture;
        @GuardedBy(value="lock")
        boolean running;

        PoolMaintainer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void init() {
            this.lastExecutionTime = SessionPool.this.clock.instant();
            Object object = SessionPool.this.lock;
            synchronized (object) {
                this.scheduledFuture = SessionPool.this.executor.scheduleAtFixedRate(this::maintainPool, this.loopFrequency, this.loopFrequency, TimeUnit.MILLISECONDS);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() {
            Object object = SessionPool.this.lock;
            synchronized (object) {
                if (!this.closed) {
                    this.closed = true;
                    this.scheduledFuture.cancel(false);
                    if (!this.running) {
                        SessionPool.this.decrementPendingClosures(1);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isClosed() {
            Object object = SessionPool.this.lock;
            synchronized (object) {
                return this.closed;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void maintainPool() {
            Object object = SessionPool.this.lock;
            synchronized (object) {
                if (SessionPool.this.isClosed()) {
                    return;
                }
                this.running = true;
                if (this.loopFrequency >= 1000L) {
                    SessionPool.this.transactionsPerSecond = (SessionPool.this.numSessionsAcquired - this.prevNumSessionsAcquired) / (this.loopFrequency / 1000L);
                }
                this.prevNumSessionsAcquired = SessionPool.this.numSessionsAcquired;
            }
            Instant currTime = SessionPool.this.clock.instant();
            this.removeIdleSessions(currTime);
            this.keepAliveSessions(currTime);
            this.replenishPool();
            Object object2 = SessionPool.this.lock;
            synchronized (object2) {
                this.running = false;
                if (SessionPool.this.isClosed()) {
                    SessionPool.this.decrementPendingClosures(1);
                }
            }
            this.removeLongRunningSessions(currTime);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeIdleSessions(Instant currTime) {
            Object object = SessionPool.this.lock;
            synchronized (object) {
                Instant minLastUseTime = currTime.minus((TemporalAmount)SessionPool.this.options.getRemoveInactiveSessionAfter());
                Iterator iterator = SessionPool.this.sessions.descendingIterator();
                while (iterator.hasNext()) {
                    PooledSession session = (PooledSession)iterator.next();
                    if (session.delegate.getLastUseTime() == null || !session.delegate.getLastUseTime().isBefore(minLastUseTime) || session.state == SessionState.CLOSING) continue;
                    boolean isRemoved = SessionPool.this.removeFromPool(session);
                    if (isRemoved) {
                        SessionPool.this.numIdleSessionsRemoved++;
                        if (SessionPool.this.idleSessionRemovedListener != null) {
                            SessionPool.this.idleSessionRemovedListener.apply(session);
                        }
                    }
                    iterator.remove();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void keepAliveSessions(Instant currTime) {
            long numSessionsToKeepAlive = 0L;
            Object object = SessionPool.this.lock;
            synchronized (object) {
                if (SessionPool.this.numSessionsInUse >= SessionPool.this.options.getMinSessions() + SessionPool.this.options.getMaxIdleSessions()) {
                    return;
                }
                numSessionsToKeepAlive = (long)Math.ceil((double)(SessionPool.this.options.getMinSessions() + SessionPool.this.options.getMaxIdleSessions() - SessionPool.this.numSessionsInUse) / (double)this.numKeepAliveCycles);
            }
            Instant keepAliveThreshold = currTime.minus((TemporalAmount)this.keepAliveMillis);
            while (numSessionsToKeepAlive > 0L) {
                Tuple sessionToKeepAlive;
                Object object2 = SessionPool.this.lock;
                synchronized (object2) {
                    sessionToKeepAlive = SessionPool.this.findSessionToKeepAlive(SessionPool.this.sessions, keepAliveThreshold, 0);
                }
                if (sessionToKeepAlive == null) break;
                try {
                    logger.log(Level.FINE, "Keeping alive session " + ((PooledSession)sessionToKeepAlive.x()).getName());
                    --numSessionsToKeepAlive;
                    ((PooledSession)sessionToKeepAlive.x()).keepAlive();
                    SessionPool.this.releaseSession((Tuple<PooledSession, Integer>)sessionToKeepAlive);
                }
                catch (SpannerException e) {
                    SessionPool.this.handleException(e, (Tuple<PooledSession, Integer>)sessionToKeepAlive);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void replenishPool() {
            Object object = SessionPool.this.lock;
            synchronized (object) {
                int sessionCount = SessionPool.this.options.getMinSessions() - (SessionPool.this.totalSessions() + SessionPool.this.numSessionsBeingCreated);
                if (sessionCount > 0) {
                    SessionPool.this.createSessions(SessionPool.this.getAllowedCreateSessions(sessionCount), false);
                }
            }
        }

        void removeLongRunningSessions(Instant currentTime) {
            try {
                if (SessionPool.this.isClosed()) {
                    return;
                }
                SessionPoolOptions.InactiveTransactionRemovalOptions inactiveTransactionRemovalOptions = SessionPool.this.options.getInactiveTransactionRemovalOptions();
                Instant minExecutionTime = this.lastExecutionTime.plus((TemporalAmount)inactiveTransactionRemovalOptions.getExecutionFrequency());
                if (currentTime.isBefore(minExecutionTime)) {
                    return;
                }
                this.lastExecutionTime = currentTime;
                if (SessionPool.this.options.closeInactiveTransactions() || SessionPool.this.options.warnInactiveTransactions() || SessionPool.this.options.warnAndCloseInactiveTransactions()) {
                    this.removeLongRunningSessions(currentTime, inactiveTransactionRemovalOptions);
                }
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "Failed removing long running transactions", t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeLongRunningSessions(Instant currentTime, SessionPoolOptions.InactiveTransactionRemovalOptions inactiveTransactionRemovalOptions) {
            Object object = SessionPool.this.lock;
            synchronized (object) {
                double usedSessionsRatio = SessionPool.this.getRatioOfSessionsInUse();
                if (usedSessionsRatio > inactiveTransactionRemovalOptions.getUsedSessionsRatioThreshold()) {
                    Iterator<PooledSessionFuture> iterator = SessionPool.this.checkedOutSessions.iterator();
                    while (iterator.hasNext()) {
                        PooledSessionFuture sessionFuture = iterator.next();
                        PooledSession session = sessionFuture.get();
                        Duration durationFromLastUse = Duration.between((Temporal)session.getDelegate().getLastUseTime(), (Temporal)currentTime);
                        if (session.eligibleForLongRunning || durationFromLastUse.compareTo(inactiveTransactionRemovalOptions.getIdleTimeThreshold()) <= 0) continue;
                        if ((SessionPool.this.options.warnInactiveTransactions() || SessionPool.this.options.warnAndCloseInactiveTransactions()) && !session.isLeakedExceptionLogged) {
                            if (SessionPool.this.options.warnAndCloseInactiveTransactions()) {
                                logger.log(Level.WARNING, String.format("Removing long-running session => %s", session.getName()), sessionFuture.leakedException);
                                session.isLeakedExceptionLogged = true;
                            } else if (SessionPool.this.options.warnInactiveTransactions()) {
                                logger.log(Level.WARNING, String.format("Detected long-running session => %s. To automatically remove long-running sessions, set SessionOption ActionOnInactiveTransaction to WARN_AND_CLOSE by invoking setWarnAndCloseIfInactiveTransactions() method.", session.getName()), sessionFuture.leakedException);
                                session.isLeakedExceptionLogged = true;
                            }
                        }
                        if (!SessionPool.this.options.closeInactiveTransactions() && !SessionPool.this.options.warnAndCloseInactiveTransactions() || session.state == SessionState.CLOSING) continue;
                        boolean isRemoved = SessionPool.this.removeFromPool(session);
                        if (isRemoved) {
                            session.isRemovedFromPool = true;
                            SessionPool.this.numLeakedSessionsRemoved++;
                            if (SessionPool.this.longRunningSessionRemovedListener != null) {
                                SessionPool.this.longRunningSessionRemovedListener.apply(session);
                            }
                        }
                        iterator.remove();
                    }
                }
            }
        }
    }

    class PooledSessionFutureWrapper
    implements SessionFutureWrapper<PooledSessionFuture> {
        PooledSessionFuture pooledSessionFuture;

        public PooledSessionFutureWrapper(PooledSessionFuture pooledSessionFuture) {
            this.pooledSessionFuture = pooledSessionFuture;
        }

        @Override
        public PooledSessionFuture get() {
            return this.pooledSessionFuture;
        }
    }

    private final class WaiterFuture
    extends ForwardingListenableFuture<PooledSession> {
        private static final long MAX_SESSION_WAIT_TIMEOUT = 240000L;
        private final SettableFuture<PooledSession> waiter = SettableFuture.create();

        private WaiterFuture() {
        }

        @Nonnull
        protected ListenableFuture<? extends PooledSession> delegate() {
            return this.waiter;
        }

        private void put(PooledSession session) {
            this.waiter.set((Object)session);
        }

        private void put(SpannerException e) {
            this.waiter.setException((Throwable)((Object)e));
        }

        public PooledSession get() {
            long currentTimeout = SessionPool.this.options.getInitialWaitForSessionTimeoutMillis();
            while (true) {
                ISpan span = SessionPool.this.tracer.spanBuilder(SessionPool.WAIT_FOR_SESSION);
                try {
                    IScope ignore = SessionPool.this.tracer.withSpan(span);
                    try {
                        PooledSession s = this.pollUninterruptiblyWithTimeout(currentTimeout, SessionPool.this.options.getAcquireSessionTimeout());
                        if (s == null) {
                            SessionPool.this.numWaiterTimeouts.incrementAndGet();
                            SessionPool.this.tracer.getCurrentSpan().setStatus(ErrorCode.DEADLINE_EXCEEDED);
                            currentTimeout = Math.min(currentTimeout * 2L, 240000L);
                            continue;
                        }
                        PooledSession pooledSession = s;
                        return pooledSession;
                    }
                    finally {
                        if (ignore == null) continue;
                        ignore.close();
                        continue;
                    }
                }
                catch (Exception e) {
                    if (e instanceof SpannerException && ErrorCode.RESOURCE_EXHAUSTED.equals((Object)((SpannerException)((Object)e)).getErrorCode())) {
                        SessionPool.this.numWaiterTimeouts.incrementAndGet();
                        SessionPool.this.tracer.getCurrentSpan().setStatus(ErrorCode.RESOURCE_EXHAUSTED);
                    }
                    span.setStatus(e);
                    throw e;
                }
                finally {
                    span.end();
                    continue;
                }
                break;
            }
        }

        private PooledSession pollUninterruptiblyWithTimeout(long timeoutMillis, Duration acquireSessionTimeout) {
            boolean interrupted = false;
            while (true) {
                try {
                    PooledSession pooledSession = acquireSessionTimeout == null ? (PooledSession)this.waiter.get(timeoutMillis, TimeUnit.MILLISECONDS) : (PooledSession)this.waiter.get(acquireSessionTimeout.toMillis(), TimeUnit.MILLISECONDS);
                    return pooledSession;
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    continue;
                }
                catch (TimeoutException e) {
                    SpannerException exception;
                    if (acquireSessionTimeout != null && this.waiter.setException((Throwable)((Object)(exception = SpannerExceptionFactory.newSpannerException(ErrorCode.RESOURCE_EXHAUSTED, "Timed out after waiting " + acquireSessionTimeout.toMillis() + "ms for acquiring session. To mitigate error SessionPoolOptions#setAcquireSessionTimeout(Duration) to set a higher timeout or increase the number of sessions in the session pool.\n" + SessionPool.this.createCheckedOutSessionsStackTraces()))))) {
                        throw exception;
                    }
                    PooledSession pooledSession = null;
                    return pooledSession;
                }
                catch (ExecutionException e) {
                    throw SpannerExceptionFactory.newSpannerException(e.getCause());
                }
                break;
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    final class LeakedSessionException
    extends RuntimeException {
        private static final long serialVersionUID = 1451131180314064914L;

        private LeakedSessionException() {
            super("Session was checked out from the pool at " + SessionPool.this.clock.instant());
        }

        private LeakedSessionException(String message) {
            super(message);
        }
    }

    private static enum SessionState {
        AVAILABLE,
        BUSY,
        CLOSING;

    }

    static interface CachedSession
    extends Session {
        public SessionImpl getDelegate();

        public void markBusy(ISpan var1);

        public void markUsed();

        public SpannerException setLastException(SpannerException var1);

        @Override
        public AsyncTransactionManagerImpl transactionManagerAsync(Options.TransactionOption ... var1);

        public void setAllowReplacing(boolean var1);
    }

    static interface SessionFuture
    extends Session {
        public CachedSession get();

        default public void addListener(Runnable listener, Executor exec) {
        }
    }

    static interface SessionFutureWrapper<T extends SessionFuture>
    extends DatabaseClient {
        public T get();

        @Override
        default public Dialect getDialect() {
            return this.get().getDialect();
        }

        @Override
        default public String getDatabaseRole() {
            return this.get().getDatabaseRole();
        }

        @Override
        default public Timestamp write(Iterable<Mutation> mutations) throws SpannerException {
            return this.get().write(mutations);
        }

        @Override
        default public CommitResponse writeWithOptions(Iterable<Mutation> mutations, Options.TransactionOption ... options) throws SpannerException {
            return this.get().writeWithOptions(mutations, options);
        }

        @Override
        default public Timestamp writeAtLeastOnce(Iterable<Mutation> mutations) throws SpannerException {
            return this.get().writeAtLeastOnce(mutations);
        }

        @Override
        default public CommitResponse writeAtLeastOnceWithOptions(Iterable<Mutation> mutations, Options.TransactionOption ... options) throws SpannerException {
            return this.get().writeAtLeastOnceWithOptions(mutations, options);
        }

        @Override
        default public ServerStream<BatchWriteResponse> batchWriteAtLeastOnce(Iterable<MutationGroup> mutationGroups, Options.TransactionOption ... options) throws SpannerException {
            return this.get().batchWriteAtLeastOnce(mutationGroups, options);
        }

        @Override
        default public ReadContext singleUse() {
            return this.get().singleUse();
        }

        @Override
        default public ReadContext singleUse(TimestampBound bound) {
            return this.get().singleUse(bound);
        }

        @Override
        default public ReadOnlyTransaction singleUseReadOnlyTransaction() {
            return this.get().singleUseReadOnlyTransaction();
        }

        @Override
        default public ReadOnlyTransaction singleUseReadOnlyTransaction(TimestampBound bound) {
            return this.get().singleUseReadOnlyTransaction(bound);
        }

        @Override
        default public ReadOnlyTransaction readOnlyTransaction() {
            return this.get().readOnlyTransaction();
        }

        @Override
        default public ReadOnlyTransaction readOnlyTransaction(TimestampBound bound) {
            return this.get().readOnlyTransaction(bound);
        }

        @Override
        default public TransactionRunner readWriteTransaction(Options.TransactionOption ... options) {
            return this.get().readWriteTransaction(options);
        }

        @Override
        default public TransactionManager transactionManager(Options.TransactionOption ... options) {
            return this.get().transactionManager(options);
        }

        @Override
        default public AsyncRunner runAsync(Options.TransactionOption ... options) {
            return this.get().runAsync(options);
        }

        @Override
        default public AsyncTransactionManager transactionManagerAsync(Options.TransactionOption ... options) {
            return this.get().transactionManagerAsync(options);
        }

        @Override
        default public long executePartitionedUpdate(Statement stmt, Options.UpdateOption ... options) {
            return this.get().executePartitionedUpdate(stmt, options);
        }
    }

    private static class SessionPoolAsyncRunner<I extends SessionFuture>
    implements AsyncRunner {
        private volatile I session;
        private final SessionReplacementHandler<I> sessionReplacementHandler;
        private final Options.TransactionOption[] options;
        private SettableApiFuture<CommitResponse> commitResponse;

        private SessionPoolAsyncRunner(I session, SessionReplacementHandler<I> sessionReplacementHandler, Options.TransactionOption ... options) {
            this.session = session;
            this.options = options;
            this.sessionReplacementHandler = sessionReplacementHandler;
        }

        @Override
        public <R> ApiFuture<R> runAsync(AsyncRunner.AsyncWork<R> work, Executor executor) {
            this.commitResponse = SettableApiFuture.create();
            SettableApiFuture res = SettableApiFuture.create();
            executor.execute(() -> {
                SpannerException exception = null;
                Object r = null;
                AsyncRunner runner = null;
                while (true) {
                    SpannerException se = null;
                    try {
                        runner = this.session.get().runAsync(this.options);
                        r = runner.runAsync(work, MoreExecutors.directExecutor()).get();
                    }
                    catch (ExecutionException e) {
                        se = SpannerExceptionFactory.asSpannerException(e.getCause());
                        continue;
                    }
                    catch (InterruptedException e) {
                        se = SpannerExceptionFactory.propagateInterrupt(e);
                        continue;
                    }
                    catch (Throwable t) {
                        se = SpannerExceptionFactory.newSpannerException(t);
                        continue;
                    }
                    finally {
                        if (se instanceof SessionNotFoundException) {
                            try {
                                this.session = this.sessionReplacementHandler.replaceSession((SessionNotFoundException)se, this.session);
                                continue;
                            }
                            catch (SessionNotFoundException e) {
                                exception = e;
                                break;
                            }
                        }
                        exception = se;
                        break;
                        continue;
                    }
                    break;
                }
                this.session.get().markUsed();
                this.session.close();
                this.setCommitResponse(runner);
                if (exception != null) {
                    res.setException((Throwable)((Object)exception));
                } else {
                    res.set(r);
                }
            });
            return res;
        }

        private void setCommitResponse(AsyncRunner delegate) {
            try {
                this.commitResponse.set((Object)((CommitResponse)delegate.getCommitResponse().get()));
            }
            catch (Throwable t) {
                this.commitResponse.setException(t);
            }
        }

        @Override
        public ApiFuture<Timestamp> getCommitTimestamp() {
            Preconditions.checkState((this.commitResponse != null ? 1 : 0) != 0, (Object)"runAsync() has not yet been called");
            return ApiFutures.transform(this.commitResponse, CommitResponse::getCommitTimestamp, (Executor)MoreExecutors.directExecutor());
        }

        @Override
        public ApiFuture<CommitResponse> getCommitResponse() {
            Preconditions.checkState((this.commitResponse != null ? 1 : 0) != 0, (Object)"runAsync() has not yet been called");
            return this.commitResponse;
        }

        /* synthetic */ SessionPoolAsyncRunner(SessionFuture x0, SessionReplacementHandler x1, Options.TransactionOption[] x2, 1 x3) {
            this(x0, x1, x2);
        }
    }

    private static final class SessionPoolTransactionRunner<I extends SessionFuture>
    implements TransactionRunner {
        private I session;
        private final SessionReplacementHandler<I> sessionReplacementHandler;
        private final Options.TransactionOption[] options;
        private TransactionRunner runner;

        private SessionPoolTransactionRunner(I session, SessionReplacementHandler<I> sessionReplacementHandler, Options.TransactionOption ... options) {
            this.session = session;
            this.options = options;
            this.sessionReplacementHandler = sessionReplacementHandler;
        }

        private TransactionRunner getRunner() {
            if (this.runner == null) {
                this.runner = this.session.get().readWriteTransaction(this.options);
            }
            return this.runner;
        }

        @Override
        @Nullable
        public <T> T run(TransactionRunner.TransactionCallable<T> callable) {
            try {
                T result;
                while (true) {
                    CachedSession cachedSession;
                    try {
                        result = this.getRunner().run(callable);
                    }
                    catch (SessionNotFoundException e) {
                        this.session = this.sessionReplacementHandler.replaceSession(e, this.session);
                        cachedSession = this.session.get();
                        this.runner = cachedSession.getDelegate().readWriteTransaction(new Options.TransactionOption[0]);
                        continue;
                    }
                    catch (RetryOnDifferentGrpcChannelException retryException) {
                        this.session = this.sessionReplacementHandler.denyListSession(retryException, this.session);
                        cachedSession = this.session.get();
                        this.runner = cachedSession.getDelegate().readWriteTransaction(new Options.TransactionOption[0]);
                        continue;
                    }
                    break;
                }
                this.session.get().markUsed();
                T t = result;
                return t;
            }
            catch (SpannerException e) {
                this.session.get().setLastException(e);
                throw e;
            }
            finally {
                this.session.close();
            }
        }

        @Override
        public Timestamp getCommitTimestamp() {
            return this.getRunner().getCommitTimestamp();
        }

        @Override
        public CommitResponse getCommitResponse() {
            return this.getRunner().getCommitResponse();
        }

        @Override
        public TransactionRunner allowNestedTransaction() {
            this.getRunner().allowNestedTransaction();
            return this;
        }

        /* synthetic */ SessionPoolTransactionRunner(SessionFuture x0, SessionReplacementHandler x1, Options.TransactionOption[] x2, 1 x3) {
            this(x0, x1, x2);
        }
    }

    private static class AutoClosingTransactionManager<T extends SessionFuture>
    implements TransactionManager,
    SessionNotFoundHandler {
        private TransactionManager delegate;
        private T session;
        private final SessionReplacementHandler<T> sessionReplacementHandler;
        private final Options.TransactionOption[] options;
        private boolean closed;
        private boolean restartedAfterSessionNotFound;

        AutoClosingTransactionManager(T session, SessionReplacementHandler<T> sessionReplacementHandler, Options.TransactionOption ... options) {
            this.session = session;
            this.options = options;
            this.sessionReplacementHandler = sessionReplacementHandler;
        }

        @Override
        public TransactionContext begin() {
            this.delegate = this.session.get().transactionManager(this.options);
            return this.internalBegin();
        }

        private TransactionContext internalBegin() {
            SessionPoolTransactionContext res = new SessionPoolTransactionContext(this, this.delegate.begin());
            this.session.get().markUsed();
            return res;
        }

        @Override
        public SpannerException handleSessionNotFound(SessionNotFoundException notFoundException) {
            this.session = this.sessionReplacementHandler.replaceSession(notFoundException, this.session);
            CachedSession cachedSession = this.session.get();
            this.delegate = cachedSession.getDelegate().transactionManager(this.options);
            this.restartedAfterSessionNotFound = true;
            return AutoClosingTransactionManager.createAbortedExceptionWithMinimalRetryDelay(notFoundException);
        }

        private static SpannerException createAbortedExceptionWithMinimalRetryDelay(SessionNotFoundException notFoundException) {
            return SpannerExceptionFactory.newSpannerException(ErrorCode.ABORTED, notFoundException.getMessage(), (Throwable)SpannerExceptionFactory.createAbortedExceptionWithRetryDelay(notFoundException.getMessage(), (Throwable)((Object)notFoundException), 0L, 1));
        }

        @Override
        public void commit() {
            try {
                this.delegate.commit();
            }
            catch (SessionNotFoundException e) {
                throw this.handleSessionNotFound(e);
            }
            finally {
                if (this.getState() != TransactionManager.TransactionState.ABORTED) {
                    this.close();
                }
            }
        }

        @Override
        public void rollback() {
            try {
                this.delegate.rollback();
            }
            finally {
                this.close();
            }
        }

        @Override
        public TransactionContext resetForRetry() {
            while (true) {
                try {
                    if (this.restartedAfterSessionNotFound) {
                        SessionPoolTransactionContext res = new SessionPoolTransactionContext(this, this.delegate.begin());
                        this.restartedAfterSessionNotFound = false;
                        return res;
                    }
                    return new SessionPoolTransactionContext(this, this.delegate.resetForRetry());
                }
                catch (SessionNotFoundException e) {
                    this.session = this.sessionReplacementHandler.replaceSession(e, this.session);
                    CachedSession cachedSession = this.session.get();
                    this.delegate = cachedSession.getDelegate().transactionManager(this.options);
                    this.restartedAfterSessionNotFound = true;
                    continue;
                }
                break;
            }
        }

        @Override
        public Timestamp getCommitTimestamp() {
            return this.delegate.getCommitTimestamp();
        }

        @Override
        public CommitResponse getCommitResponse() {
            return this.delegate.getCommitResponse();
        }

        @Override
        public void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                if (this.delegate != null) {
                    this.delegate.close();
                }
            }
            finally {
                this.session.close();
            }
        }

        @Override
        public TransactionManager.TransactionState getState() {
            if (this.restartedAfterSessionNotFound) {
                return TransactionManager.TransactionState.ABORTED;
            }
            return this.delegate == null ? null : this.delegate.getState();
        }
    }

    static class SessionPoolTransactionContext
    implements TransactionContext {
        private final SessionNotFoundHandler handler;
        final TransactionContext delegate;

        SessionPoolTransactionContext(SessionNotFoundHandler handler, TransactionContext delegate) {
            this.handler = (SessionNotFoundHandler)Preconditions.checkNotNull((Object)handler);
            this.delegate = delegate;
        }

        @Override
        public ResultSet read(String table, KeySet keys, Iterable<String> columns, Options.ReadOption ... options) {
            return new SessionPoolResultSet(this.handler, this.delegate.read(table, keys, columns, options));
        }

        @Override
        public AsyncResultSet readAsync(String table, KeySet keys, Iterable<String> columns, Options.ReadOption ... options) {
            return new AsyncSessionPoolResultSet(this.handler, this.delegate.readAsync(table, keys, columns, options));
        }

        @Override
        public ResultSet readUsingIndex(String table, String index, KeySet keys, Iterable<String> columns, Options.ReadOption ... options) {
            return new SessionPoolResultSet(this.handler, this.delegate.readUsingIndex(table, index, keys, columns, options));
        }

        @Override
        public AsyncResultSet readUsingIndexAsync(String table, String index, KeySet keys, Iterable<String> columns, Options.ReadOption ... options) {
            return new AsyncSessionPoolResultSet(this.handler, this.delegate.readUsingIndexAsync(table, index, keys, columns, options));
        }

        @Override
        public Struct readRow(String table, Key key, Iterable<String> columns) {
            try {
                return this.delegate.readRow(table, key, columns);
            }
            catch (SessionNotFoundException e) {
                throw this.handler.handleSessionNotFound(e);
            }
        }

        @Override
        public ApiFuture<Struct> readRowAsync(String table, Key key, Iterable<String> columns) {
            try (AsyncResultSet rs = this.readAsync(table, KeySet.singleKey(key), columns, new Options.ReadOption[0]);){
                ApiFuture apiFuture = ApiFutures.catching(AbstractReadContext.consumeSingleRowAsync(rs), SessionNotFoundException.class, input -> {
                    throw this.handler.handleSessionNotFound((SessionNotFoundException)((Object)input));
                }, (Executor)MoreExecutors.directExecutor());
                return apiFuture;
            }
        }

        @Override
        public void buffer(Mutation mutation) {
            this.delegate.buffer(mutation);
        }

        @Override
        public ApiFuture<Void> bufferAsync(Mutation mutation) {
            return this.delegate.bufferAsync(mutation);
        }

        @Override
        public Struct readRowUsingIndex(String table, String index, Key key, Iterable<String> columns) {
            try {
                return this.delegate.readRowUsingIndex(table, index, key, columns);
            }
            catch (SessionNotFoundException e) {
                throw this.handler.handleSessionNotFound(e);
            }
        }

        @Override
        public ApiFuture<Struct> readRowUsingIndexAsync(String table, String index, Key key, Iterable<String> columns) {
            try (AsyncResultSet rs = this.readUsingIndexAsync(table, index, KeySet.singleKey(key), columns, new Options.ReadOption[0]);){
                ApiFuture apiFuture = ApiFutures.catching(AbstractReadContext.consumeSingleRowAsync(rs), SessionNotFoundException.class, input -> {
                    throw this.handler.handleSessionNotFound((SessionNotFoundException)((Object)input));
                }, (Executor)MoreExecutors.directExecutor());
                return apiFuture;
            }
        }

        @Override
        public void buffer(Iterable<Mutation> mutations) {
            this.delegate.buffer(mutations);
        }

        @Override
        public ApiFuture<Void> bufferAsync(Iterable<Mutation> mutations) {
            return this.delegate.bufferAsync(mutations);
        }

        @Override
        public ResultSetStats analyzeUpdate(Statement statement, ReadContext.QueryAnalyzeMode analyzeMode, Options.UpdateOption ... options) {
            try (ResultSet resultSet = this.analyzeUpdateStatement(statement, analyzeMode, options);){
                ResultSetStats resultSetStats = resultSet.getStats();
                return resultSetStats;
            }
        }

        @Override
        public ResultSet analyzeUpdateStatement(Statement statement, ReadContext.QueryAnalyzeMode analyzeMode, Options.UpdateOption ... options) {
            try {
                return this.delegate.analyzeUpdateStatement(statement, analyzeMode, options);
            }
            catch (SessionNotFoundException e) {
                throw this.handler.handleSessionNotFound(e);
            }
        }

        @Override
        public long executeUpdate(Statement statement, Options.UpdateOption ... options) {
            try {
                return this.delegate.executeUpdate(statement, options);
            }
            catch (SessionNotFoundException e) {
                throw this.handler.handleSessionNotFound(e);
            }
        }

        @Override
        public ApiFuture<Long> executeUpdateAsync(Statement statement, Options.UpdateOption ... options) {
            return ApiFutures.catching(this.delegate.executeUpdateAsync(statement, options), SessionNotFoundException.class, input -> {
                throw this.handler.handleSessionNotFound((SessionNotFoundException)((Object)input));
            }, (Executor)MoreExecutors.directExecutor());
        }

        @Override
        public long[] batchUpdate(Iterable<Statement> statements, Options.UpdateOption ... options) {
            try {
                return this.delegate.batchUpdate(statements, options);
            }
            catch (SessionNotFoundException e) {
                throw this.handler.handleSessionNotFound(e);
            }
        }

        @Override
        public ApiFuture<long[]> batchUpdateAsync(Iterable<Statement> statements, Options.UpdateOption ... options) {
            return ApiFutures.catching(this.delegate.batchUpdateAsync(statements, options), SessionNotFoundException.class, input -> {
                throw this.handler.handleSessionNotFound((SessionNotFoundException)((Object)input));
            }, (Executor)MoreExecutors.directExecutor());
        }

        @Override
        public ResultSet executeQuery(Statement statement, Options.QueryOption ... options) {
            return new SessionPoolResultSet(this.handler, this.delegate.executeQuery(statement, options));
        }

        @Override
        public AsyncResultSet executeQueryAsync(Statement statement, Options.QueryOption ... options) {
            return new AsyncSessionPoolResultSet(this.handler, this.delegate.executeQueryAsync(statement, options));
        }

        @Override
        public ResultSet analyzeQuery(Statement statement, ReadContext.QueryAnalyzeMode queryMode) {
            return new SessionPoolResultSet(this.handler, this.delegate.analyzeQuery(statement, queryMode));
        }

        @Override
        public void close() {
            this.delegate.close();
        }
    }

    static class AsyncSessionPoolResultSet
    extends ForwardingAsyncResultSet {
        private final SessionNotFoundHandler handler;

        private AsyncSessionPoolResultSet(SessionNotFoundHandler handler, AsyncResultSet delegate) {
            super(delegate);
            this.handler = (SessionNotFoundHandler)Preconditions.checkNotNull((Object)handler);
        }

        @Override
        public ApiFuture<Void> setCallback(Executor executor, AsyncResultSet.ReadyCallback callback) {
            return super.setCallback(executor, resultSet -> {
                try {
                    return callback.cursorReady(resultSet);
                }
                catch (SessionNotFoundException e) {
                    throw this.handler.handleSessionNotFound(e);
                }
            });
        }

        @Override
        public boolean next() {
            try {
                return super.next();
            }
            catch (SessionNotFoundException e) {
                throw this.handler.handleSessionNotFound(e);
            }
        }

        @Override
        public AsyncResultSet.CursorState tryNext() {
            try {
                return super.tryNext();
            }
            catch (SessionNotFoundException e) {
                throw this.handler.handleSessionNotFound(e);
            }
        }
    }

    static class SessionPoolResultSet
    extends ForwardingResultSet {
        private final SessionNotFoundHandler handler;

        private SessionPoolResultSet(SessionNotFoundHandler handler, ResultSet delegate) {
            super(delegate);
            this.handler = (SessionNotFoundHandler)Preconditions.checkNotNull((Object)handler);
        }

        @Override
        public boolean next() {
            try {
                return super.next();
            }
            catch (SessionNotFoundException e) {
                throw this.handler.handleSessionNotFound(e);
            }
        }
    }

    static interface SessionNotFoundHandler {
        public SpannerException handleSessionNotFound(SessionNotFoundException var1);
    }

    static interface SessionReplacementHandler<T extends SessionFuture> {
        public T replaceSession(SessionNotFoundException var1, T var2);

        public T denyListSession(RetryOnDifferentGrpcChannelException var1, T var2);
    }

    private static class AutoClosingReadTransaction<I extends SessionFuture>
    extends AutoClosingReadContext<I, ReadOnlyTransaction>
    implements ReadOnlyTransaction {
        AutoClosingReadTransaction(Function<I, ReadOnlyTransaction> txnSupplier, SessionPool sessionPool, SessionReplacementHandler<I> sessionReplacementHandler, I session, boolean isSingleUse) {
            super(txnSupplier, sessionPool, sessionReplacementHandler, (SessionFuture)session, isSingleUse, null);
        }

        @Override
        public Timestamp getReadTimestamp() {
            return ((ReadOnlyTransaction)this.getReadContextDelegate()).getReadTimestamp();
        }
    }

    private static class AutoClosingReadContext<I extends SessionFuture, T extends ReadContext>
    implements ReadContext {
        private final Function<I, T> readContextDelegateSupplier;
        private T readContextDelegate;
        private final SessionPool sessionPool;
        private final SessionReplacementHandler<I> sessionReplacementHandler;
        private final boolean isSingleUse;
        private final AtomicInteger asyncOperationsCount = new AtomicInteger();
        private final Object lock = new Object();
        @GuardedBy(value="lock")
        private boolean sessionUsedForQuery = false;
        @GuardedBy(value="lock")
        private I session;
        @GuardedBy(value="lock")
        private boolean closed;
        @GuardedBy(value="lock")
        private boolean delegateClosed;

        private AutoClosingReadContext(Function<I, T> delegateSupplier, SessionPool sessionPool, SessionReplacementHandler<I> sessionReplacementHandler, I session, boolean isSingleUse) {
            this.readContextDelegateSupplier = delegateSupplier;
            this.sessionPool = sessionPool;
            this.sessionReplacementHandler = sessionReplacementHandler;
            this.session = session;
            this.isSingleUse = isSingleUse;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        T getReadContextDelegate() {
            Object object = this.lock;
            synchronized (object) {
                if (this.readContextDelegate == null) {
                    while (true) {
                        try {
                            this.readContextDelegate = (ReadContext)this.readContextDelegateSupplier.apply(this.session);
                        }
                        catch (SessionNotFoundException e) {
                            this.replaceSessionIfPossible(e);
                            continue;
                        }
                        break;
                    }
                }
            }
            return this.readContextDelegate;
        }

        private ResultSet wrap(final CachedResultSetSupplier resultSetSupplier) {
            return new ForwardingResultSet(resultSetSupplier){
                private boolean beforeFirst;
                {
                    super((Supplier<? extends ResultSet>)supplier);
                    this.beforeFirst = true;
                }

                @Override
                public boolean next() throws SpannerException {
                    block4: while (true) {
                        try {
                            return this.internalNext();
                        }
                        catch (SessionNotFoundException e) {
                            while (true) {
                                this.replaceSessionIfPossible(e);
                                try {
                                    this.replaceDelegate(resultSetSupplier.reload());
                                    continue block4;
                                }
                                catch (SessionNotFoundException snfe) {
                                    e = snfe;
                                    continue;
                                }
                                break;
                            }
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private boolean internalNext() {
                    try {
                        boolean ret = super.next();
                        if (this.beforeFirst) {
                            Object object = lock;
                            synchronized (object) {
                                session.get().markUsed();
                                this.beforeFirst = false;
                                sessionUsedForQuery = true;
                            }
                        }
                        if (!ret && isSingleUse) {
                            this.close();
                        }
                        return ret;
                    }
                    catch (SessionNotFoundException e) {
                        throw e;
                    }
                    catch (SpannerException e) {
                        Object object = lock;
                        synchronized (object) {
                            if (!closed && isSingleUse) {
                                session.get().setLastException(e);
                                this.close();
                            }
                        }
                        throw e;
                    }
                }

                @Override
                public void close() {
                    try {
                        super.close();
                    }
                    finally {
                        if (isSingleUse) {
                            this.close();
                        }
                    }
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void replaceSessionIfPossible(SessionNotFoundException notFound) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.isSingleUse && this.sessionUsedForQuery) {
                    throw notFound;
                }
                this.session = this.sessionReplacementHandler.replaceSession(notFound, this.session);
                this.readContextDelegate = (ReadContext)this.readContextDelegateSupplier.apply(this.session);
            }
        }

        @Override
        public ResultSet read(final String table, final KeySet keys, final Iterable<String> columns, final Options.ReadOption ... options) {
            return this.wrap(new CachedResultSetSupplier(){

                @Override
                ResultSet load() {
                    return this.getReadContextDelegate().read(table, keys, columns, options);
                }
            });
        }

        @Override
        public AsyncResultSet readAsync(final String table, final KeySet keys, final Iterable<String> columns, final Options.ReadOption ... options) {
            Options readOptions = Options.fromReadOptions(options);
            int bufferRows = readOptions.hasBufferRows() ? readOptions.bufferRows() : 10;
            return new AutoClosingReadContextAsyncResultSetImpl(this.sessionPool.sessionClient.getSpanner().getAsyncExecutorProvider(), this.wrap(new CachedResultSetSupplier(){

                @Override
                ResultSet load() {
                    return this.getReadContextDelegate().read(table, keys, columns, options);
                }
            }), bufferRows);
        }

        @Override
        public ResultSet readUsingIndex(final String table, final String index, final KeySet keys, final Iterable<String> columns, final Options.ReadOption ... options) {
            return this.wrap(new CachedResultSetSupplier(){

                @Override
                ResultSet load() {
                    return this.getReadContextDelegate().readUsingIndex(table, index, keys, columns, options);
                }
            });
        }

        @Override
        public AsyncResultSet readUsingIndexAsync(final String table, final String index, final KeySet keys, final Iterable<String> columns, final Options.ReadOption ... options) {
            Options readOptions = Options.fromReadOptions(options);
            int bufferRows = readOptions.hasBufferRows() ? readOptions.bufferRows() : 10;
            return new AutoClosingReadContextAsyncResultSetImpl(this.sessionPool.sessionClient.getSpanner().getAsyncExecutorProvider(), this.wrap(new CachedResultSetSupplier(){

                @Override
                ResultSet load() {
                    return this.getReadContextDelegate().readUsingIndex(table, index, keys, columns, options);
                }
            }), bufferRows);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public Struct readRow(String table, Key key, Iterable<String> columns) {
            while (true) {
                try {
                    Object object = this.lock;
                    synchronized (object) {
                        this.session.get().markUsed();
                    }
                    object = this.getReadContextDelegate().readRow(table, key, columns);
                    return object;
                }
                catch (SessionNotFoundException e) {
                    this.replaceSessionIfPossible(e);
                    continue;
                }
                break;
            }
            finally {
                Object object = this.lock;
                synchronized (object) {
                    this.sessionUsedForQuery = true;
                }
                if (this.isSingleUse) {
                    this.close();
                }
            }
        }

        @Override
        public ApiFuture<Struct> readRowAsync(String table, Key key, Iterable<String> columns) {
            try (AsyncResultSet rs = this.readAsync(table, KeySet.singleKey(key), columns, new Options.ReadOption[0]);){
                ApiFuture<Struct> apiFuture = AbstractReadContext.consumeSingleRowAsync(rs);
                return apiFuture;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public Struct readRowUsingIndex(String table, String index, Key key, Iterable<String> columns) {
            while (true) {
                try {
                    Object object = this.lock;
                    synchronized (object) {
                        this.session.get().markUsed();
                    }
                    object = this.getReadContextDelegate().readRowUsingIndex(table, index, key, columns);
                    return object;
                }
                catch (SessionNotFoundException e) {
                    this.replaceSessionIfPossible(e);
                    continue;
                }
                break;
            }
            finally {
                Object object = this.lock;
                synchronized (object) {
                    this.sessionUsedForQuery = true;
                }
                if (this.isSingleUse) {
                    this.close();
                }
            }
        }

        @Override
        public ApiFuture<Struct> readRowUsingIndexAsync(String table, String index, Key key, Iterable<String> columns) {
            try (AsyncResultSet rs = this.readUsingIndexAsync(table, index, KeySet.singleKey(key), columns, new Options.ReadOption[0]);){
                ApiFuture<Struct> apiFuture = AbstractReadContext.consumeSingleRowAsync(rs);
                return apiFuture;
            }
        }

        @Override
        public ResultSet executeQuery(final Statement statement, final Options.QueryOption ... options) {
            return this.wrap(new CachedResultSetSupplier(){

                @Override
                ResultSet load() {
                    return this.getReadContextDelegate().executeQuery(statement, options);
                }
            });
        }

        @Override
        public AsyncResultSet executeQueryAsync(final Statement statement, final Options.QueryOption ... options) {
            Options queryOptions = Options.fromQueryOptions(options);
            int bufferRows = queryOptions.hasBufferRows() ? queryOptions.bufferRows() : 10;
            return new AutoClosingReadContextAsyncResultSetImpl(this.sessionPool.sessionClient.getSpanner().getAsyncExecutorProvider(), this.wrap(new CachedResultSetSupplier(){

                @Override
                ResultSet load() {
                    return this.getReadContextDelegate().executeQuery(statement, options);
                }
            }), bufferRows);
        }

        @Override
        public ResultSet analyzeQuery(final Statement statement, final ReadContext.QueryAnalyzeMode queryMode) {
            return this.wrap(new CachedResultSetSupplier(){

                @Override
                ResultSet load() {
                    return this.getReadContextDelegate().analyzeQuery(statement, queryMode);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Object object = this.lock;
            synchronized (object) {
                if (this.closed && this.delegateClosed) {
                    return;
                }
                this.closed = true;
                if (this.asyncOperationsCount.get() == 0) {
                    if (this.readContextDelegate != null) {
                        this.readContextDelegate.close();
                    }
                    this.session.close();
                    this.delegateClosed = true;
                }
            }
        }

        /* synthetic */ AutoClosingReadContext(Function x0, SessionPool x1, SessionReplacementHandler x2, SessionFuture x3, boolean x4, 1 x5) {
            this(x0, x1, x2, x3, x4);
        }

        private class AutoClosingReadContextAsyncResultSetImpl
        extends AsyncResultSetImpl {
            private AutoClosingReadContextAsyncResultSetImpl(ExecutorProvider executorProvider, ResultSet delegate, int bufferRows) {
                super(executorProvider, delegate, bufferRows);
            }

            @Override
            public ApiFuture<Void> setCallback(Executor exec, AsyncResultSet.ReadyCallback cb) {
                Runnable listener = () -> {
                    Object object = AutoClosingReadContext.this.lock;
                    synchronized (object) {
                        if (AutoClosingReadContext.this.asyncOperationsCount.decrementAndGet() == 0 && AutoClosingReadContext.this.closed) {
                            AutoClosingReadContext.this.close();
                        }
                    }
                };
                try {
                    AutoClosingReadContext.this.asyncOperationsCount.incrementAndGet();
                    this.addListener(listener);
                    return super.setCallback(exec, cb);
                }
                catch (Throwable t) {
                    this.removeListener(listener);
                    AutoClosingReadContext.this.asyncOperationsCount.decrementAndGet();
                    throw t;
                }
            }
        }
    }

    private static abstract class CachedResultSetSupplier
    implements Supplier<ResultSet> {
        private ResultSet cached;

        private CachedResultSetSupplier() {
        }

        abstract ResultSet load();

        ResultSet reload() {
            this.cached = this.load();
            return this.cached;
        }

        public ResultSet get() {
            if (this.cached == null) {
                this.cached = this.load();
            }
            return this.cached;
        }
    }
}

