/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.jdbc;

import com.google.api.client.util.Preconditions;
import com.google.cloud.ByteArray;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.CommitResponse;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.connection.AutocommitDmlMode;
import com.google.cloud.spanner.connection.Connection;
import com.google.cloud.spanner.connection.ConnectionOptions;
import com.google.cloud.spanner.connection.SavepointSupport;
import com.google.cloud.spanner.connection.TransactionMode;
import com.google.cloud.spanner.connection.TransactionRetryListener;
import com.google.cloud.spanner.jdbc.AbstractJdbcConnection;
import com.google.cloud.spanner.jdbc.JdbcArray;
import com.google.cloud.spanner.jdbc.JdbcBlob;
import com.google.cloud.spanner.jdbc.JdbcClob;
import com.google.cloud.spanner.jdbc.JdbcDatabaseMetaData;
import com.google.cloud.spanner.jdbc.JdbcPreconditions;
import com.google.cloud.spanner.jdbc.JdbcPreparedStatement;
import com.google.cloud.spanner.jdbc.JdbcSavepoint;
import com.google.cloud.spanner.jdbc.JdbcSqlExceptionFactory;
import com.google.cloud.spanner.jdbc.JdbcStatement;
import com.google.cloud.spanner.jdbc.Metrics;
import com.google.cloud.spanner.jdbc.TransactionRetryListener;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nonnull;

class JdbcConnection
extends AbstractJdbcConnection {
    private static final String ONLY_RS_FORWARD_ONLY = "Only result sets of type TYPE_FORWARD_ONLY are supported";
    private static final String ONLY_CONCUR_READ_ONLY = "Only result sets with concurrency CONCUR_READ_ONLY are supported";
    private static final String ONLY_CLOSE_CURSORS_AT_COMMIT = "Only result sets with holdability CLOSE_CURSORS_AT_COMMIT are supported";
    static final String LEGACY_IS_VALID_QUERY = "SELECT 1";
    static final ImmutableList<String> NO_GENERATED_KEY_COLUMNS = ImmutableList.of();
    private Map<String, Class<?>> typeMap = new HashMap();
    private final boolean useLegacyIsValidCheck = JdbcConnection.useLegacyValidCheck();
    private final Metrics metrics;
    private final Attributes openTelemetryMetricsAttributes;

    JdbcConnection(String connectionUrl, ConnectionOptions options) throws SQLException {
        super(connectionUrl, options);
        OpenTelemetry openTelemetry = ((SpannerOptions)this.getSpanner().getOptions()).getOpenTelemetry();
        this.openTelemetryMetricsAttributes = JdbcConnection.createOpenTelemetryAttributes(this.getConnectionOptions().getDatabaseId(), false);
        this.metrics = new Metrics(openTelemetry);
    }

    static boolean useLegacyValidCheck() {
        String value = System.getProperty("spanner.jdbc.use_legacy_is_valid_check");
        if (Strings.isNullOrEmpty((String)value)) {
            value = System.getenv("SPANNER_JDBC_USE_LEGACY_IS_VALID_CHECK");
        }
        if (!Strings.isNullOrEmpty((String)value)) {
            return Boolean.parseBoolean(value);
        }
        return false;
    }

    @VisibleForTesting
    static Attributes createOpenTelemetryAttributes(DatabaseId databaseId, boolean includeConnectionId) {
        AttributesBuilder attributesBuilder = Attributes.builder();
        if (includeConnectionId) {
            attributesBuilder.put("connection_id", UUID.randomUUID().toString());
        }
        attributesBuilder.put("database", databaseId.getDatabase());
        attributesBuilder.put("instance_id", databaseId.getInstanceId().getInstance());
        attributesBuilder.put("project_id", databaseId.getInstanceId().getProject());
        return attributesBuilder.build();
    }

    public void recordClientLibLatencyMetric(long value) {
        this.metrics.recordClientLibLatency(value, this.openTelemetryMetricsAttributes);
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkClosed();
        return new JdbcStatement(this);
    }

    @Override
    public JdbcPreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, NO_GENERATED_KEY_COLUMNS);
    }

    private JdbcPreparedStatement prepareStatement(String sql, ImmutableList<String> generatedKeyColumns) throws SQLException {
        this.checkClosed();
        return new JdbcPreparedStatement(this, sql, generatedKeyColumns);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.checkClosed();
        return this.getParser().convertPositionalParametersToNamedParameters((char)'?', (String)this.getParser().removeCommentsAndTrim((String)sql)).sqlWithNamedParameters;
    }

    @Override
    public String getStatementTag() throws SQLException {
        this.checkClosed();
        return this.getSpannerConnection().getStatementTag();
    }

    @Override
    public void setStatementTag(String tag) throws SQLException {
        this.checkClosed();
        try {
            this.getSpannerConnection().setStatementTag(tag);
        }
        catch (SpannerException e) {
            throw JdbcSqlExceptionFactory.of(e);
        }
    }

    @Override
    public String getTransactionTag() throws SQLException {
        this.checkClosed();
        return this.getSpannerConnection().getTransactionTag();
    }

    @Override
    public void setTransactionTag(String tag) throws SQLException {
        this.checkClosed();
        try {
            this.getSpannerConnection().setTransactionTag(tag);
        }
        catch (SpannerException e) {
            throw JdbcSqlExceptionFactory.of(e);
        }
    }

    @Override
    public void setTransactionMode(TransactionMode mode) throws SQLException {
        this.checkClosed();
        this.getSpannerConnection().setTransactionMode(mode);
    }

    @Override
    public TransactionMode getTransactionMode() throws SQLException {
        this.checkClosed();
        return this.getSpannerConnection().getTransactionMode();
    }

    @Override
    public void setAutocommitDmlMode(AutocommitDmlMode mode) throws SQLException {
        this.checkClosed();
        this.getSpannerConnection().setAutocommitDmlMode(mode);
    }

    @Override
    public AutocommitDmlMode getAutocommitDmlMode() throws SQLException {
        this.checkClosed();
        return this.getSpannerConnection().getAutocommitDmlMode();
    }

    @Override
    public void setReadOnlyStaleness(TimestampBound staleness) throws SQLException {
        this.checkClosed();
        this.getSpannerConnection().setReadOnlyStaleness(staleness);
    }

    @Override
    public TimestampBound getReadOnlyStaleness() throws SQLException {
        this.checkClosed();
        return this.getSpannerConnection().getReadOnlyStaleness();
    }

    @Override
    public void setOptimizerVersion(String optimizerVersion) throws SQLException {
        this.checkClosed();
        this.getSpannerConnection().setOptimizerVersion(optimizerVersion);
    }

    @Override
    public String getOptimizerVersion() throws SQLException {
        this.checkClosed();
        return this.getSpannerConnection().getOptimizerVersion();
    }

    @Override
    public boolean isInTransaction() throws SQLException {
        this.checkClosed();
        return this.getSpannerConnection().isInTransaction();
    }

    @Override
    public boolean isTransactionStarted() throws SQLException {
        this.checkClosed();
        return this.getSpannerConnection().isTransactionStarted();
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkClosed();
        try {
            if (this.getSpannerConnection().isAutocommit() != autoCommit && this.getSpannerConnection().isTransactionStarted()) {
                this.commit();
            }
            this.getSpannerConnection().setAutocommit(autoCommit);
        }
        catch (SpannerException e) {
            throw JdbcSqlExceptionFactory.of(e);
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkClosed();
        return this.getSpannerConnection().isAutocommit();
    }

    @Override
    public void commit() throws SQLException {
        this.checkClosed();
        try {
            this.getSpannerConnection().commit();
        }
        catch (SpannerException e) {
            throw JdbcSqlExceptionFactory.of(e);
        }
    }

    @Override
    public void rollback() throws SQLException {
        this.checkClosed();
        try {
            this.getSpannerConnection().rollback();
        }
        catch (SpannerException e) {
            throw JdbcSqlExceptionFactory.of(e);
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            this.getSpannerConnection().close();
        }
        catch (SpannerException e) {
            throw JdbcSqlExceptionFactory.of(e);
        }
    }

    @Override
    public boolean isClosed() {
        return this.getSpannerConnection().isClosed();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkClosed();
        return new JdbcDatabaseMetaData(this);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkClosed();
        try {
            this.getSpannerConnection().setReadOnly(readOnly);
        }
        catch (SpannerException e) {
            throw JdbcSqlExceptionFactory.of(e);
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkClosed();
        return this.getSpannerConnection().isReadOnly();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        JdbcPreconditions.checkSqlFeatureSupported(resultSetType == 1003, ONLY_RS_FORWARD_ONLY);
        JdbcPreconditions.checkSqlFeatureSupported(resultSetConcurrency == 1007, ONLY_CONCUR_READ_ONLY);
        return this.createStatement();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        JdbcPreconditions.checkSqlFeatureSupported(resultSetType == 1003, ONLY_RS_FORWARD_ONLY);
        JdbcPreconditions.checkSqlFeatureSupported(resultSetConcurrency == 1007, ONLY_CONCUR_READ_ONLY);
        JdbcPreconditions.checkSqlFeatureSupported(resultSetHoldability == 2, ONLY_CLOSE_CURSORS_AT_COMMIT);
        return this.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        JdbcPreconditions.checkSqlFeatureSupported(resultSetType == 1003, ONLY_RS_FORWARD_ONLY);
        JdbcPreconditions.checkSqlFeatureSupported(resultSetConcurrency == 1007, ONLY_CONCUR_READ_ONLY);
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        JdbcPreconditions.checkSqlFeatureSupported(resultSetType == 1003, ONLY_RS_FORWARD_ONLY);
        JdbcPreconditions.checkSqlFeatureSupported(resultSetConcurrency == 1007, ONLY_CONCUR_READ_ONLY);
        JdbcPreconditions.checkSqlFeatureSupported(resultSetHoldability == 2, ONLY_CLOSE_CURSORS_AT_COMMIT);
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.prepareStatement(sql, autoGeneratedKeys == 1 ? JdbcStatement.ALL_COLUMNS : NO_GENERATED_KEY_COLUMNS);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.prepareStatement(sql, NO_GENERATED_KEY_COLUMNS);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.prepareStatement(sql, (ImmutableList<String>)(JdbcStatement.isNullOrEmpty(columnNames) ? NO_GENERATED_KEY_COLUMNS : ImmutableList.copyOf((Object[])columnNames)));
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.checkClosed();
        return new HashMap(this.typeMap);
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.checkClosed();
        this.typeMap = new HashMap(map);
    }

    boolean isUseLegacyIsValidCheck() {
        return this.useLegacyIsValidCheck;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        JdbcPreconditions.checkArgument(timeout >= 0, "timeout must be >= 0");
        if (!this.isClosed()) {
            if (this.isUseLegacyIsValidCheck()) {
                return this.legacyIsValid(timeout);
            }
            try {
                return this.getDialect() != null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean legacyIsValid(int timeout) throws SQLException {
        try (Statement statement = this.createStatement();){
            statement.setQueryTimeout(timeout);
            try (ResultSet rs = statement.executeQuery(LEGACY_IS_VALID_QUERY);){
                if (!rs.next()) return false;
                if (rs.getLong(1) != 1L) return false;
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.checkClosed();
        return new JdbcBlob();
    }

    @Override
    public Clob createClob() throws SQLException {
        this.checkClosed();
        return new JdbcClob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.checkClosed();
        return new JdbcClob();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.checkClosed();
        return JdbcArray.createArray(typeName, elements);
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkClosed();
        this.checkValidCatalog(catalog);
    }

    void checkValidCatalog(String catalog) throws SQLException {
        String defaultCatalog = this.getDefaultCatalog();
        JdbcPreconditions.checkArgument(defaultCatalog.equals(catalog), String.format("Only catalog %s is supported", defaultCatalog));
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkClosed();
        return this.getDefaultCatalog();
    }

    @Nonnull
    String getDefaultCatalog() {
        switch (this.getDialect()) {
            case POSTGRESQL: {
                String database = this.getConnectionOptions().getDatabaseName();
                return database == null ? "" : database;
            }
        }
        return "";
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.checkClosed();
        this.checkValidSchema(schema);
    }

    void checkValidSchema(String schema) throws SQLException {
        String defaultSchema = this.getDefaultSchema();
        JdbcPreconditions.checkArgument(defaultSchema.equals(schema), String.format("Only schema %s is supported", defaultSchema));
    }

    @Override
    public String getSchema() throws SQLException {
        this.checkClosed();
        return this.getDefaultSchema();
    }

    @Nonnull
    String getDefaultSchema() {
        return this.getDialect().getDefaultSchema();
    }

    @Override
    public SavepointSupport getSavepointSupport() throws SQLException {
        this.checkClosed();
        return this.getSpannerConnection().getSavepointSupport();
    }

    @Override
    public void setSavepointSupport(SavepointSupport savepointSupport) throws SQLException {
        this.checkClosed();
        try {
            this.getSpannerConnection().setSavepointSupport(savepointSupport);
        }
        catch (SpannerException e) {
            throw JdbcSqlExceptionFactory.of(e);
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.checkClosed();
        try {
            JdbcSavepoint savepoint = JdbcSavepoint.unnamed();
            this.getSpannerConnection().savepoint(savepoint.internalGetSavepointName());
            return savepoint;
        }
        catch (SpannerException e) {
            throw JdbcSqlExceptionFactory.of(e);
        }
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.checkClosed();
        try {
            JdbcSavepoint savepoint = JdbcSavepoint.named(name);
            this.getSpannerConnection().savepoint(savepoint.internalGetSavepointName());
            return savepoint;
        }
        catch (SpannerException e) {
            throw JdbcSqlExceptionFactory.of(e);
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        JdbcPreconditions.checkArgument(savepoint instanceof JdbcSavepoint, savepoint);
        JdbcSavepoint jdbcSavepoint = (JdbcSavepoint)savepoint;
        try {
            this.getSpannerConnection().rollbackToSavepoint(jdbcSavepoint.internalGetSavepointName());
        }
        catch (SpannerException e) {
            throw JdbcSqlExceptionFactory.of(e);
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        JdbcPreconditions.checkArgument(savepoint instanceof JdbcSavepoint, savepoint);
        JdbcSavepoint jdbcSavepoint = (JdbcSavepoint)savepoint;
        try {
            this.getSpannerConnection().releaseSavepoint(jdbcSavepoint.internalGetSavepointName());
        }
        catch (SpannerException e) {
            throw JdbcSqlExceptionFactory.of(e);
        }
    }

    @Override
    public java.sql.Timestamp getCommitTimestamp() throws SQLException {
        this.checkClosed();
        try {
            return this.getSpannerConnection().getCommitTimestamp().toSqlTimestamp();
        }
        catch (SpannerException e) {
            throw JdbcSqlExceptionFactory.of(e);
        }
    }

    @Override
    public CommitResponse getCommitResponse() throws SQLException {
        this.checkClosed();
        try {
            return this.getSpannerConnection().getCommitResponse();
        }
        catch (SpannerException e) {
            throw JdbcSqlExceptionFactory.of(e);
        }
    }

    @Override
    public void setReturnCommitStats(boolean returnCommitStats) throws SQLException {
        this.checkClosed();
        try {
            this.getSpannerConnection().setReturnCommitStats(returnCommitStats);
        }
        catch (SpannerException e) {
            throw JdbcSqlExceptionFactory.of(e);
        }
    }

    @Override
    public boolean isReturnCommitStats() throws SQLException {
        this.checkClosed();
        try {
            return this.getSpannerConnection().isReturnCommitStats();
        }
        catch (SpannerException e) {
            throw JdbcSqlExceptionFactory.of(e);
        }
    }

    @Override
    public java.sql.Timestamp getReadTimestamp() throws SQLException {
        this.checkClosed();
        try {
            return this.getSpannerConnection().getReadTimestamp().toSqlTimestamp();
        }
        catch (SpannerException e) {
            throw JdbcSqlExceptionFactory.of(e);
        }
    }

    @Override
    public boolean isRetryAbortsInternally() throws SQLException {
        this.checkClosed();
        try {
            return this.getSpannerConnection().isRetryAbortsInternally();
        }
        catch (SpannerException e) {
            throw JdbcSqlExceptionFactory.of(e);
        }
    }

    @Override
    public void setRetryAbortsInternally(boolean retryAbortsInternally) throws SQLException {
        this.checkClosed();
        try {
            this.getSpannerConnection().setRetryAbortsInternally(retryAbortsInternally);
        }
        catch (SpannerException e) {
            throw JdbcSqlExceptionFactory.of(e);
        }
    }

    @Override
    public void write(Mutation mutation) throws SQLException {
        this.checkClosed();
        try {
            this.getSpannerConnection().write(mutation);
        }
        catch (SpannerException e) {
            throw JdbcSqlExceptionFactory.of(e);
        }
    }

    @Override
    public void write(Iterable<Mutation> mutations) throws SQLException {
        this.checkClosed();
        try {
            this.getSpannerConnection().write(mutations);
        }
        catch (SpannerException e) {
            throw JdbcSqlExceptionFactory.of(e);
        }
    }

    @Override
    public void bufferedWrite(Mutation mutation) throws SQLException {
        this.checkClosed();
        try {
            this.getSpannerConnection().bufferedWrite(mutation);
        }
        catch (SpannerException e) {
            throw JdbcSqlExceptionFactory.of(e);
        }
    }

    @Override
    public void bufferedWrite(Iterable<Mutation> mutations) throws SQLException {
        this.checkClosed();
        try {
            this.getSpannerConnection().bufferedWrite(mutations);
        }
        catch (SpannerException e) {
            throw JdbcSqlExceptionFactory.of(e);
        }
    }

    private <T> void set(BiConsumer<Connection, T> setter, T value) throws SQLException {
        this.checkClosed();
        try {
            setter.accept(this.getSpannerConnection(), (Connection)value);
        }
        catch (SpannerException spannerException) {
            throw JdbcSqlExceptionFactory.of(spannerException);
        }
    }

    private <R> R get(Function<Connection, R> getter) throws SQLException {
        this.checkClosed();
        try {
            return getter.apply(this.getSpannerConnection());
        }
        catch (SpannerException spannerException) {
            throw JdbcSqlExceptionFactory.of(spannerException);
        }
    }

    @Override
    public void setDataBoostEnabled(boolean dataBoostEnabled) throws SQLException {
        this.set(Connection::setDataBoostEnabled, dataBoostEnabled);
    }

    @Override
    public boolean isDataBoostEnabled() throws SQLException {
        return this.get(Connection::isDataBoostEnabled);
    }

    @Override
    public void setAutoPartitionMode(boolean autoPartitionMode) throws SQLException {
        this.set(Connection::setAutoPartitionMode, autoPartitionMode);
    }

    @Override
    public boolean isAutoPartitionMode() throws SQLException {
        return this.get(Connection::isAutoPartitionMode);
    }

    @Override
    public void setMaxPartitions(int maxPartitions) throws SQLException {
        this.set(Connection::setMaxPartitions, maxPartitions);
    }

    @Override
    public int getMaxPartitions() throws SQLException {
        return this.get(Connection::getMaxPartitions);
    }

    @Override
    public void setMaxPartitionedParallelism(int maxThreads) throws SQLException {
        this.set(Connection::setMaxPartitionedParallelism, maxThreads);
    }

    @Override
    public int getMaxPartitionedParallelism() throws SQLException {
        return this.get(Connection::getMaxPartitionedParallelism);
    }

    @Override
    public void addTransactionRetryListener(TransactionRetryListener listener) throws SQLException {
        this.checkClosed();
        this.getSpannerConnection().addTransactionRetryListener((com.google.cloud.spanner.connection.TransactionRetryListener)new JdbcToSpannerTransactionRetryListener(listener));
    }

    @Override
    public void addTransactionRetryListener(com.google.cloud.spanner.connection.TransactionRetryListener listener) throws SQLException {
        this.checkClosed();
        this.getSpannerConnection().addTransactionRetryListener(listener);
    }

    @Override
    public boolean removeTransactionRetryListener(TransactionRetryListener listener) throws SQLException {
        this.checkClosed();
        return this.getSpannerConnection().removeTransactionRetryListener((com.google.cloud.spanner.connection.TransactionRetryListener)new JdbcToSpannerTransactionRetryListener(listener));
    }

    @Override
    public boolean removeTransactionRetryListener(com.google.cloud.spanner.connection.TransactionRetryListener listener) throws SQLException {
        this.checkClosed();
        return this.getSpannerConnection().removeTransactionRetryListener(listener);
    }

    @Override
    public Iterator<TransactionRetryListener> getTransactionRetryListeners() throws SQLException {
        this.checkClosed();
        return Iterators.transform((Iterator)this.getSpannerConnection().getTransactionRetryListeners(), input -> {
            if (input instanceof JdbcToSpannerTransactionRetryListener) {
                return ((JdbcToSpannerTransactionRetryListener)input).delegate;
            }
            return null;
        });
    }

    @Override
    public Iterator<com.google.cloud.spanner.connection.TransactionRetryListener> getTransactionRetryListenersFromConnection() throws SQLException {
        this.checkClosed();
        return this.getSpannerConnection().getTransactionRetryListeners();
    }

    @Override
    public void setProtoDescriptors(@Nonnull byte[] protoDescriptors) throws SQLException {
        Preconditions.checkNotNull((Object)protoDescriptors);
        this.checkClosed();
        try {
            this.getSpannerConnection().setProtoDescriptors(protoDescriptors);
        }
        catch (SpannerException e) {
            throw JdbcSqlExceptionFactory.of(e);
        }
    }

    @Override
    public void setProtoDescriptors(@Nonnull InputStream protoDescriptors) throws SQLException, IOException {
        Preconditions.checkNotNull((Object)protoDescriptors);
        this.checkClosed();
        try {
            this.getSpannerConnection().setProtoDescriptors(ByteArray.copyFrom((InputStream)protoDescriptors).toByteArray());
        }
        catch (SpannerException e) {
            throw JdbcSqlExceptionFactory.of(e);
        }
    }

    @Override
    public byte[] getProtoDescriptors() throws SQLException {
        this.checkClosed();
        return this.getSpannerConnection().getProtoDescriptors();
    }

    private static final class JdbcToSpannerTransactionRetryListener
    implements com.google.cloud.spanner.connection.TransactionRetryListener {
        private final TransactionRetryListener delegate;

        JdbcToSpannerTransactionRetryListener(TransactionRetryListener delegate) {
            this.delegate = (TransactionRetryListener)Preconditions.checkNotNull((Object)delegate);
        }

        public void retryStarting(Timestamp transactionStarted, long transactionId, int retryAttempt) {
            this.delegate.retryStarting(transactionStarted, transactionId, retryAttempt);
        }

        public void retryFinished(Timestamp transactionStarted, long transactionId, int retryAttempt, TransactionRetryListener.RetryResult result) {
            this.delegate.retryFinished(transactionStarted, transactionId, retryAttempt, TransactionRetryListener.RetryResult.valueOf(result.name()));
        }

        public boolean equals(Object o) {
            if (!(o instanceof JdbcToSpannerTransactionRetryListener)) {
                return false;
            }
            JdbcToSpannerTransactionRetryListener other = (JdbcToSpannerTransactionRetryListener)o;
            return this.delegate.equals(other.delegate);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }
    }
}

