/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.jdbc;

import com.google.cloud.spanner.jdbc.JdbcPreconditions;
import com.google.cloud.spanner.jdbc.JdbcSqlExceptionFactory;
import com.google.common.base.Preconditions;
import com.google.rpc.Code;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;

class JdbcBlob
implements Blob {
    private byte[] value = new byte[0];

    JdbcBlob() {
    }

    JdbcBlob(byte[] value) {
        this.value = value;
    }

    private void checkPosition(long pos) {
        Preconditions.checkArgument((pos + 1L <= Integer.MAX_VALUE ? 1 : 0) != 0, (Object)"position larger than 2147483647 is not supported");
    }

    private void checkLength(long length) {
        Preconditions.checkArgument((length <= Integer.MAX_VALUE ? 1 : 0) != 0, (Object)"length larger than 2147483647 is not supported");
    }

    private void checkPositionPlusLength(long pos, long length) {
        Preconditions.checkArgument((pos + 1L + length <= Integer.MAX_VALUE ? 1 : 0) != 0, (Object)"position+length larger than 2147483647 is not supported");
    }

    @Override
    public long length() {
        return this.value.length;
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        JdbcPreconditions.checkArgument(pos > 0L, "pos must be >= 1");
        JdbcPreconditions.checkArgument(length >= 0, "length must be >= 0");
        this.checkPosition(pos);
        this.checkPositionPlusLength(pos, length);
        int end = (int)pos + length - 1;
        int blobLength = (int)this.length();
        if (end > blobLength) {
            length = blobLength - (int)pos + 1;
        }
        byte[] res = new byte[length];
        System.arraycopy(this.value, (int)pos - 1, res, 0, length);
        return res;
    }

    @Override
    public InputStream getBinaryStream() {
        return new ByteArrayInputStream(this.value);
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        JdbcPreconditions.checkArgument(pattern != null && pattern.length > 0, "pattern must not be empty");
        JdbcPreconditions.checkArgument(start > 0L, "start must be >= 1");
        this.checkPosition(start);
        for (int outerIndex = (int)start - 1; outerIndex < this.value.length; ++outerIndex) {
            int innerIndex = 0;
            for (int valueIndex = outerIndex; valueIndex < this.value.length && innerIndex < pattern.length && this.value[valueIndex] == pattern[innerIndex]; ++innerIndex, ++valueIndex) {
            }
            if (innerIndex != pattern.length) continue;
            return outerIndex + 1;
        }
        return -1L;
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        JdbcPreconditions.checkArgument(pattern != null, "pattern must not be empty");
        JdbcPreconditions.checkArgument(start > 0L, "start must be >= 1");
        this.checkPosition(start);
        byte[] buffer = new byte[1024];
        int totalSize = 0;
        ArrayList<byte[]> totalBytes = new ArrayList<byte[]>();
        try (InputStream is = pattern.getBinaryStream();){
            int bytesRead;
            while ((bytesRead = is.read(buffer)) > -1) {
                if (bytesRead == buffer.length) {
                    totalBytes.add(buffer);
                } else {
                    byte[] dest = new byte[bytesRead];
                    System.arraycopy(buffer, 0, dest, 0, bytesRead);
                    totalBytes.add(dest);
                }
                totalSize += bytesRead;
                buffer = new byte[1024];
            }
        }
        catch (IOException e) {
            throw JdbcSqlExceptionFactory.of("reading blob failed", Code.UNKNOWN, e);
        }
        byte[] bytePattern = new byte[totalSize];
        int index = 0;
        for (byte[] b : totalBytes) {
            System.arraycopy(b, 0, bytePattern, index, b.length);
            index += b.length;
        }
        return this.position(bytePattern, start);
    }

    private void setLength(int length) {
        int prevLength = this.value.length;
        byte[] newValue = new byte[length];
        System.arraycopy(this.value, 0, newValue, 0, Math.min(prevLength, newValue.length));
        this.value = newValue;
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        JdbcPreconditions.checkArgument(bytes != null, "bytes must be non-null");
        JdbcPreconditions.checkArgument(pos > 0L, "pos must be >= 1");
        this.checkPosition(pos);
        int end = (int)pos + bytes.length - 1;
        if (end >= this.value.length) {
            this.setLength(end);
        }
        System.arraycopy(bytes, 0, this.value, (int)pos - 1, bytes.length);
        return bytes.length;
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        JdbcPreconditions.checkArgument(bytes != null, "bytes must be non-null");
        JdbcPreconditions.checkArgument(pos > 0L, "pos must be >= 1");
        JdbcPreconditions.checkArgument(offset >= 0, "offset must be >= 0");
        JdbcPreconditions.checkArgument(len >= 0, "len must be >= 0");
        this.checkPosition(pos);
        if (offset > bytes.length) {
            offset = 0;
            len = 0;
        } else if (offset + len > bytes.length) {
            len = bytes.length - offset;
        }
        int end = (int)pos + len - 1;
        if (end >= this.value.length) {
            this.setLength(end);
        }
        System.arraycopy(bytes, offset, this.value, (int)pos - 1, len);
        return len;
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        JdbcPreconditions.checkArgument(pos > 0L, "pos must be >= 1");
        this.checkPosition(pos);
        return new BlobOutputStream((int)pos);
    }

    @Override
    public void truncate(long len) throws SQLException {
        JdbcPreconditions.checkArgument(len >= 0L, "len must be >= 0");
        this.checkLength(len);
        this.setLength((int)len);
    }

    @Override
    public void free() {
        this.setLength(0);
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        JdbcPreconditions.checkArgument(pos > 0L, "pos must be >= 1");
        JdbcPreconditions.checkArgument(length >= 0L, "length must be >= 0");
        this.checkPosition(pos);
        this.checkPositionPlusLength(pos, length);
        if (pos + length > (long)this.value.length) {
            length = (long)this.value.length - pos + 1L;
        }
        byte[] buffer = new byte[(int)length];
        System.arraycopy(this.value, (int)pos - 1, buffer, 0, (int)length);
        return new ByteArrayInputStream(buffer);
    }

    public boolean equals(Object other) {
        if (!(other instanceof JdbcBlob)) {
            return false;
        }
        JdbcBlob blob = (JdbcBlob)other;
        return Arrays.equals(this.value, blob.value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    private final class BlobOutputStream
    extends OutputStream {
        private byte[] buffer = new byte[1024];
        private int currentPos = 0;
        private int blobPosition;

        private BlobOutputStream(int pos) {
            this.blobPosition = pos;
        }

        @Override
        public void write(int b) {
            if (this.currentPos >= this.buffer.length) {
                byte[] newBuffer = new byte[this.buffer.length * 2];
                System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
                this.buffer = newBuffer;
            }
            this.buffer[this.currentPos] = (byte)b;
            ++this.currentPos;
        }

        @Override
        public void flush() throws IOException {
            try {
                JdbcBlob.this.setBytes(this.blobPosition, this.buffer, 0, this.currentPos);
                this.blobPosition += this.currentPos;
                this.currentPos = 0;
                Arrays.fill(this.buffer, (byte)0);
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
        }

        @Override
        public void close() throws IOException {
            this.flush();
        }
    }
}

