/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.util.Strings;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class TimeCodec
implements TypeCodec<LocalTime> {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss.SSSSSSSSS");

    @Override
    @NonNull
    public GenericType<LocalTime> getJavaType() {
        return GenericType.LOCAL_TIME;
    }

    @Override
    @NonNull
    public DataType getCqlType() {
        return DataTypes.TIME;
    }

    @Override
    public boolean accepts(@NonNull Object value) {
        return value instanceof LocalTime;
    }

    @Override
    public boolean accepts(@NonNull Class<?> javaClass) {
        return javaClass == LocalTime.class;
    }

    @Override
    @Nullable
    public ByteBuffer encode(@Nullable LocalTime value, @NonNull ProtocolVersion protocolVersion) {
        return value == null ? null : TypeCodecs.BIGINT.encodePrimitive(value.toNanoOfDay(), protocolVersion);
    }

    @Override
    @Nullable
    public LocalTime decode(@Nullable ByteBuffer bytes, @NonNull ProtocolVersion protocolVersion) {
        if (bytes == null || bytes.remaining() == 0) {
            return null;
        }
        long nanosOfDay = TypeCodecs.BIGINT.decodePrimitive(bytes, protocolVersion);
        return LocalTime.ofNanoOfDay(nanosOfDay);
    }

    @Override
    @NonNull
    public String format(@Nullable LocalTime value) {
        return value == null ? "NULL" : Strings.quote(FORMATTER.format(value));
    }

    @Override
    @Nullable
    public LocalTime parse(@Nullable String value) {
        if (value == null || value.isEmpty() || value.equalsIgnoreCase("NULL")) {
            return null;
        }
        if (!Strings.isQuoted(value)) {
            throw new IllegalArgumentException("time values must be enclosed by single quotes");
        }
        if (Strings.isLongLiteral(value = value.substring(1, value.length() - 1))) {
            try {
                return LocalTime.ofNanoOfDay(Long.parseLong(value));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("Cannot parse time value from \"%s\"", value), e);
            }
        }
        try {
            return LocalTime.parse(value);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException(String.format("Cannot parse time value from \"%s\"", value), e);
        }
    }
}

