/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc42.internal.apache.http.impl.client;

import com.databricks.client.jdbc42.internal.apache.http.HttpConnection;
import com.databricks.client.jdbc42.internal.apache.http.annotation.Contract;
import com.databricks.client.jdbc42.internal.apache.http.annotation.ThreadingBehavior;
import com.databricks.client.jdbc42.internal.apache.http.auth.AuthScheme;
import com.databricks.client.jdbc42.internal.apache.http.auth.AuthState;
import com.databricks.client.jdbc42.internal.apache.http.auth.Credentials;
import com.databricks.client.jdbc42.internal.apache.http.client.UserTokenHandler;
import com.databricks.client.jdbc42.internal.apache.http.client.protocol.HttpClientContext;
import com.databricks.client.jdbc42.internal.apache.http.conn.ManagedHttpClientConnection;
import com.databricks.client.jdbc42.internal.apache.http.protocol.HttpContext;
import java.security.Principal;
import javax.net.ssl.SSLSession;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class DefaultUserTokenHandler
implements UserTokenHandler {
    public static final DefaultUserTokenHandler INSTANCE = new DefaultUserTokenHandler();

    @Override
    public Object getUserToken(HttpContext context) {
        SSLSession sslsession;
        HttpConnection conn;
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        Principal userPrincipal = null;
        AuthState targetAuthState = clientContext.getTargetAuthState();
        if (targetAuthState != null && (userPrincipal = DefaultUserTokenHandler.getAuthPrincipal(targetAuthState)) == null) {
            AuthState proxyAuthState = clientContext.getProxyAuthState();
            userPrincipal = DefaultUserTokenHandler.getAuthPrincipal(proxyAuthState);
        }
        if (userPrincipal == null && (conn = clientContext.getConnection()).isOpen() && conn instanceof ManagedHttpClientConnection && (sslsession = ((ManagedHttpClientConnection)conn).getSSLSession()) != null) {
            userPrincipal = sslsession.getLocalPrincipal();
        }
        return userPrincipal;
    }

    private static Principal getAuthPrincipal(AuthState authState) {
        Credentials creds;
        AuthScheme scheme = authState.getAuthScheme();
        if (scheme != null && scheme.isComplete() && scheme.isConnectionBased() && (creds = authState.getCredentials()) != null) {
            return creds.getUserPrincipal();
        }
        return null;
    }
}

