/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc.utils;

import com.databricks.client.jdbc.core.DSDriver;
import com.databricks.client.jdbc.exceptions.CommonJDBCMessageKey;
import com.databricks.client.jdbc.utils.DSStringCache;
import com.databricks.client.jdbc.utils.DSStringCacheEntry;
import com.databricks.client.jdbc.utils.DSStringMemoryCache;
import com.databricks.client.support.ILogger;
import com.databricks.client.support.LogUtilities;
import com.databricks.client.support.exceptions.ErrorException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.NonWritableChannelException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;

public class DSStringFileCache
extends DSStringCache {
    private static final String NEW_LINE = "\n";
    private static final String READ_WRITE = "rw";
    private static final String SYSTEM_CURRENT_USER = "user.name";
    private DSStringMemoryCache m_DSMemoryCache;
    private String m_filePath;
    private char m_delimiterChar;

    public DSStringFileCache(ILogger iLogger, String string, boolean bl, boolean bl2, char c) {
        super(iLogger, bl, bl2);
        this.m_DSMemoryCache = new DSStringMemoryCache(iLogger, bl, bl2);
        this.m_filePath = string;
        this.m_delimiterChar = c;
    }

    @Override
    public String getValue(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.syncMemoryCacheWithFileCache();
        return this.m_DSMemoryCache.getValue(string);
    }

    @Override
    public long getExpiry(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.syncMemoryCacheWithFileCache();
        return this.m_DSMemoryCache.getExpiry(string);
    }

    @Override
    public boolean setValue(String string, String string2, long l) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (string != null && string2 != null && this.m_DSMemoryCache.setValue(string, string2, l)) {
            this.syncMemoryCacheWithFileCache();
            return true;
        }
        return false;
    }

    public Collection<DSStringCacheEntry> readFromCacheFile() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        HashSet<DSStringCacheEntry> hashSet = new HashSet<DSStringCacheEntry>();
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(this.m_filePath, READ_WRITE);
             FileChannel fileChannel = randomAccessFile.getChannel();
             FileLock fileLock = fileChannel.lock();){
            String string = randomAccessFile.readLine();
            while (string != null) {
                String[] stringArray = string.split(String.valueOf(this.m_delimiterChar));
                DSStringCacheEntry dSStringCacheEntry = new DSStringCacheEntry(stringArray[0], stringArray[1], Long.parseLong(stringArray[2]));
                hashSet.add(dSStringCacheEntry);
                string = randomAccessFile.readLine();
            }
        }
        catch (IOException | NonWritableChannelException exception) {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CACHE_FILE_OPERATION_ERROR.name(), exception.getMessage(), exception.getCause());
            throw errorException;
        }
        return hashSet;
    }

    private boolean syncMemoryCacheWithFileCache() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_DSMemoryCache.addValuesWithoutReplacement(this.readFromCacheFile());
        File file = new File(this.m_filePath);
        file.delete();
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(this.m_filePath, READ_WRITE);
             FileChannel fileChannel = randomAccessFile.getChannel();
             FileLock fileLock = fileChannel.tryLock();){
            this.setFilePermissions();
            for (DSStringCacheEntry dSStringCacheEntry : this.m_DSMemoryCache.getValues()) {
                String string = dSStringCacheEntry.key + this.m_delimiterChar + dSStringCacheEntry.value + this.m_delimiterChar + String.valueOf(dSStringCacheEntry.expiry) + NEW_LINE;
                ByteBuffer byteBuffer = ByteBuffer.wrap(string.getBytes());
                fileChannel.write(byteBuffer);
            }
        }
        catch (IOException iOException) {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CACHE_FILE_OPERATION_ERROR.name(), iOException.getMessage(), iOException.getCause());
            throw errorException;
        }
        return true;
    }

    private boolean setFilePermissions() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        Path path = Paths.get(this.m_filePath, new String[0]);
        UserPrincipal userPrincipal = null;
        try {
            UserPrincipalLookupService userPrincipalLookupService = path.getFileSystem().getUserPrincipalLookupService();
            userPrincipal = userPrincipalLookupService.lookupPrincipalByName(System.getProperty(SYSTEM_CURRENT_USER));
            EnumSet<AclEntryPermission> enumSet = EnumSet.allOf(AclEntryPermission.class);
            AclEntry aclEntry = AclEntry.newBuilder().setType(AclEntryType.ALLOW).setPrincipal(userPrincipal).setPermissions(enumSet).build();
            AclFileAttributeView aclFileAttributeView = Files.getFileAttributeView(path, AclFileAttributeView.class, new LinkOption[0]);
            List<AclEntry> list = Collections.singletonList(aclEntry);
            aclFileAttributeView.setAcl(list);
        }
        catch (Exception exception) {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CACHE_FILE_OPERATION_ERROR.name(), exception.getMessage(), exception.getCause());
            throw errorException;
        }
        return true;
    }
}

