/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc.kerberos;

import com.databricks.client.jdbc.core.DSDriver;
import com.databricks.client.jdbc.exceptions.CommonJDBCMessageKey;
import com.databricks.client.jdbc.kerberos.IBMKerberosAuthenticationHelper;
import com.databricks.client.jdbc.kerberos.JaasConfiguration;
import com.databricks.client.jdbc.kerberos.KerberosAuthenticationHelper;
import com.databricks.client.support.ILogger;
import com.databricks.client.support.LogUtilities;
import com.databricks.client.support.exceptions.ErrorException;
import java.io.FileNotFoundException;
import java.security.AccessController;
import java.util.HashMap;
import javax.security.auth.Subject;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class Kerberos {
    private static String AUTH_LOGIN_CONFIG = "java.security.auth.login.config";
    private static String JAAS_DISABLED_EXCEPTION_STR = "JAAS is not enabled in your configuration";
    private static String JAAS_ENABLE_VALUE = "1";
    private static String JDBC_ENABLE_JAAS_ENV_KEY = "JDBC_ENABLE_JAAS";

    public static Subject getSubjectViaEnvJAASConfig(ILogger iLogger) throws LoginException, ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        Kerberos.throwIfJAASDisabled(iLogger);
        String string = System.getProperty(AUTH_LOGIN_CONFIG);
        if (null == string) {
            String string2 = System.getenv("JAAS_CONFIG");
            if (null != string2) {
                System.setProperty(AUTH_LOGIN_CONFIG, string2);
                LogUtilities.logInfo(AUTH_LOGIN_CONFIG + " is set using enviroment variable 'JAAS_CONFIG' to:" + string2, iLogger);
            } else {
                LogUtilities.logDebug(AUTH_LOGIN_CONFIG + " is not set", iLogger);
            }
        } else {
            LogUtilities.logInfo("java.security.auth.login.config is already set to: " + string, iLogger);
        }
        return Kerberos.getSubjectViaJAASConfig(iLogger);
    }

    public static Subject getSubjectViaJAASConfig(ILogger iLogger) throws LoginException, ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        Kerberos.throwIfJAASDisabled(iLogger);
        String string = System.getProperty(AUTH_LOGIN_CONFIG);
        if (null != string) {
            LogUtilities.logDebug("System.getProperty(" + AUTH_LOGIN_CONFIG + "): " + string, iLogger);
            if (null != System.getenv("KRB5_CONFIG")) {
                System.setProperty("java.security.krb5.conf", System.getenv("KRB5_CONFIG"));
            }
            Configuration configuration = Configuration.getConfiguration();
            LoginContext loginContext = new LoginContext("Client", null, null, configuration);
            loginContext.login();
            return loginContext.getSubject();
        }
        return null;
    }

    public static Subject getSubjectViaAccessControlContext(ILogger iLogger) {
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        return Subject.getSubject(AccessController.getContext());
    }

    public static Subject getSubjectViaTicketCache(ILogger iLogger) throws LoginException {
        Object object;
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        if (null != System.getenv("KRB5_CONFIG")) {
            System.setProperty("java.security.krb5.conf", System.getenv("KRB5_CONFIG"));
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Configuration configuration = null;
        if ("IBM Corporation".equals(System.getProperty("java.vendor"))) {
            hashMap.put("refreshKrb5Config", "true");
            hashMap.put("useDefaultCcache", "true");
            hashMap.put("renewTGT", "true");
            hashMap.put("credsType", "initiator");
            configuration = new IBMKerberosAuthenticationHelper(hashMap);
        } else {
            object = System.getenv("KRB5CCNAME");
            if (null != object) {
                hashMap.put("ticketCache", (String)object);
            }
            hashMap.put("doNotPrompt", "true");
            hashMap.put("renewTGT", "true");
            hashMap.put("useTicketCache", "true");
            configuration = new KerberosAuthenticationHelper(hashMap);
        }
        object = new LoginContext("Client", null, null, configuration);
        ((LoginContext)object).login();
        return ((LoginContext)object).getSubject();
    }

    public static Subject getSubjectViaCustomJAASConfig(String string, ILogger iLogger) throws LoginException, FileNotFoundException, ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, string);
        Kerberos.throwIfJAASDisabled(iLogger);
        JaasConfiguration jaasConfiguration = new JaasConfiguration(string);
        LoginContext loginContext = new LoginContext("Client", null, null, jaasConfiguration);
        loginContext.login();
        return loginContext.getSubject();
    }

    private static void throwIfJAASDisabled(ILogger iLogger) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        String string = System.getenv(JDBC_ENABLE_JAAS_ENV_KEY);
        if (null == string || !string.equals(JAAS_ENABLE_VALUE)) {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.UNSUPPORTED_OPERATION_ERR.name(), JAAS_DISABLED_EXCEPTION_STR);
            throw errorException;
        }
    }
}

