/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.hivecommon.api;

import com.databricks.client.hivecommon.api.SSOSettings;
import com.databricks.client.hivecommon.api.TEHTTPSettings;
import com.databricks.client.hivecommon.api.TETHttpClient;
import com.databricks.client.hivecommon.exceptions.TEHttpSSORedirectException;
import com.databricks.client.jdbc42.internal.apache.http.HttpResponse;
import com.databricks.client.jdbc42.internal.apache.http.client.CookieStore;
import com.databricks.client.jdbc42.internal.apache.http.client.HttpClient;
import com.databricks.client.jdbc42.internal.apache.thrift.transport.TTransportException;
import com.databricks.client.support.ILogger;

public class SSOSAMLTHttpClient
extends TETHttpClient {
    public static final String SSO_CLIENT_IDENTIFIER = "X-Hive-Client-Identifier";
    public static final String SSO_DEV_CLIENT_IDENTIFIER = "X-Client-Identifier";
    private SSOSettings m_ssoSettings;

    public SSOSAMLTHttpClient(String string, HttpClient httpClient, TEHTTPSettings tEHTTPSettings, SSOSettings sSOSettings, CookieStore cookieStore, ILogger iLogger) throws TTransportException {
        super(string, httpClient, tEHTTPSettings, cookieStore, iLogger);
        this.m_ssoSettings = sSOSettings;
    }

    public static String getClientIdentifierHeaderKey(SSOSettings sSOSettings) {
        return sSOSettings.m_ssoTestingUseDevHeaders ? SSO_DEV_CLIENT_IDENTIFIER : SSO_CLIENT_IDENTIFIER;
    }

    @Override
    protected void handleErrorResponse(HttpResponse httpResponse) throws TTransportException {
        int n = httpResponse.getStatusLine().getStatusCode();
        if (this.m_settings.m_throwDifferentExceptionOnRedirect && 302 == n) {
            throw new TEHttpSSORedirectException(httpResponse, this.extractThriftHeaderError(httpResponse), SSOSAMLTHttpClient.getClientIdentifierHeaderKey(this.m_ssoSettings));
        }
        super.handleErrorResponse(httpResponse);
    }
}

