/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.community.database.db2z;

import java.sql.SQLException;
import java.util.List;
import java.util.regex.Pattern;
import org.flywaydb.community.database.db2z.DB2ZJdbcTemplate;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.jdbc.Result;
import org.flywaydb.core.internal.jdbc.Results;
import org.flywaydb.core.internal.sqlscript.Delimiter;
import org.flywaydb.core.internal.sqlscript.ParsedSqlStatement;
import org.flywaydb.core.internal.sqlscript.SqlScriptExecutor;

public class DB2ZCallProcedureParsedStatement
extends ParsedSqlStatement {
    private final String procedureName;
    private final Object[] parms;
    private static final Pattern DB2Z_DSNUTILU_PROCNAME = Pattern.compile("\"?SYSPROC\"?\\.\"?DSNUTILU\"?", 2);

    public DB2ZCallProcedureParsedStatement(int pos, int line, int col, String sql, Delimiter delimiter, boolean canExecuteInTransaction, boolean batchable, String procedureName, Object[] parms) {
        super(pos, line, col, sql, delimiter, canExecuteInTransaction, batchable);
        this.procedureName = procedureName;
        this.parms = parms;
    }

    public Results execute(JdbcTemplate jdbcTemplate, SqlScriptExecutor sqlScriptExecutor, Configuration config) {
        String lastMessage;
        List lastResultRow;
        List resultData;
        Result result;
        List resultList;
        String callStmt = "CALL " + this.procedureName + "(";
        for (int i = 0; i < this.parms.length; ++i) {
            callStmt = callStmt + (i > 0 ? ", ?" : "?");
        }
        callStmt = callStmt + ")";
        Results results = ((DB2ZJdbcTemplate)jdbcTemplate).executeCallableStatement(callStmt, this.parms);
        if (DB2Z_DSNUTILU_PROCNAME.matcher(this.procedureName).matches() && (resultList = results.getResults()).size() > 0 && (result = (Result)resultList.get(0)) != null && (resultData = result.data()) != null && resultData.size() > 0 && (lastResultRow = (List)resultData.get(resultData.size() - 1)) != null && lastResultRow.size() > 0 && (lastMessage = (String)lastResultRow.get(lastResultRow.size() - 1)) != null && (lastMessage.contains("DSNUGBAC - UTILITY EXECUTION TERMINATED, HIGHEST RETURN CODE=") || lastMessage.contains("DSNUGBAC - UTILITY BATCH MEMORY EXECUTION ABENDED"))) {
            Object message = "DSNUTILU TERMINATED WITH OUTPUT:\n";
            for (List row : resultData) {
                message = (String)message + (String)row.get(row.size() - 1) + "\n";
            }
            results.setException(new SQLException((String)message));
        }
        return results;
    }
}

