set(VCPKG_POLICY_EMPTY_PACKAGE enabled)

if(VCPKG_HOST_IS_WINDOWS)
    # The version-agnostic tool dir may already exist.
    # Simulate/test with NASM.
    file(REMOVE_RECURSE "${DOWNLOADS}/tools/nasm")
    file(MAKE_DIRECTORY "${DOWNLOADS}/tools/nasm")
endif(VCPKG_HOST_IS_WINDOWS)

# For each vcpkg_find_acquire_program(NAME).cmake script,
# there must be a literal call to vcpkg_find_acquire_program(NAME)
vcpkg_list(SET variables)
macro(vcpkg_find_acquire_program NAME_AND_VAR)
    vcpkg_list(APPEND variables "${NAME_AND_VAR}")
    _vcpkg_find_acquire_program("${NAME_AND_VAR}")
endmacro()

vcpkg_find_acquire_program(BAZEL)
vcpkg_find_acquire_program(BISON)
vcpkg_find_acquire_program(FLEX)
vcpkg_find_acquire_program(GIT)
vcpkg_find_acquire_program(GN)
vcpkg_find_acquire_program(GPERF)
vcpkg_find_acquire_program(NASM)
vcpkg_find_acquire_program(NINJA)
vcpkg_find_acquire_program(PERL)
vcpkg_find_acquire_program(PKGCONFIG)
vcpkg_find_acquire_program(PYTHON3)
vcpkg_find_acquire_program(SCONS)
vcpkg_find_acquire_program(YASM)

if(NOT VCPKG_HOST_IS_OSX)
    vcpkg_find_acquire_program(MESON) # System python too old (3.9; meson needs 3.10)
    vcpkg_find_acquire_program(RUBY)
    vcpkg_find_acquire_program(SWIG)
endif()

if(VCPKG_HOST_IS_LINUX)
    vcpkg_find_acquire_program(PATCHELF)
endif()

if(VCPKG_HOST_IS_WINDOWS)
    vcpkg_find_acquire_program(7Z)
    vcpkg_find_acquire_program(CLANG)
    vcpkg_find_acquire_program(DARK)
    vcpkg_find_acquire_program(DOXYGEN)
    vcpkg_find_acquire_program(GASPREPROCESSOR)
    vcpkg_find_acquire_program(GO)
    vcpkg_find_acquire_program(JOM)
    vcpkg_find_acquire_program(NUGET)
    vcpkg_find_acquire_program(PYTHON2)
endif()

list(SORT variables)
message(STATUS "Collected programs: ${variables}")

set(missing "")
foreach(variable IN LISTS variables)
    set(var_contents "${${variable}}")
    list(POP_BACK var_contents program)
    if(NOT EXISTS "${program}")
        list(APPEND missing "${variable}: ${program}")
    endif()
    list(POP_FRONT var_contents interpreter)
    if(interpreter AND NOT EXISTS "${interpreter}")
        list(APPEND missing "${variable} (interpreter): ${interpreter}")
    endif()
endforeach()
if(missing)
    list(JOIN missing "\n   " missing)
    message(FATAL_ERROR "The following programs do not exist:\n   ${missing}")
endif()
