pub mod analyzer;
pub mod analyzer_error;
pub mod attribute;
pub mod attribute_table;
pub mod bigint;
pub mod connect_operation_table;
pub mod conv;
pub mod definition_table;
pub mod handlers;
pub mod ir;
pub mod literal;
pub mod literal_table;
pub mod msb_table;
pub mod multi_sources;
pub mod namespace;
pub mod namespace_table;
pub mod range_table;
pub mod reference_table;
pub mod stopwatch;
pub mod sv_system_function;
pub mod symbol;
pub mod symbol_path;
pub mod symbol_table;
pub mod type_dag;
pub mod r#unsafe;
pub mod unsafe_table;
pub mod value;
pub use analyzer::Analyzer;
pub use analyzer_error::AnalyzerError;
pub use conv::Context;
#[cfg(test)]
mod tests;

type HashMap<K, V> = fxhash::FxHashMap<K, V>;
type HashSet<V> = fxhash::FxHashSet<V>;
type BigInt = bigint::BigInt;
type BigUint = bigint::BigUint;
type Sign = bigint::Sign;

pub use smallvec::smallvec as svec;
pub type SVec<T> = smallvec::SmallVec<[T; 4]>;
