# `mise set`

- **Usage**: `mise set [FLAGS] [ENV_VAR]…`
- **Source code**: [`src/cli/set.rs`](https://github.com/jdx/mise/blob/main/src/cli/set.rs)

Set environment variables in mise.toml

By default, this command modifies `mise.toml` in the current directory.
Use `-E <env>` to create/modify environment-specific config files like `mise.<env>.toml`.

## Arguments

### `[ENV_VAR]…`

Environment variable(s) to set
e.g.: NODE_ENV=production

## Flags

### `--file <FILE>`

The TOML file to update

Defaults to MISE_DEFAULT_CONFIG_FILENAME environment variable, or `mise.toml`.

### `-g --global`

Set the environment variable in the global config file

### `-E --env <ENV>`

Create/modify an environment-specific config file like .mise.&lt;env>.toml

Examples:

```
$ mise set NODE_ENV=production

$ mise set NODE_ENV
production

$ mise set -E staging NODE_ENV=staging
# creates or modifies mise.staging.toml

$ mise set
key       value       source
NODE_ENV  production  ~/.config/mise/config.toml
```
