#!/usr/bin/env node
// Patches pkg/package.json generated by wasm-pack to add missing peerDependencies.
import { readFileSync, writeFileSync } from 'fs'

const pkgPath = new URL('../pkg/package.json', import.meta.url).pathname
const pkg = JSON.parse(readFileSync(pkgPath, 'utf8'))

const rootPkgPath = new URL('../package.json', import.meta.url).pathname
const rootPkg = JSON.parse(readFileSync(rootPkgPath, 'utf8'))
const webTreeSitterVersion = rootPkg.peerDependencies['web-tree-sitter']

pkg.peerDependencies = {
  'web-tree-sitter': webTreeSitterVersion,
}

writeFileSync(pkgPath, JSON.stringify(pkg, null, 2) + '\n')
console.log('Patched pkg/package.json with peerDependencies.')
