/*******************************************************************
 *  Copyright (c) 1994-2008 Jetico, Inc., Finland
 *  All rights reserved.
 *
 *  File:          wipe.h
 *
 *  Description:   BestCrypt wipe utility
 *
 *  Author:        Vitaliy Zolotarev
 *
 *  Created:       20-Nov-1999
 *
 *  Revision:      $Id: wipe.h 373 2014-12-23 11:40:21Z nail $ 
 *
 *
 *******************************************************************/

#ifndef _WIPE_H_
#define _WIPE_H_

#define OK          0
#define ERROR       -1

#define BUFFSIZE    1024*1024

#define NAME_MAX_PASSES 10
#define NAME_TRIES      200

#define BCWIPE_RAND	0
#define BCWIPE_SHA1	1
#define BCWIPE_ISAAC	2

#include <sys/types.h>
#include <time.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef time_t	seed_t;

typedef void (*stop_random_f)(void  *ctx);
typedef void (*restart_random_f)(void *ctx, int seed);
typedef void (*get_random_f)(void *ctx, unsigned char *buf, int size);

typedef struct {
	stop_random_f     stop_random;
	restart_random_f  restart_random;
	get_random_f      get_random;
	void              *random_context;
	unsigned char     *buffer;
	unsigned char     *verify_buffer;
	seed_t            seed;
	long long int     pos;
	int               pass;
	int               written;
	int               status;
	int               bufsize;
} data_context_t;

extern int init_random(data_context_t *ctx, int type);

typedef struct wipe_task
{
	long long int	 size;		/* actual size, may be 0 for devices */
	long long int	 slack_size;	/* file slack size */

	/* wiping task information */
	long long int    start;
	long long int    end;
	long long int    pos;
	int              flags;
	int		 slave;
			
	char		 *filename;	/* name */
	char		 *filename_print;	/* printable filename */
	mode_t		 st_mode;	/* st_mode from stat()/lstat() call */
	time_t		 mtime;		/* st_mtime from stat()/lstat() call */
	time_t		 atime;		/* st_atime from stat()/lstat() call */
	int		 pass;		/* current pass */
	seed_t		 seed;		/* seed to initialize pseudo-random sequence */
	seed_t		 prev_seed;	/* seed for previous pass */
	int              xattr;
	int		 skip;		/* an error occured, error number here */
	struct wipe_task *next;
	data_context_t   *data_context;
	
} wipe_task_t;

#ifdef __cplusplus
}
#endif

#endif  /* _WIPE_H_ */

