/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.util.jsonprinter;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import proguard.evaluation.util.jsonprinter.JsonPrinter;
import proguard.evaluation.util.jsonprinter.JsonSerializable;

class InstructionRecord
implements JsonSerializable {
    private final int offset;
    @NotNull
    private final String instruction;
    private List<String> finalVariablesBefore;
    private List<String> finalStackBefore;
    private List<Integer> finalTargetInstructions;
    private List<Integer> finalOriginInstructions;

    public InstructionRecord(int offset, @NotNull String instruction) {
        this.offset = offset;
        this.instruction = instruction;
    }

    @Override
    public StringBuilder toJson(StringBuilder builder) {
        builder.append("{");
        JsonPrinter.toJson("offset", this.offset, builder).append(",");
        JsonPrinter.toJson("instruction", this.instruction, builder);
        if (this.finalVariablesBefore != null) {
            builder.append(",");
            JsonPrinter.stringListToJson("finalVariablesBefore", this.finalVariablesBefore, builder);
        }
        if (this.finalStackBefore != null) {
            builder.append(",");
            JsonPrinter.stringListToJson("finalStackBefore", this.finalStackBefore, builder);
        }
        if (this.finalTargetInstructions != null) {
            builder.append(",");
            JsonPrinter.intListToJson("finalTargetInstructions", this.finalTargetInstructions, builder);
        }
        if (this.finalOriginInstructions != null) {
            builder.append(",");
            JsonPrinter.intListToJson("finalOriginInstructions", this.finalOriginInstructions, builder);
        }
        return builder.append("}");
    }

    public List<String> getFinalStackBefore() {
        return this.finalStackBefore;
    }

    public void setFinalStackBefore(List<String> finalStackBefore) {
        this.finalStackBefore = finalStackBefore;
    }

    public List<String> getFinalVariablesBefore() {
        return this.finalVariablesBefore;
    }

    public void setFinalVariablesBefore(List<String> finalVariablesBefore) {
        this.finalVariablesBefore = finalVariablesBefore;
    }

    public List<Integer> getFinalTargetInstructions() {
        return this.finalTargetInstructions;
    }

    public void setFinalTargetInstructions(List<Integer> finalTargetInstructions) {
        this.finalTargetInstructions = finalTargetInstructions;
    }

    public List<Integer> getFinalOriginInstructions() {
        return this.finalOriginInstructions;
    }

    public void setFinalOriginInstructions(List<Integer> finalOriginInstructions) {
        this.finalOriginInstructions = finalOriginInstructions;
    }

    public int getOffset() {
        return this.offset;
    }

    @NotNull
    public String getInstruction() {
        return this.instruction;
    }
}

