/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.kotlin.visitor.filter;

import java.util.function.Predicate;
import proguard.classfile.Clazz;
import proguard.classfile.kotlin.KotlinClassKindMetadata;
import proguard.classfile.kotlin.KotlinDeclarationContainerMetadata;
import proguard.classfile.kotlin.KotlinFunctionMetadata;
import proguard.classfile.kotlin.KotlinMetadata;
import proguard.classfile.kotlin.KotlinPropertyMetadata;
import proguard.classfile.kotlin.KotlinTypeAliasMetadata;
import proguard.classfile.kotlin.KotlinTypeParameterMetadata;
import proguard.classfile.kotlin.visitor.KotlinTypeParameterVisitor;

public class KotlinTypeParameterFilter
implements KotlinTypeParameterVisitor {
    private final Predicate<KotlinTypeParameterMetadata> predicate;
    private final KotlinTypeParameterVisitor acceptedVisitor;
    private final KotlinTypeParameterVisitor rejectedVisitor;

    public KotlinTypeParameterFilter(Predicate<KotlinTypeParameterMetadata> predicate, KotlinTypeParameterVisitor acceptedVisitor, KotlinTypeParameterVisitor rejectedVisitor) {
        this.predicate = predicate;
        this.acceptedVisitor = acceptedVisitor;
        this.rejectedVisitor = rejectedVisitor;
    }

    public KotlinTypeParameterFilter(Predicate<KotlinTypeParameterMetadata> predicate, KotlinTypeParameterVisitor acceptedVisitor) {
        this(predicate, acceptedVisitor, null);
    }

    @Override
    public void visitAnyTypeParameter(Clazz clazz, KotlinTypeParameterMetadata kotlinTypeParameterMetadata) {
    }

    @Override
    public void visitClassTypeParameter(Clazz clazz, KotlinClassKindMetadata kotlinMetadata, KotlinTypeParameterMetadata kotlinTypeParameterMetadata) {
        KotlinTypeParameterVisitor delegate = this.getDelegate(kotlinTypeParameterMetadata);
        if (delegate != null) {
            kotlinTypeParameterMetadata.accept(clazz, kotlinMetadata, delegate);
        }
    }

    @Override
    public void visitPropertyTypeParameter(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata, KotlinTypeParameterMetadata kotlinTypeParameterMetadata) {
        KotlinTypeParameterVisitor delegate = this.getDelegate(kotlinTypeParameterMetadata);
        if (delegate != null) {
            kotlinTypeParameterMetadata.accept(clazz, kotlinDeclarationContainerMetadata, kotlinPropertyMetadata, delegate);
        }
    }

    @Override
    public void visitFunctionTypeParameter(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata, KotlinTypeParameterMetadata kotlinTypeParameterMetadata) {
        KotlinTypeParameterVisitor delegate = this.getDelegate(kotlinTypeParameterMetadata);
        if (delegate != null) {
            kotlinTypeParameterMetadata.accept(clazz, kotlinMetadata, kotlinFunctionMetadata, delegate);
        }
    }

    @Override
    public void visitAliasTypeParameter(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinTypeAliasMetadata kotlinTypeAliasMetadata, KotlinTypeParameterMetadata kotlinTypeParameterMetadata) {
        KotlinTypeParameterVisitor delegate = this.getDelegate(kotlinTypeParameterMetadata);
        if (delegate != null) {
            kotlinTypeParameterMetadata.accept(clazz, kotlinDeclarationContainerMetadata, kotlinTypeAliasMetadata, delegate);
        }
    }

    private KotlinTypeParameterVisitor getDelegate(KotlinTypeParameterMetadata kotlinTypeParameterMetadata) {
        return this.predicate.test(kotlinTypeParameterMetadata) ? this.acceptedVisitor : this.rejectedVisitor;
    }
}

