/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.refaster;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableBiMap;
import com.google.errorprone.refaster.AutoValue_UUnary;
import com.google.errorprone.refaster.Choice;
import com.google.errorprone.refaster.CouldNotResolveImportException;
import com.google.errorprone.refaster.Inliner;
import com.google.errorprone.refaster.UBinary;
import com.google.errorprone.refaster.UExpression;
import com.google.errorprone.refaster.Unifier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TreeVisitor;
import com.sun.source.tree.UnaryTree;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeCopier;
import com.sun.tools.javac.tree.TreeMaker;
import org.jspecify.annotations.Nullable;

@AutoValue
abstract class UUnary
extends UExpression
implements UnaryTree {
    private static final ImmutableBiMap<Tree.Kind, JCTree.Tag> UNARY_OP_CODES = new ImmutableBiMap.Builder().put((Object)Tree.Kind.PREFIX_INCREMENT, (Object)JCTree.Tag.PREINC).put((Object)Tree.Kind.PREFIX_DECREMENT, (Object)JCTree.Tag.PREDEC).put((Object)Tree.Kind.POSTFIX_INCREMENT, (Object)JCTree.Tag.POSTINC).put((Object)Tree.Kind.POSTFIX_DECREMENT, (Object)JCTree.Tag.POSTDEC).put((Object)Tree.Kind.UNARY_PLUS, (Object)JCTree.Tag.POS).put((Object)Tree.Kind.UNARY_MINUS, (Object)JCTree.Tag.NEG).put((Object)Tree.Kind.BITWISE_COMPLEMENT, (Object)JCTree.Tag.COMPL).put((Object)Tree.Kind.LOGICAL_COMPLEMENT, (Object)JCTree.Tag.NOT).buildOrThrow();

    UUnary() {
    }

    public static UUnary create(Tree.Kind unaryOp, UExpression expression) {
        Preconditions.checkArgument((boolean)UNARY_OP_CODES.containsKey((Object)unaryOp), (String)"%s is not a recognized unary operation", (Object)((Object)unaryOp));
        return new AutoValue_UUnary(unaryOp, expression);
    }

    @Override
    public abstract Tree.Kind getKind();

    @Override
    public abstract UExpression getExpression();

    @Override
    public @Nullable Choice<Unifier> visitUnary(UnaryTree unary, @Nullable Unifier unifier) {
        return Choice.condition(this.getKind().equals((Object)unary.getKind()), unifier).thenChoose(Unifier.unifications(this.getExpression(), ASTHelpers.stripParentheses((ExpressionTree)unary.getExpression())));
    }

    @Override
    public <R, D> R accept(TreeVisitor<R, D> visitor, D data) {
        return visitor.visitUnary(this, data);
    }

    @Override
    public JCTree.JCExpression inline(Inliner inliner) throws CouldNotResolveImportException {
        JCTree.JCExpression expr = (JCTree.JCExpression)this.getExpression().inline(inliner);
        final TreeMaker maker = inliner.maker();
        if (this.getKind() == Tree.Kind.LOGICAL_COMPLEMENT) {
            return new TreeCopier<Void>(this, maker){
                final /* synthetic */ UUnary this$0;
                {
                    this.this$0 = this$0;
                    super(M);
                }

                @Override
                public <T extends JCTree> T copy(T t, Void v) {
                    if (t instanceof BinaryTree || t instanceof UnaryTree || t instanceof ConditionalExpressionTree) {
                        return super.copy(t, null);
                    }
                    return (T)this.defaultNegation(t);
                }

                public JCTree.JCExpression defaultNegation(Tree expr) {
                    return maker.Unary(JCTree.Tag.NOT, (JCTree.JCExpression)expr);
                }

                @Override
                public JCTree.JCExpression visitBinary(BinaryTree tree, Void v) {
                    if (UBinary.DEMORGAN.containsKey((Object)tree.getKind())) {
                        JCTree.JCExpression negLeft = this.copy((JCTree.JCExpression)tree.getLeftOperand());
                        JCTree.JCExpression negRight = this.copy((JCTree.JCExpression)tree.getRightOperand());
                        return maker.Binary((JCTree.Tag)((Object)UBinary.OP_CODES.get(UBinary.DEMORGAN.get((Object)tree.getKind()))), negLeft, negRight);
                    }
                    if (UBinary.NEGATION.containsKey((Object)tree.getKind())) {
                        JCTree.JCExpression left = (JCTree.JCExpression)tree.getLeftOperand();
                        JCTree.JCExpression right = (JCTree.JCExpression)tree.getRightOperand();
                        return maker.Binary((JCTree.Tag)((Object)UBinary.OP_CODES.get(UBinary.NEGATION.get((Object)tree.getKind()))), left, right);
                    }
                    return this.defaultNegation(tree);
                }

                @Override
                public JCTree.JCExpression visitUnary(UnaryTree tree, Void v) {
                    if (tree.getKind() == Tree.Kind.LOGICAL_COMPLEMENT) {
                        return (JCTree.JCExpression)tree.getExpression();
                    }
                    return this.defaultNegation(tree);
                }

                @Override
                public JCTree.JCConditional visitConditionalExpression(ConditionalExpressionTree tree, Void v) {
                    return maker.Conditional((JCTree.JCExpression)tree.getCondition(), this.copy((JCTree.JCExpression)tree.getTrueExpression()), this.copy((JCTree.JCExpression)tree.getFalseExpression()));
                }
            }.copy(expr);
        }
        return inliner.maker().Unary((JCTree.Tag)((Object)UNARY_OP_CODES.get((Object)this.getKind())), (JCTree.JCExpression)this.getExpression().inline(inliner));
    }

    @Override
    public UExpression negate() {
        return this.getKind() == Tree.Kind.LOGICAL_COMPLEMENT ? this.getExpression() : super.negate();
    }
}

