/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.refaster;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.ForOverride;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public abstract class Choice<T> {
    private static final Choice<Object> NONE = new Choice<Object>(){

        @Override
        protected Iterator<Object> iterator() {
            return Collections.emptyIterator();
        }

        @Override
        public <R> Choice<R> thenChoose(Function<? super Object, Choice<R>> function) {
            Preconditions.checkNotNull(function);
            return 1.none();
        }

        @Override
        public <R> Choice<R> thenOption(Function<? super Object, Optional<R>> function) {
            Preconditions.checkNotNull(function);
            return 1.none();
        }

        @Override
        public <R> Choice<R> transform(Function<? super Object, R> function) {
            Preconditions.checkNotNull(function);
            return 1.none();
        }

        @Override
        public Choice<Object> or(Choice<Object> other) {
            return (Choice)Preconditions.checkNotNull(other);
        }

        @Override
        @CanIgnoreReturnValue
        public Choice<Object> condition(Predicate<? super Object> predicate) {
            Preconditions.checkNotNull(predicate);
            return this;
        }

        @Override
        public String toString() {
            return "Choice.NONE";
        }
    };

    public static <T> Choice<T> none() {
        return NONE;
    }

    public static <T> Choice<T> of(final T t) {
        Preconditions.checkNotNull(t);
        return new Choice<T>(){

            @Override
            protected Iterator<T> iterator() {
                return Iterators.singletonIterator((Object)t);
            }

            @Override
            public Optional<T> first() {
                return Optional.of((Object)t);
            }

            @Override
            public Choice<T> condition(Predicate<? super T> predicate) {
                return predicate.apply(t) ? this : Choice.none();
            }

            @Override
            public <R> Choice<R> thenChoose(Function<? super T, Choice<R>> function) {
                return (Choice)function.apply(t);
            }

            @Override
            public <R> Choice<R> thenOption(Function<? super T, Optional<R>> function) {
                return 2.fromOptional((Optional)function.apply(t));
            }

            @Override
            public <R> Choice<R> transform(Function<? super T, R> function) {
                return 2.of(function.apply(t));
            }

            @Override
            public String toString() {
                return String.format("Choice.of(%s)", t);
            }
        };
    }

    public static <T> Choice<T> condition(boolean condition, T t) {
        return condition ? Choice.of(t) : Choice.none();
    }

    public static <T> Choice<T> fromOptional(Optional<T> optional) {
        return optional.isPresent() ? Choice.of(optional.get()) : Choice.none();
    }

    public static <T> Choice<T> from(final Collection<T> choices) {
        switch (choices.size()) {
            case 0: {
                return Choice.none();
            }
            case 1: {
                return Choice.of(Iterables.getOnlyElement(choices));
            }
        }
        return new Choice<T>(){

            @Override
            protected Iterator<T> iterator() {
                return choices.iterator();
            }

            @Override
            public String toString() {
                return String.format("Choice.from(%s)", choices);
            }
        };
    }

    public static <T> Choice<T> any(Collection<Choice<T>> choices) {
        return Choice.from(choices).thenChoose(Functions.identity());
    }

    private Choice() {
    }

    @VisibleForTesting
    Iterable<T> asIterable() {
        return this::iterator;
    }

    @ForOverride
    protected abstract Iterator<T> iterator();

    public String toString() {
        return Iterables.toString(this.asIterable());
    }

    public Optional<T> first() {
        Iterator<T> itr = this.iterator();
        return itr.hasNext() ? Optional.of(itr.next()) : Optional.absent();
    }

    public <R> Choice<R> thenChoose(final Function<? super T, Choice<R>> function) {
        Preconditions.checkNotNull(function);
        if (Thread.interrupted()) {
            throw new RuntimeException(new InterruptedException());
        }
        final Choice thisChoice = this;
        return new Choice<R>(this){
            final /* synthetic */ Choice this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            protected Iterator<R> iterator() {
                if (Thread.interrupted()) {
                    throw new RuntimeException(new InterruptedException());
                }
                return Iterators.concat((Iterator)Iterators.transform(thisChoice.iterator(), t -> ((Choice)function.apply(t)).iterator()));
            }
        };
    }

    public <R> Choice<R> thenOption(final Function<? super T, Optional<R>> function) {
        Preconditions.checkNotNull(function);
        final Choice thisChoice = this;
        return new Choice<R>(this){
            final /* synthetic */ Choice this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            protected Iterator<R> iterator() {
                return Optional.presentInstances((Iterable)Iterables.transform(thisChoice.asIterable(), (Function)function)).iterator();
            }
        };
    }

    public <R> Choice<R> transform(final Function<? super T, R> function) {
        Preconditions.checkNotNull(function);
        final Choice thisChoice = this;
        return new Choice<R>(this){
            final /* synthetic */ Choice this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            protected Iterator<R> iterator() {
                return Iterators.transform(thisChoice.iterator(), (Function)function);
            }
        };
    }

    public Choice<T> or(final Choice<T> other) {
        Preconditions.checkNotNull(other);
        if (other == Choice.none()) {
            return this;
        }
        final Choice thisChoice = this;
        return new Choice<T>(this){
            final /* synthetic */ Choice this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            protected Iterator<T> iterator() {
                return Iterators.concat(thisChoice.iterator(), other.iterator());
            }

            @Override
            public String toString() {
                return String.format("%s.or(%s)", thisChoice, other);
            }
        };
    }

    public Choice<T> condition(boolean condition) {
        return condition ? this : Choice.none();
    }

    public Choice<T> condition(final Predicate<? super T> predicate) {
        Preconditions.checkNotNull(predicate);
        final Choice thisChoice = this;
        return new Choice<T>(this){
            final /* synthetic */ Choice this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            protected Iterator<T> iterator() {
                return Iterators.filter(thisChoice.iterator(), (Predicate)predicate);
            }

            @Override
            public String toString() {
                return String.format("%s.condition(%s)", thisChoice, predicate);
            }
        };
    }
}

