/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.time;

import com.google.common.base.Joiner;
import com.google.common.base.Verify;
import com.google.common.collect.Range;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import java.time.DateTimeException;
import java.time.Month;
import java.util.ArrayList;
import java.util.List;

@BugPattern(summary="Warns against suspect looking calls to java.util.Date APIs", explanation="java.util.Date uses 1900-based years, 0-based months, 1-based days, and 0-based hours/minutes/seconds. Additionally, it allows for negative values or very large values (which rollover).", severity=BugPattern.SeverityLevel.WARNING)
public final class DateChecker
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.NewClassTreeMatcher {
    private static final String DATE = "java.util.Date";
    private static final Matcher<ExpressionTree> CONSTRUCTORS = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.constructor().forClass("java.util.Date").withParameters("int", new String[]{"int", "int"}), Matchers.constructor().forClass("java.util.Date").withParameters("int", new String[]{"int", "int", "int", "int"}), Matchers.constructor().forClass("java.util.Date").withParameters("int", new String[]{"int", "int", "int", "int", "int"})});
    private static final Matcher<ExpressionTree> SET_YEAR = Matchers.instanceMethod().onExactClass("java.util.Date").named("setYear");
    private static final Matcher<ExpressionTree> SET_MONTH = Matchers.instanceMethod().onExactClass("java.util.Date").named("setMonth");
    private static final Matcher<ExpressionTree> SET_DAY = Matchers.instanceMethod().onExactClass("java.util.Date").named("setDate");
    private static final Matcher<ExpressionTree> SET_HOUR = Matchers.instanceMethod().onExactClass("java.util.Date").named("setHours");
    private static final Matcher<ExpressionTree> SET_MIN = Matchers.instanceMethod().onExactClass("java.util.Date").named("setMinutes");
    private static final Matcher<ExpressionTree> SET_SEC = Matchers.instanceMethod().onExactClass("java.util.Date").named("setSeconds");
    private static final Range<Integer> YEAR_RANGE = Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(300));
    private static final Range<Integer> MONTH_RANGE = Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(11));
    private static final Range<Integer> DAY_RANGE = Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(31));
    private static final Range<Integer> HOUR_RANGE = Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(23));
    private static final Range<Integer> SEC_MIN_RANGE = Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(59));

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        ArrayList<String> errors = new ArrayList<String>();
        if (tree.getArguments().size() == 1) {
            ExpressionTree arg0 = tree.getArguments().get(0);
            if (SET_YEAR.matches((Tree)tree, state)) {
                DateChecker.checkYear(arg0, errors);
            } else if (SET_MONTH.matches((Tree)tree, state)) {
                DateChecker.checkMonth(arg0, errors);
            } else if (SET_DAY.matches((Tree)tree, state)) {
                DateChecker.checkDay(arg0, errors);
            } else if (SET_HOUR.matches((Tree)tree, state)) {
                DateChecker.checkHours(arg0, errors);
            } else if (SET_MIN.matches((Tree)tree, state)) {
                DateChecker.checkMinutes(arg0, errors);
            } else if (SET_SEC.matches((Tree)tree, state)) {
                DateChecker.checkSeconds(arg0, errors);
            }
        }
        return this.buildDescription(tree, errors);
    }

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        ArrayList<String> errors = new ArrayList<String>();
        if (CONSTRUCTORS.matches((Tree)tree, state)) {
            List<? extends ExpressionTree> args = tree.getArguments();
            int numArgs = args.size();
            Verify.verify((numArgs >= 3 && numArgs <= 6 ? 1 : 0) != 0, (String)"Expected the constructor to have at least 3 and at most 6 arguments, but it had %s", (int)numArgs);
            DateChecker.checkYear(args.get(0), errors);
            DateChecker.checkMonth(args.get(1), errors);
            DateChecker.checkDay(args.get(2), errors);
            if (numArgs > 4) {
                DateChecker.checkHours(args.get(3), errors);
                DateChecker.checkMinutes(args.get(4), errors);
            }
            if (numArgs > 5) {
                DateChecker.checkSeconds(args.get(5), errors);
            }
        }
        return this.buildDescription(tree, errors);
    }

    private Description buildDescription(ExpressionTree tree, List<String> errors) {
        return errors.isEmpty() ? Description.NO_MATCH : this.buildDescription(tree).setMessage("This Date usage looks suspect for the following reason(s): " + Joiner.on((String)"  ").join(errors)).build();
    }

    private static void checkYear(ExpressionTree tree, List<String> errors) {
        DateChecker.checkBounds(tree, "1900-based year", YEAR_RANGE, errors);
    }

    private static void checkMonth(ExpressionTree tree, List<String> errors) {
        DateChecker.checkBounds(tree, "0-based month", MONTH_RANGE, errors);
        if (tree instanceof LiteralTree) {
            int monthValue = (Integer)((LiteralTree)tree).getValue();
            try {
                errors.add(String.format("Use Calendar.%s instead of %s to represent the month.", Month.of(monthValue + 1), monthValue));
            }
            catch (DateTimeException dateTimeException) {
                // empty catch block
            }
        }
    }

    private static void checkDay(ExpressionTree tree, List<String> errors) {
        DateChecker.checkBounds(tree, "day", DAY_RANGE, errors);
    }

    private static void checkHours(ExpressionTree tree, List<String> errors) {
        DateChecker.checkBounds(tree, "hours", HOUR_RANGE, errors);
    }

    private static void checkMinutes(ExpressionTree tree, List<String> errors) {
        DateChecker.checkBounds(tree, "minutes", SEC_MIN_RANGE, errors);
    }

    private static void checkSeconds(ExpressionTree tree, List<String> errors) {
        DateChecker.checkBounds(tree, "seconds", SEC_MIN_RANGE, errors);
    }

    private static void checkBounds(ExpressionTree tree, String type, Range<Integer> range, List<String> errors) {
        Integer value = (Integer)ASTHelpers.constValue((Tree)tree, Integer.class);
        if (value != null && !range.contains((Comparable)value)) {
            errors.add(String.format("The %s value (%s) is out of bounds %s.", type, value, range));
        }
    }
}

