/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.optimize.OptimizationInfoClassFilter;
import proguard.optimize.info.ClassOptimizationInfo;
import proguard.optimize.info.ProgramClassOptimizationInfo;

public class InstanceofClassMarker
implements InstructionVisitor,
ConstantVisitor,
ClassVisitor {
    private final OptimizationInfoClassFilter filteredClassMarker = new OptimizationInfoClassFilter(this);

    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
    }

    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        if (constantInstruction.opcode == -63) {
            clazz.constantPoolEntryAccept(constantInstruction.constantIndex, (ConstantVisitor)this);
        }
    }

    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        classConstant.referencedClassAccept((ClassVisitor)this.filteredClassMarker);
    }

    public void visitAnyClass(Clazz clazz) {
        InstanceofClassMarker.setInstanceofed(clazz);
    }

    private static void setInstanceofed(Clazz clazz) {
        ProgramClassOptimizationInfo.getProgramClassOptimizationInfo(clazz).setInstanceofed();
    }

    public static boolean isInstanceofed(Clazz clazz) {
        return ClassOptimizationInfo.getClassOptimizationInfo(clazz).isInstanceofed();
    }
}

