/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.worker;

import com.google.caliper.core.Running;
import com.google.caliper.core.UserCodeException;
import com.google.caliper.util.InvalidCommandException;
import com.google.caliper.util.Util;
import com.google.common.base.Preconditions;
import dagger.Module;
import dagger.Provides;
import dagger.Reusable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Iterator;
import java.util.UUID;

@Module
final class WorkerOptionsModule {
    private final UUID id;
    private final InetSocketAddress clientAddress;
    private final String benchmarkClassName;

    public static WorkerOptionsModule fromArgs(String[] args) throws IOException {
        Iterator<String> iter = Arrays.asList(args).iterator();
        return new WorkerOptionsModule(UUID.fromString(iter.next()), new InetSocketAddress(InetAddress.getLocalHost(), Integer.parseInt(iter.next())), iter.next());
    }

    private WorkerOptionsModule(UUID id, InetSocketAddress clientAddress, String benchmarkClassName) {
        this.id = (UUID)Preconditions.checkNotNull((Object)id);
        this.clientAddress = (InetSocketAddress)Preconditions.checkNotNull((Object)clientAddress);
        this.benchmarkClassName = (String)Preconditions.checkNotNull((Object)benchmarkClassName);
    }

    @Provides
    UUID id() {
        return this.id;
    }

    @Provides
    InetSocketAddress clientAddress() {
        return this.clientAddress;
    }

    @Provides
    @Reusable
    @Running.BenchmarkClass
    Class<?> benchmarkClass() {
        try {
            return Util.lenientClassForName((String)this.benchmarkClassName);
        }
        catch (ClassNotFoundException e) {
            String string = String.valueOf(this.benchmarkClassName);
            throw new InvalidCommandException(string.length() != 0 ? "Benchmark class not found: ".concat(string) : new String("Benchmark class not found: "), new Object[0]);
        }
        catch (ExceptionInInitializerError e) {
            String string = String.valueOf(this.benchmarkClassName);
            throw new UserCodeException(string.length() != 0 ? "Exception thrown while initializing class: ".concat(string) : new String("Exception thrown while initializing class: "), e.getCause());
        }
        catch (NoClassDefFoundError e) {
            String string = String.valueOf(this.benchmarkClassName);
            throw new UserCodeException(string.length() != 0 ? "Unable to load class: ".concat(string) : new String("Unable to load class: "), (Throwable)e);
        }
    }
}

