/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner.instrument;

import com.google.caliper.Benchmark;
import com.google.caliper.api.Macrobenchmark;
import com.google.caliper.bridge.AbstractLogMessageVisitor;
import com.google.caliper.bridge.GcLogMessage;
import com.google.caliper.bridge.HotspotLogMessage;
import com.google.caliper.bridge.StartMeasurementLogMessage;
import com.google.caliper.bridge.StopMeasurementLogMessage;
import com.google.caliper.core.BenchmarkClassModel;
import com.google.caliper.core.InvalidBenchmarkException;
import com.google.caliper.model.InstrumentType;
import com.google.caliper.model.Measurement;
import com.google.caliper.runner.config.SupportsVmType;
import com.google.caliper.runner.config.VmType;
import com.google.caliper.runner.instrument.BenchmarkMethods;
import com.google.caliper.runner.instrument.Instrument;
import com.google.caliper.runner.instrument.MeasurementCollectingVisitor;
import com.google.caliper.runner.instrument.NanoTimeGranularity;
import com.google.caliper.util.ShortDuration;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.inject.Inject;

@SupportsVmType(value={VmType.JVM, VmType.ANDROID})
public class RuntimeInstrument
extends Instrument {
    private static final String SUGGEST_GRANULARITY_OPTION = "suggestGranularity";
    private static final String TIMING_INTERVAL_OPTION = "timingInterval";
    private static final Logger logger = Logger.getLogger(RuntimeInstrument.class.getName());
    private final ShortDuration nanoTimeGranularity;

    @Inject
    @VisibleForTesting
    public RuntimeInstrument(@NanoTimeGranularity ShortDuration nanoTimeGranularity) {
        this.nanoTimeGranularity = nanoTimeGranularity;
        this.setInstrumentName("runtime");
    }

    @Override
    public boolean isBenchmarkMethod(BenchmarkClassModel.MethodModel method) {
        return method.isAnnotationPresent(Benchmark.class) || BenchmarkMethods.isTimeMethod(method) || method.isAnnotationPresent(Macrobenchmark.class);
    }

    @Override
    protected ImmutableSet<String> instrumentOptions() {
        return ImmutableSet.of((Object)"warmup", (Object)"maxWarmupWallTime", (Object)TIMING_INTERVAL_OPTION, (Object)"measurements", (Object)"gcBeforeEach", (Object)SUGGEST_GRANULARITY_OPTION, (Object[])new String[0]);
    }

    @Override
    public Instrument.InstrumentedMethod createInstrumentedMethod(BenchmarkClassModel.MethodModel benchmarkMethod) throws InvalidBenchmarkException {
        Preconditions.checkNotNull((Object)benchmarkMethod);
        Preconditions.checkArgument((boolean)this.isBenchmarkMethod(benchmarkMethod));
        if (Modifier.isStatic(benchmarkMethod.modifiers())) {
            throw new InvalidBenchmarkException("Benchmark methods must not be static: %s", new Object[]{benchmarkMethod.name()});
        }
        try {
            switch (BenchmarkMethods.Type.of(benchmarkMethod)) {
                case MACRO: {
                    return new MacrobenchmarkInstrumentedMethod(benchmarkMethod);
                }
                case MICRO: {
                    return new MicrobenchmarkInstrumentedMethod(this, benchmarkMethod);
                }
                case PICO: {
                    return new PicobenchmarkInstrumentedMethod(this, benchmarkMethod);
                }
            }
            throw new AssertionError((Object)"unknown type");
        }
        catch (IllegalArgumentException e) {
            throw new InvalidBenchmarkException("Benchmark methods must have no arguments or accept a single int or long parameter: %s", new Object[]{benchmarkMethod.name()});
        }
    }

    private int getMeasurementsPerTrial() {
        String measurementsString = (String)this.options.get((Object)"measurements");
        int measurementsPerTrial = measurementsString == null ? 1 : Integer.parseInt(measurementsString);
        Preconditions.checkState((measurementsPerTrial > 0 ? 1 : 0) != 0);
        return measurementsPerTrial;
    }

    private static final class SingleInvocationMeasurementCollector
    extends RuntimeMeasurementCollector {
        SingleInvocationMeasurementCollector(int measurementsPerTrial, ShortDuration warmup, ShortDuration maxWarmupWallTime) {
            super(measurementsPerTrial, warmup, maxWarmupWallTime);
        }

        @Override
        void gcWhileMeasuring() {
            this.messages.add("WARNING: GC occurred during timing. Depending on the scope of the benchmark, this might significantly impact results. Consider running with a larger heap size.");
        }

        @Override
        void hotspotWhileMeasuring() {
            this.messages.add("WARNING: Hotspot compilation occurred during timing. Depending on the scope of the benchmark, this might significantly impact results. Consider running with a longer warmup.");
        }

        @Override
        void hotspotWhileNotMeasuring() {
            this.messages.add("WARNING: Hotspot compilation occurred after warmup, but outside of timing. Depending on the scope of the benchmark, this might significantly impact results. Consider running with a longer warmup.");
        }
    }

    private static final class RepBasedMeasurementCollector
    extends RuntimeMeasurementCollector {
        RepBasedMeasurementCollector(int measurementsPerTrial, ShortDuration warmup, ShortDuration maxWarmupWallTime) {
            super(measurementsPerTrial, warmup, maxWarmupWallTime);
        }

        @Override
        void gcWhileMeasuring() {
            this.invalidateMeasurements = true;
            this.messages.add("ERROR: GC occurred during timing. Measurements were discarded.");
        }

        @Override
        void hotspotWhileMeasuring() {
            this.invalidateMeasurements = true;
            this.messages.add("ERROR: Hotspot compilation occurred during timing: warmup is likely insufficent. Measurements were discarded.");
        }

        @Override
        void hotspotWhileNotMeasuring() {
            this.messages.add("WARNING: Hotspot compilation occurred after warmup, but outside of timing. Results may be affected. Run with --verbose to see which method was compiled.");
        }
    }

    private static abstract class RuntimeMeasurementCollector
    extends AbstractLogMessageVisitor
    implements MeasurementCollectingVisitor {
        final int targetMeasurements;
        final ShortDuration warmup;
        final ShortDuration maxWarmupWallTime;
        final List<Measurement> measurements = Lists.newArrayList();
        ShortDuration elapsedWarmup = ShortDuration.zero();
        boolean measuring = false;
        boolean invalidateMeasurements = false;
        boolean notifiedAboutGc = false;
        boolean notifiedAboutJit = false;
        boolean notifiedAboutMeasuringJit = false;
        Stopwatch timeSinceStartOfTrial = Stopwatch.createUnstarted();
        final List<String> messages = Lists.newArrayList();

        RuntimeMeasurementCollector(int targetMeasurements, ShortDuration warmup, ShortDuration maxWarmupWallTime) {
            this.targetMeasurements = targetMeasurements;
            this.warmup = warmup;
            this.maxWarmupWallTime = maxWarmupWallTime;
        }

        public void visit(GcLogMessage logMessage) {
            if (this.measuring && this.isWarmupComplete() && !this.notifiedAboutGc) {
                this.gcWhileMeasuring();
                this.notifiedAboutGc = true;
            }
        }

        public void visit(HotspotLogMessage logMessage) {
            if (this.isWarmupComplete()) {
                if (this.measuring && this.notifiedAboutMeasuringJit) {
                    this.hotspotWhileMeasuring();
                    this.notifiedAboutMeasuringJit = true;
                } else if (this.notifiedAboutJit) {
                    this.hotspotWhileNotMeasuring();
                    this.notifiedAboutJit = true;
                }
            }
        }

        public void visit(StartMeasurementLogMessage logMessage) {
            Preconditions.checkState((!this.measuring ? 1 : 0) != 0);
            this.measuring = true;
            if (!this.timeSinceStartOfTrial.isRunning()) {
                this.timeSinceStartOfTrial.start();
            }
        }

        public void visit(StopMeasurementLogMessage logMessage) {
            Preconditions.checkState((boolean)this.measuring);
            ImmutableList newMeasurements = logMessage.measurements();
            if (!this.isWarmupComplete()) {
                for (Measurement measurement : newMeasurements) {
                    Preconditions.checkArgument((boolean)"ns".equals(measurement.value().unit()));
                    this.elapsedWarmup = this.elapsedWarmup.plus(ShortDuration.of((BigDecimal)BigDecimal.valueOf(measurement.value().magnitude()), (TimeUnit)TimeUnit.NANOSECONDS));
                }
            } else {
                if (!this.measuredWarmupDurationReached()) {
                    this.messages.add(String.format("WARNING: Warmup was interrupted because it took longer than %s of wall-clock time. %s was spent in the benchmark method for warmup (normal warmup duration should be %s).", this.maxWarmupWallTime, this.elapsedWarmup, this.warmup));
                }
                if (this.invalidateMeasurements) {
                    logger.fine(String.format("Discarding %s as they were marked invalid.", newMeasurements));
                } else {
                    this.measurements.addAll((Collection<Measurement>)newMeasurements);
                }
            }
            this.invalidateMeasurements = false;
            this.measuring = false;
        }

        abstract void gcWhileMeasuring();

        abstract void hotspotWhileMeasuring();

        abstract void hotspotWhileNotMeasuring();

        @Override
        public ImmutableList<Measurement> getMeasurements() {
            return ImmutableList.copyOf(this.measurements);
        }

        boolean measuredWarmupDurationReached() {
            return this.elapsedWarmup.compareTo((Object)this.warmup) >= 0;
        }

        @Override
        public boolean isWarmupComplete() {
            return this.measuredWarmupDurationReached() || this.timeSinceStartOfTrial.elapsed(TimeUnit.MILLISECONDS) > this.maxWarmupWallTime.to(TimeUnit.MILLISECONDS);
        }

        @Override
        public boolean isDoneCollecting() {
            return this.measurements.size() >= this.targetMeasurements;
        }

        @Override
        public ImmutableList<String> getMessages() {
            return ImmutableList.copyOf(this.messages);
        }
    }

    private class PicobenchmarkInstrumentedMethod
    extends RuntimeInstrumentedMethod {
        PicobenchmarkInstrumentedMethod(RuntimeInstrument runtimeInstrument, BenchmarkClassModel.MethodModel benchmarkMethod) {
            super(benchmarkMethod);
        }

        @Override
        public InstrumentType type() {
            return InstrumentType.RUNTIME_PICO;
        }
    }

    private class MicrobenchmarkInstrumentedMethod
    extends RuntimeInstrumentedMethod {
        MicrobenchmarkInstrumentedMethod(RuntimeInstrument runtimeInstrument, BenchmarkClassModel.MethodModel benchmarkMethod) {
            super(benchmarkMethod);
        }

        @Override
        public InstrumentType type() {
            return InstrumentType.RUNTIME_MICRO;
        }
    }

    private abstract class RuntimeInstrumentedMethod
    extends Instrument.InstrumentedMethod {
        RuntimeInstrumentedMethod(BenchmarkClassModel.MethodModel method) {
            super(method);
        }

        @Override
        public ImmutableMap<String, String> workerOptions() {
            return ImmutableMap.of((Object)"timingIntervalNanos", (Object)this.toNanosString(RuntimeInstrument.TIMING_INTERVAL_OPTION), (Object)"gcBeforeEach", (Object)((String)RuntimeInstrument.this.options.get((Object)"gcBeforeEach")));
        }

        private String toNanosString(String optionName) {
            return String.valueOf(ShortDuration.valueOf((String)((String)RuntimeInstrument.this.options.get((Object)optionName))).to(TimeUnit.NANOSECONDS));
        }

        @Override
        public MeasurementCollectingVisitor getMeasurementCollectingVisitor() {
            return new RepBasedMeasurementCollector(RuntimeInstrument.this.getMeasurementsPerTrial(), ShortDuration.valueOf((String)((String)RuntimeInstrument.this.options.get((Object)"warmup"))), ShortDuration.valueOf((String)((String)RuntimeInstrument.this.options.get((Object)"maxWarmupWallTime"))));
        }

        @Override
        public Optional<String> validateMeasurements(Iterable<ImmutableList<Measurement>> trialResults) {
            if (!Boolean.parseBoolean((String)RuntimeInstrument.this.options.get((Object)RuntimeInstrument.SUGGEST_GRANULARITY_OPTION))) {
                return Optional.absent();
            }
            boolean hasResults = false;
            ShortDuration reasonableUpperBound = RuntimeInstrument.this.nanoTimeGranularity.times(1000L);
            for (ImmutableList<Measurement> measurements : trialResults) {
                for (Measurement measurement : measurements) {
                    hasResults = true;
                    double nanos = measurement.value().magnitude() / measurement.weight();
                    if (!(nanos < (double)reasonableUpperBound.to(TimeUnit.NANOSECONDS))) continue;
                    return Optional.absent();
                }
            }
            if (hasResults) {
                return Optional.of((Object)String.format("This benchmark does not require a microbenchmark. The granularity of the timer (%s) is less than 0.1%% of the fastest measured runtime across all experiments.", RuntimeInstrument.this.nanoTimeGranularity));
            }
            return Optional.absent();
        }
    }

    private class MacrobenchmarkInstrumentedMethod
    extends Instrument.InstrumentedMethod {
        MacrobenchmarkInstrumentedMethod(BenchmarkClassModel.MethodModel benchmarkMethod) {
            super(benchmarkMethod);
        }

        @Override
        public InstrumentType type() {
            return InstrumentType.RUNTIME_MACRO;
        }

        @Override
        public MeasurementCollectingVisitor getMeasurementCollectingVisitor() {
            return new SingleInvocationMeasurementCollector(Integer.parseInt((String)RuntimeInstrument.this.options.get((Object)"measurements")), ShortDuration.valueOf((String)((String)RuntimeInstrument.this.options.get((Object)"warmup"))), ShortDuration.valueOf((String)((String)RuntimeInstrument.this.options.get((Object)"maxWarmupWallTime"))));
        }
    }
}

