/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner;

import com.google.caliper.core.InvalidBenchmarkException;
import com.google.caliper.runner.CaliperRun;
import com.google.caliper.runner.CaliperRunComponent;
import com.google.caliper.runner.config.CaliperConfig;
import com.google.caliper.runner.config.InvalidConfigurationException;
import com.google.caliper.runner.options.CaliperOptions;
import com.google.caliper.runner.worker.targetinfo.TargetInfo;
import com.google.caliper.runner.worker.targetinfo.TargetInfoFactory;
import com.google.caliper.util.DisplayUsageException;
import com.google.caliper.util.InvalidCommandException;
import com.google.caliper.util.Stderr;
import com.google.caliper.util.Stdout;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Service;
import com.google.common.util.concurrent.ServiceManager;
import dagger.Lazy;
import java.io.PrintWriter;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import javax.inject.Provider;

public final class CaliperRunner {
    private final Lazy<CaliperOptions> options;
    private final Lazy<CaliperConfig> config;
    private final Lazy<ServiceManager> serviceManager;
    private final Lazy<TargetInfoFactory> targetInfoFactory;
    private final PrintWriter stdout;
    private final PrintWriter stderr;
    private final Provider<CaliperRunComponent.Builder> runComponentBuilder;
    private final ExecutorService executor;

    @Inject
    CaliperRunner(Lazy<CaliperOptions> options, Lazy<CaliperConfig> config, Lazy<ServiceManager> serviceManager, Lazy<TargetInfoFactory> targetInfoFactory, @Stdout PrintWriter stdout, @Stderr PrintWriter stderr, Provider<CaliperRunComponent.Builder> runComponentBuilder, ExecutorService executor) {
        this.options = options;
        this.config = config;
        this.serviceManager = serviceManager;
        this.targetInfoFactory = targetInfoFactory;
        this.stdout = stdout;
        this.stderr = stderr;
        this.runComponentBuilder = runComponentBuilder;
        this.executor = executor;
    }

    public int run() {
        int code = 1;
        try {
            this.runInternal();
            code = 0;
        }
        catch (DisplayUsageException e) {
            e.display(this.stdout);
            code = e.exitCode();
        }
        catch (InvalidCommandException e) {
            e.display(this.stderr);
            code = e.exitCode();
        }
        catch (InvalidBenchmarkException e) {
            e.display(this.stderr);
        }
        catch (InvalidConfigurationException e) {
            e.display(this.stderr);
        }
        catch (Throwable t) {
            t.printStackTrace(this.stderr);
            this.stdout.println();
            this.stdout.println("An unexpected exception has been thrown by the caliper runner.");
            this.stdout.println("Please see https://sites.google.com/site/caliperusers/issues");
        }
        this.stdout.flush();
        this.stderr.flush();
        return code;
    }

    public void runAndExit() {
        System.exit(this.run());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void runInternal() throws InvalidCommandException, InvalidBenchmarkException, InvalidConfigurationException {
        try {
            if (((CaliperOptions)this.options.get()).printConfiguration()) {
                this.stdout.println("Configuration:");
                ImmutableSortedMap sortedProperties = ImmutableSortedMap.copyOf(((CaliperConfig)this.config.get()).properties());
                for (Map.Entry entry : sortedProperties.entrySet()) {
                    this.stdout.printf("  %s = %s%n", entry.getKey(), entry.getValue());
                }
            }
            ((ServiceManager)this.serviceManager.get()).addListener(new ServiceManager.Listener(){

                public void failure(Service service) {
                    String string = String.valueOf(service);
                    CaliperRunner.this.stderr.println(new StringBuilder(45 + String.valueOf(string).length()).append("Service ").append(string).append(" failed with the following exception:").toString());
                    service.failureCause().printStackTrace(CaliperRunner.this.stderr);
                }
            }, MoreExecutors.directExecutor());
            ((ServiceManager)this.serviceManager.get()).startAsync().awaitHealthy();
            try {
                TargetInfo targetInfo = ((TargetInfoFactory)this.targetInfoFactory.get()).getTargetInfo();
                CaliperRun run = ((CaliperRunComponent.Builder)this.runComponentBuilder.get()).targetInfo(targetInfo).build().getCaliperRun();
                run.run();
            }
            finally {
                try {
                    ((ServiceManager)this.serviceManager.get()).stopAsync().awaitStopped(10L, TimeUnit.SECONDS);
                }
                catch (TimeoutException timeoutException) {}
            }
        }
        finally {
            MoreExecutors.shutdownAndAwaitTermination((ExecutorService)this.executor, (long)5L, (TimeUnit)TimeUnit.SECONDS);
            this.stderr.flush();
            this.stdout.flush();
        }
    }
}

