/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.parse.json;

import org.basex.build.json.JsonOptions;
import org.basex.build.json.JsonParserOptions;
import org.basex.io.parse.json.JsonConstants;
import org.basex.io.parse.json.JsonXmlConverter;
import org.basex.query.QueryException;
import org.basex.query.value.node.FBuilder;
import org.basex.query.value.node.FElem;
import org.basex.util.XMLToken;

public final class JsonDirectConverter
extends JsonXmlConverter {
    private final boolean lax;

    JsonDirectConverter(JsonParserOptions opts) throws QueryException {
        super(opts);
        this.lax = this.jopts.get(JsonOptions.LAX);
        this.name = JsonConstants.JSON;
    }

    @Override
    protected void openObject() {
        this.openOuter(JsonConstants.OBJECT);
    }

    @Override
    protected void closeObject() {
        this.closeOuter();
    }

    @Override
    protected void openPair(byte[] key, boolean add) {
        this.addValues.add(add);
        if (add) {
            this.name = this.shared.token(XMLToken.encode(key, this.lax));
        }
    }

    @Override
    protected void closePair(boolean add) {
        this.addValues.pop();
    }

    @Override
    protected void openArray() {
        this.openOuter(JsonConstants.ARRAY);
    }

    @Override
    protected void closeArray() {
        this.closeOuter();
    }

    @Override
    protected void openItem() {
        this.name = JsonConstants.VALUE;
    }

    @Override
    protected void closeItem() {
    }

    @Override
    void addValue(byte[] type, byte[] value) {
        if (this.addValues.peek()) {
            byte[] val = value != null ? this.shared.token(value) : null;
            FBuilder elem = this.element(type).add(val);
            if (this.curr != null) {
                this.curr.add(elem);
            } else {
                this.curr = elem;
            }
        }
    }

    private void openOuter(byte[] type) {
        this.curr = this.element(type);
        this.stack.push(this.curr);
    }

    private void closeOuter() {
        this.curr = (FBuilder)this.stack.pop();
        if (!this.stack.isEmpty()) {
            this.curr = ((FBuilder)this.stack.peek()).add(this.curr);
        }
    }

    private FBuilder element(byte[] type) {
        FBuilder elem = FElem.build(this.shared.qName(this.name));
        this.processType(elem, type);
        return elem;
    }
}

