/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.hash;

import java.util.Arrays;
import org.basex.util.hash.ASet;

public class IntSet
extends ASet {
    int[] keys = new int[this.capacity()];

    public IntSet() {
        this(2L);
    }

    public IntSet(long capacity) {
        super(capacity);
    }

    public final boolean add(int key) {
        return this.store(key) > 0;
    }

    public final int put(int key) {
        int i = this.store(key);
        return Math.abs(i);
    }

    public final boolean contains(int key) {
        return this.index(key) > 0;
    }

    public final int index(int key) {
        int b = key & this.capacity() - 1;
        int i = this.buckets[b];
        while (i != 0) {
            if (key == this.keys[i]) {
                return i;
            }
            i = this.next[i];
        }
        return 0;
    }

    public final int key(int index) {
        return this.keys[index];
    }

    private int store(int key) {
        int b = key & this.capacity() - 1;
        int i = this.buckets[b];
        while (i != 0) {
            if (key == this.keys[i]) {
                return -i;
            }
            i = this.next[i];
        }
        int s = this.size++;
        if (this.checkCapacity()) {
            b = key & this.capacity() - 1;
        }
        this.next[s] = this.buckets[b];
        this.keys[s] = key;
        this.buckets[b] = s;
        return s;
    }

    @Override
    protected final int hashCode(int index) {
        return this.keys[index];
    }

    @Override
    protected void rehash(int newSize) {
        this.keys = Arrays.copyOf(this.keys, newSize);
    }

    public final int[] keys() {
        return Arrays.copyOfRange(this.keys, 1, this.size);
    }

    public String toString() {
        return this.toString(Arrays.stream(this.keys).boxed().toArray(Integer[]::new));
    }
}

