/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.session;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.lang.reflect.Field;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.ApiFunc;
import org.basex.query.func.session.ASession;
import org.basex.util.Reflect;
import org.basex.util.Util;

abstract class SessionFn
extends ApiFunc {
    SessionFn() {
    }

    final ASession session(QueryContext qc, boolean create) throws QueryException {
        HttpServletRequest request = this.request(qc);
        HttpSession session = SessionFn.wsSession(qc);
        if (session == null) {
            try {
                session = request.getSession(create);
            }
            catch (NullPointerException ex) {
                Util.debug((Throwable)ex);
            }
        }
        if (session == null) {
            if (create) {
                throw QueryError.SESSION_NOTFOUND.get(this.info, new Object[0]);
            }
            return null;
        }
        return new ASession(session);
    }

    private static HttpSession wsSession(QueryContext qc) {
        Object ws;
        Class wsClass = Reflect.find((String)"org.basex.http.ws.WebSocket");
        if (wsClass != null && (ws = qc.context.getExternal(wsClass)) != null) {
            return (HttpSession)Reflect.get((Field)Reflect.field((Class)wsClass, (String)"session"), (Object)ws);
        }
        return null;
    }
}

