## Description

<!-- Provide a brief summary of your changes. What does this PR do? -->

## Type of Change

<!-- Mark the relevant option with an "x" -->

- [ ] 🐛 Bug fix (non-breaking change that fixes an issue)
- [ ] ✨ New feature (non-breaking change that adds functionality)
- [ ] 💥 Breaking change (fix or feature that would cause existing functionality to change)
- [ ] 📚 Documentation update
- [ ] 🔧 Refactor (code change that neither fixes a bug nor adds a feature)
- [ ] 🧪 Test improvement

## Related Issues

<!-- Link any related issues using "Fixes #123" or "Closes #123" -->

## Testing Performed

<!-- Describe the testing you've done -->

- [ ] Tested with built-in trackpad
- [ ] Tested with Magic Trackpad (if available)
- [ ] Verified system gestures (Mission Control, etc.) still work
- [ ] Tested in target apps (list any specific apps tested):
  - 

## Checklist

<!-- Ensure all items are checked before requesting review -->

- [ ] My code follows the project's [code style guidelines](../CONTRIBUTING.md)
- [ ] I have tested my changes thoroughly
- [ ] I have added comments for non-obvious logic
- [ ] My changes don't break existing functionality
- [ ] I have updated documentation if needed

## Code Coverage

<!-- Our CI enforces 80% patch coverage on new code -->

- [ ] I have added tests for new functionality (where applicable)
- [ ] My changes meet the **80% patch coverage** requirement

> **Note:** Codecov will automatically check patch coverage. PRs that don't meet the 80% threshold will fail the coverage check. Files in `MiddleDragTests/`, `AppDelegate.swift`, `MiddleDragApp.swift`, and `UpdateManager.swift` are excluded from coverage requirements.

## Screenshots / Recordings

<!-- If applicable, add screenshots or screen recordings demonstrating the changes -->

## Additional Notes

<!-- Any additional context, concerns, or notes for reviewers -->
