[comment {-*- tcl -*- doctools manpage}]
[manpage_begin term::interact::menu n 0.2]
[keywords control]
[keywords menu]
[keywords terminal]
[keywords {text display}]
[copyright {2006 Andreas Kupries <andreas_kupries@users.sourceforge.net>}]
[moddesc   {Terminal control}]
[titledesc {Terminal widget, menu}]
[category  {Terminal control}]
[require Tcl "8.5 9"]
[require term::interact::menu [opt 0.2]]
[description]

This package provides a class for the creation of a simple menu
control.

[section {Class API}]

The package exports a single command, the class command, enabling the
creation of menu instances. Its API is:

[list_begin definitions]

[call [cmd term::interact::menu] [arg object] [arg dict] [opt [arg options]...]]

This command creates a new menu object with the name [arg object],
initializes it, and returns the fully qualified name of the object
command as its result.

[para]

The argument is the menu to show, possibly followed by configuration
options and their values. The options are explained in the section
[sectref Configuration]. The menu is a dictionary maping labels
to symbolic action codes.

[list_end]

[section {Object API}]

The objects created by the class command provide the methods listed
below:

[list_begin definitions]
[call [arg object] [method interact]]

Shows the menu in the screen at the configured location and starts
interacting with it. This opens its own event loop for the processing
of incoming characters. The method returns when the interaction has
completed. See section [sectref Interaction] for a description of the
possible interaction.

[para]

The method returns the symbolic action of the menu item selected by
the user at the end of the interaction.

[call [arg object] [method done]]

This method can be used by user supplied actions to terminate the
interaction with the object.

[call [arg object] [method clear]]

This method can be used by user supplied actions to remove the menu
from the terminal.

[call [arg object] [method configure]]
[call [arg object] [method configure] [arg option]]
[call [arg object] [method configure] [arg option] [arg value]...]
[call [arg object] [method cget] [arg option]]

Standard methods to retrieve and configure the options of the menu.

[list_end]

[section Configuration]

A menu instance recognizes the following options:

[list_begin options]
[opt_def -in chan]

Specifies the channel to read character sequences from. Defaults to
[const stdin].

[opt_def -out chan]

Specifies the channel to write the menu contents to. Defaults to
[const stdout].

[opt_def -column int]

Specifies the column of the terminal where the left margin of the
menu display should appear. Defaults to 0, i.e. the left-most
column.

[opt_def -line int]

Specifies the line of the terminal where the top margin of the menu
display should appear. Defaults to 0, i.e. the top-most line.

[opt_def -height int]

Specifies the number of lines of text to show at most in the
display. Defaults to 25.

[opt_def -actions dict]

Specifies a dictionary containing additional actions, using character
sequences as keys. Note that these sequences cannot override the
hardwired sequences described in section [sectref Interaction].

[opt_def -hilitleft int]
[opt_def -hilitright int]

By default the entire selected menu entry is highlighted in revers
output. However, when present these two options restrict revers dispay
to the specified sub-range of the entry.

[opt_def -framed bool]

By default the menu is shown using only header and footer out of
characters box graphics. If this flag is set the menu is fully
enclosed in a box.

[list_end]

[section Interaction]

A menu object recognizes the control sequences listed below and acts
as described. The user can supply more control sequences to act on via
the configuration, but is not able to overide these defaults.

[list_begin definitions]
[def {Cursor Up}]

The selection is moved up one entry, except if the first entry of the
menu is already selected.

[def {Cursor Down}]

The selection is moved down one entry, except if the last entry of the
menu is already selected.

[def Enter/Return]

The interaction with the object is terminated.

[list_end]

[vset CATEGORY term]
[include ../common-text/feedback.inc]
[manpage_end]
