/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.vlma;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.apache.log4j.Logger;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdDbPool;
import org.jrobin.core.RrdDef;
import org.jrobin.core.RrdException;
import org.jrobin.core.Sample;
import org.jrobin.core.Util;
import org.jrobin.graph.RrdGraph;
import org.jrobin.graph.RrdGraphDef;
import org.videolan.vlma.OrderGiver;
import org.videolan.vlma.VLMaService;
import org.videolan.vlma.dao.VLMaDao;
import org.videolan.vlma.model.Media;
import org.videolan.vlma.model.Order;
import org.videolan.vlma.model.Satellite;
import org.videolan.vlma.model.Server;
import org.videolan.vlma.monitor.OrderMonitor;
import org.videolan.vlma.monitor.ServerStateMonitor;
import org.videolan.vlma.notifier.Notifier;
import org.videolan.vlma.retriever.Data;
import org.videolan.vlma.retriever.DataRetriever;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VLMaServiceImpl
implements VLMaService {
    public static final String DATA_FILE = "data.xml";
    public static final int SOCKET_TIMEOUT = 5000;
    private static final Logger logger = Logger.getLogger(VLMaServiceImpl.class);
    private Set<Order> orders = new HashSet<Order>();
    private Set<Order> ordersToCancel = new HashSet<Order>();
    private Configuration configuration;
    private DataRetriever dataRetriever;
    private OrderGiver orderGiver;
    private OrderMonitor orderMonitor;
    private ServerStateMonitor serverStateMonitor;
    private Set<Notifier> notifiers;
    private VLMaDao vlmaDao;

    @Override
    public List<Satellite> getSatellites() {
        return this.vlmaDao.getSatellites();
    }

    @Override
    public List<Server> getServers() {
        return this.vlmaDao.getServers();
    }

    @Override
    public List<Media> getMedias() {
        return this.vlmaDao.getMedias();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Order> getOrders() {
        Set<Order> set = this.orders;
        synchronized (set) {
            return this.orders;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Order> getOrdersToCancel() {
        Set<Order> set = this.ordersToCancel;
        synchronized (set) {
            return this.ordersToCancel;
        }
    }

    @Override
    public void giveOrders() {
        this.orderGiver.giveOrders();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelOrder(Order order) {
        Set<Order> set = this.ordersToCancel;
        synchronized (set) {
            this.ordersToCancel.add(order);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendNotification(String message) {
        Iterator<Notifier> i$ = this.notifiers.iterator();
        while (i$.hasNext()) {
            Notifier notifier;
            Notifier notifier2 = notifier = i$.next();
            synchronized (notifier2) {
                notifier.sendNotification(message);
            }
        }
    }

    @Override
    public void startOrderMonitoring() {
        this.orderMonitor.startOrderMonitoringThread();
    }

    @Override
    public void startCheckAllVLCs() {
        this.serverStateMonitor.startCheckVLCThread();
    }

    private File getRrdDir() throws IOException {
        String basePath = this.configuration.getString("vlma.data");
        File rrdDir = new File(basePath, "rrd");
        if (!rrdDir.exists()) {
            rrdDir.mkdir();
        }
        return rrdDir;
    }

    private String createRrdFileIfNecessary(Server server) throws IOException {
        File rrdR = new File(this.getRrdDir(), server.getName() + ".rrd");
        if (!rrdR.exists()) {
            logger.info((Object)("Creating RRD file of " + server.getName()));
            try {
                RrdDef rrdDef = new RrdDef(rrdR.getPath());
                rrdDef.setStartTime(Util.getTime());
                rrdDef.addDatasource(Data.CPU_LOAD.name().toLowerCase(), "GAUGE", 300L, 0.0, Double.NaN);
                rrdDef.addDatasource(Data.TRAFFIC_IN.name().toLowerCase(), "COUNTER", 300L, 0.0, Double.NaN);
                rrdDef.addDatasource(Data.TRAFFIC_OUT.name().toLowerCase(), "COUNTER", 300L, 0.0, Double.NaN);
                rrdDef.addDatasource(Data.VLC_CPU.name().toLowerCase(), "GAUGE", 300L, 0.0, Double.NaN);
                rrdDef.addDatasource(Data.VLC_MEM.name().toLowerCase(), "GAUGE", 300L, 0.0, Double.NaN);
                rrdDef.addArchive("AVERAGE", 0.5, 1, 4000);
                rrdDef.addArchive("AVERAGE", 0.5, 6, 4000);
                rrdDef.addArchive("AVERAGE", 0.5, 24, 4000);
                rrdDef.addArchive("AVERAGE", 0.5, 288, 4000);
                RrdDbPool rrdPool = RrdDbPool.getInstance();
                RrdDb rrdDb = rrdPool.requestRrdDb(rrdDef);
                rrdPool.release(rrdDb);
            }
            catch (RrdException e) {
                logger.error((Object)("Error while creating RRD file of " + rrdR.getPath()), (Throwable)e);
            }
            catch (IOException e) {
                logger.error((Object)("Error while creating RRD file of " + rrdR.getPath()), (Throwable)e);
            }
        }
        return rrdR.getPath();
    }

    @Override
    public void updateSnmpData(Server server) {
        String rrdFile;
        try {
            rrdFile = this.createRrdFileIfNecessary(server);
        }
        catch (IOException e) {
            logger.error((Object)("Error while creating RRD file of " + server.getName()), (Throwable)e);
            return;
        }
        RrdDbPool rrdPool = RrdDbPool.getInstance();
        RrdDb rrdDb = null;
        Sample sample = null;
        try {
            rrdDb = rrdPool.requestRrdDb(rrdFile);
            sample = rrdDb.createSample();
        }
        catch (Exception e) {
            logger.error((Object)("Cannot instanciate the RRD database for server" + server.getName()), (Throwable)e);
        }
        for (Data data : Data.values()) {
            String value = this.dataRetriever.retrieve(server, data);
            if (value == null) {
                value = "0";
            }
            try {
                if (Data.TRAFFIC_IN.equals((Object)data) || Data.TRAFFIC_OUT.equals((Object)data)) {
                    sample.setValue(data.name().toLowerCase(), (double)Long.parseLong(value.trim()));
                    continue;
                }
                sample.setValue(data.name().toLowerCase(), Double.parseDouble(value.trim()));
            }
            catch (Exception e) {
                if (e instanceof NumberFormatException) {
                    logger.error((Object)("Cannot convert value to the expected format (Server " + server.getName() + ")"), (Throwable)e);
                } else {
                    logger.error((Object)"Error while adding value to the RRD database", (Throwable)e);
                }
                try {
                    if (Data.TRAFFIC_IN.equals((Object)data) || Data.TRAFFIC_OUT.equals((Object)data)) {
                        sample.setValue(data.name().toLowerCase(), 0.0);
                        continue;
                    }
                    sample.setValue(data.name().toLowerCase(), 0.0);
                }
                catch (RrdException f) {
                    logger.error((Object)"Unexpected error!", (Throwable)f);
                }
            }
        }
        try {
            sample.update();
        }
        catch (Exception e) {
            logger.error((Object)("Cannot update sample of server " + server.getName()), (Throwable)e);
        }
        try {
            rrdPool.release(rrdDb);
        }
        catch (Exception e) {
            logger.error((Object)("Cannot release RRD database for server " + server.getName()), (Throwable)e);
        }
    }

    @Override
    public void updateRrdGraph(Server server) {
        long endTime = Util.getTime();
        long startTime = endTime - 86400L;
        try {
            File rrdDir = this.getRrdDir();
            RrdGraphDef graphDef = new RrdGraphDef();
            graphDef.datasource("cpu_load", this.createRrdFileIfNecessary(server), "cpu_load", "AVERAGE");
            graphDef.area("cpu_load", Color.RED, "CPU load@L");
            graphDef.line("cpu_load", Color.BLUE, "CPU load@L", 3);
            graphDef.gprint("cpu_load", "AVERAGE", "Average CPU load: @3@r");
            graphDef.setLowerLimit(0.0);
            graphDef.setTimePeriod(startTime, endTime);
            graphDef.setTitle("Load");
            RrdGraph rrdGraph = new RrdGraph(graphDef);
            File rrdGraphFile = new File(rrdDir, server.getName() + "-cpu_load.png");
            rrdGraph.saveAsPNG(rrdGraphFile.getAbsolutePath());
            graphDef = new RrdGraphDef();
            graphDef.datasource("traffic_out", this.createRrdFileIfNecessary(server), "traffic_out", "AVERAGE");
            graphDef.line("traffic_out", Color.BLUE, "Outgoing traffic@L", 3);
            graphDef.setLowerLimit(0.0);
            graphDef.setTimePeriod(startTime, endTime);
            graphDef.setTitle("Outgoing traffic");
            rrdGraph = new RrdGraph(graphDef);
            rrdGraphFile = new File(rrdDir, server.getName() + "-traffic_out.png");
            rrdGraph.saveAsPNG(rrdGraphFile.getAbsolutePath());
            graphDef = new RrdGraphDef();
            graphDef.datasource("vlc_cpu", this.createRrdFileIfNecessary(server), "vlc_cpu", "AVERAGE");
            graphDef.datasource("vlc_mem", this.createRrdFileIfNecessary(server), "vlc_mem", "AVERAGE");
            graphDef.line("vlc_cpu", Color.RED, "CPU usage for VLC");
            graphDef.line("vlc_mem", Color.BLUE, "Memory usage for VLC");
            graphDef.setLowerLimit(0.0);
            graphDef.setTimePeriod(startTime, endTime);
            graphDef.setTitle("Resources used for VLC");
            rrdGraph = new RrdGraph(graphDef);
            rrdGraphFile = new File(rrdDir, server.getName() + "-vlc.png");
            rrdGraph.saveAsPNG(rrdGraphFile.getAbsolutePath());
        }
        catch (RrdException e) {
            logger.error((Object)("Error while creating RRD file of " + server.getName()), (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)("Error while creating RRD file of " + server.getName()), (Throwable)e);
        }
    }

    @Override
    public synchronized boolean checkVLC(Server server) {
        boolean formerState = server.isUp();
        try {
            Socket socket = new Socket();
            socket.connect(new InetSocketAddress(server.getIp(), this.configuration.getInt("vlc.telnet.port")), 5000);
            socket.close();
            server.setUp(true);
            logger.debug((Object)("VLC of " + server.getName() + " is reachable"));
        }
        catch (IOException e) {
            logger.info((Object)("Unable to contact VLC server of " + server.getName() + " through telnet interface"));
            server.setUp(false);
        }
        boolean newState = server.isUp();
        if (newState != formerState) {
            this.sendNotification(server.getName() + " is " + (newState ? "up" : "down"));
        }
        return server.isUp();
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setDataRetriever(DataRetriever dataRetriever) {
        this.dataRetriever = dataRetriever;
    }

    public void setOrderGiver(OrderGiver orderGiver) {
        this.orderGiver = orderGiver;
    }

    public void setOrderMonitor(OrderMonitor orderMonitor) {
        this.orderMonitor = orderMonitor;
    }

    public void setServerStateMonitor(ServerStateMonitor serverStateMonitor) {
        this.serverStateMonitor = serverStateMonitor;
    }

    public void setNotifiers(Set<Notifier> notifiers) {
        this.notifiers = notifiers;
    }

    public void setVlmaDao(VLMaDao vlmaDao) {
        this.vlmaDao = vlmaDao;
    }
}

