---
layout: post
title: Polyglot 1.8.0 - 커뮤니티 제공물 릴리스
lang: ko
---

몇 가지 기능 향상과 커뮤니티 문서 및 기여를 인정하는 Jekyll-Polyglot 1.8.0에 대해 기대를 높이세요! 몇 가지 기능 향상과 커뮤니티 문서 및 기여를 인정하는 제킬-폴리글롯 1.8.0 에 대해 기대를 높이세요!

## 언어별 고유 링크

한 가지 새로운 기능은 페이지에 언어별 고유 링크를 제공하고 다른 상대 페이지와의 연결을 유지하는 것입니다. 이 새로운 기능은 또 다시 **[antoniovazquezblanco](https://github.com/antoniovazquezblanco)** 에 의해 개선되었습니다, 진실된 신사이면서 학식 있는 분입니다.

## 사이트맵 생성 및 다국어 SEO

 이 릴리스는 또한 품질을 인정합니다 [sitemap.xml]({{ site.url }}/sitemap.xml) 그리고 [robots.txt]({{ site.url }}/robots.txt) solution provided by **[jerturowetz](https://github.com/jerturowetz)**. 이 사이트는 이제 검색 엔진에 의해 정적 제킬 웹사이트로 크롤링될 수 있도록 이러한 설정을 사용하여 더 많은 SEO 기능을 보여주고 활용합니다. [여기](https://github.com/untra/polyglot/tree/master/site) 예시 웹사이트 파일을 참조하십시오.

## jekyll :polyglot :post_write hook

Github 사용자  **[obfusk](https://github.com/obfusk)** 몇 년 전 작은  [기여를 했습니다](https://github.com/untra/polyglot/pull/142) 기여를 했습니다.

을 사용하여 polyglot `:site, :post_write` 이 기능은 각 자식 프로세스 실행 시 한 번 실행됩니다:

```rb
Jekyll::Hooks.register :site, :post_write do |site|
  ...
end
```

 이 릴리스는 모든 언어가 처리된 후 정확히 한 번 실행되는 사용자 정의 후크 `:post_write` 를 추가합니다 (여부 `parallel_localization` 사용됩니다):

```rb
Jekyll::Hooks.register :polyglot, :post_write do |site|
  # 여기서 놀라운 것을 만들어 보세요!
end
```

 이 기능은 추가적인 활용이 필요한 복잡한 제킬 정적 사이트에 유용합니다  [jekyll hook plugins](https://jekyllrb.com/docs/plugins/hooks/).

그녀는 또한 다음과 같은 문제를 해결하는 [언어 서브 프로세스 충돌 시 추가 로깅](https://github.com/untra/polyglot/pull/145). 이 기여에 감사합니다!

## 지역 변수 및 포르투갈어 번역

**[george-gca](https://github.com/george-gca)** 재능이 뛰어나고 멋진 분입니다, 그는 [전체 블로그 게시물을 기고했습니다](/2024/02/29/localized-variables/) 웹사이트 데이터에서 리치 텍스트를 가장 효과적으로 로컬라이징하는 방법에 대한. 그는 또한 제공했습니다 [브라질 포르투갈어 사이트 번역](https://polyglot.untra.io/pt-BR/). 

