/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */
#ifndef INCLUDED_SVX_INC_HELPIDS_H
#define INCLUDED_SVX_INC_HELPIDS_H

#include <rtl/string.hxx>

inline constexpr OStringLiteral HID_BMPMASK_CTL_QCOL_1 = "SVX_HID_BMPMASK_CTL_QCOL_1";
inline constexpr OStringLiteral HID_COLOR_CTL_COLORS = "SVX_HID_COLOR_CTL_COLORS";
inline constexpr OStringLiteral HID_CTRL3D_HSCROLL = "SVX_HID_CTRL3D_HSCROLL";
inline constexpr OStringLiteral HID_CTRL3D_SWITCHER = "SVX_HID_CTRL3D_SWITCHER";
inline constexpr OStringLiteral HID_CTRL3D_VSCROLL = "SVX_HID_CTRL3D_VSCROLL";
inline constexpr OStringLiteral HID_CTRL_COLOR = "SVX_HID_CTRL_COLOR";
inline constexpr OStringLiteral HID_GALLERY_ICONVIEW = "SVX_HID_GALLERY_ICONVIEW";
inline constexpr OStringLiteral HID_GALLERY_LISTVIEW = "SVX_HID_GALLERY_LISTVIEW";
inline constexpr OStringLiteral HID_GALLERY_NEWTHEME = "SVX_HID_GALLERY_NEWTHEME";
inline constexpr OStringLiteral HID_GALLERY_THEMELIST = "SVX_HID_GALLERY_THEMELIST";
inline constexpr OStringLiteral HID_GALLERY_WINDOW = "SVX_HID_GALLERY_WINDOW";
inline constexpr OStringLiteral HID_POPUP_COLOR = "SVX_HID_POPUP_COLOR";
inline constexpr OStringLiteral HID_POPUP_COLOR_CTRL = "SVX_HID_POPUP_COLOR_CTRL";
inline constexpr OStringLiteral HID_POPUP_FRAME = "SVX_HID_POPUP_FRAME";
inline constexpr OStringLiteral HID_POPUP_LINE = "SVX_HID_POPUP_LINE";
inline constexpr OStringLiteral HID_POPUP_LINEEND = "SVX_HID_POPUP_LINEEND";
inline constexpr OStringLiteral HID_POPUP_LINEEND_CTRL = "SVX_HID_POPUP_LINEEND_CTRL";
inline constexpr OStringLiteral HID_STYLE_LISTBOX = "SVX_HID_STYLE_LISTBOX";
inline constexpr OStringLiteral HID_VALUESET_EXTRUSION_LIGHTING = "SVX_HID_VALUESET_EXTRUSION_LIGHTING";
inline constexpr OStringLiteral HID_UNDERLINE_BTN = "SVX_HID_UNDERLINE_BTN";
inline constexpr OStringLiteral HID_SPACING_MB_KERN = "SVX_HID_SPACING_MB_KERN";

inline constexpr OStringLiteral HID_FORM_NAVIGATOR = "SVX_HID_FORM_NAVIGATOR";
inline constexpr OStringLiteral HID_FORM_NAVIGATOR_WIN = "SVX_HID_FORM_NAVIGATOR_WIN";
inline constexpr OStringLiteral HID_FIELD_SEL = "SVX_HID_FIELD_SEL";
inline constexpr OStringLiteral HID_FIELD_SEL_WIN = "SVX_HID_FIELD_SEL_WIN";
inline constexpr OStringLiteral HID_FILTER_NAVIGATOR = "SVX_HID_FILTER_NAVIGATOR";
inline constexpr OStringLiteral HID_FILTER_NAVIGATOR_WIN = "SVX_HID_FILTER_NAVIGATOR_WIN";
inline constexpr OStringLiteral HID_GRID_TRAVEL_FIRST = "SVX_HID_GRID_TRAVEL_FIRST";
inline constexpr OStringLiteral HID_GRID_TRAVEL_PREV = "SVX_HID_GRID_TRAVEL_PREV";
inline constexpr OStringLiteral HID_GRID_TRAVEL_NEXT = "SVX_HID_GRID_TRAVEL_NEXT";
inline constexpr OStringLiteral HID_GRID_TRAVEL_LAST = "SVX_HID_GRID_TRAVEL_LAST";
inline constexpr OStringLiteral HID_GRID_TRAVEL_NEW = "SVX_HID_GRID_TRAVEL_NEW";
inline constexpr OStringLiteral HID_GRID_TRAVEL_ABSOLUTE = "SVX_HID_GRID_TRAVEL_ABSOLUTE";
inline constexpr OStringLiteral HID_GRID_NUMBEROFRECORDS = "SVX_HID_GRID_NUMBEROFRECORDS";

// Help IDs for Manage Track Changes
inline constexpr OStringLiteral HID_REDLINE_CTRL_VIEW = "SVX_HID_REDLINE_CTRL_VIEW";
inline constexpr OStringLiteral HID_REDLINE_CTRL_FILTER = "SVX_HID_REDLINE_CTRL_FILTER";

#endif

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
