/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

#ifndef INCLUDED_SC_SOURCE_UI_INC_CONSDLG_HXX
#define INCLUDED_SC_SOURCE_UI_INC_CONSDLG_HXX

#include <vcl/lstbox.hxx>
#include <vcl/layout.hxx>
#include <global.hxx>
#include "anyrefdg.hxx"

class ScViewData;
class ScDocument;
class ScRangeUtil;
class ScAreaData;

class ScConsolidateDlg : public ScAnyRefDlg
{
public:
                    ScConsolidateDlg( SfxBindings* pB, SfxChildWindow* pCW, vcl::Window* pParent,
                                      const SfxItemSet& rArgSet );
                    virtual ~ScConsolidateDlg() override;
    virtual void    dispose() override;

    virtual void    SetReference( const ScRange& rRef, ScDocument* pDoc ) override;

    virtual bool    IsRefInputMode() const override { return true; }
    virtual void    SetActive() override;

    virtual bool    Close() override;

protected:
    virtual void    Deactivate() override;

private:
    VclPtr<ListBox>         pLbFunc;
    VclPtr<ListBox>         pLbConsAreas;

    VclPtr<ListBox>         pLbDataArea;
    VclPtr<formula::RefEdit>        pEdDataArea;
    VclPtr<formula::RefButton>      pRbDataArea;

    VclPtr<ListBox>         pLbDestArea;
    VclPtr<formula::RefEdit>        pEdDestArea;
    VclPtr<formula::RefButton>      pRbDestArea;

    VclPtr<VclExpander>     pExpander;
    VclPtr<CheckBox>        pBtnByRow;
    VclPtr<CheckBox>        pBtnByCol;

    VclPtr<CheckBox>        pBtnRefs;

    VclPtr<OKButton>        pBtnOk;
    VclPtr<CancelButton>    pBtnCancel;
    VclPtr<PushButton>      pBtnAdd;
    VclPtr<PushButton>      pBtnRemove;

    OUString const         aStrUndefined;

    ScConsolidateParam const  theConsData;
    ScViewData&         rViewData;
    ScDocument* const         pDoc;
    std::unique_ptr<ScRangeUtil>  pRangeUtil;
    std::unique_ptr<ScAreaData[]> pAreaData;
    size_t              nAreaDataCount;
    sal_uInt16 const          nWhichCons;

    VclPtr<formula::RefEdit>   pRefInputEdit;
    bool                bDlgLostFocus;

    void Init               ();
    void FillAreaLists      ();
    bool VerifyEdit         ( formula::RefEdit* pEd );

    DECL_LINK( OkHdl,    Button*, void );
    DECL_LINK( ClickHdl, Button*, void );
    DECL_LINK( GetFocusHdl, Control&, void );
    DECL_LINK( ModifyHdl, Edit&, void );
    DECL_LINK( SelectHdl, ListBox&, void );

    static ScSubTotalFunc  LbPosToFunc( sal_Int32 nPos );
    static sal_Int32      FuncToLbPos( ScSubTotalFunc eFunc );
};

#endif // INCLUDED_SC_SOURCE_UI_INC_CONSDLG_HXX

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
