/*
 Leaflet 0.8-dev (dc0001e9), a JS library for interactive maps. http://leafletjs.com
 (c) 2010-2015 Vladimir Agafonkin, (c) 2010-2011 CloudMade
*/
!function(t,e,i){function n(){var e=t.L;s.noConflict=function(){return t.L=e,this},t.L=s}function o(t){for(var e=[],i=new Uint8Array(t),n=0;n<i.length;n++){var o=i[n].toString(16),s=("00"+o).slice(-2);e.push(s)}return e.join("")}var s={version:"0.8-dev"};"object"==typeof module&&"object"==typeof module.exports?module.exports=s:"function"==typeof define&&define.amd&&define(s),"undefined"!=typeof t&&n(),s.Log={log:function(t,e,i,n){n||(n=Date.now()),this._logs||(this._logs=[]),t=t.replace(/(\r\n|\n|\r)/gm," "),this._logs.push({msg:t,direction:e,coords:i,time:n})},_getEntries:function(){this._logs.sort(function(t,e){return t.time<e.time?-1:t.time>e.time?1:0});for(var t="",e=0;e<this._logs.length;e++)t+=this._logs[e].time+"."+this._logs[e].direction+"."+this._logs[e].msg+"."+this._logs[e].coords,t+="\n";return t},print:function(){},save:function(){var i=new Blob([this._getEntries()],{type:"text/csv"}),n=e.createEvent("MouseEvents"),o=e.createElement("a");o.download=Date.now()+".csv",o.href=t.URL.createObjectURL(i),o.dataset.downloadurl=["text/csv",o.download,o.href].join(":"),n.initMouseEvent("click",!0,!1,t,0,0,0,0,0,!1,!1,!1,!1,0,null),o.dispatchEvent(n)},clear:function(){this._logs=[]}},s.INCOMING="INCOMING",s.OUTGOING="OUTGOING",s.Util={extend:function(t){var e,i,n,o;for(i=1,n=arguments.length;n>i;i++){o=arguments[i];for(e in o)t[e]=o[e]}return t},create:Object.create||function(){function t(){}return function(e){return t.prototype=e,new t}}(),bind:function(t,e){var i=Array.prototype.slice;if(t.bind)return t.bind.apply(t,i.call(arguments,1));var n=i.call(arguments,2);return function(){return t.apply(e,n.length?n.concat(i.call(arguments)):arguments)}},stamp:function(t){return t._leaflet_id=t._leaflet_id||++s.Util.lastId,t._leaflet_id},lastId:0,throttle:function(t,e,i){var n,o,s,a;return a=function(){n=!1,o&&(s.apply(i,o),o=!1)},s=function(){n?o=arguments:(t.apply(i,arguments),setTimeout(a,e),n=!0)}},wrapNum:function(t,e,i){var n=e[1],o=e[0],s=n-o;return t===n&&i?t:((t-o)%s+s)%s+o},falseFn:function(){return!1},formatNum:function(t,e){var i=Math.pow(10,e||5);return Math.round(t*i)/i},trim:function(t){return t.trim?t.trim():t.replace(/^\s+|\s+$/g,"")},splitWords:function(t){return s.Util.trim(t).split(/\s+/)},setOptions:function(t,e){t.hasOwnProperty("options")||(t.options=t.options?s.Util.create(t.options):{});for(var i in e)t.options[i]=e[i];return t.options},getParamString:function(t,e,i){var n=[];for(var o in t)n.push(encodeURIComponent(i?o.toUpperCase():o)+"="+encodeURIComponent(t[o]));return(e&&-1!==e.indexOf("?")?"&":"?")+n.join("&")},round:function(t,e){if(!e)return Math.round(t);var i=1/e;return Math.round(t*i)*e},template:function(t,e){return t.replace(s.Util.templateRe,function(t,n){var o=e[n];if(o===i)throw new Error("No value provided for variable "+t);return"function"==typeof o&&(o=o(e)),o})},templateRe:/\{ *([\w_]+) *\}/g,isArray:Array.isArray||function(t){return"[object Array]"===Object.prototype.toString.call(t)},emptyImageUrl:"data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs="},function(){function e(e){return t["webkit"+e]||t["moz"+e]||t["ms"+e]}function i(e){var i=+new Date,o=Math.max(0,16-(i-n));return n=i+o,t.setTimeout(e,o)}var n=0,o=t.requestAnimationFrame||e("RequestAnimationFrame")||i,a=t.cancelAnimationFrame||e("CancelAnimationFrame")||e("CancelRequestAnimationFrame")||function(e){t.clearTimeout(e)};s.Util.requestAnimFrame=function(e,n,a){return a&&o===i?void e.call(n):o.call(t,s.bind(e,n))},s.Util.cancelAnimFrame=function(e){e&&a.call(t,e)}}(),s.extend=s.Util.extend,s.bind=s.Util.bind,s.stamp=s.Util.stamp,s.setOptions=s.Util.setOptions,s.round=s.Util.round,s.LOUtil={darkColors:[[198,146,0],[6,70,162],[87,157,28],[105,43,157],[197,0,11],[0,128,128],[140,132,0],[53,85,107],[209,118,0]],startSpinner:function(t,e){var i;t.width=50,t.height=50;var n=t.getContext("2d");n.lineWidth=8,n.strokeStyle="grey";var o=t.width/2,s=t.height/2,a=s-n.lineWidth/2;return i=setInterval(function(){n.clearRect(0,0,2*o,2*s),n.translate(o,s),n.rotate(e*Math.PI/180),n.translate(-o,-s),n.beginPath(),n.arc(o,s,a,0,1.3*Math.PI),n.stroke()},1)},getViewIdColor:function(t){var e=this.darkColors[(t+1)%this.darkColors.length];return e[2]|e[1]<<8|e[0]<<16},rgbToHex:function(t){return"#"+("000000"+t.toString(16)).slice(-6)},stringToPoint:function(t){var e=t.match(/\d+/g);return s.point(parseInt(e[0]),parseInt(e[1]))},stringToBounds:function(t){var e=t.match(/\d+/g),i=s.point(parseInt(e[0]),parseInt(e[1])),n=i.add(s.point(parseInt(e[2]),parseInt(e[3])));return s.bounds(i,n)},stringToRectangles:function(t){var e=t.match(/\d+/g),i=[];if(null!==e)for(var n=0;n<e.length;n+=4){var o=s.point(parseInt(e[n]),parseInt(e[n+1])),a=s.point(parseInt(e[n+2]),parseInt(e[n+3])),r=o.add(s.point(a.x,0)),l=o.add(s.point(0,a.y)),h=o.add(a);i.push([l,h,o,r])}return i}},s.Class=function(){},s.Class.extend=function(t){var e=function(){this.initialize&&this.initialize.apply(this,arguments),this.callInitHooks()},i=e.__super__=this.prototype,n=s.Util.create(i);n.constructor=e,e.prototype=n;for(var o in this)this.hasOwnProperty(o)&&"prototype"!==o&&(e[o]=this[o]);return t.statics&&(s.extend(e,t.statics),delete t.statics),t.includes&&(s.Util.extend.apply(null,[n].concat(t.includes)),delete t.includes),n.options&&(t.options=s.Util.extend(s.Util.create(n.options),t.options)),s.extend(n,t),n._initHooks=[],n.callInitHooks=function(){if(!this._initHooksCalled){i.callInitHooks&&i.callInitHooks.call(this),this._initHooksCalled=!0;for(var t=0,e=n._initHooks.length;e>t;t++)n._initHooks[t].call(this)}},e},s.Class.include=function(t){s.extend(this.prototype,t)},s.Class.mergeOptions=function(t){s.extend(this.prototype.options,t)},s.Class.addInitHook=function(t){var e=Array.prototype.slice.call(arguments,1),i="function"==typeof t?t:function(){this[t].apply(this,e)};this.prototype._initHooks=this.prototype._initHooks||[],this.prototype._initHooks.push(i)},s.Evented=s.Class.extend({on:function(t,e,i){if("object"==typeof t)for(var n in t)this._on(n,t[n],e);else{t=s.Util.splitWords(t);for(var o=0,a=t.length;a>o;o++)this._on(t[o],e,i)}return this},off:function(t,e,i){if(t)if("object"==typeof t)for(var n in t)this._off(n,t[n],e);else{t=s.Util.splitWords(t);for(var o=0,a=t.length;a>o;o++)this._off(t[o],e,i)}else delete this._events;return this},_on:function(t,e,i){var n=this._events=this._events||{},o=i&&i!==this&&s.stamp(i);if(o){var a=t+"_idx",r=t+"_len",l=n[a]=n[a]||{},h=s.stamp(e)+"_"+o;l[h]||(l[h]={fn:e,ctx:i},n[r]=(n[r]||0)+1)}else n[t]=n[t]||[],n[t].push({fn:e})},_off:function(t,e,i){var n=this._events,o=t+"_idx",a=t+"_len";if(n){if(!e)return delete n[t],delete n[o],void delete n[a];var r,l,h,d,u,c=i&&i!==this&&s.stamp(i);if(c)u=s.stamp(e)+"_"+c,r=n[o],r&&r[u]&&(d=r[u],delete r[u],n[a]--);else if(r=n[t])for(l=0,h=r.length;h>l;l++)if(r[l].fn===e){d=r[l],r.splice(l,1);break}d&&(d.fn=s.Util.falseFn)}},fire:function(t,e,i){if(!this.listens(t,i))return this;var n=s.Util.extend({},e,{type:t,target:this}),o=this._events;if(o){var a,r,l,h,d=o[t+"_idx"];if(o[t])for(l=o[t].slice(),a=0,r=l.length;r>a;a++)l[a].fn.call(this,n);for(h in d)d[h].fn.call(d[h].ctx,n)}return i&&this._propagateEvent(n),this},listens:function(t,e){var i=this._events;if(i&&(i[t]||i[t+"_len"]))return!0;if(e)for(var n in this._eventParents)if(this._eventParents[n].listens(t,e))return!0;return!1},once:function(t,e,i){if("object"==typeof t){for(var n in t)this.once(n,t[n],e);return this}var o=s.bind(function(){this.off(t,e,i).off(t,o,i)},this);return this.on(t,e,i).on(t,o,i)},addEventParent:function(t){return this._eventParents=this._eventParents||{},this._eventParents[s.stamp(t)]=t,this},removeEventParent:function(t){return this._eventParents&&delete this._eventParents[s.stamp(t)],this},_propagateEvent:function(t){for(var e in this._eventParents)this._eventParents[e].fire(t.type,s.extend({layer:t.target},t),!0)}});var a=s.Evented.prototype;a.addEventListener=a.on,a.removeEventListener=a.clearAllEventListeners=a.off,a.addOneTimeEventListener=a.once,a.fireEvent=a.fire,a.hasEventListeners=a.listens,s.Mixin={Events:a},s.Socket=s.Class.extend({ProtocolVersionNumber:"0.1",ReconnectCount:0,getParameterValue:function(t){var e=t.indexOf("=");return-1===e?i:t.substring(e+1)},initialize:function(t){console.debug("socket.initialize:"),this._map=t,this._msgQueue=[]},connect:function(){var t=this._map;t.options.permission&&(t.options.docParams.permission=t.options.permission);var e="";""!=t.options.wopiSrc&&(e="?WOPISrc="+t.options.wopiSrc+"&compat=/ws");try{this.socket=new WebSocket(t.options.server+"/lool/"+encodeURIComponent(t.options.doc+"?"+$.param(t.options.docParams))+"/ws"+e)}catch(i){return void this._map.fire("error",{msg:_("Oops, there is a problem connecting to LibreOffice Online : ").replace("LibreOffice Online","undefined"!=typeof brandProductName?brandProductName:"LibreOffice Online")+i,cmd:"socket",kind:"failed",id:3})}if(this.socket.onerror=s.bind(this._onSocketError,this),this.socket.onclose=s.bind(this._onSocketClose,this),this.socket.onopen=s.bind(this._onSocketOpen,this),this.socket.onmessage=s.bind(this._onMessage,this),this.socket.binaryType="arraybuffer",t.options.docParams.access_token&&parseInt(t.options.docParams.access_token_ttl)){var n=9e5;clearTimeout(this._accessTokenExpireTimeout),this._accessTokenExpireTimeout=setTimeout(s.bind(this._sessionExpiredWarning,this),parseInt(t.options.docParams.access_token_ttl)-Date.now()-n)}},_sessionExpiredWarning:function(){clearTimeout(this._accessTokenExpireTimeout);var t=errorMessages.sessionexpiry;parseInt(this._map.options.docParams.access_token_ttl)-Date.now()<=0&&(t=errorMessages.sessionexpired);var e=$.timeago(parseInt(this._map.options.docParams.access_token_ttl)).replace(" ago","");this._map.fire("warn",{msg:t.replace("%time",e)}),this._accessTokenExpireTimeout=setTimeout(s.bind(this._sessionExpiredWarning,this),12e4)},close:function(){this.socket.onerror=function(){},this.socket.onclose=function(){},this.socket.onmessage=function(){},this.socket.close(),this._map.wopi.resetAppLoaded(),this._map.fire("docloaded",{status:!1}),clearTimeout(this._accessTokenExpireTimeout)},connected:function(){return this.socket&&1===this.socket.readyState},sendMessage:function(t,e){if((t.startsWith("useractive")||t.startsWith("userinactive")||this._map._active)&&!this._map._fatal){var i=this.socket.readyState;(2===i||3===i)&&this._map.loadDocument(),1===i?(this.socket.send(t),"string"==typeof t&&(s.Log.log(t,s.OUTGOING,e),this._map._docLayer&&this._map._docLayer._debug&&console.log2(+new Date+" %cOUTGOING%c: "+t.concat(" ").replace(" ","%c "),"background:#fbb;color:black","color:red","color:black"))):this._msgQueue.push({msg:t,coords:e})}},_doSend:function(t,e){"string"==typeof t&&(s.Log.log(t,s.OUTGOING,e),this._map._docLayer&&this._map._docLayer._debug&&console.log2(+new Date+" %cOUTGOING%c: "+t.concat(" ").replace(" ","%c "),"background:#fbb;color:black","color:red","color:black")),this.socket.send(t)},_getParameterByName:function(t,e){e=e.replace(/[\[]/,"\\[").replace(/[\]]/,"\\]");var i=new RegExp("[\\?&]"+e+"=([^&#]*)"),n=i.exec(t);return null===n?"":n[1].replace(/\+/g," ")},_onSocketOpen:function(){console.debug("_onSocketOpen:"),this._map._serverRecycling=!1,this._map._documentIdle=!1,this._doSend("loolclient "+this.ProtocolVersionNumber);var t="load url="+encodeURIComponent(this._map.options.doc);if(this._map._docLayer&&(this._reconnecting=!0,t+=" part="+this._map.getCurrentPartNumber()),this._map.options.timestamp&&(t+=" timestamp="+this._map.options.timestamp),this._map._docPassword&&(t+=" password="+this._map._docPassword),String.locale&&(t+=" lang="+String.locale),this._map.options.renderingOptions){var e={rendering:this._map.options.renderingOptions};t+=" options="+JSON.stringify(e)}this._doSend(t);for(var i=0;i<this._msgQueue.length;i++)this._doSend(this._msgQueue[i].msg,this._msgQueue[i].coords);this._msgQueue=[],this._map._activate()},_utf8ToString:function(t){for(var e="",i=0;i<t.length;i++)e+=String.fromCharCode(t[i]);return e},_onMessage:function(n){var o,a,r;if("string"==typeof n.data)r=n.data;else if("object"==typeof n.data){for(o=new Uint8Array(n.data),a=0;a<o.length&&10!==o[a];)a++;r=String.fromCharCode.apply(null,o.subarray(0,a))}this._map._docLayer&&this._map._docLayer._debug&&console.log2(+new Date+" %cINCOMING%c: "+r.concat(" ").replace(" ","%c "),"background:#ddf;color:black","color:blue","color:black");var l=this.parseServerCmd(r);if(r.startsWith("loolserver ")){var h=JSON.parse(r.substring(r.indexOf("{"))),d=h.Hash;parseInt(d,16).toString(16)===d.toLowerCase().replace(/^0+/,"")?(d='<a target="_blank" href="https://hub.libreoffice.org/git-online/'+d+'">'+d+"</a>",$("#loolwsd-version").html(h.Version+" (git hash: "+d+")")):$("#loolwsd-version").text(h.Version),h.Protocol!==this.ProtocolVersionNumber&&this._map.fire("error",{msg:_("Unsupported server version.")})}else if(r.startsWith("lokitversion ")){var u=JSON.parse(r.substring(r.indexOf("{")));d=u.BuildId.substring(0,7),parseInt(d,16).toString(16)===d.toLowerCase().replace(/^0+/,"")&&(d='<a target="_blank" href="https://hub.libreoffice.org/git-core/'+d+'">'+d+"</a>"),$("#lokit-version").html(u.ProductName+" "+u.ProductVersion+u.ProductExtension.replace(".10.","-")+" (git hash: "+d+")")}else{if(r.startsWith("perm:")){var c=r.substring("perm:".length);return this._map.options.permission="readonly",void this._map.setPermission(c)}if(r.startsWith("wopi: ")){var p=JSON.parse(r.substring(r.indexOf("{")));return void this._map.fire("wopiprops",p)}if(r.startsWith("commandresult: ")){var m=JSON.parse(r.substring(r.indexOf("{")));if("savetostorage"===m.command&&m.success&&vex.dialogID>0){var g=vex.dialogID;vex.dialogID=-1,vex.close(g)}return}if(r.startsWith("close: ")){r=r.substring("close: ".length),M="";var f={};if("ownertermination"===r)M=_("Session terminated by document owner"),f.Reason="OwnerTermination";else if("idle"===r||"oom"===r)M=_("Idle document - please click to reload and resume editing"),this._map._documentIdle=!0,f.Reason="DocumentIdle","oom"===r&&(f.Reason="OOM");else if("shuttingdown"===r)M=_("Server is shutting down for maintenance (auto-saving)"),f.Reason="ShuttingDown";else if("docdisconnected"===r)M=_("Oops, there is a problem connecting the document"),f.Reason="DocumentDisconnected";else if("recycling"===r){M=_("Server is recycling and will be available shortly"),this._map._active=!1,this._map._serverRecycling=!0;var v=5e3,y=1e4,w=Math.floor(Math.random()*(y-v)+v),C=this;P=this._map,vex.timer=setInterval(function(){if(C.connected()){if(clearTimeout(vex.timer),vex.dialogID>0){var t=vex.dialogID;vex.dialogID=-1,vex.close(t)}}else try{P.loadDocument(P)}catch(e){console.warn("Cannot load document.")}},w)}else r.startsWith("documentconflict")&&(M=_("Document has changed in storage. Loading the new document. Your version is available as revision."),this._map._docLayer&&this._map._docLayer.removeAllViews(),this.close(),this._map._active=!1,P=this._map,vex.timer=setInterval(function(){try{P._activate()}catch(t){console.warn("Cannot activate map")}},3e3));vex.dialogID>0&&(g=vex.dialogID,vex.dialogID=-1,vex.close(g));var x="";this._map.wopi.DisableInactiveMessages||(x=M);var b=$.extend({},vex.defaultOptions,{contentCSS:{background:"rgba(0, 0, 0, 0)","font-size":"xx-large",color:"#fff","text-align":"center"},content:x});if(b.id=vex.globalID,vex.dialogID=b.id,vex.globalID+=1,b.$vex=$("<div>").addClass(vex.baseClassNames.vex).addClass(b.className).css(b.css).data({vex:b}),b.$vexOverlay=$("<div>").addClass(vex.baseClassNames.overlay).addClass(b.overlayClassName).css(b.overlayCSS).data({vex:b}),b.$vex.append(b.$vexOverlay),b.$vexContent=$("<div>").addClass(vex.baseClassNames.content).addClass(b.contentClassName).css(b.contentCSS).text(b.content).data({vex:b}),b.$vex.append(b.$vexContent),"idle"===r||"oom"===r){var P=this._map;b.$vex.bind("click.vex",function(){return console.debug("idleness: reactivating"),P._documentIdle=!1,P._activate()})}return $(b.appendLocation).append(b.$vex),vex.setupBodyClassName(b.$vex),f.Reason&&this._map.fire("postMessage",{msgId:"Session_Closed",args:f}),void("ownertermination"===r&&this._map.remove())}if(r.startsWith("error:")&&"storage"===l.errorCmd){this._map.hideBusy();var L;if("savediskfull"===l.errorKind)L=errorMessages.storage.savediskfull;else if("savefailed"===l.errorKind)L=errorMessages.storage.savefailed;else if("saveunauthorized"===l.errorKind)L=errorMessages.storage.saveunauthorized;else if("loadfailed"===l.errorKind)L=errorMessages.storage.loadfailed,this.close();else if("documentconflict"===l.errorKind)return L=errorMessages.storage.documentconflict,vex.dialogID>0&&(g=vex.dialogID,vex.dialogID=-1,vex.close(g)),vex.dialog.confirm({message:_("Document has been changed in storage. Do you want to discard your changes, and load the document from the storage?"),buttons:[$.extend({},vex.dialog.buttons.YES,{text:_("Discard changes")}),$.extend({},vex.dialog.buttons.NO,{text:_("Overwrite document")})],callback:s.bind(function(t){t?this.sendMessage("closedocument"):this.sendMessage("savetostorage force=1")},this)}),void(vex.dialogID=vex.globalID-1);var T=e.createElement("a");return T.href=this._map.options.doc,L=L.replace("%storageserver",T.host),void this._map.fire("warn",{msg:L})}if(r.startsWith("error:")&&"internal"===l.errorCmd)return this._map.hideBusy(),this._map._fatal=!0,"diskfull"===l.errorKind?this._map.fire("error",{msg:errorMessages.diskfull}):"unauthorized"===l.errorKind&&this._map.fire("error",{msg:errorMessages.unauthorized}),this._map._docLayer&&this._map._docLayer.removeAllViews(),void this.close();if(r.startsWith("error:")&&"saveas"===l.errorCmd)this._map.hideBusy();else if(r.startsWith("error:")&&"load"===l.errorCmd){this._map.hideBusy(),this.close();var S=l.errorKind,D=!1;if(S.startsWith("passwordrequired")){D=!0;var M="",I=S.split(":")[1];"to-view"===I?M+=_("Document requires password to view."):"to-modify"===I&&(M+=_("Document requires password to modify."),M+=" ",M+=_("Hit Cancel to open in view-only mode."))}else if(S.startsWith("wrongpassword"))D=!0,M=_("Wrong password provided. Please try again.");else if(S.startsWith("faileddocloading"))this._map._fatal=!0,this._map.fire("error",{msg:errorMessages.faileddocloading});else if(S.startsWith("docunloading")){if(this._map._active=!1,this.ReconnectCount++>=10)return void clearTimeout(vex.timer);P=this._map,vex.timer=setInterval(function(){try{P._activate()}catch(t){console.warn("Cannot activate map")}},1e3)}if(D)return void vex.dialog.open({message:M,input:'<input name="password" type="password" required />',callback:s.bind(function(t){t?(this._map._docPassword=t.password,this._map.loadDocument()):"to-modify"===I?(this._map._docPassword="",this._map.loadDocument()):this._map.hideBusy()},this)})}else if(r.startsWith("error:")&&!this._map._docLayer)r=r.substring(6),"limitreached"===l.errorKind?(this._map._fatal=!0,this._map._active=!1,parseInt(l.params[0])>=50?(r=errorMessages.limitreachedprod,r=r.replace(/%0/g,l.params[0]),r=r.replace(/%1/g,l.params[1])):(r=errorMessages.limitreached,r=r.replace(/%0/g,l.params[0]),r=r.replace(/%1/g,l.params[1]),r=r.replace(/%2/g,"undefined"!=typeof brandProductName?brandProductName:"LibreOffice Online"),r=r.replace(/%3/g,"undefined"!=typeof brandProductFAQURL?brandProductFAQURL:"https://wiki.documentfoundation.org/Development/LibreOffice_Online"))):"serviceunavailable"===l.errorKind&&(this._map._fatal=!0,this._map._active=!1,r=errorMessages.serviceunavailable),this._map.fire("error",{msg:r});else if(r.startsWith("pong ")&&this._map._docLayer&&this._map._docLayer._debug){var k=this._map._docLayer._debugTimePING,E=this._map._docLayer._debugSetTimes(k,+new Date-this._map._docLayer._debugPINGQueue.shift());this._map._docLayer._debugData.ping.setPrefix("Server ping time: "+E+". Rendered tiles: "+l.rendercount+", last: "+(l.rendercount-this._map._docLayer._debugRenderCount)),this._map._docLayer._debugRenderCount=l.rendercount}else if(r.startsWith("saveas:")){if(this._map.hideBusy(),l!==i&&l.url!==i&&""!==l.url){this.close();var U=l.url,O=this._getParameterByName(U,"access_token"),A=this._getParameterByName(U,"access_token_ttl");O!==i?(A===i&&(A=0),this._map.options.docParams={access_token:O,access_token_ttl:A}):this._map.options.docParams={};var B=U.split("?")[0];this._map.options.doc=B,this._map.options.wopiSrc=encodeURIComponent(B),this._map.loadDocument()}}else if(r.startsWith("statusindicator:"))this._map.showBusy(_("Connecting..."),!1),r.startsWith("statusindicator: ready")&&(this.ReconnectCount=0,clearTimeout(vex.timer),vex.dialogID>0&&(g=vex.dialogID,vex.dialogID=-1,vex.close(g)));else if(r.startsWith("tile:")||r.startsWith("renderfont:")||r.startsWith("windowpaint:")){var R=o.subarray(a+1);if(R.length>0&&68==R[0]){console.log("Socket: got a delta !");var N=R}else{for(var H="",z=0;z<R.length;z++)H+=String.fromCharCode(R[z]);N="data:image/png;base64,"+t.btoa(H)}}else{if(s.Log.log(r,s.INCOMING),o!==i)try{r=String.fromCharCode.apply(null,o)}catch(W){r=this._utf8ToString(o)}"object"==typeof n.data&&(r=decodeURIComponent(t.escape(r)))}}if(r.startsWith("status:")){if(this._map._docLayer)this._reconnecting&&(this._reconnecting=!1,this._map._docLayer._onMessage("invalidatetiles: EMPTY",null),this._map.fire("statusindicator",{statusType:"reconnected"}),this._map.setPermission(this._map.options.permission));else{var F=this._map.options.tileWidthTwips,V=this._map.options.tileHeightTwips;if(this._map.options.zoom!==this._map.options.defaultZoom){var Z=this._map.options.crs.scale(this._map.options.defaultZoom-this._map.options.zoom);F=Math.round(F*Z),V=Math.round(V*Z)}var G=null;if("text"===l.type)G=new s.WriterTileLayer("",{permission:this._map.options.permission,tileWidthTwips:F,tileHeightTwips:V,docType:l.type});else if("spreadsheet"===l.type)G=new s.CalcTileLayer("",{permission:this._map.options.permission,tileWidthTwips:F,tileHeightTwips:V,docType:l.type});else{if("presentation"===l.type&&this._map.options.defaultZoom===this._map.options.zoom){var j=this._map.getSize().y/256;F=Math.round(l.height/j),V=Math.round(l.height/j)}G=new s.ImpressTileLayer("",{permission:this._map.options.permission,tileWidthTwips:F,tileHeightTwips:V,docType:l.type})}this._map._docLayer=G,this._map.addLayer(G),this._map.fire("doclayerinit")}this._map.fire("docloaded",{status:!0})}if(r.startsWith("statusindicatorstart:"))return void this._map.fire("statusindicator",{statusType:"start"});if(r.startsWith("statusindicatorsetvalue:")){var q=r.match(/\d+/g)[0];return void this._map.fire("statusindicator",{statusType:"setvalue",value:q})}return r.startsWith("statusindicatorfinish:")?(this._map.fire("statusindicator",{statusType:"finish"}),void this._map._fireInitComplete("statusindicatorfinish")):void(this._map._docLayer&&this._map._docLayer._onMessage(r,N))},_onSocketError:function(){console.debug("_onSocketError:"),this._map.hideBusy()},_onSocketClose:function(){console.debug("_onSocketClose:");var t=this._map._active;this._map.hideBusy(),this._map._active=!1,this._map._docLayer&&this._map._docLayer.removeAllViews(),t&&this._reconnecting&&this._map.fire("error",{msg:_("Well, this is embarrassing, we cannot connect to your document. Please try again."),cmd:"socket",kind:"closed",id:4}),this._map.wopi.resetAppLoaded(),this._map.fire("docloaded",{status:!1}),this._reconnecting||(this._reconnecting=!0,this._map._activate())},parseServerCmd:function(t){for(var e=t.split(/[ \n]+/),i={},n=0;n<e.length;n++)"tileposx="===e[n].substring(0,9)?i.x=parseInt(e[n].substring(9)):"tileposy="===e[n].substring(0,9)?i.y=parseInt(e[n].substring(9)):"x="===e[n].substring(0,2)?i.x=parseInt(e[n].substring(2)):"y="===e[n].substring(0,2)?i.y=parseInt(e[n].substring(2)):"tilewidth="===e[n].substring(0,10)?i.tileWidth=parseInt(e[n].substring(10)):"tileheight="===e[n].substring(0,11)?i.tileHeight=parseInt(e[n].substring(11)):"width="===e[n].substring(0,6)?i.width=parseInt(e[n].substring(6)):"height="===e[n].substring(0,7)?i.height=parseInt(e[n].substring(7)):"part="===e[n].substring(0,5)?i.part=parseInt(e[n].substring(5)):"parts="===e[n].substring(0,6)?i.parts=parseInt(e[n].substring(6)):"current="===e[n].substring(0,8)?i.selectedPart=parseInt(e[n].substring(8)):"id="===e[n].substring(0,3)?i.id=e[n].substring(3).replace(/(\r\n|\n|\r)/gm,""):"type="===e[n].substring(0,5)?i.type=e[n].substring(5).replace(/(\r\n|\n|\r)/gm,""):"cmd="===e[n].substring(0,4)?i.errorCmd=e[n].substring(4):"code="===e[n].substring(0,5)?i.errorCode=e[n].substring(5):"kind="===e[n].substring(0,5)?i.errorKind=e[n].substring(5):"jail="===e[n].substring(0,5)?i.jail=e[n].substring(5):"dir="===e[n].substring(0,4)?i.dir=e[n].substring(4):"name="===e[n].substring(0,5)?i.name=e[n].substring(5):"port="===e[n].substring(0,5)?i.port=e[n].substring(5):"font="===e[n].substring(0,5)?i.font=e[n].substring(5):"char="===e[n].substring(0,5)?i["char"]=e[n].substring(5):"url="===e[n].substring(0,4)?i.url=e[n].substring(4):"viewid="===e[n].substring(0,7)?i.viewid=e[n].substring(7):"params="===e[n].substring(0,7)?i.params=e[n].substring(7).split(","):"renderid="===e[n].substring(0,9)?i.renderid=e[n].substring(9):"rendercount="===e[n].substring(0,12)?i.rendercount=parseInt(e[n].substring(12)):e[n].startsWith("wid=")?i.wireId=this.getParameterValue(e[n]):"title="===e[n].substring(0,6)?i.title=e[n].substring(6):"dialogwidth="===e[n].substring(0,12)?i.dialogwidth=e[n].substring(12):"dialogheight="===e[n].substring(0,13)?i.dialogheight=e[n].substring(13):"rectangle="===e[n].substring(0,10)&&(i.rectangle=e[n].substring(10));if(i.tileWidth&&i.tileHeight&&this._map._docLayer){var o=this._map.options.zoom,s=i.tileWidth/this._map._docLayer.options.tileWidthTwips;i.zoom=Math.round(o-Math.log(s)/Math.log(1.2))}return i}}),s.socket=function(t){return new s.Socket(t)},function(){var i=navigator.userAgent.toLowerCase(),n=e.documentElement,o="ActiveXObject"in t,a=-1!==i.indexOf("webkit"),r=-1!==i.indexOf("phantom"),l=-1!==i.search("android [23]"),h=-1!==i.indexOf("chrome"),d=-1!==i.indexOf("gecko")&&!a&&!t.opera&&!o,u=0===navigator.platform.indexOf("Win"),c="undefined"!=typeof orientation||-1!==i.indexOf("mobile"),_=!t.PointerEvent&&t.MSPointerEvent,p=t.PointerEvent&&navigator.pointerEnabled&&navigator.maxTouchPoints||_,m=o&&"transition"in n.style,g="WebKitCSSMatrix"in t&&"m11"in new t.WebKitCSSMatrix&&!l,f="MozPerspective"in n.style,v="OTransition"in n.style,y=!t.L_NO_TOUCH&&(p||"ontouchstart"in t||t.DocumentTouch&&e instanceof t.DocumentTouch);s.Browser={ie:o,ielt9:o&&!e.addEventListener,edge:"msLaunchUri"in navigator&&!("documentMode"in e),webkit:a,gecko:d,android:-1!==i.indexOf("android"),android23:l,chrome:h,safari:!h&&-1!==i.indexOf("safari"),win:u,ie3d:m,webkit3d:g,gecko3d:f,opera12:v,any3d:!t.L_DISABLE_3D&&(m||g||f)&&!v&&!r,mobile:c,mobileWebkit:c&&a,mobileWebkit3d:c&&g,mobileOpera:c&&t.opera,mobileGecko:c&&d,touch:!!y,msPointer:!!_,pointer:!!p,retina:(t.devicePixelRatio||t.screen.deviceXDPI/t.screen.logicalXDPI)>1}}(),s.Point=function(t,e,i){this.x=i?Math.round(t):t,this.y=i?Math.round(e):e},s.Point.prototype={clone:function(){return new s.Point(this.x,this.y)},add:function(t){return this.clone()._add(s.point(t))},_add:function(t){return this.x+=t.x,this.y+=t.y,this},subtract:function(t){return this.clone()._subtract(s.point(t))},_subtract:function(t){return this.x-=t.x,this.y-=t.y,this},divideBy:function(t){return this.clone()._divideBy(t)},_divideBy:function(t){return this.x/=t,this.y/=t,this},multiplyBy:function(t){return this.clone()._multiplyBy(t)},_multiplyBy:function(t){return this.x*=t,this.y*=t,this},round:function(){return this.clone()._round()},_round:function(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this},floor:function(){return this.clone()._floor()},_floor:function(){return this.x=Math.floor(this.x),this.y=Math.floor(this.y),this},ceil:function(){return this.clone()._ceil()},_ceil:function(){return this.x=Math.ceil(this.x),this.y=Math.ceil(this.y),this},distanceTo:function(t){t=s.point(t);var e=t.x-this.x,i=t.y-this.y;return Math.sqrt(e*e+i*i)},equals:function(t){return t=s.point(t),t.x===this.x&&t.y===this.y},contains:function(t){return t=s.point(t),Math.abs(t.x)<=Math.abs(this.x)&&Math.abs(t.y)<=Math.abs(this.y)},toString:function(){return"Point("+s.Util.formatNum(this.x)+", "+s.Util.formatNum(this.y)+")"}},s.point=function(t,e,n){return t instanceof s.Point?t:s.Util.isArray(t)?new s.Point(t[0],t[1]):t===i||null===t?t:new s.Point(t,e,n)},s.Bounds=function(t,e){if(t)for(var i=e?[t,e]:t,n=0,o=i.length;o>n;n++)this.extend(i[n])},s.Bounds.prototype={extend:function(t){return t=s.point(t),this.min||this.max?(this.min.x=Math.min(t.x,this.min.x),this.max.x=Math.max(t.x,this.max.x),this.min.y=Math.min(t.y,this.min.y),this.max.y=Math.max(t.y,this.max.y)):(this.min=t.clone(),this.max=t.clone()),this},getCenter:function(t){return new s.Point((this.min.x+this.max.x)/2,(this.min.y+this.max.y)/2,t)},getBottomLeft:function(){return new s.Point(this.min.x,this.max.y)},getTopRight:function(){return new s.Point(this.max.x,this.min.y)},getSize:function(){return this.max.subtract(this.min)},contains:function(t){var e,i;return t="number"==typeof t[0]||t instanceof s.Point?s.point(t):s.bounds(t),t instanceof s.Bounds?(e=t.min,i=t.max):e=i=t,e.x>=this.min.x&&i.x<=this.max.x&&e.y>=this.min.y&&i.y<=this.max.y},intersects:function(t){t=s.bounds(t);var e=this.min,i=this.max,n=t.min,o=t.max,a=o.x>=e.x&&n.x<=i.x,r=o.y>=e.y&&n.y<=i.y;return a&&r},isValid:function(){return!(!this.min||!this.max)}},s.bounds=function(t,e){return!t||t instanceof s.Bounds?t:new s.Bounds(t,e)},s.Transformation=function(t,e,i,n){this._a=t,this._b=e,this._c=i,this._d=n},s.Transformation.prototype={transform:function(t,e){return this._transform(t.clone(),e)},_transform:function(t,e){return e=e||1,t.x=e*(this._a*t.x+this._b),t.y=e*(this._c*t.y+this._d),t},untransform:function(t,e){return e=e||1,new s.Point((t.x/e-this._b)/this._a,(t.y/e-this._d)/this._c)}},s.DomUtil={get:function(t){return"string"==typeof t?e.getElementById(t):t},getStyle:function(t,i){var n=t.style[i]||t.currentStyle&&t.currentStyle[i];if((!n||"auto"===n)&&e.defaultView){var o=e.defaultView.getComputedStyle(t,null);n=o?o[i]:null}return"auto"===n?null:n},setStyle:function(t,e,i){t.style[e]=i},create:function(t,i,n){var o=e.createElement(t);return o.className=i,n&&n.appendChild(o),o},createWithId:function(t,i,n){var o=e.createElement(t);return o.id=i,n&&n.appendChild(o),o},remove:function(t){var e=t.parentNode;e&&e.removeChild(t)},empty:function(t){for(;t.firstChild;)t.removeChild(t.firstChild)},toFront:function(t){t.parentNode.appendChild(t)},toBack:function(t){var e=t.parentNode;e.insertBefore(t,e.firstChild)},hasClass:function(t,e){if(t.classList!==i)return t.classList.contains(e);var n=s.DomUtil.getClass(t);return n.length>0&&new RegExp("(^|\\s)"+e+"(\\s|$)").test(n)},addClass:function(t,e){if(t.classList!==i)for(var n=s.Util.splitWords(e),o=0,a=n.length;a>o;o++)t.classList.add(n[o]);else if(!s.DomUtil.hasClass(t,e)){var r=s.DomUtil.getClass(t);s.DomUtil.setClass(t,(r?r+" ":"")+e)}},removeClass:function(t,e){t.classList!==i?t.classList.remove(e):s.DomUtil.setClass(t,s.Util.trim((" "+s.DomUtil.getClass(t)+" ").replace(" "+e+" "," ")))},setClass:function(t,e){t.className.baseVal===i?t.className=e:t.className.baseVal=e},getClass:function(t){return t.className.baseVal===i?t.className:t.className.baseVal},setOpacity:function(t,e){"opacity"in t.style?t.style.opacity=e:"filter"in t.style&&s.DomUtil._setOpacityIE(t,e)},_setOpacityIE:function(t,e){var i=!1,n="DXImageTransform.Microsoft.Alpha";try{i=t.filters.item(n)}catch(o){if(1===e)return}e=Math.round(100*e),i?(i.Enabled=100!==e,i.Opacity=e):t.style.filter+=" progid:"+n+"(opacity="+e+")"},testProp:function(t){for(var i=e.documentElement.style,n=0;n<t.length;n++)if(t[n]in i)return t[n];return!1},setTransform:function(t,e,i){var n=e||new s.Point(0,0);t.style[s.DomUtil.TRANSFORM]="translate3d("+n.x+"px,"+n.y+"px,0)"+(i?" scale("+i+")":"")},setPosition:function(t,e,i){
t._leaflet_pos=e,s.Browser.any3d&&!i?s.DomUtil.setTransform(t,e):(t.style.left=e.x+"px",t.style.top=e.y+"px")},getPosition:function(t){return t._leaflet_pos}},function(){s.DomUtil.TRANSFORM=s.DomUtil.testProp(["transform","WebkitTransform","OTransform","MozTransform","msTransform"]);var i=s.DomUtil.TRANSITION=s.DomUtil.testProp(["webkitTransition","transition","OTransition","MozTransition","msTransition"]);if(s.DomUtil.TRANSITION_END="webkitTransition"===i||"OTransition"===i?i+"End":"transitionend","onselectstart"in e)s.DomUtil.disableTextSelection=function(){s.DomEvent.on(t,"selectstart",s.DomEvent.preventDefault)},s.DomUtil.enableTextSelection=function(){s.DomEvent.off(t,"selectstart",s.DomEvent.preventDefault)};else{var n=s.DomUtil.testProp(["userSelect","WebkitUserSelect","OUserSelect","MozUserSelect","msUserSelect"]);s.DomUtil.disableTextSelection=function(){if(n){var t=e.documentElement.style;this._userSelect=t[n],t[n]="none"}},s.DomUtil.enableTextSelection=function(){n&&(e.documentElement.style[n]=this._userSelect,delete this._userSelect)}}s.DomUtil.disableImageDrag=function(){s.DomEvent.on(t,"dragstart",s.DomEvent.preventDefault)},s.DomUtil.enableImageDrag=function(){s.DomEvent.off(t,"dragstart",s.DomEvent.preventDefault)},s.DomUtil.preventOutline=function(e){s.DomUtil.restoreOutline(),this._outlineElement=e,this._outlineStyle=e.style.outline,e.style.outline="none",s.DomEvent.on(t,"keydown",s.DomUtil.restoreOutline,this)},s.DomUtil.restoreOutline=function(){this._outlineElement&&(this._outlineElement.style.outline=this._outlineStyle,delete this._outlineElement,delete this._outlineStyle,s.DomEvent.off(t,"keydown",s.DomUtil.restoreOutline,this))}}(),s.LatLng=function(t,e,n){if(isNaN(t)||isNaN(e))throw new Error("Invalid LatLng object: ("+t+", "+e+")");this.lat=+t,this.lng=+e,n!==i&&(this.alt=+n)},s.LatLng.prototype={equals:function(t,e){if(!t)return!1;t=s.latLng(t);var n=Math.max(Math.abs(this.lat-t.lat),Math.abs(this.lng-t.lng));return(e===i?1e-9:e)>=n},toString:function(t){return"LatLng("+s.Util.formatNum(this.lat,t)+", "+s.Util.formatNum(this.lng,t)+")"},distanceTo:function(t){return s.CRS.Earth.distance(this,s.latLng(t))},wrap:function(){return s.CRS.Earth.wrapLatLng(this)},toBounds:function(t){var e=180*t/40075017,i=e/Math.cos(Math.PI/180*this.lat);return s.latLngBounds([this.lat-e,this.lng-i],[this.lat+e,this.lng+i])}},s.latLng=function(t,e,n){return t instanceof s.LatLng?t:s.Util.isArray(t)&&"object"!=typeof t[0]?3===t.length?new s.LatLng(t[0],t[1],t[2]):2===t.length?new s.LatLng(t[0],t[1]):null:t===i||null===t?t:"object"==typeof t&&"lat"in t?new s.LatLng(t.lat,"lng"in t?t.lng:t.lon,t.alt):e===i?null:new s.LatLng(t,e,n)},s.LatLngBounds=function(t,e){if(t)for(var i=e?[t,e]:t,n=0,o=i.length;o>n;n++)this.extend(i[n])},s.LatLngBounds.prototype={extend:function(t){var e,i,n=this._southWest,o=this._northEast;if(t instanceof s.LatLng)e=t,i=t;else{if(!(t instanceof s.LatLngBounds))return t?this.extend(s.latLng(t)||s.latLngBounds(t)):this;if(e=t._southWest,i=t._northEast,!e||!i)return this}return n||o?(n.lat=Math.min(e.lat,n.lat),n.lng=Math.min(e.lng,n.lng),o.lat=Math.max(i.lat,o.lat),o.lng=Math.max(i.lng,o.lng)):(this._southWest=new s.LatLng(e.lat,e.lng),this._northEast=new s.LatLng(i.lat,i.lng)),this},pad:function(t){var e=this._southWest,i=this._northEast,n=Math.abs(e.lat-i.lat)*t,o=Math.abs(e.lng-i.lng)*t;return new s.LatLngBounds(new s.LatLng(e.lat-n,e.lng-o),new s.LatLng(i.lat+n,i.lng+o))},getCenter:function(){return new s.LatLng((this._southWest.lat+this._northEast.lat)/2,(this._southWest.lng+this._northEast.lng)/2)},getSouthWest:function(){return this._southWest},getNorthEast:function(){return this._northEast},getNorthWest:function(){return new s.LatLng(this.getNorth(),this.getWest())},getSouthEast:function(){return new s.LatLng(this.getSouth(),this.getEast())},getWest:function(){return this._southWest.lng},getSouth:function(){return this._southWest.lat},getEast:function(){return this._northEast.lng},getNorth:function(){return this._northEast.lat},contains:function(t){t="number"==typeof t[0]||t instanceof s.LatLng?s.latLng(t):s.latLngBounds(t);var e,i,n=this._southWest,o=this._northEast;return t instanceof s.LatLngBounds?(e=t.getSouthWest(),i=t.getNorthEast()):e=i=t,e.lat>=n.lat&&i.lat<=o.lat&&e.lng>=n.lng&&i.lng<=o.lng},intersects:function(t){t=s.latLngBounds(t);var e=this._southWest,i=this._northEast,n=t.getSouthWest(),o=t.getNorthEast(),a=o.lat>=e.lat&&n.lat<=i.lat,r=o.lng>=e.lng&&n.lng<=i.lng;return a&&r},toBBoxString:function(){return[this.getWest(),this.getSouth(),this.getEast(),this.getNorth()].join(",")},equals:function(t){return t?(t=s.latLngBounds(t),this._southWest.equals(t.getSouthWest())&&this._northEast.equals(t.getNorthEast())):!1},isValid:function(){return!(!this._southWest||!this._northEast)}},s.LatLngBounds.createDefault=function(){return new s.LatLngBounds(new s.LatLng(0,0),new s.LatLng(0,0))},s.latLngBounds=function(t,e){return!t||t instanceof s.LatLngBounds?t:new s.LatLngBounds(t,e)},s.Projection={},s.Projection.LonLat={project:function(t){return new s.Point(t.lng,t.lat)},unproject:function(t){return new s.LatLng(t.y,t.x)},bounds:s.bounds([-180,-90],[180,90])},s.Projection.SphericalMercator={R:6378137,project:function(t){var e=Math.PI/180,i=1-1e-15,n=Math.max(Math.min(Math.sin(t.lat*e),i),-i);return new s.Point(this.R*t.lng*e,this.R*Math.log((1+n)/(1-n))/2)},unproject:function(t){var e=180/Math.PI;return new s.LatLng((2*Math.atan(Math.exp(t.y/this.R))-Math.PI/2)*e,t.x*e/this.R)},bounds:function(){var t=6378137*Math.PI;return s.bounds([-t,-t],[t,t])}()},s.CRS={latLngToPoint:function(t,e){var i=this.projection.project(t),n=this.scale(e);return this.transformation._transform(i,n)},pointToLatLng:function(t,e){var i=this.scale(e),n=this.transformation.untransform(t,i);return this.projection.unproject(n)},project:function(t){return this.projection.project(t)},unproject:function(t){return this.projection.unproject(t)},scale:function(t){return 256*Math.pow(2,t)},getProjectedBounds:function(t){if(this.infinite)return null;var e=this.projection.bounds,i=this.scale(t),n=this.transformation.transform(e.min,i),o=this.transformation.transform(e.max,i);return s.bounds(n,o)},wrapLatLng:function(t){var e=this.wrapLng?s.Util.wrapNum(t.lng,this.wrapLng,!0):t.lng,i=this.wrapLat?s.Util.wrapNum(t.lat,this.wrapLat,!0):t.lat;return s.latLng(i,e)}},s.CRS.Simple=s.extend({},s.CRS,{projection:s.Projection.LonLat,transformation:new s.Transformation(1,0,-1,0),scale:function(t){return Math.pow(1.2,t)},distance:function(t,e){var i=e.lng-t.lng,n=e.lat-t.lat;return Math.sqrt(i*i+n*n)},infinite:!0}),s.CRS.Earth=s.extend({},s.CRS,{wrapLng:[-180,180],R:6378137,distance:function(t,e){var i=Math.PI/180,n=t.lat*i,o=e.lat*i,s=Math.sin(n)*Math.sin(o)+Math.cos(n)*Math.cos(o)*Math.cos((e.lng-t.lng)*i);return this.R*Math.acos(Math.min(s,1))}}),s.CRS.EPSG3857=s.extend({},s.CRS.Earth,{code:"EPSG:3857",projection:s.Projection.SphericalMercator,transformation:function(){var t=.5/(Math.PI*s.Projection.SphericalMercator.R);return new s.Transformation(t,.5,-t,.5)}()}),s.CRS.EPSG900913=s.extend({},s.CRS.EPSG3857,{code:"EPSG:900913"}),s.CRS.EPSG4326=s.extend({},s.CRS.Earth,{code:"EPSG:4326",projection:s.Projection.LonLat,transformation:new s.Transformation(1/180,1,-1/180,.5)}),s.Map=s.Evented.extend({options:{crs:s.CRS.Simple,center:[0,0],zoom:10,minZoom:1,maxZoom:20,fadeAnimation:!1,trackResize:!0,markerZoomAnimation:!0,defaultZoom:10,tileWidthTwips:3840,tileHeightTwips:3840,urlPrefix:"lool",wopiSrc:""},lastActiveTime:Date.now(),initialize:function(n,o){if(o=s.setOptions(this,o),this.options.documentContainer&&(this.options.documentContainer=s.DomUtil.get(this.options.documentContainer)),this._initContainer(n),this._initLayout(),this._onResize=s.bind(this._onResize,this),this._initEvents(),o.maxBounds&&this.setMaxBounds(o.maxBounds),o.zoom!==i&&(this._zoom=this._limitZoom(o.zoom)),o.center&&o.zoom!==i&&this.setView(s.latLng(o.center),o.zoom,{reset:!0}),s.Cursor.imagePath=o.cursorURL||s.Cursor.getCursorURL("cursors"),o.webserver===i){var a="file:"===t.location.protocol?"https:":t.location.protocol;o.webserver=o.server.replace(/^(ws|wss):/i,a)}o.webserver=o.webserver.replace(/\/*$/,""),this._handlers=[],this._layers={},this._zoomBoundLayers={},this._sizeChanged=!0,this._bDisableKeyboard=!1,this._active=!0,this._fatal=!1,this._enabled=!0,this._debugAlwaysActive=!1,this._serverRecycling=!1,this._documentIdle=!1,vex.dialogID=-1,this.callInitHooks(),this.options.imagePath&&(s.Icon.Default.imagePath=this.options.imagePath),this._addLayers(this.options.layers),this._socket=s.socket(this),this._progressBar=s.progressOverlay(this.getCenter(),s.point(150,25)),this.on("contextmenu",function(){}),this.initConditions={doclayerinit:!1,statusindicatorfinish:!1,StyleApply:!1,CharFontName:!1,updatepermission:!1},this.initComplete=!1,this.on("updatepermission",function(t){this.initComplete||this._fireInitComplete("updatepermission"),"readonly"===t.perm&&(s.DomUtil.addClass(this._container.parentElement,"readonly"),s.DomUtil.addClass(s.DomUtil.get("logo"),"readonly"),s.DomUtil.addClass(s.DomUtil.get("toolbar-wrapper"),"readonly"),s.DomUtil.addClass(s.DomUtil.get("main-menu"),"readonly"),s.DomUtil.addClass(s.DomUtil.get("presentation-controls-wrapper"),"readonly"),s.DomUtil.addClass(s.DomUtil.get("spreadsheet-row-column-frame"),"readonly"))},this),this.on("doclayerinit",function(){if(this.initComplete||this._fireInitComplete("doclayerinit"),"text"==this._docLayer._docType){var t="edit"===this._permission?!0:!1;s.control.ruler({position:"topleft",interactive:t}).addTo(this)}}),this.on("updatetoolbarcommandvalues",function(t){this.initComplete||(".uno:StyleApply"===t.commandName?this._fireInitComplete("StyleApply"):".uno:CharFontName"===t.commandName&&this._fireInitComplete("CharFontName"))}),this.showBusy(_("Initializing..."),!1),this.on("statusindicator",this._onUpdateProgress,this),this._viewInfo={},this._viewInfoByUserName={},this._viewColors={},this._everModified=!1,this._docLoaded=!1,this.on("commandstatechanged",function(t){".uno:ModifiedStatus"===t.commandName&&(this._everModified=this._everModified||"true"===t.state)},this),this.on("docloaded",function(t){this._docLoaded=t.status,this._docLoaded&&(this.lastActiveTime=Date.now(),e.hasFocus()?this._activate():this._deactivate())},this)},loadDocument:function(){this._socket.connect()},getViewId:function(t){for(var e in this._viewInfo)if(this._viewInfo[e].username===t)return this._viewInfo[e].id;return-1},addView:function(t){this._viewInfo[t.id]=t,t.userextrainfo!==i&&t.userextrainfo.avatar!==i&&(this._viewInfoByUserName[t.username]=t),this.fire("postMessage",{msgId:"View_Added",args:{ViewId:t.id,UserId:t.userid,UserName:t.username,UserExtraInfo:t.userextrainfo,Color:s.LOUtil.rgbToHex(t.color),ReadOnly:t.readonly}}),this.fire("addview",{viewId:t.id,username:t.username,extraInfo:t.userextrainfo,readonly:this.isViewReadOnly(t.id)}),this.updateAvatars()},removeView:function(t){var e=this._viewInfo[t].username;delete this._viewInfoByUserName[this._viewInfo[t].username],delete this._viewInfo[t],this.fire("postMessage",{msgId:"View_Removed",args:{ViewId:t}}),this.fire("removeview",{viewId:t,username:e})},setView:function(t,e){return e=e===i?this.getZoom():e,this._resetView(s.latLng(t),this._limitZoom(e)),this},updateAvatars:function(){if(this._docLayer&&this._docLayer._annotations&&this._docLayer._annotations._items)for(var t in this._docLayer._annotations._items){var e=this._docLayer._annotations._items[t]._data.author;this._viewInfoByUserName[e]&&$(this._docLayer._annotations._items[t]._authorAvatarImg).attr("src",this._viewInfoByUserName[e].userextrainfo.avatar)}},showBusy:function(t,e){return this._docLayer?void this.fire("showbusy",{label:t}):(this._progressBar.setLabel(t),this._progressBar.setBar(e),this._progressBar.setValue(0),void(this.hasLayer(this._progressBar)||this.addLayer(this._progressBar)))},hideBusy:function(){this.fire("hidebusy"),this.hasLayer(this._progressBar)&&this.removeLayer(this._progressBar)},setZoom:function(t,e){return this._loaded?(this._docLayer&&"spreadsheet"===this._docLayer._docType&&this._docLayer._checkSpreadSheetBounds(t),this.setView(this.getCenter(),t,{zoom:e})):(this._zoom=this._limitZoom(t),this)},zoomIn:function(t,e){return this.setZoom(this._zoom+(t||1),e)},zoomOut:function(t,e){return this.setZoom(this._zoom-(t||1),e)},setZoomAround:function(t,e,i){var n=this.getZoomScale(e),o=this.getSize().divideBy(2),a=t instanceof s.Point?t:this.latLngToContainerPoint(t),r=a.subtract(o).multiplyBy(1-1/n),l=this.containerPointToLatLng(o.add(r));return this.setView(l,e,{zoom:i})},fitBounds:function(t,e){e=e||{},t=t.getBounds?t.getBounds():s.latLngBounds(t);var i=s.point(e.paddingTopLeft||e.padding||[0,0]),n=s.point(e.paddingBottomRight||e.padding||[0,0]),o=this.getBoundsZoom(t,!1,i.add(n));o=e.maxZoom?Math.min(e.maxZoom,o):o;var a=n.subtract(i).divideBy(2),r=this.project(t.getSouthWest(),o),l=this.project(t.getNorthEast(),o),h=this.unproject(r.add(l).divideBy(2).add(a),o);return this.setView(h,o,e)},fitWorld:function(t){return this.fitBounds([[-90,-180],[90,180]],t)},panTo:function(t,e){return this.setView(t,this._zoom,{pan:e})},panBy:function(t){return this.fire("movestart"),this._rawPanBy(s.point(t)),this.fire("move"),this.fire("moveend")},setMaxBounds:function(t,e){return t=s.latLngBounds(t),this.options.maxBounds=t,e=e||{},t?(this._loaded&&this._panInsideMaxBounds(),e.panInside===!1?this.off("moveend",this._panInsideMaxBounds):this.on("moveend",this._panInsideMaxBounds)):this.off("moveend",this._panInsideMaxBounds)},setDocBounds:function(t){t=s.latLngBounds(t),this.options.docBounds=t},panInsideBounds:function(t,e){var i=this.getCenter(),n=this._limitCenter(i,this._zoom,t);return i.equals(n)?this:this.panTo(n,e)},invalidateSize:function(t){if(!this._loaded)return this;t=s.extend({animate:!1,pan:!0},t===!0?{animate:!0}:t);var e=this.getSize();this._sizeChanged=!0;var i=this.getSize(),n=e.divideBy(2).round(),o=i.divideBy(2).round(),a=n.subtract(o);return a.x||a.y?(t.animate&&t.pan?this.panBy(a):(t.pan&&this._rawPanBy(a),this.fire("move"),t.debounceMoveend?(clearTimeout(this._sizeTimer),this._sizeTimer=setTimeout(s.bind(this.fire,this,"moveend"),200)):this.fire("moveend")),this.fire("resize",{oldSize:e,newSize:i})):this},stop:function(){return s.Util.cancelAnimFrame(this._flyToFrame),this._panAnim&&this._panAnim.stop(),this},addHandler:function(t,e){if(!e)return this;var i=this[t]=new e(this);return this._handlers.push(i),this.options[t]&&i.enable(),this},remove:function(){this._initEvents(!0);try{delete this._container._leaflet}catch(t){this._container._leaflet=i}return s.DomUtil.remove(this._mapPane),this._clearControlPos&&this._clearControlPos(),this._clearHandlers(),this._loaded&&this.fire("unload"),this._docLayer&&this.removeLayer(this._docLayer),this.removeControls(),this._socket.close(),this},createPane:function(t,e){var i="leaflet-pane"+(t?" leaflet-"+t.replace("Pane","")+"-pane":""),n=s.DomUtil.create("div",i,e||this._mapPane);return t&&(this._panes[t]=n),n},getViewName:function(t){return this._viewInfo[t].username},getViewColor:function(t){return this._viewInfo[t].color},isViewReadOnly:function(t){return"0"!==this._viewInfo[t].readonly},getCenter:function(){return this._checkIfLoaded(),this.layerPointToLatLng(this._getCenterLayerPoint())},getZoom:function(){return this._zoom},getBounds:function(){var t=this.getPixelBounds(),e=this.unproject(t.getBottomLeft()),i=this.unproject(t.getTopRight());return new s.LatLngBounds(e,i)},getMinZoom:function(){return this.options.minZoom===i?this._layersMinZoom||0:this.options.minZoom},getMaxZoom:function(){return this.options.maxZoom===i?this._layersMaxZoom===i?1/0:this._layersMaxZoom:this.options.maxZoom},getLayerMaxBounds:function(){return s.bounds(this.latLngToLayerPoint(this.options.maxBounds.getNorthWest()),this.latLngToLayerPoint(this.options.maxBounds.getSouthEast()))},getLayerDocBounds:function(){return s.bounds(this.latLngToLayerPoint(this.options.docBounds.getNorthWest()),this.latLngToLayerPoint(this.options.docBounds.getSouthEast()))},getBoundsZoom:function(t,e,i){t=s.latLngBounds(t);var n,o=this.getMinZoom()-(e?1:0),a=this.getMaxZoom(),r=this.getSize(),l=t.getNorthWest(),h=t.getSouthEast(),d=!0;i=s.point(i||[0,0]);do o++,n=this.project(h,o).subtract(this.project(l,o)).add(i).floor(),d=e?n.x<r.x||n.y<r.y:r.contains(n);while(d&&a>=o);return d&&e?null:e?o:o-1},getSize:function(){return(!this._size||this._sizeChanged)&&(this._size=new s.Point(this._container.clientWidth,this._container.clientHeight),this._sizeChanged=!1),this._size.clone()},getPixelBounds:function(t,e){var i=this._getTopLeftPoint(t,e);return new s.Bounds(i,i.add(this.getSize()))},getPixelOrigin:function(){return this._checkIfLoaded(),this._pixelOrigin},getPixelWorldBounds:function(t){return this.options.crs.getProjectedBounds(t===i?this.getZoom():t)},getPane:function(t){return"string"==typeof t?this._panes[t]:t},getPanes:function(){return this._panes},getContainer:function(){return this._container},getZoomScale:function(t,e){var n=this.options.crs;return e=e===i?this._zoom:e,n.scale(t)/n.scale(e)},getScaleZoom:function(t,e){return e=e===i?this._zoom:e,e+Math.log(t)/Math.LN2},project:function(t,e){e=e===i?this._zoom:e;var n=this.options.crs.latLngToPoint(s.latLng(t),e);return new s.Point(s.round(n.x,1e-6),s.round(n.y,1e-6))},unproject:function(t,e){return e=e===i?this._zoom:e,this.options.crs.pointToLatLng(s.point(t),e)},layerPointToLatLng:function(t){var e=s.point(t).add(this.getPixelOrigin());return this.unproject(e)},latLngToLayerPoint:function(t){var e=this.project(s.latLng(t))._round();return e._subtract(this.getPixelOrigin())},wrapLatLng:function(t){return this.options.crs.wrapLatLng(s.latLng(t))},distance:function(t,e){return this.options.crs.distance(s.latLng(t),s.latLng(e))},containerPointToLayerPoint:function(t){return s.point(t).subtract(this._getMapPanePos())},layerPointToContainerPoint:function(t){return s.point(t).add(this._getMapPanePos())},containerPointToLatLng:function(t){var e=this.containerPointToLayerPoint(s.point(t));return this.layerPointToLatLng(e)},latLngToContainerPoint:function(t){return this.layerPointToContainerPoint(this.latLngToLayerPoint(s.latLng(t)))},mouseEventToContainerPoint:function(t){return s.DomEvent.getMousePosition(t,this._container)},mouseEventToLayerPoint:function(t){return this.containerPointToLayerPoint(this.mouseEventToContainerPoint(t))},mouseEventToLatLng:function(t){return this.layerPointToLatLng(this.mouseEventToLayerPoint(t))},focus:function(){console.debug("focus:"),this._docLayer&&e.activeElement!==this._docLayer._textArea&&(console.debug("focus: focussing"),this._docLayer._textArea.focus())},_fireInitComplete:function(t){if(!this.initComplete){this.initConditions[t]=!0;for(var e in this.initConditions)if(!this.initConditions[e])return;this.fire("statusindicator",{statusType:"initializationcomplete"}),this.initComplete=!0}},_initContainer:function(t){var e=this._container=s.DomUtil.get(t);if(!e)throw new Error("Map container not found.");if(e._leaflet)throw new Error("Map container is already initialized.");var i=s.DomUtil.create("div","clipboard-container",e.parentElement);this._textArea=s.DomUtil.create("input","clipboard",i),this._textArea.setAttribute("type","text"),this._textArea.setAttribute("autocorrect","off"),this._textArea.setAttribute("autocapitalize","off"),this._textArea.setAttribute("autocomplete","off"),this._textArea.setAttribute("spellcheck","false"),this._resizeDetector=s.DomUtil.create("iframe","resize-detector",e),this._fileDownloader=s.DomUtil.create("iframe","",e),s.DomUtil.setStyle(this._fileDownloader,"display","none"),e._leaflet=!0},_initLayout:function(){var t=this._container;this._fadeAnimated=this.options.fadeAnimation&&s.Browser.any3d,s.DomUtil.addClass(t,"leaflet-container"+(s.Browser.touch?" leaflet-touch":"")+(s.Browser.retina?" leaflet-retina":"")+(s.Browser.ielt9?" leaflet-oldie":"")+(s.Browser.safari?" leaflet-safari":"")+(this._fadeAnimated?" leaflet-fade-anim":""));var e=s.DomUtil.getStyle(t,"position");"absolute"!==e&&"relative"!==e&&"fixed"!==e&&(t.style.position="absolute"),this._initPanes(),this._initControlPos&&this._initControlPos()},_initPanes:function(){var t=this._panes={};this._paneRenderers={},this._mapPane=this.createPane("mapPane",this._container),this.createPane("tilePane"),this.createPane("shadowPane"),this.createPane("overlayPane"),this.createPane("markerPane"),this.createPane("popupPane"),this.options.markerZoomAnimation||(s.DomUtil.addClass(t.markerPane,"leaflet-zoom-hide"),s.DomUtil.addClass(t.shadowPane,"leaflet-zoom-hide"))},_resetView:function(t,e,i,n){var o=this._zoom!==e;n||(this.fire("movestart"),o&&this.fire("zoomstart")),this._zoom=e,i||s.DomUtil.setPosition(this._mapPane,new s.Point(0,0)),this._pixelOrigin=this._getNewPixelOrigin(t);var a=!this._loaded;this._loaded=!0,this.fire("viewreset",{hard:!i}),a&&this.fire("load"),this.fire("move"),(o||n)&&(this.fire("zoomend"),this.fire("zoomlevelschange")),this.fire("moveend",{hard:!i})},_rawPanBy:function(t){s.DomUtil.setPosition(this._mapPane,this._getMapPanePos().subtract(t))},_getZoomSpan:function(){return this.getMaxZoom()-this.getMinZoom()},_panInsideMaxBounds:function(){this.panInsideBounds(this.options.maxBounds)},_checkIfLoaded:function(){if(!this._loaded)throw new Error("Set map center and zoom first.")},_initEvents:function(e){if(s.DomEvent){this._targets={},this._mouseOut=!1;var i=e?"off":"on";s.DomEvent[i](this._container,"click dblclick mousedown mouseup mouseover mouseout mousemove contextmenu dragover drop keydown keypress keyup trplclick qdrplclick",this._handleDOMEvent,this),s.DomEvent[i](this._textArea,"copy cut paste keydown keypress keyup compositionstart compositionupdate compositionend textInput",this._handleDOMEvent,this),this.options.trackResize&&this._resizeDetector.contentWindow&&s.DomEvent[i](this._resizeDetector.contentWindow,"resize",this._onResize,this),s.DomEvent[i](t,"blur",this._onLostFocus,this),s.DomEvent[i](t,"focus",this._onGotFocus,this)}},_onResize:function(){s.Util.cancelAnimFrame(this._resizeRequest),this._resizeRequest=s.Util.requestAnimFrame(function(){this.invalidateSize({debounceMoveend:!0})},this,!1,this._container)},_activate:function(){if(!this._serverRecycling&&!this._documentIdle){if(console.debug("_activate:"),clearTimeout(vex.timer),!this._active)if(this._socket.connected()){if(console.debug("sending useractive"),this._socket.sendMessage("useractive"),this._active=!0,this._docLayer&&this._docLayer._onMessage("invalidatetiles: EMPTY",null),vex.dialogID>0){var t=vex.dialogID;return vex.dialogID=-1,this._startInactiveTimer(),this.focus(),vex.close(t)}}else this.loadDocument();return this._startInactiveTimer(),this.focus(),!1}},_dim:function(){if(!this.options.alwaysActive&&this._debugAlwaysActive!==!0&&(console.debug("_dim:"),this._socket.connected())){this._active=!1,clearTimeout(vex.timer);var t="",e=this;e.wopi.DisableInactiveMessages||(t=_("Inactive document - please click to resume editing"));var i=$.extend({},vex.defaultOptions,{contentCSS:{background:"rgba(0, 0, 0, 0)","font-size":"xx-large",color:"#fff","text-align":"center"},content:t});i.id=vex.globalID,vex.dialogID=i.id,vex.globalID+=1,i.$vex=$("<div>").addClass(vex.baseClassNames.vex).addClass(i.className).css(i.css).data({vex:i}),i.$vexOverlay=$("<div>").addClass(vex.baseClassNames.overlay).addClass(i.overlayClassName).css(i.overlayCSS).data({vex:i}),i.$vex.bind("click.vex",function(){return console.debug("_dim: click.vex function"),e._activate()}),i.$vex.append(i.$vexOverlay),i.$vexContent=$("<div>").addClass(vex.baseClassNames.content).addClass(i.contentClassName).css(i.contentCSS).text(i.content).data({vex:i}),i.$vex.append(i.$vexContent),$(i.appendLocation).append(i.$vex),vex.setupBodyClassName(i.$vex),this._doclayer&&this._docLayer._onMessage("textselection:",null),console.debug("_dim: sending userinactive"),e.fire("postMessage",{msgId:"User_Idle"}),this._socket.sendMessage("userinactive")}},_dimIfInactive:function(){console.debug("_dimIfInactive: diff="+(Date.now()-this.lastActiveTime)),this._docLoaded&&Date.now()-this.lastActiveTime>=1e3*this.options.idleTimeoutSecs?this._dim():this._startInactiveTimer()},_startInactiveTimer:function(){if(!this._serverRecycling&&!this._documentIdle&&this._docLoaded){console.debug("_startInactiveTimer:"),clearTimeout(vex.timer);var t=this;vex.timer=setTimeout(function(){t._dimIfInactive()},6e4)}},_deactivate:function(){if(!this._serverRecycling&&!this._documentIdle&&this._docLoaded){if(console.debug("_deactivate:"),clearTimeout(vex.timer),!this._active||vex.dialogID>0)return this._active=!1,this._docLayer&&this._docLayer._onMessage("textselection:",null),void(this._socket.connected()&&(console.debug("_deactivate: sending userinactive"),this._socket.sendMessage("userinactive")));var t=this;vex.timer=setTimeout(function(){t._dim()},1e3*t.options.outOfFocusTimeoutSecs)}},_onLostFocus:function(){if(this._loaded){console.debug("_onLostFocus: ");var t=this._docLayer;t&&(t._isCursorVisibleOnLostFocus=t._isCursorVisible,t._isCursorOverlayVisibleOnLostFocus=t._isCursorOverlayVisible,t._isCursorVisible&&t._isCursorOverlayVisible&&(t._isCursorOverlayVisible=!1,t._updateCursorAndOverlay()),this._deactivate())}},_onGotFocus:function(){if(console.debug("_onGotFocus:"),this._loaded){var t=this._docLayer;t&&"undefined"!=typeof t._isCursorOverlayVisibleOnLostFocus&&"undefined"!=typeof t._isCursorVisibleOnLostFocus&&setTimeout(function(){t._isCursorOverlayVisible=t._isCursorOverlayVisibleOnLostFocus,t._isCursorVisible=t._isCursorVisibleOnLostFocus,t._updateCursorAndOverlay()},300),this._activate()}},_onUpdateProgress:function(t){"start"===t.statusType?1===this._socket.socket.readyState?this.showBusy(_("Saving..."),!0):this.showBusy(_("Loading..."),!0):"setvalue"===t.statusType?this._progressBar.setValue(t.value):("finish"===t.statusType||"loleafletloaded"===t.statusType||"reconnected"===t.statusType)&&this.hideBusy()},_isMouseEnteringLeaving:function(t){var e=t.target||t.srcElement,i=t.relatedTarget;return e?s.DomUtil.hasClass(e,"leaflet-tile")&&!(i&&(s.DomUtil.hasClass(i,"leaflet-tile")||s.DomUtil.hasClass(i,"leaflet-cursor"))):!1},_handleDOMEvent:function(t){if(this._docLayer&&this._loaded&&this._enabled&&!s.DomEvent._skipped(t)){this.lastActiveTime=Date.now();var e=this._targets[s.stamp(t.target||t.srcElement)],n=t.type;"click"===n&&("edit"===this._permission&&(this._textArea.blur(),this._textArea.focus()),this._docLayer&&this._docLayer._annotations&&this._docLayer._annotations.unselect&&this._docLayer._annotations.unselect()),"keypress"===n&&(this.lastActionByUser=!0),this._mouseEnteringLeaving=!1,e||this._mouseOut||"mouseout"!==n||(this._mouseEnteringLeaving=this._isMouseEnteringLeaving(t),this._mouseOut=this._mouseEnteringLeaving),!e&&this._mouseOut&&"mouseover"===n&&(this._mouseEnteringLeaving=this._isMouseEnteringLeaving(t),this._mouseOut=!this._mouseEnteringLeaving),(e||this._mouseEnteringLeaving||"mouseover"!==n&&"mouseout"!==n||s.DomEvent._checkMouse(this._container,t))&&("mousedown"===n&&(s.DomUtil.preventOutline(t.target||t.srcElement),t.preventDefault()),e!==i&&e._path!==i&&"mousemove"===n&&(e=i),this._fireDOMEvent(e||this,t,n))}},_fireDOMEvent:function(t,e,i){if((t.listens(i,!0)||"click"===i&&t.listens("preclick",!0))&&("contextmenu"===i&&s.DomEvent.preventDefault(e),"click"!==e.type||e._simulated||!this._draggableMoved(t))){var n={originalEvent:e};"keypress"!==e.type&&"keyup"!==e.type&&"keydown"!==e.type&&"copy"!==e.type&&"cut"!==e.type&&"paste"!==e.type&&"compositionstart"!==e.type&&"compositionupdate"!==e.type&&"compositionend"!==e.type&&"textInput"!==e.type&&(n.containerPoint=t instanceof s.Marker?this.latLngToContainerPoint(t.getLatLng()):this.mouseEventToContainerPoint(e),n.layerPoint=this.containerPointToLayerPoint(n.containerPoint),n.latlng=this.layerPointToLatLng(n.layerPoint)),"click"===i&&t.fire("preclick",n,!0),t.fire(i,n,!0)}},_draggableMoved:function(t){return t=t.options.draggable?t:this,t.dragging&&t.dragging.moved()||this.boxZoom&&this.boxZoom.moved()},_clearHandlers:function(){for(var t=0,e=this._handlers.length;e>t;t++)this._handlers[t].disable()},whenReady:function(t,e){return this._loaded?t.call(e||this,{target:this}):this.on("load",t,e),this},_getMapPanePos:function(){return s.DomUtil.getPosition(this._mapPane)||new s.Point(0,0)},_moved:function(){var t=this._getMapPanePos();return t&&!t.equals([0,0])},_getTopLeftPoint:function(t,e){var n=t&&e!==i?this._getNewPixelOrigin(t,e):this.getPixelOrigin();return n.subtract(this._getMapPanePos())},_getNewPixelOrigin:function(t,e){var i=this.getSize()._divideBy(2);return this.project(t,e)._subtract(i)._add(this._getMapPanePos())._round()},_latLngToNewLayerPoint:function(t,e,i){var n=this._getNewPixelOrigin(i,e);return this.project(t,e)._subtract(n)},_getCenterLayerPoint:function(){return this.containerPointToLayerPoint(this.getSize()._divideBy(2))},_getCenterOffset:function(t){return this.latLngToLayerPoint(t).subtract(this._getCenterLayerPoint())},_limitCenter:function(t,e,i){if(!i)return t;var n=this.project(t,e),o=this.getSize().divideBy(2),a=new s.Bounds(n.subtract(o),n.add(o)),r=this._getBoundsOffset(a,i,e);return this.unproject(n.add(r),e)},_limitOffset:function(t,e){if(!e)return t;var i=this.getPixelBounds(),n=new s.Bounds(i.min.add(t),i.max.add(t));return t.add(this._getBoundsOffset(n,e))},_getBoundsOffset:function(t,e,i){var n=this.project(e.getNorthWest(),i).subtract(t.min),o=this.project(e.getSouthEast(),i).subtract(t.max),a=this._rebound(n.x,-o.x),r=this._rebound(n.y,-o.y);return new s.Point(a,r)},_rebound:function(t,e){return t+e>0?Math.round(t-e)/2:Math.max(0,Math.ceil(t))-Math.max(0,Math.floor(e))},_limitZoom:function(t){var e=this.getMinZoom(),i=this.getMaxZoom();return Math.max(e,Math.min(i,t))},enable:function(t){this._enabled=t,this._enabled?$(".scroll-container").mCustomScrollbar("update"):$(".scroll-container").mCustomScrollbar("disable")}}),s.map=function(t,e){return new s.Map(t,e)},s.Layer=s.Evented.extend({options:{pane:"overlayPane"},addTo:function(t){return t.addLayer(this),this},remove:function(){return this.removeFrom(this._map||this._mapToAdd)},removeFrom:function(t){return t&&t.removeLayer(this),this},getPane:function(t){return this._map.getPane(t?this.options[t]||t:this.options.pane)},addInteractiveTarget:function(t){return this._map._targets[s.stamp(t)]=this,this},removeInteractiveTarget:function(t){return delete this._map._targets[s.stamp(t)],this},_layerAdd:function(t){var e=t.target;e.hasLayer(this)&&(this._map=e,this._zoomAnimated=e._zoomAnimated,this.onAdd(e),this.getEvents&&e.on(this.getEvents(),this),this.fire("add"),e.fire("layeradd",{layer:this}))}}),s.Map.include({addLayer:function(t){var e=s.stamp(t);return this._layers[e]?t:(this._layers[e]=t,t._mapToAdd=this,t.beforeAdd&&t.beforeAdd(this),this.whenReady(t._layerAdd,t),this)},removeLayer:function(t){var e=s.stamp(t);return this._layers[e]?(this._loaded&&t.onRemove(this),t.getEvents&&this.off(t.getEvents(),t),delete this._layers[e],this._loaded&&(this.fire("layerremove",{layer:t}),t.fire("remove")),t._map=t._mapToAdd=null,this):this},hasLayer:function(t){return!!t&&s.stamp(t)in this._layers},eachLayer:function(t,e){for(var i in this._layers)t.call(e,this._layers[i]);return this},_addLayers:function(t){t=t?s.Util.isArray(t)?t:[t]:[];for(var e=0,i=t.length;i>e;e++)this.addLayer(t[e])},_addZoomLimit:function(t){(isNaN(t.options.maxZoom)||!isNaN(t.options.minZoom))&&(this._zoomBoundLayers[s.stamp(t)]=t,this._updateZoomLevels())},_removeZoomLimit:function(t){var e=s.stamp(t);this._zoomBoundLayers[e]&&(delete this._zoomBoundLayers[e],this._updateZoomLevels())},_updateZoomLevels:function(){var t=1/0,e=-(1/0),n=this._getZoomSpan();for(var o in this._zoomBoundLayers){var s=this._zoomBoundLayers[o].options;t=s.minZoom===i?t:Math.min(t,s.minZoom),e=s.maxZoom===i?e:Math.max(e,s.maxZoom);
}this._layersMaxZoom=e===-(1/0)?i:e,this._layersMinZoom=t===1/0?i:t,n!==this._getZoomSpan()&&this.fire("zoomlevelschange")}}),s.Projection.Mercator={R:6378137,R_MINOR:6356752.314245179,bounds:s.bounds([-20037508.34279,-15496570.73972],[20037508.34279,18764656.23138]),project:function(t){var e=Math.PI/180,i=this.R,n=t.lat*e,o=this.R_MINOR/i,a=Math.sqrt(1-o*o),r=a*Math.sin(n),l=Math.tan(Math.PI/4-n/2)/Math.pow((1-r)/(1+r),a/2);return n=-i*Math.log(Math.max(l,1e-10)),new s.Point(t.lng*e*i,n)},unproject:function(t){for(var e,i=180/Math.PI,n=this.R,o=this.R_MINOR/n,a=Math.sqrt(1-o*o),r=Math.exp(-t.y/n),l=Math.PI/2-2*Math.atan(r),h=0,d=.1;15>h&&Math.abs(d)>1e-7;h++)e=a*Math.sin(l),e=Math.pow((1-e)/(1+e),a/2),d=Math.PI/2-2*Math.atan(r*e)-l,l+=d;return new s.LatLng(l*i,t.x*i/n)}},s.CRS.EPSG3395=s.extend({},s.CRS.Earth,{code:"EPSG:3395",projection:s.Projection.Mercator,transformation:function(){var t=.5/(Math.PI*s.Projection.Mercator.R);return new s.Transformation(t,.5,-t,.5)}()}),s.GridLayer=s.Layer.extend({options:{pane:"tilePane",tileSize:256,opacity:1,updateWhenIdle:s.Browser.mobile,updateInterval:200,attribution:null,zIndex:null,bounds:null,minZoom:0},initialize:function(t){t=s.setOptions(this,t)},onAdd:function(){this._initContainer(),this._levels={},this._tiles={},this._viewReset()},beforeAdd:function(t){t._addZoomLimit(this)},onRemove:function(t){s.DomUtil.remove(this._container),t._removeZoomLimit(this),this._container=null,this._tileZoom=null,clearTimeout(this._preFetchIdle),clearTimeout(this._previewInvalidator),clearInterval(this._tilesPreFetcher),this._selections&&this._map.removeLayer(this._selections),this._cursorMarker&&this._cursorMarker.remove(),this._graphicMarker&&this._graphicMarker.remove();for(var e in this._selectionHandles)this._selectionHandles[e].remove()},bringToFront:function(){return this._map&&(s.DomUtil.toFront(this._container),this._setAutoZIndex(Math.max)),this},bringToBack:function(){return this._map&&(s.DomUtil.toBack(this._container),this._setAutoZIndex(Math.min)),this},getAttribution:function(){return this.options.attribution},getContainer:function(){return this._container},setOpacity:function(t){return this.options.opacity=t,this._map&&this._updateOpacity(),this},setZIndex:function(t){return this.options.zIndex=t,this._updateZIndex(),this},redraw:function(){return this._map&&(this._removeAllTiles(),this._update()),this},getEvents:function(){var t={viewreset:this._viewReset,movestart:this._moveStart,moveend:this._move};return this.options.updateWhenIdle||(t.move=s.Util.throttle(this._move,this.options.updateInterval,this)),this._zoomAnimated&&(t.zoomanim=this._animateZoom),t},createTile:function(){return e.createElement("div")},_updateZIndex:function(){this._container&&this.options.zIndex!==i&&null!==this.options.zIndex&&(this._container.style.zIndex=this.options.zIndex)},_setAutoZIndex:function(t){for(var e,i=this.getPane().children,n=-t(-(1/0),1/0),o=0,s=i.length;s>o;o++)e=i[o].style.zIndex,i[o]!==this._container&&e&&(n=t(n,+e));isFinite(n)&&(this.options.zIndex=n+t(-1,1),this._updateZIndex())},_updateOpacity:function(){var t=this.options.opacity;if(!s.Browser.ielt9&&!this._map._fadeAnimated)return void s.DomUtil.setOpacity(this._container,t);var e=+new Date,i=!1;for(var n in this._tiles){var o=this._tiles[n];if(o.current&&o.loaded&&!o.active){var a=Math.min(1,(e-o.loaded)/200);1>a?(s.DomUtil.setOpacity(o.el,t*a),i=!0):(s.DomUtil.setOpacity(o.el,t),o.active=!0,this._pruneTiles())}}i&&(s.Util.cancelAnimFrame(this._fadeFrame),this._fadeFrame=s.Util.requestAnimFrame(this._updateOpacity,this))},_initContainer:function(){this._container||(this._container=s.DomUtil.create("div","leaflet-layer"),this._updateZIndex(),this.options.opacity<1&&this._updateOpacity(),this.getPane().appendChild(this._container))},_updateLevels:function(){var t=this._tileZoom,e=this.options.maxZoom;for(var i in this._levels)this._levels[i].el.children.length||i===t?this._levels[i].el.style.zIndex=e-Math.abs(t-i):(s.DomUtil.remove(this._levels[i].el),delete this._levels[i]);var n=this._levels[t],o=this._map;return n||(n=this._levels[t]={},n.el=s.DomUtil.create("div","leaflet-tile-container leaflet-zoom-animated",this._container),n.el.style.zIndex=e,n.origin=o.project(o.unproject(o.getPixelOrigin()),t).round(),n.zoom=t,this._setZoomTransform(n,o.getCenter(),o.getZoom()),s.Util.falseFn(n.el.offsetWidth)),this._level=n,n},_pruneTiles:function(){var t,e;for(t in this._tiles)e=this._tiles[t],e.retain=e.current;for(t in this._tiles)if(e=this._tiles[t],e.current&&!e.active){var i=e.coords;this._retainParent(i.x,i.y,i.z,i.part,i.z-5)||this._retainChildren(i.x,i.y,i.z,i.part,i.z+2)}for(t in this._tiles)this._tiles[t].retain||this._removeTile(t)},_removeAllTiles:function(){for(var t in this._tiles)this._removeTile(t)},_retainParent:function(t,e,i,n,o){var s=Math.floor(t/1.2),a=Math.floor(e/1.2),r=i-1,l=s+":"+a+":"+r+":"+n,h=this._tiles[l];return h&&h.active?(h.retain=!0,!0):(h&&h.loaded&&(h.retain=!0),r>o?this._retainParent(s,a,r,n,o):!1)},_retainChildren:function(t,e,i,n,o){for(var s=1.2*t;1.2*t+2>s;s++)for(var a=1.2*e;1.2*e+2>a;a++){var r=Math.floor(s)+":"+Math.floor(a)+":"+(i+1)+":"+n,l=this._tiles[r];l&&l.active?l.retain=!0:(l&&l.loaded&&(l.retain=!0),o>i+1&&this._retainChildren(s,a,i+1,n,o))}},_viewReset:function(t){this._reset(this._map.getCenter(),this._map.getZoom(),t&&t.hard)},_animateZoom:function(t){this._reset(t.center,t.zoom,!1,!0,t.noUpdate)},_reset:function(t,e,i,n,o){var a=Math.round(e),r=this._tileZoom!==a;o||!i&&!r||(this._abortLoading&&this._abortLoading(),this._tileZoom=a,r&&(this._updateTileTwips(),this._updateMaxBounds(null,null,e)),this._updateLevels(),this._resetGrid(),s.Browser.mobileWebkit||this._update(t,a),n||this._pruneTiles()),this._setZoomTransforms(t,e)},_updateTileTwips:function(){var t=Math.pow(1.2,this._map.options.zoom-this._tileZoom);this._tileWidthTwips=Math.round(this.options.tileWidthTwips*t),this._tileHeightTwips=Math.round(this.options.tileHeightTwips*t)},_updateMaxBounds:function(t,e,n,o){if(this._docWidthTwips!==i&&this._docHeightTwips!==i){o||(o=this._map.getZoom());var a=new s.Point(this._docWidthTwips/this.options.tileWidthTwips,this._docHeightTwips/this.options.tileHeightTwips);a=a.multiplyBy(this._tileSize);var r=this._map.getZoomScale(o,10),l=new s.Point(0,0);l=this._map.unproject(l.multiplyBy(r));var h=new s.Point(a.x,a.y);h=h.multiplyBy(r),e&&(h=h.add(e)),h=this._map.unproject(h),(""===this._documentInfo||t)&&(this._map.setMaxBounds(new s.LatLngBounds(l,h),n),this._map.setDocBounds(new s.LatLngBounds(l,this._map.unproject(a.multiplyBy(r)))));var d=new s.Point(this._docWidthTwips/this._tileWidthTwips,this._docHeightTwips/this._tileHeightTwips);d=e?d.multiplyBy(this._tileSize).add(e.multiplyBy(r)):d.multiplyBy(this._tileSize),this._docPixelSize={x:d.x,y:d.y},this._map.fire("docsize",{x:d.x,y:d.y,extraSize:e})}},_checkSpreadSheetBounds:function(t){var e=this._map.getSize(),i=this._map.getZoomScale(t),n=this._docWidthTwips/this._tileWidthTwips*this._tileSize*i,o=this._docHeightTwips/this._tileHeightTwips*this._tileSize*i;n<e.x||o<e.y?(n=Math.max(n,e.x),o=Math.max(o,e.y),this._map.options._origMaxBounds||(this._map.options._origMaxBounds=this._map.options.maxBounds),i=this._map.options.crs.scale(1),this._map.setMaxBounds(new s.LatLngBounds(this._map.unproject(new s.Point(0,0)),this._map.unproject(new s.Point(n*i,o*i))))):this._map.options._origMaxBounds&&(this._map.setMaxBounds(this._map.options._origMaxBounds),this._map.options._origMaxBounds=null)},_updateScrollOffset:function(){var t=this._map.project(this._map.getCenter()),e=t.subtract(this._map.getSize().divideBy(2)),i=Math.round(e.x<0?0:e.x),n=Math.round(e.y<0?0:e.y);this._map.fire("updatescrolloffset",{x:i,y:n})},_setZoomTransforms:function(t,e){for(var i in this._levels)this._setZoomTransform(this._levels[i],t,e)},_setZoomTransform:function(t,e,i){var n=this._map.getZoomScale(i,t.zoom),o=t.origin.multiplyBy(n).subtract(this._map._getNewPixelOrigin(e,i)).round();s.DomUtil.setTransform(t.el,o,n)},_resetGrid:function(){var t=this._map,e=t.options.crs,n=this._tileSize=this._getTileSize(),o=this._tileZoom;this._tileWidthTwips===i&&(this._tileWidthTwips=this.options.tileWidthTwips),this._tileHeightTwips===i&&(this._tileHeightTwips=this.options.tileHeightTwips);var s=this._map.getPixelWorldBounds(this._tileZoom);s&&(this._globalTileRange=this._pxBoundsToTileRange(s)),this._wrapX=e.wrapLng&&[Math.floor(t.project([0,e.wrapLng[0]],o).x/n),Math.ceil(t.project([0,e.wrapLng[1]],o).x/n)],this._wrapY=e.wrapLat&&[Math.floor(t.project([e.wrapLat[0],0],o).y/n),Math.ceil(t.project([e.wrapLat[1],0],o).y/n)]},_getTileSize:function(){return this.options.tileSize},_moveStart:function(){this._resetPreFetching()},_move:function(){this._update(),this._resetPreFetching(!0),this._onCurrentPageUpdate()},_update:function(t,n){var o=this._map;if(o&&""!==this._documentInfo){t===i&&(t=o.getCenter()),n===i&&(n=Math.round(o.getZoom()));var a=o.getPixelBounds(t,n),r=this._pxBoundsToTileRange(a),l=[];for(var h in this._tiles)(this._keyToTileCoords(h).z!==n||this._keyToTileCoords(h).part!==this._selectedPart)&&(this._tiles[h].current=!1);for(var d=!0,u=r.min.y;u<=r.max.y;u++)for(var c=r.min.x;c<=r.max.x;c++){var _=new s.Point(c,u);if(_.z=n,_.part=this._selectedPart,this._isValidTile(_)){h=this._tileCoordsToKey(_);var p=this._tiles[h];p?(p.current=!0,d=!1):l.push(_)}}if(0!==l.length){if(d){this._map._socket.sendMessage("canceltiles");for(h in this._tiles)(!this._tiles[h].loaded||this._tiles[h]._invalidCount>0)&&(s.DomUtil.remove(this._tiles[h].el),delete this._tiles[h],this._debug&&(this._debugCancelledTiles++,this._debugShowTileData()));this._emptyTilesCount=0}this._noTilesToLoad()&&this.fire("loading");var m=e.createDocumentFragment();this._addTiles(l,m),this._level.el.appendChild(m)}}},_updateOnChangePart:function(){var t=this._map;if(t&&""!==this._documentInfo){var i,n,o,a=t.getCenter(),r=Math.round(t.getZoom()),l=t.getPixelBounds(a,r),h=this._pxBoundsToTileRange(l),d=[];for(i in this._tiles)(this._keyToTileCoords(i).z!==r||this._keyToTileCoords(i).part!==this._selectedPart)&&(this._tiles[i].current=!1);for(var u=!0,c=h.min.y;c<=h.max.y;c++)for(var _=h.min.x;_<=h.max.x;_++)n=new s.Point(_,c),n.z=r,n.part=this._selectedPart,this._isValidTile(n)&&(i=this._tileCoordsToKey(n),o=this._tiles[i],o?(o.current=!0,u=!1):d.push(n));if(0!==d.length){if(u){this._map._socket.sendMessage("canceltiles");for(i in this._tiles)o=this._tiles[i],(!o.loaded||o._invalidCount>0)&&(s.DomUtil.remove(o.el),delete this._tiles[i],this._debug&&this._debugDataCancelledTiles&&(this._debugCancelledTiles++,this._debugDataCancelledTiles.setPrefix("Cancelled tiles: "+this._debugCancelledTiles)));this._emptyTilesCount=0}this._noTilesToLoad()&&this.fire("loading");var p=e.createDocumentFragment(),m="",g="";for(_=0;_<d.length;_++){n=d[_];var f=this._getTilePos(n);if(i=this._tileCoordsToKey(n),n.part===this._selectedPart&&(o=this.createTile(this._wrapCoords(n),s.bind(this._tileReady,this,n)),this._initTile(o),this.createTile.length<2&&setTimeout(s.bind(this._tileReady,this,n,null,o),0),s.DomUtil.setPosition(o,f,!0),this._tiles[i]={el:o,coords:n,current:!0},p.appendChild(o),this.fire("tileloadstart",{tile:o,coords:n})),this._tileCache[i])o.src=this._tileCache[i];else{var v=this._coordsToTwips(n);""!==m&&(m+=","),m+=v.x,""!==g&&(g+=","),g+=v.y}}if(""!==m&&""!==g){var y="tilecombine part="+this._selectedPart+" width="+this._tileWidthPx+" height="+this._tileHeightPx+" tileposx="+m+" tileposy="+g+" tilewidth="+this._tileWidthTwips+" tileheight="+this._tileHeightTwips;this._map._socket.sendMessage(y,"")}this._level.el.appendChild(p)}}},_isValidTile:function(t){return t.x<0||t.y<0?!1:t.x*this._tileWidthTwips>=this._docWidthTwips||t.y*this._tileHeightTwips>=this._docHeightTwips?!1:!0},_keyToBounds:function(t){return this._tileCoordsToBounds(this._keyToTileCoords(t))},_tileCoordsToBounds:function(t){var e=this._map,i=this._getTileSize(),n=t.multiplyBy(i),o=n.add([i,i]),a=e.wrapLatLng(e.unproject(n,t.z)),r=e.wrapLatLng(e.unproject(o,t.z));return new s.LatLngBounds(a,r)},_tileCoordsToKey:function(t){return t.x+":"+t.y+":"+t.z+":"+t.part},_keyToTileCoords:function(t){var e=t.split(":"),i=new s.Point(+e[0],+e[1]);return i.z=+e[2],i.part=+e[3],i},_removeTile:function(t){var e=this._tiles[t];e&&(this._tiles[t]._invalidCount>0||(this._tileCache[t]=e.el.src),!e.loaded&&this._emptyTilesCount>0&&(this._emptyTilesCount-=1),s.DomUtil.remove(e.el),this._debug&&this._debugInfo&&this._tiles[t]._debugPopup&&this._debugInfo.removeLayer(this._tiles[t]._debugPopup),delete this._tiles[t],this.fire("tileunload",{tile:e.el,coords:this._keyToTileCoords(t)}))},_initTile:function(t){s.DomUtil.addClass(t,"leaflet-tile"),t.style.width=this._tileSize+"px",t.style.height=this._tileSize+"px",t.onselectstart=s.Util.falseFn,t.onmousemove=s.Util.falseFn,s.Browser.ielt9&&this.options.opacity<1&&s.DomUtil.setOpacity(t,this.options.opacity),s.Browser.android&&!s.Browser.android23&&(t.style.WebkitBackfaceVisibility="hidden")},_addTiles:function(t,e){for(var i,n,o=0;o<t.length;o++){i=t[o];var a=this._getTilePos(i);if(n=this._tileCoordsToKey(i),i.part===this._selectedPart){var r=this.createTile(this._wrapCoords(i),s.bind(this._tileReady,this,i));this._initTile(r),this.createTile.length<2&&setTimeout(s.bind(this._tileReady,this,i,null,r),0),s.DomUtil.setPosition(r,a,!0),this._tiles[n]={el:r,coords:i,current:!0},e.appendChild(r),this.fire("tileloadstart",{tile:r,coords:i})}this._tileCache[n]&&(r.src=this._tileCache[n])}t.sort(function(t,e){return t.y!==e.y?t.y-e.y:t.x-e.x});for(var l=[];t.length>0;)if(i=t[0],n=this._tileCoordsToKey(i),this._tileCache[n]||i.part!==this._selectedPart)t.splice(0,1);else{var h=[i],d=new s.Point(i.x,i.y);t.splice(0,1);var u=!1,c=!1;for(o=0;o<t.length;){var _=t[o];if(c||_.y!==d.y+1||(u=!0,++d.y),_.y>d.y)break;u?_.x<=d.x&&_.y<=d.y?(h.push(_),t.splice(o,1)):(c=!0,++o):_.y===d.y&&_.x===d.x+1?(++d.x,h.push(_),t.splice(o,1)):(u=!0,++o)}l.push(h)}for(var p,m,g=0;g<l.length;++g)if(h=l[g],1===h.length)i=h[0],n=this._tileCoordsToKey(i),p=this._coordsToTwips(i),m="tile part="+i.part+" width="+this._tileWidthPx+" height="+this._tileHeightPx+" tileposx="+p.x+" tileposy="+p.y+" tilewidth="+this._tileWidthTwips+" tileheight="+this._tileHeightTwips,this._map._socket.sendMessage(m,n);else{var f="",v="";for(o=0;o<h.length;o++)i=h[o],p=this._coordsToTwips(i),""!==f&&(f+=","),f+=p.x,""!==v&&(v+=","),v+=p.y;p=this._coordsToTwips(i),m="tilecombine part="+i.part+" width="+this._tileWidthPx+" height="+this._tileHeightPx+" tileposx="+f+" tileposy="+v+" tilewidth="+this._tileWidthTwips+" tileheight="+this._tileHeightTwips,this._map._socket.sendMessage(m,"")}},_tileReady:function(t,e,i){if(this._map){e&&this.fire("tileerror",{error:e,tile:i,coords:t});var n=this._tileCoordsToKey(t);i=this._tiles[n],i&&(i.loaded=+new Date,this._map._fadeAnimated?(s.DomUtil.setOpacity(i.el,0),s.Util.cancelAnimFrame(this._fadeFrame),this._fadeFrame=s.Util.requestAnimFrame(this._updateOpacity,this)):i.active=!0,s.DomUtil.addClass(i.el,"leaflet-tile-loaded"),this._noTilesToLoad()&&(this.fire("load"),this._pruneTiles()))}},_getTilePos:function(t){return t.multiplyBy(this._tileSize).subtract(this._level.origin)},_wrapCoords:function(t){var e=new s.Point(this._wrapX?s.Util.wrapNum(t.x,this._wrapX):t.x,this._wrapY?s.Util.wrapNum(t.y,this._wrapY):t.y);return e.z=t.z,e.part=t.part,e},_pxBoundsToTileRange:function(t){return new s.Bounds(t.min.divideBy(this._tileSize).floor().subtract([1,1]),t.max.divideBy(this._tileSize).ceil())},_twipsToCoords:function(t){return new s.Point(Math.round(t.x/t.tileWidth),Math.round(t.y/t.tileHeight))},_coordsToTwips:function(t){return new s.Point(t.x*this._tileWidthTwips,t.y*this._tileHeightTwips)},_twipsToLatLng:function(t,e){var i=new s.Point(t.x/this._tileWidthTwips*this._tileSize,t.y/this._tileHeightTwips*this._tileSize);return this._map.unproject(i,e)},_latLngToTwips:function(t,e){var i=this._map.project(t,e);return new s.Point(Math.round(i.x/this._tileSize*this._tileWidthTwips),Math.round(i.y/this._tileSize*this._tileHeightTwips))},_twipsToPixels:function(t){return new s.Point(t.x/this._tileWidthTwips*this._tileSize,t.y/this._tileHeightTwips*this._tileSize)},_pixelsToTwips:function(t){return new s.Point(t.x*this._tileWidthTwips/this._tileSize,t.y*this._tileHeightTwips/this._tileSize)},_twipsRectangleToPixelBounds:function(t){var e=t.match(/\d+/g);if(!e)return null;var i=new s.Point(parseInt(e[0]),parseInt(e[1])),n=new s.Point(parseInt(e[2]),parseInt(e[3])),o=i.add(n);return new s.Bounds(this._twipsToPixels(i),this._twipsToPixels(o))},_twipsRectanglesToPixelBounds:function(t){t=t.split(";");for(var e=[],i=0;i<t.length;i++){var n=this._twipsRectangleToPixelBounds(t[i]);n&&e.push(n)}return e},_noTilesToLoad:function(){for(var t in this._tiles)if(!this._tiles[t].loaded)return!1;return!0},_preFetchTiles:function(){if(!(this._emptyTilesCount>0)){var t=this._map.getCenter(),i=this._map.getZoom(),n=10,o=5;if("edit"===this._map._permission&&(n=5,o=3),this._preFetchBorder)a=this._preFetchBorder;else if(this._selectedPart!==this._preFetchPart)var a=this._preFetchBorder=new s.Bounds(new s.Point(0,0),new s.Point(0,0));else{var r=this._map.getPixelBounds(t,i);a=this._pxBoundsToTileRange(r),this._preFetchBorder=a}for(var l=[],h=[],d={},u=0;(a.min.x>=0||a.min.y>=0||a.max.x*this._tileWidthTwips<this._docWidthTwips||a.max.y*this._tileHeightTwips<this._docHeightTwips)&&n>0&&o>u;){for(var c=a.min.x;c<=a.max.x;c++){var _=new s.Point(c,a.max.y);l.push(_)}for(c=a.min.x;c<=a.max.x;c++)_=new s.Point(c,a.min.y),l.push(_);for(c=a.min.y;c<=a.max.y;c++)_=new s.Point(a.max.x,c),l.push(_);for(c=a.min.y;c<=a.max.y;c++)_=new s.Point(a.min.x,c),l.push(_);for(c=0;c<l.length&&n>0;c++){_=l[c],_.z=i,_.part=this._preFetchPart;var p=this._tileCoordsToKey(_);!this._isValidTile(_)||this._tiles[p]||this._tileCache[p]||d[p]||(d[p]=!0,h.push(_),n-=1)}0!==n&&(a.min.x>=0&&(a.min.x-=1),a.min.y>=0&&(a.min.y-=1),a.max.x*this._tileWidthTwips<=this._docWidthTwips&&(a.max.x+=1),a.max.y*this._tileHeightTwips<=this._docHeightTwips&&(a.max.y+=1),u+=1)}if(h.length>0){var m=e.createDocumentFragment();this._addTiles(h,m),this._level.el.appendChild(m)}}},_resetPreFetching:function(t){if(this._map){clearInterval(this._tilesPreFetcher),clearTimeout(this._preFetchIdle),t&&(this._preFetchBorder=null);var e=750,i=5e3;this._preFetchPart=this._selectedPart,this._preFetchIdle=setTimeout(s.bind(function(){this._tilesPreFetcher=setInterval(s.bind(this._preFetchTiles,this),e)},this),i)}}}),s.gridLayer=function(t){return new s.GridLayer(t)},"function"!=typeof String.prototype.startsWith&&(String.prototype.startsWith=function(t){return this.slice(0,t.length)===t}),s.Compatibility={clipboardGet:function(e){var i=null;return e.clipboardData?i=e.clipboardData.getData("text/plain"):t.clipboardData&&(i=t.clipboardData.getData("Text")),i},clipboardSet:function(e,i){e.clipboardData?e.clipboardData.setData("text/plain",i):t.clipboardData&&t.clipboardData.setData("Text",i)}},s.TileLayer=s.GridLayer.extend({options:{maxZoom:18,subdomains:"abc",errorTileUrl:"",zoomOffset:0,maxNativeZoom:null,tms:!1,zoomReverse:!1,detectRetina:!0,crossOrigin:!1,previewInvalidationTimeout:1e3,marginX:10,marginY:10},initialize:function(t,e){this._url=t,e=s.setOptions(this,e),this._tileWidthPx=e.tileSize,this._tileHeightPx=e.tileSize,"spreadsheet"!==e.docType&&e.detectRetina&&s.Browser.retina&&e.maxZoom>0&&(this._tileWidthPx*=2,this._tileHeightPx*=2,e.zoomOffset++,e.minZoom=Math.max(0,e.minZoom),e.maxZoom--),"string"==typeof e.subdomains&&(e.subdomains=e.subdomains.split("")),s.Browser.android||this.on("tileunload",this._onTileRemove),this._docType=e.docType,this._documentInfo="",this._visibleCursor=new s.LatLngBounds(new s.LatLng(0,0),new s.LatLng(0,0)),this._isCursorOverlayVisible=!1,this._isCursorVisible=!0,this._graphicSelectionTwips=new s.Bounds(new s.Point(0,0),new s.Point(0,0)),this._graphicSelection=new s.LatLngBounds(new s.LatLng(0,0),new s.LatLng(0,0)),this._cellCursorTwips=new s.Bounds(new s.Point(0,0),new s.Point(0,0)),this._cellCursor=s.LatLngBounds.createDefault(),this._prevCellCursor=s.LatLngBounds.createDefault(),this._cellCursorOnPgUp=null,this._cellCursorOnPgDn=null,this._viewCursors={},this._cellViewCursors={},this._viewSelections={},this._graphicViewMarkers={},this._lastValidPart=-1,this._cursorMarker=null,this._graphicMarker=null,this._selectionHandles={},["start","end"].forEach(s.bind(function(t){this._selectionHandles[t]=s.marker(new s.LatLng(0,0),{icon:s.divIcon({className:"leaflet-selection-marker-"+t,iconSize:null}),draggable:!0})},this)),this._emptyTilesCount=0,this._msgQueue=[],this._toolbarCommandValues={},this._previewInvalidations=[],this._clientZoom="tilepixelwidth="+this._tileWidthPx+" tilepixelheight="+this._tileHeightPx+" tiletwipwidth="+this.options.tileWidthTwips+" tiletwipheight="+this.options.tileHeightTwips,this._followThis=-1,this._editorId=-1,this._followUser=!1,this._followEditor=!1,this._invalidateClientVisibleArea()},onAdd:function(t){this._initContainer(),this._getToolbarCommandsValues(),this._selections=new s.LayerGroup,"readonly"!==this.options.permission&&t.addLayer(this._selections),this._viewLayerGroup=new s.LayerGroup,"readonly"!==this.options.permission&&t.addLayer(this._viewLayerGroup),this._debug=t.options.debug,this._debug&&this._debugInit(),this._searchResultsLayer=new s.LayerGroup,t.addLayer(this._searchResultsLayer),this._levels={},this._tiles={},this._tileCache={},this._map._socket.sendMessage("commandvalues command=.uno:LanguageStatus"),this._map._socket.sendMessage("commandvalues command=.uno:ViewAnnotations");var e=this;$.contextMenu({selector:".loleaflet-annotation-menu",trigger:"none",className:"loleaflet-font",items:{modify:{name:_("Modify"),callback:function(t,i){e.onAnnotationModify.call(e,i.$trigger.get(0).annotation)}},reply:"text"!==this._docType&&"presentation"!==this._docType?i:{name:_("Reply"),callback:function(t,i){e.onAnnotationReply.call(e,i.$trigger.get(0).annotation)}},remove:{name:_("Remove"),callback:function(t,i){e.onAnnotationRemove.call(e,i.$trigger.get(0).annotation._data.id)}}},events:{show:function(t){t.$trigger.get(0).annotation._contextMenu=!0},hide:function(t){t.$trigger.get(0).annotation._contextMenu=!1}}}),$.contextMenu({selector:".loleaflet-annotation-menu-redline",trigger:"none",className:"loleaflet-font",items:{modify:{name:_("Comment"),callback:function(t,i){e.onAnnotationModify.call(e,i.$trigger.get(0).annotation)}}},events:{show:function(t){t.$trigger.get(0).annotation._contextMenu=!0},hide:function(t){t.$trigger.get(0).annotation._contextMenu=!1}}}),this._map._socket.sendMessage("commandvalues command=.uno:AcceptTrackedChanges"),t._fadeAnimated=!1,this._viewReset(),t.on("drag resize zoomend",this._updateScrollOffset,this),t.on("copy",this._onCopy,this),t.on("cut",this._onCut,this),t.on("paste",this._onPaste,this),t.on("dragover",this._onDragOver,this),t.on("drop",this._onDrop,this),t.on("zoomend",this._onUpdateCursor,this),"spreadsheet"===this._docType&&t.on("zoomend",this._onCellCursorShift,this),t.on("zoomend",this._updateClientZoom,this),t.on("zoomend",s.bind(this.eachView,this,this._viewCursors,this._onUpdateViewCursor,this,!1)),t.on("resize zoomend",this._invalidateClientVisibleArea,this),t.on("dragstart",this._onDragStart,this),t.on("requestloksession",this._onRequestLOKSession,this),t.on("error",this._mapOnError,this),t.options.autoFitWidth!==!1&&t.on("resize",this._fitWidthZoom,this),t.on("statusindicator",function(t){"alltilesloaded"===t.statusType&&"spreadsheet"===this._docType&&this._onCellCursorShift(!0)},this),t.on("updatepermission",function(t){"edit"!==t.perm&&this._clearSelections()},this);for(var n in this._selectionHandles)this._selectionHandles[n].on("drag dragend",this._onSelectionHandleDrag,this);this._textArea=t._textArea,this._textArea.focus(),t.setPermission(this.options.permission),t.fire("statusindicator",{statusType:"loleafletloaded"})},getEvents:function(){var t={viewreset:this._viewReset,movestart:this._moveStart,moveend:this._move};return this.options.updateWhenIdle||(t.move=s.Util.throttle(this._move,this.options.updateInterval,this)),this._zoomAnimated&&(t.zoomanim=this._animateZoom),t},registerExportFormat:function(t,e){this._exportFormats||(this._exportFormats=[]),this._exportFormats.push({label:t,format:e})},setUrl:function(t,e){return this._url=t,e||this.redraw(),this},createTile:function(t,i){var n=e.createElement("img");return n.onload=s.bind(this._tileOnLoad,this,i,n),n.onerror=s.bind(this._tileOnError,this,i,n),this.options.crossOrigin&&(n.crossOrigin=""),n.alt="",this._emptyTilesCount+=1,n},_getToolbarCommandsValues:function(){for(var t=0;t<this._map.unoToolbarCommands.length;t++){var e=this._map.unoToolbarCommands[t];this._map._socket.sendMessage("commandvalues command="+e)}},_onMessage:function(t,e){if(t.startsWith("commandvalues:"))this._onCommandValuesMsg(t);else if(t.startsWith("cursorvisible:"))this._onCursorVisibleMsg(t);else if(t.startsWith("downloadas:"))this._onDownloadAsMsg(t);else if(t.startsWith("error:"))this._onErrorMsg(t);else if(t.startsWith("getchildid:"))this._onGetChildIdMsg(t);else if(t.startsWith("graphicselection:"))this._onGraphicSelectionMsg(t);else if(t.startsWith("cellcursor:"))this._onCellCursorMsg(t);else if(t.startsWith("celladdress:"))this._onCellAddressMsg(t);else if(t.startsWith("cellformula:"))this._onCellFormulaMsg(t);else if(t.startsWith("hyperlinkclicked:"))this._onHyperlinkClickedMsg(t);else if(t.startsWith("invalidatecursor:"))this._onInvalidateCursorMsg(t);else if(t.startsWith("invalidatetiles:")){var i=t.substring("invalidatetiles:".length+1);if(i.startsWith("EMPTY")){var n="invalidatetiles: ";if("text"===this._docType)n+="part=0 ";else{var o=parseInt(i.substring("EMPTY".length+1));n+="part="+(isNaN(o)?this._selectedPart:o)+" "}n+="x=0 y=0 ",n+="width="+this._docWidthTwips+" ",n+="height="+this._docHeightTwips,this._onInvalidateTilesMsg(n)}else this._onInvalidateTilesMsg(t)}else t.startsWith("mousepointer:")?this._onMousePointerMsg(t):t.startsWith("renderfont:")?this._onRenderFontMsg(t,e):t.startsWith("searchnotfound:")?this._onSearchNotFoundMsg(t):t.startsWith("searchresultselection:")?this._onSearchResultSelection(t):t.startsWith("setpart:")?this._onSetPartMsg(t):t.startsWith("statechanged:")?this._onStateChangedMsg(t):t.startsWith("status:")?this._onStatusMsg(t):t.startsWith("textselection:")?this._onTextSelectionMsg(t):t.startsWith("textselectioncontent:")?this._onTextSelectionContentMsg(t):t.startsWith("textselectionend:")?this._onTextSelectionEndMsg(t):t.startsWith("textselectionstart:")?this._onTextSelectionStartMsg(t):t.startsWith("tile:")?this._onTileMsg(t,e):t.startsWith("windowpaint:")?this._onDialogPaintMsg(t,e):t.startsWith("window:")?this._onDialogMsg(t):t.startsWith("unocommandresult:")?this._onUnoCommandResultMsg(t):t.startsWith("rulerupdate:")?this._onRulerUpdate(t):t.startsWith("contextmenu:")?this._onContextMenuMsg(t):t.startsWith("invalidateviewcursor:")?this._onInvalidateViewCursorMsg(t):t.startsWith("viewcursorvisible:")?this._onViewCursorVisibleMsg(t):t.startsWith("cellviewcursor:")?this._onCellViewCursorMsg(t):t.startsWith("viewinfo:")?this._onViewInfoMsg(t):t.startsWith("textviewselection:")?this._onTextViewSelectionMsg(t):t.startsWith("graphicviewselection:")?this._onGraphicViewSelectionMsg(t):t.startsWith("editor:")&&this._updateEditor(t)},toggleTileDebugMode:function(){this._invalidateClientVisibleArea(),this._debug=!this._debug,this._debug?(this._debugInfo&&(map.addLayer(this._debugInfo),map.addLayer(this._debugInfo2),$(".leaflet-control-layers-expanded").css("display","block")),this._debugInit()):(map.removeLayer(this._debugInfo),map.removeLayer(this._debugInfo2),$(".leaflet-control-layers-expanded").css("display","none")),this._onMessage("invalidatetiles: EMPTY",null)},_onCommandValuesMsg:function(t){var e=t.indexOf("{");if(-1!==e){var i=JSON.parse(t.substring(e));".uno:DocumentRepair"===i.commandName?this._onDocumentRepair(i):".uno:CellCursor"===i.commandName?this._onCellCursorMsg(i.commandValues):-1!==this._map.unoToolbarCommands.indexOf(i.commandName)?(this._toolbarCommandValues[i.commandName]=i.commandValues,this._map.fire("updatetoolbarcommandvalues",{commandName:i.commandName,commandValues:i.commandValues})):this._map.fire("commandvalues",{commandName:i.commandName,commandValues:i.commandValues})}},_onCellAddressMsg:function(t){var e=t.substring(13);this._map.fire("celladdress",{address:e})},_onCellFormulaMsg:function(t){var e=t.substring(13);this._map.wopi.DisableCopy||(this._selectionTextContent=e),this._map.fire("cellformula",{formula:e})},_onCursorVisibleMsg:function(t){var e=t.match("cursorvisible: true");this._isCursorVisible=e?!0:!1,this._isCursorOverlayVisible=!0,this._onUpdateCursor()},_onDownloadAsMsg:function(t){var i=this._map._socket.parseServerCmd(t),n=e.createElement("a");n.href=this._map.options.server;var o="";""!=map.options.wopiSrc&&(o="?WOPISrc="+map.options.wopiSrc);var a=this._map.options.webserver+"/"+this._map.options.urlPrefix+"/"+encodeURIComponent(this._map.options.doc)+"/"+i.jail+"/"+i.dir+"/"+i.name+o;this._map.hideBusy(),"print"===i.id?s.Browser.gecko||s.Browser.edge||this._map.options.print===!1?this._map.fire("print",{url:a}):this._map.fire("filedownloadready",{url:a}):"slideshow"===i.id?this._map.fire("slidedownloadready",{url:a}):"export"===i.id&&(this._map._fileDownloader.src=a)},_onErrorMsg:function(t){var e=this._map._socket.parseServerCmd(t),n=1;"load"===e.errorCmd?n=2:("save"===e.errorCmd||"saveas"===e.errorCmd)&&(n=5);var o=-1;e.errorCode!==i&&(o=e.errorCode),this._map.fire("error",{cmd:e.errorCmd,kind:e.errorKind,id:n,code:o})},_onGetChildIdMsg:function(t){var e=this._map._socket.parseServerCmd(t);this._map.fire("childid",{id:e.id})},_onGraphicSelectionMsg:function(t){if(t.match("EMPTY"))this._graphicSelectionTwips=new s.Bounds(new s.Point(0,0),new s.Point(0,0)),this._graphicSelection=new s.LatLngBounds(new s.LatLng(0,0),new s.LatLng(0,0));else{var e=t.match(/\d+/g),i=new s.Point(parseInt(e[0]),parseInt(e[1])),n=new s.Point(parseInt(e[2]),parseInt(e[3])),o=i.add(n);this._graphicSelectionTwips=new s.Bounds(i,o),this._graphicSelection=new s.LatLngBounds(this._twipsToLatLng(i,this._map.getZoom()),this._twipsToLatLng(o,this._map.getZoom()))}this._onUpdateGraphicSelection()},_onGraphicViewSelectionMsg:function(t){t=t.substring("graphicviewselection:".length+1);var e=JSON.parse(t),i=parseInt(e.viewId);if(i!==this._viewId&&this._map._viewInfo[i]){var n=e.selection.match(/\d+/g);if(this._graphicViewMarkers[i]=this._graphicViewMarkers[i]||{},this._graphicViewMarkers[i].part=parseInt(e.part),null!=n){var o=new s.Point(parseInt(n[0]),parseInt(n[1])),a=new s.Point(parseInt(n[2]),parseInt(n[3])),r=o.add(a);this._graphicViewMarkers[i].bounds=new s.LatLngBounds(this._twipsToLatLng(o,this._map.getZoom()),this._twipsToLatLng(r,this._map.getZoom()))}else this._graphicViewMarkers[i].bounds=s.LatLngBounds.createDefault();this._onUpdateGraphicViewSelection(i)}},_onCellCursorMsg:function(t){if(this._cellCursor||(this._cellCursor=s.LatLngBounds.createDefault()),this._prevCellCursor||(this._prevCellCursor=s.LatLngBounds.createDefault()),this._cellCursorXY||(this._cellCursorXY=new s.Point(-1,-1)),this._prevCellCursorXY||(this._prevCellCursorXY=new s.Point(-1,-1)),t.match("EMPTY"))this._cellCursorTwips=new s.Bounds(new s.Point(0,0),new s.Point(0,0)),this._cellCursor=s.LatLngBounds.createDefault(),this._cellCursorXY=new s.Point(-1,-1);else{var e=t.match(/\d+/g),i=new s.Point(parseInt(e[0]),parseInt(e[1])),n=new s.Point(parseInt(e[2]),parseInt(e[3])),o=i.add(n);this._cellCursorTwips=new s.Bounds(i,o),this._cellCursor=new s.LatLngBounds(this._twipsToLatLng(i,this._map.getZoom()),this._twipsToLatLng(o,this._map.getZoom())),this._cellCursorXY=new s.Point(parseInt(e[4]),parseInt(e[5]))}var a=0,r=0,l=function(t){return t>0?1:0>t?-1:t};this._isEmptyRectangle(this._prevCellCursor)||this._isEmptyRectangle(this._cellCursor)||(a=l(this._cellCursor.getWest()-this._prevCellCursor.getWest()),
r=l(this._cellCursor.getNorth()-this._prevCellCursor.getNorth()));var h=!1;this._isEmptyRectangle(this._cellCursor)||this._prevCellCursor.equals(this._cellCursor)||((this._cellCursorOnPgUp&&this._cellCursorOnPgUp.equals(this._prevCellCursor)||this._cellCursorOnPgDn&&this._cellCursorOnPgDn.equals(this._prevCellCursor))&&(h=!0),this._prevCellCursor=new s.LatLngBounds(this._cellCursor.getSouthWest(),this._cellCursor.getNorthEast())),this._onUpdateCellCursor(a,r,h)},_onDocumentRepair:function(t){this._docRepair||(this._docRepair=s.control.documentRepair()),this._docRepair.isVisible()||(this._docRepair.addTo(this._map),this._docRepair.fillActions(t),this._map.enable(!1),this._docRepair.show())},_onSpecialChar:function(t,e){this._specialChar||(this._specialChar=s.control.characterMap()),this._specialChar.isVisible()||(this._specialChar.addTo(this._map),this._specialChar.fillFontNames(t,e),this._map.enable(!1),this._specialChar.show())},_onMousePointerMsg:function(t){t=t.substring(14),t=s.Cursor.getCustomCursor(t)||t,this._map._container.style.cursor!==t&&(this._map._container.style.cursor=t)},_onHyperlinkClickedMsg:function(t){var e=t.substring(18);this._map.fire("hyperlinkclicked",{url:e})},_onInvalidateCursorMsg:function(t){var e=this._map._docLayer,i=t.match(/\d+/g),n=new s.Point(parseInt(i[0]),parseInt(i[1])),o=new s.Point(parseInt(i[2]),parseInt(i[3])),a=n.add(o);this._visibleCursor=new s.LatLngBounds(this._twipsToLatLng(n,this._map.getZoom()),this._twipsToLatLng(a,this._map.getZoom())),this._visibleCursorOnLostFocus=this._visibleCursor,this._isCursorOverlayVisible=!0,(e._followEditor||e._followUser)&&this._map.lastActionByUser&&this._map.fire("setFollowOff"),this._map.lastActionByUser=!1,this._onUpdateCursor()},_updateEditor:function(t){t=t.substring("editor:".length+1);var e=parseInt(t),i=this._map._docLayer;i._editorId=e,i._followEditor&&(i._followThis=e),this._map._viewInfo[e]&&this._map.fire("updateEditorName",{username:this._map._viewInfo[e].username})},_onInvalidateViewCursorMsg:function(t){t=t.substring("invalidateviewcursor:".length+1);var e=JSON.parse(t),i=parseInt(e.viewId),n=this._map._docLayer;if(i!==this._viewId&&this._map._viewInfo[i]){var o=e.rectangle.match(/\d+/g),a=new s.Point(parseInt(o[0]),parseInt(o[1])),r=new s.Point(parseInt(o[2]),parseInt(o[3])),l=a.add(r);this._viewCursors[i]=this._viewCursors[i]||{},this._viewCursors[i].bounds=new s.LatLngBounds(this._twipsToLatLng(a,this._map.getZoom()),this._twipsToLatLng(l,this._map.getZoom())),this._viewCursors[i].part=parseInt(e.part),"undefined"==typeof this._viewCursors[i].visible&&(this._viewCursors[i].visible=!0),this._onUpdateViewCursor(i),n._followThis===i&&(n._followEditor||n._followUser)&&("text"===this._map.getDocType()||"presentation"===this._map.getDocType()?this.goToViewCursor(i):"spreadsheet"===this._map.getDocType()&&this.goToCellViewCursor(i))}},_onCellViewCursorMsg:function(t){t=t.substring("cellviewcursor:".length+1);var e=JSON.parse(t),i=parseInt(e.viewId);if(i!==this._viewId){if(this._cellViewCursors[i]=this._cellViewCursors[i]||{},this._cellViewCursors[i].bounds||(this._cellViewCursors[i].bounds=s.LatLngBounds.createDefault()),e.rectangle.match("EMPTY"))this._cellViewCursors[i].bounds=s.LatLngBounds.createDefault();else{var n=e.rectangle.match(/\d+/g),o=new s.Point(parseInt(n[0]),parseInt(n[1])),a=new s.Point(parseInt(n[2]),parseInt(n[3])),r=o.add(a);this._cellViewCursors[i].bounds=new s.LatLngBounds(this._twipsToLatLng(o,this._map.getZoom()),this._twipsToLatLng(r,this._map.getZoom()))}this._cellViewCursors[i].part=parseInt(e.part),this._onUpdateCellViewCursor(i)}},_onUpdateCellViewCursor:function(t){if(this._cellViewCursors[t]&&this._cellViewCursors[t].bounds){var e=this._cellViewCursors[t].marker,i=this._cellViewCursors[t].part;if(this._isEmptyRectangle(this._cellViewCursors[t].bounds)||this._selectedPart!==i)e&&this._viewLayerGroup.removeLayer(e);else{if(e)e.setBounds(this._cellViewCursors[t].bounds);else{var n=s.LOUtil.rgbToHex(this._map.getViewColor(t));e=s.rectangle(this._cellViewCursors[t].bounds,{fill:!1,color:n,weight:2}),this._cellViewCursors[t].marker=e,e.bindPopup(this._map.getViewName(t),{autoClose:!1,autoPan:!1,backgroundColor:n,color:"white",closeButton:!1})}this._viewLayerGroup.addLayer(e)}}},goToCellViewCursor:function(t){if(this._cellViewCursors[t]&&!this._isEmptyRectangle(this._cellViewCursors[t].bounds)){if(!this._map.getBounds().contains(this._cellViewCursors[t].bounds)){var e=this._map.getBounds(),i=0,n=0,o=Math.abs(this._cellViewCursors[t].bounds.getEast()-this._cellViewCursors[t].bounds.getWest())/4,a=Math.abs(this._cellViewCursors[t].bounds.getSouth()-this._cellViewCursors[t].bounds.getNorth())/4;if(this._cellViewCursors[t].bounds.getWest()<e.getWest()?i=this._cellViewCursors[t].bounds.getWest()-e.getWest()-o:this._cellViewCursors[t].bounds.getEast()>e.getEast()&&(i=this._cellViewCursors[t].bounds.getEast()-e.getEast()+o),this._cellViewCursors[t].bounds.getNorth()>e.getNorth()?n=this._cellViewCursors[t].bounds.getNorth()-e.getNorth()+a:this._cellViewCursors[t].bounds.getSouth()<e.getSouth()&&(n=this._cellViewCursors[t].bounds.getSouth()-e.getSouth()-a),0!==i||0!==n){var r=e.getCenter();r.lat+=i,r.lat+=n;var l=this._map.project(r);l=l.subtract(this._map.getSize().divideBy(2)),l.x=Math.round(l.x<0?0:l.x),l.y=Math.round(l.y<0?0:l.y),this._map.fire("scrollto",{x:l.x,y:l.y})}}var h=s.LOUtil.rgbToHex(this._map.getViewColor(t));this._cellViewCursors[t].marker.bindPopup(this._map.getViewName(t),{autoClose:!1,autoPan:!1,backgroundColor:h,color:"white",closeButton:!1})}},_onViewCursorVisibleMsg:function(t){t=t.substring("viewcursorvisible:".length+1);var e=JSON.parse(t),i=parseInt(e.viewId);i!==this._viewId&&this._map._viewInfo[i]&&("undefined"!=typeof this._viewCursors[i]&&(this._viewCursors[i].visible="true"===e.visible),this._onUpdateViewCursor(i))},_addView:function(t){0===t.color&&"text"!==this._map.getDocType()&&(t.color=s.LOUtil.getViewIdColor(t.id)),this._map.addView(t),"undefined"!=typeof this._viewCursors[t.id]&&(this._viewCursors[t.id]={}),this._onUpdateViewCursor(t.id)},_removeView:function(t){this._viewSelections[t]&&this._viewSelections[t].selection&&this._viewLayerGroup.removeLayer(this._viewSelections[t].selection),"undefined"!=typeof this._viewCursors[t]&&(this._viewCursors[t].visible=!1,this._onUpdateViewCursor(t),delete this._viewCursors[t]),this._map.removeView(t)},removeAllViews:function(){for(var t in this._map._viewInfo)this._removeView(parseInt(t))},_onViewInfoMsg:function(t){t=t.substring("viewinfo: ".length);var e=JSON.parse(t);this._map.fire("viewinfo",e);var i=[];for(var n in e)parseInt(e[n].id)in this._map._viewInfo||this._addView(e[n]),i.push(e[n].id);for(n in this._map._viewInfo)-1===i.indexOf(parseInt(n))&&this._removeView(parseInt(n))},_onRenderFontMsg:function(t,e){var i=this._map._socket.parseServerCmd(t);this._map.fire("renderfont",{font:i.font,"char":i["char"],img:e})},_onSearchNotFoundMsg:function(t){this._clearSearchResults(),this._searchRequested=!1;var e=t.substring(16);this._map.fire("search",{originalPhrase:e,count:0})},_onSearchResultSelection:function(t){this._searchRequested=!1,t=t.substring(23);for(var e=JSON.parse(t),i=e.searchString,n=e.searchResultSelection.length,o=e.highlightAll,s=[],a=0;a<e.searchResultSelection.length;a++)s.push({part:parseInt(e.searchResultSelection[a].part),rectangles:this._twipsRectanglesToPixelBounds(e.searchResultSelection[a].rectangles),twipsRectangles:e.searchResultSelection[a].rectangles});n>1?(this._clearSearchResults(),this._searchResults=s,this._map.setPart(s[0].part)):1===n&&(this._lastSearchResult=s[0]),this._searchTerm=i,this._map.fire("search",{originalPhrase:i,count:n,highlightAll:o,results:s})},_clearSearchResults:function(){this._lastSearchResult=null,this._searchResults=null,this._searchTerm=null,this._searchResultsLayer.clearLayers()},_drawSearchResults:function(){if(this._searchResults){this._searchResultsLayer.clearLayers();for(var t=0;t<this._searchResults.length;t++){var e=this._searchResults[t];if(e.part===this._selectedPart){for(var i="#CCCCCC",n=e.twipsRectangles.match(/\d+/g),o=[],a=0;a<n.length;a+=4){var r=new s.Point(parseInt(n[a]),parseInt(n[a+1])),l=new s.Point(parseInt(n[a+2]),parseInt(n[a+3])),h=r.add(new s.Point(l.x,0)),d=r.add(new s.Point(0,l.y)),u=r.add(l);o.push([d,u,r,h])}var c=s.PolyUtil.rectanglesToPolygons(o,this),_=new s.Polygon(c,{pointerEvents:"none",fillColor:i,fillOpacity:.25,weight:2,opacity:.25});this._searchResultsLayer.addLayer(_)}}}},_onStateChangedMsg:function(t){t=t.substr(14);var e=t.indexOf("="),i=-1!==e?t.substr(0,e):"",n=-1!==e?t.substr(e+1):"";this._map.fire("commandstatechanged",{commandName:i,state:n})},_onUnoCommandResultMsg:function(t){t=t.substring(18);var e=JSON.parse(t),i=e.commandName;if("true"===e.success)var n=!0;else"false"===e.success&&(n=!1);this._map.hideBusy(),this._map.fire("commandresult",{commandName:i,success:n,result:e.result})},_onRulerUpdate:function(t){t=t.substring(13);var e=JSON.parse(t);this._map.fire("rulerupdate",e)},_onContextMenuMsg:function(t){t=t.substring(13);var e=JSON.parse(t);this._map.fire("locontextmenu",e)},_onTextSelectionMsg:function(t){var e=t.match(/\d+/g);if(this._selections.clearLayers(),null!=e){for(var i=[],n=0;n<e.length;n+=4){var o=new s.Point(parseInt(e[n]),parseInt(e[n+1])),a=new s.Point(parseInt(e[n+2]),parseInt(e[n+3])),r=o.add(new s.Point(a.x,0)),l=o.add(new s.Point(0,a.y)),h=o.add(a);i.push([l,h,o,r])}var d=s.PolyUtil.rectanglesToPolygons(i,this),u=new s.Polygon(d,{pointerEvents:"none",fillColor:"#43ACE8",fillOpacity:.25,weight:2,opacity:.25});this._selections.addLayer(u),this._selectionContentRequest&&clearTimeout(this._selectionContentRequest),this._selectionContentRequest=setTimeout(s.bind(function(){this._map._socket.sendMessage("gettextselection mimetype=text/plain;charset=utf-8")},this),100)}this._onUpdateTextSelection()},_onTextViewSelectionMsg:function(t){t=t.substring("textviewselection:".length+1);var e=JSON.parse(t),i=parseInt(e.viewId),n=parseInt(e.part);if(i!==this._viewId&&this._map._viewInfo[i]){var o=e.selection.match(/\d+/g);if(this._viewSelections[i]=this._viewSelections[i]||{},null!=o){for(var a=[],r=0;r<o.length;r+=4){var l=new s.Point(parseInt(o[r]),parseInt(o[r+1])),h=new s.Point(parseInt(o[r+2]),parseInt(o[r+3])),d=l.add(new s.Point(h.x,0)),u=l.add(new s.Point(0,h.y)),c=l.add(h);a.push([u,c,l,d])}this._viewSelections[i].part=n,this._viewSelections[i].polygons=s.PolyUtil.rectanglesToPolygons(a,this)}else this._viewSelections[i].polygons=null;this._onUpdateTextViewSelection(i)}},_onTextSelectionContentMsg:function(t){this._selectionTextContent=t.substr(22)},_onTextSelectionEndMsg:function(t){var e=t.match(/\d+/g);if(null!=e&&"edit"===this._map._permission){var i=new s.Point(parseInt(e[0]),parseInt(e[1])),n=new s.Point(parseInt(e[2]),parseInt(e[3])),o=i.add(n);this._textSelectionEnd=new s.LatLngBounds(this._twipsToLatLng(i,this._map.getZoom()),this._twipsToLatLng(o,this._map.getZoom()))}else this._textSelectionEnd=null},_onTextSelectionStartMsg:function(t){var e=t.match(/\d+/g);if(null!=e&&"edit"===this._map._permission){var i=new s.Point(parseInt(e[0]),parseInt(e[1])),n=new s.Point(parseInt(e[2]),parseInt(e[3])),o=i.add(n);this._textSelectionStart=new s.LatLngBounds(this._twipsToLatLng(i,this._map.getZoom()),this._twipsToLatLng(o,this._map.getZoom()))}else this._textSelectionStart=null},_onDialogPaintMsg:function(t,e){var i=this._map._socket.parseServerCmd(t);this._map.fire("windowpaint",{id:i.id,img:e,width:i.width,height:i.height,rectangle:i.rectangle})},_onDialogMsg:function(t){t=t.substring("window: ".length);var e=JSON.parse(t);e.winType=e.type,this._map.fire("window",e)},_onTileMsg:function(t,n){var a=this._map._socket.parseServerCmd(t),r=this._twipsToCoords(a);r.z=a.zoom,r.part=a.part;var l=this._tileCoordsToKey(r),h=this._tiles[l];if(this._debug&&h){if(h._debugLoadCount?(h._debugLoadCount++,this._debugLoadCount++):(h._debugLoadCount=1,h._debugInvalidateCount=1),!h._debugPopup){var d=this._keyToBounds(l);h._debugPopup=s.popup({className:"debug",offset:new s.Point(0,0),autoPan:!1,closeButton:!1,closeOnClick:!1}).setLatLng(new s.LatLng(d.getSouth(),d.getWest()+(d.getEast()-d.getWest())/5)),this._debugInfo.addLayer(h._debugPopup),this._debugTiles[l]&&this._debugInfo.removeLayer(this._debugTiles[l]),h._debugTile=s.rectangle(d,{color:"blue",weight:1,fillOpacity:0,pointerEvents:"none"}),this._debugTiles[l]=h._debugTile,h._debugTime=this._debugGetTimeArray(),this._debugInfo.addLayer(h._debugTile)}0===h._debugTime.date?h._debugPopup.setContent("requested: "+this._tiles[l]._debugInvalidateCount+"<br>received: "+this._tiles[l]._debugLoadCount):h._debugPopup.setContent("requested: "+this._tiles[l]._debugInvalidateCount+"<br>received: "+this._tiles[l]._debugLoadCount+"<br>"+this._debugSetTimes(h._debugTime,+new Date-h._debugTime.date).replace(/, /g,"<br>")),h._debugTile&&h._debugTile.setStyle({fillOpacity:"cached"===a.renderid?.1:0,fillColor:"yellow"}),this._debugShowTileData()}if(a.id!==i)this._map.fire("tilepreview",{tile:n,id:a.id,width:a.width,height:a.height,part:a.part,docType:this._docType});else if(h&&"object"==typeof n){var u=e.createElement("canvas");u.width=256,u.height=256;var c=u.getContext("2d"),_=new Image;_.src=h.el.src,c.drawImage(_,0,0);var p=c.getImageData(0,0,u.width,u.height),m=new Uint8ClampedArray(p.data),g=n,f=u.width*u.height*4,v=0;console.log("Applying a delta of length "+g.length+" pix size: "+f+"\nhex: "+o(g));for(var y=1;y<g.length;)switch(g[y]){case 99:var w=g[y+1],C=g[y+2],x=g[y+3];y+=4,console.log("copy "+w+" row(s) "+C+" to "+x);for(var b=0;w>b;++b)for(var P=(C+b)*u.width*4,L=(x+b)*u.width*4,T=0;T<4*u.width;++T)p.data[L+T]=m[P+T];break;case 100:x=g[y+1];var S=g[y+2],D=g[y+3];for(v=x*u.width*4+4*S,y+=4,console.log("apply new span of size "+D+" at pos "+S+", "+x+" into delta at byte: "+v),D*=4,p.data[v+1]=256;D-->0;)p.data[v++]=g[y++];p.data[v-2]=256;break;default:console.log("ERROR: Unknown code "+g[y]+" at offset "+y),y=g.length}c.putImageData(p,0,0),h.oldWireId=h.wireId,h.wireId=a.wireId,h.el.src=u.toDataURL("image/png"),console.log("set new image")}else h&&(a.wireId!=i&&(h.oldWireId=a.wireId),this._tiles[l]._invalidCount>0&&(this._tiles[l]._invalidCount-=1),h.loaded||(this._emptyTilesCount-=1,0===this._emptyTilesCount&&this._map.fire("statusindicator",{statusType:"alltilesloaded"})),h.el.src=n);s.Log.log(t,s.INCOMING,l)},_tileOnLoad:function(t,e){t(null,e)},_tileOnError:function(t,e,i){var n=this.options.errorTileUrl;n&&(e.src=n),t(i,e)},_mapOnError:function(t){t.msg&&"edit"===this._map._permission&&this._map.setPermission("view")},_onTileRemove:function(t){t.tile.onload=null},_clearSelections:function(){this._isCursorOverlayVisible=!1,this._onUpdateCursor(),this._selections.clearLayers(),this._onUpdateTextSelection(),this._graphicSelection=null,this._onUpdateGraphicSelection(),this._cellCursor=null,this._onUpdateCellCursor()},_postMouseEvent:function(t,e,i,n,o,s){this._clientZoom&&(this._map._socket.sendMessage("clientzoom "+this._clientZoom),this._clientZoom=null),this._map._socket.sendMessage("mouse type="+t+" x="+e+" y="+i+" count="+n+" buttons="+o+" modifier="+s),"buttondown"===t&&this._clearSearchResults()},_postKeyboardEvent:function(t,e,i){if("spreadsheet"===this._docType&&this._prevCellCursor&&"input"===t)if(1030===i){if(this._cellCursorOnPgUp)return;this._cellCursorOnPgUp=new s.LatLngBounds(this._prevCellCursor.getSouthWest(),this._prevCellCursor.getNorthEast())}else if(1031===i){if(this._cellCursorOnPgDn)return;this._cellCursorOnPgDn=new s.LatLngBounds(this._prevCellCursor.getSouthWest(),this._prevCellCursor.getNorthEast())}if(this._clientZoom&&(this._map._socket.sendMessage("clientzoom "+this._clientZoom),this._clientZoom=null),this._clientVisibleArea){var n=this._map._container.getBoundingClientRect(),o=this._pixelsToTwips(new s.Point(n.left,n.top)),a=this._pixelsToTwips(new s.Point(n.width,n.height)),r="clientvisiblearea x="+Math.round(o.x)+" y="+Math.round(o.y)+" width="+Math.round(a.x)+" height="+Math.round(a.y);this._map._socket.sendMessage(r),this._clientVisibleArea=!1}this._map._socket.sendMessage("key type="+t+" char="+e+" key="+i)},_postSelectGraphicEvent:function(t,e,i){this._map._socket.sendMessage("selectgraphic type="+t+" x="+e+" y="+i)},_postSelectTextEvent:function(t,e,i){this._map._socket.sendMessage("selecttext type="+t+" x="+e+" y="+i)},_isEmptyRectangle:function(t){return t?t.getSouthWest().equals(new s.LatLng(0,0))&&t.getNorthEast().equals(new s.LatLng(0,0)):!0},_onUpdateCursor:function(t){var e=this._visibleCursor.getNorthWest(),i=this._map._docLayer;if(!t&&!this._map.getBounds().contains(this._visibleCursor)&&this._isCursorVisible){var n=this._map.project(e);n=n.subtract(this._map.getSize().divideBy(2)),n.x=Math.round(n.x<0?0:n.x),n.y=Math.round(n.y<0?0:n.y),this._selectionHandles.start&&this._selectionHandles.start.isDragged||this._selectionHandles.end&&this._selectionHandles.end.isDragged||i._followEditor||i._followUser||this._map.fire("scrollto",{x:n.x,y:n.y})}this._updateCursorAndOverlay(),this.eachView(this._viewCursors,function(t){var e=t.marker;e&&e.setOpacity(this._map.hasLayer(this._cursorMarker)&&this._cursorMarker.getLatLng().equals(e.getLatLng())?0:1)},this,!0)},_updateCursorAndOverlay:function(){if("edit"===this._map._permission&&this._isCursorVisible&&this._isCursorOverlayVisible&&!this._isEmptyRectangle(this._visibleCursor)){var t=s.bounds(this._map.latLngToLayerPoint(this._visibleCursor.getSouthWest()),this._map.latLngToLayerPoint(this._visibleCursor.getNorthEast())),e=this._visibleCursor.getNorthWest();this._cursorMarker?this._cursorMarker.setLatLng(e,t.getSize().multiplyBy(this._map.getZoomScale(this._map.getZoom()))):this._cursorMarker=s.cursor(e,t.getSize().multiplyBy(this._map.getZoomScale(this._map.getZoom())),{blink:!0}),this._map.addLayer(this._cursorMarker)}else this._cursorMarker&&(this._map.removeLayer(this._cursorMarker),this._isCursorOverlayVisible=!1)},_onUpdateViewCursor:function(t){if("object"==typeof this._viewCursors[t]&&"object"==typeof this._viewCursors[t].bounds){var e=s.bounds(this._map.latLngToLayerPoint(this._viewCursors[t].bounds.getSouthWest()),this._map.latLngToLayerPoint(this._viewCursors[t].bounds.getNorthEast())),i=this._viewCursors[t].bounds.getNorthWest(),n=this._viewCursors[t].marker,o=this._viewCursors[t].visible,a=this._viewCursors[t].part;if(this._map.isViewReadOnly(t)||!o||this._isEmptyRectangle(this._viewCursors[t].bounds)||"text"!==this._docType&&this._selectedPart!==a)n&&this._viewLayerGroup.removeLayer(n);else{if(n)n.setLatLng(i,e.getSize().multiplyBy(this._map.getZoomScale(this._map.getZoom())));else{var r={color:s.LOUtil.rgbToHex(this._map.getViewColor(t)),blink:!1,header:!0,headerTimeout:3e3,zIndex:t,headerName:this._map.getViewName(t)};n=s.cursor(i,e.getSize().multiplyBy(this._map.getZoomScale(this._map.getZoom())),r),this._viewCursors[t].marker=n}n.setOpacity(this._map.hasLayer(this._cursorMarker)&&this._cursorMarker.getLatLng().equals(n.getLatLng())?0:1),this._viewLayerGroup.addLayer(n)}}},goToViewCursor:function(t){if(t===this._viewId)return void this._onUpdateCursor();if(this._viewCursors[t]&&this._viewCursors[t].visible&&!this._isEmptyRectangle(this._viewCursors[t].bounds)){if(!this._map.getBounds().contains(this._viewCursors[t].bounds)){var e=this._viewCursors[t].bounds.getNorthWest(),i=this._map.project(e);i=i.subtract(this._map.getSize().divideBy(2)),i.x=Math.round(i.x<0?0:i.x),i.y=Math.round(i.y<0?0:i.y),this._map.fire("scrollto",{x:i.x,y:i.y})}this._viewCursors[t].marker.showCursorHeader()}},_onUpdateTextViewSelection:function(t){t=parseInt(t);var e=this._viewSelections[t].polygons,i=this._viewSelections[t].selection,n=this._viewSelections[t].part;!e||"text"!==this._docType&&this._selectedPart!==n?i&&this._viewLayerGroup.removeLayer(i):(i&&this._viewLayerGroup.removeLayer(i),i=new s.Polygon(e,{pointerEvents:"none",fillColor:s.LOUtil.rgbToHex(this._map.getViewColor(t)),fillOpacity:.25,weight:2,opacity:.25}),this._viewSelections[t].selection=i,this._viewLayerGroup.addLayer(i))},_onUpdateGraphicViewSelection:function(t){var e=this._graphicViewMarkers[t].bounds,i=this._graphicViewMarkers[t].marker,n=this._graphicViewMarkers[t].part;if(this._isEmptyRectangle(e)||"text"!==this._docType&&this._selectedPart!==n)i&&this._viewLayerGroup.removeLayer(i);else{if(i)i.setBounds(e);else{var o=s.LOUtil.rgbToHex(this._map.getViewColor(t));i=s.rectangle(e,{pointerEvents:"auto",fill:!1,color:o}),i.bindPopup(this._map.getViewName(t),{autoClose:!1,autoPan:!1,backgroundColor:o,color:"white",closeButton:!1}),this._graphicViewMarkers[t].marker=i}this._viewLayerGroup.addLayer(i)}},eachView:function(t,e,i,n){for(var o in t)e.call(i,n?t[o]:o)},_onGraphicEdit:function(t){if(t.handle){var e=this._latLngToTwips(t.handle.getLatLng());"editstart"===t.type?(this._graphicMarker.isDragged=!0,this._postSelectGraphicEvent("start",Math.min(e.x,this._graphicSelectionTwips.max.x-1),Math.min(e.y,this._graphicSelectionTwips.max.y-1))):"editend"===t.type&&(this._postSelectGraphicEvent("end",e.x,e.y),this._graphicMarker.isDragged=!1)}},_onSelectionHandleDrag:function(t){if("drag"===t.type){t.target.isDragged=!0;var e=t.target._icon.getBoundingClientRect(),i=s.point(e.left,e.top),n=s.point(t.originalEvent.pageX,t.originalEvent.pageY).subtract(t.target.dragging._draggable.startOffset);if(!n.equals(i)){var o=n.subtract(i);t.target.dragging._draggable._startPoint=t.target.dragging._draggable._startPoint.add(o),t.target.dragging._draggable._startPos=t.target.dragging._draggable._startPos.add(o),t.target.dragging._draggable._newPos=t.target.dragging._draggable._newPos.add(o),t.target.dragging._draggable._updatePosition()}var a=new s.Point(n.x-this._map._container.getBoundingClientRect().left,n.y-this._map._container.getBoundingClientRect().top);a=a.add(t.target.dragging._draggable.startOffset),this._map.fire("handleautoscroll",{pos:a,map:this._map})}"dragend"===t.type&&(t.target.isDragged=!1,this._textArea.focus(),this._map.fire("scrollvelocity",{vx:0,vy:0}));var r=this._latLngToTwips(t.target.getLatLng());this._selectionHandles.start===t.target?this._postSelectTextEvent("start",r.x,r.y):this._selectionHandles.end===t.target&&this._postSelectTextEvent("end",r.x,r.y)},_onUpdateGraphicSelection:function(){if(this._graphicSelection&&!this._isEmptyRectangle(this._graphicSelection)){if(this._graphicMarker&&(this._graphicMarker.off("editstart editend",this._onGraphicEdit,this),this._map.removeLayer(this._graphicMarker)),"edit"!==this._map._permission)return;if(this._graphicMarker=s.rectangle(this._graphicSelection,{pointerEvents:"none",fill:!1}),this._visibleCursor=this._visibleCursorOnLostFocus=this._graphicMarker._bounds,!this._graphicMarker)return void this._map.fire("error",{msg:"Graphic marker initialization",cmd:"marker",kind:"failed",id:1});this._graphicMarker.editing.enable(),this._graphicMarker.on("editstart editend",this._onGraphicEdit,this),this._map.addLayer(this._graphicMarker)}else this._graphicMarker&&(this._graphicMarker.off("editstart editend",this._onGraphicEdit,this),this._map.removeLayer(this._graphicMarker),this._graphicMarker.isDragged=!1)},_onUpdateCellCursor:function(t,e,i){if(this._cellCursor&&!this._isEmptyRectangle(this._cellCursor)){var n=this._map.getBounds();if(!n.contains(this._cellCursor)&&!this._cellCursorXY.equals(this._prevCellCursorXY)){var o=0,a=0;if(i){var r=(n.getNorth()-n.getSouth())/2,l=this._cellCursorOnPgUp?this._cellCursorOnPgUp:this._cellCursorOnPgDn;a=this._cellCursor.getNorth()-l.getNorth(),this._cellCursor.getNorth()>n.getNorth()+a?a=this._cellCursor.getNorth()-n.getNorth()+r:this._cellCursor.getSouth()<n.getSouth()+a&&(a=this._cellCursor.getNorth()-n.getNorth()+r)}else if(0!==t||0!=e){var h=Math.abs(this._cellCursor.getEast()-this._cellCursor.getWest())/4,d=Math.abs(this._cellCursor.getSouth()-this._cellCursor.getNorth())/4;this._cellCursor.getWest()<n.getWest()?o=this._cellCursor.getWest()-n.getWest()-h:this._cellCursor.getEast()>n.getEast()&&(o=this._cellCursor.getEast()-n.getEast()+h),this._cellCursor.getNorth()>n.getNorth()?a=this._cellCursor.getNorth()-n.getNorth()+d:this._cellCursor.getSouth()<n.getSouth()&&(a=this._cellCursor.getSouth()-n.getSouth()-d)}if(0!==o||0!==a){var u=n.getCenter();u.lng+=o,u.lat+=a;var c=this._map.project(u);c=c.subtract(this._map.getSize().divideBy(2)),c.x=Math.round(c.x<0?0:c.x),c.y=Math.round(c.y<0?0:c.y),this._map.fire("scrollto",{x:c.x,y:c.y})}this._prevCellCursorXY=this._cellCursorXY}if(i&&(this._cellCursorOnPgUp=null,this._cellCursorOnPgDn=null),this._cellCursorMarker&&this._map.removeLayer(this._cellCursorMarker),this._cellCursorMarker=s.rectangle(this._cellCursor,{pointerEvents:"none",fill:!1,color:"#000000",weight:2}),!this._cellCursorMarker)return void this._map.fire("error",{msg:"Cell Cursor marker initialization",cmd:"cellCursor",kind:"failed",id:1});this._map.addLayer(this._cellCursorMarker)}else this._cellCursorMarker&&this._map.removeLayer(this._cellCursorMarker)},_onUpdateTextSelection:function(){var t,e;for(var i in this._selectionHandles)"start"===i?t=this._selectionHandles[i]:"end"===i&&(e=this._selectionHandles[i]);if(0!==this._selections.getLayers().length||t.isDragged||e.isDragged){if(!t||!e||this._isEmptyRectangle(this._textSelectionStart)||this._isEmptyRectangle(this._textSelectionEnd))return;var n=this._map.project(this._textSelectionStart.getSouthWest()),o=this._map.project(this._textSelectionEnd.getSouthWest()),a=this._map.project(t.getLatLng());if(a.distanceTo(o)<a.distanceTo(n)&&t._icon&&e._icon){s.DomUtil.removeClass(t._icon,"leaflet-selection-marker-start"),s.DomUtil.removeClass(e._icon,"leaflet-selection-marker-end"),s.DomUtil.addClass(t._icon,"leaflet-selection-marker-end"),s.DomUtil.addClass(e._icon,"leaflet-selection-marker-start");var r=t;t=e,e=r}else t._icon&&e._icon&&(s.DomUtil.removeClass(t._icon,"leaflet-selection-marker-end"),s.DomUtil.removeClass(e._icon,"leaflet-selection-marker-start"),s.DomUtil.addClass(t._icon,"leaflet-selection-marker-start"),s.DomUtil.addClass(e._icon,"leaflet-selection-marker-end"));if(!t.isDragged){var l=this._map.project(this._textSelectionStart.getSouthWest());l=l.subtract(new s.Point(0,2)),l=this._map.unproject(l),t.setLatLng(l),this._map.addLayer(t)}e.isDragged||(l=this._map.project(this._textSelectionEnd.getSouthEast()),l=l.subtract(new s.Point(0,2)),l=this._map.unproject(l),e.setLatLng(l),this._map.addLayer(e))}else{this._textSelectionStart=null,this._textSelectionEnd=null;for(i in this._selectionHandles)this._map.removeLayer(this._selectionHandles[i]),this._selectionHandles[i].isDragged=!1}},_onCopy:function(t){t=t.originalEvent,t.preventDefault(),this._selectionTextContent&&(s.Compatibility.clipboardSet(t,this._selectionTextContent),this._selectionTextHash=this._selectionTextContent),this._map._socket.sendMessage("uno .uno:Copy")},_onCut:function(t){t=t.originalEvent,t.preventDefault(),this._selectionTextContent&&(s.Compatibility.clipboardSet(t,this._selectionTextContent),this._selectionTextHash=this._selectionTextContent),this._map._socket.sendMessage("uno .uno:Cut")},_onPaste:function(t){t=t.originalEvent,t.preventDefault();var e=s.Compatibility.clipboardGet(t);"false"!==e&&e&&e!==this._selectionTextHash?this._map._socket.sendMessage("paste mimetype=text/plain;charset=utf-8\n"+e):this._map._socket.sendMessage("uno .uno:Paste")},_onDragOver:function(t){t=t.originalEvent,t.preventDefault()},_onDrop:function(t){var e=t.latlng,i=this._map._docLayer,n=i._latLngToTwips(e),o=1,s=1,a=this._map.keyboard.modifier;this._postMouseEvent("buttondown",n.x,n.y,o,s,a),this._postMouseEvent("buttonup",n.x,n.y,o,s,a),t=t.originalEvent,t.preventDefault();for(var r=t.dataTransfer.types,l=!1,h=0;!l&&h<r.length;h++)"text/html"===r[h]&&(l=!0);var d=!1;for(h=0;!d&&h<r.length;h++){var u=r[h];if("text/html"===u)this._map._socket.sendMessage("paste mimetype=text/html\n"+t.dataTransfer.getData(u)),d=!0;else if("text/plain"!==u||l){if("Files"===u)for(var c=t.dataTransfer.files,_=0;_<c.length;++_){var p=c[_];if(p.type.match(/image.*/)){var m=new FileReader;m.onload=this._onFileLoadFunc(p),m.readAsArrayBuffer(p),d=!0}}}else this._map._socket.sendMessage("paste mimetype=text/plain;charset=utf-8\n"+t.dataTransfer.getData(u)),d=!0}},_onFileLoadFunc:function(t){var e=this._map._socket;return function(i){var n=new Blob(["paste mimetype="+t.type+"\n",i.target.result]);e.sendMessage(n)}},_onDragStart:function(){this._map.on("moveend",this._updateScrollOffset,this)},_onRequestLOKSession:function(){this._map._socket.sendMessage("requestloksession")},_fitWidthZoom:function(t,e){var i=t?t.newSize:this._map.getSize(),n=i.x*this._map.options.tileWidthTwips/this._tileSize;if(e=e?e:this._map.getZoom(),"spreadsheet"!==this._docType){var o=this._map.options.crs.scale(1);if(this._docWidthTwips>0){var s=n/this._docWidthTwips,a=this._map.getZoom()+Math.floor(Math.log(s)/Math.log(o));a=Math.max(1,a),a=Math.min(e,a),this._map.setZoom(a,{animate:!1})}}},_onCurrentPageUpdate:function(){var t=this._map.project(this._map.getCenter());if(this._partPageRectanglesPixels&&this._currentPage>=0&&!(this._currentPage>=this._partPageRectanglesPixels.length)&&!this._partPageRectanglesPixels[this._currentPage].contains(t))for(var e=0;e<this._partPageRectanglesPixels.length;e++)if(this._partPageRectanglesPixels[e].contains(t))return this._currentPage=e,void this._map.fire("pagenumberchanged",{currentPage:this._currentPage,pages:this._pages,docType:this._docType})},_onCellCursorShift:function(t){(this._cellCursorMarker||t)&&this._map._socket.sendMessage("commandvalues command=.uno:CellCursor?outputHeight="+this._tileWidthPx+"&outputWidth="+this._tileHeightPx+"&tileHeight="+this._tileWidthTwips+"&tileWidth="+this._tileHeightTwips)},_invalidatePreviews:function(){if(this._map._docPreviews&&this._previewInvalidations.length>0){for(var t={},e=0;e<this._previewInvalidations.length;e++){var i=this._previewInvalidations[e];for(var n in this._map._docPreviews){var o=this._map._docPreviews[n];if(o.index>=0&&"text"===this._docType)this._partPageRectanglesTwips.length>o.index&&i.intersects(this._partPageRectanglesTwips[o.index])&&(t[n]=!0);else if(o.index>=0)(o.index===this._selectedPart||o.index===this._prevSelectedPart&&this._prevSelectedPartNeedsUpdate)&&(o.index===this._prevSelectedPart&&(this._prevSelectedPartNeedsUpdate=!1),t[n]=!0);else{var a=new s.Bounds(new s.Point(o.tilePosX,o.tilePosY),new s.Point(o.tilePosX+o.tileWidth,o.tilePosY+o.tileHeight));(o.part===this._selectedPart||o.part===this._prevSelectedPart&&this._prevSelectedPartNeedsUpdate)&&i.intersects(a)&&(o.index===this._prevSelectedPart&&(this._prevSelectedPartNeedsUpdate=!1),t[n]=!0)}}}for(n in t)o=this._map._docPreviews[n],o.autoUpdate&&(o.index>=0?this._map.getPreview(o.id,o.index,o.maxWidth,o.maxHeight,{autoUpdate:!0,broadcast:!0}):this._map.getCustomPreview(o.id,o.part,o.width,o.height,o.tilePosX,o.tilePosY,o.tileWidth,o.tileHeight,{autoUpdate:!0}))}this._previewInvalidations=[]},_updateClientZoom:function(){this._clientZoom="tilepixelwidth="+this._tileWidthPx+" tilepixelheight="+this._tileHeightPx+" tiletwipwidth="+this._tileWidthTwips+" tiletwipheight="+this._tileHeightTwips},_invalidateClientVisibleArea:function(){if(this._debug){this._debugInfo.clearLayers();for(var t in this._tiles)this._tiles[t]._debugPopup=null,this._tiles[t]._debugTile=null}this._clientVisibleArea=!0},_debugGetTimeArray:function(){return{count:0,ms:0,best:Number.MAX_SAFE_INTEGER,worst:0,date:0}},_debugShowTileData:function(){this._debugData.loadCount.setPrefix("Total of requested tiles: "+this._debugInvalidateCount+", received: "+this._debugLoadCount+", cancelled: "+this._debugCancelledTiles)},_debugInit:function(){if(this._debugTiles={},this._debugInvalidBounds={},this._debugInvalidBoundsMessage={},this._debugTimeout(),this._debugId=0,this._debugCancelledTiles=0,this._debugLoadCount=0,this._debugInvalidateCount=0,this._debugRenderCount=0,!this._debugData){this._debugData={},this._debugDataNames=["tileCombine","fromKeyInputToInvalidate","ping","loadCount"];
for(var t=0;t<this._debugDataNames.length;t++)this._debugData[this._debugDataNames[t]]=s.control.attribution({prefix:"",position:"bottomleft"}).addTo(map);this._debugInfo=new s.LayerGroup,this._debugInfo2=new s.LayerGroup,this._debugAlwaysActive=new s.LayerGroup,this._debugTyper=new s.LayerGroup,map.addLayer(this._debugInfo),map.addLayer(this._debugInfo2);var e={"Tile overlays":this._debugInfo,"Screen overlays":this._debugInfo2,"Always active":this._debugAlwaysActive,Typing:this._debugTyper};s.control.layers({},e,{collapsed:!1}).addTo(map),this._map.on("layeradd",function(t){if(t.layer===this._debugAlwaysActive)map._debugAlwaysActive=!0;else if(t.layer===this._debugTyper)this._debugTypeTimeout();else if(t.layer===this._debugInfo2)for(var e=0;e<this._debugDataNames.length;e++)this._debugData[this._debugDataNames[e]].addTo(map)},this),map.on("layerremove",function(t){if(t.layer===this._debugAlwaysActive)map._debugAlwaysActive=!1;else if(t.layer===this._debugTyper)clearTimeout(this._debugTypeTimeoutId);else if(t.layer===this._debugInfo2)for(var e in this._debugData)this._debugData[e].remove()},this)}this._debugTimePING=this._debugGetTimeArray(),this._debugPINGQueue=[],this._debugTimeKeypress=this._debugGetTimeArray(),this._debugKeypressQueue=[],this._debugLorem="Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.",this._debugLorem+=" "+this._debugLorem+"\n",this._debugLoremPos=0},_debugSetTimes:function(t,e){return e<t.best&&(t.best=e),e>t.worst&&(t.worst=e),t.ms+=e,t.count++,"best: "+t.best+" ms, avg: "+Math.round(t.ms/t.count)+" ms, worst: "+t.worst+" ms, last: "+e+" ms"},_debugAddInvalidationRectangle:function(t,e,i){var n=+new Date,o=new s.LatLngBounds(this._twipsToLatLng(t,this._tileZoom),this._twipsToLatLng(e,this._tileZoom)),a=s.rectangle(o,{color:"red",weight:1,opacity:1,fillOpacity:.4,pointerEvents:"none"});this._debugInvalidBounds[this._debugId]=a,this._debugInvalidBoundsMessage[this._debugId]=i,this._debugId++,this._debugInfo.addLayer(a);var r=this._debugKeypressQueue.shift();if(r){var l=this._debugSetTimes(this._debugTimeKeypress,n-r);this._debugData.fromKeyInputToInvalidate.setPrefix("Elapsed time between key input and next invalidate: "+l)}this._debugPINGQueue.push(+new Date),this._map._socket.sendMessage("ping")},_debugAddInvalidationData:function(t){t._debugTile&&(t._debugTile.setStyle({fillOpacity:.5,fillColor:"blue"}),t._debugTime.date=+new Date,t._debugTile.date=+new Date,t._debugInvalidateCount++,this._debugInvalidateCount++)},_debugAddInvalidationMessage:function(t){this._debugInvalidBoundsMessage[this._debugId-1]=t;for(var e="",i=this._debugId-1;i>this._debugId-6;i--)i>=0&&this._debugInvalidBoundsMessage[i]&&(e+=""+i+": "+this._debugInvalidBoundsMessage[i]+" <br>");this._debugData.tileCombine.setPrefix(e),this._debugShowTileData()},_debugTimeout:function(){if(this._debug){for(var t in this._debugInvalidBounds){var e=this._debugInvalidBounds[t],i=e.options.fillOpacity;.04>=i?t<this._debugId-5?(this._debugInfo.removeLayer(e),delete this._debugInvalidBounds[t],delete this._debugInvalidBoundsMessage[t]):e.setStyle({fillOpacity:0,opacity:1-(this._debugId-t)/7}):e.setStyle({fillOpacity:i-.04})}for(t in this._debugTiles){e=this._debugTiles[t];var n=e.options.fillColor;i=e.options.fillOpacity,"blue"===n&&i>=.04&&e.date+1e3<+new Date&&e.setStyle({fillOpacity:i-.04})}this._debugTimeoutId=setTimeout(function(){map._docLayer._debugTimeout()},50)}},_debugTypeTimeout:function(){var t=this._debugLorem.charCodeAt(this._debugLoremPos%this._debugLorem.length);this._debugKeypressQueue.push(+new Date),t==="\n".charCodeAt(0)?this._postKeyboardEvent("input",0,1280):this._postKeyboardEvent("input",this._debugLorem.charCodeAt(this._debugLoremPos%this._debugLorem.length),0),this._debugLoremPos++,this._debugTypeTimeoutId=setTimeout(function(){map._docLayer._debugTypeTimeout()},50)}}),s.tileLayer=function(t,e){return new s.TileLayer(t,e)},s.TileLayer.WMS=s.TileLayer.extend({defaultWmsParams:{service:"WMS",request:"GetMap",version:"1.1.1",layers:"",styles:"",format:"image/jpeg",transparent:!1},options:{crs:null,uppercase:!1},initialize:function(t,e){this._url=t;var i=s.extend({},this.defaultWmsParams);for(var n in e)n in this.options||(i[n]=e[n]);e=s.setOptions(this,e),i.width=i.height=e.tileSize*(e.detectRetina&&s.Browser.retina?2:1),this.wmsParams=i},onAdd:function(t){this._crs=this.options.crs||t.options.crs,this._wmsVersion=parseFloat(this.wmsParams.version);var e=this._wmsVersion>=1.3?"crs":"srs";this.wmsParams[e]=this._crs.code,s.TileLayer.prototype.onAdd.call(this,t)},getTileUrl:function(t){var e=this._tileCoordsToBounds(t),i=this._crs.project(e.getNorthWest()),n=this._crs.project(e.getSouthEast()),o=(this._wmsVersion>=1.3&&this._crs===s.CRS.EPSG4326?[n.y,i.x,i.y,n.x]:[i.x,n.y,n.x,i.y]).join(","),a=s.TileLayer.prototype.getTileUrl.call(this,t);return a+s.Util.getParamString(this.wmsParams,a,this.options.uppercase)+(this.options.uppercase?"&BBOX=":"&bbox=")+o},setParams:function(t,e){return s.extend(this.wmsParams,t),e||this.redraw(),this}}),s.tileLayer.wms=function(t,e){return new s.TileLayer.WMS(t,e)},s.WriterTileLayer=s.TileLayer.extend({newAnnotation:function(t){!t.anchorPos&&this._isCursorVisible&&(t.anchorPos=s.bounds(this._latLngToTwips(this._visibleCursor.getSouthWest()),this._latLngToTwips(this._visibleCursor.getNorthEast())),t.anchorPix=this._twipsToPixels(t.anchorPos.min)),t.anchorPos&&this._annotations.modify(this._annotations.add(t))},onRemove:function(t){t.off("updatemaxbounds",this._onUpdateMaxBounds,this)},onAdd:function(t){s.TileLayer.prototype.onAdd.call(this,t),this._annotations=s.annotationManager(t),t.on("updatemaxbounds",this._onUpdateMaxBounds,this)},onAnnotationModify:function(t){this._annotations.modify(t)},onAnnotationRemove:function(t){this._annotations.remove(t)},onAnnotationReply:function(t){this._annotations.reply(t)},onChangeAccept:function(t){this._annotations.acceptChange(t)},onChangeReject:function(t){this._annotations.rejectChange(t)},_onCommandValuesMsg:function(t){var e=JSON.parse(t.substring(t.indexOf("{")));e&&(e.comments?this._annotations.fill(e.comments):e.redlines?this._annotations.fillChanges(e.redlines):s.TileLayer.prototype._onCommandValuesMsg.call(this,t))},_onMessage:function(t,e){if(t.startsWith("comment:")){var i=JSON.parse(t.substring("comment:".length+1));this._annotations.onACKComment(i)}else t.startsWith("redlinetablemodified:")?(i=JSON.parse(t.substring("redlinetablemodified:".length+1)),this._annotations.onACKComment(i)):t.startsWith("redlinetablechanged:")?(i=JSON.parse(t.substring("redlinetablechanged:".length+1)),this._annotations.onACKComment(i)):s.TileLayer.prototype._onMessage.call(this,t,e)},_onInvalidateTilesMsg:function(t){var e=this._map._socket.parseServerCmd(t);if(e.x===i||e.y===i||e.part===i){var n=t.match(/\d+/g);e.x=parseInt(n[0]),e.y=parseInt(n[1]),e.width=parseInt(n[2]),e.height=parseInt(n[3]),e.part=this._selectedPart}e.part=0;var o=new s.Point(e.x,e.y),a=new s.Point(e.width,e.height),r=o.add(a);this._debug&&this._debugAddInvalidationRectangle(o,r,t);var l=new s.Bounds(o,r),h=this._latLngToTwips(this._map.getBounds().getNorthWest()),d=this._latLngToTwips(this._map.getBounds().getSouthEast()),u=new s.Bounds(h,d),c="",_="",p="",m=!1;for(var g in this._tiles){var f=this._tiles[g].coords,v=this._coordsToTwips(f),y=new s.Point(this._tileWidthTwips,this._tileHeightTwips),w=new s.Bounds(v,v.add(y));f.part===e.part&&l.intersects(w)&&(this._tiles[g]._invalidCount?this._tiles[g]._invalidCount+=1:this._tiles[g]._invalidCount=1,u.intersects(w)?(""!==c&&(c+=","),c+=v.x,""!==_&&(_+=","),_+=v.y,""!==p&&(p+=","),p+=this._tiles[g].oldWireId===i?"0":this._tiles[g].oldWireId,m=!0,this._debug&&this._debugAddInvalidationData(this._tiles[g])):(this._preFetchBorder=null,this._removeTile(g)))}if(m){var C="tilecombine part="+e.part+" width="+this._tileWidthPx+" height="+this._tileHeightPx+" tileposx="+c+" tileposy="+_+" tilewidth="+this._tileWidthTwips+" tileheight="+this._tileHeightTwips+" oldwid="+p;this._map._socket.sendMessage(C,""),this._debug&&this._debugAddInvalidationMessage(C)}for(g in this._tileCache){f=this._keyToTileCoords(g);var x=this._map.getZoomScale(f.z);o=new s.Point(this.options.tileWidthTwips/x*f.x,this.options.tileHeightTwips/x*f.y),r=o.add(new s.Point(this.options.tileWidthTwips/x,this.options.tileHeightTwips/x)),w=new s.Bounds(o,r),l.intersects(w)&&delete this._tileCache[g]}this._previewInvalidations.push(l),clearTimeout(this._previewInvalidator),this._previewInvalidator=setTimeout(s.bind(this._invalidatePreviews,this),this.options.previewInvalidationTimeout)},_onSetPartMsg:function(t){var e=parseInt(t.match(/\d+/g)[0]);e!==this._selectedPart&&(this._currentPage=e,this._map.fire("pagenumberchanged",{currentPage:e,pages:this._pages,docType:this._docType}))},_onStatusMsg:function(t){var e=this._map._socket.parseServerCmd(t);if(e.width&&e.height&&this._documentInfo!==t){var i=e.width!==this._docWidthTwips||e.height!==this._docHeightTwips;i&&(this._docWidthTwips=e.width,this._docHeightTwips=e.height,this._docType=e.type,this._viewId=parseInt(e.viewid),this._updateMaxBounds(!0)),this._documentInfo=t,this._selectedPart=0,this._parts=1,this._currentPage=e.selectedPart,this._pages=e.parts,this._map.fire("pagenumberchanged",{currentPage:this._currentPage,pages:this._pages,docType:this._docType}),this._resetPreFetching(!0),this._update()}},_onUpdateMaxBounds:function(t){this._updateMaxBounds(t.sizeChanged,t.extraSize)}}),s.ImpressTileLayer=s.TileLayer.extend({extraSize:s.point(290,0),newAnnotation:function(t){if(!this._draft){this.onAnnotationCancel(),this._draft=s.annotation(s.latLng(0,0),t,{noMenu:!0}).addTo(this._map),this._draft.edit();var e=this._map.latLngToLayerPoint(this._map.getCenter()),i=this._draft.getBounds(),n=e.subtract(s.point(i.max.x-i.min.x,(i.max.y-i.min.y)/2));this._draft.setLatLng(this._map.layerPointToLatLng(n)),this.layoutAnnotations(),this._draft.focus()}},beforeAdd:function(t){t.on("zoomend",this._onAnnotationZoom,this),t.on("updateparts",this.onUpdateParts,this),t.on("AnnotationCancel",this.onAnnotationCancel,this),t.on("AnnotationReply",this.onReplyClick,this),t.on("AnnotationSave",this.onAnnotationSave,this),t.on("AnnotationScrollUp",this.onAnnotationScrollUp,this),t.on("AnnotationScrollDown",this.onAnnotationScrollDown,this)},getAnnotation:function(t){var e=this._annotations[this._partHashes[this._selectedPart]];for(var i in e)if(e[i]._data.id===t)return e[i];return null},hideAnnotations:function(t){this._selectedAnnotation=i;var e=this._annotations[this._partHashes[t]];for(var n in e)e[n].hide()},hasAnnotations:function(t){var e=this._annotations[this._partHashes[t]];return e&&e.length>0},updateDocBounds:function(t,e){var i=this._annotations[this._partHashes[this._selectedPart]];i&&i.length===t&&this._map._docLayer._updateMaxBounds(!0,e)},onAdd:function(t){s.TileLayer.prototype.onAdd.call(this,t),this._annotations={},this._topAnnotation=[],this._topAnnotation[this._selectedPart]=0,this._selectedAnnotation=i,this._draft=null},onAnnotationCancel:function(){this._draft&&(this._map.removeLayer(this._draft),this._draft=null),this._map.focus(),this._selectedAnnotation=i,this.layoutAnnotations()},onAnnotationModify:function(t){this.onAnnotationCancel(),this._selectedAnnotation=t._data.id,t.edit(),this.scrollUntilAnnotationIsVisible(t),t.focus()},onAnnotationReply:function(t){this.onAnnotationCancel(),this._selectedAnnotation=t._data.id,t.reply(),this.scrollUntilAnnotationIsVisible(t),t.focus()},onAnnotationRemove:function(t){this.onAnnotationCancel();var e={Id:{type:"string",value:t}};this._map.sendUnoCommand(".uno:DeleteAnnotation",e),this._map.focus()},onAnnotationSave:function(t){var e;this._draft?(e={Text:{type:"string",value:this._draft._data.text}},this._map.sendUnoCommand(".uno:InsertAnnotation",e),this._map.removeLayer(this._draft),this._draft=null):(e={Id:{type:"string",value:t.annotation._data.id},Text:{type:"string",value:t.annotation._data.text}},this._map.sendUnoCommand(".uno:EditAnnotation",e),this._selectedAnnotation=i),this._map.focus()},_onAnnotationZoom:function(){this.onAnnotationCancel()},onReplyClick:function(t){var e={Id:{type:"string",value:t.annotation._data.id},Text:{type:"string",value:t.annotation._data.reply}};this._map.sendUnoCommand(".uno:ReplyToAnnotation",e),this._selectedAnnotation=i,this._map.focus()},onAnnotationScrollDown:function(){this._topAnnotation[this._selectedPart]=Math.min(++this._topAnnotation[this._selectedPart],this._annotations[this._partHashes[this._selectedPart]].length-1),this.onAnnotationCancel()},onAnnotationScrollUp:function(){0===this._topAnnotation[this._selectedPart]&&this._map.fire("scrollby",{x:0,y:-100}),this._topAnnotation[this._selectedPart]=Math.max(--this._topAnnotation[this._selectedPart],0),this.onAnnotationCancel()},onUpdateParts:function(){"number"==typeof this._prevSelectedPart&&(this.hideAnnotations(this._prevSelectedPart),this.hasAnnotations(this._selectedPart)&&(this._map._docLayer._updateMaxBounds(!0),this._topAnnotation[this._selectedPart]===i&&(this._topAnnotation[this._selectedPart]=0),this.onAnnotationCancel()))},clearAnnotations:function(){var t,e;for(var i in this._annotations)for(e=this._annotations[i];e.length>0;)t=e.pop(),t&&this._map.removeLayer(t);this._annotations={}},removeAnnotation:function(t){var e=this._annotations[this._partHashes[this._selectedPart]];for(var i in e)if(e[i]._data.id==t){this._map.removeLayer(e[i]),e.splice(i,1);break}},scrollUntilAnnotationIsVisible:function(t){var e=t.getBounds(),i=this._map.getBounds();this._map.layerPointToLatLng(e.getTopRight()).lat>i.getNorth()?this._topAnnotation[this._selectedPart]=Math.max(this._topAnnotation[this._selectedPart]-2,0):this._map.layerPointToLatLng(e.getBottomLeft()).lat<i.getSouth()&&(this._topAnnotation[this._selectedPart]=Math.min(this._topAnnotation[this._selectedPart]+2,this._annotations[this._partHashes[this._selectedPart]].length-1)),this.layoutAnnotations()},layoutAnnotations:function(){var t,e,i,n=this._annotations[this._partHashes[this._selectedPart]],o=this._map.latLngToLayerPoint(this._map.options.docBounds.getNorthEast()).add(s.point((this._selectedAnnotation?3:2)*this.options.marginX,this.options.marginY));for(var a in n)if(i=n[a],this._topAnnotation[this._selectedPart]||(this._topAnnotation[this._selectedPart]=0),t=this._topAnnotation[this._selectedPart],t>0&&parseInt(a)===t-1){i.setLatLng(this._map.layerPointToLatLng(s.point(0,-1e5))),i.show(),e=i.getBounds(),i.hide();var r=o.subtract(s.point(0,e.max.y-e.min.y));i.setLatLng(this._map.layerPointToLatLng(r)),i.show(),e=i.getBounds(),e.extend(s.point(e.max.x,e.max.y+this.options.marginY))}else if(a>=t)if(i._data.id===this._selectedAnnotation){e&&e.extend(s.point(e.max.x,e.max.y+2*this.options.marginY));var l=s.point(2*this.options.marginX,0);r=(e?e.getBottomLeft():o).subtract(l),i.setLatLng(this._map.layerPointToLatLng(r)),e=i.getBounds(),e=s.bounds(e.getBottomLeft().add(l),e.getTopRight().add(l)),e.extend(s.point(e.max.x,e.max.y+3*this.options.marginY))}else r=e?e.getBottomLeft():o,i.setLatLng(this._map.layerPointToLatLng(r)),i.show(),e=i.getBounds(),e.extend(s.point(e.max.x,e.max.y+this.options.marginY));else i.hide();e?this._scrollAnnotation||(this._scrollAnnotation=s.control.scroll.annotation(),this._scrollAnnotation.addTo(this._map)):this._scrollAnnotation&&(this._map.removeControl(this._scrollAnnotation),this._scrollAnnotation=null)},_onCommandValuesMsg:function(t){try{var e=JSON.parse(t.substring(t.indexOf("{")))}catch(i){e=null}if(e)if(e.comments){this.clearAnnotations();for(var n in e.comments){var o=e.comments[n];this._annotations[o.parthash]||(this._annotations[o.parthash]=[]),this._annotations[o.parthash].push(s.annotation(this._map.options.maxBounds.getSouthEast(),o).addTo(this._map))}this._topAnnotation||(this._topAnnotation=[]),this._topAnnotation[this._selectedPart]=0,this.hasAnnotations(this._selectedPart)&&this._map._docLayer._updateMaxBounds(!0),this.layoutAnnotations()}else s.TileLayer.prototype._onCommandValuesMsg.call(this,t)},_onMessage:function(t,e){if(t.startsWith("comment:")){var n=JSON.parse(t.substring("comment:".length+1));if("Add"===n.comment.action)this._annotations[n.comment.parthash]||(this._annotations[n.comment.parthash]=[]),this._annotations[n.comment.parthash].push(s.annotation(this._map.options.maxBounds.getSouthEast(),n.comment).addTo(this._map)),this._topAnnotation[this._selectedPart]=Math.min(this._topAnnotation[this._selectedPart],this._annotations[this._partHashes[this._selectedPart]].length-1),this.updateDocBounds(1,this.extraSize),this.layoutAnnotations();else if("Remove"===n.comment.action)this.removeAnnotation(n.comment.id),this._topAnnotation[this._selectedPart]=Math.min(this._topAnnotation[this._selectedPart],this._annotations[this._partHashes[this._selectedPart]].length-1),this.updateDocBounds(0),this.layoutAnnotations();else if("Modify"===n.comment.action){var o=this.getAnnotation(n.comment.id);o&&(o._data=n.comment,o.update(),this._selectedAnnotation=i,this.layoutAnnotations())}}else s.TileLayer.prototype._onMessage.call(this,t,e)},_onInvalidateTilesMsg:function(t){var e=this._map._socket.parseServerCmd(t);if(e.x===i||e.y===i||e.part===i){var n=t.match(/\d+/g);e.x=parseInt(n[0]),e.y=parseInt(n[1]),e.width=parseInt(n[2]),e.height=parseInt(n[3]),e.part=this._selectedPart}var o=new s.Point(e.x,e.y),a=new s.Point(e.width,e.height),r=o.add(a);this._debug&&this._debugAddInvalidationRectangle(o,r,t);var l=new s.Bounds(o,r),h=this._latLngToTwips(this._map.getBounds().getNorthWest()),d=this._latLngToTwips(this._map.getBounds().getSouthEast()),u=new s.Bounds(h,d),c="",_="",p="",m=!1;for(var g in this._tiles){var f=this._tiles[g].coords,v=this._coordsToTwips(f),y=new s.Point(this._tileWidthTwips,this._tileHeightTwips),w=new s.Bounds(v,v.add(y));f.part===e.part&&l.intersects(w)&&(this._tiles[g]._invalidCount?this._tiles[g]._invalidCount+=1:this._tiles[g]._invalidCount=1,u.intersects(w)?(""!==c&&(c+=","),c+=v.x,""!==_&&(_+=","),_+=v.y,""!==p&&(p+=","),p+=this._tiles[g].oldWireId===i?"0":this._tiles[g].oldWireId,m=!0,this._debug&&this._debugAddInvalidationData(this._tiles[g])):(this._preFetchBorder=null,this._removeTile(g)))}if(m&&e.part===this._selectedPart){var C="tilecombine part="+e.part+" width="+this._tileWidthPx+" height="+this._tileHeightPx+" tileposx="+c+" tileposy="+_+" tilewidth="+this._tileWidthTwips+" tileheight="+this._tileHeightTwips+" oldwid="+p;this._map._socket.sendMessage(C,""),this._debug&&this._debugAddInvalidationMessage(C)}for(g in this._tileCache)if(f=this._keyToTileCoords(g),f.part===e.part){var x=this._map.getZoomScale(f.z);o=new s.Point(this.options.tileWidthTwips/x*f.x,this.options.tileHeightTwips/x*f.y),r=o.add(new s.Point(this.options.tileWidthTwips/x,this.options.tileHeightTwips/x)),w=new s.Bounds(o,r),l.intersects(w)&&delete this._tileCache[g]}e.part===this._selectedPart&&e.part!==this._lastValidPart&&(this._map.fire("updatepart",{part:this._lastValidPart,docType:this._docType}),this._lastValidPart=e.part,this._map.fire("updatepart",{part:e.part,docType:this._docType})),this._previewInvalidations.push(l),clearTimeout(this._previewInvalidator),this._previewInvalidator=setTimeout(s.bind(this._invalidatePreviews,this),this.options.previewInvalidationTimeout)},_onSetPartMsg:function(t){var e=parseInt(t.match(/\d+/g)[0]);e!==this._selectedPart&&(this._map.setPart(e,!0),this._map.fire("setpart",{selectedPart:this._selectedPart}))},_onStatusMsg:function(t){var e=this._map._socket.parseServerCmd(t);if(e.width&&e.height&&this._documentInfo!==t){this._docWidthTwips=e.width,this._docHeightTwips=e.height,this._docType=e.type,"drawing"===this._docType&&s.DomUtil.addClass(s.DomUtil.get("presentation-controls-wrapper"),"drawing"),this._updateMaxBounds(!0),this._documentInfo=t,this._parts=e.parts,this._viewId=parseInt(e.viewid),this._selectedPart=e.selectedPart,this._resetPreFetching(!0),this._update(),this._preFetchPart!==this._selectedPart&&(this._preFetchPart=this._selectedPart,this._preFetchBorder=null);var i=t.match(/[^\r\n]+/g);this._partHashes=i.slice(i.length-this._parts),this._map.fire("updateparts",{selectedPart:this._selectedPart,parts:this._parts,docType:this._docType,partNames:this._partHashes})}},_updateMaxBounds:function(t,e){if(!e){var n=this._annotations&&this._partHashes&&this._selectedPart!==i?this._annotations[this._partHashes[this._selectedPart]]:[];e=n&&n.length>0?this.extraSize:null}s.GridLayer.prototype._updateMaxBounds.call(this,t,e,{panInside:!1})}}),s.CalcTileLayer=s.TileLayer.extend({STD_EXTRA_WIDTH:113,twipsToHMM:function(t){return(127*t+36)/72},newAnnotation:function(t){var e,i=this._annotations[this._selectedPart];for(var n in i)if(this._cellCursor.contains(i[n]._annotation._data.cellPos)){e=i[n];break}e||(t.cellPos=this._cellCursor,e=this.createAnnotation(t),e._annotation._tag=e,this.showAnnotation(e)),e.editAnnotation()},createAnnotation:function(t){var e=s.divOverlay(t.cellPos).bindAnnotation(s.annotation(s.latLng(0,0),t,"new"===t.id?{noMenu:!0}:{}));return e},beforeAdd:function(t){t._addZoomLimit(this),t.on("zoomend",this._onZoomRowColumns,this),t.on("updateparts",this._onUpdateParts,this),t.on("AnnotationCancel",this._onAnnotationCancel,this),t.on("AnnotationReply",this._onAnnotationReply,this),t.on("AnnotationSave",this._onAnnotationSave,this)},clearAnnotations:function(){for(var t in this._annotations)for(var e in this._annotations[t])this.hideAnnotation(this._annotations[t][e]);this._annotations={}},onAdd:function(t){s.TileLayer.prototype.onAdd.call(this,t),this._annotations={}},onAnnotationModify:function(t){t.edit(),t.focus()},onAnnotationRemove:function(t){var e={Id:{type:"string",value:t}},i=this._selectedPart;this._map.sendUnoCommand(".uno:DeleteNote",e),this._annotations[i][t].closePopup(),this._map.focus()},onAnnotationReply:function(t){t.reply(),t.focus()},showAnnotation:function(t){this._map.addLayer(t)},hideAnnotation:function(t){this._map.removeLayer(t)},showAnnotations:function(){var t=this._annotations[this._selectedPart];for(var e in t)this.showAnnotation(t[e])},hideAnnotations:function(t){var e=this._annotations[t];for(var i in e)this.hideAnnotation(e[i])},_onAnnotationCancel:function(t){"new"===t.annotation._data.id?this.hideAnnotation(t.annotation._tag):this._annotations[t.annotation._data.tab][t.annotation._data.id].closePopup(),this._map.focus()},_onAnnotationReply:function(t){var e={Id:{type:"string",value:t.annotation._data.id},Text:{type:"string",value:t.annotation._data.reply}};this._map.sendUnoCommand(".uno:ReplyComment",e),this._map.focus()},_onAnnotationSave:function(t){var e;"new"===t.annotation._data.id?(e={Text:{type:"string",value:t.annotation._data.text},Author:{type:"string",value:t.annotation._data.author}},this._map.sendUnoCommand(".uno:InsertAnnotation",e),this.hideAnnotation(t.annotation._tag)):(e={Id:{type:"string",value:t.annotation._data.id},Text:{type:"string",value:t.annotation._data.text},Author:{type:"string",value:this._map.getViewName(this._viewId)}},this._map.sendUnoCommand(".uno:EditAnnotation",e),this._annotations[t.annotation._data.tab][t.annotation._data.id].closePopup()),this._map.focus()},_onUpdateParts:function(t){"number"!=typeof this._prevSelectedPart||t.source||(this.hideAnnotations(this._prevSelectedPart),this.showAnnotations())},_onMessage:function(t,e){if(t.startsWith("comment:")){var n=JSON.parse(t.substring("comment:".length+1));if(n.comment.tab=parseInt(n.comment.tab),"Add"===n.comment.action)n.comment.cellPos=s.LOUtil.stringToBounds(n.comment.cellPos),n.comment.cellPos=s.latLngBounds(this._twipsToLatLng(n.comment.cellPos.getBottomLeft()),this._twipsToLatLng(n.comment.cellPos.getTopRight())),this._annotations[n.comment.tab]||(this._annotations[n.comment.tab]={}),this._annotations[n.comment.tab][n.comment.id]=this.createAnnotation(n.comment),n.comment.tab===this._selectedPart&&this.showAnnotation(this._annotations[n.comment.tab][n.comment.id]);else if("Remove"===n.comment.action){var o=this._annotations[n.comment.tab][n.comment.id];o&&(this.hideAnnotation(o),delete this._annotations[n.comment.tab][n.comment.id])}else if("Modify"===n.comment.action){var a=this._annotations[n.comment.tab][n.comment.id];n.comment.cellPos=s.LOUtil.stringToBounds(n.comment.cellPos),n.comment.cellPos=s.latLngBounds(this._twipsToLatLng(n.comment.cellPos.getBottomLeft()),this._twipsToLatLng(n.comment.cellPos.getTopRight())),a&&(a._annotation._data=n.comment,a.setLatLngBounds(n.comment.cellPos))}}else t.startsWith("invalidateheader: column")?(this._map.fire("updaterowcolumnheaders",{x:this._map._getTopLeftPoint().x,y:0,offset:{x:i,y:0}}),this._map._socket.sendMessage("commandvalues command=.uno:ViewAnnotationsPosition")):t.startsWith("invalidateheader: row")?(this._map.fire("updaterowcolumnheaders",{x:0,y:this._map._getTopLeftPoint().y,offset:{x:0,y:i}}),this._map._socket.sendMessage("commandvalues command=.uno:ViewAnnotationsPosition")):t.startsWith("invalidateheader: all")?(this._map.fire("updaterowcolumnheaders",{x:this._map._getTopLeftPoint().x,y:this._map._getTopLeftPoint().y,offset:{x:i,y:i}}),this._map._socket.sendMessage("commandvalues command=.uno:ViewAnnotationsPosition")):s.TileLayer.prototype._onMessage.call(this,t,e)},_onInvalidateTilesMsg:function(t){var e=this._map._socket.parseServerCmd(t);if(e.x===i||e.y===i||e.part===i){var n=t.match(/\d+/g);e.x=parseInt(n[0]),e.y=parseInt(n[1]),e.width=parseInt(n[2]),e.height=parseInt(n[3]),e.part=this._selectedPart}"text"===this._docType&&(e.part=0);var o=new s.Point(e.x,e.y),a=new s.Point(e.width,e.height),r=o.add(a);this._debug&&this._debugAddInvalidationRectangle(o,r,t);var l=new s.Bounds(o,r),h=this._latLngToTwips(this._map.getBounds().getNorthWest()),d=this._latLngToTwips(this._map.getBounds().getSouthEast()),u=new s.Bounds(h,d),c="",_="",p="",m=!1;for(var g in this._tiles){var f=this._tiles[g].coords,v=this._coordsToTwips(f),y=new s.Point(this._tileWidthTwips,this._tileHeightTwips),w=new s.Bounds(v,v.add(y));f.part===e.part&&l.intersects(w)&&(this._tiles[g]._invalidCount?this._tiles[g]._invalidCount+=1:this._tiles[g]._invalidCount=1,u.intersects(w)?(""!==c&&(c+=","),c+=v.x,""!==_&&(_+=","),_+=v.y,""!==p&&(p+=","),p+=this._tiles[g].oldWireId===i?"0":this._tiles[g].oldWireId,m=!0,this._debug&&this._debugAddInvalidationData(this._tiles[g])):(this._preFetchBorder=null,this._removeTile(g)))}if(m&&e.part===this._selectedPart){var C="tilecombine part="+e.part+" width="+this._tileWidthPx+" height="+this._tileHeightPx+" tileposx="+c+" tileposy="+_+" tilewidth="+this._tileWidthTwips+" tileheight="+this._tileHeightTwips+" oldwid="+p;this._map._socket.sendMessage(C,""),this._debug&&this._debugAddInvalidationMessage(C)}for(g in this._tileCache)if(f=this._keyToTileCoords(g),f.part===e.part){var x=this._map.getZoomScale(f.z);o=new s.Point(this.options.tileWidthTwips/x*f.x,this.options.tileHeightTwips/x*f.y),r=o.add(new s.Point(this.options.tileWidthTwips/x,this.options.tileHeightTwips/x)),w=new s.Bounds(o,r),l.intersects(w)&&delete this._tileCache[g]}this._previewInvalidations.push(l),clearTimeout(this._previewInvalidator),this._previewInvalidator=setTimeout(s.bind(this._invalidatePreviews,this),this.options.previewInvalidationTimeout)},_onSetPartMsg:function(t){var e=parseInt(t.match(/\d+/g)[0]);e!==this._selectedPart&&(this._map.setPart(e,!0),this._map.fire("setpart",{selectedPart:this._selectedPart}),this._map.fire("updaterowcolumnheaders"))},_onZoomRowColumns:function(){this._updateClientZoom(),this._clientZoom&&(this._map._socket.sendMessage("clientzoom "+this._clientZoom),this._clientZoom=null),this._map.fire("updaterowcolumnheaders")},_onUpdateCurrentHeader:function(){var t=-1,e=-1;this._cellCursorXY&&(t=this._cellCursorXY.x+1,e=this._cellCursorXY.y+1);var i=new s.Point(0,0);this._cellCursor&&!this._isEmptyRectangle(this._cellCursor)&&(i=this._cellCursorTwips.getSize()),this._map.fire("updatecurrentheader",{curX:t,curY:e,width:i.x,height:i.y})},_onUpdateSelectionHeader:function(){var t=this._selections.getLayers(),e=t.pop();if(0===t.length&&e&&1===e.getLatLngs().length){var i=this._latLngToTwips(e.getBounds().getNorthWest()).add([1,1]),n=this._latLngToTwips(e.getBounds().getSouthEast()).subtract([1,1]);this._map.fire("updateselectionheader",{start:i,end:n})}else this._map.fire("clearselectionheader")},_onStatusMsg:function(t){var e=this._map._socket.parseServerCmd(t);if(e.width&&e.height&&this._documentInfo!==t){this._docWidthTwips=e.width,this._docHeightTwips=e.height,this._docType=e.type,this._parts=e.parts,this._selectedPart=e.selectedPart,this._viewId=parseInt(e.viewid);var i=this._map.getSize(),n=this._docWidthTwips/this._tileWidthTwips*this._tileSize,o=this._docHeightTwips/this._tileHeightTwips*this._tileSize;if(n<i.x||o<i.y){n=Math.max(n,i.x),o=Math.max(o,i.y);var a=this._map.unproject(new s.Point(0,0)),r=this._map.unproject(new s.Point(n,o));this._map.setMaxBounds(new s.LatLngBounds(a,r)),this._docPixelSize={x:n,y:o},this._map.fire("docsize",{x:n,y:o})}else this._updateMaxBounds(!0);this._documentInfo=t;var l=t.match(/[^\r\n]+/g);this._partNames=l.slice(l.length-this._parts),this._map.fire("updateparts",{selectedPart:this._selectedPart,parts:this._parts,docType:this._docType,partNames:this._partNames,source:"status"}),this._resetPreFetching(!0),this._update(),this._preFetchPart!==this._selectedPart&&(this._preFetchPart=this._selectedPart,this._preFetchBorder=null)}},_onCommandValuesMsg:function(t){var e=t.indexOf("{");if(-1!==e){var i=JSON.parse(t.substring(e));if(i){var n;if(".uno:ViewRowColumnHeaders"===i.commandName)this._map.fire("viewrowcolumnheaders",{data:i,converter:this._twipsToPixels,context:this}),this._onUpdateCurrentHeader(),this._onUpdateSelectionHeader();else if(i.comments){this.clearAnnotations();for(var o in i.comments)n=i.comments[o],n.tab=parseInt(n.tab),n.cellPos=s.LOUtil.stringToBounds(n.cellPos),n.cellPos=s.latLngBounds(this._twipsToLatLng(n.cellPos.getBottomLeft()),this._twipsToLatLng(n.cellPos.getTopRight())),this._annotations[n.tab]||(this._annotations[n.tab]={}),this._annotations[n.tab][n.id]=this.createAnnotation(n);this.showAnnotations()}else if(i.commentsPos){this.hideAnnotations();for(o in i.commentsPos){n=i.commentsPos[o],n.tab=parseInt(n.tab),n.cellPos=s.LOUtil.stringToBounds(n.cellPos),n.cellPos=s.latLngBounds(this._twipsToLatLng(n.cellPos.getBottomLeft()),this._twipsToLatLng(n.cellPos.getTopRight()));var a=this._annotations[n.tab][n.id];a&&(a.setLatLngBounds(n.cellPos),a.mark&&a.mark.setLatLng(n.cellPos.getNorthEast()))}this.showAnnotations()}else s.TileLayer.prototype._onCommandValuesMsg.call(this,t)}}},_onTextSelectionMsg:function(t){s.TileLayer.prototype._onTextSelectionMsg.call(this,t),this._onUpdateSelectionHeader()},_onCellCursorMsg:function(t){s.TileLayer.prototype._onCellCursorMsg.call(this,t),this._onUpdateCurrentHeader()}}),s.ImageOverlay=s.Layer.extend({options:{opacity:1,alt:"",interactive:!1},initialize:function(t,e,i){this._url=t,this._bounds=s.latLngBounds(e),s.setOptions(this,i)},onAdd:function(){this._image||(this._initImage(),this.options.opacity<1&&this._updateOpacity()),this.options.interactive&&(s.DomUtil.addClass(this._image,"leaflet-interactive"),this.addInteractiveTarget(this._image)),this.getPane().appendChild(this._image),this._reset()},onRemove:function(){s.DomUtil.remove(this._image),this.options.interactive&&this.removeInteractiveTarget(this._image)},setOpacity:function(t){return this.options.opacity=t,this._image&&this._updateOpacity(),this},setStyle:function(t){return t.opacity&&this.setOpacity(t.opacity),this},bringToFront:function(){return this._map&&s.DomUtil.toFront(this._image),this},bringToBack:function(){return this._map&&s.DomUtil.toBack(this._image),this},setUrl:function(t){return this._url=t,this._image&&(this._image.src=t),this},getAttribution:function(){return this.options.attribution},getEvents:function(){var t={viewreset:this._reset};return this._zoomAnimated&&(t.zoomanim=this._animateZoom),
t},getBounds:function(){return this._bounds},_initImage:function(){var t=this._image=s.DomUtil.create("img","leaflet-image-layer "+(this._zoomAnimated?"leaflet-zoom-animated":""));t.onselectstart=s.Util.falseFn,t.onmousemove=s.Util.falseFn,t.onload=s.bind(this.fire,this,"load"),t.src=this._url,t.alt=this.options.alt},_animateZoom:function(t){var e=new s.Bounds(this._map._latLngToNewLayerPoint(this._bounds.getNorthWest(),t.zoom,t.center),this._map._latLngToNewLayerPoint(this._bounds.getSouthEast(),t.zoom,t.center)),i=e.min.add(e.getSize()._multiplyBy((1-1/t.scale)/2));s.DomUtil.setTransform(this._image,i,t.scale)},_reset:function(){var t=this._image,e=new s.Bounds(this._map.latLngToLayerPoint(this._bounds.getNorthWest()),this._map.latLngToLayerPoint(this._bounds.getSouthEast())),i=e.getSize();s.DomUtil.setPosition(t,e.min),t.style.width=i.x+"px",t.style.height=i.y+"px"},_updateOpacity:function(){s.DomUtil.setOpacity(this._image,this.options.opacity)}}),s.imageOverlay=function(t,e,i){return new s.ImageOverlay(t,e,i)},s.ProgressOverlay=s.Layer.extend({options:{spinnerSpeed:1.5},initialize:function(t,e){this._latlng=s.latLng(t),this._size=e,this._initLayout()},onAdd:function(){this._container&&(this.getPane().appendChild(this._container),this.update()),this._spinnerInterval=s.LOUtil.startSpinner(this._spinnerCanvas,this.options.spinnerSpeed),this._map.on("moveend",this.update,this)},onRemove:function(){this._container&&this.getPane().removeChild(this._container),this._spinnerInterval&&clearInterval(this._spinnerInterval)},update:function(){if(this._container&&this._map){var t=new s.Point(0,0),e=this._map.layerPointToContainerPoint(t),i=this._size.divideBy(2,!0),n=this._map.latLngToLayerPoint(this._latlng).round();this._setPos(n.subtract(e).subtract(i))}},_initLayout:function(){this._container=s.DomUtil.create("div","leaflet-progress-layer"),this._spinner=s.DomUtil.create("div","leaflet-progress-spinner",this._container),this._spinnerCanvas=s.DomUtil.create("canvas","leaflet-progress-spinner-canvas",this._spinner),this._label=s.DomUtil.create("div","leaflet-progress-label",this._container),this._progress=s.DomUtil.create("div","leaflet-progress",this._container),this._bar=s.DomUtil.create("span","",this._progress),this._value=s.DomUtil.create("span","",this._bar),s.DomUtil.setStyle(this._value,"line-height",this._size.y+"px"),this._container.style.width=this._size.x+"px",s.DomEvent.disableClickPropagation(this._progress).disableScrollPropagation(this._container)},_setPos:function(t){s.DomUtil.setPosition(this._container,t)},setLabel:function(t){this._label.innerHTML!==t&&(this._label.innerHTML=t)},setBar:function(t){t?this._progress.style.visibility="":this._progress.style.visibility="hidden"},setValue:function(t){this._bar.style.width=t+"%",this._value.innerHTML=t+"%"}}),s.progressOverlay=function(t,e){return new s.ProgressOverlay(t,e)},s.Icon=s.Class.extend({initialize:function(t){s.setOptions(this,t)},createIcon:function(t){return this._createIcon("icon",t)},createShadow:function(t){return this._createIcon("shadow",t)},_createIcon:function(t,e){var i=this._getIconUrl(t);if(!i){if("icon"===t)throw new Error("iconUrl not set in Icon options (see the docs).");return null}var n=this._createImg(i,e&&"IMG"===e.tagName?e:null);return this._setIconStyles(n,t),n},_setIconStyles:function(t,e){var i=this.options,n=s.point(i[e+"Size"]),o=s.point("shadow"===e&&i.shadowAnchor||i.iconAnchor||n&&n.divideBy(2,!0));t.className="leaflet-marker-"+e+" "+(i.className||""),o&&(t.style.marginLeft=-o.x+"px",t.style.marginTop=-o.y+"px"),n&&(t.style.width=n.x+"px",t.style.height=n.y+"px")},_createImg:function(t,i){return i=i||e.createElement("img"),i.src=t,i},_getIconUrl:function(t){return s.Browser.retina&&this.options[t+"RetinaUrl"]||this.options[t+"Url"]}}),s.icon=function(t){return new s.Icon(t)},s.Icon.Default=s.Icon.extend({options:{iconSize:[25,41],iconAnchor:[12,41],popupAnchor:[1,-34],shadowSize:[41,41]},_getIconUrl:function(t){var e=t+"Url";if(this.options[e])return this.options[e];var i=s.Icon.Default.imagePath;if(!i)throw new Error("Couldn't autodetect L.Icon.Default.imagePath, set it manually.");return i+"/marker-"+t+(s.Browser.retina&&"icon"===t?"-2x":"")+".png"}}),s.Icon.Default.imagePath=function(){var t,i,n,o,s=e.getElementsByTagName("script"),a=/[\/^]loleaflet/;for(t=0,i=s.length;i>t;t++)if(n=s[t].src,n.match(a))return o=n.substring(0,n.lastIndexOf("/")),(o?o+"/":"")+"images"}(),s.Marker=s.Layer.extend({options:{pane:"markerPane",icon:new s.Icon.Default,interactive:!0,draggable:!1,keyboard:!0,zIndexOffset:0,opacity:1,riseOffset:250},initialize:function(t,e){s.setOptions(this,e),this._latlng=s.latLng(t)},setDraggable:function(t){return this.dragging?void(t?this.dragging.enable():this.dragging.disable()):void(this.options.draggable=t)},onAdd:function(t){this._zoomAnimated=this._zoomAnimated&&t.options.markerZoomAnimation,this._initIcon(),this.update()},onRemove:function(){this.dragging&&this.dragging.enabled()&&this.dragging.removeHooks(),this._removeIcon(),this._removeShadow()},getEvents:function(){var t={viewreset:this.update};return this._zoomAnimated&&(t.zoomanim=this._animateZoom),t},getLatLng:function(){return this._latlng},setLatLng:function(t){var e=this._latlng;return this._latlng=s.latLng(t),this.update(),this.fire("move",{oldLatLng:e,latlng:this._latlng})},setZIndexOffset:function(t){return this.options.zIndexOffset=t,this.update()},setIcon:function(t){return this.options.icon=t,this._map&&(this._initIcon(),this.update()),this._popup&&this.bindPopup(this._popup,this._popup.options),this},update:function(){if(this._icon){var t=this._map.latLngToLayerPoint(this._latlng).round();this._setPos(t)}return this},_initIcon:function(){var t=this.options,e="leaflet-zoom-"+(this._zoomAnimated?"animated":"hide"),i=t.icon.createIcon(this._icon),n=!1;i!==this._icon&&(this._icon&&this._removeIcon(),n=!0,t.title&&(i.title=t.title),t.alt&&(i.alt=t.alt)),s.DomUtil.addClass(i,e),t.keyboard&&(i.tabIndex="0"),this._icon=i,this._initInteraction(),t.riseOnHover&&this.on({mouseover:this._bringToFront,mouseout:this._resetZIndex});var o=t.icon.createShadow(this._shadow),a=!1;o!==this._shadow&&(this._removeShadow(),a=!0),o&&s.DomUtil.addClass(o,e),this._shadow=o,t.opacity<1&&this._updateOpacity(),n&&this.getPane().appendChild(this._icon),o&&a&&this.getPane("shadowPane").appendChild(this._shadow)},_removeIcon:function(){this.options.riseOnHover&&this.off({mouseover:this._bringToFront,mouseout:this._resetZIndex}),s.DomUtil.remove(this._icon),this.removeInteractiveTarget(this._icon),this._icon=null},_removeShadow:function(){this._shadow&&s.DomUtil.remove(this._shadow),this._shadow=null},_setPos:function(t){s.DomUtil.setPosition(this._icon,t),this._shadow&&s.DomUtil.setPosition(this._shadow,t),this._zIndex=t.y+this.options.zIndexOffset,this._resetZIndex()},_updateZIndex:function(t){this._icon.style.zIndex=this._zIndex+t},_animateZoom:function(t){var e=this._map._latLngToNewLayerPoint(this._latlng,t.zoom,t.center).round();this._setPos(e)},_initInteraction:function(){if(this.options.interactive&&(s.DomUtil.addClass(this._icon,"leaflet-interactive"),this.addInteractiveTarget(this._icon),s.Handler.MarkerDrag)){var t=this.options.draggable;this.dragging&&(t=this.dragging.enabled(),this.dragging.disable()),this.dragging=new s.Handler.MarkerDrag(this),t&&this.dragging.enable()}},setOpacity:function(t){return this.options.opacity=t,this._map&&this._updateOpacity(),this},_updateOpacity:function(){var t=this.options.opacity;s.DomUtil.setOpacity(this._icon,t),this._shadow&&s.DomUtil.setOpacity(this._shadow,t)},_bringToFront:function(){this._updateZIndex(this.options.riseOffset)},_resetZIndex:function(){this._updateZIndex(0)}}),s.marker=function(t,e){return new s.Marker(t,e)},s.Cursor=s.Layer.extend({options:{opacity:1,zIndex:1e3},initialize:function(t,e,i){s.setOptions(this,i),this._latlng=s.latLng(t),this._size=s.point(e),this._initLayout()},onAdd:function(){this._container||this._initLayout(),this.update(),this.getPane().appendChild(this._container)},onRemove:function(){this._container&&this.getPane().removeChild(this._container)},getEvents:function(){var t={viewreset:this.update};return t},getLatLng:function(){return this._latlng},setLatLng:function(t,e){var i=this._latlng;return this._latlng=s.latLng(t),this._size=s.point(e),this.update(),this.fire("move",{oldLatLng:i,latlng:this._latlng})},update:function(){if(this._container&&this._map){var t=this._map.latLngToLayerPoint(this._latlng).round();this._setSize(),this._setPos(t)}return this},setOpacity:function(t){this._container&&s.DomUtil.setOpacity(this._cursor,t)},showCursorHeader:function(){this._cursorHeader&&(s.DomUtil.setStyle(this._cursorHeader,"visibility","visible"),clearTimeout(this._blinkTimeout),this._blinkTimeout=setTimeout(s.bind(function(){s.DomUtil.setStyle(this._cursorHeader,"visibility","hidden")},this),this.options.headerTimeout))},_initLayout:function(){this._container=s.DomUtil.create("div","leaflet-cursor-container"),this.options.header&&(this._cursorHeader=s.DomUtil.create("div","leaflet-cursor-header",this._container),this._cursorHeader.innerHTML=this.options.headerName,clearTimeout(this._blinkTimeout),this._blinkTimeout=setTimeout(s.bind(function(){s.DomUtil.setStyle(this._cursorHeader,"visibility","hidden")},this),this.options.headerTimeout)),this._cursor=s.DomUtil.create("div","leaflet-cursor",this._container),this.options.blink&&s.DomUtil.addClass(this._cursor,"blinking-cursor"),this.options.color&&(s.DomUtil.setStyle(this._cursorHeader,"background",this.options.color),s.DomUtil.setStyle(this._cursor,"background",this.options.color)),s.DomEvent.disableClickPropagation(this._cursor).disableScrollPropagation(this._container)},_setPos:function(t){s.DomUtil.setPosition(this._container,t),this._container.style.zIndex=this.options.zIndex},_setSize:function(){this._cursor.style.height=this._size.y+"px",this._container.style.top="-"+(this._container.clientHeight-this._size.y-2)/2+"px"}}),s.cursor=function(t,e,i){return new s.Cursor(t,e,i)},s.Cursor.getCursorURL=function(t){var i,n,o,s,a=e.getElementsByTagName("script"),r=/[\/^]leaflet[\-\._]?([\w\-\._]*)\.js\??/;for(i=0,n=a.length;n>i;i++)if(o=a[i].src,o.match(r))return s=o.split(r)[0],(s?s+"/":"")+t},s.Cursor.hotSpot={fill:{x:7,y:16}},s.Cursor.customCursors=["fill"],s.Cursor.isCustomCursor=function(t){return-1!==s.Cursor.customCursors.indexOf(t)},s.Cursor.getCustomCursor=function(t){var e;if(s.Cursor.isCustomCursor(t)){var i=s.Cursor.hotSpot[t]||{x:0,y:0};e=s.Browser.ie?"url("+s.Cursor.imagePath+"/"+t+".cur), default":"url("+s.Cursor.imagePath+"/"+t+".png) "+i.x+" "+i.y+", default"}return e},s.DivIcon=s.Icon.extend({options:{iconSize:[12,12],className:"leaflet-div-icon",html:!1},createIcon:function(t){var i=t&&"DIV"===t.tagName?t:e.createElement("div"),n=this.options;return s.DomEvent.on(i,"contextmenu",s.DomEvent.preventDefault),i.innerHTML=n.html!==!1?n.html:"",n.bgPos&&(i.style.backgroundPosition=-n.bgPos.x+"px "+-n.bgPos.y+"px"),this._setIconStyles(i,"icon"),i},createShadow:function(){return null}}),s.divIcon=function(t){return new s.DivIcon(t)},s.Map.mergeOptions({closePopupOnClick:!0}),s.Popup=s.Layer.extend({options:{pane:"popupPane",minWidth:50,maxWidth:300,offset:[0,7],autoPan:!0,autoPanPadding:[5,5],closeButton:!0,autoClose:!0,zoomAnimation:!0},initialize:function(t,e){s.setOptions(this,t),this._source=e},onAdd:function(t){this._zoomAnimated=this._zoomAnimated&&this.options.zoomAnimation,this._container||this._initLayout(),t._fadeAnimated&&s.DomUtil.setOpacity(this._container,0),clearTimeout(this._removeTimeout),this.getPane().appendChild(this._container),this.update(),t._fadeAnimated&&s.DomUtil.setOpacity(this._container,1),t.fire("popupopen",{popup:this}),this._source&&this._source.fire("popupopen",{popup:this},!0)},openOn:function(t){return t.openPopup(this),this},onRemove:function(t){t._fadeAnimated?(s.DomUtil.setOpacity(this._container,0),this._removeTimeout=setTimeout(s.bind(s.DomUtil.remove,s.DomUtil,this._container),200)):s.DomUtil.remove(this._container),t.fire("popupclose",{popup:this}),this._source&&this._source.fire("popupclose",{popup:this},!0)},getLatLng:function(){return this._latlng},setLatLng:function(t){return this._latlng=s.latLng(t),this._map&&(this._updatePosition(),this._adjustPan()),this},getContent:function(){return this._content},setContent:function(t){return this._content=t,this.update(),this},update:function(){this._map&&(this._container.style.visibility="hidden",this._updateContent(),this._updateLayout(),this._updatePosition(),this._container.style.visibility="",this._adjustPan())},getEvents:function(){var t={viewreset:this._updatePosition},e=this.options;return this._zoomAnimated&&(t.zoomanim=this._animateZoom),("closeOnClick"in e?e.closeOnClick:this._map.options.closePopupOnClick)&&(t.preclick=this._close),e.keepInView&&(t.moveend=this._adjustPan),t},isOpen:function(){return!!this._map&&this._map.hasLayer(this)},_close:function(){this._map&&this._map.closePopup(this)},_initLayout:function(){var t="leaflet-popup",e=this._container=s.DomUtil.create("div",t+" "+(this.options.className||"")+" leaflet-zoom-"+(this._zoomAnimated?"animated":"hide"));if(this.options.closeButton){var i=this._closeButton=s.DomUtil.create("a",t+"-close-button",e);i.href="#close",i.innerHTML="&#215;",s.DomEvent.on(i,"click",this._onCloseButtonClick,this)}var n=this._wrapper=s.DomUtil.create("div",t+"-content-wrapper",e);this._contentNode=s.DomUtil.create("div",t+"-content",n),s.DomEvent.disableClickPropagation(n).disableScrollPropagation(this._contentNode).on(n,"contextmenu",s.DomEvent.stopPropagation),this._tipContainer=s.DomUtil.create("div",t+"-tip-container",e),this._tip=s.DomUtil.create("div",t+"-tip",this._tipContainer),this.options.backgroundColor&&(this._tip.style["background-color"]=this._wrapper.style["background-color"]=this.options.backgroundColor),this.options.color&&(this._wrapper.style.color=this.options.color)},_updateContent:function(){if(this._content){var t=this._contentNode;if("string"==typeof this._content)t.innerHTML=this._content;else{for(;t.hasChildNodes();)t.removeChild(t.firstChild);t.appendChild(this._content)}this.fire("contentupdate")}},_updateLayout:function(){var t=this._contentNode,e=t.style;e.width="",e.whiteSpace="nowrap";var i=t.offsetWidth;i=Math.min(i,this.options.maxWidth),i=Math.max(i,this.options.minWidth),e.width=i+1+"px",e.whiteSpace="",e.height="";var n=t.offsetHeight,o=this.options.maxHeight,a="leaflet-popup-scrolled";o&&n>o?(e.height=o+"px",s.DomUtil.addClass(t,a)):s.DomUtil.removeClass(t,a),this._containerWidth=this._container.offsetWidth},_updatePosition:function(){if(this._map){var t=this._map.latLngToLayerPoint(this._latlng),e=s.point(this.options.offset);this._zoomAnimated?s.DomUtil.setPosition(this._container,t):e=e.add(t);var i=this._containerBottom=-e.y,n=this._containerLeft=-Math.round(this._containerWidth/2)+e.x;this._container.style.bottom=i+"px",this._container.style.left=n+"px"}},_animateZoom:function(t){var e=this._map._latLngToNewLayerPoint(this._latlng,t.zoom,t.center);s.DomUtil.setPosition(this._container,e)},_adjustPan:function(){if(this.options.autoPan){var t=this._map,e=this._container.offsetHeight,i=this._containerWidth,n=new s.Point(this._containerLeft,-e-this._containerBottom);this._zoomAnimated&&n._add(s.DomUtil.getPosition(this._container));var o=t.layerPointToContainerPoint(n),a=s.point(this.options.autoPanPadding),r=s.point(this.options.autoPanPaddingTopLeft||a),l=s.point(this.options.autoPanPaddingBottomRight||a),h=t.getSize(),d=0,u=0;o.x+i+l.x>h.x&&(d=o.x+i-h.x+l.x),o.x-d-r.x<0&&(d=o.x-r.x),o.y+e+l.y>h.y&&(u=o.y+e-h.y+l.y),o.y-u-r.y<0&&(u=o.y-r.y),(d||u)&&t.fire("autopanstart").panBy([d,u])}},_onCloseButtonClick:function(t){this._close(),s.DomEvent.stop(t)}}),s.popup=function(t,e){return new s.Popup(t,e)},s.Map.include({openPopup:function(t,e,i){if(!(t instanceof s.Popup)){var n=t;t=new s.Popup(i).setContent(n)}return e&&t.setLatLng(e),this.hasLayer(t)?this:(this._popup&&this._popup.options.autoClose&&this.closePopup(),this._popup=t,this.addLayer(t))},closePopup:function(t){return t&&t!==this._popup||(t=this._popup,this._popup=null),t&&this.removeLayer(t),this}}),s.Layer.include({bindPopup:function(t,e){return t instanceof s.Popup?(s.setOptions(t,e),this._popup=t,t._source=this):((!this._popup||e)&&(this._popup=new s.Popup(e,this)),this._popup.setContent(t)),this._popupHandlersAdded||(this.on({click:this._openPopup,remove:this.closePopup,move:this._movePopup}),this._popupHandlersAdded=!0),this},unbindPopup:function(){return this._popup&&(this.off({click:this._openPopup,remove:this.closePopup,move:this._movePopup}),this._popupHandlersAdded=!1,this._popup=null),this},openPopup:function(t){return this._popup&&this._map&&this._map.openPopup(this._popup,t||this._latlng||this.getCenter()),this},closePopup:function(){return this._popup&&this._popup._close(),this},togglePopup:function(){return this._popup&&(this._popup._map?this.closePopup():this.openPopup()),this},setPopupContent:function(t){return this._popup&&this._popup.setContent(t),this},getPopup:function(){return this._popup},_openPopup:function(t){this._map.openPopup(this._popup,t.latlng)},_movePopup:function(t){this._popup.setLatLng(t.latlng)}}),s.Marker.include({bindPopup:function(t,e){var i=s.point(this.options.icon.options.popupAnchor||[0,0]).add(s.Popup.prototype.options.offset);return e=s.extend({offset:i},e),s.Layer.prototype.bindPopup.call(this,t,e)},_openPopup:s.Layer.prototype.togglePopup}),s.LayerGroup=s.Layer.extend({initialize:function(t){this._layers={};var e,i;if(t)for(e=0,i=t.length;i>e;e++)this.addLayer(t[e])},addLayer:function(t){var e=this.getLayerId(t);return this._layers[e]=t,this._map&&this._map.addLayer(t),this},removeLayer:function(t){var e=t in this._layers?t:this.getLayerId(t);return this._map&&this._layers[e]&&this._map.removeLayer(this._layers[e]),delete this._layers[e],this},hasLayer:function(t){return!!t&&(t in this._layers||this.getLayerId(t)in this._layers)},clearLayers:function(){for(var t in this._layers)this.removeLayer(this._layers[t]);return this},invoke:function(t){var e,i,n=Array.prototype.slice.call(arguments,1);for(e in this._layers)i=this._layers[e],i[t]&&i[t].apply(i,n);return this},onAdd:function(t){for(var e in this._layers)t.addLayer(this._layers[e])},onRemove:function(t){for(var e in this._layers)t.removeLayer(this._layers[e])},eachLayer:function(t,e){for(var i in this._layers)t.call(e,this._layers[i]);return this},getLayer:function(t){return this._layers[t]},getLayers:function(){var t=[];for(var e in this._layers)t.push(this._layers[e]);return t},setZIndex:function(t){return this.invoke("setZIndex",t)},getLayerId:function(t){return s.stamp(t)}}),s.layerGroup=function(t){return new s.LayerGroup(t)},s.FeatureGroup=s.LayerGroup.extend({addLayer:function(t){return this.hasLayer(t)?this:(t.addEventParent(this),s.LayerGroup.prototype.addLayer.call(this,t),this._popupContent&&t.bindPopup&&t.bindPopup(this._popupContent,this._popupOptions),this.fire("layeradd",{layer:t}))},removeLayer:function(t){return this.hasLayer(t)?(t in this._layers&&(t=this._layers[t]),t.removeEventParent(this),s.LayerGroup.prototype.removeLayer.call(this,t),this._popupContent&&this.invoke("unbindPopup"),this.fire("layerremove",{layer:t})):this},bindPopup:function(t,e){return this._popupContent=t,this._popupOptions=e,this.invoke("bindPopup",t,e)},openPopup:function(t){for(var e in this._layers){this._layers[e].openPopup(t);break}return this},setStyle:function(t){return this.invoke("setStyle",t)},bringToFront:function(){return this.invoke("bringToFront")},bringToBack:function(){return this.invoke("bringToBack")},getBounds:function(){var t=new s.LatLngBounds;return this.eachLayer(function(e){t.extend(e.getBounds?e.getBounds():e.getLatLng())}),t}}),s.featureGroup=function(t){return new s.FeatureGroup(t)},s.Renderer=s.Layer.extend({options:{padding:0},initialize:function(t){s.setOptions(this,t),s.stamp(this)},onAdd:function(){this._container||(this._initContainer(),this._zoomAnimated&&s.DomUtil.addClass(this._container,"leaflet-zoom-animated")),this.getPane().appendChild(this._container),this._update()},onRemove:function(){s.DomUtil.remove(this._container)},getEvents:function(){var t={moveend:this._update};return this._zoomAnimated&&(t.zoomanim=this._animateZoom),t},_animateZoom:function(t){var e=t.origin.subtract(this._map._getCenterLayerPoint()),i=this._bounds.min.add(e.multiplyBy(1-t.scale)).add(t.offset).round();s.DomUtil.setTransform(this._container,i,t.scale)},_update:function(){var t=this.options.padding,e=this._map.getSize(),i=this._map.containerPointToLayerPoint(e.multiplyBy(-t)).round();this._bounds=new s.Bounds(i,i.add(e.multiplyBy(1+2*t)).round())}}),s.Map.include({getRenderer:function(t){var e=t.options.renderer||this._getPaneRenderer(t.options.pane)||this.options.renderer||this._renderer;return e||(e=this._renderer=s.SVG&&s.svg()||s.Canvas&&s.canvas()),this.hasLayer(e)||this.addLayer(e),e},_getPaneRenderer:function(t){if("overlayPane"===t||t===i)return!1;var e=this._paneRenderers[t];return e===i&&(e=s.SVG&&s.svg({pane:t})||s.Canvas&&s.canvas({pane:t}),this._paneRenderers[t]=e),e}}),s.Path=s.Layer.extend({options:{stroke:!0,color:"#3388ff",weight:3,opacity:1,lineCap:"round",lineJoin:"round",fillOpacity:.2,fillRule:"evenodd",interactive:!0},onAdd:function(){this._renderer=this._map.getRenderer(this),this._renderer._initPath(this),this._project(),this._update(),this._renderer._addPath(this)},onRemove:function(){this._renderer._removePath(this)},getEvents:function(){return{viewreset:this._project,moveend:this._update}},redraw:function(){return this._map&&this._renderer._updatePath(this),this},setStyle:function(t){return s.setOptions(this,t),this._renderer&&this._renderer._updateStyle(this),this},bringToFront:function(){return this._renderer&&this._renderer._bringToFront(this),this},bringToBack:function(){return this._renderer&&this._renderer._bringToBack(this),this},_clickTolerance:function(){return(this.options.stroke?this.options.weight/2:0)+(s.Browser.touch?10:0)}}),s.Path.include({bindPopup:function(t,e){return t instanceof s.Popup?this._popup=t:((!this._popup||e)&&(this._popup=new s.Popup(e,this)),this._popup.setContent(t)),this._popupHandlersAdded||(this.on({mouseover:this._openPopup,mouseout:this._delayClose,remove:this.closePopup,add:this.firstPopup}),this._popupHandlersAdded=!0),this},unbindPopup:function(){return this._popup&&(this._popup=null,this.off({mouseover:this._openPopup,mouseout:this._delayClose,remove:this.closePopup,add:this.firstPopup}),this._popupHandlersAdded=!1),this},firstPopup:function(){this._popup&&this._openPopup({latlng:this._bounds.getCenter()})},closePopup:function(){return this._popup&&this._popup._close(),this},_delayClose:function(){clearTimeout(this._timer),this._timer=setTimeout(s.bind(this.closePopup,this),3e3)},_openPopup:function(t){this._map.hasLayer(this._popup)||(this._popup.setLatLng(t.latlng),this._map.openPopup(this._popup),this._delayClose())}}),s.LineUtil={simplify:function(t,e){if(!e||!t.length)return t.slice();var i=e*e;return t=this._reducePoints(t,i),t=this._simplifyDP(t,i)},pointToSegmentDistance:function(t,e,i){return Math.sqrt(this._sqClosestPointOnSegment(t,e,i,!0))},closestPointOnSegment:function(t,e,i){return this._sqClosestPointOnSegment(t,e,i)},_simplifyDP:function(t,e){var n=t.length,o=typeof Uint8Array!=i+""?Uint8Array:Array,s=new o(n);s[0]=s[n-1]=1,this._simplifyDPStep(t,s,e,0,n-1);var a,r=[];for(a=0;n>a;a++)s[a]&&r.push(t[a]);return r},_simplifyDPStep:function(t,e,i,n,o){var s,a,r,l=0;for(a=n+1;o-1>=a;a++)r=this._sqClosestPointOnSegment(t[a],t[n],t[o],!0),r>l&&(s=a,l=r);l>i&&(e[s]=1,this._simplifyDPStep(t,e,i,n,s),this._simplifyDPStep(t,e,i,s,o))},_reducePoints:function(t,e){for(var i=[t[0]],n=1,o=0,s=t.length;s>n;n++)this._sqDist(t[n],t[o])>e&&(i.push(t[n]),o=n);return s-1>o&&i.push(t[s-1]),i},clipSegment:function(t,e,i,n,o){var s,a,r,l=n?this._lastCode:this._getBitCode(t,i),h=this._getBitCode(e,i);for(this._lastCode=h;;){if(!(l|h))return[t,e];if(l&h)return!1;s=l||h,a=this._getEdgeIntersection(t,e,s,i,o),r=this._getBitCode(a,i),s===l?(t=a,l=r):(e=a,h=r)}},_getEdgeIntersection:function(t,e,i,n,o){var a,r,l=e.x-t.x,h=e.y-t.y,d=n.min,u=n.max;return 8&i?(a=t.x+l*(u.y-t.y)/h,r=u.y):4&i?(a=t.x+l*(d.y-t.y)/h,r=d.y):2&i?(a=u.x,r=t.y+h*(u.x-t.x)/l):1&i&&(a=d.x,r=t.y+h*(d.x-t.x)/l),new s.Point(a,r,o)},_getBitCode:function(t,e){var i=0;return t.x<e.min.x?i|=1:t.x>e.max.x&&(i|=2),t.y<e.min.y?i|=4:t.y>e.max.y&&(i|=8),i},_sqDist:function(t,e){var i=e.x-t.x,n=e.y-t.y;return i*i+n*n},_sqClosestPointOnSegment:function(t,e,i,n){var o,a=e.x,r=e.y,l=i.x-a,h=i.y-r,d=l*l+h*h;return d>0&&(o=((t.x-a)*l+(t.y-r)*h)/d,o>1?(a=i.x,r=i.y):o>0&&(a+=l*o,r+=h*o)),l=t.x-a,h=t.y-r,n?l*l+h*h:new s.Point(a,r)}},s.Polyline=s.Path.extend({options:{smoothFactor:1},initialize:function(t,e){s.setOptions(this,e),this._setLatLngs(t)},getLatLngs:function(){return this._latlngs},setLatLngs:function(t){return this._setLatLngs(t),this.redraw()},addLatLng:function(t){return t=s.latLng(t),this._latlngs.push(t),this._bounds.extend(t),this.redraw()},spliceLatLngs:function(){var t=[].splice.apply(this._latlngs,arguments);return this._setLatLngs(this._latlngs),this.redraw(),t},closestLayerPoint:function(t){for(var e,i,n=1/0,o=null,a=s.LineUtil._sqClosestPointOnSegment,r=0,l=this._parts.length;l>r;r++)for(var h=this._parts[r],d=1,u=h.length;u>d;d++){e=h[d-1],i=h[d];var c=a(t,e,i,!0);n>c&&(n=c,o=a(t,e,i))}return o&&(o.distance=Math.sqrt(n)),o},getCenter:function(){var t,e,i,n,o,s,a,r=this._rings[0],l=r.length;for(t=0,e=0;l-1>t;t++)e+=r[t].distanceTo(r[t+1])/2;for(t=0,n=0;l-1>t;t++)if(o=r[t],s=r[t+1],i=o.distanceTo(s),n+=i,n>e)return a=(n-e)/i,this._map.layerPointToLatLng([s.x-a*(s.x-o.x),s.y-a*(s.y-o.y)])},getBounds:function(){return this._bounds},_setLatLngs:function(t){this._bounds=new s.LatLngBounds,this._latlngs=this._convertLatLngs(t)},_convertLatLngs:function(t){for(var e=[],i=this._flat(t),n=0,o=t.length;o>n;n++)i?(e[n]=s.latLng(t[n]),this._bounds.extend(e[n])):e[n]=this._convertLatLngs(t[n]);return e},_flat:function(t){return!s.Util.isArray(t[0])||"object"!=typeof t[0][0]},_project:function(){this._rings=[],this._projectLatlngs(this._latlngs,this._rings);var t=this._clickTolerance(),e=new s.Point(t,-t);this._latlngs.length&&(this._pxBounds=new s.Bounds(this._map.latLngToLayerPoint(this._bounds.getSouthWest())._subtract(e),this._map.latLngToLayerPoint(this._bounds.getNorthEast())._add(e)))},_projectLatlngs:function(t,e){var i,n,o=t[0]instanceof s.LatLng,a=t.length;if(o){for(n=[],i=0;a>i;i++)n[i]=this._map.latLngToLayerPoint(t[i]);e.push(n)}else for(i=0;a>i;i++)this._projectLatlngs(t[i],e)},_clipPoints:function(){if(this.options.noClip)return void(this._parts=this._rings);this._parts=[];var t,e,i,n,o,a,r,l=this._parts,h=this._renderer._bounds;for(t=0,i=0,n=this._rings.length;n>t;t++)for(r=this._rings[t],e=0,o=r.length;o-1>e;e++)a=s.LineUtil.clipSegment(r[e],r[e+1],h,e,!0),a&&(l[i]=l[i]||[],l[i].push(a[0]),(a[1]!==r[e+1]||e===o-2)&&(l[i].push(a[1]),i++))},_simplifyPoints:function(){for(var t=this._parts,e=this.options.smoothFactor,i=0,n=t.length;n>i;i++)t[i]=s.LineUtil.simplify(t[i],e)},_update:function(){this._map&&(this._clipPoints(),this._simplifyPoints(),this._updatePath())},_updatePath:function(){this._renderer._updatePoly(this)}}),s.polyline=function(t,e){return new s.Polyline(t,e)},s.PolyUtil={},s.PolyUtil.clipPolygon=function(t,e,i){var n,o,a,r,l,h,d,u,c,_=[1,4,2,8],p=s.LineUtil;for(o=0,d=t.length;d>o;o++)t[o]._code=p._getBitCode(t[o],e);for(r=0;4>r;r++){for(u=_[r],n=[],o=0,d=t.length,a=d-1;d>o;a=o++)l=t[o],h=t[a],l._code&u?h._code&u||(c=p._getEdgeIntersection(h,l,u,e,i),c._code=p._getBitCode(c,e),n.push(c)):(h._code&u&&(c=p._getEdgeIntersection(h,l,u,e,i),c._code=p._getBitCode(c,e),n.push(c)),n.push(l));t=n}return t},s.PolyUtil.rectanglesToPolygons=function(t,e){function i(t){var e=[];for(var i in t)t.hasOwnProperty(i)&&e.push(i);return e}function n(t,e){var i=t.match(/\d+/g);i[0]=parseInt(i[0]),i[1]=parseInt(i[1]);var n=e.match(/\d+/g);return n[0]=parseInt(n[0]),n[1]=parseInt(n[1]),i[0]<n[0]||i[0]===n[0]&&i[1]<n[1]?-1:i[0]===n[0]&&i[1]===n[1]?0:1}function o(t,e){var i=t.match(/\d+/g);i[0]=parseInt(i[0]),i[1]=parseInt(i[1]);var n=e.match(/\d+/g);return n[0]=parseInt(n[0]),n[1]=parseInt(n[1]),i[1]<n[1]||i[1]===n[1]&&i[0]<n[0]?-1:i[0]===n[0]&&i[1]===n[1]?0:1}for(var s=20,a=0;a<t.length-1;a++)for(var r=a+1;r<t.length;r++)for(var l=0;l<t[a].length;l++)for(var h=0;h<t[r].length;h++)Math.abs(t[a][l].x-t[r][h].x)<s&&(t[r][h].x=t[a][l].x),Math.abs(t[a][l].y-t[r][h].y)<s&&(t[r][h].y=t[a][l].y);var d={};for(a=0;a<t.length;a++)for(r=0;r<t[a].length;r++)d[t[a][r]]?delete d[t[a][r]]:d[t[a][r]]=t[a][r];var u=i(d).sort(n),c=i(d).sort(o),_={},p={},m=i(d).length;for(a=0;m>a;)for(var g=d[c[a]].y;m>a&&d[c[a]].y===g;)_[c[a]]=c[a+1],_[c[a+1]]=c[a],a+=2;for(a=0;m>a;)for(var f=d[u[a]].x;m>a&&d[u[a]].x===f;)p[u[a]]=u[a+1],p[u[a+1]]=u[a],a+=2;for(var v=[],y=i(_);y.length>0;){for(var w=[[y[0],0]];;){var C=w[w.length-1][0],x=w[w.length-1][1];if(0===x){var b=p[C];delete p[C],w.push([b,1])}else b=_[C],delete _[C],w.push([b,0]);if(w[w.length-1][0]===w[0][0]&&w[w.length-1][1]===w[0][1]){w.pop();break}}var P=[];for(a=0;a<w.length;a++)P.push(e._twipsToLatLng(d[w[a][0]])),delete _[w[a][0]],delete p[w[a][0]];P.push(e._twipsToLatLng(d[w[0][0]])),y=i(_),v.push(P)}return v},s.Polygon=s.Polyline.extend({options:{fill:!0},getCenter:function(){var t,e,i,n,o,s,a,r,l,h=this._rings[0];for(a=r=l=0,t=0,i=h.length,e=i-1;i>t;e=t++)n=h[t],o=h[e],s=n.y*o.x-o.y*n.x,r+=(n.x+o.x)*s,l+=(n.y+o.y)*s,a+=3*s;return this._map.layerPointToLatLng([r/a,l/a])},_convertLatLngs:function(t){var e=s.Polyline.prototype._convertLatLngs.call(this,t),i=e.length;return i>=2&&e[0]instanceof s.LatLng&&e[0].equals(e[i-1])&&e.pop(),e},_clipPoints:function(){if(this.options.noClip)return void(this._parts=this._rings);var t=this._renderer._bounds,e=this.options.weight,i=new s.Point(e,e);t=new s.Bounds(t.min.subtract(i),t.max.add(i)),this._parts=[];for(var n,o=0,a=this._rings.length;a>o;o++)n=s.PolyUtil.clipPolygon(this._rings[o],t,!0),n.length&&this._parts.push(n)},_updatePath:function(){this._renderer._updatePoly(this,!0)}}),s.polygon=function(t,e){return new s.Polygon(t,e)},s.Rectangle=s.Polygon.extend({initialize:function(t,e){s.Polygon.prototype.initialize.call(this,this._boundsToLatLngs(t),e)},setBounds:function(t){this.setLatLngs(this._boundsToLatLngs(t))},_boundsToLatLngs:function(t){return t=s.latLngBounds(t),[t.getSouthWest(),t.getNorthWest(),t.getNorthEast(),t.getSouthEast()]}}),s.rectangle=function(t,e){return new s.Rectangle(t,e)},s.CircleMarker=s.Path.extend({options:{fill:!0,radius:10},initialize:function(t,e){s.setOptions(this,e),this._latlng=s.latLng(t),this._radius=this.options.radius},setLatLng:function(t){return this._latlng=s.latLng(t),this.redraw(),this.fire("move",{latlng:this._latlng})},getLatLng:function(){return this._latlng},setRadius:function(t){return this.options.radius=this._radius=t,this.redraw()},getRadius:function(){return this._radius},setStyle:function(t){var e=t&&t.radius||this._radius;return s.Path.prototype.setStyle.call(this,t),this.setRadius(e),this},_project:function(){this._point=this._map.latLngToLayerPoint(this._latlng),this._updateBounds()},_updateBounds:function(){var t=this._radius,e=this._radiusY||t,i=this._clickTolerance(),n=[t+i,e+i];this._pxBounds=new s.Bounds(this._point.subtract(n),this._point.add(n))},_update:function(){this._map&&this._updatePath()},_updatePath:function(){this._renderer._updateCircle(this)},_empty:function(){return this._radius&&!this._renderer._bounds.intersects(this._pxBounds)}}),s.circleMarker=function(t,e){return new s.CircleMarker(t,e)},s.Circle=s.CircleMarker.extend({initialize:function(t,e,i){s.setOptions(this,i),this._latlng=s.latLng(t),this._mRadius=e},setRadius:function(t){return this._mRadius=t,this.redraw()},getRadius:function(){
return this._mRadius},getBounds:function(){var t=[this._radius,this._radiusY];return new s.LatLngBounds(this._map.layerPointToLatLng(this._point.subtract(t)),this._map.layerPointToLatLng(this._point.add(t)))},setStyle:s.Path.prototype.setStyle,_project:function(){var t=this._latlng.lng,e=this._latlng.lat,i=this._map,n=i.options.crs;if(n.distance===s.CRS.Earth.distance){var o=Math.PI/180,a=this._mRadius/s.CRS.Earth.R/o,r=i.project([e+a,t]),l=i.project([e-a,t]),h=r.add(l).divideBy(2),d=i.unproject(h).lat,u=Math.acos((Math.cos(a*o)-Math.sin(e*o)*Math.sin(d*o))/(Math.cos(e*o)*Math.cos(d*o)))/o;this._point=h.subtract(i.getPixelOrigin()),this._radius=isNaN(u)?0:Math.max(Math.round(h.x-i.project([d,t-u]).x),1),this._radiusY=Math.max(Math.round(h.y-r.y),1)}else{var c=n.unproject(n.project(this._latlng).subtract([this._mRadius,0]));this._point=i.latLngToLayerPoint(this._latlng),this._radius=this._point.x-i.latLngToLayerPoint(c).x}this._updateBounds()}}),s.circle=function(t,e,i){return new s.Circle(t,e,i)},s.SVG=s.Renderer.extend({_initContainer:function(){this._container=s.SVG.create("svg"),this._container.setAttribute("pointer-events","none")},_update:function(){if(!this._map._animatingZoom||!this._bounds){s.Renderer.prototype._update.call(this);var t=this._bounds,e=t.getSize(),i=this._container;s.DomUtil.setPosition(i,t.min),this._svgSize&&this._svgSize.equals(e)||(this._svgSize=e,i.setAttribute("width",e.x),i.setAttribute("height",e.y)),s.DomUtil.setPosition(i,t.min),i.setAttribute("viewBox",[t.min.x,t.min.y,e.x,e.y].join(" "))}},_initPath:function(t){var e=t._path=s.SVG.create("path");if(t.options.className&&s.DomUtil.addClass(e,t.options.className),t.options.interactive){s.DomUtil.addClass(e,"leaflet-interactive");for(var i=["mouseenter","mouseout"],n=0;n<i.length;n++)s.DomEvent.on(e,i[n],this._fireMouseEvent,this)}this._updateStyle(t)},_fireMouseEvent:function(t){if(this._map&&this.hasEventListeners(t.type)){var e=this._map,i=e.mouseEventToContainerPoint(t),n=e.containerPointToLayerPoint(i),o=e.layerPointToLatLng(n);this.fire(t.type,{latlng:o,layerPoint:n,containerPoint:i,originalEvent:t})}},_addPath:function(t){this._container.appendChild(t._path),t.addInteractiveTarget(t._path)},_removePath:function(t){s.DomUtil.remove(t._path),t.removeInteractiveTarget(t._path)},_updatePath:function(t){t._project(),t._update()},_updateStyle:function(t){var e=t._path,i=t.options;e&&(i.stroke?(e.setAttribute("stroke",i.color),e.setAttribute("stroke-opacity",i.opacity),e.setAttribute("stroke-width",i.weight),e.setAttribute("stroke-linecap",i.lineCap),e.setAttribute("stroke-linejoin",i.lineJoin),i.dashArray?e.setAttribute("stroke-dasharray",i.dashArray):e.removeAttribute("stroke-dasharray"),i.dashOffset?e.setAttribute("stroke-dashoffset",i.dashOffset):e.removeAttribute("stroke-dashoffset")):e.setAttribute("stroke","none"),i.fill?(e.setAttribute("fill",i.fillColor||i.color),e.setAttribute("fill-opacity",i.fillOpacity),e.setAttribute("fill-rule",i.fillRule||"evenodd")):e.setAttribute("fill","none"),e.setAttribute("pointer-events",i.pointerEvents||(i.interactive?"visiblePainted":"none")))},_updatePoly:function(t,e){this._setPath(t,s.SVG.pointsToPath(t._parts,e))},_updateCircle:function(t){var e=t._point,i=t._radius,n=t._radiusY||i,o="a"+i+","+n+" 0 1,0 ",s=t._empty()?"M0 0":"M"+(e.x-i)+","+e.y+o+2*i+",0 "+o+2*-i+",0 ";this._setPath(t,s)},_setPath:function(t,e){t._path.setAttribute("d",e)},_bringToFront:function(t){s.DomUtil.toFront(t._path)},_bringToBack:function(t){s.DomUtil.toBack(t._path)}}),s.extend(s.SVG,{create:function(t){return e.createElementNS("http://www.w3.org/2000/svg",t)},pointsToPath:function(t,e){var i,n,o,a,r,l,h="";for(i=0,o=t.length;o>i;i++){for(r=t[i],n=0,a=r.length;a>n;n++)l=r[n],h+=(n?"L":"M")+l.x+" "+l.y;h+=e?s.Browser.svg?"z":"x":""}return h||"M0 0"}}),s.Browser.svg=!(!e.createElementNS||!s.SVG.create("svg").createSVGRect),s.svg=function(t){return s.Browser.svg||s.Browser.vml?new s.SVG(t):null},s.Browser.vml=!s.Browser.svg&&function(){try{var t=e.createElement("div");t.innerHTML='<v:shape adj="1"/>';var i=t.firstChild;return i.style.behavior="url(#default#VML)",i&&"object"==typeof i.adj}catch(n){return!1}}(),s.SVG.include(s.Browser.vml?{_initContainer:function(){this._container=s.DomUtil.create("div","leaflet-vml-container"),this._paths={},this._initEvents()},_update:function(){this._map._animatingZoom||s.Renderer.prototype._update.call(this)},_initPath:function(t){var e=t._container=s.SVG.create("shape");s.DomUtil.addClass(e,"leaflet-vml-shape "+(this.options.className||"")),e.coordsize="1 1",t._path=s.SVG.create("path"),e.appendChild(t._path),this._updateStyle(t)},_addPath:function(t){var e=t._container;this._container.appendChild(e),this._paths[s.stamp(e)]=t},_removePath:function(t){var e=t._container;s.DomUtil.remove(e),delete this._paths[s.stamp(e)]},_updateStyle:function(t){var e=t._stroke,i=t._fill,n=t.options,o=t._container;o.stroked=!!n.stroke,o.filled=!!n.fill,n.stroke?(e||(e=t._stroke=s.SVG.create("stroke"),o.appendChild(e)),e.weight=n.weight+"px",e.color=n.color,e.opacity=n.opacity,n.dashArray?e.dashStyle=s.Util.isArray(n.dashArray)?n.dashArray.join(" "):n.dashArray.replace(/( *, *)/g," "):e.dashStyle="",e.endcap=n.lineCap.replace("butt","flat"),e.joinstyle=n.lineJoin):e&&(o.removeChild(e),t._stroke=null),n.fill?(i||(i=t._fill=s.SVG.create("fill"),o.appendChild(i)),i.color=n.fillColor||n.color,i.opacity=n.fillOpacity):i&&(o.removeChild(i),t._fill=null)},_updateCircle:function(t){var e=t._point.round(),i=Math.round(t._radius),n=Math.round(t._radiusY||i);this._setPath(t,t._empty()?"M0 0":"AL "+e.x+","+e.y+" "+i+","+n+" 0,23592600")},_setPath:function(t,e){t._path.v=e},_bringToFront:function(t){s.DomUtil.toFront(t._container)},_bringToBack:function(t){s.DomUtil.toBack(t._container)}}:{}),s.Browser.vml&&(s.SVG.create=function(){try{return e.namespaces.add("lvml","urn:schemas-microsoft-com:vml"),function(t){return e.createElement("<lvml:"+t+' class="lvml">')}}catch(t){return function(t){return e.createElement("<"+t+' xmlns="urn:schemas-microsoft.com:vml" class="lvml">')}}}()),s.Canvas=s.Renderer.extend({onAdd:function(){s.Renderer.prototype.onAdd.call(this),this._layers=this._layers||{},this._draw()},_initContainer:function(){var t=this._container=e.createElement("canvas");s.DomEvent.on(t,"mousemove",this._onMouseMove,this).on(t,"click dblclick mousedown mouseup contextmenu",this._onClick,this),this._ctx=t.getContext("2d")},_update:function(){if(!this._map._animatingZoom||!this._bounds){s.Renderer.prototype._update.call(this);var t=this._bounds,e=this._container,i=t.getSize(),n=s.Browser.retina?2:1;s.DomUtil.setPosition(e,t.min),e.width=n*i.x,e.height=n*i.y,e.style.width=i.x+"px",e.style.height=i.y+"px",s.Browser.retina&&this._ctx.scale(2,2),this._ctx.translate(-t.min.x,-t.min.y)}},_initPath:function(t){this._layers[s.stamp(t)]=t},_addPath:s.Util.falseFn,_removePath:function(t){t._removed=!0,this._requestRedraw(t)},_updatePath:function(t){this._redrawBounds=t._pxBounds,this._draw(!0),t._project(),t._update(),this._draw(),this._redrawBounds=null},_updateStyle:function(t){this._requestRedraw(t)},_requestRedraw:function(t){this._map&&(this._redrawBounds=this._redrawBounds||new s.Bounds,this._redrawBounds.extend(t._pxBounds.min).extend(t._pxBounds.max),this._redrawRequest=this._redrawRequest||s.Util.requestAnimFrame(this._redraw,this))},_redraw:function(){this._redrawRequest=null,this._draw(!0),this._draw(),this._redrawBounds=null},_draw:function(t){this._clear=t;var e;for(var i in this._layers)e=this._layers[i],(!this._redrawBounds||e._pxBounds.intersects(this._redrawBounds))&&e._updatePath(),t&&e._removed&&(delete e._removed,delete this._layers[i])},_updatePoly:function(t,e){var i,n,o,s,a=t._parts,r=a.length,l=this._ctx;if(r){for(l.beginPath(),i=0;r>i;i++){for(n=0,o=a[i].length;o>n;n++)s=a[i][n],l[n?"lineTo":"moveTo"](s.x,s.y);e&&l.closePath()}this._fillStroke(l,t)}},_updateCircle:function(t){if(!t._empty()){var e=t._point,i=this._ctx,n=t._radius,o=(t._radiusY||n)/n;1!==o&&(i.save(),i.scale(1,o)),i.beginPath(),i.arc(e.x,e.y/o,n,0,2*Math.PI,!1),1!==o&&i.restore(),this._fillStroke(i,t)}},_fillStroke:function(t,e){var i=this._clear,n=e.options;t.globalCompositeOperation=i?"destination-out":"source-over",n.fill&&(t.globalAlpha=i?1:n.fillOpacity,t.fillStyle=n.fillColor||n.color,t.fill(n.fillRule||"evenodd")),n.stroke&&0!==n.weight&&(t.globalAlpha=i?1:n.opacity,e._prevWeight=t.lineWidth=i?e._prevWeight+1:n.weight,t.strokeStyle=n.color,t.lineCap=n.lineCap,t.lineJoin=n.lineJoin,t.stroke())},_onClick:function(t){var e=this._map.mouseEventToLayerPoint(t);for(var i in this._layers)this._layers[i]._containsPoint(e)&&(s.DomEvent._fakeStop(t),this._fireEvent(this._layers[i],t))},_onMouseMove:function(t){if(this._map&&!this._map._animatingZoom){var e=this._map.mouseEventToLayerPoint(t);for(var i in this._layers)this._handleHover(this._layers[i],t,e)}},_handleHover:function(t,e,i){t.options.interactive&&(t._containsPoint(i)?(t._mouseInside||(s.DomUtil.addClass(this._container,"leaflet-interactive"),this._fireEvent(t,e,"mouseover"),t._mouseInside=!0),this._fireEvent(t,e)):t._mouseInside&&(s.DomUtil.removeClass(this._container,"leaflet-interactive"),this._fireEvent(t,e,"mouseout"),t._mouseInside=!1))},_fireEvent:function(t,e,i){this._map._fireDOMEvent(t,e,i||e.type)},_bringToFront:s.Util.falseFn,_bringToBack:s.Util.falseFn}),s.Browser.canvas=function(){return!!e.createElement("canvas").getContext}(),s.canvas=function(t){return s.Browser.canvas?new s.Canvas(t):null},s.Polyline.prototype._containsPoint=function(t,e){var i,n,o,a,r,l,h=this._clickTolerance();if(!this._pxBounds.contains(t))return!1;for(i=0,a=this._parts.length;a>i;i++)for(l=this._parts[i],n=0,r=l.length,o=r-1;r>n;o=n++)if((e||0!==n)&&s.LineUtil.pointToSegmentDistance(t,l[o],l[n])<=h)return!0;return!1},s.Polygon.prototype._containsPoint=function(t){var e,i,n,o,a,r,l,h,d=!1;if(!this._pxBounds.contains(t))return!1;for(o=0,l=this._parts.length;l>o;o++)for(e=this._parts[o],a=0,h=e.length,r=h-1;h>a;r=a++)i=e[a],n=e[r],i.y>t.y!=n.y>t.y&&t.x<(n.x-i.x)*(t.y-i.y)/(n.y-i.y)+i.x&&(d=!d);return d||s.Polyline.prototype._containsPoint.call(this,t,!0)},s.CircleMarker.prototype._containsPoint=function(t){return t.distanceTo(this._point)<=this._radius+this._clickTolerance()},s.GeoJSON=s.FeatureGroup.extend({initialize:function(t,e){s.setOptions(this,e),this._layers={},t&&this.addData(t)},addData:function(t){var e,i,n,o=s.Util.isArray(t)?t:t.features;if(o){for(e=0,i=o.length;i>e;e++)n=o[e],(n.geometries||n.geometry||n.features||n.coordinates)&&this.addData(n);return this}var a=this.options;if(a.filter&&!a.filter(t))return this;var r=s.GeoJSON.geometryToLayer(t,a);return r.feature=s.GeoJSON.asFeature(t),r.defaultOptions=r.options,this.resetStyle(r),a.onEachFeature&&a.onEachFeature(t,r),this.addLayer(r)},resetStyle:function(t){return t.options=t.defaultOptions,this._setLayerStyle(t,this.options.style),this},setStyle:function(t){return this.eachLayer(function(e){this._setLayerStyle(e,t)},this)},_setLayerStyle:function(t,e){"function"==typeof e&&(e=e(t.feature)),t.setStyle&&t.setStyle(e)}}),s.extend(s.GeoJSON,{geometryToLayer:function(t,e){var i,n,o,a,r="Feature"===t.type?t.geometry:t,l=r.coordinates,h=[],d=e&&e.pointToLayer,u=e&&e.coordsToLatLng||this.coordsToLatLng;switch(r.type){case"Point":return i=u(l),d?d(t,i):new s.Marker(i);case"MultiPoint":for(o=0,a=l.length;a>o;o++)i=u(l[o]),h.push(d?d(t,i):new s.Marker(i));return new s.FeatureGroup(h);case"LineString":case"MultiLineString":return n=this.coordsToLatLngs(l,"LineString"===r.type?0:1,u),new s.Polyline(n,e);case"Polygon":case"MultiPolygon":return n=this.coordsToLatLngs(l,"Polygon"===r.type?1:2,u),new s.Polygon(n,e);case"GeometryCollection":for(o=0,a=r.geometries.length;a>o;o++)h.push(this.geometryToLayer({geometry:r.geometries[o],type:"Feature",properties:t.properties},e));return new s.FeatureGroup(h);default:throw new Error("Invalid GeoJSON object.")}},coordsToLatLng:function(t){return new s.LatLng(t[1],t[0],t[2])},coordsToLatLngs:function(t,e,i){for(var n,o=[],s=0,a=t.length;a>s;s++)n=e?this.coordsToLatLngs(t[s],e-1,i):(i||this.coordsToLatLng)(t[s]),o.push(n);return o},latLngToCoords:function(t){return t.alt!==i?[t.lng,t.lat,t.alt]:[t.lng,t.lat]},latLngsToCoords:function(t,e,i){for(var n=[],o=0,a=t.length;a>o;o++)n.push(e?s.GeoJSON.latLngsToCoords(t[o],e-1,i):s.GeoJSON.latLngToCoords(t[o]));return!e&&i&&n.push(n[0]),n},getFeature:function(t,e){return t.feature?s.extend({},t.feature,{geometry:e}):s.GeoJSON.asFeature(e)},asFeature:function(t){return"Feature"===t.type?t:{type:"Feature",properties:{},geometry:t}}});var r={toGeoJSON:function(){return s.GeoJSON.getFeature(this,{type:"Point",coordinates:s.GeoJSON.latLngToCoords(this.getLatLng())})}};s.Marker.include(r),s.Circle.include(r),s.CircleMarker.include(r),s.Polyline.prototype.toGeoJSON=function(){var t=!this._flat(this._latlngs),e=s.GeoJSON.latLngsToCoords(this._latlngs,t?1:0);return s.GeoJSON.getFeature(this,{type:(t?"Multi":"")+"LineString",coordinates:e})},s.Polygon.prototype.toGeoJSON=function(){var t=!this._flat(this._latlngs),e=t&&!this._flat(this._latlngs[0]),i=s.GeoJSON.latLngsToCoords(this._latlngs,e?2:t?1:0,!0);return t||(i=[i]),s.GeoJSON.getFeature(this,{type:(e?"Multi":"")+"Polygon",coordinates:i})},s.LayerGroup.include({toMultiPoint:function(){var t=[];return this.eachLayer(function(e){t.push(e.toGeoJSON().geometry.coordinates)}),s.GeoJSON.getFeature(this,{type:"MultiPoint",coordinates:t})},toGeoJSON:function(){var t=this.feature&&this.feature.geometry&&this.feature.geometry.type;if("MultiPoint"===t)return this.toMultiPoint();var e="GeometryCollection"===t,i=[];return this.eachLayer(function(t){if(t.toGeoJSON){var n=t.toGeoJSON();i.push(e?n.geometry:s.GeoJSON.asFeature(n))}}),e?s.GeoJSON.getFeature(this,{geometries:i,type:"GeometryCollection"}):{type:"FeatureCollection",features:i}}}),s.geoJson=function(t,e){return new s.GeoJSON(t,e)};var l="_leaflet_events";s.DomEvent={on:function(t,e,i,n){if("object"==typeof e)for(var o in e)this._on(t,o,e[o],i);else{e=s.Util.splitWords(e);for(var a=0,r=e.length;r>a;a++)this._on(t,e[a],i,n)}return this},off:function(t,e,i,n){if("object"==typeof e)for(var o in e)this._off(t,o,e[o],i);else{e=s.Util.splitWords(e);for(var a=0,r=e.length;r>a;a++)this._off(t,e[a],i,n)}return this},_on:function(e,i,n,o){var a=i+s.stamp(n)+(o?"_"+s.stamp(o):"");if(e[l]&&e[l][a])return this;var r=function(i){return n.call(o||e,i||t.event)},h=r;return s.Browser.pointer&&0===i.indexOf("touch")?this.addPointerListener(e,i,r,a):s.Browser.touch&&"dblclick"===i&&this.addDoubleTapListener?this.addDoubleTapListener(e,r,a):"trplclick"===i||"qdrplclick"===i?this.addMultiClickListener(e,r,a,i):"addEventListener"in e?"mousewheel"===i?(e.addEventListener("DOMMouseScroll",r,!1),e.addEventListener(i,r,!1)):"mouseenter"===i||"mouseleave"===i?(r=function(i){i=i||t.event,s.DomEvent._checkMouse(e,i)&&h(i)},e.addEventListener("mouseenter"===i?"mouseover":"mouseout",r,!1)):("click"===i&&s.Browser.android&&(r=function(t){return s.DomEvent._filterClick(t,h)}),e.addEventListener(i,r,!1)):"attachEvent"in e&&e.attachEvent("on"+i,r),e[l]=e[l]||{},e[l][a]=r,this},_off:function(t,e,i,n){var o=e+s.stamp(i)+(n?"_"+s.stamp(n):""),a=t[l]&&t[l][o];return a?(s.Browser.pointer&&0===e.indexOf("touch")?this.removePointerListener(t,e,o):s.Browser.touch&&"dblclick"===e&&this.removeDoubleTapListener?this.removeDoubleTapListener(t,o):"trplclick"===e||"qdrplclick"===e?this.removeMultiClickListener(t,o,e):"removeEventListener"in t?"mousewheel"===e?(t.removeEventListener("DOMMouseScroll",a,!1),t.removeEventListener(e,a,!1)):t.removeEventListener("mouseenter"===e?"mouseover":"mouseleave"===e?"mouseout":e,a,!1):"detachEvent"in t&&t.detachEvent("on"+e,a),t[l][o]=null,this):this},stopPropagation:function(t){return t.stopPropagation?t.stopPropagation():t.cancelBubble=!0,s.DomEvent._skipped(t),this},disableScrollPropagation:function(t){return s.DomEvent.on(t,"mousewheel MozMousePixelScroll",s.DomEvent.stopPropagation)},disableClickPropagation:function(t){var e=s.DomEvent.stopPropagation;return s.DomEvent.on(t,s.Draggable.START.join(" "),e),s.DomEvent.on(t,{click:s.DomEvent._fakeStop,dblclick:e})},preventDefault:function(t){return t.preventDefault?t.preventDefault():t.returnValue=!1,this},stop:function(t){return s.DomEvent.preventDefault(t).stopPropagation(t)},getMousePosition:function(t,e){if(!e)return new s.Point(t.clientX,t.clientY);var i=e.getBoundingClientRect(),n=i.left,o=i.top;return t.currentTarget&&t.currentTarget.frameElement&&s.DomUtil.hasClass(t.currentTarget.frameElement,"resize-detector")&&(n=o=0),new s.Point(t.clientX-n-e.clientLeft,t.clientY-o-e.clientTop)},getWheelDelta:function(t){var e=0;return t.wheelDelta&&(e=t.wheelDelta/120),t.detail&&(e=-t.detail/3),e},_skipEvents:{},_fakeStop:function(t){s.DomEvent._skipEvents[t.type]=!0},_skipped:function(t){var e=this._skipEvents[t.type];return this._skipEvents[t.type]=!1,e},_checkMouse:function(t,e){var i=e.relatedTarget;if(!i)return!0;try{for(;i&&i!==t;)i=i.parentNode}catch(n){return!1}return i!==t},_filterClick:function(t,e){var i=t.timeStamp||t.originalEvent.timeStamp,n=s.DomEvent._lastClick&&i-s.DomEvent._lastClick;return n&&n>100&&500>n||t.target._simulatedClick&&!t._simulated?void s.DomEvent.stop(t):(s.DomEvent._lastClick=i,void e(t))}},s.DomEvent.addListener=s.DomEvent.on,s.DomEvent.removeListener=s.DomEvent.off,s.Draggable=s.Evented.extend({statics:{START:s.Browser.touch?["touchstart","mousedown"]:["mousedown"],END:{mousedown:"mouseup",touchstart:"touchend",pointerdown:"touchend",MSPointerDown:"touchend"},MOVE:{mousedown:"mousemove",touchstart:"touchmove",pointerdown:"touchmove",MSPointerDown:"touchmove"}},initialize:function(t,e,i){this._element=t,this._dragStartTarget=e||t,this._preventOutline=i},enable:function(){this._enabled||(s.DomEvent.on(this._dragStartTarget,s.Draggable.START.join(" "),this._onDown,this),this._enabled=!0)},disable:function(){this._enabled&&(s.DomEvent.off(this._dragStartTarget,s.Draggable.START.join(" "),this._onDown,this),this._enabled=!1,this._moved=!1)},_onDown:function(t){if(this._moved=!1,!t.shiftKey&&(1===t.which||0===t.button||t.touches)&&(s.DomUtil.hasClass(this._element,"leaflet-map-pane")||s.DomEvent.stopPropagation(t),this._preventOutline&&s.DomUtil.preventOutline(this._element),!s.DomUtil.hasClass(this._element,"leaflet-zoom-anim")&&(s.DomUtil.disableImageDrag(),s.DomUtil.disableTextSelection(),!this._moving))){this.fire("down");var i=t.touches?t.touches[0]:t;this._startPoint=new s.Point(i.clientX,i.clientY),this._startPos=this._newPos=s.DomUtil.getPosition(this._element);var n=this._element.getBoundingClientRect();this.startOffset=this._startPoint.subtract(new s.Point(n.left,n.top)),s.DomEvent.on(e,s.Draggable.MOVE[t.type],this._onMove,this).on(e,s.Draggable.END[t.type],this._onUp,this)}},_onMove:function(t){if(t.touches&&t.touches.length>1)return void(this._moved=!0);var i=t.touches&&1===t.touches.length?t.touches[0]:t,n=new s.Point(i.clientX,i.clientY),o=n.subtract(this._startPoint);if(this._map){if(t.currentTarget&&t.currentTarget.frameElement&&s.DomUtil.hasClass(t.currentTarget.frameElement,"resize-detector")){var a=this._map._container.getBoundingClientRect(),r=new s.Point(a.left,a.top);o=o.add(r)}this._map.getDocSize().x<this._map.getSize().x&&(o.x=0),this._map.getDocSize().y<this._map.getSize().y&&(o.y=0)}(o.x||o.y)&&(s.Browser.touch&&Math.abs(o.x)+Math.abs(o.y)<3||(s.DomEvent.preventDefault(t),this._moved||(this.fire("dragstart"),this._moved=!0,this._startPos=s.DomUtil.getPosition(this._element).subtract(o),s.DomUtil.addClass(e.body,"leaflet-dragging"),this._lastTarget=t.target||t.srcElement,s.DomUtil.addClass(this._lastTarget,"leaflet-drag-target")),this._newPos=this._startPos.add(o),this._moving=!0,s.Util.cancelAnimFrame(this._animRequest),this._lastEvent=t,this._animRequest=s.Util.requestAnimFrame(this._updatePosition,this,!0,this._dragStartTarget)))},_updatePosition:function(){var t={originalEvent:this._lastEvent};this.fire("predrag",t),s.DomUtil.setPosition(this._element,this._newPos),this.fire("drag",t)},_onUp:function(){s.DomUtil.removeClass(e.body,"leaflet-dragging"),this._lastTarget&&(s.DomUtil.removeClass(this._lastTarget,"leaflet-drag-target"),this._lastTarget=null);for(var t in s.Draggable.MOVE)s.DomEvent.off(e,s.Draggable.MOVE[t],this._onMove,this).off(e,s.Draggable.END[t],this._onUp,this);s.DomUtil.enableImageDrag(),s.DomUtil.enableTextSelection(),this._moved&&this._moving&&(s.Util.cancelAnimFrame(this._animRequest),this.fire("dragend",{distance:this._newPos.distanceTo(this._startPos)})),this._moving=!1}}),s.Handler=s.Class.extend({initialize:function(t){this._map=t},enable:function(){this._enabled||(this._enabled=!0,this.addHooks())},disable:function(){this._enabled&&(this._enabled=!1,this.removeHooks())},enabled:function(){return!!this._enabled}}),s.Map.mergeOptions({dragging:!0,inertia:!s.Browser.android23,inertiaDeceleration:3400,inertiaMaxSpeed:1/0,easeLinearity:.2,worldCopyJump:!1}),s.Map.Drag=s.Handler.extend({addHooks:function(){if(!this._draggable){var t=this._map;this._draggable=new s.Draggable(t._mapPane,t._container),this._draggable._map=t,this._draggable.on({down:this._onDown,dragstart:this._onDragStart,drag:this._onDrag,dragend:this._onDragEnd},this),t.options.worldCopyJump&&(this._draggable.on("predrag",this._onPreDrag,this),t.on("viewreset",this._onViewReset,this),t.whenReady(this._onViewReset,this))}this._draggable.enable()},removeHooks:function(){this._draggable.disable()},moved:function(){return this._draggable&&this._draggable._moved},_onDown:function(){this._map.stop()},_onDragStart:function(){var t=this._map;t.fire("movestart").fire("dragstart"),t.options.inertia&&(this._positions=[],this._times=[])},_onDrag:function(t){if(this._map.options.inertia){var e=this._lastTime=+new Date,i=this._lastPos=this._draggable._absPos||this._draggable._newPos;this._positions.push(i),this._times.push(e),e-this._times[0]>50&&(this._positions.shift(),this._times.shift())}this._map.fire("move",t).fire("drag",t)},_onViewReset:function(){var t=this._map.getSize().divideBy(2),e=this._map.latLngToLayerPoint([0,0]);this._initialWorldOffset=e.subtract(t).x,this._worldWidth=this._map.getPixelWorldBounds().getSize().x},_onPreDrag:function(){var t=this._worldWidth,e=Math.round(t/2),i=this._initialWorldOffset,n=this._draggable._newPos.x,o=(n-e+i)%t+e-i,s=(n+e+i)%t-e-i,a=Math.abs(o+i)<Math.abs(s+i)?o:s;this._draggable._absPos=this._draggable._newPos.clone(),this._draggable._newPos.x=a},_onDragEnd:function(t){var e=this._map,i=e.options,n=!i.inertia||this._times.length<2;if(e.fire("dragend",t),n)e.fire("moveend");else{var o=this._lastPos.subtract(this._positions[0]),a=(this._lastTime-this._times[0])/1e3,r=i.easeLinearity,l=o.multiplyBy(r/a),h=l.distanceTo([0,0]),d=Math.min(i.inertiaMaxSpeed,h),u=l.multiplyBy(d/h),c=d/(i.inertiaDeceleration*r),_=u.multiplyBy(-c/2).round();_.x&&_.y?(_=e._limitOffset(_,e.options.maxBounds),s.Util.requestAnimFrame(function(){e.panBy(_,{duration:c,easeLinearity:r,noMoveStart:!0,animate:!0})})):e.fire("moveend")}}}),s.Map.addInitHook("addHandler","dragging",s.Map.Drag),s.Map.mergeOptions({scrollHandler:!0,wheelDebounceTime:40}),s.Map.Scroll=s.Handler.extend({addHooks:function(){s.DomEvent.on(this._map._container,{mousewheel:this._onWheelScroll,MozMousePixelScroll:s.DomEvent.preventDefault},this),this._delta=0,this._vertical=1},removeHooks:function(){s.DomEvent.off(this._map._container,{mousewheel:this._onWheelScroll,MozMousePixelScroll:s.DomEvent.preventDefault},this)},_onWheelScroll:function(t){var e=s.DomEvent.getWheelDelta(t),i=this._map.options.wheelDebounceTime;this._delta+=e,this._lastMousePos=this._map.mouseEventToContainerPoint(t),this._startTime||(this._startTime=+new Date);var n=Math.max(i-(+new Date-this._startTime),0);clearTimeout(this._timer),t.ctrlKey?this._timer=setTimeout(s.bind(this._performZoom,this),n):t.shiftKey?(this._vertical=0,this._timer=setTimeout(s.bind(this._performScroll,this),n)):(this._vertical=1,this._timer=setTimeout(s.bind(this._performScroll,this),n)),s.DomEvent.stop(t)},_performScroll:function(){var t=this._map,e=-this._delta,i=Math.round(t.getSize().y/4);this._delta=0,this._startTime=null,e&&t.fire("scrollby",{x:(1-this._vertical)*e*i,y:this._vertical*e*i})},_performZoom:function(){var t=this._map,e=this._delta,i=t.getZoom();t.stop(),e=e>0?Math.ceil(e):Math.floor(e),e=Math.max(Math.min(e,4),-4),e=t._limitZoom(i+e)-i,this._delta=0,this._startTime=null,e&&("center"===t.options.scrollWheelZoom?t.setZoom(i+e):t.setZoomAround(this._lastMousePos,i+e))}}),s.Map.addInitHook("addHandler","scrollHandler",s.Map.Scroll),s.Map.mergeOptions({doubleClickZoom:!1}),s.Map.DoubleClickZoom=s.Handler.extend({addHooks:function(){this._map.on("dblclick",this._onDoubleClick,this)},removeHooks:function(){this._map.off("dblclick",this._onDoubleClick,this)},_onDoubleClick:function(t){var e=this._map,i=e.getZoom(),n=t.originalEvent.shiftKey?Math.ceil(i)-1:Math.floor(i)+1;"center"===e.options.doubleClickZoom?e.setZoom(n):e.setZoomAround(t.containerPoint,n)}}),s.Map.addInitHook("addHandler","doubleClickZoom",s.Map.DoubleClickZoom),s.extend(s.DomEvent,{_touchstart:s.Browser.msPointer?"MSPointerDown":s.Browser.pointer?"pointerdown":"touchstart",_touchend:s.Browser.msPointer?"MSPointerUp":s.Browser.pointer?"pointerup":"touchend",addDoubleTapListener:function(t,e,i){function n(t){var e;if(e=s.Browser.pointer?s.DomEvent._pointersCount:t.touches.length,!(e>1)){var i=Date.now(),n=i-(a||i);r=t.touches?t.touches[0]:t,l=n>0&&h>=n,a=i}}function o(){if(l){if(s.Browser.pointer){var t,i,n={};for(i in r)t=r[i],n[i]=t&&t.bind?t.bind(r):t;r=n}r.type="dblclick",r.button=0,e(r),a=null}}var a,r,l=!1,h=250,d="_leaflet_",u=this._touchstart,c=this._touchend;return t[d+u+i]=n,t[d+c+i]=o,t.addEventListener(u,n,!1),t.addEventListener(c,o,!1),this},removeDoubleTapListener:function(t,e){var i="_leaflet_",n=t[i+this._touchend+e];return t.removeEventListener(this._touchstart,t[i+this._touchstart+e],!1),t.removeEventListener(this._touchend,n,!1),this}}),s.extend(s.DomEvent,{POINTER_DOWN:s.Browser.msPointer?"MSPointerDown":"pointerdown",POINTER_MOVE:s.Browser.msPointer?"MSPointerMove":"pointermove",POINTER_UP:s.Browser.msPointer?"MSPointerUp":"pointerup",POINTER_CANCEL:s.Browser.msPointer?"MSPointerCancel":"pointercancel",_pointers:{},_pointersCount:0,addPointerListener:function(t,e,i,n){return"touchstart"===e?this._addPointerStart(t,i,n):"touchmove"===e?this._addPointerMove(t,i,n):"touchend"===e&&this._addPointerEnd(t,i,n),this},removePointerListener:function(t,e,i){var n=t["_leaflet_"+e+i];return"touchstart"===e?t.removeEventListener(this.POINTER_DOWN,n,!1):"touchmove"===e?t.removeEventListener(this.POINTER_MOVE,n,!1):"touchend"===e&&(t.removeEventListener(this.POINTER_UP,n,!1),t.removeEventListener(this.POINTER_CANCEL,n,!1)),this},_addPointerStart:function(t,i,n){var o=s.bind(function(t){s.DomEvent.preventDefault(t),this._handlePointer(t,i)},this);if(t["_leaflet_touchstart"+n]=o,t.addEventListener(this.POINTER_DOWN,o,!1),!this._pointerDocListener){var a=s.bind(this._globalPointerUp,this);e.documentElement.addEventListener(this.POINTER_DOWN,s.bind(this._globalPointerDown,this),!0),e.documentElement.addEventListener(this.POINTER_MOVE,s.bind(this._globalPointerMove,this),!0),e.documentElement.addEventListener(this.POINTER_UP,a,!0),e.documentElement.addEventListener(this.POINTER_CANCEL,a,!0),this._pointerDocListener=!0}},_globalPointerDown:function(t){this._pointers[t.pointerId]=t,this._pointersCount++},_globalPointerMove:function(t){this._pointers[t.pointerId]&&(this._pointers[t.pointerId]=t)},_globalPointerUp:function(t){delete this._pointers[t.pointerId],this._pointersCount--},_handlePointer:function(t,e){t.touches=[];for(var i in this._pointers)t.touches.push(this._pointers[i]);t.changedTouches=[t],e(t)},_addPointerMove:function(t,e,i){var n=s.bind(function(t){(t.pointerType!==t.MSPOINTER_TYPE_MOUSE&&"mouse"!==t.pointerType||0!==t.buttons)&&this._handlePointer(t,e)},this);t["_leaflet_touchmove"+i]=n,t.addEventListener(this.POINTER_MOVE,n,!1)},_addPointerEnd:function(t,e,i){var n=s.bind(function(t){this._handlePointer(t,e)},this);t["_leaflet_touchend"+i]=n,t.addEventListener(this.POINTER_UP,n,!1),t.addEventListener(this.POINTER_CANCEL,n,!1)}}),s.Map.mergeOptions({touchZoom:s.Browser.touch&&!s.Browser.android23,bounceAtZoomLimits:!0}),s.Map.TouchZoom=s.Handler.extend({addHooks:function(){s.DomEvent.on(this._map._container,"touchstart",this._onTouchStart,this)},removeHooks:function(){s.DomEvent.off(this._map._container,"touchstart",this._onTouchStart,this)},_onTouchStart:function(t){var i=this._map;if(t.touches&&2===t.touches.length&&!i._animatingZoom&&!this._zooming){var n=i.mouseEventToLayerPoint(t.touches[0]),o=i.mouseEventToLayerPoint(t.touches[1]),a=i._getCenterLayerPoint();this._startCenter=n.add(o)._divideBy(2),this._startDist=n.distanceTo(o),this._moved=!1,"spreadsheet"===i.getDocType()?this._zooming=!1:this._zooming=!0,this._centerOffset=a.subtract(this._startCenter),i.stop(),s.DomEvent.on(e,"touchmove",this._onTouchMove,this).on(e,"touchend",this._onTouchEnd,this),s.DomEvent.preventDefault(t)}},_onTouchMove:function(t){if(t.touches&&2===t.touches.length&&this._zooming){var e=this._map,i=e.mouseEventToLayerPoint(t.touches[0]),n=e.mouseEventToLayerPoint(t.touches[1]);if(this._scale=i.distanceTo(n)/this._startDist,this._delta=i._add(n)._divideBy(2)._subtract(this._startCenter),!e.options.bounceAtZoomLimits){var o=e.getScaleZoom(this._scale);if(o<=e.getMinZoom()&&this._scale<1||o>=e.getMaxZoom()&&this._scale>1)return}this._moved||(e.fire("movestart").fire("zoomstart"),this._moved=!0),s.Util.cancelAnimFrame(this._animRequest),this._animRequest=s.Util.requestAnimFrame(this._updateOnMove,this,!0,this._map._container),s.DomEvent.preventDefault(t)}},_updateOnMove:function(){var t=this._map;"center"===t.options.touchZoom?this._center=t.getCenter():this._center=t.layerPointToLatLng(this._getTargetCenter()),this._zoom=t.getScaleZoom(this._scale),(1!==this._scale||0!==this._delta.x||0!==this._delta.y)&&t._animateZoom(this._center,this._zoom,!1,!0)},_onTouchEnd:function(){if(!this._moved||!this._zooming)return void(this._zooming=!1);this._zooming=!1,s.Util.cancelAnimFrame(this._animRequest),s.DomEvent.off(e,"touchmove",this._onTouchMove).off(e,"touchend",this._onTouchEnd);var t=this._map,i=t.getZoom(),n=this._zoom-i,o=t._limitZoom(n>0?Math.ceil(this._zoom):Math.floor(this._zoom));t._animateZoom(this._center,o,!0,!0)},_getTargetCenter:function(){var t=this._centerOffset.subtract(this._delta).divideBy(this._scale);return this._startCenter.add(t)}}),s.Map.addInitHook("addHandler","touchZoom",s.Map.TouchZoom),s.Map.mergeOptions({tap:!0,tapTolerance:15}),s.Map.Tap=s.Handler.extend({addHooks:function(){s.DomEvent.on(this._map._container,"touchstart",this._onDown,this)},removeHooks:function(){s.DomEvent.off(this._map._container,"touchstart",this._onDown,this)},_onDown:function(t){if(t.touches){if(s.DomEvent.preventDefault(t),this._fireClick=!0,t.touches.length>1)return this._fireClick=!1,void clearTimeout(this._holdTimeout);var i=t.touches[0],n=i.target;this._startPos=this._newPos=new s.Point(i.clientX,i.clientY),n.tagName&&"a"===n.tagName.toLowerCase()&&s.DomUtil.addClass(n,"leaflet-active"),this._holdTimeout=setTimeout(s.bind(function(){this._isTapValid()&&(this._fireClick=!1,this._onUp(),this._simulateEvent("contextmenu",i))},this),1e3),this._simulateEvent("mousedown",i),s.DomEvent.on(e,{touchmove:this._onMove,touchend:this._onUp},this)}},_onUp:function(t){if(clearTimeout(this._holdTimeout),s.DomEvent.off(e,{touchmove:this._onMove,touchend:this._onUp},this),this._fireClick&&t&&t.changedTouches){var i=t.changedTouches[0],n=i.target;n&&n.tagName&&"a"===n.tagName.toLowerCase()&&s.DomUtil.removeClass(n,"leaflet-active"),this._simulateEvent("mouseup",i),this._isTapValid()&&this._simulateEvent("click",i)}},_isTapValid:function(){return this._newPos.distanceTo(this._startPos)<=this._map.options.tapTolerance;
},_onMove:function(t){var e=t.touches[0];this._newPos=new s.Point(e.clientX,e.clientY)},_simulateEvent:function(i,n){var o=e.createEvent("MouseEvents");o._simulated=!0,n.target._simulatedClick=!0,o.initMouseEvent(i,!0,!0,t,1,n.screenX,n.screenY,n.clientX,n.clientY,!1,!1,!1,!1,0,null),n.target.dispatchEvent(o)}}),s.Browser.touch&&!s.Browser.pointer&&s.Map.addInitHook("addHandler","tap",s.Map.Tap),s.Map.mergeOptions({boxZoom:!0}),s.Map.BoxZoom=s.Handler.extend({initialize:function(t){this._map=t,this._container=t._container,this._pane=t._panes.overlayPane},addHooks:function(){s.DomEvent.on(this._container,"mousedown",this._onMouseDown,this)},removeHooks:function(){s.DomEvent.off(this._container,"mousedown",this._onMouseDown,this)},moved:function(){return this._moved},_onMouseDown:function(t){return!t.shiftKey||1!==t.which&&0!==t.button?!1:(this._moved=!1,s.DomUtil.disableTextSelection(),s.DomUtil.disableImageDrag(),this._startPoint=this._map.mouseEventToContainerPoint(t),void s.DomEvent.on(e,{contextmenu:s.DomEvent.stop,mousemove:this._onMouseMove,mouseup:this._onMouseUp,keydown:this._onKeyDown},this))},_onMouseMove:function(t){this._moved||(this._moved=!0,this._box=s.DomUtil.create("div","leaflet-zoom-box",this._container),s.DomUtil.addClass(this._container,"leaflet-crosshair"),this._map.fire("boxzoomstart")),this._point=this._map.mouseEventToContainerPoint(t);var e=new s.Bounds(this._point,this._startPoint),i=e.getSize();s.DomUtil.setPosition(this._box,e.min),this._box.style.width=i.x+"px",this._box.style.height=i.y+"px"},_finish:function(){this._moved&&(s.DomUtil.remove(this._box),s.DomUtil.removeClass(this._container,"leaflet-crosshair")),s.DomUtil.enableTextSelection(),s.DomUtil.enableImageDrag(),s.DomEvent.off(e,{contextmenu:s.DomEvent.stop,mousemove:this._onMouseMove,mouseup:this._onMouseUp,keydown:this._onKeyDown},this)},_onMouseUp:function(t){(1===t.which||0===t.button)&&(this._finish(),!this._moved)},_onKeyDown:function(t){27===t.keyCode&&this._finish()}}),s.Map.addInitHook("addHandler","boxZoom",s.Map.BoxZoom),s.Map.mergeOptions({keyboard:!0,keyboardPanOffset:20,keyboardZoomOffset:1}),s.Map.Keyboard=s.Handler.extend({keyModifier:{shift:4096,ctrl:8192,alt:16384,ctrlMac:32768},keymap:{8:1283,9:1282,13:1280,16:null,17:null,18:null,19:null,20:null,27:1281,32:1284,33:1030,34:1031,35:1029,36:1028,37:1026,38:1025,39:1027,40:1024,45:1285,46:1286,48:256,49:257,50:258,51:259,52:260,53:261,54:262,55:263,56:264,57:265,65:512,66:513,67:514,68:515,69:516,70:517,71:518,72:519,73:520,74:521,75:522,76:523,77:524,78:525,79:526,80:527,81:528,82:529,83:530,84:531,85:532,86:533,87:534,88:535,89:536,90:537,91:null,92:null,93:null,96:256,97:257,98:258,99:259,100:260,101:261,102:262,103:263,104:264,105:265,106:1289,107:1287,109:1288,110:1309,111:1290,112:768,113:769,114:770,115:771,116:772,117:773,118:774,119:775,120:776,121:777,122:778,144:1313,145:1314,173:1288,186:1317,187:1295,188:1292,189:1288,190:null,191:null,192:null,219:null,220:null,221:null,222:null},handleOnKeyDownKeys:{8:!0,9:!0,19:!0,20:!0,27:!0,33:!0,34:!0,35:!0,36:!0,37:!0,38:!0,39:!0,40:!0,45:!0,46:!0},keyCodes:{pageUp:33,pageDown:34,enter:13},navigationKeyCodes:{left:[37],right:[39],down:[40],up:[38],zoomIn:[187,107,61,171],zoomOut:[189,109,173]},initialize:function(t){this._map=t,this._setPanOffset(t.options.keyboardPanOffset),this._setZoomOffset(t.options.keyboardZoomOffset),this.modifier=0},addHooks:function(){var t=this._map._container;-1===t.tabIndex&&(t.tabIndex="0"),this._map.on("mousedown",this._onMouseDown,this),this._map.on("keydown keyup keypress",this._onKeyDown,this),this._map.on("compositionstart compositionupdate compositionend textInput",this._onKeyDown,this)},removeHooks:function(){this._map.off("mousedown",this._onMouseDown,this),this._map.off("keydown keyup keypress",this._onKeyDown,this),this._map.off("compositionstart compositionupdate compositionend textInput",this._onKeyDown,this)},_handleOnKeyDown:function(t,e){return e&this.keyModifier.shift&&(45===t||46===t)?!1:this.handleOnKeyDownKeys[t]},_setPanOffset:function(t){var e,i,n=this._panKeys={},o=this.navigationKeyCodes;for(e=0,i=o.left.length;i>e;e++)n[o.left[e]]=[-1*t,0];for(e=0,i=o.right.length;i>e;e++)n[o.right[e]]=[t,0];for(e=0,i=o.down.length;i>e;e++)n[o.down[e]]=[0,t];for(e=0,i=o.up.length;i>e;e++)n[o.up[e]]=[0,-1*t]},_setZoomOffset:function(t){var e,i,n=this._zoomKeys={},o=this.navigationKeyCodes;for(e=0,i=o.zoomIn.length;i>e;e++)n[o.zoomIn[e]]=t;for(e=0,i=o.zoomOut.length;i>e;e++)n[o.zoomOut[e]]=-t},_onMouseDown:function(){"edit"!==this._map._permission&&this._map._container.focus()},_toUNOKeyCode:function(t){return this.keymap[t]||t},_onKeyDown:function(t,e){if(!this._map.slideShow||!this._map.slideShow.fullscreen){var n,o=this._map._docLayer;e||(e=o._postKeyboardEvent,n=o),this.modifier=0;var a=t.originalEvent.shiftKey?this.keyModifier.shift:0,r=t.originalEvent.ctrlKey?this.keyModifier.ctrl:0,l=t.originalEvent.altKey?this.keyModifier.alt:0,h=t.originalEvent.metaKey?this.keyModifier.ctrl:0,d=t.originalEvent.location;if(this._keyHandled=this._keyHandled||!1,this.modifier=a|r|l|h,r&&l){if("keydown"===t.type&&2===d)return void(this._prevCtrlAltLocation=d);if(1===d&&(this._prevCtrlAltLocation=i),2===this._prevCtrlAltLocation&&0===d){if("keypress"!==t.type)return;r=l=this.modifier=0}}if(!r&&!h||!this._handleCtrlCommand(t)){var u=t.originalEvent.charCode,c=t.originalEvent.keyCode;if(("compositionstart"===t.type||"compositionupdate"===t.type)&&(this._isComposing=!0),"compositionend"===t.type){this._isComposing=!1;for(var _=[],p=0;p<t.originalEvent.data.length;p++)_.push(t.originalEvent.data[p].charCodeAt());this._map._textArea.value=""}this._isComposing||"keyup"!==t.type||(this._map._textArea.value="");var m=this._toUNOKeyCode(c);if(this.modifier&&(m|=this.modifier,"keyup"!==t.type&&(this.modifier!==a||32===c&&!o._isCursorVisible)))return e.call(n,"input",u,m),void t.originalEvent.preventDefault();if("edit"===this._map._permission){if(o._resetPreFetching(),"keydown"===t.type)this._keyHandled=!1,this._bufferedTextInputEvent=null,this._handleOnKeyDown(c,this.modifier)&&0===u&&e.call(n,"input",u,m);else if("keypress"!==t.type&&"compositionend"!==t.type||this._handleOnKeyDown(c,this.modifier)&&0===u){if("textInput"===t.type)this._bufferedTextInputEvent=t;else if("keyup"===t.type){if(!this._keyHandled&&this._bufferedTextInputEvent){var g=this._bufferedTextInputEvent.originalEvent.data;for(u=t.originalEvent.keyCode,f=0;p<g.length;p++)e.call(n,"input",g[f].charCodeAt(),0)}e.call(n,"up",u,m),this._keyHandled=!0,this._bufferedTextInputEvent=null}}else{if(u===c&&13!==u&&(c=0,m=this._toUNOKeyCode(c)),o._debug&&o._debugKeypressQueue.push(+new Date),"compositionend"===t.type)for(var f=0;p<_.length;++p)e.call(n,"input",_[f],0);else e.call(n,"input",u,m);this._keyHandled=!0}9===c&&t.originalEvent.preventDefault()}else{if(!(this.modifier||33!==t.originalEvent.keyCode&&34!==t.originalEvent.keyCode))return;if("keydown"===t.type){var v=t.originalEvent.keyCode,y=this._map;if(v in this._panKeys&&!t.originalEvent.shiftKey){if(y._panAnim&&y._panAnim._inProgress)return;y.fire("scrollby",{x:this._panKeys[v][0],y:this._panKeys[v][1]})}else v in this._panKeys&&t.originalEvent.shiftKey&&0!==o._selections.getLayers().length?e.call(n,"input",u,m):v in this._zoomKeys&&y.setZoom(y.getZoom()+(t.shiftKey?3:1)*this._zoomKeys[v])}}s.DomEvent.stopPropagation(t.originalEvent)}}},_handleCtrlCommand:function(t){if("keydown"!==t.type&&"c"!==t.originalEvent.key&&"v"!==t.originalEvent.key&&"x"!==t.originalEvent.key&&99!==t.originalEvent.keyCode&&118!==t.originalEvent.keyCode&&120!==t.originalEvent.keyCode)return t.originalEvent.preventDefault(),!0;if(67!==t.originalEvent.keyCode&&86!==t.originalEvent.keyCode&&88!==t.originalEvent.keyCode&&99!==t.originalEvent.keyCode&&118!==t.originalEvent.keyCode&&120!==t.originalEvent.keyCode&&"c"!==t.originalEvent.key&&"v"!==t.originalEvent.key&&"x"!==t.originalEvent.key&&t.originalEvent.preventDefault(),t.originalEvent.ctrlKey&&t.originalEvent.shiftKey&&"?"===t.originalEvent.key)return map.showLOKeyboardHelp(),t.originalEvent.preventDefault(),!0;if(t.originalEvent.ctrlKey&&("z"===t.originalEvent.key||"Z"===t.originalEvent.key))return this._map._socket.sendMessage("uno .uno:Undo"),t.originalEvent.preventDefault(),!0;if(t.originalEvent.ctrlKey&&("y"===t.originalEvent.key||"Y"===t.originalEvent.key))return this._map._socket.sendMessage("uno .uno:Redo"),t.originalEvent.preventDefault(),!0;if(t.originalEvent.altKey||t.originalEvent.shiftKey){if("c"===t.originalEvent.key&&t.originalEvent.altKey)return this._map.insertComment(),!0;if(t.originalEvent.shiftKey){if(t.originalEvent.altKey)switch(t.originalEvent.keyCode){case 68:this._map._docLayer.toggleTileDebugMode()}}else switch(t.originalEvent.keyCode){case 53:return this._map._socket.sendMessage("uno .uno:Strikeout"),!0;case 70:return this._map._socket.sendMessage("uno .uno:InsertFootnote"),!0;case 67:case 77:return this._map._socket.sendMessage("uno .uno:InsertAnnotation"),!0;case 68:return this._map._socket.sendMessage("uno .uno:InsertEndnote"),!0}return!1}switch(t.originalEvent.keyCode){case 51:return"spreadsheet"===this._map.getDocType()?(this._map._socket.sendMessage("uno .uno:SetOptimalColumnWidthDirect"),this._map._socket.sendMessage("commandvalues command=.uno:ViewRowColumnHeaders"),!0):!1;case 53:return"spreadsheet"===this._map.getDocType()?(this._map._socket.sendMessage("uno .uno:Strikeout"),!0):!1;case 67:case 88:case 99:case 120:case 91:case 93:return this._map._docLayer._textArea.value="dummy text",this._map._docLayer._textArea.focus(),this._map._docLayer._textArea.select(),!0;case 80:return this._map.print(),!0;case 83:return this._map.save(!1,!1),!0;case 86:case 118:return!0;case 112:return this._map._socket.sendMessage("uno .uno:NoteVisible"),!0;case 188:return this._map._socket.sendMessage("uno .uno:SubScript"),!0;case 190:return this._map._socket.sendMessage("uno .uno:SuperScript"),!0}return"keypress"!==t.type||!t.originalEvent.ctrlKey&&!t.originalEvent.metaKey||"c"!==t.originalEvent.key&&"v"!==t.originalEvent.key&&"x"!==t.originalEvent.key?!1:!0}}),s.Map.addInitHook("addHandler","keyboard",s.Map.Keyboard),s.extend(s.DomEvent,{addMultiClickListener:function(t,e,i){function n(t){var i=Date.now(),n=0;o&&(n=i-(o[o.length-1]||i));var a=n>0&&s>=n,r=!1;if(o.length>1&&a){var l=o[o.length-1]-o[o.length-2];r=l>0&&s>=l}if(r){var h=!1;if(o.length>2&&r){var d=o[o.length-2]-o[o.length-3];h=d>0&&s>=d}var u={type:h?"qdrplclick":"trplclick",clientX:t.clientX,clientY:t.clientY,button:t.button,target:t.target};e(u)}for(o.push(i);o.length>3;)o.shift()}var o=[],s=250;return t["_leaflet_click"+i]=n,t.addEventListener("click",n,!1),this},removeMultiClickListener:function(t,e){return t.removeEventListener("click",t["_leaflet_click"+e],!1),this}}),s.Map.mergeOptions({mouse:!0}),s.Map.Mouse=s.Handler.extend({initialize:function(t){this._map=t,this._mouseEventsQueue=[],this._prevMousePos=null},addHooks:function(){this._map.on("mousedown mouseup mouseover mouseout mousemove dblclick trplclick qdrplclick",this._onMouseEvent,this)},removeHooks:function(){this._map.off("mousedown mouseup mouseover mouseout mousemove dblclick trplclick qdrplclick",this._onMouseEvent,this)},LOButtons:{left:1,middle:2,right:4},JSButtons:{left:0,middle:1,right:2},_onMouseEvent:function(t){var i=this._map._docLayer;if(!(!i||this._map.slideShow&&this._map.slideShow.fullscreen||this._map.rulerActive)){if(i._graphicMarker){if(i._graphicMarker.isDragged)return;if(!i._isEmptyRectangle(i._graphicSelection)){var n=i._graphicMarker.getBounds().contains(t.latlng);if("mousedown"===t.type&&n)this._prevMousePos=t.latlng;else if("mousemove"===t.type&&this._mouseDown)if(!this._prevMousePos&&n)this._prevMousePos=t.latlng;else{var o=s.latLng(t.latlng.lat-this._prevMousePos.lat,t.latlng.lng-this._prevMousePos.lng);this._prevMousePos=t.latlng;var a=i._graphicMarker.getBounds().getCenter(),r=s.latLng(a.lat+o.lat,a.lng+o.lng);i._graphicMarker.editing&&i._graphicMarker.editing._move(r)}else"mouseup"===t.type&&(this._prevMousePos=null)}}for(var l in i._selectionHandles)if(i._selectionHandles[l].isDragged)return;var h=0,d=t.originalEvent.shiftKey?this._map.keyboard.keyModifier.shift:0,u=t.originalEvent.ctrlKey?this._map.keyboard.keyModifier.ctrl:0,c=t.originalEvent.altKey?this._map.keyboard.keyModifier.alt:0,_=t.originalEvent.metaKey?this._map.keyboard.keyModifier.ctrlMac:0;h=d|u|c|_;var p=0;p|=t.originalEvent.button===this.JSButtons.left?this.LOButtons.left:0,p|=t.originalEvent.button===this.JSButtons.middle?this.LOButtons.middle:0,p|=t.originalEvent.button===this.JSButtons.right?this.LOButtons.right:0;var m=this._map._mouseEnteringLeaving;if(m&&"mouseover"===t.type&&this._mouseDown)s.DomEvent.off(e,"mousemove",this._onMouseMoveOutside,this),s.DomEvent.off(e,"mouseup",this._onMouseUpOutside,this),s.DomEvent.off(this._map._resizeDetector.contentWindow,"mousemove",this._onMouseMoveOutside,this),s.DomEvent.off(this._map._resizeDetector.contentWindow,"mouseup",this._onMouseUpOutside,this);else if("mousedown"===t.type){i._resetPreFetching(),this._mouseDown=!0,this._holdMouseEvent&&clearTimeout(this._holdMouseEvent);var g=i._latLngToTwips(t.latlng);this._mouseEventsQueue.push(s.bind(function(){this._postMouseEvent("buttondown",g.x,g.y,1,p,h)},i)),this._holdMouseEvent=setTimeout(s.bind(this._executeMouseEvents,this),500)}else if("mouseup"===t.type){if(this._mouseDown=!1,this._map.dragging.enabled()&&0===this._mouseEventsQueue.length)return;if(clearTimeout(this._holdMouseEvent),this._holdMouseEvent=null,this._clickTime&&Date.now()-this._clickTime<=250)return this._mouseEventsQueue=[],this._clickCount++,void(this._clickCount<4&&(this._clickTime=Date.now()));this._clickTime=Date.now(),this._clickCount=1,g=i._latLngToTwips(t.latlng);var f=250;"edit"===this._map._permission&&(f=0),this._mouseEventsQueue.push(s.bind(function(){var t=this._map._docLayer;this._mouseEventsQueue=[],t._postMouseEvent("buttonup",g.x,g.y,1,p,h),t._textArea.focus()},this)),this._holdMouseEvent=setTimeout(s.bind(this._executeMouseEvents,this),f);for(l in i._selectionHandles){var v=i._selectionHandles[l];v._icon&&s.DomUtil.removeClass(v._icon,"leaflet-not-clickable")}this._map.fire("scrollvelocity",{vx:0,vy:0})}else if("mousemove"===t.type&&this._mouseDown){if(this._holdMouseEvent){if(clearTimeout(this._holdMouseEvent),this._holdMouseEvent=null,this._map.dragging.enabled())return void(this._mouseEventsQueue=[]);for(var y=0;y<this._mouseEventsQueue.length;y++)this._mouseEventsQueue[y]();this._mouseEventsQueue=[]}if(!this._map.dragging.enabled()){g=i._latLngToTwips(t.latlng),i._postMouseEvent("move",g.x,g.y,1,p,h);for(l in i._selectionHandles)v=i._selectionHandles[l],v._icon&&s.DomUtil.addClass(v._icon,"leaflet-not-clickable");this._map.fire("handleautoscroll",{pos:t.containerPoint,map:this._map})}}else if("mousemove"!==t.type||this._mouseDown)if("dblclick"===t.type||"trplclick"===t.type||"qdrplclick"===t.type){g=i._latLngToTwips(t.latlng);var w={dblclick:2,trplclick:3,qdrplclick:4},C=w[t.type];i._postMouseEvent("buttondown",g.x,g.y,C,p,h),i._postMouseEvent("buttonup",g.x,g.y,C,p,h)}else m&&"mouseout"===t.type&&this._mouseDown&&(s.DomEvent.on(this._map._resizeDetector.contentWindow,"mousemove",this._onMouseMoveOutside,this),s.DomEvent.on(this._map._resizeDetector.contentWindow,"mouseup",this._onMouseUpOutside,this),s.DomEvent.on(e,"mousemove",this._onMouseMoveOutside,this),s.DomEvent.on(e,"mouseup",this._onMouseUpOutside,this));else clearTimeout(this._mouseOverTimeout),g=i._latLngToTwips(t.latlng),this._mouseOverTimeout=setTimeout(s.bind(function(){i._postMouseEvent("move",g.x,g.y,1,0,h)},this),100)}},_executeMouseEvents:function(){this._holdMouseEvent=null;for(var t=0;t<this._mouseEventsQueue.length;t++)this._mouseEventsQueue[t]();this._mouseEventsQueue=[]},_onMouseMoveOutside:function(t){this._map._handleDOMEvent(t),this._map.dragging.enabled()&&this._map.dragging._draggable._onMove(t)},_onMouseUpOutside:function(t){this._mouseDown=!1,s.DomEvent.off(e,"mousemove",this._onMouseMoveOutside,this),s.DomEvent.off(e,"mouseup",this._onMouseUpOutside,this),s.DomEvent.off(this._map._resizeDetector.contentWindow,"mousemove",this._onMouseMoveOutside,this),s.DomEvent.off(this._map._resizeDetector.contentWindow,"mouseup",this._onMouseUpOutside,this),this._map._handleDOMEvent(t),this._map.dragging.enabled()&&this._map.dragging._draggable._onUp(t)}}),s.Map.addInitHook("addHandler","mouse",s.Map.Mouse),s.Map.mergeOptions({printHandler:!0}),s.Map.Print=s.Handler.extend({initialize:function(t){this._map=t},addHooks:function(){this._map.on("filedownloadready",this._onFileReady,this)},removeHooks:function(){this._map.off("filedownloadready",this._onFileReady,this)},_onFileReady:function(t){var e=new XMLHttpRequest;e.onreadystatechange=s.bind(function(){4===e.readyState&&200===e.status&&this._onInitPrint(e)},this),e.open("GET",t.url,!0),e.responseType="blob",e.send()},_onInitPrint:function(t){var i=new Blob([t.response],{type:"application/pdf"}),n=URL.createObjectURL(i);this._printIframe=s.DomUtil.create("iframe","",e.body),this._printIframe.onload=s.bind(this._onIframeLoaded,this),s.DomUtil.setStyle(this._printIframe,"visibility","hidden"),s.DomUtil.setStyle(this._printIframe,"position","fixed"),s.DomUtil.setStyle(this._printIframe,"right","0"),s.DomUtil.setStyle(this._printIframe,"bottom","0"),this._printIframe.src=n},_onIframeLoaded:function(){this._printIframe.contentWindow.focus(),this._printIframe.contentWindow.print(),setTimeout(s.bind(this._closePrintIframe,this,this._printIframe),3e5)},_closePrintIframe:function(t){s.DomUtil.remove(t),this._map.focus()}}),s.Map.addInitHook("addHandler","printHandler",s.Map.Print),s.Map.mergeOptions({slideShow:!0}),s.Map.SlideShow=s.Handler.extend({initialize:function(t){this._map=t},addHooks:function(){this._map.on("fullscreen",this._onFullScreen,this),this._map.on("slidedownloadready",this._onSlideDownloadReady,this)},removeHooks:function(){this._map.off("fullscreen",this._onFullScreen,this),this._map.off("slidedownloadready",this._onSlideDownloadReady,this)},_onFullScreen:function(){this._slideShow=s.DomUtil.create("iframe","leaflet-slideshow",this._map._container),this._slideShow.src=this._map.options.webserver+"/loleaflet/dist/loading.html",this._slideShow.requestFullscreen?this._slideShow.requestFullscreen():this._slideShow.msRequestFullscreen?this._slideShow.msRequestFullscreen():this._slideShow.mozRequestFullScreen?this._slideShow.mozRequestFullScreen():this._slideShow.webkitRequestFullscreen&&this._slideShow.webkitRequestFullscreen(),s.DomEvent.on(e,"fullscreenchange webkitfullscreenchange mozfullscreenchange msfullscreenchange",this._onFullScreenChange,this),this.fullscreen=!0,this._map.downloadAs("slideshow.svg","svg",null,"slideshow")},_onFullScreenChange:function(){this.fullscreen=e.fullscreen||e.webkitIsFullScreen||e.mozFullScreen||e.msFullscreenElement,this.fullscreen||s.DomUtil.remove(this._slideShow)},_onSlideDownloadReady:function(t){this._slideShow.src=t.url,this._slideShow.contentWindow.focus(),clearInterval(this._slideShow.contentWindow.spinnerInterval)}}),s.Map.addInitHook("addHandler","slideShow",s.Map.SlideShow),s.Map.mergeOptions({fileInserter:!0}),s.Map.FileInserter=s.Handler.extend({initialize:function(t){this._map=t,this._childId=null,this._toInsert={};var i=e.createElement("a");i.href=t.options.server;var n="";""!=t.options.wopiSrc&&(n="?WOPISrc="+t.options.wopiSrc),this._url=t.options.webserver+"/"+t.options.urlPrefix+"/"+encodeURIComponent(t.options.doc)+"/insertfile"+n},addHooks:function(){this._map.on("insertfile",this._onInsertFile,this),this._map.on("childid",this._onChildIdMsg,this)},removeHooks:function(){this._map.off("insertfile",this._onInsertFile,this),this._map.off("childid",this._onChildIdMsg,this)},_onInsertFile:function(t){this._childId?this._sendFile(Date.now(),t.file):(this._map._socket.sendMessage("getchildid"),this._toInsert[Date.now()]=t.file)},_onChildIdMsg:function(t){this._childId=t.id;for(var e in this._toInsert)this._sendFile(e,this._toInsert[e]);this._toInsert={}},_sendFile:function(t,e){var i=this._url,n=new XMLHttpRequest,o=this._map._socket,s=this._map;this._map.showBusy(_("Uploading..."),!1),n.onreadystatechange=function(){4===n.readyState&&200===n.status&&(s.hideBusy(),o.sendMessage("insertfile name="+t+" type=graphic"))},n.open("POST",i,!0);var a=new FormData;a.append("name",t),a.append("childid",this._childId),a.append("file",e),n.send(a)}}),s.Map.addInitHook("addHandler","fileInserter",s.Map.FileInserter),s.Map.mergeOptions({stateChangeHandler:!0}),s.Map.StateChangeHandler=s.Handler.extend({initialize:function(t){this._map=t,this._items={}},addHooks:function(){this._map.on("commandstatechanged",this._onStateChanged,this)},removeHooks:function(){this._map.off("commandstatechanged",this._onStateChanged,this)},_onStateChanged:function(t){var e=t.state.indexOf("{"),i=-1!==e?JSON.parse(t.state.substring(e)):t.state;this._items[t.commandName]=i},getItems:function(){return this._items},getItemValue:function(t){return t&&".uno:"!==t.substring(0,5)&&(t=".uno:"+t),this._items[t]}}),s.Map.addInitHook("addHandler","stateChangeHandler",s.Map.StateChangeHandler),s.Map.WOPI=s.Handler.extend({PostMessageOrigin:"*",BaseFileName:"",DocumentLoadedTime:!1,HidePrintOption:!1,HideSaveOption:!1,HideExportOption:!1,DisablePrint:!1,DisableExport:!1,DisableCopy:!1,DisableInactiveMessages:!1,UserCanNotWriteRelative:!0,_appLoadedConditions:{docloaded:!1,updatepermission:!1,viewinfo:!1},_appLoaded:!1,initialize:function(t){this._map=t},addHooks:function(){this._map.on("postMessage",this._postMessage,this),this._map.on("docloaded",this._postLoaded,this),this._map.on("updatepermission",this._postLoaded,this),this._map.on("viewinfo",this._postLoaded,this),this._map.on("wopiprops",this._setWopiProps,this),s.DomEvent.on(t,"message",this._postMessageListener,this)},removeHooks:function(){this._map.off("postMessage",this._postMessage,this),this._map.off("docloaded",this._postLoaded,this),this._map.off("updatepermission",this._postLoaded,this),this._map.off("viewinfo",this._postLoaded,this),this._map.off("wopiprops",this._setWopiProps,this),s.DomEvent.off(t,"message",this._postMessageListener,this)},_setWopiProps:function(t){t.PostMessageOrigin&&(this.PostMessageOrigin=t.PostMessageOrigin),this.BaseFileName=t.BaseFileName,this.HidePrintOption=!!t.HidePrintOption,this.HideSaveOption=!!t.HideSaveOption,this.HideExportOption=!!t.HideExportOption,this.DisablePrint=!!t.DisablePrint,this.DisableExport=!!t.DisableExport,this.DisableCopy=!!t.DisableCopy,this.DisableInactiveMessages=!!t.DisableInactiveMessages,this.UserCanNotWriteRelative=!!t.UserCanNotWriteRelative,this._map.fire("postMessage",{msgId:"App_LoadingStatus",args:{Status:"Frame_Ready"}})},resetAppLoaded:function(){this._appLoaded=!1;for(var t in this._appLoadedConditions)this._appLoadedConditions[t]=!1},_postLoaded:function(t){if(!this._appLoaded){if("docloaded"===t.type){if(!t.status)return void(this._appLoadedConditions[t.type]=!1);this.DocumentLoadedTime=Date.now()}this._appLoadedConditions[t.type]=!0;for(var e in this._appLoadedConditions)if(!this._appLoadedConditions[e])return;this._appLoaded=!0,this._map.fire("postMessage",{msgId:"App_LoadingStatus",args:{Status:"Document_Loaded",DocumentLoadedTime:this.DocumentLoadedTime}})}},_postMessageListener:function(e){if(t.WOPIPostmessageReady){var n=JSON.parse(e.data);if("Host_PostmessageReady"!==n.MessageId){if("Close_Session"===n.MessageId)return void this._map._socket.sendMessage("closedocument");if(!this._appLoaded)return void console.error("LibreOffice Online not loaded yet. Listen for App_LoadingStatus (Document_Loaded) event before using PostMessage API. Ignoring post message '"+n.MessageId+"'.");if("Insert_Button"===n.MessageId){if(n.Values&&n.Values.id&&!w2ui["toolbar-up"].get(n.Values.id)&&n.Values.imgurl)if("edit"===this._map._permission){if($("html > head > style").append(".w2ui-icon."+n.Values.id+"{background: url("+n.Values.imgurl+") no-repeat center !important; }"),w2ui["toolbar-up"].insert("save",[{type:"button",id:n.Values.id,img:n.Values.id,hint:_(n.Values.hint),postmessage:!0}]),n.Values.mobile){var o=toolbarUpMobileItems.indexOf("save");toolbarUpMobileItems.splice(o,0,n.Values.id)}resizeToolbar()}else"readonly"===this._map._permission&&this._map.fire("addmenu",{id:n.Values.id,label:n.Values.hint})}else if("Set_Settings"===n.MessageId){if(n.Values){var s=n.Values.AlwaysActive;this._map.options.alwaysActive=!!s}}else if("Get_Views"===n.MessageId){var a=[];for(var r in this._map._viewInfo)a.push({ViewId:r,UserName:this._map._viewInfo[r].username,UserId:this._map._viewInfo[r].userid,UserExtraInfo:this._map._viewInfo[r].userextrainfo,Color:this._map._viewInfo[r].color});this._postMessage({msgId:"Get_Views_Resp",args:a})}else if("Action_Save"===n.MessageId){var l=n.Values&&n.Values.DontTerminateEdit,h=n.Values&&n.Values.DontSaveIfUnmodified;this._notifySave=n.Values&&n.Values.Notify,this._map.save(l,h)}else if("Action_Print"===n.MessageId)this._map.print();else if("Action_Export"===n.MessageId){if(n.Values){var d=n.Values.Format,u=this._map.wopi.BaseFileName;u=u.substr(0,u.lastIndexOf(".")),u=""===u?"document":u,this._map.downloadAs(u+"."+d,d)}}else if("Action_ShowBusy"===n.MessageId)n.Values&&n.Values.Label&&this._map.fire("showbusy",{label:n.Values.Label});else if("Action_HideBusy"===n.MessageId)this._map.fire("hidebusy");else if("Get_Export_Formats"===n.MessageId){var c=[];for(var p in this._map._docLayer._exportFormats)c.push({Label:this._map._docLayer._exportFormats[p].label,Format:this._map._docLayer._exportFormats[p].format});this._postMessage({msgId:"Get_Export_Formats_Resp",args:c})}else"Action_SaveAs"===n.MessageId&&n.Values&&null!==n.Values.Filename&&n.Values.Filename!==i&&(this._map.showBusy(_("Creating copy..."),!1),this._map.saveAs(n.Values.Filename))}}},_postMessage:function(e){if(this.enabled){var i=e.msgId,n=e.args||{};if(this.PostMessageOrigin&&t.parent!==t.self){if("Action_Save_Resp"===i){if(!this._notifySave)return;this._notifySave=!1}var o={MessageId:i,SendTime:Date.now(),Values:n};t.parent.postMessage(JSON.stringify(o),this.PostMessageOrigin)}}}}),s.Map.addInitHook("addHandler","wopi",s.Map.WOPI),s.Handler.MarkerDrag=s.Handler.extend({initialize:function(t){this._marker=t},addHooks:function(){var t=this._marker._icon;this._draggable||(this._draggable=new s.Draggable(t,t,!0)),this._draggable.on({dragstart:this._onDragStart,drag:this._onDrag,dragend:this._onDragEnd},this).enable(),s.DomUtil.addClass(t,"leaflet-marker-draggable")},removeHooks:function(){this._draggable.off({dragstart:this._onDragStart,drag:this._onDrag,dragend:this._onDragEnd},this).disable(),this._marker._icon&&s.DomUtil.removeClass(this._marker._icon,"leaflet-marker-draggable")},moved:function(){return this._draggable&&this._draggable._moved},_onDragStart:function(){this._marker.closePopup().fire("movestart").fire("dragstart")},_onDrag:function(t){var e=this._marker,i=e._shadow,n=s.DomUtil.getPosition(e._icon),o=e._map.layerPointToLatLng(n);i&&s.DomUtil.setPosition(i,n),e._latlng=o,t.latlng=o,e.fire("move",t).fire("drag",t)},_onDragEnd:function(t){this._marker.fire("moveend").fire("dragend",t)}}),s.Control=s.Class.extend({options:{position:"topright"},initialize:function(t){s.setOptions(this,t)},getPosition:function(){return this.options.position},setPosition:function(t){var e=this._map;return e&&e.removeControl(this),this.options.position=t,e&&e.addControl(this),this},getContainer:function(){return this._container},addTo:function(t){this.remove(),this._map=t;var e=this._container=this.onAdd(t),i=this.getPosition(),n=t._controlCorners[i];return s.DomUtil.addClass(e,"leaflet-control"),-1!==i.indexOf("bottom")?n.insertBefore(e,n.firstChild):n.appendChild(e),this},remove:function(){return this._map?(s.DomUtil.remove(this._container),this.onRemove&&this.onRemove(this._map),this._map=null,this):this},isVisible:function(){if(!this._map)return!1;var t=this._map._controlCorners[this.options.position];return t.hasChildNodes()},_refocusOnMap:function(){this._map.focus()}}),s.control=function(t){return new s.Control(t)},s.Map.include({addControl:function(t){t._map=this;var e=t.onAdd(this),i=s.DomUtil.get(this.options.toolbarContainer);return this._controls||(this._controls=[]),i&&e&&(i.appendChild(e),this._controls.push({div:e})),this},removeControl:function(t){return t.remove(),this},removeControls:function(){this._controls&&this._controls.forEach(function(t){s.DomUtil.remove(t.div)})},_initControlPos:function(){function t(t,o){var a=i+t+" "+i+o;e[t+o]=s.DomUtil.create("div",a,n)}var e=this._controlCorners={},i="leaflet-",n=this._controlContainer=s.DomUtil.create("div",i+"control-container",this._container);t("top","left"),t("top","middle"),t("top","right"),t("bottom","left"),t("bottom","right")},_clearControlPos:function(){s.DomUtil.remove(this._controlContainer)}}),s.Control.PartsPreview=s.Control.extend({options:{autoUpdate:!0},onAdd:function(t){this._previewInitialized=!1,this._previewTiles=[],this._partsPreviewCont=s.DomUtil.get("slide-sorter"),t.on("updateparts",this._updateDisabled,this),t.on("updatepart",this._updatePart,this),t.on("tilepreview",this._updatePreview,this),t.on("insertpage",this._insertPreview,this),t.on("deletepage",this._deletePreview,this)},_updateDisabled:function(t){var e=t.parts,n=t.selectedPart,o=t.docType;if("text"!==o&&("presentation"===o||"drawing"===o))if(this._previewInitialized){t.partNames!==i&&this._syncPreviews(t);for(var a=0;e>a;a++)s.DomUtil.removeClass(this._previewTiles[a],"preview-img-selected");s.DomUtil.addClass(this._previewTiles[n],"preview-img-selected")}else{var r=this._map.options.documentContainer;s.DomUtil.addClass(r,"parts-preview-document"),setTimeout(s.bind(function(){this._map.invalidateSize(),$(".scroll-container").mCustomScrollbar("update")},this),500);for(var l=0;e>l;l++)this._previewTiles.push(this._createPreview(l,t.partNames[l]));s.DomUtil.addClass(this._previewTiles[n],"preview-img-selected"),this._previewInitialized=!0}},_createPreview:function(t,e){var i=s.DomUtil.create("div","preview-frame",this._partsPreviewCont);s.DomUtil.create("span","preview-helper",i);var n="preview-img",o=s.DomUtil.create("img",n,i);return o.hash=e,o.src=s.Icon.Default.imagePath+"/preview_placeholder.png",s.DomEvent.on(o,"click",s.DomEvent.stopPropagation).on(o,"click",s.DomEvent.stop).on(o,"click",this._setPart,this).on(o,"click",this._refocusOnMap,this),this._map.getPreview(t,t,180,180,{autoUpdate:this.options.autoUpdate}),o},_setPart:function(t){var e=$("#slide-sorter .mCSB_container .preview-frame").index(t.target.parentNode);null!==e&&this._map.setPart(parseInt(e))},_updatePart:function(t){"presentation"===t.docType&&t.part>=0&&this._map.getPreview(t.part,t.part,180,180,{autoUpdate:this.options.autoUpdate})},_syncPreviews:function(t){var e=0,i=t.parts;if(i!==this._previewTiles.length)if(1===Math.abs(i-this._previewTiles.length)){if(i>this._previewTiles.length)for(e=0;i>e;e++){if(e===this._previewTiles.length){this._insertPreview({selectedPart:e-1,hashCode:t.partNames[e]});break}if(this._previewTiles[e].hash!==t.partNames[e]){this._insertPreview({selectedPart:e,hashCode:t.partNames[e]});break}}else for(e=0;e<this._previewTiles.length;e++)if(e===t.partNames.length||this._previewTiles[e].hash!==t.partNames[e]){this._deletePreview({selectedPart:e});break}}else{for(;this._previewTiles.length<t.partNames.length;)this._insertPreview({selectedPart:this._previewTiles.length-1,hashCode:t.partNames[this._previewTiles.length]});for(;this._previewTiles.length>t.partNames.length;)this._deletePreview({selectedPart:this._previewTiles.length-1});for(e=0;e<t.partNames.length;e++)this._previewTiles[e].hash=t.partNames[e],this._previewTiles[e].src=s.Icon.Default.imagePath+"/preview_placeholder.png",this._map.getPreview(e,e,180,180,{autoUpdate:this.options.autoUpdate})}else for(e=0;i>e;e++)this._previewTiles[e].hash!==t.partNames[e]&&(this._previewTiles[e].hash=t.partNames[e]);
},_updatePreview:function(t){("presentation"===this._map.getDocType()||"drawing"===this._map.getDocType())&&(this._previewTiles[t.id].onload=function(){$("#slide-sorter").mCustomScrollbar({axis:"y",theme:"dark-thick",scrollInertia:0,alwaysShowScrollbar:1})},this._previewTiles[t.id].src=t.tile)},_updatePreviewIds:function(){$("#slide-sorter").mCustomScrollbar("update")},_insertPreview:function(t){if("presentation"===this._map.getDocType()){var e=t.selectedPart+1,n=this._createPreview(e,t.hashCode===i?null:t.hashCode);this._previewTiles.splice(e,0,n);var o=this._previewTiles[t.selectedPart].parentNode,s=n.parentNode;o.parentNode.insertBefore(s,o.nextSibling),this._updatePreviewIds()}},_deletePreview:function(t){if("presentation"===this._map.getDocType()){var e=this._previewTiles[t.selectedPart].parentNode;s.DomUtil.remove(e),this._previewTiles.splice(t.selectedPart,1),this._updatePreviewIds()}}}),s.control.partsPreview=function(t){return new s.Control.PartsPreview(t)},s.Control.Header=s.Control.extend({options:{cursor:"col-resize"},initialize:function(){this._isColumn=i,this.converter=null,this._canvas=null,this._clicks=0,this._current=-1,this._selection={start:-1,end:-1},this._mouseOverEntry=null,this._lastMouseOverIndex=i,this._hitResizeArea=!1,this._overHeaderArea=!1,this._selectionBackgroundGradient=["#3465A4","#729FCF","#004586"],this._groups=null,this._groupHeadSize=12,this._levelSpacing=1;var t=s.DomUtil.get("spreadsheet-header-corner-container");if(t)this._cornerHeaderContainer=t,this._cornerCanvas=s.DomUtil.get("spreadsheet-header-corner");else{var e=s.DomUtil.get("spreadsheet-row-column-frame");this._cornerHeaderContainer=s.DomUtil.createWithId("div","spreadsheet-header-corner-container",e),this._cornerCanvas=s.DomUtil.createWithId("canvas","spreadsheet-header-corner",this._cornerHeaderContainer),this._setCornerCanvasWidth(),this._setCornerCanvasHeight()}this._cornerCanvasContext=this._cornerCanvas.getContext("2d"),this._cornerCanvasContext.clearRect(0,0,this._cornerCanvas.width,this._cornerCanvas.height)},_initHeaderEntryStyles:function(t){var i=e.getElementsByTagName("body")[0],n=s.DomUtil.create("div",t,i);this._textColor=s.DomUtil.getStyle(n,"color"),this._backgroundColor=s.DomUtil.getStyle(n,"background-color");var o=s.DomUtil.getStyle(n,"font-family"),a=parseInt(s.DomUtil.getStyle(n,"font-size")),r=parseInt(s.DomUtil.getStyle(n,"line-height")),l=r/a;this._font=a+"px/"+l+" "+o,this._borderColor=s.DomUtil.getStyle(n,"border-top-color");var h=s.DomUtil.getStyle(n,"border-top-width");this._borderWidth=parseInt(h),this._cursor=s.DomUtil.getStyle(n,"cursor"),s.DomUtil.remove(n)},_initHeaderEntryHoverStyles:function(t){var i=e.getElementsByTagName("body")[0],n=s.DomUtil.create("div",t,i);this._hoverColor=s.DomUtil.getStyle(n,"background-color"),s.DomUtil.remove(n)},_initHeaderEntrySelectedStyles:function(t){var i=e.getElementsByTagName("body")[0],n=s.DomUtil.create("div",t,i);this._selectionTextColor=s.DomUtil.getStyle(n,"color");var o=[],a=s.DomUtil.getStyle(n,"background-image");for(a=a.slice("linear-gradient(".length,-1);a;){var r=a.split(",",3);r=r.join(","),o.push(r),a=a.substr(r.length),a=a.substr(a.indexOf("r"))}o.length&&(this._selectionBackgroundGradient=o),s.DomUtil.remove(n)},_initHeaderEntryResizeStyles:function(t){if(this.options.cursor)this._resizeCursor=this.options.cursor;else{var i=e.getElementsByTagName("body")[0],n=s.DomUtil.create("div",t,i);this._resizeCursor=s.DomUtil.getStyle(n,"cursor"),s.DomUtil.remove(n)}},mouseInit:function(t){s.DomEvent.on(t,"mousedown",this._onMouseDown,this)},select:function(t){this.drawHeaderEntry(t,!1,!0)},unselect:function(t){this.drawHeaderEntry(t,!1,!1)},isHighlighted:function(t){return-1===this._selection.start&&-1===this._selection.end?t===this._current:this._selection.start<=t&&t<=this._selection.end},clearSelection:function(t){if(-1!==this._selection.start||-1!==this._selection.end){for(var e=this._selection.start<1?1:this._selection.start,i=this._selection.end+1,n=t.getAt(e);n&&n.index<i;)this.unselect(n),n=t.getNext(e);this._selection.start=this._selection.end=-1,this.select(t.get(this._current))}},updateSelection:function(t,e,i){if(t&&!t.isEmpty()){var n=0,o=0,s=-1,a=-1,r=!1,l=t.getFirst();for(l&&(n=l.pos-l.size,n>e&&i>n&&(r=!0,s=1));l;){if(n=l.pos-l.size,o=l.pos,e>=n&&o>e&&(r=!0,s=l.index),r&&this.select(l),i>=n&&o>=i){a=l.index;break}l=t.getNext()}if(-1!==s&&-1===a&&(a=t.getLength()-1),-1!==this._current&&-1!==s&&-1!==a&&(this._current<s||this._current>a)&&this.unselect(t.get(this._current)),-1!==this._selection.start&&-1!==s&&s>this._selection.start)for(l=t.getAt(this._selection.start);l&&l.index<s;)this.unselect(l),l=t.getNext();if(-1!==this._selection.end&&-1!==a&&a<this._selection.end)for(l=t.getAt(a+1);l&&l.index<=this._selection.end;)this.unselect(l),l=t.getNext();this._selection.start=s,this._selection.end=a}},updateCurrent:function(t,e,i){if(t&&!t.isEmpty()){if(0>e)return this.unselect(t.get(this._current)),void(this._current=-1);var n=e>0?t.get(e-1):null,o=i&&n&&0===n.size,s=t.get(e);-1===this._selection.start&&-1===this._selection.end&&(this.unselect(t.get(this._current)),s&&!o&&this.select(s)),this._current=s&&!o?s.index:-1}},_mouseEventToCanvasPos:function(t,e){var i=t.getBoundingClientRect();return{x:e.clientX-i.left,y:e.clientY-i.top}},_onMouseOut:function(t){this._hitOutline(t)||this._onHeaderMouseOut(t)},_onHeaderMouseOut:function(){this._overHeaderArea&&(this._overHeaderArea=!1,this._mouseOverEntry&&(this.drawHeaderEntry(this._mouseOverEntry,!1),this._lastMouseOverIndex=this._mouseOverEntry.index,this._mouseOverEntry=null),this._hitResizeArea=!1,s.DomEvent.on(this._canvas,"click",this._onClick,this),s.DomUtil.setStyle(this._canvas,"cursor","default"))},_onMouseMove:function(t){if(this._hitOutline(t))return this._onHeaderMouseOut(t),!1;this._overHeaderArea||(s.DomUtil.setStyle(this._canvas,"cursor",this._cursor),this._overHeaderArea=!0);var e=!1,n=this._getParallelPos(this._mouseEventToCanvasPos(this._canvas,t));n-=this._position;for(var o=this._mouseOverEntry?this._mouseOverEntry.index:i,a=this._data.getFirst();a;){var r=a.pos-a.size,l=a.pos;if(n>r&&l>=n){o=a.index;var h=Math.max(r,l-3);e=n>h;break}a=this._data.getNext()}if(!o||this._mouseOverEntry&&o===this._mouseOverEntry.index||(this.drawHeaderEntry(this._mouseOverEntry,!1),this.drawHeaderEntry(a,!0),this._mouseOverEntry=a),e!==this._hitResizeArea){e?s.DomEvent.off(this._canvas,"click",this._onClick,this):s.DomEvent.on(this._canvas,"click",this._onClick,this);var d=e?this._resizeCursor:this._cursor;s.DomUtil.setStyle(this._canvas,"cursor",d),this._hitResizeArea=e}},_onOutlineMouseEvent:function(t,e){if(!this._hitOutline(t))return!1;var i=this._mouseEventToCanvasPos(this._canvas,t),n=this._getGroupLevel(this._getOrthogonalPos(i));if(0>n||n>=this._groups.length)return!0;for(var o=this._groups[n],s=Object.keys(o),a=s.length,r=a-1;r>=0&&(t.group=o[s[r]],!e.call(this,t));--r);return!0},_onGroupControlClick:function(t){var e=t.group;if(!e)return!1;var i=this._getParallelPos(this._mouseEventToCanvasPos(this._canvas,t));return i-=this._position,e.startPos<i&&i<e.startPos+this._groupHeadSize?(this._updateOutlineState(this._isColumn,e),!0):!1},_onDoubleClick:function(t){this._onOutlineMouseEvent(t,this._onGroupControlDoubleClick)},_onGroupControlDoubleClick:function(t){var e=t.group;if(!e&&!e.hidden)return!1;var i=this._getParallelPos(this._mouseEventToCanvasPos(this._canvas,t));return i-=this._position,e.startPos+this._groupHeadSize<i&&i<e.endPos?(this._updateOutlineState(this._isColumn,e),!0):!1},_updateOutlineState:function(t,e){if(e){var i=t?"column":"row",n=e.hidden?"visible":"hidden",o="outlinestate type="+i+" level="+e.level+" index="+e.index+" state="+n;this._map._socket.sendMessage(o)}},_onMouseDown:function(t){if(!this._hitOutline(t)){var i=t.target||t.srcElement;if(!i||this._dragging)return!1;if(this._hitResizeArea){s.DomUtil.disableImageDrag(),s.DomUtil.disableTextSelection(),s.DomEvent.stopPropagation(t),s.DomEvent.off(i,"mousemove",this._onMouseMove,this),s.DomEvent.off(i,"mouseout",this._onMouseOut,this),s.DomEvent.on(e,"mousemove",this._onMouseMoveForDragging,this),s.DomEvent.on(e,"mouseup",this._onMouseUp,this);var n=this.getHeaderEntryBoundingClientRect();this._start=new s.Point(n.left,n.top),this._offset=new s.Point(n.right-t.clientX,n.bottom-t.clientY),this._item=i,this.onDragStart(this.item,this._start,this._offset,t)}}},_onMouseMoveForDragging:function(t){this._dragging=!0,s.DomEvent.preventDefault(t),this.onDragMove(this._item,this._start,this._offset,t)},_resetClickCount:function(){this._clicks=0},_onMouseUp:function(t){s.DomEvent.off(e,"mousemove",this._onMouseMoveForDragging,this),s.DomEvent.off(e,"mouseup",this._onMouseUp,this),s.DomUtil.enableImageDrag(),s.DomUtil.enableTextSelection(),s.DomEvent.on(this._item,"mousemove",this._onMouseMove,this),s.DomEvent.on(this._item,"mouseout",this._onMouseOut,this),this._dragging?(this.onDragEnd(this._item,this._start,this._offset,t),this._clicks=0):(this.onDragClick(this._item,++this._clicks,t),setTimeout(s.bind(this._resetClickCount,this),400)),this._item=this._start=this._offset=null,this._dragging=!1},_twipsToPixels:function(t){if(!this.converter)return 0;var e=new s.Point(t,t);return Math.round(this._getParallelPos(this.converter(e)))},_setCanvasSizeImpl:function(t,e,i,n){n?s.DomUtil.setStyle(t,i,n+"px"):n=parseInt(s.DomUtil.getStyle(t,i)),e[i]=n},_setCanvasWidth:function(t){this._setCanvasSizeImpl(this._headerContainer,this._canvas,"width",t)},_setCanvasHeight:function(t){this._setCanvasSizeImpl(this._headerContainer,this._canvas,"height",t)},_setCornerCanvasWidth:function(t){this._setCanvasSizeImpl(this._cornerHeaderContainer,this._cornerCanvas,"width",t)},_setCornerCanvasHeight:function(t){this._setCanvasSizeImpl(this._cornerHeaderContainer,this._cornerCanvas,"height",t)},_hitOutline:function(t){var e=this._mouseEventToCanvasPos(this._canvas,t);return this._getOrthogonalPos(e)<=this.getOutlineWidth()},_getGroupLevel:function(t){var e=this._groups.length,i=this._levelSpacing+this._groupHeadSize,n=(t+1)/i|0,o=t%i;return e>=n&&o>this._levelSpacing?n:-1},_computeOutlineWidth:function(){return this._levelSpacing+(this._groupHeadSize+this._levelSpacing)*(this._groups.length+1)},getOutlineWidth:function(){return this._isColumn?this._canvas.height-this._borderWidth-this._headerHeight:this._canvas.width-this._borderWidth-this._headerWidth},_collectGroupsData:function(t){for(var e,n,o=new Array(t.length),s=new Array(t.length),a=-1,r=0;r<t.length;++r){var l=t[r];e=parseInt(l.level)-1,this._groups[e]||(this._groups[e]={});var h=this._twipsToPixels(parseInt(l.startPos)),d=this._twipsToPixels(parseInt(l.endPos)),u=!!parseInt(l.hidden);if(u||h===d)h-=this._groupHeadSize/2,d=h+this._groupHeadSize;else{var c=!1;if(a>e&&s[a]!==i){var _=this._groups[a][s[a]];_.hidden&&h>_.startPos&&h<_.endPos&&(h=_.startPos,c=!0)}if(!c&&o[e]!==i){var p=this._groups[e][o[e]];p.hidden&&h>p.startPos&&h<p.endPos&&(h=p.endPos)}}n={level:e,index:l.index,startPos:h,endPos:d,hidden:u},this._groups[e][l.index]=n,o[e]=l.index,e>a?(s[e]=l.index,a=e):e===a&&(s[e+1]=i)}},drawCornerHeader:function(){var t=this._cornerCanvasContext;if(this._groups){if(t.save(),t.fillStyle=this._borderColor,this._isColumn){var e=this._cornerCanvas.height-(s.Control.Header.colHeaderHeight+this._borderWidth);e>0&&t.fillRect(0,e,this._cornerCanvas.width,this._borderWidth)}else{var i=this._cornerCanvas.width-(s.Control.Header.rowHeaderWidth+this._borderWidth);i>0&&t.fillRect(i,0,this._borderWidth,this._cornerCanvas.height)}t.restore();for(var n=this._groups.length+1,o=0;n>o;++o)this.drawLevelHeader(o)}},drawOutline:function(){if(this._groups)for(var t=0;t<this._groups.length;++t)for(var e in this._groups[t])this._groups[t].hasOwnProperty(e)&&this.drawGroupControl(this._groups[t][e])},onDragStart:function(){},onDragMove:function(){},onDragEnd:function(){},onDragClick:function(){},getHeaderEntryBoundingClientRect:function(){},drawHeaderEntry:function(){},drawGroupControl:function(){},_getParallelPos:function(){},_getOrthogonalPos:function(){}}),function(){s.Control.Header.rowHeaderWidth=i,s.Control.Header.colHeaderHeight=i,s.Control.Header.DataImpl=s.Class.extend({initialize:function(){this.converter=null,this._currentIndex=i,this._currentRange=i,this._dataMap={},this._indexes=[],this._endIndex=-1,this._skipZeroSize=!0},_get:function(t,e){if(1>t||t>this._endIndex)return null;var n=this._getFirstIndexLessOrEqual(t);return n!==i?(e&&(this._currentRange=n,this._currentIndex=t),this._computeEntry(this._indexes[n],t)):void 0},get:function(t){return this._get(t,!1)},getAt:function(t){return this._get(t,!0)},getFirst:function(){return this._currentRange=0,this._currentIndex=this._indexes[this._currentRange],this.getNext()},getNext:function(){if(this._currentIndex===i||this._currentRange===i)return null;if(this._currentIndex+=1,this._currentIndex>this._endIndex)return this._currentIndex=i,this._currentRange=i,this._skipZeroSize=!1,null;if(this._indexes[this._currentRange+1]===this._currentIndex&&(this._currentRange+=1,this._skipZeroSize)){var t,e,n=this._indexes.length;for(e=this._currentRange;n>e&&(t=this._indexes[e],!(this._dataMap[t].size>0));++e);if(!(n>e))return this._currentIndex=i,this._currentRange=i,this._skipZeroSize=!1,null;this._currentRange=e,this._currentIndex=t}var o=this._indexes[this._currentRange];return this._computeEntry(o,this._currentIndex)},pushBack:function(t,e){t<=this._endIndex||(this._dataMap[t]=e,this._indexes.push(t),this._endIndex=t)},isZeroSize:function(t){if(!(t>0&&t<this._endIndex))return!0;var e=this._getFirstIndexLessOrEqual(t);return 0===this._dataMap[this._indexes[e]].size},getLength:function(){return this._endIndex},isEmpty:function(){return 0===this._indexes.length},_binaryIndexOf:function(t,e){for(var i,n,o=0,s=t.length-1;s>=o;)if(i=(o+s)/2|0,n=t[i],e>n)o=i+1;else{if(!(n>e))return i;s=i-1}return i>s?i-1:o>i?i:void 0},_getFirstIndexLessOrEqual:function(t){return this._binaryIndexOf(this._indexes,t)},_twipsToPixels:function(t){return this.converter?this.converter(t):0},_computeEntry:function(t,e){var i=this._dataMap[t],n=i.pos+(e-t)*i.size;n=this._twipsToPixels(n);var o=this._twipsToPixels(i.size);return{index:e,pos:n,size:o}}})}(),s.Control.ColumnHeader=s.Control.Header.extend({options:{cursor:"col-resize"},onAdd:function(t){t.on("updatepermission",this._onUpdatePermission,this),this._initialized=!1},_initialize:function(){this._initialized=!0,this._isColumn=!0,this._map.on("scrolloffset",this.offsetScrollPosition,this),this._map.on("updatescrolloffset",this.setScrollPosition,this),this._map.on("viewrowcolumnheaders",this.viewRowColumnHeaders,this),this._map.on("updateselectionheader",this._onUpdateSelection,this),this._map.on("clearselectionheader",this._onClearSelection,this),this._map.on("updatecurrentheader",this._onUpdateCurrentColumn,this),this._map.on("updatecornerheader",this.drawCornerHeader,this);var t=s.DomUtil.get("spreadsheet-row-column-frame");this._headerContainer=s.DomUtil.createWithId("div","spreadsheet-header-columns-container",t),this._initHeaderEntryStyles("spreadsheet-header-column"),this._initHeaderEntryHoverStyles("spreadsheet-header-column-hover"),this._initHeaderEntrySelectedStyles("spreadsheet-header-column-selected"),this._initHeaderEntryResizeStyles("spreadsheet-header-column-resize"),this._canvas=s.DomUtil.create("canvas","spreadsheet-header-columns",this._headerContainer),this._canvasContext=this._canvas.getContext("2d"),this._setCanvasWidth(),this._setCanvasHeight(),this._headerHeight=this._canvas.height,s.Control.Header.colHeaderHeight=this._canvas.height,s.DomUtil.setStyle(this._canvas,"cursor",this._cursor),s.DomEvent.on(this._canvas,"mousemove",this._onMouseMove,this),s.DomEvent.on(this._canvas,"mouseout",this._onMouseOut,this),s.DomEvent.on(this._canvas,"click",this._onClick,this),s.DomEvent.on(this._canvas,"dblclick",this._onDoubleClick,this),this._startHeaderIndex=0,this._startOffset=0,this._position=0,s.DomEvent.on(this._cornerCanvas,"contextmenu",s.DomEvent.preventDefault),s.DomEvent.addListener(this._cornerCanvas,"click",this._onCornerHeaderClick,this);var e=this;$.contextMenu({selector:".spreadsheet-header-columns",className:"loleaflet-font",items:{insertcolbefore:{name:_UNO(".uno:InsertColumnsBefore","spreadsheet",!0),callback:function(){var t=e._lastMouseOverIndex;t&&e.insertColumn.call(e,t)}},deleteselectedcol:{name:_UNO(".uno:DeleteColumns","spreadsheet",!0),callback:function(){var t=e._lastMouseOverIndex;t&&e.deleteColumn.call(e,t)}},optimalwidth:{name:_UNO(".uno:SetOptimalColumnWidth","spreadsheet",!0),callback:function(){var t=e._lastMouseOverIndex;t&&e.optimalWidth.call(e,t)}},hideColumn:{name:_UNO(".uno:HideColumn","spreadsheet",!0),callback:function(){var t=e._lastMouseOverIndex;t&&e.hideColumn.call(e,t)}},showColumn:{name:_UNO(".uno:ShowColumn","spreadsheet",!0),callback:function(){var t=e._lastMouseOverIndex;t&&e.showColumn.call(e,t)}}},zIndex:10})},optimalWidth:function(t){this._dialog||(this._dialog=s.control.metricInput(this._onDialogResult,this,this._map._docLayer.twipsToHMM(this._map._docLayer.STD_EXTRA_WIDTH),{title:_UNO(".uno:SetOptimalColumnWidth","spreadsheet",!0).replace("...","")})),0===this._map._docLayer._selections.getLayers().length&&this._selectColumn(t,0),this._dialog.addTo(this._map),this._map.enable(!1),this._dialog.show()},insertColumn:function(t){0===this._map._docLayer._selections.getLayers().length&&this._selectColumn(t,0),this._map.sendUnoCommand(".uno:InsertColumns"),this._updateColumnHeader()},deleteColumn:function(t){0===this._map._docLayer._selections.getLayers().length&&this._selectColumn(t,0),this._map.sendUnoCommand(".uno:DeleteColumns"),this._updateColumnHeader()},hideColumn:function(t){0===this._map._docLayer._selections.getLayers().length&&this._selectColumn(t,0),this._map.sendUnoCommand(".uno:HideColumn"),this._updateColumnHeader()},showColumn:function(t){0===this._map._docLayer._selections.getLayers().length&&this._selectColumn(t,0),this._map.sendUnoCommand(".uno:ShowColumn"),this._updateColumnHeader()},setScrollPosition:function(t){var e=-t.x;this._position=Math.min(0,e)},offsetScrollPosition:function(t){var e=t.x;this._position=Math.min(0,this._position-e)},_onClearSelection:function(){this.clearSelection(this._data)},_onUpdateSelection:function(t){var e=t.start.x,i=t.end.x;-1!==e&&(e=this._twipsToPixels(e)),-1!==i&&(i=this._twipsToPixels(i)),this.updateSelection(this._data,e,i)},_onUpdateCurrentColumn:function(t){var e=t.curX-this._startHeaderIndex,i=this._twipsToPixels(t.width),n=1>=i;this.updateCurrent(this._data,e,n)},_updateColumnHeader:function(){this._map.fire("updaterowcolumnheaders",{x:this._map._getTopLeftPoint().x,y:0,offset:{x:i,y:0}})},drawHeaderEntry:function(t,e,i){if(t){var n=this._canvasContext,o=this._colIndexToAlpha(t.index+this._startHeaderIndex),s=this._canvas.height-this._headerHeight,a=t.pos-t.size-this._startOffset,r=t.pos-this._startOffset,l=r-a,h=this._headerHeight;if(i!==!0&&i!==!1&&(i=this.isHighlighted(t.index)),!(0>=l)){n.save(),n.translate(this._position+this._startOffset,0);var d=null;i&&(d=n.createLinearGradient(a,s,a,s+h),d.addColorStop(0,this._selectionBackgroundGradient[0]),d.addColorStop(.5,this._selectionBackgroundGradient[1]),d.addColorStop(1,this._selectionBackgroundGradient[2])),this._headerHeight!==this._canvas.height&&(n.fillStyle=this._borderColor,n.fillRect(a,s-this._borderWidth,l,this._borderWidth)),n.beginPath(),n.rect(a,s,l,h),n.clip(),n.fillStyle=i?d:e?this._hoverColor:this._backgroundColor,n.fillRect(a,s,l,h),n.fillStyle=i?this._selectionTextColor:this._textColor,n.font=this._font,n.textAlign="center",n.textBaseline="middle",n.fillText(o,r-l/2,s+h/2+1),n.fillStyle=this._borderColor,n.fillRect(r-1,s,this._borderWidth,h),n.restore()}}},drawGroupControl:function(t){if(t){var e=this._canvasContext,i=this._groupHeadSize,n=this._levelSpacing,o=t.level,s=n+(i+n)*o,a=t.startPos-this._startOffset,r=t.endPos-t.startPos;e.save(),e.translate(this._position+this._startOffset,0),e.beginPath(),e.rect(a,s,r,i),e.clip(),t.hidden?(e.fillStyle=this._hoverColor,e.fillRect(a,s,i,i),e.strokeStyle="black",e.lineWidth=.5,e.strokeRect(a,s,i,i),e.lineWidth=1,e.beginPath(),e.moveTo(a+i/4,s+i/2),e.lineTo(a+3*i/4,s+i/2),e.moveTo(a+i/2,s+i/4),e.lineTo(a+i/2,s+3*i/4),e.stroke()):(e.strokeStyle="black",e.lineWidth=1.5,e.beginPath(),e.moveTo(a+i,s+2),e.lineTo(a+r-1,s+2),e.lineTo(a+r-1,s+2+i/2),e.stroke(),e.fillStyle=this._hoverColor,e.fillRect(a,s,i,i),e.strokeStyle="black",e.lineWidth=.5,e.strokeRect(a,s,i,i),e.lineWidth=1,e.strokeRect(a+i/4,s+i/2,i/2,1)),e.restore()}},drawLevelHeader:function(t){var e=this._cornerCanvasContext,i=this._groupHeadSize,n=this._levelSpacing,o=n+(i+n)*t,a=this._cornerCanvas.width-(i+(s.Control.Header.rowHeaderWidth-i)/2);e.save(),e.fillStyle=this._hoverColor,e.fillRect(a,o,i,i),e.strokeStyle="black",e.lineWidth=.5,e.strokeRect(a,o,i,i),e.fillStyle=this._textColor,e.font=this._font,e.textAlign="center",e.textBaseline="middle",e.fillText(t+1,a+i/2,o+i/2),e.restore()},getHeaderEntryBoundingClientRect:function(t){var e=this._mouseOverEntry;if(t&&(e=this._data.get(t)),e){var i=this._canvas.getBoundingClientRect(),n=e.pos-e.size+this._position,o=e.pos+this._position,s=i.left+n,a=i.left+o,r=i.top,l=i.bottom;return{left:s,right:a,top:r,bottom:l}}},viewRowColumnHeaders:function(t){t.data.columns&&t.data.columns.length>0&&this.fillColumns(t.data.columns,t.data.columnGroups,t.converter,t.context)},fillColumns:function(t,e,n,o){if(!(t.length<2)){var a,r,l,h,d,u=this._canvas;this._setCanvasWidth(),this._setCanvasHeight(),this._canvasContext.clearRect(0,0,u.width,u.height),this._startHeaderIndex=parseInt(t[0].text),this._current=-1,this._selection.start=this._selection.end=-1,this._mouseOverEntry=null,this._lastMouseOverIndex=i,this._data=new s.Control.Header.DataImpl,this.converter=s.Util.bind(n,o),this._data.converter=s.Util.bind(this._twipsToPixels,this),this._groupLevels=parseInt(t[0].groupLevels),this._groups=this._groupLevels?new Array(this._groupLevels):null;var c=parseInt(t[0].size);this._startOffset=this._twipsToPixels(c),this._data.pushBack(0,{pos:c,size:0});var _=c,p=parseInt(t[1].text),m=t.length-1;for(l=1;m>l;l++)r=p,d=parseInt(t[l].size),p=parseInt(t[l+1].text),h=d-_,_=Math.round(d+h*(p-r-1)),r-=this._startHeaderIndex,a={pos:d,size:h},this._data.pushBack(r,a);for(r=p-this._startHeaderIndex,d=parseInt(t[m].size),h=d-_,this._data.pushBack(r,{pos:d,size:h}),e!==i&&this._groups&&this._collectGroupsData(e),this._groups?this.resize(this._computeOutlineWidth()+this._borderWidth+this._headerHeight):this._canvas.height!==this._headerHeight&&this.resize(this._headerHeight),a=this._data.getFirst();a;)this.drawHeaderEntry(a,!1),a=this._data.getNext();this.drawOutline(),this.mouseInit(u),s.DomEvent.on(u,"contextmenu",s.DomEvent.preventDefault),$(".spreadsheet-header-columns").length>0&&$(".spreadsheet-header-columns").contextMenu("edit"===this._map._permission)}},_colAlphaToNumber:function(t){for(var e=0,i="A".charCodeAt(),n=0;n<t.length;n++){var o=t[t.length-n-1];e+=(o.charCodeAt()-i+1)*Math.pow(26,n)}return e},_colIndexToAlpha:function(t){for(var e,i="A".charCodeAt(),n=t,o="";n>0;)e=(n-1)%26,o=String.fromCharCode(i+e)+o,n=Math.floor((n-e)/26);return o},_selectColumn:function(t,e){var i={Col:{type:"unsigned short",value:t-1},Modifier:{type:"unsigned short",value:e}};this._map.sendUnoCommand(".uno:SelectColumn ",i)},_onClick:function(t){if(!this._onOutlineMouseEvent(t,this._onGroupControlClick)&&this._mouseOverEntry){var e=this._mouseOverEntry.index+this._startHeaderIndex,i=0;t.shiftKey&&(i+=this._map.keyboard.keyModifier.shift),t.ctrlKey&&(i+=this._map.keyboard.keyModifier.ctrl),this._selectColumn(e,i)}},_onCornerHeaderClick:function(t){var e=this._mouseEventToCanvasPos(this._cornerCanvas,t);if(e.y>this.getOutlineWidth())return void this._map.fire("cornerheaderclicked",t);var i=this._cornerCanvas.width-s.Control.Header.rowHeaderWidth-this._borderWidth;if(e.x<=i)return void this._map.sendUnoCommand(".uno:SelectAll");var n=this._getGroupLevel(e.y);this._updateOutlineState(!0,{column:!0,level:n,index:-1})},_onDialogResult:function(t){if("submit"===t.type&&!isNaN(t.value)){var e={aExtraWidth:{type:"unsigned short",value:t.value}};this._map.sendUnoCommand(".uno:SetOptimalColumnWidth",e)}this._map.enable(!0)},_getVertLatLng:function(t,e,i){var n=this._map.mouseEventToContainerPoint({clientX:t.x,clientY:t.y}),o=this._map.mouseEventToContainerPoint(i);return[this._map.containerPointToLatLng(new s.Point(Math.max(n.x,o.x+e.x),0)),this._map.containerPointToLatLng(new s.Point(Math.max(n.x,o.x+e.x),this._map.getSize().y))]},onDragStart:function(t,e,i,n){this._vertLine?this._vertLine.setLatLngs(this._getVertLatLng(e,i,n)):this._vertLine=s.polyline(this._getVertLatLng(e,i,n),{color:"darkblue",weight:1}),this._map.addLayer(this._vertLine)},onDragMove:function(t,e,i,n){this._vertLine&&this._vertLine.setLatLngs(this._getVertLatLng(e,i,n))},onDragEnd:function(t,e,i,n){var o=new s.Point(n.clientX+i.x,n.clientY),a=this._map._docLayer._pixelsToTwips(o.subtract(e)),r=this._mouseOverEntry;if(r){var l=r.size,h=r.index+this._startHeaderIndex;if(this._data.isZeroSize(r.index+1)&&(h+=1,l=0),l!==a.x){var d={ColumnWidth:{type:"unsigned short",value:this._map._docLayer.twipsToHMM(Math.max(a.x,0))},Column:{type:"unsigned short",value:h}};this._map.sendUnoCommand(".uno:ColumnWidth",d),this._updateColumnHeader()}}this._map.removeLayer(this._vertLine)},onDragClick:function(t,e){if(this._map.removeLayer(this._vertLine),this._mouseOverEntry&&2===e){var i=this._mouseOverEntry.index+this._startHeaderIndex,n={Col:{type:"unsigned short",value:i-1},Modifier:{type:"unsigned short",value:0}};this._map.sendUnoCommand(".uno:SelectColumn ",n),this._map.sendUnoCommand(".uno:SetOptimalColumnWidthDirect")}},_onUpdatePermission:function(t){"spreadsheet"===this._map.getDocType()&&(this._initialized||this._initialize(),$(".spreadsheet-header-columns").length>0&&$(".spreadsheet-header-columns").contextMenu("edit"===t.perm))},_getParallelPos:function(t){return t.x},_getOrthogonalPos:function(t){return t.y},resize:function(t){if(!(t<this._headerHeight)){var e=s.DomUtil.get("spreadsheet-header-rows-container"),i=s.DomUtil.get("document-container");this._setCornerCanvasHeight(t);var n=t-this._canvas.height,o=parseInt(s.DomUtil.getStyle(e,"top"))+n,a=parseInt(s.DomUtil.getStyle(i,"top"))+n;s.DomUtil.setStyle(e,"top",o+"px"),s.DomUtil.setStyle(i,"top",a+"px"),this._setCanvasHeight(t),this._map.fire("updatecornerheader")}}}),s.control.columnHeader=function(t){return new s.Control.ColumnHeader(t)},s.Control.RowHeader=s.Control.Header.extend({options:{cursor:"row-resize"},onAdd:function(t){t.on("updatepermission",this._onUpdatePermission,this),this._initialized=!1},_initialize:function(){this._initialized=!0,this._isColumn=!1,this._map.on("scrolloffset",this.offsetScrollPosition,this),this._map.on("updatescrolloffset",this.setScrollPosition,this),this._map.on("viewrowcolumnheaders",this.viewRowColumnHeaders,this),this._map.on("updateselectionheader",this._onUpdateSelection,this),this._map.on("clearselectionheader",this._onClearSelection,this),this._map.on("updatecurrentheader",this._onUpdateCurrentRow,this),this._map.on("updatecornerheader",this.drawCornerHeader,this),this._map.on("cornerheaderclicked",this._onCornerHeaderClick,this);var t=s.DomUtil.get("spreadsheet-row-column-frame");this._headerContainer=s.DomUtil.createWithId("div","spreadsheet-header-rows-container",t),this._initHeaderEntryStyles("spreadsheet-header-row"),this._initHeaderEntryHoverStyles("spreadsheet-header-row-hover"),this._initHeaderEntrySelectedStyles("spreadsheet-header-row-selected"),this._initHeaderEntryResizeStyles("spreadsheet-header-row-resize"),this._canvas=s.DomUtil.create("canvas","spreadsheet-header-rows",this._headerContainer),this._canvasContext=this._canvas.getContext("2d"),this._setCanvasWidth(),this._setCanvasHeight(),this._headerWidth=this._canvas.width,s.Control.Header.rowHeaderWidth=this._canvas.width,s.DomUtil.setStyle(this._canvas,"cursor",this._cursor),s.DomEvent.on(this._canvas,"mousemove",this._onMouseMove,this),s.DomEvent.on(this._canvas,"mouseout",this._onMouseOut,this),s.DomEvent.on(this._canvas,"click",this._onClick,this),s.DomEvent.on(this._canvas,"dblclick",this._onDoubleClick,this),this._startHeaderIndex=0,this._startOffset=0,this._position=0;var e=this;$.contextMenu({selector:".spreadsheet-header-rows",className:"loleaflet-font",items:{insertrowabove:{name:_UNO(".uno:InsertRows","spreadsheet",!0),callback:function(){var t=e._lastMouseOverIndex;t&&e.insertRow.call(e,t)}},deleteselectedrow:{name:_UNO(".uno:DeleteRows","spreadsheet",!0),callback:function(){var t=e._lastMouseOverIndex;t&&e.deleteRow.call(e,t)}},optimalheight:{name:_UNO(".uno:SetOptimalRowHeight","spreadsheet",!0),callback:function(){var t=e._lastMouseOverIndex;t&&e.optimalHeight.call(e,t)}},hideRow:{name:_UNO(".uno:HideRow","spreadsheet",!0),callback:function(){var t=e._lastMouseOverIndex;t&&e.hideRow.call(e,t)}},showRow:{name:_UNO(".uno:ShowRow","spreadsheet",!0),callback:function(){var t=e._lastMouseOverIndex;t&&e.showRow.call(e,t)}}},zIndex:10})},optimalHeight:function(t){this._dialog||(this._dialog=s.control.metricInput(this._onDialogResult,this,0,{title:_UNO(".uno:SetOptimalRowHeight","spreadsheet",!0).replace("...","")})),0===this._map._docLayer._selections.getLayers().length&&this._selectRow(t,0),this._dialog.addTo(this._map),this._map.enable(!1),this._dialog.show()},insertRow:function(t){0===this._map._docLayer._selections.getLayers().length&&this._selectRow(t,0),this._map.sendUnoCommand(".uno:InsertRows")},deleteRow:function(t){0===this._map._docLayer._selections.getLayers().length&&this._selectRow(t,0),this._map.sendUnoCommand(".uno:DeleteRows")},hideRow:function(t){0===this._map._docLayer._selections.getLayers().length&&this._selectRow(t,0),this._map.sendUnoCommand(".uno:HideRow")},showRow:function(t){0===this._map._docLayer._selections.getLayers().length&&this._selectRow(t,0),this._map.sendUnoCommand(".uno:ShowRow")},setScrollPosition:function(t){var e=-t.y;this._position=Math.min(0,e)},offsetScrollPosition:function(t){var e=t.y;this._position=Math.min(0,this._position-e)},_onClearSelection:function(){this.clearSelection(this._data)},_onUpdateSelection:function(t){var e=t.start.y,i=t.end.y;-1!==e&&(e=this._twipsToPixels(e)),-1!==i&&(i=this._twipsToPixels(i)),this.updateSelection(this._data,e,i)},_onUpdateCurrentRow:function(t){var e=t.curY-this._startHeaderIndex,i=this._twipsToPixels(t.height),n=1>=i;this.updateCurrent(this._data,e,n)},_updateRowHeader:function(){this._map.fire("updaterowcolumnheaders",{x:0,y:this._map._getTopLeftPoint().y,offset:{x:0,y:i}})},drawHeaderEntry:function(t,e,i){if(t){var n=this._canvasContext,o=t.index+this._startHeaderIndex,s=this._canvas.width-this._headerWidth,a=t.pos-t.size-this._startOffset,r=t.pos-this._startOffset,l=r-a,h=this._headerWidth;if(i!==!0&&i!==!1&&(i=this.isHighlighted(t.index)),!(0>=l)){n.save(),n.translate(0,this._position+this._startOffset);var d=null;i&&(d=n.createLinearGradient(0,a,0,a+l),d.addColorStop(0,this._selectionBackgroundGradient[0]),d.addColorStop(.5,this._selectionBackgroundGradient[1]),d.addColorStop(1,this._selectionBackgroundGradient[2])),this._headerWidth!==this._canvas.width&&(n.fillStyle=this._borderColor,n.fillRect(s-this._borderWidth,a,this._borderWidth,l)),n.beginPath(),n.rect(s,a,h,l),n.clip(),n.fillStyle=i?d:e?this._hoverColor:this._backgroundColor,n.fillRect(s,a,h,l),n.fillStyle=i?this._selectionTextColor:this._textColor,n.font=this._font,n.textAlign="center",n.textBaseline="middle",n.fillText(o,s+h/2,r-l/2),n.fillStyle=this._borderColor,n.fillRect(s,r-1,h,this._borderWidth),n.restore()}}},drawGroupControl:function(t){if(t){var e=this._canvasContext,i=this._groupHeadSize,n=this._levelSpacing,o=t.level,s=n+(i+n)*o,a=t.startPos-this._startOffset,r=t.endPos-t.startPos;e.save(),e.translate(0,this._position+this._startOffset),
e.beginPath(),e.rect(s,a,i,r),e.clip(),t.hidden?(e.fillStyle=this._hoverColor,e.fillRect(s,a,i,i),e.strokeStyle="black",e.lineWidth=.5,e.strokeRect(s,a,i,i),e.lineWidth=1,e.beginPath(),e.moveTo(s+i/4,a+i/2),e.lineTo(s+3*i/4,a+i/2),e.moveTo(s+i/2,a+i/4),e.lineTo(s+i/2,a+3*i/4),e.stroke()):(e.strokeStyle="black",e.lineWidth=1.5,e.beginPath(),e.moveTo(s+2,a+i),e.lineTo(s+2,a+r-1),e.lineTo(s+2+i/2,a+r-1),e.stroke(),e.fillStyle=this._hoverColor,e.fillRect(s,a,i,i),e.strokeStyle="black",e.lineWidth=.5,e.strokeRect(s,a,i,i),e.lineWidth=1,e.strokeRect(s+i/4,a+i/2,i/2,1)),e.restore()}},drawLevelHeader:function(t){var e=this._cornerCanvasContext,i=this._groupHeadSize,n=this._levelSpacing,o=n+(i+n)*t,a=this._cornerCanvas.height-(i+(s.Control.Header.colHeaderHeight-i)/2);e.save(),e.fillStyle=this._hoverColor,e.fillRect(o,a,i,i),e.strokeStyle="black",e.lineWidth=.5,e.strokeRect(o,a,i,i),e.fillStyle=this._textColor,e.font=this._font,e.textAlign="center",e.textBaseline="middle",e.fillText(t+1,o+i/2,a+i/2),e.restore()},getHeaderEntryBoundingClientRect:function(t){var e=this._mouseOverEntry;if(t&&(e=this._data.get(t)),e){var i=this._canvas.getBoundingClientRect(),n=e.pos-e.size+this._position,o=e.pos+this._position,s=i.left,a=i.right,r=i.top+n,l=i.top+o;return{left:s,right:a,top:r,bottom:l}}},viewRowColumnHeaders:function(t){t.data.rows&&t.data.rows.length&&this.fillRows(t.data.rows,t.data.rowGroups,t.converter,t.context)},fillRows:function(t,e,n,o){if(!(t.length<2)){var a,r,l,h,d,u=this._canvas;this._setCanvasWidth(),this._setCanvasHeight(),this._canvasContext.clearRect(0,0,u.width,u.height),this._startHeaderIndex=parseInt(t[0].text),this._current=-1,this._selection.start=this._selection.end=-1,this._mouseOverEntry=null,this._lastMouseOverIndex=i,this._data=new s.Control.Header.DataImpl,this.converter=s.Util.bind(n,o),this._data.converter=s.Util.bind(this._twipsToPixels,this),this._groupLevels=parseInt(t[0].groupLevels),this._groups=this._groupLevels?new Array(this._groupLevels):null;var c=parseInt(t[0].size);this._startOffset=this._twipsToPixels(c),this._data.pushBack(0,{pos:c,size:0});var _=c,p=parseInt(t[1].text),m=t.length-1;for(l=1;m>l;l++)r=p,d=parseInt(t[l].size),p=parseInt(t[l+1].text),h=d-_,_=Math.round(d+h*(p-r-1)),r-=this._startHeaderIndex,a={pos:d,size:h},this._data.pushBack(r,a);for(r=p-this._startHeaderIndex,d=parseInt(t[m].size),h=d-_,this._data.pushBack(r,{pos:d,size:h}),e!==i&&this._groups&&this._collectGroupsData(e),this._groups?this.resize(this._computeOutlineWidth()+this._borderWidth+this._headerWidth):this._canvas.width!==this._headerWidth&&this.resize(this._headerWidth),a=this._data.getFirst();a;)this.drawHeaderEntry(a,!1),a=this._data.getNext();this.drawOutline(),this.mouseInit(u),s.DomEvent.on(u,"contextmenu",s.DomEvent.preventDefault),$(".spreadsheet-header-rows").length>0&&$(".spreadsheet-header-rows").contextMenu("edit"===this._map._permission)}},_selectRow:function(t,e){var i={Row:{type:"long",value:t-1},Modifier:{type:"unsigned short",value:e}};this._map.sendUnoCommand(".uno:SelectRow ",i)},_onClick:function(t){if(!this._onOutlineMouseEvent(t,this._onGroupControlClick)&&this._mouseOverEntry){var e=this._mouseOverEntry.index+this._startHeaderIndex,i=0;t.shiftKey&&(i+=this._map.keyboard.keyModifier.shift),t.ctrlKey&&(i+=this._map.keyboard.keyModifier.ctrl),this._selectRow(e,i)}},_onCornerHeaderClick:function(t){var e=this._mouseEventToCanvasPos(this._cornerCanvas,t);if(e.x>this.getOutlineWidth())return void this._map.sendUnoCommand(".uno:SelectAll");var i=this._getGroupLevel(e.x);this._updateOutlineState(!1,{column:!1,level:i,index:-1})},_onDialogResult:function(t){if("submit"===t.type&&!isNaN(t.value)){var e={aExtraHeight:{type:"unsigned short",value:t.value}};this._map.sendUnoCommand(".uno:SetOptimalRowHeight",e)}this._map.enable(!0)},_getHorzLatLng:function(t,e,i){var n=this._map.mouseEventToContainerPoint({clientX:t.x,clientY:t.y}),o=this._map.mouseEventToContainerPoint(i);return[this._map.containerPointToLatLng(new s.Point(0,Math.max(n.y,o.y+e.y))),this._map.containerPointToLatLng(new s.Point(this._map.getSize().x,Math.max(n.y,o.y+e.y)))]},onDragStart:function(t,e,i,n){this._horzLine?this._horzLine.setLatLngs(this._getHorzLatLng(e,i,n)):this._horzLine=s.polyline(this._getHorzLatLng(e,i,n),{color:"darkblue",weight:1}),this._map.addLayer(this._horzLine)},onDragMove:function(t,e,i,n){this._horzLine&&this._horzLine.setLatLngs(this._getHorzLatLng(e,i,n))},onDragEnd:function(t,e,i,n){var o=new s.Point(n.clientX,n.clientY+i.y),a=this._map._docLayer._pixelsToTwips(o.subtract(e)),r=this._mouseOverEntry;if(r){var l=r.size,h=r.index+this._startHeaderIndex;if(this._data.isZeroSize(r.index+1)&&(h+=1,l=0),l!==a.y){var d={RowHeight:{type:"unsigned short",value:this._map._docLayer.twipsToHMM(Math.max(a.y,0))},Row:{type:"long",value:h}};this._map.sendUnoCommand(".uno:RowHeight",d)}}this._map.removeLayer(this._horzLine)},onDragClick:function(t,e){if(this._map.removeLayer(this._horzLine),this._mouseOverEntry&&2===e){var i=this._mouseOverEntry.index+this._startHeaderIndex,n={Row:{type:"long",value:i-1},Modifier:{type:"unsigned short",value:0}},o={aExtraHeight:{type:"unsigned short",value:0}};this._map.sendUnoCommand(".uno:SelectRow",n),this._map.sendUnoCommand(".uno:SetOptimalRowHeight",o)}},_onUpdatePermission:function(t){"spreadsheet"===this._map.getDocType()&&(this._initialized||this._initialize(),$(".spreadsheet-header-rows").length>0&&$(".spreadsheet-header-rows").contextMenu("edit"===t.perm))},_getParallelPos:function(t){return t.y},_getOrthogonalPos:function(t){return t.x},resize:function(t){if(!(t<this._headerWidth)){var e=s.DomUtil.get("spreadsheet-header-columns-container"),i=s.DomUtil.get("document-container");this._setCornerCanvasWidth(t);var n=t-this._canvas.width,o=parseInt(s.DomUtil.getStyle(e,"left"))+n,a=parseInt(s.DomUtil.getStyle(i,"left"))+n;s.DomUtil.setStyle(e,"left",o+"px"),s.DomUtil.setStyle(i,"left",a+"px"),this._setCanvasWidth(t),this._map.fire("updatecornerheader")}}}),s.control.rowHeader=function(t){return new s.Control.RowHeader(t)},s.Control.MetricInput=s.Control.extend({options:{position:"topmiddle",title:""},initialize:function(t,e,i,n){s.setOptions(this,n),this._callback=t,this._context=e,this._default=i},onAdd:function(){return this._initLayout(),this._container},_initLayout:function(){var t="leaflet-control-layers",i=this._container=s.DomUtil.create("div",t);i.style.visibility="hidden";var n=s.DomUtil.create("a","leaflet-popup-close-button",i);n.href="#close",n.innerHTML="&#215;",s.DomEvent.on(n,"click",this._onCloseButtonClick,this);var o=s.DomUtil.create("div","leaflet-popup-content-wrapper",i),a=s.DomUtil.create("div","leaflet-popup-content",o),r=e.createElement("span");r.innerHTML="<b>"+this.options.title+" "+_("(100th/mm)")+"</b>",a.appendChild(r),a.appendChild(e.createElement("br")),a.appendChild(e.createElement("br"));var l=e.createElement("span");l.innerHTML=_("Add: "),a.appendChild(l);var h=this._input=e.createElement("input");h.type="text",h.value=this._default,a.appendChild(h),a.appendChild(e.createElement("br")),a.appendChild(e.createElement("br"));var d=e.createElement("input");d.type="checkbox",d.checked=!0,s.DomEvent.on(d,"click",this._onDefaultClick,this),a.appendChild(d);var u=e.createElement("span");u.innerHTML=_("Default value"),a.appendChild(u),a.appendChild(e.createElement("br")),a.appendChild(e.createElement("br"));var c=e.createElement("input");c.type="button",c.value=_("Submit"),s.DomEvent.on(c,"click",this._onOKButtonClick,this),a.appendChild(c)},onRemove:function(){this._input=null},show:function(){this._container.style.marginLeft=-this._container.offsetWidth/2+"px",this._container.style.visibility="",this._input.focus()},_onDefaultClick:function(){this._input.value=this._default},_onOKButtonClick:function(){var t=parseFloat(this._input.value);this.remove(),this._callback.call(this._context,{type:"submit",value:t})},_onCloseButtonClick:function(){this.remove(),this._callback.call(this._context,{type:"close"})}}),s.control.metricInput=function(t,e,i,n){return new s.Control.MetricInput(t,e,i,n)},s.Control.DocumentRepair=s.Control.extend({options:{position:"topright"},initialize:function(t){s.setOptions(this,t)},onAdd:function(){return this._initLayout(),this._container},_initLayout:function(){this._container=s.DomUtil.create("div","leaflet-control-layers"),this._container.style.visibility="hidden";var t=s.DomUtil.create("a","leaflet-popup-close-button",this._container);t.href="#close",t.innerHTML="&#215;",s.DomEvent.on(t,"click",this._onCloseClick,this);var i=s.DomUtil.create("div","leaflet-popup-content-wrapper",this._container),n=s.DomUtil.create("div","leaflet-popup-content",i),o=e.createElement("span");o.innerHTML="<b>"+_("Repair Document")+"</b>",n.appendChild(o),n.appendChild(e.createElement("br")),n.appendChild(e.createElement("br"));var a=s.DomUtil.create("table","",n),r=this._tbody=s.DomUtil.create("tbody","",a),l=s.DomUtil.create("tr","",r),h=s.DomUtil.create("th","",l);s.DomUtil.setStyle(h,"display","none"),h.appendChild(e.createTextNode("")),h=s.DomUtil.create("th","",l),h.appendChild(e.createTextNode(_("Type"))),h=s.DomUtil.create("th","",l),h.appendChild(e.createTextNode(_("Index"))),h=s.DomUtil.create("th","",l),h.appendChild(e.createTextNode(_("Comment"))),h=s.DomUtil.create("th","",l),h.appendChild(e.createTextNode(_("User name"))),h=s.DomUtil.create("th","",l),h.appendChild(e.createTextNode(_("Timestamp")));var d=e.createElement("input");d.type="button",d.value=_("Jump to state"),s.DomEvent.on(d,"click",this._onJumpClick,this),n.appendChild(e.createElement("br")),n.appendChild(e.createElement("br")),n.appendChild(d)},createAction:function(t,i,n,o,a){var r=s.DomUtil.create("tr","",this._tbody),l=s.DomUtil.create("td","",r);s.DomUtil.setStyle(l,"display","none"),l.appendChild(e.createTextNode(t)),l=s.DomUtil.create("td","",r),l.appendChild(e.createTextNode(_UNO(".uno:"+t))),l=s.DomUtil.create("td","",r),l.appendChild(e.createTextNode(i)),l=s.DomUtil.create("td","",r),l.appendChild(e.createTextNode(n)),l=s.DomUtil.create("td","",r),l.appendChild(e.createTextNode(o)),l=s.DomUtil.create("td","",r);var h=$.timeago(a.replace(/,.*/,"Z")),d=e.createElement("span");d.title=a,d.appendChild(e.createTextNode(h)),l.appendChild(d),s.DomEvent.on(r,"click",this._onRowClick,this),s.DomEvent.on(r,"dblclick",this._onJumpClick,this)},fillAction:function(t,e){for(var i=0;i<t.length;++i){var n=t[i].userName?t[i].userName:"";parseInt(t[i].viewId)===this._map._docLayer._viewId&&(n=_("You")),this.createAction(e,t[i].index,t[i].comment,n,t[i].dateTime)}},fillActions:function(t){this.fillAction(t.Redo.actions,"Redo"),this.fillAction(t.Undo.actions,"Undo")},show:function(){this._tbody.setAttribute("style","max-height:"+this._map.getSize().y/2+"px"),this._container.style.visibility=""},_selectRow:function(t){this._selected&&s.DomUtil.removeClass(this._selected,"leaflet-popup-selected"),this._selected=t,s.DomUtil.addClass(this._selected,"leaflet-popup-selected")},_onCloseClick:function(){this._map.enable(!0),this._refocusOnMap(),this.remove()},_onRowClick:function(t){t.currentTarget&&this._selected!==t.currentTarget&&this._selectRow(t.currentTarget)},_onJumpClick:function(){if(this._selected){var t=this._selected.childNodes[0].innerHTML,e=parseInt(this._selected.childNodes[2].innerHTML),i={Repair:{type:"boolean",value:!0}};i[t]={type:"unsigned short",value:e+1},this._map.sendUnoCommand(".uno:"+t,i),this._onCloseClick()}}}),s.control.documentRepair=function(t){return new s.Control.DocumentRepair(t)},s.Control.ContextMenu=s.Control.extend({options:{SEPARATOR:"---------",whitelist:{general:["Cut","Copy","Paste","PasteSpecialMenu","PasteUnformatted","NumberingStart","ContinueNumbering","IncrementLevel","DecrementLevel","OpenHyperlinkOnCursor","CopyHyperlinkLocation","RemoveHyperlink","AnchorMenu","SetAnchorToPage","SetAnchorToPara","SetAnchorAtChar","SetAnchorToChar","SetAnchorToFrame","WrapMenu","WrapOff","WrapOn","WrapIdeal","WrapLeft","WrapRight","WrapThrough","WrapThroughTransparent","WrapContour","WrapAnchorOnly","ArrangeFrameMenu","ArrangeMenu","BringToFront","ObjectForwardOne","ObjectBackOne","SendToBack","RotateMenu","RotateLeft","RotateRight"],text:["TableInsertMenu","InsertRowsBefore","InsertRowsAfter","InsertColumnsBefore","InsertColumnsAfter","TableDeleteMenu","DeleteRows","DeleteColumns","DeleteTable","MergeCells","SetOptimalColumnWidth","SetOptimalRowHeight","UpdateCurIndex","RemoveTableOf","ReplyComment","DeleteComment","DeleteAuthor","DeleteAllNotes"],spreadsheet:["MergeCells","SplitCell","RecalcPivotTable","FormatCellDialog"],presentation:["TransformDialog","FormatLine","FormatArea"],drawing:[]}},onAdd:function(t){this._prevMousePos=null,t.on("locontextmenu",this._onContextMenu,this),t.on("mousedown",this._onMouseDown,this),t.on("keydown",this._onKeyDown,this)},_onMouseDown:function(t){this._prevMousePos={x:t.originalEvent.pageX,y:t.originalEvent.pageY},$.contextMenu("destroy",".leaflet-layer")},_onKeyDown:function(t){27===t.originalEvent.keyCode&&$.contextMenu("destroy",".leaflet-layer")},_onContextMenu:function(t){if("edit"===map._permission){var e=this._createContextMenuStructure(t);$.contextMenu({selector:".leaflet-layer",className:"loleaflet-font",trigger:"none",build:function(){return{callback:function(t){map.sendUnoCommand(t),map.focus()},items:e}}}),$(".leaflet-layer").contextMenu(this._prevMousePos)}},_createContextMenuStructure:function(t){var e,n=map.getDocType(),o={},s=1,a=!1;for(var r in t.menu){var l=t.menu[r];if("false"!==l.enabled)if("separator"===l.type)a&&(o["sep"+s++]=this.options.SEPARATOR),a=!1;else if("command"===l.type){var h=l.command.substring(5);if(!(-1!==this.options.whitelist.general.indexOf(h)||"text"===n&&-1!==this.options.whitelist.text.indexOf(h)||"spreadsheet"===n&&-1!==this.options.whitelist.spreadsheet.indexOf(h)||"presentation"===n&&-1!==this.options.whitelist.presentation.indexOf(h)||"drawing"===n&&-1!==this.options.whitelist.drawing.indexOf(h)))continue;switch(e=_UNO(l.command,n,!0),h){case"Cut":e=_("Internal Cut");break;case"Copy":e=_("Internal Copy");break;case"Paste":e=_("Internal Paste")}o[l.command]={name:_(e)},"checkmark"===l.checktype?"true"===l.checked&&(o[l.command].icon="lo-checkmark"):"radio"===l.checktype&&"true"===l.checked&&(o[l.command].icon="radio"),a=!0}else if("menu"===l.type){e=l.text.replace("~",""),"Paste Special"===e&&(e=_("Internal Paste Special"));var d=this._createContextMenuStructure(l);if(0===Object.keys(d).length)continue;o[l.command]={name:_(e),items:d},a=!0}}var u=Object.keys(o)[Object.keys(o).length-1];return u!==i&&u.startsWith("sep")&&delete o[u],o}}),s.control.contextMenu=function(t){return new s.Control.ContextMenu(t)},s.Control.Menubar=s.Control.extend({options:{initial:[{name:_UNO(".uno:PickList"),disabled:!0},{name:_UNO(".uno:EditMenu"),disabled:!0},{name:_UNO(".uno:ViewMenu"),disabled:!0},{name:_UNO(".uno:InsertMenu"),disabled:!0},{name:_UNO(".uno:ToolsMenu"),disabled:!0}],text:[{name:_UNO(".uno:PickList","text"),id:"file",type:"menu",menu:[{name:_UNO(".uno:Save","text"),id:"save",type:"action"},{name:_UNO(".uno:SaveAs","text"),id:"saveas",type:"action"},{name:_UNO(".uno:Print","text"),id:"print",type:"action"},{name:_("See revision history"),id:"rev-history",type:"action"},{name:_("Download as"),id:"downloadas",type:"menu",menu:[{name:_("PDF Document (.pdf)"),id:"downloadas-pdf",type:"action"},{name:_("ODF text document (.odt)"),id:"downloadas-odt",type:"action"},{name:_("Microsoft Word 2003 (.doc)"),id:"downloadas-doc",type:"action"},{name:_("Microsoft Word (.docx)"),id:"downloadas-docx",type:"action"}]},{type:"separator"},{uno:".uno:SetDocumentProperties"}]},{name:_UNO(".uno:EditMenu","text"),type:"menu",menu:[{uno:".uno:Undo"},{uno:".uno:Redo"},{name:_("Repair"),id:"repair",type:"action"},{type:"separator"},{uno:".uno:Cut"},{uno:".uno:Copy"},{uno:".uno:Paste"},{uno:".uno:SelectAll"},{type:"separator"},{uno:".uno:SearchDialog"},{type:"separator"},{name:_UNO(".uno:ChangesMenu","text"),type:"menu",menu:[{uno:".uno:TrackChanges"},{uno:".uno:ShowTrackedChanges"},{type:"separator"},{uno:".uno:AcceptTrackedChanges"},{uno:".uno:AcceptAllTrackedChanges"},{uno:".uno:RejectAllTrackedChanges"},{uno:".uno:PreviousTrackedChange"},{uno:".uno:NextTrackedChange"}]},{uno:".uno:EditStyle"}]},{name:_UNO(".uno:ViewMenu","text"),id:"view",type:"menu",menu:[{name:_UNO(".uno:FullScreen","text"),id:"fullscreen",type:"action"},{type:"separator"},{name:_UNO(".uno:ZoomPlus","text"),id:"zoomin",type:"action"},{name:_UNO(".uno:ZoomMinus","text"),id:"zoomout",type:"action"},{name:_("Reset zoom"),id:"zoomreset",type:"action"},{type:"separator"},{uno:".uno:ControlCodes"}]},{name:_UNO(".uno:InsertMenu","text"),type:"menu",menu:[{name:_UNO(".uno:InsertGraphic","text"),id:"insertgraphic",type:"action"},{name:_UNO(".uno:InsertAnnotation","text"),id:"insertcomment",type:"action"},{type:"separator"},{name:_UNO(".uno:InsertHeaderFooterMenu","text"),type:"menu",menu:[{uno:".uno:InsertPageHeader",type:"menu",menu:[{name:_("All"),disabled:!0,id:"insertheader",tag:"_ALL_",uno:".uno:InsertPageHeader?"}]},{uno:".uno:InsertPageFooter",type:"menu",menu:[{name:_("All"),disabled:!0,id:"insertfooter",tag:"_ALL_",uno:".uno:InsertPageFooter?"}]}]},{uno:".uno:InsertFootnote"},{uno:".uno:InsertEndnote"},{type:"separator"},{uno:".uno:InsertPagebreak"},{uno:".uno:InsertColumnBreak"},{type:"separator"},{uno:".uno:HyperlinkDialog"},{uno:".uno:InsertSymbol"},{name:_UNO(".uno:FormattingMarkMenu","text"),type:"menu",menu:[{uno:".uno:InsertNonBreakingSpace"},{uno:".uno:InsertHardHyphen"},{uno:".uno:InsertSoftHyphen"},{uno:".uno:InsertZWSP"},{uno:".uno:InsertZWNBSP"},{uno:".uno:InsertLRM"},{uno:".uno:InsertRLM"}]},{uno:".uno:InsertIndexesEntry"}]},{name:_UNO(".uno:FormatMenu","text"),type:"menu",menu:[{name:_UNO(".uno:FormatTextMenu","text"),type:"menu",menu:[{uno:".uno:Bold"},{uno:".uno:Italic"},{uno:".uno:Underline"},{uno:".uno:UnderlineDouble"},{uno:".uno:Strikeout"},{uno:".uno:Overline"},{type:"separator"},{uno:".uno:SuperScript"},{uno:".uno:SubScript"},{uno:".uno:SmallCaps"},{type:"separator"},{uno:".uno:Shadowed"},{uno:".uno:OutlineFont"},{type:"separator"},{uno:".uno:Grow"},{uno:".uno:Shrink"},{type:"separator"},{uno:".uno:ChangeCaseToUpper"},{uno:".uno:ChangeCaseToLower"},{uno:".uno:ChangeCaseRotateCase"},{type:"separator"},{uno:".uno:ChangeCaseToSentenceCase"},{uno:".uno:ChangeCaseToTitleCase"},{uno:".uno:ChangeCaseToToggleCase"}]},{name:_("Text orientation"),type:"menu",menu:[{uno:".uno:ParaLeftToRight"},{uno:".uno:ParaRightToLeft"}]},{name:_UNO(".uno:FormatSpacingMenu","text"),type:"menu",menu:[{uno:".uno:SpacePara1"},{uno:".uno:SpacePara15"},{uno:".uno:SpacePara2"},{type:"separator"},{uno:".uno:ParaspaceIncrease"},{uno:".uno:ParaspaceDecrease"},{type:"separator"},{uno:".uno:IncrementIndent"},{uno:".uno:DecrementIndent"}]},{name:_UNO(".uno:TextAlign","text"),type:"menu",menu:[{uno:".uno:CommonAlignLeft"},{uno:".uno:CommonAlignHorizontalCenter"},{uno:".uno:CommonAlignRight"},{uno:".uno:CommonAlignJustified"},{type:"separator"},{uno:".uno:CommonAlignTop"},{uno:".uno:CommonAlignVerticalCenter"},{uno:".uno:CommonAlignBottom"}]},{name:_UNO(".uno:FormatBulletsMenu","text"),type:"menu",menu:[{uno:".uno:DefaultBullet"},{uno:".uno:DefaultNumbering"},{type:"separator"},{uno:".uno:DecrementLevel"},{uno:".uno:IncrementLevel"},{uno:".uno:DecrementSubLevels"},{uno:".uno:IncrementSubLevels"},{type:"separator"},{uno:".uno:MoveDown"},{uno:".uno:MoveUp"},{uno:".uno:MoveDownSubItems"},{uno:".uno:MoveUpSubItems"},{type:"separator"},{uno:".uno:InsertNeutralParagraph"},{uno:".uno:NumberingStart"},{type:"separator"},{uno:".uno:JumpDownThisLevel"},{uno:".uno:JumpUpThisLevel"},{uno:".uno:ContinueNumbering"}]},{type:"separator"},{uno:".uno:FontDialog"},{uno:".uno:ParagraphDialog"},{uno:".uno:OutlineBullet"},{uno:".uno:PageDialog"},{type:"separator"},{uno:".uno:ResetAttributes"}]},{name:_UNO(".uno:TableMenu","text"),type:"menu",menu:[{name:_UNO(".uno:TableInsertMenu","text"),type:"menu",menu:[{uno:".uno:InsertRowsBefore"},{uno:".uno:InsertRowsAfter"},{type:"separator"},{uno:".uno:InsertColumnsBefore"},{uno:".uno:InsertColumnsAfter"}]},{name:_UNO(".uno:TableDeleteMenu","text"),type:"menu",menu:[{uno:".uno:DeleteRows"},{uno:".uno:DeleteColumns"},{uno:".uno:DeleteTable"}]},{name:_UNO(".uno:TableSelectMenu","text"),type:"menu",menu:[{uno:".uno:SelectTable"},{uno:".uno:EntireRow"},{uno:".uno:EntireColumn"},{uno:".uno:EntireCell"}]},{uno:".uno:MergeCells"},{type:"separator"},{uno:".uno:TableDialog"}]},{name:_UNO(".uno:ToolsMenu","text"),id:"tools",type:"menu",menu:[{uno:".uno:SpellingAndGrammarDialog"},{uno:".uno:SpellOnline"},{name:_UNO(".uno:LanguageMenu"),type:"menu",menu:[{name:_UNO(".uno:SetLanguageSelectionMenu","text"),type:"menu",menu:[{name:_("None (Do not check spelling)"),id:"noneselection",uno:".uno:LanguageStatus?Language:string=Current_LANGUAGE_NONE"}]},{name:_UNO(".uno:SetLanguageParagraphMenu","text"),type:"menu",menu:[{name:_("None (Do not check spelling)"),id:"noneparagraph",uno:".uno:LanguageStatus?Language:string=Paragraph_LANGUAGE_NONE"}]},{name:_UNO(".uno:SetLanguageAllTextMenu","text"),type:"menu",menu:[{name:_("None (Do not check spelling)"),id:"nonelanguage",uno:".uno:LanguageStatus?Language:string=Default_LANGUAGE_NONE"}]}]},{uno:".uno:WordCountDialog"}]},{name:_UNO(".uno:HelpMenu","text"),id:"help",type:"menu",menu:[{name:_("Keyboard shortcuts"),id:"keyboard-shortcuts",type:"action"},{name:_("About"),id:"about",type:"action"}]},{name:_("Close document"),id:"closedocument",type:"action"}],presentation:[{name:_UNO(".uno:PickList","presentation"),id:"file",type:"menu",menu:[{name:_UNO(".uno:Save","presentation"),id:"save",type:"action"},{name:_UNO(".uno:SaveAs","presentation"),id:"saveas",type:"action"},{name:_UNO(".uno:Print","presentation"),id:"print",type:"action"},{name:_("See revision history"),id:"rev-history",type:"action"},{name:_("Download as"),id:"downloadas",type:"menu",menu:[{name:_("PDF Document (.pdf)"),id:"downloadas-pdf",type:"action"},{name:_("ODF presentation (.odp)"),id:"downloadas-odp",type:"action"},{name:_("Microsoft Powerpoint 2003 (.ppt)"),id:"downloadas-ppt",type:"action"},{name:_("Microsoft Powerpoint (.pptx)"),id:"downloadas-pptx",type:"action"}]},{type:"separator"},{uno:".uno:SetDocumentProperties"}]},{name:_UNO(".uno:EditMenu","presentation"),type:"menu",menu:[{uno:".uno:Undo"},{uno:".uno:Redo"},{name:_("Repair"),id:"repair",type:"action"},{type:"separator"},{uno:".uno:Cut"},{uno:".uno:Copy"},{uno:".uno:Paste"},{uno:".uno:SelectAll"},{type:"separator"},{uno:".uno:SearchDialog"}]},{name:_UNO(".uno:ViewMenu","presentation"),id:"view",type:"menu",menu:[{name:_UNO(".uno:FullScreen","presentation"),id:"fullscreen",type:"action"},{type:"separator"},{name:_UNO(".uno:ZoomPlus","presentation"),id:"zoomin",type:"action"},{name:_UNO(".uno:ZoomMinus","presentation"),id:"zoomout",type:"action"},{name:_("Reset zoom"),id:"zoomreset",type:"action"}]},{name:_UNO(".uno:InsertMenu","presentation"),type:"menu",menu:[{name:_UNO(".uno:InsertGraphic","presentation"),id:"insertgraphic",type:"action"},{name:_UNO(".uno:InsertAnnotation","presentation"),id:"insertcomment",type:"action"},{type:"separator"},{uno:".uno:InsertSymbol"}]},{name:_UNO(".uno:FormatMenu","presentation"),type:"menu",menu:[{name:_UNO(".uno:FormatObjectMenu","presentation"),type:"menu",menu:[{uno:".uno:TransformDialog"},{uno:".uno:FormatLine"},{uno:".uno:FormatArea"}]}]},{name:_UNO(".uno:TableMenu","text"),type:"menu",menu:[{name:_UNO(".uno:TableInsertMenu","text"),type:"menu",menu:[{uno:".uno:InsertRowsBefore"},{uno:".uno:InsertRowsAfter"},{type:"separator"},{uno:".uno:InsertColumnsBefore"},{uno:".uno:InsertColumnsAfter"}]},{name:_UNO(".uno:TableDeleteMenu","text"),type:"menu",menu:[{uno:".uno:DeleteRows"},{uno:".uno:DeleteColumns"}]},{uno:".uno:MergeCells"}]},{name:_UNO(".uno:SlideMenu","presentation"),type:"menu",menu:[{name:_UNO(".uno:InsertSlide","presentation"),id:"insertpage",type:"action"},{name:_UNO(".uno:DuplicateSlide","presentation"),id:"duplicatepage",type:"action"},{name:_UNO(".uno:DeleteSlide","presentation"),id:"deletepage",type:"action"},{type:"separator",id:"fullscreen-presentation-separator"},{name:_("Fullscreen presentation"),id:"fullscreen-presentation",type:"action"}]},{name:_UNO(".uno:ToolsMenu","presentation"),id:"tools",type:"menu",menu:[{uno:".uno:SpellOnline"},{name:_UNO(".uno:LanguageMenu"),type:"menu",menu:[{name:_("None (Do not check spelling)"),id:"nonelanguage",uno:".uno:LanguageStatus?Language:string=Default_LANGUAGE_NONE"}]}]},{name:_UNO(".uno:HelpMenu","presentation"),id:"help",type:"menu",menu:[{name:_("Keyboard shortcuts"),id:"keyboard-shortcuts",type:"action"},{name:_("About"),id:"about",type:"action"}]},{name:_("Close document"),id:"closedocument",type:"action"}],spreadsheet:[{name:_UNO(".uno:PickList","spreadsheet"),id:"file",type:"menu",menu:[{name:_UNO(".uno:Save","spreadsheet"),id:"save",type:"action"},{name:_UNO(".uno:SaveAs","spreadsheet"),id:"saveas",type:"action"},{name:_UNO(".uno:Print","spreadsheet"),id:"print",type:"action"},{name:_("See revision history"),id:"rev-history",type:"action"},{name:_("Download as"),id:"downloadas",type:"menu",menu:[{name:_("PDF Document (.pdf)"),id:"downloadas-pdf",type:"action"},{name:_("ODF spreadsheet (.ods)"),id:"downloadas-ods",type:"action"},{name:_("Microsoft Excel 2003 (.xls)"),id:"downloadas-xls",type:"action"},{name:_("Microsoft Excel (.xlsx)"),id:"downloadas-xlsx",type:"action"}]},{type:"separator"},{uno:".uno:SetDocumentProperties"}]},{name:_UNO(".uno:EditMenu","spreadsheet"),type:"menu",menu:[{uno:".uno:Undo"},{uno:".uno:Redo"},{name:_("Repair"),id:"repair",type:"action"},{type:"separator"},{uno:".uno:Cut"},{uno:".uno:Copy"},{uno:".uno:Paste"},{uno:".uno:SelectAll"},{type:"separator"},{uno:".uno:SearchDialog"}]},{name:_UNO(".uno:ViewMenu","spreadsheet"),id:"view",type:"menu",menu:[{name:_UNO(".uno:FullScreen","spreadsheet"),id:"fullscreen",type:"action"}]},{name:_UNO(".uno:InsertMenu","spreadsheet"),type:"menu",menu:[{name:_UNO(".uno:InsertGraphic","spreadsheet"),id:"insertgraphic",type:"action"},{name:_UNO(".uno:InsertAnnotation","spreadsheet"),id:"insertcomment",type:"action"},{type:"separator"},{uno:".uno:InsertSymbol"}]},{name:_UNO(".uno:FormatMenu","spreadsheet"),type:"menu",menu:[{uno:".uno:ResetAttributes"},{uno:".uno:FormatCellDialog"}]},{name:_UNO(".uno:SheetMenu","spreadsheet"),type:"menu",menu:[{name:_UNO(".uno:InsertRowsMenu","spreadsheet"),type:"menu",menu:[{uno:".uno:InsertRowsBefore"},{uno:".uno:InsertRowsAfter"}]},{name:_UNO(".uno:InsertColumnsMenu","spreadsheet"),type:"menu",menu:[{uno:".uno:InsertColumnsBefore"},{uno:".uno:InsertColumnsAfter"}]},{name:_UNO(".uno:InsertBreakMenu","spreadsheet"),type:"menu",menu:[{uno:".uno:InsertRowBreak"},{uno:".uno:InsertColumnBreak"}]},{type:"separator"},{uno:".uno:DeleteRows"},{uno:".uno:DeleteColumns"},{name:_UNO(".uno:DelBreakMenu","spreadsheet"),type:"menu",menu:[{uno:".uno:DeleteRowbreak"},{uno:".uno:DeleteColumnbreak"}]}]},{name:_UNO(".uno:DataMenu","spreadsheet"),type:"menu",menu:[{uno:".uno:DataSort"},{uno:".uno:SortAscending"},{uno:".uno:SortDescending"},{type:"separator"},{uno:".uno:DataFilterAutoFilter"},{name:_UNO(".uno:FilterMenu","spreadsheet"),type:"menu",menu:[{uno:".uno:DataFilterStandardFilter"},{uno:".uno:DataFilterSpecialFilter"},{type:"separator"},{uno:".uno:DataFilterRemoveFilter"},{uno:".uno:DataFilterHideAutoFilter"}]},{type:"separator"},{name:_UNO(".uno:GroupOutlineMenu","spreadsheet"),type:"menu",menu:[{uno:".uno:Group"},{uno:".uno:Ungroup"},{type:"separator"},{uno:".uno:ClearOutline"},{type:"separator"},{uno:".uno:HideDetail"},{uno:".uno:ShowDetail"}]}]},{name:_UNO(".uno:ToolsMenu","spreadsheet"),id:"tools",type:"menu",menu:[{uno:".uno:SpellOnline"},{name:_UNO(".uno:LanguageMenu"),type:"menu",menu:[{name:_("None (Do not check spelling)"),id:"nonelanguage",uno:".uno:LanguageStatus?Language:string=Default_LANGUAGE_NONE"}]}]},{name:_UNO(".uno:HelpMenu","spreadsheet"),id:"help",type:"menu",menu:[{name:_("Keyboard shortcuts"),id:"keyboard-shortcuts",type:"action"},{name:_("About"),id:"about",type:"action"}]},{name:_("Close document"),id:"closedocument",type:"action"}],commandStates:{},allowedReadonlyMenus:["file","downloadas","view","help"],allowedViewModeActions:["downloadas-pdf","downloadas-odt","downloadas-doc","downloadas-docx","downloadas-odp","downloadas-ppt","downloadas-pptx","downloadas-ods","downloadas-xls","downloadas-xlsx","fullscreen","zoomin","zoomout","zoomreset","about","keyboard-shortcuts"]},onAdd:function(t){this._initialized=!1,this._menubarCont=s.DomUtil.get("main-menu"),this._initializeMenu(this.options.initial),t.on("doclayerinit",this._onDocLayerInit,this),t.on("addmenu",this._addMenu,this),t.on("commandvalues",this._onInitMenu,this),t.on("updatetoolbarcommandvalues",this._onStyleMenu,this)},_addMenu:function(t){var e=s.DomUtil.get("menu-"+t.id);if(!e){var i=s.DomUtil.create("li","");i.id="menu-"+t.id,"readonly"===map._permission&&s.DomUtil.addClass(i,"readonly");var n=s.DomUtil.create("a","",i);$(n).text(t.label),$(n).data("id",t.id),$(n).data("type","action"),$(n).data("postmessage","true"),this._menubarCont.insertBefore(i,this._menubarCont.firstChild)}},_createUnoMenuItem:function(t,e,i){var n,o;return n=s.DomUtil.create("li",""),o=s.DomUtil.create("a","",n),$(o).text(t),$(o).data("type","unocommand"),$(o).data("uno",e),$(o).data("tag",i),n},_onInitMenu:function(t){if(".uno:LanguageStatus"===t.commandName&&s.Util.isArray(t.commandValues)){var e,i,n="Default_RESET_LANGUAGES",o="Current_RESET_LANGUAGES",a="Paragraph_RESET_LANGUAGES",r=".uno:LanguageStatus?Language:string=",l=_("Reset to Default Language"),h=[];t.commandValues.forEach(function(t){h.push({translated:_(t),neutral:t})}),h.sort(function(t,e){return t.translated<e.translated?-1:t.translated>e.translated?1:0});var d=$("#menu-noneselection").parent(),u=$("#menu-noneparagraph").parent(),c=$("#menu-nonelanguage").parent();for(var p in h)e=h[p].translated,i=h[p].neutral,d.append(this._createUnoMenuItem(e,r+encodeURIComponent("Current_"+i))),u.append(this._createUnoMenuItem(e,r+encodeURIComponent("Paragraph_"+i))),c.append(this._createUnoMenuItem(e,r+encodeURIComponent("Default_"+i)));d.append(this._createMenu([{type:"separator"}])),u.append(this._createMenu([{type:"separator"}])),c.append(this._createMenu([{type:"separator"}])),d.append(this._createUnoMenuItem(l,r+o)),u.append(this._createUnoMenuItem(l,r+a)),c.append(this._createUnoMenuItem(l,r+n))}},_onStyleMenu:function(t){if(".uno:StyleApply"===t.commandName){var e,i="&",n=".uno:InsertPageHeader?PageStyle:string=",o=".uno:InsertPageFooter?PageStyle:string=",s=$("#menu-insertheader").parent(),a=$("#menu-insertfooter").parent(),r=t.commandValues.HeaderFooter;for(var l in r)e=r[l],s.append(this._createUnoMenuItem(_(e),n+encodeURIComponent(e)+i,e)),a.append(this._createUnoMenuItem(_(e),o+encodeURIComponent(e)+i,e))}},_onDocLayerInit:function(){for(;this._menubarCont.hasChildNodes();)this._menubarCont.removeChild(this._menubarCont.firstChild);var e=this._map.getDocType();"text"===e?this._initializeMenu(this.options.text):"spreadsheet"===e?this._initializeMenu(this.options.spreadsheet):("presentation"===e||"drawing"===e)&&this._initializeMenu(this.options.presentation),$("#main-menu").smartmenus({hideOnClick:!0,showOnClick:!0,hideTimeout:0,hideDuration:0,showDuration:0,showTimeout:0,collapsibleHideDuration:0,subIndicatorsPos:"append",subIndicatorsText:"&#8250;"}),$("#main-menu").attr("tabindex",0),$("#main-menu").bind("select.smapi",{self:this},this._onItemSelected),$("#main-menu").bind("beforeshow.smapi",{self:this},this._beforeShow),$("#main-menu").bind("click.smapi",{self:this},this._onClicked),$(function(){var e=$("#main-menu-state");e.length&&(e.change(function(){var t=$("#main-menu");this.checked?t.hide().slideDown(250,function(){t.css("display","")}):t.show().slideUp(250,function(){t.css("display","")})}),$(t).bind("beforeunload unload",function(){
e[0].checked&&e[0].click()}))}),this._initialized=!0},_onClicked:function(t,e){$(e).hasClass("highlighted")&&$("#main-menu").smartmenus("menuHideAll");var i=$("#main-menu-state");!$(e).hasClass("has-submenu")&&i[0].checked&&i[0].click()},_checkedMenu:function(t,e){var i="lo-menu-item-checked",n=map.stateChangeHandler.getItemValue(t),o=$(e).data("tag");n=n[o]||!1,n?$(e).addClass(i):$(e).removeClass(i)},_beforeShow:function(t,e){var i=t.data.self,n=$(e).children().children("a").not(".has-submenu");$(n).each(function(){var t=this,e=$(t).data("type"),n=$(t).data("id");if("edit"===map._permission){if("unocommand"===e){var o,a,r="uno",l="stateChangeHandler",h="lo-menu-item-checked",d=".uno:LanguageStatus",u=".uno:InsertPageHeader",c=".uno:InsertPageFooter",_=$(t).data(r),p=map[l].getItemValue(_);"disabled"===p?$(t).addClass("disabled"):$(t).removeClass("disabled"),_.startsWith(d)?(_=d,a=map[l].getItemValue(_),o=decodeURIComponent($(t).data(r)),-1!==o.indexOf(a)?$(t).addClass(h):-1!==o.indexOf("LANGUAGE_NONE")&&"[None]"===a?$(t).addClass(h):$(t).removeClass(h)):_.startsWith(u)?(_=u,i._checkedMenu(_,this)):_.startsWith(c)?(_=c,i._checkedMenu(_,this)):"true"===p?$(t).addClass(h):$(t).removeClass(h)}else if("action"===e)if("fullscreen"===n&&(s.Browser.ie||s.Browser.edge)){$(t).addClass("disabled");var m=i.options.allowedViewModeActions.indexOf("fullscreen");m>0&&i.options.allowedViewModeActions.splice(m,1)}else $(t).removeClass("disabled")}else if("unocommand"===e)$(t).addClass("disabled");else if("action"===e){var g=!1;for(var f in i.options.allowedViewModeActions)if(i.options.allowedViewModeActions[f]===n){g=!0;break}g?$(t).removeClass("disabled"):$(t).addClass("disabled")}})},_executeAction:function(t){var i=$(t).data("id");if("save"===i)map.save(!0,!0);else if("saveas"===i)map.fire("postMessage",{msgId:"UI_SaveAs"});else if("print"===i)map.print();else if(i.startsWith("downloadas-")){var n=i.substring("downloadas-".length),o=map.wopi.BaseFileName;o=o.substr(0,o.lastIndexOf(".")),o=""===o?"document":o,map.downloadAs(o+"."+n,n)}else"insertcomment"===i?map.insertComment():"insertgraphic"===i?s.DomUtil.get("insertgraphic").click():"zoomin"===i&&map.getZoom()<map.getMaxZoom()?map.zoomIn(1):"zoomout"===i&&map.getZoom()>map.getMinZoom()?map.zoomOut(1):"zoomreset"===i?map.setZoom(map.options.zoom):"fullscreen"===i?e.fullscreenElement||e.mozFullscreenElement||e.msFullscreenElement||e.webkitFullscreenElement?e.exitFullscreen?e.exitFullscreen():e.msExitFullscreen?e.msExitFullscreen():e.mozCancelFullScreen?e.mozCancelFullScreen():e.webkitExitFullscreen&&e.webkitExitFullscreen():e.documentElement.requestFullscreen?e.documentElement.requestFullscreen():e.documentElement.msRequestFullscreen?e.documentElement.msRequestFullscreen():e.documentElement.mozRequestFullScreen?e.documentElement.mozRequestFullScreen():e.documentElement.webkitRequestFullscreen&&e.documentElement.webkitRequestFullscreen(Element.ALLOW_KEYBOARD_INPUT):"fullscreen-presentation"===i&&"presentation"===map.getDocType()?map.fire("fullscreen"):"insertpage"===i?map.insertPage():"duplicatepage"===i?map.duplicatePage():"deletepage"===i?vex.dialog.confirm({message:_("Are you sure you want to delete this slide?"),callback:this._onDeleteSlide},this):"about"===i?map.showLOAboutDialog():"keyboard-shortcuts"===i?map.showLOKeyboardHelp():"rev-history"===i?(map.fire("postMessage",{msgId:"rev-history",args:{Deprecated:!0}}),map.fire("postMessage",{msgId:"UI_FileVersions"})):"closedocument"===i?(map.fire("postMessage",{msgId:"close",args:{EverModified:map._everModified,Deprecated:!0}}),map.fire("postMessage",{msgId:"UI_Close",args:{EverModified:map._everModified}}),map.remove()):"repair"===i&&map._socket.sendMessage("commandvalues command=.uno:DocumentRepair");"true"===$(t).data("postmessage")&&map.fire("postMessage",{msgId:"Clicked_Button",args:{Id:i}})},_sendCommand:function(t){var e=$(t).data("uno");(e.startsWith(".uno:InsertPageHeader")||e.startsWith(".uno:InsertPageFooter"))&&(e+=$(t).hasClass("lo-menu-item-checked")?"On:bool=false":"On:bool=true"),map.sendUnoCommand(e)},_onDeleteSlide:function(t){t&&map.deletePage()},_onItemSelected:function(t,e){var i=t.data.self,n=$(e).data("type");"unocommand"===n?i._sendCommand(e):"action"===n&&i._executeAction(e),"insertcomment"!==$(e).data("id")&&map.focus()},_createMenu:function(t){var e=[],n=this._map.getDocType();for(var o in t)if("about"!==t[o].id||null!==s.DomUtil.get("about-dialog")){if("readonly"===map._permission&&"menu"===t[o].type){var a=!1;for(var r in this.options.allowedReadonlyMenus)if(this.options.allowedReadonlyMenus[r]===t[o].id){a=!0;break}if(!a)continue}if(("action"!==t[o].type||("rev-history"!==t[o].id||revHistoryEnabled)&&("closedocument"!==t[o].id||closebutton))&&!("print"===t[o].id&&this._map.wopi.HidePrintOption||"save"===t[o].id&&this._map.wopi.HideSaveOption||"saveas"===t[o].id&&this._map.wopi.UserCanNotWriteRelative||t[o].id&&t[o].id.startsWith("fullscreen-presentation")&&this._map.wopi.HideExportOption)){if(t[o].id&&t[o].id.startsWith("downloadas-")){var l=t[o].id.substring("downloadas-".length);if(this._map._docLayer.registerExportFormat(t[o].name,l),this._map.wopi.HideExportOption)continue}var h=s.DomUtil.create("li","");t[o].id&&(h.id="menu-"+t[o].id,"closedocument"===t[o].id&&"readonly"===map._permission&&s.DomUtil.addClass(h,"readonly"));var d=s.DomUtil.create("a",t[o].disabled?"disabled":"",h);if(t[o].name!==i?d.innerHTML=t[o].name:t[o].uno!==i?d.innerHTML=_UNO(t[o].uno,n):d.innerHTML="","menu"===t[o].type){var u=s.DomUtil.create("ul","",h),c=this._createMenu(t[o].menu);if(!c.length)continue;for(var _ in c)u.appendChild(c[_])}else"unocommand"===t[o].type||t[o].uno!==i?($(d).data("type","unocommand"),$(d).data("uno",t[o].uno),$(d).data("tag",t[o].tag)):"separator"===t[o].type?$(d).addClass("separator"):"action"===t[o].type&&($(d).data("type","action"),$(d).data("id",t[o].id));e.push(h)}}return e},_initializeMenu:function(t){var e=this._createMenu(t);for(var i in e)this._menubarCont.appendChild(e[i])}}),s.control.menubar=function(t){return new s.Control.Menubar(t)},s.Control.Tabs=s.Control.extend({onAdd:function(t){t.on("updatepermission",this._onUpdatePermission,this),this._initialized=!1},_onUpdatePermission:function(t){"spreadsheet"===this._map.getDocType()&&(this._initialized||this._initialize(),setTimeout(function(){$(".spreadsheet-tab").contextMenu("edit"===t.perm)},1e3))},_initialize:function(){this._initialized=!0,this._tabsInitialized=!1,this._spreadsheetTabs={};var t=map.options.documentContainer;this._tabsCont=s.DomUtil.create("div","spreadsheet-tabs-container",t.parentElement),$.contextMenu({selector:".spreadsheet-tab",className:"loleaflet-font",callback:function(t,e){var i=parseInt(e.$trigger.attr("id").split("spreadsheet-tab")[1]);"insertsheetbefore"===t&&map.insertPage(i),"insertsheetafter"===t&&map.insertPage(i+1)},items:{insertsheetbefore:{name:_("Insert sheet before this")},insertsheetafter:{name:_("Insert sheet after this")},deletesheet:{name:_UNO(".uno:Remove","spreadsheet",!0),callback:function(t,e){var i=parseInt(e.$trigger.attr("id").split("spreadsheet-tab")[1]);vex.dialog.confirm({message:_("Are you sure you want to delete sheet, %sheet% ?").replace("%sheet%",e.$trigger.text()),callback:function(t){t&&map.deletePage(i)}})}},renamesheet:{name:_UNO(".uno:RenameTable","spreadsheet",!0),callback:function(t,e){var i=parseInt(e.$trigger.attr("id").split("spreadsheet-tab")[1]);vex.dialog.open({message:_("Enter new sheet name"),input:'<input name="sheetname" type="text" required />',callback:function(t){map.renamePage(t.sheetname,i)}})}}},zIndex:1e3}),map.on("updateparts",this._updateDisabled,this)},_updateDisabled:function(t){var e=t.parts,i=t.selectedPart,n=t.docType;if("text"!==n&&"spreadsheet"===n){if(!this._tabsInitialized){var o=this._map.options.documentContainer;s.DomUtil.addClass(o,"spreadsheet-document"),setTimeout(s.bind(function(){this._map.invalidateSize(),$(".scroll-container").mCustomScrollbar("update"),$(".scroll-container").mCustomScrollbar("scrollTo",[0,0])},this),100),this._tabsInitialized=!0}if("partNames"in t){for(;this._tabsCont.firstChild;)this._tabsCont.removeChild(this._tabsCont.firstChild);var a=s.DomUtil.create("div","spreadsheet-tab-scroll",this._tabsCont);a.id="spreadsheet-tab-scroll";for(var r=0;e>r;r++){var l="spreadsheet-tab"+r,h=s.DomUtil.create("div","spreadsheet-tab",a);h.innerHTML=t.partNames[r],h.id=l,s.DomEvent.on(h,"click",s.DomEvent.stopPropagation).on(h,"click",s.DomEvent.stop).on(h,"click",this._setPart,this).on(h,"click",this._refocusOnMap,this),this._spreadsheetTabs[l]=h}}for(var d in this._spreadsheetTabs){var u=parseInt(d.match(/\d+/g)[0]);s.DomUtil.removeClass(this._spreadsheetTabs[d],"spreadsheet-tab-selected"),u===i&&s.DomUtil.addClass(this._spreadsheetTabs[d],"spreadsheet-tab-selected")}}},_setPart:function(t){var e=t.target.id.match(/\d+/g)[0];null!==e&&this._map.setPart(parseInt(e))}}),s.control.tabs=function(t){return new s.Control.Tabs(t)},s.Control.PermissionSwitch=s.Control.extend({options:{position:"topleft"},onAdd:function(t){var i="leaflet-control-editviewswitch",n=s.DomUtil.create("label",i+" leaflet-bar");return this._checkBox=s.DomUtil.create("input","editview-cb",n),this._checkBox.type="checkbox",s.DomEvent.on(this._checkBox,"change",this._onChange,this),t.on("updatepermission",this._onUpdatePermission,this),n.appendChild(e.createTextNode("Enable editing")),n},_onChange:function(){this._checkBox.checked?this._map.setPermission("edit"):this._map.setPermission("view"),this._refocusOnMap()},_onUpdatePermission:function(t){"edit"===t.perm?(this._checkBox.checked=!0,this._checkBox.disabled=!1):"view"===t.perm?(this._checkBox.checked=!1,this._checkBox.disabled=!1):"readonly"===t.perm&&(this._checkBox.checked=!1,this._checkBox.disabled=!0)}}),s.control.permissionSwitch=function(t){return new s.Control.PermissionSwitch(t)},s.Control.Selection=s.Control.extend({options:{position:"topleft"},onAdd:function(t){var i="leaflet-control-editviewswitch",n=s.DomUtil.create("label",i+" leaflet-bar");return this._checkBox=s.DomUtil.create("input","editview-cb",n),this._checkBox.type="checkbox",s.DomEvent.on(this._checkBox,"change",this._onChange,this),t.on("updatepermission",this._onUpdatePermission,this),n.appendChild(e.createTextNode("Enable Selection")),n},_onChange:function(){this._checkBox.checked?this._map.enableSelection():this._map.disableSelection(),this._refocusOnMap()},_onUpdatePermission:function(t){"edit"===t.perm?(this._checkBox.checked=!1,this._checkBox.disabled=!0):"view"===t.perm?(this._checkBox.checked=!1,this._checkBox.disabled=!1):"readonly"===t.perm&&(this._checkBox.checked=!1,this._checkBox.disabled=!1)}}),s.control.selection=function(t){return new s.Control.Selection(t)},s.Control.Scroll=s.Control.extend({onAdd:function(t){this._scrollContainer=s.DomUtil.create("div","scroll-container",t._container.parentElement),this._mockDoc=s.DomUtil.create("div","",this._scrollContainer),this._mockDoc.id="mock-doc",this._prevScrollX=0,this._prevScrollY=0,this._prevDocWidth=0,this._prevDocHeight=0,t.on("scrollto",this._onScrollTo,this),t.on("scrollby",this._onScrollBy,this),t.on("scrollvelocity",this._onScrollVelocity,this),t.on("handleautoscroll",this._onHandleAutoScroll,this),t.on("docsize",this._onUpdateSize,this),t.on("updatescrolloffset",this._onUpdateScrollOffset,this),t.on("updaterowcolumnheaders",this._onUpdateRowColumnHeaders,this);var e=this,i=null;$(".scroll-container").mCustomScrollbar({axis:"yx",theme:"minimal-dark",scrollInertia:0,advanced:{autoExpandHorizontalScroll:!0},callbacks:{onScroll:function(){e._onScrollEnd(this),i&&clearTimeout(i),i=setTimeout(function(){$(".mCS-autoHide > .mCustomScrollBox ~ .mCSB_scrollTools").removeClass("loleaflet-scrollbar-show")},2e3)},whileScrolling:function(){e._onScroll(this),$(".mCS-autoHide > .mCustomScrollBox ~ .mCSB_scrollTools").addClass("loleaflet-scrollbar-show")},onUpdate:function(){console.debug("mCustomScrollbar: onUpdate:")},alwaysTriggerOffsets:!1}})},_onCalcScroll:function(t){if(this._map._enabled){var e=-t.mcs.left;if(e>this._prevScrollX){var i=this._map.getSize().x,n=this._map._docLayer._docPixelSize.x;e=Math.min(e,n-i)}else e=Math.max(e,0);var o=-t.mcs.top;if(o>this._prevScrollY){var a=this._map.getSize().y,r=Math.round(this._map._docLayer._docPixelSize.y);o=Math.min(o,r-a)}else o=Math.max(o,0);var l=new s.Point(e-this._prevScrollX,o-this._prevScrollY);l.equals(new s.Point(0,0))||(this._onUpdateRowColumnHeaders({x:e,y:o,offset:l}),this._prevScrollY=o,this._prevScrollX=e,this._map.fire("scrolloffset",l),this._map.scroll(l.x,l.y))}},_onScroll:function(t){if("spreadsheet"===this._map._docLayer._docType)return void this._onCalcScroll(t);if(console.debug("_onScroll: "),this._map._enabled){if(this._ignoreScroll)return void console.debug("_onScroll: ignoring scroll");var e=new s.Point(-t.mcs.left-this._prevScrollX,-t.mcs.top-this._prevScrollY);e.equals(new s.Point(0,0))||(this._prevScrollY=-t.mcs.top,this._prevScrollX=-t.mcs.left,console.debug("_onScroll: scrolling: "+e),this._map.scroll(e.x,e.y),this._map.fire("scrolloffset",e))}},_onScrollEnd:function(t){"spreadsheet"!==this._map._docLayer._docType&&(console.debug("_onScrollEnd:"),this._ignoreScroll&&(this._ignoreScroll=null,console.debug("_onScrollEnd: scrollTop: "+-t.mcs.top),this._map.scrollTop(-t.mcs.top)),this._prevScrollY=-t.mcs.top,this._prevScrollX=-t.mcs.left,this._map._docLayer._annotations.layout&&this._map._docLayer._annotations.layout())},_onScrollTo:function(t){$(".scroll-container").mCustomScrollbar("scrollTo",[t.y,t.x])},_onScrollBy:function(t){t.y*=-1;var e="+="+t.y;t.y<0&&(e="-="+Math.abs(t.y)),t.x*=-1;var i="+="+t.x;t.x<0&&(i="-="+Math.abs(t.x)),$(".scroll-container").mCustomScrollbar("scrollTo",[e,i])},_onScrollVelocity:function(t){0===t.vx&&0===t.vy?(clearInterval(this._autoScrollTimer),this._autoScrollTimer=null,this._map.isAutoScrolling=!1):(clearInterval(this._autoScrollTimer),this._map.isAutoScrolling=!0,this._autoScrollTimer=setInterval(s.bind(function(){this._onScrollBy({x:t.vx,y:t.vy})},this),100))},_onHandleAutoScroll:function(t){var e=0,i=0;t.pos.y>t.map._size.y-50?i=50:t.pos.y<50&&(i=-50),t.pos.x>t.map._size.x-50?e=50:t.pos.x<50&&(e=-50),this._onScrollVelocity({vx:e,vy:i})},_onUpdateSize:function(t){if(this._mockDoc){var e=Math.ceil(t.x),i=Math.ceil(t.y);"text"===this._map.getDocType()&&i<this._prevDocHeight&&(console.debug("_onUpdateSize: Ignore the scroll !"),this._ignoreScroll=!0),s.DomUtil.setStyle(this._mockDoc,"width",t.x+"px"),s.DomUtil.setStyle(this._mockDoc,"height",t.y+"px"),this._prevDocWidth!==e&&this._prevDocHeight===i&&$(".scroll-container").mCustomScrollbar("update"),this._prevDocWidth=e,this._prevDocHeight=i}},_onUpdateScrollOffset:function(t){if("spreadsheet"===this._map._docLayer._docType){var e=new s.Point(t.x-this._prevScrollX,t.y-this._prevScrollY);0===e.x&&(e.x=1),0===e.y&&(e.y=1),this._onUpdateRowColumnHeaders({x:t.x,y:t.y,offset:e})}this._ignoreScroll=null,$(".scroll-container").mCustomScrollbar("stop"),this._prevScrollY=t.y,this._prevScrollX=t.x,$(".scroll-container").mCustomScrollbar("scrollTo",[t.y,t.x],{callbacks:!1,timeout:0})},_onUpdateRowColumnHeaders:function(t){var e=t.offset||{},n=new s.Point(t.x,t.y),o=this._map.getSize();n.x===i&&(n.x=this._map._getTopLeftPoint().x),n.y===i&&(n.y=this._map._getTopLeftPoint().y),0===e.x&&(n.x=-1,o.x=0),0===e.y&&(n.y=-1,o.y=0);var a=this._map._docLayer._pixelsToTwips(n),r=this._map._docLayer._pixelsToTwips(o),l="commandvalues command=.uno:ViewRowColumnHeaders?x="+Math.round(a.x)+"&y="+Math.round(a.y)+"&width="+Math.round(r.x)+"&height="+Math.round(r.y);t.outline&&(l+="&columnOutline="+t.outline.column+"&groupLevel="+t.outline.level+"&groupIndex="+t.outline.index+"&groupHidden="+t.outline.hidden),this._map._socket.sendMessage(l)}}),s.control.scroll=function(t){return new s.Control.Scroll(t)},s.Control.LokDialog=s.Control.extend({dialogIdPrefix:"lokdialog-",onAdd:function(t){t.on("window",this._onDialogMsg,this),t.on("windowpaint",this._onDialogPaint,this),t.on("opendialog",this._openDialog,this),t.on("docloaded",this._docLoaded,this)},_dialogs:{},_docLoaded:function(t){t.status||($(".lokdialog_container").remove(),$(".lokdialogchild-canvas").remove())},_getParentDialog:function(t){t=parseInt(t);for(var e in this._dialogs)if(this._dialogs[e].childid&&this._dialogs[e].childid===t)return e;return null},_isOpen:function(t){return this._dialogs[t]&&this._dialogs[t].open&&$("#"+this._toDlgPrefix(t)).length>0},_toRawDlgId:function(t){return"string"==typeof t?parseInt(t.replace(this.dialogIdPrefix,"")):t},_toDlgPrefix:function(t){return this.dialogIdPrefix+t},_createRectStr:function(t,e,i,n,o){return n||(n=this._dialogs[parseInt(t)].width),o||(o=this._dialogs[parseInt(t)].height),e||(e=0),i||(i=0),[e,i,n,o].join(",")},_sendPaintWindow:function(t,e){e&&(e=e.replace(/ /g,"")),this._map._socket.sendMessage("paintwindow "+t+(e?" rectangle="+e:""))},_sendCloseWindow:function(t){this._map._socket.sendMessage("windowcommand "+t+" close")},_isRectangleValid:function(t){return t=t.split(","),parseInt(t[0])<0||parseInt(t[1])<0||parseInt(t[2])<0||parseInt(t[3])<0?!1:!0},_onDialogMsg:function(t){t.id=parseInt(t.id);var e=this._toDlgPrefix(t.id);if("created"===t.action){var i=parseInt(t.size.split(",")[0]),n=parseInt(t.size.split(",")[1]);if("dialog"===t.winType)this._launchDialog(this._toDlgPrefix(t.id),i,n,t.title),this._sendPaintWindow(t.id,this._createRectStr(t.id));else if("child"===t.winType){if(!this._isOpen(t.parentId))return;var o=parseInt(t.parentId),a=parseInt(t.position.split(",")[0]),r=parseInt(t.position.split(",")[1]);this._removeDialogChild(o),this._dialogs[o].childid=t.id,this._dialogs[o].childwidth=i,this._dialogs[o].childheight=n,this._dialogs[o].childx=a,this._dialogs[o].childy=r,this._createDialogChild(t.id,o,r,a),this._sendPaintWindow(t.id,this._createRectStr(null,0,0,i,n))}}else if("invalidate"===t.action){var l=this._getParentDialog(t.id),h=t.rectangle;if(l)h="0,0,"+this._dialogs[l].childwidth+","+this._dialogs[l].childheight;else{if(h&&!this._isRectangleValid(h))return;h||(h="0,0,"+this._dialogs[t.id].width+","+this._dialogs[t.id].height)}this._sendPaintWindow(t.id,h)}else if("size_changed"===t.action)i=parseInt(t.size.split(",")[0]),n=parseInt(t.size.split(",")[1]),$("#"+e).remove(),this._launchDialog(e,i,n,this._dialogs[parseInt(t.id)].title),this._sendPaintWindow(t.id,this._createRectStr(t.id));else if("cursor_invalidate"===t.action){if(this._isOpen(t.id)&&t.rectangle){h=t.rectangle.split(",");var d=parseInt(h[0]),u=parseInt(h[1]);n=parseInt(h[3]);var c=s.DomUtil.get(e+"-cursor");s.DomUtil.setStyle(c,"height",n+"px"),s.DomUtil.setStyle(c,"display",this._dialogs[t.id].cursorVisible?"block":"none"),s.DomUtil.setStyle(this._dialogs[t.id].cursor,"left",d+"px"),s.DomUtil.setStyle(this._dialogs[t.id].cursor,"top",u+"px")}}else"title_changed"===t.action?t.title&&this._dialogs[parseInt(t.id)]&&(this._dialogs[parseInt(t.id)].title=t.title,$("#"+e).dialog("option","title",t.title)):"cursor_visible"===t.action?(this._dialogs[t.id].cursorVisible="true"===t.visible,this._dialogs[t.id].cursorVisible?$("#"+e+"-cursor").css({display:"block"}):$("#"+e+"-cursor").css({display:"none"})):"close"===t.action&&(l=this._getParentDialog(t.id),l?this._onDialogChildClose(this._toDlgPrefix(l)):this._onDialogClose(t.id,!1))},_openDialog:function(t){this._map.sendUnoCommand(t.uno)},_launchDialogCursor:function(t){var e=this._toRawDlgId(t);this._dialogs[e].cursor=s.DomUtil.create("div","leaflet-cursor-container",s.DomUtil.get(t));var i=s.DomUtil.create("div","leaflet-cursor lokdialog-cursor",this._dialogs[e].cursor);i.id=t+"-cursor",s.DomUtil.addClass(i,"blinking-cursor")},_launchDialog:function(t,i,n,o){var a=s.DomUtil.create("div","lokdialog",e.body);s.DomUtil.setStyle(a,"padding","0px"),s.DomUtil.setStyle(a,"margin","0px"),s.DomUtil.setStyle(a,"overflow","hidden"),a.id=t;var r=s.DomUtil.create("canvas","lokdialog_canvas",a);r.width=i,r.height=n,r.tabIndex="0",r.contentEditable=!0,r.id=t+"-canvas",s.DomEvent.on(r,"contextmenu",s.DomEvent.preventDefault);var l=this;$(a).dialog({width:i,title:o?o:"",modal:!1,closeOnEscape:!0,resizable:!1,dialogClass:"lokdialog_container",close:function(){l._onDialogClose(l._toRawDlgId(t),!0)}}),$(a).parent().hide(),this._dialogs[this._toRawDlgId(t)]={open:!0,width:i,height:n,title:o},$(".lokdialog_container button.ui-dialog-titlebar-close").attr("tabindex","-1").blur(),s.DomEvent.on(r,"mousedown mouseup",function(e){var i=0;i|=e.button===map.mouse.JSButtons.left?map.mouse.LOButtons.left:0,i|=e.button===map.mouse.JSButtons.middle?map.mouse.LOButtons.middle:0,i|=e.button===map.mouse.JSButtons.right?map.mouse.LOButtons.right:0;var n=e.type.replace("mouse","button");this._postWindowMouseEvent(n,this._toRawDlgId(t),e.offsetX,e.offsetY,1,i,0)},this),s.DomEvent.on(r,"keyup keypress keydown",function(e){e.originalEvent=e,map.keyboard._onKeyDown(e,s.bind(this._postWindowKeyboardEvent,this,this._toRawDlgId(t)))},this),s.DomEvent.on(r,"contextmenu",function(){return!1}),this._launchDialogCursor(t)},_postWindowMouseEvent:function(t,e,i,n,o,s,a){this._map._socket.sendMessage("windowmouse id="+e+" type="+t+" x="+i+" y="+n+" count="+o+" buttons="+s+" modifier="+a)},_postWindowKeyboardEvent:function(t,e,i,n){this._map._socket.sendMessage("windowkey id="+t+" type="+e+" char="+i+" key="+n)},_onDialogClose:function(t,e){e&&this._sendCloseWindow(t),$("#"+this._toDlgPrefix(t)).remove(),this._map.focus(),delete this._dialogs[t]},_paintDialog:function(t,i,n){if(this._isOpen(t)){var o=this._toDlgPrefix(t),a=new Image,r=e.getElementById(o+"-canvas"),l=r.getContext("2d");a.onload=function(){var t=0,e=0;i&&(i=i.split(","),t=parseInt(i[0]),e=parseInt(i[1])),l.drawImage(a,t,e);var n=s.DomUtil.get(o);$(n).parent().show()},a.src=n}},_onDialogPaint:function(t){var e=this._getParentDialog(t.id);e?this._paintDialogChild(e,t.width,t.height,t.rectangle,t.img):this._paintDialog(t.id,t.rectangle,t.img)},_paintDialogChild:function(t,i,n,o,s){var a=this._toDlgPrefix(t),r=new Image,l=e.getElementById(a+"-floating");l.width=i,l.height=n;var h=l.getContext("2d");r.onload=function(){h.drawImage(r,0,0)},r.src=s,n=parseInt(l.style.top)+l.height;var d=parseInt($("#"+a).css("height"));n>d&&$("#"+a).css("height",n+"px")},_onDialogChildClose:function(t){$("#"+t+"-floating").remove();var i=e.getElementById(t+"-canvas").height;$("#"+t).height(i+"px")},_removeDialogChild:function(t){"number"==typeof t&&(t=this._toDlgPrefix(t)),$("#"+t+"-floating").remove()},_createDialogChild:function(t,e,i,n){var o=this._toDlgPrefix(e),a=s.DomUtil.get(o),r=s.DomUtil.create("canvas","lokdialogchild-canvas",a);r.id=o+"-floating",s.DomUtil.setStyle(r,"position","absolute"),s.DomUtil.setStyle(r,"left",n+"px"),s.DomUtil.setStyle(r,"top",i+"px"),s.DomEvent.on(r,"mousedown mouseup",function(e){var i=0;i|=e.button===map.mouse.JSButtons.left?map.mouse.LOButtons.left:0,i|=e.button===map.mouse.JSButtons.middle?map.mouse.LOButtons.middle:0,i|=e.button===map.mouse.JSButtons.right?map.mouse.LOButtons.right:0;var n=e.type.replace("mouse","button");this._postWindowMouseEvent(n,t,e.offsetX,e.offsetY,1,i,0)},this),s.DomEvent.on(r,"mousemove",function(e){this._postWindowMouseEvent("move",t,e.offsetX,e.offsetY,1,0,0)},this),s.DomEvent.on(r,"contextmenu",function(){return!1})}}),s.control.lokDialog=function(t){return new s.Control.LokDialog(t)},s.Control.AlertDialog=s.Control.extend({onAdd:function(t){t.on("error",this._onError,this),t.on("warn",this._onError,this),t.on("print",this._onPrint,this)},_onError:function(t){if(vex.dialogID>0&&!this._map._fatal&&vex.close(vex.dialogID),t.msg)vex.dialog.alert(t.msg);else{if("load"==t.cmd&&"docunloading"==t.kind)return;if(t.cmd&&t.kind){var e=_("The server encountered a %0 error while parsing the %1 command.");e.replace("%0",t.kind),e.replace("%1",t.cmd),vex.dialog.alert(e)}}vex.dialogID=vex.globalID-1},_onPrint:function(t){var e=t.url;vex.dialog.confirm({message:_("Download PDF export?"),callback:s.bind(function(t){t&&(this._map._fileDownloader.src=e)},this)})}}),s.control.alertDialog=function(t){return new s.Control.AlertDialog(t)},s.Control.Attribution=s.Control.extend({options:{position:"bottomright",prefix:'<a href="http://leafletjs.com" title="A JS library for interactive maps">Leaflet</a>'},initialize:function(t){s.setOptions(this,t)},onAdd:function(){return this._container||(this._container=s.DomUtil.create("div","leaflet-control-attribution"),s.DomEvent.disableClickPropagation(this._container)),this._update(),this._container},setPrefix:function(t){return this.options.prefix=t,this._update(),this},_update:function(){this._map&&(this._container.innerHTML=this.options.prefix)}}),s.control.attribution=function(t){return new s.Control.Attribution(t)},s.Control.Scale=s.Control.extend({options:{position:"bottomleft",maxWidth:100,metric:!0,imperial:!0},onAdd:function(t){var e="leaflet-control-scale",i=s.DomUtil.create("div",e),n=this.options;return this._addScales(n,e+"-line",i),t.on(n.updateWhenIdle?"moveend":"move",this._update,this),t.whenReady(this._update,this),i},onRemove:function(t){t.off(this.options.updateWhenIdle?"moveend":"move",this._update,this)},_addScales:function(t,e,i){t.metric&&(this._mScale=s.DomUtil.create("div",e,i)),t.imperial&&(this._iScale=s.DomUtil.create("div",e,i))},_update:function(){var t=this._map,e=t.getSize().y/2,i=s.CRS.Earth.distance(t.containerPointToLatLng([0,e]),t.containerPointToLatLng([this.options.maxWidth,e]));this._updateScales(i)},_updateScales:function(t){this.options.metric&&t&&this._updateMetric(t),this.options.imperial&&t&&this._updateImperial(t)},_updateMetric:function(t){var e=this._getRoundNum(t),i=1e3>e?e+" m":e/1e3+" km";this._updateScale(this._mScale,i,e/t)},_updateImperial:function(t){var e,i,n,o=3.2808399*t;o>5280?(e=o/5280,i=this._getRoundNum(e),this._updateScale(this._iScale,i+" mi",i/e)):(n=this._getRoundNum(o),this._updateScale(this._iScale,n+" ft",n/o))},_updateScale:function(t,e,i){t.style.width=Math.round(this.options.maxWidth*i)+"px",t.innerHTML=e},_getRoundNum:function(t){var e=Math.pow(10,(Math.floor(t)+"").length-1),i=t/e;return i=i>=10?10:i>=5?5:i>=3?3:i>=2?2:1,e*i}}),s.control.scale=function(t){return new s.Control.Scale(t)},s.Control.Layers=s.Control.extend({options:{collapsed:!0,position:"topright",autoZIndex:!0,hideSingleBase:!1},initialize:function(t,e,i){s.setOptions(this,i),this._layers={},this._lastZIndex=0,this._handlingClick=!1;for(var n in t)this._addLayer(t[n],n);for(n in e)this._addLayer(e[n],n,!0)},onAdd:function(){return this._initLayout(),this._update(),this._container},addBaseLayer:function(t,e){return this._addLayer(t,e),this._update()},addOverlay:function(t,e){return this._addLayer(t,e,!0),this._update()},removeLayer:function(t){return t.off("add remove",this._onLayerChange,this),delete this._layers[s.stamp(t)],this._update()},_initLayout:function(){var t="leaflet-control-layers",e=this._container=s.DomUtil.create("div",t);e.setAttribute("aria-haspopup",!0),s.Browser.touch?s.DomEvent.on(e,"click",s.DomEvent.stopPropagation):s.DomEvent.disableClickPropagation(e).disableScrollPropagation(e);var i=this._form=s.DomUtil.create("form",t+"-list");if(this.options.collapsed){s.Browser.android||s.DomEvent.on(e,{mouseenter:this._expand,mouseleave:this._collapse},this);var n=this._layersLink=s.DomUtil.create("a",t+"-toggle",e);n.href="#",n.title="Layers",s.Browser.touch?s.DomEvent.on(n,"click",s.DomEvent.stop).on(n,"click",this._expand,this):s.DomEvent.on(n,"focus",this._expand,this),s.DomEvent.on(i,"click",function(){setTimeout(s.bind(this._onInputClick,this),0)},this),this._map.on("click",this._collapse,this)}else this._expand();this._baseLayersList=s.DomUtil.create("div",t+"-base",i),this._separator=s.DomUtil.create("div",t+"-separator",i),this._overlaysList=s.DomUtil.create("div",t+"-overlays",i),e.appendChild(i)},_addLayer:function(t,e,i){t.on("add remove",this._onLayerChange,this);var n=s.stamp(t);this._layers[n]={layer:t,name:e,overlay:i},this.options.autoZIndex&&t.setZIndex&&(this._lastZIndex++,t.setZIndex(this._lastZIndex))},_update:function(){if(!this._container)return this;s.DomUtil.empty(this._baseLayersList),s.DomUtil.empty(this._overlaysList);var t,e,i,n,o=0;for(i in this._layers)n=this._layers[i],this._addItem(n),e=e||n.overlay,t=t||!n.overlay,o+=n.overlay?0:1;return this.options.hideSingleBase&&(t=t&&o>1,this._baseLayersList.style.display=t?"":"none"),this._separator.style.display=e&&t?"":"none",this},_onLayerChange:function(t){this._handlingClick||this._update();var e=this._layers[s.stamp(t.target)].overlay,i=e?"add"===t.type?"overlayadd":"overlayremove":"add"===t.type?"baselayerchange":null;i&&this._map.fire(i,t.target)},_createRadioElement:function(t,i){var n='<input type="radio" class="leaflet-control-layers-selector" name="'+t+'"'+(i?' checked="checked"':"")+"/>",o=e.createElement("div");return o.innerHTML=n,o.firstChild},_addItem:function(t){var i,n=e.createElement("label"),o=this._map.hasLayer(t.layer);t.overlay?(i=e.createElement("input"),i.type="checkbox",i.className="leaflet-control-layers-selector",i.defaultChecked=o):i=this._createRadioElement("leaflet-base-layers",o),i.layerId=s.stamp(t.layer),s.DomEvent.on(i,"click",this._onInputClick,this);var a=e.createElement("span");a.innerHTML=" "+t.name,n.appendChild(i),n.appendChild(a);var r=t.overlay?this._overlaysList:this._baseLayersList;return r.appendChild(n),n},_onInputClick:function(){var t,e,i,n=this._form.getElementsByTagName("input"),o=[],s=[];this._handlingClick=!0;for(var a=0,r=n.length;r>a;a++)t=n[a],e=this._layers[t.layerId].layer,i=this._map.hasLayer(e),t.checked&&!i?o.push(e):!t.checked&&i&&s.push(e);for(a=0;a<s.length;a++)this._map.removeLayer(s[a]);for(a=0;a<o.length;a++)this._map.addLayer(o[a]);this._handlingClick=!1,this._refocusOnMap()},_expand:function(){s.DomUtil.addClass(this._container,"leaflet-control-layers-expanded")},_collapse:function(){s.DomUtil.removeClass(this._container,"leaflet-control-layers-expanded")}}),s.control.layers=function(t,e,i){return new s.Control.Layers(t,e,i)},s.Map.include({search:function(t,e,n,o,a){e===i&&(e=!1),o===i&&(o=0),n===i&&(n=""),this._docLayer._searchResults&&t!==this._docLayer._searchTerm&&this._docLayer._clearSearchResults();var r={"SearchItem.SearchString":{type:"string"},"SearchItem.ReplaceString":{type:"string"},"SearchItem.Backward":{type:"boolean"},"SearchItem.SearchStartPointX":{type:"long"},"SearchItem.SearchStartPointY":{type:"long"},"SearchItem.Command":{type:"long"}};this.fire("clearselection");var l=this.project(this.getBounds().getNorthWest()),h=this.project(this.options.maxBounds.getNorthWest()),d=this.unproject(new s.Point(Math.max(l.x,h.x),Math.max(l.y,h.y))),u=this._docLayer._latLngToTwips(d),c=u.x,_=u.y;if(this._docLayer&&this._docLayer._lastSearchResult&&a){var p=this._docLayer._lastSearchResult.twipsRectangles.match(/\d+/g);null!=p&&(c=p[0],_=p[1]),this.resetSelection()}r["SearchItem.SearchString"].value=t,r["SearchItem.Backward"].value=e,r["SearchItem.ReplaceString"].value=n,r["SearchItem.SearchStartPointX"].value=c,r["SearchItem.SearchStartPointY"].value=_,r["SearchItem.Command"].value=o,this._searchRequested=!0,this._socket.sendMessage("uno .uno:ExecuteSearch "+JSON.stringify(r))},highlightAll:function(t){this._docLayer._searchResults&&t===this._docLayer._searchTerm||this.search(t,!1,1)},resetSelection:function(){this._docLayer._clearSearchResults(),this._socket.sendMessage("resetselection")}}),s.Map.include({setPermission:function(t){this._permission=t,"edit"===t?(this._socket.sendMessage("requestloksession"),s.Browser.touch||this.dragging.disable()):("view"===t||"readonly"===t)&&(this.dragging.enable(),this._docLayer._onUpdateCursor(),this._docLayer._clearSelections(),this._docLayer._onUpdateTextSelection()),this.fire("updatepermission",{perm:t})},enableSelection:function(){"edit"!==this._permission&&(this._socket.sendMessage("requestloksession"),this.dragging.disable())},disableSelection:function(){"edit"!==this._permission&&this.dragging.enable();
},isSelectionEnabled:function(){return!this.dragging.enabled()},getPermission:function(){return this._permission}}),s.Map.include({unoToolbarCommands:[".uno:StyleApply",".uno:CharFontName"],_modalDialogOptions:{overlayClose:!0,opacity:80,overlayCss:{backgroundColor:"#000"},containerCss:{overflow:"hidden",backgroundColor:"#fff",padding:"20px",border:"2px solid #000"}},applyFont:function(t){if("edit"===this.getPermission()){var e='uno .uno:CharFontName {"CharFontName.FamilyName": {"type": "string", "value": "'+t+'"}}';this._socket.sendMessage(e)}},applyFontSize:function(t){if("edit"===this.getPermission()){var e='uno .uno:FontHeight {"FontHeight.Height": {"type": "float", "value": "'+t+'"}}';this._socket.sendMessage(e)}},getToolbarCommandValues:function(t){return this._docLayer?this._docLayer._toolbarCommandValues[t]:i},downloadAs:function(t,e,n,o){if(!this._fatal){if(o=o||"export","print"===o&&this.wopi.DisablePrint||"export"===o&&this.wopi.DisableExport)return void this.hideBusy();(e===i||null===e)&&(e=""),(n===i||null===n)&&(n=""),this.showBusy(_("Downloading..."),!1),this._socket.sendMessage("downloadas name="+encodeURIComponent(t)+" id="+o+" format="+e+" options="+n)}},print:function(){this.showBusy(_("Downloading..."),!1),this.downloadAs("print.pdf","pdf",null,"print")},saveAs:function(t,e,n){t!==i&&null!=t&&((e===i||null===e)&&(e=""),(n===i||null===n)&&(n=""),this.showBusy(_("Saving..."),!1),this._socket.sendMessage("saveas url=wopi:"+encodeURIComponent(t)+" format="+e+" options="+n))},applyStyle:function(t,e){if(!t||!e)return void this.fire("error",{cmd:"setStyle",kind:"incorrectparam"});if("edit"===this._permission){var i='uno .uno:StyleApply {"Style":{"type":"string", "value": "'+t+'"},"FamilyName":{"type":"string", "value":"'+e+'"}}';this._socket.sendMessage(i)}},applyLayout:function(t){if(!t)return void this.fire("error",{cmd:"setLayout",kind:"incorrectparam"});if("edit"===this._permission){var e='uno .uno:AssignLayout {"WhatPage":{"type":"unsigned short", "value": "'+this.getCurrentPartNumber()+'"},"WhatLayout":{"type":"unsigned short", "value": "'+t+'"}}';this._socket.sendMessage(e)}},save:function(t,e){this._socket.sendMessage("save dontTerminateEdit="+(t?1:0)+" dontSaveIfUnmodified="+(e?1:0))},sendUnoCommand:function(t,e){"edit"===this._permission&&this._socket.sendMessage("uno "+t+(e?" "+JSON.stringify(e):""))},toggleCommandState:function(t){"edit"===this._permission&&(t.startsWith(".uno:")||(t=".uno:"+t),this.sendUnoCommand(t))},insertFile:function(t){this.fire("insertfile",{file:t})},cellEnterString:function(t){var e={StringName:{type:"string",value:t},DontCommit:{type:"boolean",value:!0}};this.sendUnoCommand(".uno:EnterString ",e)},renderFont:function(e){this._socket.sendMessage("renderfont font="+t.encodeURIComponent(e))},showLOKeyboardHelp:function(){var i=t.innerWidth/2;$.get("loleaflet-help.html",function(t){vex.open({content:t,showCloseButton:!0,escapeButtonCloses:!0,overlayClosesOnClick:!0,contentCSS:{width:i+"px"},buttons:{},afterOpen:function(t){"text"===map.getDocType()?e.getElementById("text-shortcuts").style.display="block":"spreadsheet"===map.getDocType()?e.getElementById("spreadsheet-shortcuts").style.display="block":("presentation"===map.getDocType()||"drawing"===map.getDocType())&&(e.getElementById("presentation-shortcuts").style.display="block");var i,n,o=t.find("h1");for(i=0,n=o.length;n>i;i++)o[i].firstChild.nodeValue=o[i].firstChild.nodeValue.toLocaleString();for(o=t.find("h2"),i=0,n=o.length;n>i;i++)o[i].firstChild.nodeValue=o[i].firstChild.nodeValue.toLocaleString();for(o=t.find("td"),i=0,n=o.length;n>i;i++)o[i].firstChild.nodeValue=o[i].firstChild.nodeValue.toLocaleString();$(".vex-content").attr("tabindex",-1),$(".vex-content").focus(),$(".vex-overlay").css({"pointer-events":"none"}),$(".vex").click(function(){vex.close(t.data().vex.id)}),$(".vex-content").click(function(t){t.stopPropagation()})},beforeClose:function(){map.focus()}})})},showLOAboutDialog:function(){var e=$("#about-dialog").clone().css({display:"block"}),i="undefined"!=typeof brandProductName?brandProductName:"LibreOffice Online";e.find("#product-name").text(i);var n=_("This version of %productName is powered by");e.find("#product-string").text(n.replace("%productName",i));var o=t.innerWidth/2;vex.open({content:e,showCloseButton:!0,escapeButtonCloses:!0,overlayClosesOnClick:!0,contentCSS:{width:o+"px"},buttons:{},afterOpen:function(t){map.enable(!1),$(".vex-overlay").css({"pointer-events":"none"}),$(".vex").click(function(){vex.close(t.data().vex.id)}),$(".vex-content").click(function(t){t.stopPropagation()})},beforeClose:function(){map.enable(!0)}})}}),s.Map.include({setPart:function(t,e){var i=this._docLayer;if(i._prevSelectedPart=i._selectedPart,"prev"===t)i._selectedPart>0&&(i._selectedPart-=1);else if("next"===t)i._selectedPart<i._parts-1&&(i._selectedPart+=1);else{if(!("number"==typeof t&&t>=0&&t<i._parts))return;i._selectedPart=t}i._isCursorOverlayVisible&&this._socket.sendMessage("resetselection"),this.fire("updateparts",{selectedPart:i._selectedPart,parts:i._parts,docType:i._docType}),e||this._socket.sendMessage("setclientpart part="+i._selectedPart),i.eachView(i._viewCursors,i._onUpdateViewCursor,i),i.eachView(i._cellViewCursors,i._onUpdateCellViewCursor,i),i.eachView(i._graphicViewMarkers,i._onUpdateGraphicViewSelection,i),i.eachView(i._viewSelections,i._onUpdateTextViewSelection,i),i._clearSelections(),i._updateOnChangePart(),i._pruneTiles(),i._prevSelectedPartNeedsUpdate=!0,i._invalidatePreview&&i._invalidatePreview(),i._drawSearchResults(),this._searchRequested||this.focus()},getPreview:function(t,e,i,n,o){this._docPreviews||(this._docPreviews={});var s=o?!!o.autoUpdate:!1,a=o?!!o.broadcast:!1;this._docPreviews[t]={id:t,index:e,maxWidth:i,maxHeight:n,autoUpdate:s};var r=this._docLayer;if("text"!==r._docType){var l=e,h=0,d=0,u=r._docWidthTwips,c=r._docHeightTwips,_=u/c,p=i/n;p>_?i=Math.round(u*n/c):n=Math.round(c*i/u),this._socket.sendMessage("tile part="+l+" width="+i+" height="+n+" tileposx="+h+" tileposy="+d+" tilewidth="+u+" tileheight="+c+" id="+t+" broadcast="+(a?"yes":"no"))}},getCustomPreview:function(t,e,i,n,o,s,a,r,l){this._docPreviews||(this._docPreviews={});var h=l?l.autoUpdate:!1;this._docPreviews[t]={id:t,part:e,width:i,height:n,tilePosX:o,tilePosY:s,tileWidth:a,tileHeight:r,autoUpdate:h},this._socket.sendMessage("tile part="+e+" width="+i+" height="+n+" tileposx="+o+" tileposy="+s+" tilewidth="+a+" tileheight="+r+" id="+t+" broadcast=no")},removePreviewUpdate:function(t){this._docPreviews&&this._docPreviews[t]&&(this._docPreviews[t].autoUpdate=!1)},goToPage:function(t){var e=this._docLayer;if("prev"===t?e._currentPage>0&&(e._currentPage-=1):"next"===t?e._currentPage<e._pages-1&&(e._currentPage+=1):"number"==typeof t&&t>=0&&t<e._pages&&(e._currentPage=t),"edit"!==this._permission&&e._partPageRectanglesPixels.length>e._currentPage){var i=e._partPageRectanglesPixels[e._currentPage],n=new s.Point(i.min.x+(i.max.x-i.min.x)/2,i.min.y);n.y-=this.getSize().y/4,this.scrollTop(n.y,{update:!0}),this.scrollLeft(n.x,{update:!0})}else this._socket.sendMessage("setpage page="+e._currentPage);this.fire("pagenumberchanged",{currentPage:e._currentPage,pages:e._pages,docType:e._docType})},insertPage:function(t){if("presentation"===this.getDocType())this._socket.sendMessage("uno .uno:InsertPage");else{if("spreadsheet"!==this.getDocType())return;var e={Name:{type:"string",value:""},Index:{type:"long",value:t+1}};this._socket.sendMessage("uno .uno:Insert "+JSON.stringify(e))}var i=this._docLayer;this.fire("insertpage",{selectedPart:i._selectedPart,parts:i._parts}),i._parts++,"number"==typeof t?this.setPart(t):this.setPart("next")},duplicatePage:function(){if("presentation"===this.getDocType()){this._socket.sendMessage("uno .uno:DuplicatePage");var t=this._docLayer;this.fire("insertpage",{selectedPart:t._selectedPart,parts:t._parts}),t._parts++,this.setPart("next")}},deletePage:function(t){if("presentation"===this.getDocType())this._socket.sendMessage("uno .uno:DeletePage");else{if("spreadsheet"!==this.getDocType())return;var e={Index:{type:"long",value:t+1}};this._socket.sendMessage("uno .uno:Remove "+JSON.stringify(e))}var i=this._docLayer;1!==i._parts&&(this.fire("deletepage",{selectedPart:i._selectedPart,parts:i._parts}),i._parts--,i._selectedPart>=i._parts&&i._selectedPart--,"number"==typeof t?this.setPart(t):this.setPart(i._selectedPart))},renamePage:function(t,e){if("spreadsheet"===this.getDocType()){var i={Name:{type:"string",value:t},Index:{type:"long",value:e+1}};this._socket.sendMessage("uno .uno:Name "+JSON.stringify(i)),this.setPart(this._docLayer)}},getNumberOfPages:function(){return this._docLayer._pages},getNumberOfParts:function(){return this._docLayer._parts},getCurrentPageNumber:function(){return this._docLayer._currentPage},getCurrentPartNumber:function(){return this._docLayer._selectedPart},getDocSize:function(){return this._docLayer._docPixelSize},getDocType:function(){return this._docLayer?this._docLayer._docType:null}}),s.Map.include({scroll:function(t,e,i){"number"==typeof t&&"number"==typeof e&&(this._setUpdateOffsetEvt(i),this.panBy(new s.Point(t,e),{animate:!1}))},scrollDown:function(t,e){this.scroll(0,t,e)},scrollRight:function(t,e){this.scroll(t,0,e)},scrollOffset:function(){var t=this.project(this.getCenter()),e=t.subtract(this.getSize().divideBy(2)),i={};return i.x=e.x<0?0:Math.round(e.x),i.y=e.y<0?0:Math.round(e.y),i},scrollTop:function(t,e){this._setUpdateOffsetEvt(e);var i=this.scrollOffset();console.debug("scrollTop: "+t+" "+i.y+" "+(t-i.y)),this.panBy(new s.Point(0,t-i.y),{animate:!1})},scrollLeft:function(t,e){this._setUpdateOffsetEvt(e);var i=this.scrollOffset();this.panBy(new s.Point(t-i.x,0),{animate:!1})},_setUpdateOffsetEvt:function(t){t&&t.update===!0?this.on("moveend",this._docLayer._updateScrollOffset,this._docLayer):this.off("moveend",this._docLayer._updateScrollOffset,this._docLayer)},fitWidthZoom:function(t){this._docLayer&&this._docLayer._fitWidthZoom(null,t)}}),s.Styles={styleMappings:{Default:"Default",Result:"Result",Result2:"Result2",Heading:"Heading",Heading1:"Heading1",Default:"Default",Report:"Report",standard:"Default",objectwitharrow:"Object with arrow",objectwithshadow:"Object with shadow",objectwithoutfill:"Object without fill","Object with no fill and no line":"Object with no fill and no line",text:"Text",textbody:"Text body",textbodyjustfied:"Text body justified",textbodyindent:"First line indent",title:"Title",title1:"Title1",title2:"Title2",headline:"Heading",headline1:"Heading1",headline2:"Heading2",measure:"Dimension Line",Normal:"Normal","Heading 1":"Heading 1","Heading 2":"Heading 2","Heading 3":"Heading 3","Numbering Symbols":"Numbering Symbols",Bullets:"Bullets","Table Contents":"Table Contents",Quotations:"Quotations",Index:"Index",Caption:"Caption",List:"List","Text Body":"Text Body","default":"default",gray1:"gray1",gray2:"gray2",gray3:"gray3",bw1:"bw1",bw2:"bw2",bw3:"bw3",orange1:"orange1",orange2:"orange2",orange3:"orange3",turquoise1:"turquoise1",turquoise2:"turquoise2",turquoise3:"turquoise3",blue1:"blue1",blue2:"blue2",blue3:"blue3",sun1:"sun1",sun2:"sun2",sun3:"sun3",earth1:"earth1",earth2:"earth2",earth3:"earth3",green1:"green1",green2:"green2",green3:"green3",seetang1:"seetang1",seetang2:"seetang2",seetang3:"seetang3",lightblue1:"lightblue1",lightblue2:"lightblue2",lightblue3:"lightblue3",yellow1:"yellow1",yellow2:"yellow2",yellow3:"yellow3","default":"default",bw:"bw",orange:"orange",turquoise:"turquoise",blue:"blue",sun:"sun",earth:"earth",green:"green",seetang:"seetang",lightblue:"lightblue",yellow:"yellow",background:"Background",backgroundobjects:"Background objects",notes:"Notes",outline1:"Outline 1",outline2:"Outline 2",outline3:"Outline 3",outline4:"Outline 4",outline5:"Outline 5",outline6:"Outline 6",outline7:"Outline 7",outline8:"Outline 8",outline9:"Outline 9",subtitle:"Subtitle",title:"Title","Clear formatting":"Clear formatting","Default Style":"Default Style","Bullet Symbols":"Bullets","Numbering Symbols":"Numbering Symbols","Footnote Symbol":"Footnote Characters","Page Number":"Page Number","Caption characters":"Caption Characters","Drop Caps":"Drop Caps","Internet link":"Internet Link","Visited Internet Link":"Visited Internet Link",Placeholder:"Placeholder","Index Link":"Index Link","Endnote Symbol":"Endnote Characters","Line numbering":"Line Numbering","Main index entry":"Main Index Entry","Footnote anchor":"Footnote Anchor","Endnote anchor":"Endnote Anchor",Rubies:"Rubies","Vertical Numbering Symbols":"Vertical Numbering Symbols",Emphasis:"Emphasis",Citation:"Quotation","Strong Emphasis":"Strong Emphasis","Source Text":"Source Text",Example:"Example","User Entry":"User Entry",Variable:"Variable",Definition:"Definition",Teletype:"Teletype","Text body":"Text Body",Quotations:"Quotations",Title:"Title",Subtitle:"Subtitle","Heading 1":"Heading 1","Heading 2":"Heading 2","Heading 3":"Heading 3",Standard:"Default Style",Heading:"Heading",List:"List",Caption:"Caption",Index:"Index","Table Contents":"Table Contents","First line indent":"First Line Indent","Hanging indent":"Hanging Indent","Text body indent":"Text Body Indent",Salutation:"Complimentary Close",Signature:"Signature","List Indent":"List Indent",Marginalia:"Marginalia","Heading 4":"Heading 4","Heading 5":"Heading 5","Heading 6":"Heading 6","Heading 7":"Heading 7","Heading 8":"Heading 8","Heading 9":"Heading 9","Heading 10":"Heading 10","Numbering 1 Start":"Numbering 1 Start","Numbering 1":"Numbering 1","Numbering 1 End":"Numbering 1 End","Numbering 1 Cont.":"Numbering 1 Cont.","Numbering 2 Start":"Numbering 2 Start","Numbering 2":"Numbering 2","Numbering 2 End":"Numbering 2 End","Numbering 2 Cont.":"Numbering 2 Cont.","Numbering 3 Start":"Numbering 3 Start","Numbering 3":"Numbering 3","Numbering 3 End":"Numbering 3 End","Numbering 3 Cont.":"Numbering 3 Cont.","Numbering 4 Start":"Numbering 4 Start","Numbering 4":"Numbering 4","Numbering 4 End":"Numbering 4 End","Numbering 4 Cont.":"Numbering 4 Cont.","Numbering 5 Start":"Numbering 5 Start","Numbering 5":"Numbering 5","Numbering 5 End":"Numbering 5 End","Numbering 5 Cont.":"Numbering 5 Cont.","List 1 Start":"List 1 Start","List 1":"List 1","List 1 End":"List 1 End","List 1 Cont.":"List 1 Cont.","List 2 Start":"List 2 Start","List 2":"List 2","List 2 End":"List 2 End","List 2 Cont.":"List 2 Cont.","List 3 Start":"List 3 Start","List 3":"List 3","List 3 End":"List 3 End","List 3 Cont.":"List 3 Cont.","List 4 Start":"List 4 Start","List 4":"List 4","List 4 End":"List 4 End","List 4 Cont.":"List 4 Cont.","List 5 Start":"List 5 Start","List 5":"List 5","List 5 End":"List 5 End","List 5 Cont.":"List 5 Cont.","Index Heading":"Index Heading","Index 1":"Index 1","Index 2":"Index 2","Index 3":"Index 3","Index Separator":"Index Separator","Contents Heading":"Contents Heading","Contents 1":"Contents 1","Contents 2":"Contents 2","Contents 3":"Contents 3","Contents 4":"Contents 4","Contents 5":"Contents 5","User Index Heading":"User Index Heading","User Index 1":"User Index 1","User Index 2":"User Index 2","User Index 3":"User Index 3","User Index 4":"User Index 4","User Index 5":"User Index 5","Contents 6":"Contents 6","Contents 7":"Contents 7","Contents 8":"Contents 8","Contents 9":"Contents 9","Contents 10":"Contents 10","Illustration Index Heading":"Illustration Index Heading","Illustration Index 1":"Illustration Index 1","Object index heading":"Object Index Heading","Object index 1":"Object Index 1","Table index heading":"Table Index Heading","Table index 1":"Table Index 1","Bibliography Heading":"Bibliography Heading","Bibliography 1":"Bibliography 1","User Index 6":"User Index 6","User Index 7":"User Index 7","User Index 8":"User Index 8","User Index 9":"User Index 9","User Index 10":"User Index 10",Header:"Header","Header left":"Header Left","Header right":"Header Right",Footer:"Footer","Footer left":"Footer Left","Footer right":"Footer Right","Table Heading":"Table Heading",Illustration:"Illustration",Table:"Table",Text:"Text","Frame contents":"Frame Contents",Footnote:"Footnote",Addressee:"Addressee",Sender:"Sender",Endnote:"Endnote",Drawing:"Drawing","Preformatted Text":"Preformatted Text","Horizontal Line":"Horizontal Line","List Contents":"List Contents","List Heading":"List Heading",Standard:"Default Style","First Page":"First Page","Left Page":"Left Page","Right Page":"Right Page",Envelope:"Envelope",Index:"Index",HTML:"HTML",Footnote:"Footnote",Endnote:"Endnote",Landscape:"Landscape",Graphics:"Graphics",Frame:"Frame",OLE:"OLE",Formula:"Formula",Marginalia:"Marginalia",Watermark:"Watermark",Labels:"Labels","Numbering 1":"Numbering 1","Numbering 2":"Numbering 2","Numbering 3":"Numbering 3","Numbering 4":"Numbering 4","Numbering 5":"Numbering 5","List 1":"List 1","List 2":"List 2","List 3":"List 3","List 4":"List 4","List 5":"List 5"},impressMapping:{Titel:"title",Untertitel:"subtitle","Gliederung 1":"outline1","Gliederung 2":"outline2","Gliederung 3":"outline3","Gliederung 4":"outline4","Gliederung 5":"outline5","Gliederung 6":"outline6","Gliederung 7":"outline7","Gliederung 8":"outline8","Gliederung 9":"outline9",Hintergrund:"background",Hintergrundobjekte:"backgroundobjects",Notizen:"notes"},impressLayout:[{id:0,text:"Title Slide"},{id:1,text:"Title, Content"},{id:3,text:"Title and 2 Content"},{id:19,text:"Title Only"},{id:20,text:"Blank Slide"},{id:32,text:"Centered Text"},{id:12,text:"Title, Content and 2 Content"},{id:15,text:"Title, 2 Content and Content"},{id:16,text:"Title, 2 Content over Content"},{id:14,text:"Title, Content over Content"},{id:18,text:"Title, 4 Content"},{id:34,text:"Title, 6 Content"},{id:27,text:"Vertical Title, Text, Chart"},{id:28,text:"Vertical Title, Vertical Text"},{id:29,text:"Title, Vertical Text"},{id:30,text:"Title, Vertical Text, Clipart"}],insertMode:{"true":"Insert","false":"Overwrite"},selectionMode:["Standard selection","Extending selection","Adding selection","Block selection"]},s.Control.Ruler=s.Control.extend({options:{interactive:!0,marginSet:!1,displayNumber:!0,tileMargin:18,extraSize:0,margin1:null,margin2:null,nullOffset:null,pageOffset:null,pageWidth:null,unit:null,DraggableConvertRatio:null,timer:null},onAdd:function(t){return t.on("rulerupdate",this._updateOptions,this),t.on("docsize",this._updatePaintTimer,this),t.on("scrolloffset resize",this._fixOffset,this),t.on("updatepermission",this._changeInteractions,this),this._map=t,this._initLayout()},_updatePaintTimer:function(t){t.extraSize&&(this.options.extraSize=t.extraSize.x),clearTimeout(this.options.timer),this.options.timer=setTimeout(s.bind(this._updateBreakPoints,this),300)},_changeInteractions:function(t){"edit"===t.perm?(this._lMarginDrag.style.cursor="e-resize",this._rMarginDrag.style.cursor="w-resize",s.DomEvent.on(this._rMarginDrag,"mousedown",this._initiateDrag,this),s.DomEvent.on(this._lMarginDrag,"mousedown",this._initiateDrag,this)):(this._lMarginDrag.style.cursor="default",this._rMarginDrag.style.cursor="default",s.DomEvent.off(this._rMarginDrag,"mousedown",this._initiateDrag,this),s.DomEvent.off(this._lMarginDrag,"mousedown",this._initiateDrag,this))},_initLayout:function(){return this._rWrapper=s.DomUtil.create("div","loleaflet-ruler leaflet-bar leaflet-control leaflet-control-custom"),this._rFace=s.DomUtil.create("div","loleaflet-ruler-face",this._rWrapper),this._rMarginWrapper=s.DomUtil.create("div","loleaflet-ruler-marginwrapper",this._rFace),this._rBPWrapper=s.DomUtil.create("div","loleaflet-ruler-breakwrapper",this._rFace),this._rBPContainer=s.DomUtil.create("div","loleaflet-ruler-breakcontainer",this._rBPWrapper),this._rWrapper},_updateOptions:function(t){this.options.margin1=parseInt(t.margin1),this.options.margin2=parseInt(t.margin2),this.options.nullOffset=parseInt(t.leftOffset),this.options.pageWidth=parseInt(t.pageWidth),this._updateBreakPoints()},_updateBreakPoints:function(){if(null!=this.options.margin1&&null!=this.options.margin2){0!==this._map._docLayer._annotations._items.length&&this.options.marginSet||(this.options.extraSize=0);var t,e,i,n,o,a="loleaflet-ruler-maj",r="loleaflet-ruler-margin",l="loleaflet-ruler-drag",h="loleaflet-ruler-right",d="loleaflet-ruler-left",u="loleaflet-ruler-ltooltip",c="loleaflet-ruler-rtooltip",p=_("Left Margin"),m=_("Right Margin");e=this.options.nullOffset,i=this.options.pageWidth-(this.options.nullOffset+this.options.margin2),o=this._map.getZoomScale(this._map.getZoom(),10),n=this._map._docLayer._docPixelSize.x-(this.options.extraSize+2*this.options.tileMargin)*o,this._fixOffset(),t=this.options.DraggableConvertRatio=n/this.options.pageWidth,this._rFace.style.width=n+"px",this._rBPContainer.style.marginLeft=-1*(t*(500-e%1e3))+1+"px";var g=-1*parseInt(e/1e3);$("."+a).remove();for(var f=0;f<=this.options.pageWidth/1e3+1;f++){var v=s.DomUtil.create("div",a,this._rBPContainer);v.style.width=1e3*t-2+"px",this.options.displayNumber&&(0!==g?v.innerText=Math.abs(g++):g++)}this.options.marginSet||(this.options.marginSet=!0,this._lMarginMarker=s.DomUtil.create("div",r+" "+d,this._rFace),this._rMarginMarker=s.DomUtil.create("div",r+" "+h,this._rFace),this._lMarginDrag=s.DomUtil.create("div",l+" "+d,this._rMarginWrapper),this._lToolTip=s.DomUtil.create("div",u,this._lMarginDrag),this._rMarginDrag=s.DomUtil.create("div",l+" "+h,this._rMarginWrapper),this._rToolTip=s.DomUtil.create("div",c,this._rMarginDrag),this._lMarginDrag.title=p,this._rMarginDrag.title=m),this._lMarginMarker.style.width=t*e+"px",this._rMarginMarker.style.width=t*i+"px",this._lMarginDrag.style.width=t*e+"px",this._rMarginDrag.style.width=t*i+"px",this.options.interactive?this._changeInteractions({perm:"edit"}):this._changeInteractions({perm:"readonly"})}},_fixOffset:function(){var t=this._map.getZoomScale(this._map.getZoom(),10),e=this._map._mapPane,i=this._map._docLayer._tiles,n=Object.keys(i)[0],o=parseInt(n.match(/(\d*):/)[1]),s=i[n].el,a=parseInt(s.style.left)-this._map._docLayer._tileWidthPx*o,r=e.getElementsByClassName("leaflet-tile-container");r=r[r.length-1];var l=parseInt(r.style.transform.match(/\(([-0-9]*)/)[1]),h=parseInt(e.style.transform.match(/\(([-0-9]*)/)[1]),d=h+a+l+this.options.tileMargin*t;this._rFace.style.marginLeft=d+"px"},_initiateDrag:function(t){this._map.rulerActive=!0;var e=t.srcElement||t.target;s.DomEvent.on(this._rFace,"mousemove",this._moveMargin,this),s.DomEvent.on(this._map,"mouseup",this._endDrag,this),this._initialposition=t.clientX,s.DomUtil.hasClass(e,"loleaflet-ruler-right")?(s.DomUtil.addClass(this._rMarginDrag,"leaflet-drag-moving"),this._rFace.style.cursor="w-resize"):(s.DomUtil.addClass(this._lMarginDrag,"leaflet-drag-moving"),this._rFace.style.cursor="e-resize")},_moveMargin:function(t){var e=t.clientX-this._initialposition,i=this.options.unit?this.options.unit:" cm";if(s.DomUtil.hasClass(this._rMarginDrag,"leaflet-drag-moving")){var n=this.options.pageWidth-(this.options.nullOffset+this.options.margin2),o=this.options.DraggableConvertRatio*n-e;this._rToolTip.style.display="block",this._rToolTip.style.right=o-25+"px",this._rToolTip.innerText=(Math.round(this.options.pageWidth/100-o/(100*this.options.DraggableConvertRatio))/10).toString()+i,this._rMarginDrag.style.width=o+"px"}else o=this.options.DraggableConvertRatio*this.options.nullOffset+e,this._lToolTip.style.display="block",this._lToolTip.style.left=o-25+"px",this._lToolTip.innerText=(Math.round(o/(100*this.options.DraggableConvertRatio))/10).toString()+i,this._lMarginDrag.style.width=o+"px"},_endDrag:function(t){this._map.rulerActive=!1;var e,i,n=t.originalEvent.clientX-this._initialposition,o={};s.DomEvent.off(this._rFace,"mousemove",this._moveMargin,this),s.DomEvent.off(this._map,"mouseup",this._endDrag,this),s.DomUtil.hasClass(this._rMarginDrag,"leaflet-drag-moving")?(e="Margin2",i=-1,s.DomUtil.removeClass(this._rMarginDrag,"leaflet-drag-moving"),this._rToolTip.style.display="none"):(e="Margin1",i=1,s.DomUtil.removeClass(this._lMarginDrag,"leaflet-drag-moving"),this._lToolTip.style.display="none"),this._rFace.style.cursor="default",o[e]={},o[e].type="string",o[e].value=i*n/(this.options.DraggableConvertRatio*this.options.pageWidth),this._map._socket.sendMessage("uno .uno:RulerChangeState "+JSON.stringify(o))}}),s.control.ruler=function(t){return new s.Control.Ruler(t)},s.PosAnimation=s.Class.extend({includes:s.Mixin.Events,run:function(t,e,i,n){this.stop(),this._el=t,this._inProgress=!0,this._newPos=e,this.fire("start"),t.style[s.DomUtil.TRANSITION]="all "+(i||.25)+"s cubic-bezier(0,0,"+(n||.5)+",1)",s.DomEvent.on(t,s.DomUtil.TRANSITION_END,this._onTransitionEnd,this),s.DomUtil.setPosition(t,e),s.Util.falseFn(t.offsetWidth),this._stepTimer=setInterval(s.bind(this._onStep,this),50)},stop:function(){this._inProgress&&(s.DomUtil.setPosition(this._el,this._getPos()),this._onTransitionEnd(),s.Util.falseFn(this._el.offsetWidth))},_onStep:function(){var t=this._getPos();return t?(this._el._leaflet_pos=t,void this.fire("step")):void this._onTransitionEnd()},_transformRe:/([-+]?(?:\d*\.)?\d+)\D*, ([-+]?(?:\d*\.)?\d+)\D*\)/,_getPos:function(){var e,i,n,o=this._el,a=t.getComputedStyle(o);if(s.Browser.any3d){if(n=a[s.DomUtil.TRANSFORM].match(this._transformRe),!n)return;e=parseFloat(n[1]),i=parseFloat(n[2])}else e=parseFloat(a.left),i=parseFloat(a.top);return new s.Point(e,i,!0)},_onTransitionEnd:function(){s.DomEvent.off(this._el,s.DomUtil.TRANSITION_END,this._onTransitionEnd,this),this._inProgress&&(this._inProgress=!1,this._el.style[s.DomUtil.TRANSITION]="",this._el._leaflet_pos=this._newPos,clearInterval(this._stepTimer),this.fire("step").fire("end"))}}),s.Map.include({setView:function(t,e,n){if(e=e===i?this._zoom:this._limitZoom(e),t=this._limitCenter(s.latLng(t),e,this.options.maxBounds),n=n||{},this.stop(),this._loaded&&!n.reset&&n!==!0){n.animate!==i&&(n.zoom=s.extend({animate:n.animate},n.zoom),n.pan=s.extend({animate:n.animate},n.pan));var o=this._zoom!==e?this._tryAnimatedZoom&&this._tryAnimatedZoom(t,e,n.zoom):this._tryAnimatedPan(t,n.pan);if(o)return clearTimeout(this._sizeTimer),this}return this._resetView(t,e),this},panBy:function(t,e){if(t=s.point(t).round(),e=e||{},!t.x&&!t.y)return this;if(e.animate!==!0&&!this.getSize().contains(t))return this._resetView(this.unproject(this.project(this.getCenter()).add(t)),this.getZoom()),this;if(this._panAnim||(this._panAnim=new s.PosAnimation,this._panAnim.on({step:this._onPanTransitionStep,end:this._onPanTransitionEnd},this)),e.noMoveStart||this.fire("movestart"),e.animate===!0){s.DomUtil.addClass(this._mapPane,"leaflet-pan-anim");var i=this._getMapPanePos().subtract(t);this._panAnim.run(this._mapPane,i,e.duration||.25,e.easeLinearity)}else this._rawPanBy(t),this.fire("move").fire("moveend");return this},_onPanTransitionStep:function(){this.fire("move")},_onPanTransitionEnd:function(){s.DomUtil.removeClass(this._mapPane,"leaflet-pan-anim"),this.fire("moveend")},_tryAnimatedPan:function(t,e){var i=this._getCenterOffset(t)._floor();return(e&&e.animate)===!0||this.getSize().contains(i)?(this.panBy(i,e),(e&&e.animate)!==!1):!1}}),s.PosAnimation=s.DomUtil.TRANSITION?s.PosAnimation:s.PosAnimation.extend({run:function(t,e,i,n){this.stop(),this._el=t,this._inProgress=!0,this._duration=i||.25,this._easeOutPower=1/Math.max(n||.5,.2),this._startPos=s.DomUtil.getPosition(t),this._offset=e.subtract(this._startPos),this._startTime=+new Date,this.fire("start"),this._animate()},stop:function(){this._inProgress&&(this._step(),this._complete())},_animate:function(){this._animId=s.Util.requestAnimFrame(this._animate,this),this._step()},_step:function(){var t=+new Date-this._startTime,e=1e3*this._duration;e>t?this._runFrame(this._easeOut(t/e)):(this._runFrame(1),this._complete())},_runFrame:function(t){var e=this._startPos.add(this._offset.multiplyBy(t));s.DomUtil.setPosition(this._el,e),this.fire("step")},_complete:function(){s.Util.cancelAnimFrame(this._animId),this._inProgress=!1,this.fire("end")},_easeOut:function(t){return 1-Math.pow(1-t,this._easeOutPower)}}),s.Map.mergeOptions({zoomAnimation:!0,zoomAnimationThreshold:4});var h=s.DomUtil.TRANSITION&&s.Browser.any3d&&!s.Browser.mobileOpera;h&&s.Map.addInitHook(function(){this._zoomAnimated=this.options.zoomAnimation,this._zoomAnimated&&(this._createAnimProxy(),s.DomEvent.on(this._proxy,s.DomUtil.TRANSITION_END,this._catchTransitionEnd,this))}),s.Map.include(h?{_createAnimProxy:function(){var t=this._proxy=s.DomUtil.create("div","leaflet-proxy leaflet-zoom-animated");this._panes.mapPane.appendChild(t),this.on("zoomanim",function(e){var i=s.DomUtil.TRANSFORM,n=t.style[i];s.DomUtil.setTransform(t,this.project(e.center,e.zoom),this.getZoomScale(e.zoom,1)),n===t.style[i]&&this._animatingZoom&&this._onZoomTransitionEnd()},this),this.on("load moveend",function(){var e=this.getCenter(),i=this.getZoom();s.DomUtil.setTransform(t,this.project(e,i),this.getZoomScale(i,1))},this)},_catchTransitionEnd:function(t){this._animatingZoom&&t.propertyName.indexOf("transform")>=0&&this._onZoomTransitionEnd()},_nothingToAnimate:function(){return!this._container.getElementsByClassName("leaflet-zoom-animated").length},_tryAnimatedZoom:function(t,e,i){if(this._animatingZoom)return!0;if(i=i||{},!this._zoomAnimated||i.animate===!1||this._nothingToAnimate()||Math.abs(e-this._zoom)>this.options.zoomAnimationThreshold)return!1;var n=this.getZoomScale(e),o=this._getCenterOffset(t)._divideBy(1-1/n);return i.animate===!0||this.getSize().contains(o)?(s.Util.requestAnimFrame(function(){this.fire("movestart").fire("zoomstart")._animateZoom(t,e,!0)},this),!0):!1},_animateZoom:function(t,e,i,n){i&&(this._animatingZoom=!0,this._animateToCenter=t,this._animateToZoom=e,s.DomUtil.addClass(this._mapPane,"leaflet-zoom-anim")),this.fire("zoomanim",{center:t,zoom:e,scale:this.getZoomScale(e),origin:this.latLngToLayerPoint(t),offset:this._getCenterOffset(t).multiplyBy(-1),noUpdate:n})},_onZoomTransitionEnd:function(){this._animatingZoom=!1,s.DomUtil.removeClass(this._mapPane,"leaflet-zoom-anim"),this._resetView(this._animateToCenter,this._animateToZoom,!0,!0)}}:{}),s.Map.include({flyTo:function(t,e){function n(t){var e=(f*f-g*g+(t?-1:1)*w*w*v*v)/(2*(t?f:g)*w*v);return Math.log(Math.sqrt(e*e+1)-e)}function o(t){return(Math.exp(t)-Math.exp(-t))/2}function a(t){return(Math.exp(t)+Math.exp(-t))/2}function r(t){return o(t)/a(t)}function l(t){return g*(a(C)/a(C+y*t))}function h(t){return g*(a(C)*r(C+y*t)-o(C))/w}function d(t){return 1-Math.pow(1-t,1.5)}function u(){var i=(Date.now()-x)/P,n=d(i)*b;1>=i?(this._flyToFrame=s.Util.requestAnimFrame(u,this),this._resetView(this.unproject(c.add(_.subtract(c).multiplyBy(h(n)/v)),m),this.getScaleZoom(g/l(n),m),!0,!0)):this._resetView(t,e,!0,!0)}this.stop();var c=this.project(this.getCenter()),_=this.project(t),p=this.getSize(),m=this._zoom;t=s.latLng(t),e=e===i?m:e;var g=Math.max(p.x,p.y),f=g*this.getZoomScale(m,e),v=_.distanceTo(c),y=1.42,w=y*y,C=n(0),x=Date.now(),b=(n(1)-C)/y,P=1e3*b*.8;this.fire("zoomstart"),u.call(this)}}),s.Map.include({_defaultLocateOptions:{timeout:1e4,watch:!1},locate:function(t){if(t=this._locateOptions=s.extend({},this._defaultLocateOptions,t),!navigator.geolocation)return this._handleGeolocationError({code:0,message:"Geolocation not supported."}),this;var e=s.bind(this._handleGeolocationResponse,this),i=s.bind(this._handleGeolocationError,this);return t.watch?this._locationWatchId=navigator.geolocation.watchPosition(e,i,t):navigator.geolocation.getCurrentPosition(e,i,t),this},stopLocate:function(){return navigator.geolocation&&navigator.geolocation.clearWatch(this._locationWatchId),this._locateOptions&&(this._locateOptions.setView=!1),this},_handleGeolocationError:function(t){var e=t.code,i=t.message||(1===e?"permission denied":2===e?"position unavailable":"timeout");this._locateOptions.setView&&!this._loaded&&this.fitWorld(),this.fire("locationerror",{code:e,message:"Geolocation error: "+i+"."})},_handleGeolocationResponse:function(t){var e=t.coords.latitude,i=t.coords.longitude,n=new s.LatLng(e,i),o=n.toBounds(t.coords.accuracy),a=this._locateOptions;
if(a.setView){var r=this.getBoundsZoom(o);this.setView(n,a.maxZoom?Math.min(r,a.maxZoom):r)}var l={latlng:n,bounds:o,timestamp:t.timestamp};for(var h in t.coords)"number"==typeof t.coords[h]&&(l[h]=t.coords[h]);this.fire("locationfound",l)}}),s.AnnotationManager=s.Class.extend({options:{marginX:40,marginY:10,offset:5,extraSize:s.point(290,0)},initialize:function(t,e){this._map=t,this._items=[],this._selected=null,s.setOptions(this,e),this._arrow=s.polyline([],{color:"darkblue",weight:1}),this._map.on("zoomend",this._onAnnotationZoom,this),this._map.on("AnnotationCancel",this._onAnnotationCancel,this),this._map.on("AnnotationClick",this._onAnnotationClick,this),this._map.on("AnnotationReply",this._onAnnotationReply,this),this._map.on("AnnotationSave",this._onAnnotationSave,this),this._map.on("RedlineAccept",this._onRedlineAccept,this),this._map.on("RedlineReject",this._onRedlineReject,this)},clear:function(){for(var t=0;t<this._items.length;)this._items[t].trackchange?t++:(this._map.removeLayer(this._items[t]),this._items.splice(t,1));this._selected=null,this._map.removeLayer(this._arrow)},clearChanges:function(){for(var t=0;t<this._items.length;)this._items[t].trackchange?(this._map.removeLayer(this._items[t]),this._items.splice(t,1)):t++},adjustComment:function(t){var e,i,n;t.trackchange=!1,e=s.PolyUtil.rectanglesToPolygons(s.LOUtil.stringToRectangles(t.textRange||t.anchorPos),this._map._docLayer),t.anchorPos=s.LOUtil.stringToBounds(t.anchorPos),t.anchorPix=this._map._docLayer._twipsToPixels(t.anchorPos.min),n=this._map.getViewId(t.author),i=n>=0?s.LOUtil.rgbToHex(this._map.getViewColor(n)):"#43ACE8",e.length>0&&(t.textSelected=s.polygon(e,{pointerEvents:"all",interactive:!1,fillColor:i,fillOpacity:.25,weight:2,opacity:.25}),s.DomEvent.on(t.textSelected,"contextmenu",s.DomEvent.preventDefault),t.textSelected.on("click",function(e){var i=this._map.mouseEventToLatLng(e.originalEvent),n=this._map._docLayer._latLngToTwips(i);this._map._docLayer._postMouseEvent("buttondown",n.x,n.y,1,1,0),this._map._docLayer._postMouseEvent("buttonup",n.x,n.y,1,1,0),this.selectById(t.id)},this))},adjustRedLine:function(t){if(!t.textRange)return console.warn("Redline received has invalid textRange"),!1;t.id="change-"+t.index,t.anchorPos=s.LOUtil.stringToBounds(t.textRange),t.anchorPix=this._map._docLayer._twipsToPixels(t.anchorPos.min),t.trackchange=!0,t.text=t.comment;var e=s.PolyUtil.rectanglesToPolygons(s.LOUtil.stringToRectangles(t.textRange),this._map._docLayer);return e.length>0&&(t.textSelected=s.polygon(e,{pointerEvents:"all",interactive:!1,fillOpacity:0,opacity:0}),s.DomEvent.on(t.textSelected,"contextmenu",s.DomEvent.preventDefault),t.textSelected.on("click",function(e){var i=this._map.mouseEventToLatLng(e.originalEvent),n=this._map._docLayer._latLngToTwips(i);this._map._docLayer._postMouseEvent("buttondown",n.x,n.y,1,1,0),this._map._docLayer._postMouseEvent("buttonup",n.x,n.y,1,1,0),this.selectById(t.id)},this)),!0},fill:function(t){var e;this.clear();var i=!this._items.length;for(var n in t)e=t[n],this.adjustComment(e),e.author in this._map._viewInfoByUserName&&(e.avatar=this._map._viewInfoByUserName[e.author].userextrainfo.avatar),this._items.push(s.annotation(this._map.options.docBounds.getSouthEast(),e).addTo(this._map));this._items.length>0&&(i||this._items.sort(function(t,e){return Math.abs(t._data.anchorPos.min.y)-Math.abs(e._data.anchorPos.min.y)||Math.abs(t._data.anchorPos.min.x)-Math.abs(e._data.anchorPos.min.x)}),this.layout())},fillChanges:function(t){var e;this.clearChanges();var i=!this._items.length;for(var n in t)e=t[n],this.adjustRedLine(e)&&(e.author in this._map._viewInfoByUserName&&(e.avatar=this._map._viewInfoByUserName[e.author].userextrainfo.avatar),this._items.push(s.annotation(this._map.options.docBounds.getSouthEast(),e).addTo(this._map)));this._items.length>0&&(i||this._items.sort(function(t,e){return Math.abs(t._data.anchorPos.min.y)-Math.abs(e._data.anchorPos.min.y)||Math.abs(t._data.anchorPos.min.x)-Math.abs(e._data.anchorPos.min.x)}),this.layout())},getItem:function(t){for(var e in this._items)if(this._items[e]._data.id===t)return this._items[e];return null},getIndexOf:function(t){for(var e=0;e<this._items.length;e++)if(this._items[e]._data.id===t)return e;return-1},getRootIndexOf:function(t){for(var e=this.getIndexOf(t),i=e-1;i>=0&&this._items[i]._data.id===this._items[i+1]._data.parent;i--)e=i;return e},getLastChildIndexOf:function(t){for(var e=this.getIndexOf(t),i=e+1;i<this._items.length&&this._items[i]._data.parent===this._items[i-1]._data.id;i++)e=i;return e},removeItem:function(t){var e;for(var i in this._items)if(e=this._items[i],e._data.id===t)return this._items.splice(i,1),e},unselect:function(){this._selected&&(this._selected=null,this.update())},select:function(t){if(t){var e=this.getRootIndexOf(t._data.id);this._selected=this._items[e],this.update()}},selectById:function(t){var e=this.getRootIndexOf(t);this._selected=this._items[e],this.update()},update:function(){if(this._selected){var t,e=this._map.project(this._map.options.docBounds.getNorthEast());t=this._map._docLayer._twipsToPixels(this._selected._data.anchorPos.min),this._arrow.setLatLngs([this._map.unproject(t),this._map.unproject(s.point(e.x,t.y))]),this._map.addLayer(this._arrow)}else this._map.removeLayer(this._arrow);this.layout()},updateDocBounds:function(){0===this._items.length&&this._map.fire("updatemaxbounds",{sizeChanged:!0})},layoutUp:function(t,e,i){if(!(t.length<=0)){(new s.PosAnimation).run(t[0]._container,this._map.latLngToLayerPoint(e)),t[0].setLatLng(e);for(var n=t[0].getBounds(),o=1;o<t.length;)n.extend(n.max.add([0,t[o].getBounds().getSize().y])),o++;var a;for(i.intersects(n)?(i.extend(i.min.subtract([0,n.getSize().y])),a=i.min):(a=n.min,i.extend(n.min)),i.extend(i.min.subtract([0,this.options.marginY])),o=0,o=0;o<t.length;++o){e=this._map.layerPointToLatLng(a),(new s.PosAnimation).run(t[o]._container,this._map.latLngToLayerPoint(e)),t[o].setLatLng(e),t[o].show();var r=t[o].getBounds();a=a.add([0,r.getSize().y])}}},layoutDown:function(t,e,i){if(!(t.length<=0)){(new s.PosAnimation).run(t[0]._container,this._map.latLngToLayerPoint(e)),t[0].setLatLng(e);for(var n=t[0].getBounds(),o=1;o<t.length;)n.extend(n.max.add([0,t[o].getBounds().getSize().y])),o++;var a;for(i.intersects(n)?(a=i.getBottomLeft(),i.extend(i.max.add([0,n.getSize().y]))):(a=n.min,i.extend(n.max)),i.extend(i.max.add([0,this.options.marginY])),o=0,o=0;o<t.length;++o){e=this._map.layerPointToLatLng(a),(new s.PosAnimation).run(t[o]._container,this._map.latLngToLayerPoint(e)),t[o].setLatLng(e),t[o].show();var r=t[o].getBounds();a=a.add([0,r.getSize().y])}}},layout:function(t){var e,i,n,o,a=this._map.project(this._map.options.docBounds.getNorthEast()),r=a.add(s.point(this.options.marginX,this.options.marginY));if(this._selected){var l=this.getRootIndexOf(this._selected._data.id),h=this.getLastChildIndexOf(this._selected._data.id);for(t&&(this._items[l]._data.anchorPix=this._map._docLayer._twipsToPixels(this._items[l]._data.anchorPos.min)),e=this._map.unproject(s.point(a.x,this._items[l]._data.anchorPix.y)),(new s.PosAnimation).run(this._items[l]._container,this._map.latLngToLayerPoint(e)),this._items[l].setLatLng(e),i=this._items[l].getBounds(),o=l+1;h>=o;o++){t&&(this._items[o]._data.anchorPix=this._map._docLayer._twipsToPixels(this._items[o]._data.anchorPos.min)),e=this._map.layerPointToLatLng(i.getBottomLeft()),(new s.PosAnimation).run(this._items[o]._container,i.getBottomLeft()),this._items[o].setLatLng(e);var d=this._items[o].getBounds();i.extend(i.max.add([0,d.getSize().y]))}for(i.min=i.min.add([this.options.marginX,0]),i.max=i.max.add([this.options.marginX,0]),i.extend(i.min.subtract([0,this.options.marginY])),i.extend(i.max.add([0,this.options.marginY])),o=l-1;o>=0;){var u=[],c=o;do t&&(this._items[o]._data.anchorPix=this._map._docLayer._twipsToPixels(this._items[o]._data.anchorPos.min)),u.push(this._items[c]),c-=1;while(c>=0&&this._items[c]._data.id===this._items[c+1]._data.parent);u.reverse(),this.layoutUp(u,this._map.unproject(s.point(r.x,u[0]._data.anchorPix.y)),i),o-=u.length}for(o=h+1;o<this._items.length;){u=[],c=o;do t&&(this._items[o]._data.anchorPix=this._map._docLayer._twipsToPixels(this._items[o]._data.anchorPos.min)),u.push(this._items[c]),c+=1;while(c<this._items.length&&this._items[c]._data.parent===this._items[c-1]._data.id);this.layoutDown(u,this._map.unproject(s.point(r.x,u[0]._data.anchorPix.y)),i),o+=u.length}this._selected.isEdit()||this._selected.show()}else for(n=this._map.latLngToLayerPoint(this._map.unproject(r)),i=s.bounds(n,n),o=0;o<this._items.length;){u=[],c=o;do t&&(this._items[c]._data.anchorPix=this._map._docLayer._twipsToPixels(this._items[c]._data.anchorPos.min)),u.push(this._items[c]),c+=1;while(c<this._items.length&&this._items[c]._data.parent===this._items[c-1]._data.id);this.layoutDown(u,this._map.unproject(s.point(r.x,u[0]._data.anchorPix.y)),i),o+=u.length}},add:function(t){var e=s.annotation(this._map._docLayer._twipsToLatLng(t.anchorPos.getTopRight()),t,"new"===t.id?{noMenu:!0}:{}).addTo(this._map);if(t.parent&&t.parent>"0"){var i=this.getIndexOf(t.parent);this._items.splice(i+1,0,e)}else this._items.push(e);return this._items.sort(function(t,e){return Math.abs(t._data.anchorPos.min.y)-Math.abs(e._data.anchorPos.min.y)||Math.abs(t._data.anchorPos.min.x)-Math.abs(e._data.anchorPos.min.x)}),e},edit:function(t){var e=s.annotation(this._map._docLayer._twipsToLatLng(t.anchorPos.getTopRight()),t).addTo(this._map);e.edit(),e.focus()},modify:function(t){t.edit(),this.select(t),t.focus()},reply:function(t){t.reply(),this.select(t),t.focus()},remove:function(t){var e={Id:{type:"string",value:t}};this._map.sendUnoCommand(".uno:DeleteComment",e),this.unselect(),this._map.focus()},_onRedlineAccept:function(t){var e={AcceptTrackedChange:{type:"unsigned short",value:t.id.substring("change-".length)}};this._map.sendUnoCommand(".uno:AcceptTrackedChange",e),this.unselect(),this._map.focus()},_onRedlineReject:function(t){var e={RejectTrackedChange:{type:"unsigned short",value:t.id.substring("change-".length)}};this._map.sendUnoCommand(".uno:RejectTrackedChange",e),this.unselect(),this._map.focus()},adjustParentAdd:function(t){if(t.parent&&t.parent>"0"){var e=this.getIndexOf(t.parent);if(-1===e)return void console.warn("adjustParentAdd: No parent comment to attach received comment to. Parent comment ID sought is :"+t.parent+" for current comment with ID : "+t.id);this._items[e+1]&&this._items[e+1]._data.parent===this._items[e]._data.id&&(this._items[e+1]._data.parent=t.id)}},adjustParentRemove:function(t){var e="0",i=this.getIndexOf(t._data.parent);i>=0&&(e=this._items[i]._data.id);var n=this.getIndexOf(t._data.id);this._items[n+1]&&this._items[n].parentOf(this._items[n+1])&&(this._items[n+1]._data.parent=e)},onACKComment:function(t){var e,i=t.redline?!0:!1,n=i?t.redline.action:t.comment.action;if(i&&t.redline.author in this._map._viewInfoByUserName?t.redline.avatar=this._map._viewInfoByUserName[t.redline.author].userextrainfo.avatar:!i&&t.comment.author in this._map._viewInfoByUserName&&(t.comment.avatar=this._map._viewInfoByUserName[t.comment.author].userextrainfo.avatar),"Add"===n){if(i){if(!this.adjustRedLine(t.redline))return;this.add(t.redline)}else this.adjustComment(t.comment),this.adjustParentAdd(t.comment),this.add(t.comment);this._selected&&!this._selected.isEdit()&&this._map.focus(),this.layout()}else if("Remove"===n){e=i?"change-"+t.redline.index:t.comment.id;var o=this.getItem(e);o&&(this.adjustParentRemove(o),this._map.removeLayer(this.removeItem(e)),this._selected===o?this.unselect():this.layout()),this.updateDocBounds()}else if("Modify"===n){e=i?"change-"+t.redline.index:t.comment.id;var s=this.getItem(e);if(s){var a;if(i){if(!this.adjustRedLine(t.redline))return;a=t.redline}else this.adjustComment(t.comment),a=t.comment;s.setData(a),s.update(),this.update()}}},_onAnnotationCancel:function(t){"new"===t.annotation._data.id&&(this._map.removeLayer(this.removeItem(t.annotation._data.id)),this.updateDocBounds()),this._selected===t.annotation?this.unselect():this.layout(),this._map.focus()},_onAnnotationClick:function(t){this.select(t.annotation)},_onAnnotationReply:function(t){var e={Id:{type:"string",value:t.annotation._data.id},Text:{type:"string",value:t.annotation._data.reply}};this._map.sendUnoCommand(".uno:ReplyComment",e),this.unselect(),this._map.focus()},_onAnnotationSave:function(t){var e;"new"===t.annotation._data.id?(e={Text:{type:"string",value:t.annotation._data.text},Author:{type:"string",value:t.annotation._data.author}},this._map.sendUnoCommand(".uno:InsertAnnotation",e),this._map.removeLayer(this.removeItem(t.annotation._data.id))):t.annotation._data.trackchange?(e={ChangeTrackingId:{type:"long",value:t.annotation._data.index},Text:{type:"string",value:t.annotation._data.text}},this._map.sendUnoCommand(".uno:CommentChangeTracking",e)):(e={Id:{type:"string",value:t.annotation._data.id},Text:{type:"string",value:t.annotation._data.text}},this._map.sendUnoCommand(".uno:EditAnnotation",e)),this.unselect(),this._map.focus()},_onAnnotationZoom:function(){this._map.fire("updatemaxbounds",{sizeChanged:!0}),this.layout(!0)}}),s.Map.include({insertComment:function(){this._docLayer.newAnnotation({text:"",textrange:"",author:this.getViewName(this._docLayer._viewId),dateTime:(new Date).toDateString(),id:"new"})}}),s.annotationManager=function(t,e){return new s.AnnotationManager(t,e)},s.Control.Scroll.Annotation=s.Control.extend({options:{position:"topright",arrowUp:"0x25b2",arrowUpTitle:_("Scroll up annotations"),arrowDown:"0x25bc",arrowDownTitle:_("Scroll down annotations")},onAdd:function(t){var e="leaflet-control-scroll",i=s.DomUtil.create("div","loleaflet-bar");return this._map=t,this._buttonUp=this._createButton(this.options.arrowUp,this.options.arrowUpTitle,e+"-up",i,this._onScrollUp,this),this._buttonDown=this._createButton(this.options.arrowDown,this.options.arrowDownTitle,e+"-down",i,this._onScrollDown,this),i},_onScrollUp:function(){this._map.fire("AnnotationScrollUp")},_onScrollDown:function(){this._map.fire("AnnotationScrollDown")},_createButton:function(t,e,i,n,o,a){var r=s.DomUtil.create("a",i,n);r.innerHTML=String.fromCharCode(t),r.href="#",r.title=e;var l=s.DomEvent.stopPropagation;return s.DomEvent.on(r,"click",l).on(r,"mousedown",l).on(r,"dblclick",l).on(r,"click",s.DomEvent.preventDefault).on(r,"click",o,a),r}}),s.control.scroll.annotation=function(t){return new s.Control.Scroll.Annotation(t)},s.Annotation=s.Layer.extend({options:{minWidth:160,maxHeight:50,imgSize:s.point([32,32]),margin:s.point([40,40]),noMenu:!1},initialize:function(t,e,i){s.setOptions(this,i),this._latlng=s.latLng(t),this._data=e},onAdd:function(t){this._map=t,this._container||this._initLayout(),t._panes.popupPane.appendChild(this._container),this.update()},addTo:function(t){return t.addLayer(this),this},onRemove:function(t){t._panes.popupPane.removeChild(this._container),this._data.textSelected&&this._map.removeLayer(this._data.textSelected),this._map=null},update:function(){this._map&&(this._updateContent(),this._updateLayout(),this._updatePosition())},setData:function(t){this._data.textSelected&&this._map.removeLayer(this._data.textSelected),this._data=t},setLatLng:function(t){return this._latlng!=t&&(this._latlng=t,this._updatePosition()),this},getBounds:function(){var t=this._map.latLngToLayerPoint(this._latlng);return s.bounds(t,t.add(s.point(this._container.offsetWidth,this._container.offsetHeight)))},show:function(){this._container.style.visibility="",this._contentNode.style.display="",this._nodeModify.style.display="none",this._nodeReply.style.display="none",this._data.textSelected&&!this._map.hasLayer(this._data.textSelected)&&this._map.addLayer(this._data.textSelected)},hide:function(){this._container.style.visibility="hidden",this._contentNode.style.display="none",this._nodeModify.style.display="none",this._nodeReply.style.display="none",this._data.textSelected&&this._map.hasLayer(this._data.textSelected)&&this._map.removeLayer(this._data.textSelected)},edit:function(){return this._container.style.visibility="",this._contentNode.style.display="none",this._nodeModify.style.display="",this._nodeReply.style.display="none",this},reply:function(){return this._container.style.visibility="",this._contentNode.style.display="",this._nodeModify.style.display="none",this._nodeReply.style.display="",this},isEdit:function(){return this._nodeModify&&"none"!==this._nodeModify.style.display||this._nodeReply&&"none"!==this._nodeReply.style.display},focus:function(){this._nodeModifyText.focus(),this._nodeReplyText.focus()},parentOf:function(t){return this._data.id===t._data.parent},_checkBounds:function(){if(this._map&&!this._map.animatingZoom&&this._container.style&&""===this._container.style.visibility){var t=this._map.getLayerMaxBounds(),e=this.getBounds();if(!t.contains(e)){var i=this._map.getLayerDocBounds(),n=s.point(Math.max(e.max.x-i.max.x,0),Math.max(e.max.y-i.max.y,0));n.x>0&&(n.x+=this.options.margin.x),n.y>0&&(n.y+=this.options.margin.y),this._map.fire("updatemaxbounds",{sizeChanged:!0,extraSize:n})}}},_createButton:function(t,e,i){var n=s.DomUtil.create("input","loleaflet-controls",t);n.type="button",n.value=e,s.DomEvent.on(n,"mousedown",s.DomEvent.preventDefault),s.DomEvent.on(n,"click",i,this)},_initLayout:function(){var t,e="td",i="div",n="",o="click",a="textarea",r=_("Cancel"),l="loleaflet-annotation-textarea",h="loleaflet-annotation-edit",d=this._container=s.DomUtil.create(i,"loleaflet-annotation");if(this._data.trackchange)var u=this._wrapper=s.DomUtil.create(i,"loleaflet-annotation-redline-content-wrapper",d);else u=this._wrapper=s.DomUtil.create(i,"loleaflet-annotation-content-wrapper",d);this._author=s.DomUtil.create("table","loleaflet-annotation-table",u);var c=s.DomUtil.create("tbody",n,this._author),p=s.DomUtil.create("tr",n,c),m=s.DomUtil.create(e,"loleaflet-annotation-img",p),g=s.DomUtil.create(e,"loleaflet-annotation-author",p),f=s.DomUtil.create("img",n,m);if(f.setAttribute("src",s.Icon.Default.imagePath+"/user.png"),f.setAttribute("width",this.options.imgSize.x),f.setAttribute("height",this.options.imgSize.y),this._authorAvatarImg=f,s.DomUtil.create(i,"loleaflet-annotation-userline",m),this._contentAuthor=s.DomUtil.create(i,"loleaflet-annotation-content-author",g),this._contentDate=s.DomUtil.create(i,"loleaflet-annotation-date",g),this._data.trackchange&&"readonly"!==this._map._permission){var v=s.DomUtil.create(e,"loleaflet-annotation-menubar",p),y=s.DomUtil.create("button","loleaflet-redline-accept-button",v),w=s.DomUtil.create(e,"loleaflet-annotation-menubar",p),C=s.DomUtil.create("button","loleaflet-redline-reject-button",w);y.title=_("Accept change"),s.DomEvent.on(y,o,function(){this._map.fire("RedlineAccept",{id:this._data.id})},this),C.title=_("Reject change"),s.DomEvent.on(C,o,function(){this._map.fire("RedlineReject",{id:this._data.id})},this)}if(this.options.noMenu!==!0&&"readonly"!==this._map._permission){var x=s.DomUtil.create(e,"loleaflet-annotation-menubar",p),b=s.DomUtil.create(i,this._data.trackchange?"loleaflet-annotation-menu-redline":"loleaflet-annotation-menu",x);b.title=_("Open menu"),b.annotation=this}this._data.trackchange&&(this._captionNode=s.DomUtil.create(i,"loleaflet-annotation-caption",u),this._captionText=s.DomUtil.create(i,n,this._captionNode)),this._contentNode=s.DomUtil.create(i,"loleaflet-annotation-content loleaflet-dont-break",u),this._nodeModify=s.DomUtil.create(i,h,u),this._nodeModifyText=s.DomUtil.create(a,l,this._nodeModify),this._contentText=s.DomUtil.create(i,n,this._contentNode),this._nodeReply=s.DomUtil.create(i,h,u),this._nodeReplyText=s.DomUtil.create(a,l,this._nodeReply),t=s.DomUtil.create(i,n,this._nodeModify),s.DomEvent.on(this._nodeModifyText,"blur",this._onLostFocus,this),s.DomEvent.on(this._nodeReplyText,"blur",this._onLostFocusReply,this),this._createButton(t,_("Save"),this._onSaveComment),this._createButton(t,r,this._onCancelClick),t=s.DomUtil.create(i,n,this._nodeReply),this._createButton(t,_("Reply"),this._onReplyClick),this._createButton(t,r,this._onCancelClick),s.DomEvent.disableScrollPropagation(this._container),this._container.style.visibility="hidden",this._nodeModify.style.display="none",this._nodeReply.style.display="none";var P=[o,"dblclick","mousedown","mouseup","mouseover","mouseout","keydown","keypress","keyup"];s.DomEvent.on(d,o,this._onMouseClick,this),s.DomEvent.on(d,"mouseleave",this._onMouseLeave,this);for(var L=0;L<P.length;L++)s.DomEvent.on(d,P[L],s.DomEvent.stopPropagation,this)},_onCancelClick:function(t){s.DomEvent.stopPropagation(t),this._nodeModifyText.value=this._contentText.origText,this._nodeReplyText.value="",this.show(),this._map.fire("AnnotationCancel",{annotation:this})},_onSaveComment:function(t){s.DomEvent.stopPropagation(t),this._data.text=this._nodeModifyText.value,this._updateContent(),this.show(),this._checkBounds(),this._map.fire("AnnotationSave",{annotation:this})},_onLostFocus:function(t){this._contentText.origText!==this._nodeModifyText.value?this._onSaveComment(t):""==this._nodeModifyText.value&&this._onCancelClick(t)},_onLostFocusReply:function(t){""!==this._nodeReplyText.value&&this._onReplyClick(t)},_onMouseClick:function(t){var e=t.target||t.srcElement;return s.DomEvent.stopPropagation(t),s.DomUtil.hasClass(e,"loleaflet-annotation-menu")||s.DomUtil.hasClass(e,"loleaflet-annotation-menu-redline")?void $(e).contextMenu():(s.DomEvent.stopPropagation(t),void this._map.fire("AnnotationClick",{annotation:this}))},_onMouseLeave:function(t){var e=this._map.mouseEventToLayerPoint(t),i=this._map.layerPointToLatLng(e);s.DomEvent.stopPropagation(t),this._contextMenu||this.isEdit()||this.fire("AnnotationMouseLeave",{originalEvent:t,latlng:i,layerPoint:e})},_onReplyClick:function(t){s.DomEvent.stopPropagation(t),this._data.reply=this._nodeReplyText.value,this._nodeReplyText.value="",this.show(),this._checkBounds(),this._map.fire("AnnotationReply",{annotation:this})},_updateLayout:function(){var t=this._wrapper.style;t.width="",t.whiteSpace="nowrap",t.whiteSpace=""},_updateContent:function(){$(this._contentText).text(this._data.text);var t=Autolinker.link($(this._contentText).html());this._contentText.innerHTML=t,this._contentText.origText=this._data.text,$(this._nodeModifyText).text(this._data.text),$(this._contentAuthor).text(this._data.author),$(this._authorAvatarImg).attr("src",this._data.avatar);var e=new Date(this._data.dateTime.replace(/,.*/,"Z"));$(this._contentDate).text(isNaN(e.getTime())||"spreadsheet"===this._map.getDocType()?this._data.dateTime:e.toDateString()),this._data.trackchange&&$(this._captionText).text(this._data.description)},_updatePosition:function(){if(this._map){var t=this._map.latLngToLayerPoint(this._latlng);s.DomUtil.setPosition(this._container,t)}this._checkBounds()}}),s.annotation=function(t,e,i){return new s.Annotation(t,e,i)},s.DivOverlay=s.Layer.extend({initialize:function(t,e){this._latLngBounds=s.latLngBounds(t),s.setOptions(this,e)},onAdd:function(t){this._map=t,this._container||this._initLayout(),t._panes.overlayPane.appendChild(this._container)},onRemove:function(t){t.removeLayer(this._annotation),t._panes.overlayPane.removeChild(this._container)},setLatLngBounds:function(t){this._latLngBounds=s.latLngBounds(t),this.update()},update:function(){if(this._container&&this._map){var t=this._map.latLngToLayerPoint(this._latLngBounds.getNorthWest()),e=this._map.latLngToLayerPoint(this._latLngBounds.getSouthEast()).subtract(t);s.DomUtil.setPosition(this._container,t),this._container.style.width=e.x+"px",this._container.style.height=e.y+"px"}this._annotation&&this._annotation.setLatLng(this._latLngBounds.getNorthEast())},openAnnotation:function(){this._map&&this._annotation&&!this._map.hasLayer(this._annotation)&&!this._annotation.isEdit()&&(this._annotation.setLatLng(this._latLngBounds.getNorthEast()),this._map.addLayer(this._annotation),this._annotation.show())},editAnnotation:function(){this._map&&this._annotation&&(this._annotation.setLatLng(this._latLngBounds.getNorthEast()),this._map.addLayer(this._annotation),this._annotation.edit(),this._annotation.focus())},closePopup:function(){this._map&&this._annotation&&(this._annotation.show(),this._map.removeLayer(this._annotation))},closeAnnotation:function(t){this._map&&this._annotation&&this._map.hasLayer(this._annotation)&&!this._annotation.isEdit()&&!this._annotation.getBounds().contains(t.layerPoint)&&this._map.removeLayer(this._annotation)},_onMouseLeave:function(t){this._map&&this._annotation&&this._map.hasLayer(this._annotation)&&!this._annotation.isEdit()&&!this._latLngBounds.contains(t.latlng)&&this._map.removeLayer(this._annotation)},bindAnnotation:function(t){return this._annotation=t,this._handlersAdded||(this.on("mouseover",this.openAnnotation,this),this.on("mouseout",this.closeAnnotation,this),this._annotation.on("AnnotationMouseLeave",this._onMouseLeave,this),this._handlersAdded=!0),this},unbindAnnotation:function(){return this._annotation&&(this.off("mouseover",this.openAnnotation,this),this.off("mouseout",this.closeAnnotation,this),this._annotation.off("AnnoationMouseLeave",this._onMouseLeave,this),this._handlerAdded=!1,this._annotation=null),this},_initLayout:function(){this._container=s.DomUtil.create("div","loleaflet-div-layer"),s.DomEvent.on(this._container,"mouseover",this._fireMouseEvents,this),s.DomEvent.on(this._container,"mouseout",this._fireMouseEvents,this),s.DomUtil.setOpacity(this._container,this.options.opacity),this.update()},_fireMouseEvents:function(t){var e=this._map.mouseEventToContainerPoint(t),i=this._map.containerPointToLayerPoint(e),n=this._map.layerPointToLatLng(i);this.fire(t.type,{latlng:n,layerPoint:i,containerPoint:e,originalEvent:t})}}),s.divOverlay=function(t,e){return new s.DivOverlay(t,e)}}(window,document);