/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#ifndef OOX_SHAPE_DRAWINGFRAGMENTHANDLER
#define OOX_SHAPE_DRAWINGFRAGMENTHANDLER

#include "oox/core/fragmenthandler.hxx"
#include "oox/drawingml/shapegroupcontext.hxx"

namespace oox { namespace shape {

/// Generic (i.e. not specific to PPTX) handler for the prerendered diagram parsing.
class ShapeDrawingFragmentHandler : public oox::core::FragmentHandler
{
public:
    ShapeDrawingFragmentHandler( oox::core::XmlFilterBase& rFilter, const OUString& rFragmentPath, oox::drawingml::ShapePtr pGroupShapePtr ) throw();
    virtual ~ShapeDrawingFragmentHandler() throw();
    virtual void SAL_CALL endDocument() throw (com::sun::star::xml::sax::SAXException, com::sun::star::uno::RuntimeException);
    virtual com::sun::star::uno::Reference<com::sun::star::xml::sax::XFastContextHandler> SAL_CALL createFastChildContext(sal_Int32 Element, const com::sun::star::uno::Reference<com::sun::star::xml::sax::XFastAttributeList>& Attribs ) throw (com::sun::star::xml::sax::SAXException, com::sun::star::uno::RuntimeException);

private:
        oox::drawingml::ShapePtr        mpGroupShapePtr;
};


} }


#endif

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
