/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bson.util.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public final class MongoCredential {
    public static final String MONGODB_CR_MECHANISM = "MONGODB-CR";
    public static final String GSSAPI_MECHANISM = "GSSAPI";
    public static final String PLAIN_MECHANISM = "PLAIN";
    public static final String SCRAM_SHA_1_MECHANISM = "SCRAM-SHA-1";
    public static final String MONGODB_X509_MECHANISM = "MONGODB-X509";
    private final String mechanism;
    private final String userName;
    private final String source;
    private final char[] password;
    private final Map<String, Object> mechanismProperties;

    public static MongoCredential createCredential(String userName, String database, char[] password) {
        return new MongoCredential(null, userName, database, password);
    }

    public static MongoCredential createScramSha1Credential(String userName, String source, char[] password) {
        return new MongoCredential(SCRAM_SHA_1_MECHANISM, userName, source, password);
    }

    public static MongoCredential createMongoCRCredential(String userName, String database, char[] password) {
        return new MongoCredential(MONGODB_CR_MECHANISM, userName, database, password);
    }

    public static MongoCredential createGSSAPICredential(String userName) {
        return new MongoCredential(GSSAPI_MECHANISM, userName, "$external", null);
    }

    public static MongoCredential createMongoX509Credential(String userName) {
        return new MongoCredential(MONGODB_X509_MECHANISM, userName, "$external", null);
    }

    public static MongoCredential createPlainCredential(String userName, String source, char[] password) {
        return new MongoCredential(PLAIN_MECHANISM, userName, source, password);
    }

    public <T> MongoCredential withMechanismProperty(String key, T value) {
        return new MongoCredential(this, key, value);
    }

    MongoCredential(String mechanism, String userName, String source, char[] password) {
        if (userName == null) {
            throw new IllegalArgumentException("username can not be null");
        }
        if (mechanism == null && password == null) {
            throw new IllegalArgumentException("Password can not be null when the authentication mechanism is unspecified");
        }
        if ((MONGODB_CR_MECHANISM.equals(mechanism) || SCRAM_SHA_1_MECHANISM.equals(mechanism)) && password == null) {
            throw new IllegalArgumentException("Password can not be null for the " + mechanism + " authentication mechanism");
        }
        if (GSSAPI_MECHANISM.equals(mechanism) && password != null) {
            throw new IllegalArgumentException("Password must be null for the GSSAPI authentication mechanism");
        }
        this.mechanism = mechanism;
        this.userName = userName;
        this.source = source;
        this.password = password != null ? (char[])password.clone() : null;
        this.mechanismProperties = Collections.emptyMap();
    }

    <T> MongoCredential(MongoCredential from, String mechanismPropertyKey, T mechanismPropertyValue) {
        this.mechanism = from.mechanism;
        this.userName = from.userName;
        this.source = from.source;
        this.password = from.password;
        this.mechanismProperties = new HashMap<String, Object>(from.mechanismProperties);
        this.mechanismProperties.put(mechanismPropertyKey.toLowerCase(), mechanismPropertyValue);
    }

    public String getMechanism() {
        return this.mechanism;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getSource() {
        return this.source;
    }

    public char[] getPassword() {
        if (this.password == null) {
            return null;
        }
        return (char[])this.password.clone();
    }

    public <T> T getMechanismProperty(String key, T defaultValue) {
        Object value = this.mechanismProperties.get(key.toLowerCase());
        return (T)(value == null ? defaultValue : value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MongoCredential that = (MongoCredential)o;
        if (this.mechanism != null ? !this.mechanism.equals(that.mechanism) : that.mechanism != null) {
            return false;
        }
        if (!this.mechanismProperties.equals(that.mechanismProperties)) {
            return false;
        }
        if (!Arrays.equals(this.password, that.password)) {
            return false;
        }
        if (!this.source.equals(that.source)) {
            return false;
        }
        return this.userName.equals(that.userName);
    }

    public int hashCode() {
        int result = this.mechanism != null ? this.mechanism.hashCode() : 0;
        result = 31 * result + this.userName.hashCode();
        result = 31 * result + this.source.hashCode();
        result = 31 * result + (this.password != null ? Arrays.hashCode(this.password) : 0);
        result = 31 * result + this.mechanismProperties.hashCode();
        return result;
    }

    public String toString() {
        return "MongoCredential{mechanism='" + this.mechanism + '\'' + ", userName='" + this.userName + '\'' + ", source='" + this.source + '\'' + ", password=<hidden>" + ", mechanismProperties=" + this.mechanismProperties + '}';
    }
}

