# The PEP 484 type hints stub file for the QtWebEngineWidgets module.
#
# Generated by SIP 6.10.0
#
# Copyright (c) 2025 Riverbank Computing Limited <info@riverbankcomputing.com>
# 
# This file is part of PyQt6-WebEngine.
# 
# This file may be used under the terms of the GNU General Public License
# version 3.0 as published by the Free Software Foundation and appearing in
# the file LICENSE included in the packaging of this file.  Please review the
# following information to ensure the GNU General Public License version 3.0
# requirements will be met: http://www.gnu.org/copyleft/gpl.html.
# 
# If you do not wish to use this file under the terms of the GPL version 3.0
# then you may purchase a commercial license.  For more information contact
# info@riverbankcomputing.com.
# 
# This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
# WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.


import collections, re, typing

try:
    from warnings import deprecated
except ImportError:
    pass

import PyQt6.sip

from PyQt6 import QtCore
from PyQt6 import QtNetwork
from PyQt6 import QtGui
from PyQt6 import QtWidgets
from PyQt6 import QtPrintSupport
from PyQt6 import QtWebChannel
from PyQt6 import QtWebEngineCore

# Support for QDate, QDateTime and QTime.
import datetime

# Convenient type aliases.
PYQT_SIGNAL = typing.Union[QtCore.pyqtSignal, QtCore.pyqtBoundSignal]
PYQT_SLOT = typing.Union[collections.abc.Callable[..., Any], QtCore.pyqtBoundSignal]


class QWebEngineView(QtWidgets.QWidget):

    @typing.overload
    def __init__(self, page: typing.Optional[QtWebEngineCore.QWebEnginePage], parent: typing.Optional[QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, profile: typing.Optional[QtWebEngineCore.QWebEngineProfile], parent: typing.Optional[QtWidgets.QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[QtWidgets.QWidget] = ...) -> None: ...

    printRequestedByFrame: typing.ClassVar[QtCore.pyqtSignal]
    printFinished: typing.ClassVar[QtCore.pyqtSignal]
    printRequested: typing.ClassVar[QtCore.pyqtSignal]
    pdfPrintingFinished: typing.ClassVar[QtCore.pyqtSignal]
    def print(self, printer: typing.Optional[QtPrintSupport.QPrinter]) -> None: ...
    @typing.overload
    def printToPdf(self, filePath: typing.Optional[str], pageLayout: QtGui.QPageLayout = ..., ranges: QtGui.QPageRanges = ...) -> None: ...
    @typing.overload
    def printToPdf(self, resultCallback: collections.abc.Callable[[typing.Union[QtCore.QByteArray, bytes, bytearray, memoryview]], None], pageLayout: QtGui.QPageLayout = ..., ranges: QtGui.QPageRanges = ...) -> None: ...
    def lastContextMenuRequest(self) -> typing.Optional[QtWebEngineCore.QWebEngineContextMenuRequest]: ...
    def createStandardContextMenu(self) -> typing.Optional[QtWidgets.QMenu]: ...
    def findText(self, subString: typing.Optional[str], options: QtWebEngineCore.QWebEnginePage.FindFlag = ..., resultCallback: collections.abc.Callable[[bool], None] = ...) -> None: ...
    @staticmethod
    def forPage(page: typing.Optional[QtWebEngineCore.QWebEnginePage]) -> typing.Optional['QWebEngineView']: ...
    def closeEvent(self, a0: typing.Optional[QtGui.QCloseEvent]) -> None: ...
    def dropEvent(self, e: typing.Optional[QtGui.QDropEvent]) -> None: ...
    def dragMoveEvent(self, e: typing.Optional[QtGui.QDragMoveEvent]) -> None: ...
    def dragLeaveEvent(self, e: typing.Optional[QtGui.QDragLeaveEvent]) -> None: ...
    def dragEnterEvent(self, e: typing.Optional[QtGui.QDragEnterEvent]) -> None: ...
    def hideEvent(self, a0: typing.Optional[QtGui.QHideEvent]) -> None: ...
    def showEvent(self, a0: typing.Optional[QtGui.QShowEvent]) -> None: ...
    def event(self, a0: typing.Optional[QtCore.QEvent]) -> bool: ...
    def contextMenuEvent(self, a0: typing.Optional[QtGui.QContextMenuEvent]) -> None: ...
    def createWindow(self, type: QtWebEngineCore.QWebEnginePage.WebWindowType) -> typing.Optional['QWebEngineView']: ...
    renderProcessTerminated: typing.ClassVar[QtCore.pyqtSignal]
    iconChanged: typing.ClassVar[QtCore.pyqtSignal]
    iconUrlChanged: typing.ClassVar[QtCore.pyqtSignal]
    urlChanged: typing.ClassVar[QtCore.pyqtSignal]
    selectionChanged: typing.ClassVar[QtCore.pyqtSignal]
    titleChanged: typing.ClassVar[QtCore.pyqtSignal]
    loadFinished: typing.ClassVar[QtCore.pyqtSignal]
    loadProgress: typing.ClassVar[QtCore.pyqtSignal]
    loadStarted: typing.ClassVar[QtCore.pyqtSignal]
    def reload(self) -> None: ...
    def forward(self) -> None: ...
    def back(self) -> None: ...
    def stop(self) -> None: ...
    def icon(self) -> QtGui.QIcon: ...
    def settings(self) -> typing.Optional[QtWebEngineCore.QWebEngineSettings]: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def setZoomFactor(self, factor: float) -> None: ...
    def zoomFactor(self) -> float: ...
    def triggerPageAction(self, action: QtWebEngineCore.QWebEnginePage.WebAction, checked: bool = ...) -> None: ...
    def pageAction(self, action: QtWebEngineCore.QWebEnginePage.WebAction) -> typing.Optional[QtGui.QAction]: ...
    def selectedText(self) -> str: ...
    def hasSelection(self) -> bool: ...
    def iconUrl(self) -> QtCore.QUrl: ...
    def url(self) -> QtCore.QUrl: ...
    def setUrl(self, url: QtCore.QUrl) -> None: ...
    def title(self) -> str: ...
    def history(self) -> typing.Optional[QtWebEngineCore.QWebEngineHistory]: ...
    def setContent(self, data: typing.Union[QtCore.QByteArray, bytes, bytearray, memoryview], mimeType: typing.Optional[str] = ..., baseUrl: QtCore.QUrl = ...) -> None: ...
    def setHtml(self, html: typing.Optional[str], baseUrl: QtCore.QUrl = ...) -> None: ...
    @typing.overload
    def load(self, url: QtCore.QUrl) -> None: ...
    @typing.overload
    def load(self, request: QtWebEngineCore.QWebEngineHttpRequest) -> None: ...
    def setPage(self, page: typing.Optional[QtWebEngineCore.QWebEnginePage]) -> None: ...
    def page(self) -> typing.Optional[QtWebEngineCore.QWebEnginePage]: ...
