/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.processors.validation;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.github.fge.jackson.JacksonUtils;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.ref.JsonRef;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.tree.SchemaTree;
import com.github.fge.jsonschema.processors.data.FullData;
import com.google.common.collect.Queues;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Deque;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
final class ValidationStack {
    private final Deque<Element> validationQueue = Queues.newArrayDeque();
    private final String errmsg;
    private JsonPointer pointer = null;
    private Deque<SchemaURI> schemaURIs = null;

    ValidationStack(String errmsg) {
        this.errmsg = errmsg;
    }

    void push(FullData data) throws ProcessingException {
        JsonPointer ptr = data.getInstance().getPointer();
        SchemaURI schemaURI = new SchemaURI(data.getSchema());
        if (ptr.equals(this.pointer)) {
            if (this.schemaURIs.contains(schemaURI)) {
                throw new ProcessingException(this.validationLoopMessage(data));
            }
            this.schemaURIs.addLast(schemaURI);
            return;
        }
        this.validationQueue.addLast(new Element(this.pointer, this.schemaURIs));
        this.pointer = ptr;
        this.schemaURIs = Queues.newArrayDeque();
        this.schemaURIs.addLast(schemaURI);
    }

    void pop() {
        this.schemaURIs.removeLast();
        if (!this.schemaURIs.isEmpty()) {
            return;
        }
        Element element = this.validationQueue.removeLast();
        this.pointer = element.pointer;
        this.schemaURIs = element.schemaURIs;
    }

    private ProcessingMessage validationLoopMessage(FullData input) {
        ArrayNode node = JacksonUtils.nodeFactory().arrayNode();
        for (SchemaURI uri : this.schemaURIs) {
            node.add(uri.toString());
        }
        return input.newMessage().put("domain", "validation").setMessage(this.errmsg).putArgument("alreadyVisited", new SchemaURI(input.getSchema())).putArgument("instancePointer", this.pointer.toString()).put("validationPath", node);
    }

    private static final class SchemaURI {
        private final JsonRef locator;
        private final JsonPointer pointer;

        private SchemaURI(SchemaTree tree) {
            this.locator = tree.getContext();
            this.pointer = tree.getPointer();
        }

        public int hashCode() {
            return this.locator.hashCode() ^ this.pointer.hashCode();
        }

        public boolean equals(@Nullable Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SchemaURI other = (SchemaURI)obj;
            return this.locator.equals(other.locator) && this.pointer.equals(other.pointer);
        }

        public String toString() {
            URI tmp;
            try {
                tmp = new URI(null, null, this.pointer.toString());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("How did I get there??", e);
            }
            return this.locator.toURI().resolve(tmp).toString();
        }
    }

    private static final class Element {
        private final JsonPointer pointer;
        private final Deque<SchemaURI> schemaURIs;

        private Element(@Nullable JsonPointer pointer, @Nullable Deque<SchemaURI> schemaURIs) {
            this.pointer = pointer;
            this.schemaURIs = schemaURIs;
        }
    }
}

