/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.alerting.model;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.validator.routines.UrlValidator;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.commons.alerting.model.ClusterMetricsInputKt;
import org.opensearch.commons.alerting.model.Input;
import org.opensearch.commons.utils.ValidationHelpersKt;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u0000 ?2\u00020\u0001:\u0002>?B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B/\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010 \u001a\u00020\u0006H\u00c6\u0003J\t\u0010!\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0006H\u00c6\u0003J\u000f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u00c6\u0003J\b\u0010$\u001a\u00020\u0015H\u0002J7\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u00062\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u00c6\u0001J\u0013\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)H\u00d6\u0003J\u0010\u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020\u0006H\u0002J\t\u0010,\u001a\u00020-H\u00d6\u0001J\b\u0010.\u001a\u00020\u0006H\u0016J\b\u0010/\u001a\u000200H\u0002J\u0006\u00101\u001a\u00020\u0006J\b\u00102\u001a\u00020\u0015H\u0002J\t\u00103\u001a\u00020\u0006H\u00d6\u0001J\u0018\u00104\u001a\u0002052\u0006\u00106\u001a\u0002052\u0006\u00107\u001a\u000208H\u0016J\b\u00109\u001a\u00020'H\u0002J\b\u0010:\u001a\u00020'H\u0002J\u0010\u0010;\u001a\u0002002\u0006\u0010<\u001a\u00020=H\u0016R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR \u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u0007\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0019\"\u0004\b\u001d\u0010\u001bR\u001a\u0010\b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0019\"\u0004\b\u001f\u0010\u001b\u00a8\u0006@"}, d2={"Lorg/opensearch/commons/alerting/model/ClusterMetricsInput;", "Lorg/opensearch/commons/alerting/model/Input;", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "path", "", "pathParams", "url", "clusters", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "clusterMetricType", "Lorg/opensearch/commons/alerting/model/ClusterMetricsInput$ClusterMetricType;", "getClusterMetricType", "()Lorg/opensearch/commons/alerting/model/ClusterMetricsInput$ClusterMetricType;", "getClusters", "()Ljava/util/List;", "setClusters", "(Ljava/util/List;)V", "constructedUri", "Ljava/net/URI;", "getConstructedUri", "()Ljava/net/URI;", "getPath", "()Ljava/lang/String;", "setPath", "(Ljava/lang/String;)V", "getPathParams", "setPathParams", "getUrl", "setUrl", "component1", "component2", "component3", "component4", "constructUrlFromInputs", "copy", "equals", "", "other", "", "findApiType", "uriPath", "hashCode", "", "name", "parseEmptyFields", "", "parsePathParams", "toConstructedUri", "toString", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "validateFields", "validateFieldsNotEmpty", "writeTo", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "ClusterMetricType", "Companion", "common-utils"})
@SourceDebugExtension(value={"SMAP\nClusterMetricsInput.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClusterMetricsInput.kt\norg/opensearch/commons/alerting/model/ClusterMetricsInput\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,381:1\n1726#2,3:382\n1855#2,2:392\n37#3,2:385\n13579#4,2:387\n3792#4:389\n4307#4,2:390\n*S KotlinDebug\n*F\n+ 1 ClusterMetricsInput.kt\norg/opensearch/commons/alerting/model/ClusterMetricsInput\n*L\n63#1:382,3\n219#1:392,2\n100#1:385,2\n190#1:387,2\n218#1:389\n218#1:390,2\n*E\n"})
public final class ClusterMetricsInput
implements Input {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String path;
    @NotNull
    private String pathParams;
    @NotNull
    private String url;
    @NotNull
    private List<String> clusters;
    @NotNull
    private final ClusterMetricType clusterMetricType;
    @NotNull
    private final URI constructedUri;
    @NotNull
    public static final String SUPPORTED_SCHEME = "http";
    @NotNull
    public static final String SUPPORTED_HOST = "localhost";
    public static final int SUPPORTED_PORT = 9200;
    @NotNull
    public static final String API_TYPE_FIELD = "api_type";
    @NotNull
    public static final String PATH_FIELD = "path";
    @NotNull
    public static final String PATH_PARAMS_FIELD = "path_params";
    @NotNull
    public static final String URL_FIELD = "url";
    @NotNull
    public static final String URI_FIELD = "uri";
    @NotNull
    public static final String CLUSTERS_FIELD = "clusters";
    @NotNull
    private static final NamedXContentRegistry.Entry XCONTENT_REGISTRY = new NamedXContentRegistry.Entry(Input.class, new ParseField("uri", new String[0]), ClusterMetricsInput::XCONTENT_REGISTRY$lambda$10);

    public ClusterMetricsInput(@NotNull String path, @NotNull String pathParams, @NotNull String url, @NotNull List<String> clusters) {
        Intrinsics.checkNotNullParameter((Object)path, (String)PATH_FIELD);
        Intrinsics.checkNotNullParameter((Object)pathParams, (String)"pathParams");
        Intrinsics.checkNotNullParameter((Object)url, (String)URL_FIELD);
        Intrinsics.checkNotNullParameter(clusters, (String)CLUSTERS_FIELD);
        this.path = path;
        this.pathParams = pathParams;
        this.url = url;
        this.clusters = clusters;
        if (!this.validateFields()) {
            boolean $i$a$-require-ClusterMetricsInput$62 = false;
            String $i$a$-require-ClusterMetricsInput$62 = "The uri.api_type field, uri.path field, or uri.uri field must be defined.";
            throw new IllegalArgumentException($i$a$-require-ClusterMetricsInput$62.toString());
        }
        String[] $i$a$-require-ClusterMetricsInput$62 = new String[]{SUPPORTED_SCHEME, "https"};
        UrlValidator urlValidator = new UrlValidator($i$a$-require-ClusterMetricsInput$62, 8L);
        this.constructedUri = this.toConstructedUri();
        if (!urlValidator.isValid(this.constructedUri.toString())) {
            boolean $i$a$-require-ClusterMetricsInput$82 = false;
            String $i$a$-require-ClusterMetricsInput$82 = "Invalid URI constructed from the path and path_params inputs, or the url input.";
            throw new IllegalArgumentException($i$a$-require-ClusterMetricsInput$82.toString());
        }
        if (((CharSequence)this.url).length() > 0 && this.validateFieldsNotEmpty() && !Intrinsics.areEqual((Object)this.constructedUri, (Object)this.constructUrlFromInputs())) {
            boolean $i$a$-require-ClusterMetricsInput$92 = false;
            String $i$a$-require-ClusterMetricsInput$92 = "The provided URL and URI fields form different URLs.";
            throw new IllegalArgumentException($i$a$-require-ClusterMetricsInput$92.toString());
        }
        String string = this.constructedUri.getHost();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"constructedUri.host");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        if (!Intrinsics.areEqual((Object)string2, (Object)SUPPORTED_HOST)) {
            boolean $i$a$-require-ClusterMetricsInput$102 = false;
            String $i$a$-require-ClusterMetricsInput$102 = "Only host 'localhost' is supported.";
            throw new IllegalArgumentException($i$a$-require-ClusterMetricsInput$102.toString());
        }
        if (!(this.constructedUri.getPort() == 9200)) {
            boolean $i$a$-require-ClusterMetricsInput$112 = false;
            String $i$a$-require-ClusterMetricsInput$112 = "Only port '9200' is supported.";
            throw new IllegalArgumentException($i$a$-require-ClusterMetricsInput$112.toString());
        }
        if (!((Collection)this.clusters).isEmpty()) {
            boolean bl;
            block10: {
                Iterable $this$all$iv = this.clusters;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (ValidationHelpersKt.getCLUSTER_NAME_REGEX().matches((CharSequence)it)) continue;
                        bl = false;
                        break block10;
                    }
                    bl = true;
                }
            }
            if (!bl) {
                boolean bl3 = false;
                String string3 = "Cluster names are not valid.";
                throw new IllegalArgumentException(string3.toString());
            }
        }
        String string4 = this.constructedUri.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"constructedUri.path");
        this.clusterMetricType = this.findApiType(string4);
        this.parseEmptyFields();
    }

    public /* synthetic */ ClusterMetricsInput(String string, String string2, String string3, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(string, string2, string3, list);
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    public final void setPath(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.path = string;
    }

    @NotNull
    public final String getPathParams() {
        return this.pathParams;
    }

    public final void setPathParams(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.pathParams = string;
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    public final void setUrl(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.url = string;
    }

    @NotNull
    public final List<String> getClusters() {
        return this.clusters;
    }

    public final void setClusters(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.clusters = list;
    }

    @NotNull
    public final ClusterMetricType getClusterMetricType() {
        return this.clusterMetricType;
    }

    @NotNull
    public final URI getConstructedUri() {
        return this.constructedUri;
    }

    public ClusterMetricsInput(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        String string = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sin.readString()");
        String string2 = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sin.readString()");
        String string3 = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"sin.readString()");
        this(string, string2, string3, null, 8, null);
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        XContentBuilder xContentBuilder = builder.startObject().startObject(URI_FIELD).field(API_TYPE_FIELD, (Object)this.clusterMetricType).field(PATH_FIELD, this.path).field(PATH_PARAMS_FIELD, this.pathParams).field(URL_FIELD, this.url).field(CLUSTERS_FIELD, (Iterable)this.clusters).endObject().endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"builder.startObject()\n  \u2026\n            .endObject()");
        return xContentBuilder;
    }

    @Override
    @NotNull
    public String name() {
        return URI_FIELD;
    }

    public void writeTo(@NotNull StreamOutput out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeString(this.clusterMetricType.toString());
        out.writeString(this.path);
        out.writeString(this.pathParams);
        out.writeString(this.url);
        Collection $this$toTypedArray$iv = this.clusters;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        out.writeStringArray(thisCollection$iv.toArray(new String[0]));
    }

    private final URI toConstructedUri() {
        URI uRI;
        if (((CharSequence)this.url).length() == 0) {
            uRI = this.constructUrlFromInputs();
        } else {
            URI uRI2;
            try {
                uRI2 = new URIBuilder(this.url).build();
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Invalid URL syntax.");
            }
            URI uRI3 = uRI2;
            uRI = uRI3;
            Intrinsics.checkNotNullExpressionValue((Object)uRI3, (String)"{\n            try {\n    \u2026)\n            }\n        }");
        }
        return uRI;
    }

    @NotNull
    public final String parsePathParams() {
        Object prependPath;
        String path = this.constructedUri.getPath();
        ClusterMetricType apiType = this.clusterMetricType;
        String pathParams = null;
        if (((CharSequence)this.pathParams).length() > 0) {
            pathParams = this.pathParams;
        } else {
            prependPath = apiType.getSupportsPathParams() ? apiType.getPrependPath() : apiType.getDefaultPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)PATH_FIELD);
            pathParams = StringsKt.removePrefix((String)path, (CharSequence)((CharSequence)prependPath));
            pathParams = StringsKt.removeSuffix((String)pathParams, (CharSequence)apiType.getAppendPath());
        }
        if (((CharSequence)pathParams).length() > 0) {
            prependPath = new char[1];
            prependPath[0] = 47;
            pathParams = StringsKt.trim((String)pathParams, (char[])prependPath);
            Character[] $this$forEach$iv = ClusterMetricsInputKt.getILLEGAL_PATH_PARAMETER_CHARACTERS();
            boolean $i$f$forEach = false;
            for (Character element$iv : $this$forEach$iv) {
                char character = element$iv.charValue();
                boolean bl = false;
                if (!StringsKt.contains$default((CharSequence)pathParams, (char)character, (boolean)false, (int)2, null)) continue;
                throw new IllegalArgumentException("The provided path parameters contain invalid characters or spaces. Please omit: " + ArraysKt.joinToString$default((Object[])ClusterMetricsInputKt.getILLEGAL_PATH_PARAMETER_CHARACTERS(), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
            }
        }
        if (apiType.getRequiresPathParams() && ((CharSequence)pathParams).length() == 0) {
            throw new IllegalArgumentException("The API requires path parameters.");
        }
        if (!apiType.getSupportsPathParams() && ((CharSequence)pathParams).length() > 0) {
            throw new IllegalArgumentException("The API does not use path parameters.");
        }
        return pathParams;
    }

    /*
     * WARNING - void declaration
     */
    private final ClusterMetricType findApiType(String uriPath) {
        void $this$filterTo$iv$iv;
        ClusterMetricType apiType = null;
        apiType = ClusterMetricType.BLANK;
        ClusterMetricType[] $this$filter$iv = ClusterMetricType.values();
        boolean $i$f$filter = false;
        ClusterMetricType[] clusterMetricTypeArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void option = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            if (!(option != ClusterMetricType.BLANK)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ClusterMetricType option = (ClusterMetricType)((Object)element$iv);
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)uriPath, (String)option.getPrependPath(), (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)uriPath, (String)option.getDefaultPath(), (boolean)false, (int)2, null)) continue;
            apiType = option;
        }
        if (apiType.isBlank()) {
            throw new IllegalArgumentException("The API could not be determined from the provided URI.");
        }
        return apiType;
    }

    private final URI constructUrlFromInputs() {
        URI uRI;
        try {
            String formattedPath = StringsKt.startsWith$default((String)this.path, (String)"/", (boolean)false, (int)2, null) || StringsKt.isBlank((CharSequence)this.path) ? this.path : "/" + this.path;
            String formattedPathParams = StringsKt.startsWith$default((String)this.pathParams, (String)"/", (boolean)false, (int)2, null) || StringsKt.isBlank((CharSequence)this.pathParams) ? this.pathParams : "/" + this.pathParams;
            URIBuilder uriBuilder = new URIBuilder("http://localhost:9200" + formattedPath + formattedPathParams);
            URI uRI2 = uriBuilder.build();
            Intrinsics.checkNotNullExpressionValue((Object)uRI2, (String)"{\n            val format\u2026Builder.build()\n        }");
            uRI = uRI2;
        }
        catch (URISyntaxException ex) {
            URI uRI3;
            URIBuilder uriBuilder = new URIBuilder().setScheme(SUPPORTED_SCHEME).setHost(SUPPORTED_HOST).setPort(9200).setPath(this.path + this.pathParams);
            try {
                uRI3 = uriBuilder.build();
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Invalid URL syntax.");
            }
            URI uRI4 = uRI3;
            Intrinsics.checkNotNullExpressionValue((Object)uRI4, (String)"{\n            val uriBui\u2026)\n            }\n        }");
            uRI = uRI4;
        }
        return uRI;
    }

    private final void parseEmptyFields() {
        if (((CharSequence)this.pathParams).length() == 0) {
            this.pathParams = this.parsePathParams();
        }
        if (((CharSequence)this.path).length() == 0) {
            this.path = ((CharSequence)this.pathParams).length() == 0 ? this.clusterMetricType.getDefaultPath() : this.clusterMetricType.getPrependPath();
        }
        if (((CharSequence)this.url).length() == 0) {
            String string = this.constructedUri.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"constructedUri.toString()");
            this.url = string;
        }
    }

    private final boolean validateFields() {
        return ((CharSequence)this.url).length() > 0 || this.validateFieldsNotEmpty();
    }

    private final boolean validateFieldsNotEmpty() {
        return ((CharSequence)this.path).length() > 0;
    }

    @Override
    @NotNull
    public Map<String, Object> asTemplateArg() {
        return Input.DefaultImpls.asTemplateArg(this);
    }

    @NotNull
    public final String component1() {
        return this.path;
    }

    @NotNull
    public final String component2() {
        return this.pathParams;
    }

    @NotNull
    public final String component3() {
        return this.url;
    }

    @NotNull
    public final List<String> component4() {
        return this.clusters;
    }

    @NotNull
    public final ClusterMetricsInput copy(@NotNull String path, @NotNull String pathParams, @NotNull String url, @NotNull List<String> clusters) {
        Intrinsics.checkNotNullParameter((Object)path, (String)PATH_FIELD);
        Intrinsics.checkNotNullParameter((Object)pathParams, (String)"pathParams");
        Intrinsics.checkNotNullParameter((Object)url, (String)URL_FIELD);
        Intrinsics.checkNotNullParameter(clusters, (String)CLUSTERS_FIELD);
        return new ClusterMetricsInput(path, pathParams, url, clusters);
    }

    public static /* synthetic */ ClusterMetricsInput copy$default(ClusterMetricsInput clusterMetricsInput, String string, String string2, String string3, List list, int n, Object object) {
        if ((n & 1) != 0) {
            string = clusterMetricsInput.path;
        }
        if ((n & 2) != 0) {
            string2 = clusterMetricsInput.pathParams;
        }
        if ((n & 4) != 0) {
            string3 = clusterMetricsInput.url;
        }
        if ((n & 8) != 0) {
            list = clusterMetricsInput.clusters;
        }
        return clusterMetricsInput.copy(string, string2, string3, list);
    }

    @NotNull
    public String toString() {
        return "ClusterMetricsInput(path=" + this.path + ", pathParams=" + this.pathParams + ", url=" + this.url + ", clusters=" + this.clusters + ")";
    }

    public int hashCode() {
        int result = this.path.hashCode();
        result = result * 31 + this.pathParams.hashCode();
        result = result * 31 + this.url.hashCode();
        result = result * 31 + ((Object)this.clusters).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ClusterMetricsInput)) {
            return false;
        }
        ClusterMetricsInput clusterMetricsInput = (ClusterMetricsInput)other;
        if (!Intrinsics.areEqual((Object)this.path, (Object)clusterMetricsInput.path)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.pathParams, (Object)clusterMetricsInput.pathParams)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.url, (Object)clusterMetricsInput.url)) {
            return false;
        }
        return Intrinsics.areEqual(this.clusters, clusterMetricsInput.clusters);
    }

    private static final ClusterMetricsInput XCONTENT_REGISTRY$lambda$10(XContentParser it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return Companion.parseInner(it);
    }

    @JvmStatic
    @NotNull
    public static final ClusterMetricsInput parseInner(@NotNull XContentParser xcp) throws IOException {
        return Companion.parseInner(xcp);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0016\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B/\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0011\u001a\u00020\u0007R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fj\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001c\u00a8\u0006\u001d"}, d2={"Lorg/opensearch/commons/alerting/model/ClusterMetricsInput$ClusterMetricType;", "", "defaultPath", "", "prependPath", "appendPath", "supportsPathParams", "", "requiresPathParams", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;ZZ)V", "getAppendPath", "()Ljava/lang/String;", "getDefaultPath", "getPrependPath", "getRequiresPathParams", "()Z", "getSupportsPathParams", "isBlank", "BLANK", "CAT_INDICES", "CAT_PENDING_TASKS", "CAT_RECOVERY", "CAT_SHARDS", "CAT_SNAPSHOTS", "CAT_TASKS", "CLUSTER_HEALTH", "CLUSTER_SETTINGS", "CLUSTER_STATS", "NODES_STATS", "common-utils"})
    public static final class ClusterMetricType
    extends Enum<ClusterMetricType> {
        @NotNull
        private final String defaultPath;
        @NotNull
        private final String prependPath;
        @NotNull
        private final String appendPath;
        private final boolean supportsPathParams;
        private final boolean requiresPathParams;
        public static final /* enum */ ClusterMetricType BLANK = new ClusterMetricType("", "", "", false, false);
        public static final /* enum */ ClusterMetricType CAT_INDICES = new ClusterMetricType("/_cat/indices", "/_cat/indices", "", true, false);
        public static final /* enum */ ClusterMetricType CAT_PENDING_TASKS = new ClusterMetricType("/_cat/pending_tasks", "/_cat/pending_tasks", "", false, false);
        public static final /* enum */ ClusterMetricType CAT_RECOVERY = new ClusterMetricType("/_cat/recovery", "/_cat/recovery", "", true, false);
        public static final /* enum */ ClusterMetricType CAT_SHARDS = new ClusterMetricType("/_cat/shards", "/_cat/shards", "", true, false);
        public static final /* enum */ ClusterMetricType CAT_SNAPSHOTS = new ClusterMetricType("/_cat/snapshots", "/_cat/snapshots", "", true, true);
        public static final /* enum */ ClusterMetricType CAT_TASKS = new ClusterMetricType("/_cat/tasks", "/_cat/tasks", "", false, false);
        public static final /* enum */ ClusterMetricType CLUSTER_HEALTH = new ClusterMetricType("/_cluster/health", "/_cluster/health", "", true, false);
        public static final /* enum */ ClusterMetricType CLUSTER_SETTINGS = new ClusterMetricType("/_cluster/settings", "/_cluster/settings", "", false, false);
        public static final /* enum */ ClusterMetricType CLUSTER_STATS = new ClusterMetricType("/_cluster/stats", "/_cluster/stats", "", true, false);
        public static final /* enum */ ClusterMetricType NODES_STATS = new ClusterMetricType("/_nodes/stats", "/_nodes", "", false, false);
        private static final /* synthetic */ ClusterMetricType[] $VALUES;

        private ClusterMetricType(String defaultPath, String prependPath, String appendPath, boolean supportsPathParams, boolean requiresPathParams) {
            this.defaultPath = defaultPath;
            this.prependPath = prependPath;
            this.appendPath = appendPath;
            this.supportsPathParams = supportsPathParams;
            this.requiresPathParams = requiresPathParams;
        }

        @NotNull
        public final String getDefaultPath() {
            return this.defaultPath;
        }

        @NotNull
        public final String getPrependPath() {
            return this.prependPath;
        }

        @NotNull
        public final String getAppendPath() {
            return this.appendPath;
        }

        public final boolean getSupportsPathParams() {
            return this.supportsPathParams;
        }

        public final boolean getRequiresPathParams() {
            return this.requiresPathParams;
        }

        public final boolean isBlank() {
            return this == BLANK;
        }

        public static ClusterMetricType[] values() {
            return (ClusterMetricType[])$VALUES.clone();
        }

        public static ClusterMetricType valueOf(String value) {
            return Enum.valueOf(ClusterMetricType.class, value);
        }

        static {
            $VALUES = clusterMetricTypeArray = new ClusterMetricType[]{ClusterMetricType.BLANK, ClusterMetricType.CAT_INDICES, ClusterMetricType.CAT_PENDING_TASKS, ClusterMetricType.CAT_RECOVERY, ClusterMetricType.CAT_SHARDS, ClusterMetricType.CAT_SNAPSHOTS, ClusterMetricType.CAT_TASKS, ClusterMetricType.CLUSTER_HEALTH, ClusterMetricType.CLUSTER_SETTINGS, ClusterMetricType.CLUSTER_STATS, ClusterMetricType.NODES_STATS};
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lorg/opensearch/commons/alerting/model/ClusterMetricsInput$Companion;", "", "()V", "API_TYPE_FIELD", "", "CLUSTERS_FIELD", "PATH_FIELD", "PATH_PARAMS_FIELD", "SUPPORTED_HOST", "SUPPORTED_PORT", "", "SUPPORTED_SCHEME", "URI_FIELD", "URL_FIELD", "XCONTENT_REGISTRY", "Lorg/opensearch/core/xcontent/NamedXContentRegistry$Entry;", "getXCONTENT_REGISTRY", "()Lorg/opensearch/core/xcontent/NamedXContentRegistry$Entry;", "parseInner", "Lorg/opensearch/commons/alerting/model/ClusterMetricsInput;", "xcp", "Lorg/opensearch/core/xcontent/XContentParser;", "common-utils"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NamedXContentRegistry.Entry getXCONTENT_REGISTRY() {
            return XCONTENT_REGISTRY;
        }

        @JvmStatic
        @NotNull
        public final ClusterMetricsInput parseInner(@NotNull XContentParser xcp) throws IOException {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            String path = "";
            String pathParams = "";
            String url = "";
            List clusters = new ArrayList();
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            block12: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName = xcp.currentName();
                xcp.nextToken();
                String string = fieldName;
                if (string == null) continue;
                int n = -1;
                switch (string.hashCode()) {
                    case 3433509: {
                        if (string.equals(ClusterMetricsInput.PATH_FIELD)) {
                            n = 1;
                        }
                        break;
                    }
                    case 2088341216: {
                        if (string.equals(ClusterMetricsInput.PATH_PARAMS_FIELD)) {
                            n = 2;
                        }
                        break;
                    }
                    case 116079: {
                        if (string.equals(ClusterMetricsInput.URL_FIELD)) {
                            n = 3;
                        }
                        break;
                    }
                    case 1265053113: {
                        if (string.equals(ClusterMetricsInput.CLUSTERS_FIELD)) {
                            n = 4;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 1: {
                        Intrinsics.checkNotNullExpressionValue((Object)xcp.text(), (String)"xcp.text()");
                        continue block12;
                    }
                    case 2: {
                        Intrinsics.checkNotNullExpressionValue((Object)xcp.text(), (String)"xcp.text()");
                        continue block12;
                    }
                    case 3: {
                        Intrinsics.checkNotNullExpressionValue((Object)xcp.text(), (String)"xcp.text()");
                        continue block12;
                    }
                    case 4: {
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                        while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                            String string2 = xcp.text();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"xcp.text()");
                            clusters.add(string2);
                        }
                        continue block12;
                    }
                }
            }
            return new ClusterMetricsInput(path, pathParams, url, clusters);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

