/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.repositories.hdfs;

import java.io.IOException;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Path;
import org.apache.lucene.store.AlreadyClosedException;
import org.opensearch.OpenSearchException;
import org.opensearch.common.blobstore.BlobContainer;
import org.opensearch.common.blobstore.BlobPath;
import org.opensearch.common.blobstore.BlobStore;
import org.opensearch.repositories.hdfs.HdfsBlobContainer;
import org.opensearch.repositories.hdfs.HdfsSecurityContext;

final class HdfsBlobStore
implements BlobStore {
    private final Path root;
    private final FileContext fileContext;
    private final HdfsSecurityContext securityContext;
    private final int bufferSize;
    private final boolean readOnly;
    private volatile boolean closed;

    HdfsBlobStore(FileContext fileContext, String path, int bufferSize, boolean readOnly) throws IOException {
        this(fileContext, path, bufferSize, readOnly, false);
    }

    HdfsBlobStore(FileContext fileContext, String path, int bufferSize, boolean readOnly, boolean haEnabled) throws IOException {
        this.fileContext = fileContext;
        boolean restrictPermissions = !haEnabled;
        this.securityContext = new HdfsSecurityContext(fileContext.getUgi(), restrictPermissions);
        this.bufferSize = bufferSize;
        this.root = this.execute(fileContext1 -> fileContext1.makeQualified(new Path(path)));
        this.readOnly = readOnly;
        if (!readOnly) {
            try {
                this.mkdirs(this.root);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                // empty catch block
            }
        }
    }

    private void mkdirs(Path path) throws IOException {
        this.execute(fileContext -> {
            fileContext.mkdir(path, null, true);
            return null;
        });
    }

    public String toString() {
        return this.root.toUri().toString();
    }

    public BlobContainer blobContainer(BlobPath path) {
        return new HdfsBlobContainer(path, this, this.buildHdfsPath(path), this.bufferSize, this.securityContext);
    }

    private Path buildHdfsPath(BlobPath blobPath) {
        Path path = this.translateToHdfsPath(blobPath);
        if (!this.readOnly) {
            try {
                this.mkdirs(path);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
            }
            catch (IOException ex) {
                throw new OpenSearchException("failed to create blob container", (Throwable)ex, new Object[0]);
            }
        }
        return path;
    }

    private Path translateToHdfsPath(BlobPath blobPath) {
        Path path = this.root;
        for (String p : blobPath) {
            path = new Path(path, p);
        }
        return path;
    }

    <V> V execute(Operation<V> operation) throws IOException {
        if (this.closed) {
            throw new AlreadyClosedException("HdfsBlobStore is closed: " + this);
        }
        return (V)this.securityContext.doPrivilegedOrThrow(() -> {
            this.securityContext.ensureLogin();
            return operation.run(this.fileContext);
        });
    }

    public void close() {
        this.closed = true;
    }

    static interface Operation<V> {
        public V run(FileContext var1) throws IOException;
    }
}

