/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.oauth;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonReader;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import org.openstreetmap.josm.data.oauth.IOAuthParameters;
import org.openstreetmap.josm.data.oauth.IOAuthToken;
import org.openstreetmap.josm.data.oauth.OAuth20Exception;
import org.openstreetmap.josm.data.oauth.OAuthException;
import org.openstreetmap.josm.data.oauth.OAuthVersion;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Utils;

public final class OAuth20Token
implements IOAuthToken {
    private static final String ACCESS_TOKEN = "access_token";
    private static final String CREATED_AT = "created_at";
    private static final String EXPIRES_IN = "expires_in";
    private static final String REFRESH_TOKEN = "refresh_token";
    private static final String SCOPE = "scope";
    private static final String TOKEN_TYPE = "token_type";
    private final String accessToken;
    private final String tokenType;
    private final int expiresIn;
    private final String refreshToken;
    private final String[] scopes;
    private final Instant createdAt;
    private final IOAuthParameters oauthParameters;

    public OAuth20Token(IOAuthParameters oauthParameters, String json) throws OAuth20Exception {
        this(oauthParameters, new InputStreamReader((InputStream)new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8));
    }

    OAuth20Token(IOAuthParameters oauthParameters, Reader bufferedReader) throws OAuth20Exception {
        this.oauthParameters = oauthParameters;
        try (JsonReader reader = Json.createReader(bufferedReader);){
            JsonStructure structure = reader.read();
            if (structure.getValueType() != JsonValue.ValueType.OBJECT || !structure.asJsonObject().containsKey(ACCESS_TOKEN) || !structure.asJsonObject().containsKey(TOKEN_TYPE)) {
                if (structure.getValueType() == JsonValue.ValueType.OBJECT && structure.asJsonObject().containsKey("error")) {
                    throw new OAuth20Exception(structure.asJsonObject());
                }
                throw new OAuth20Exception("Either access_token or token_type is not present: " + structure);
            }
            JsonObject object = structure.asJsonObject();
            this.accessToken = object.getString(ACCESS_TOKEN);
            this.tokenType = object.getString(TOKEN_TYPE);
            this.expiresIn = object.getInt(EXPIRES_IN, Integer.MAX_VALUE);
            this.refreshToken = object.getString(REFRESH_TOKEN, null);
            this.scopes = object.getString(SCOPE, "").split(" ");
            this.createdAt = object.containsKey(CREATED_AT) ? Instant.ofEpochSecond(object.getJsonNumber(CREATED_AT).longValue()) : Instant.now();
        }
    }

    @Override
    public void sign(HttpClient client) throws OAuthException {
        if (!Utils.isBlank(this.oauthParameters.getApiUrl()) && !this.oauthParameters.getApiUrl().contains(client.getURL().getHost())) {
            String host = URI.create(this.oauthParameters.getAccessTokenUrl()).getHost();
            throw new IllegalArgumentException("Cannot sign URL with token for different host: Expected " + host + " but got " + client.getURL().getHost());
        }
        if (this.getBearerToken() != null) {
            client.setHeader("Authorization", "Bearer " + this.getBearerToken());
            return;
        }
        throw new OAuth20Exception("Unknown token type: " + this.tokenType);
    }

    public String getBearerToken() {
        if ("bearer".equalsIgnoreCase(this.tokenType)) {
            return this.accessToken;
        }
        return null;
    }

    @Override
    public String toPreferencesString() {
        OAuth20Token tokenToSave = this.shouldRefresh() ? this.refresh() : this;
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        jsonObjectBuilder.add(ACCESS_TOKEN, tokenToSave.accessToken);
        jsonObjectBuilder.add(TOKEN_TYPE, tokenToSave.tokenType);
        if (tokenToSave.createdAt != null) {
            jsonObjectBuilder.add(CREATED_AT, tokenToSave.createdAt.getEpochSecond());
        }
        if (tokenToSave.expiresIn != Integer.MAX_VALUE) {
            jsonObjectBuilder.add(EXPIRES_IN, tokenToSave.expiresIn);
        }
        if (tokenToSave.refreshToken != null) {
            jsonObjectBuilder.add(REFRESH_TOKEN, tokenToSave.refreshToken);
        }
        if (tokenToSave.scopes.length > 0) {
            jsonObjectBuilder.add(SCOPE, String.join((CharSequence)" ", tokenToSave.scopes));
        }
        return jsonObjectBuilder.build().toString();
    }

    @Override
    public OAuthVersion getOAuthType() {
        return OAuthVersion.OAuth20;
    }

    @Override
    public IOAuthParameters getParameters() {
        return this.oauthParameters;
    }

    boolean shouldRefresh() {
        return this.refreshToken != null && this.expiresIn != Integer.MAX_VALUE && this.createdAt.getEpochSecond() + (long)this.expiresIn < Instant.now().getEpochSecond() - (long)this.expiresIn * 9L / 10L;
    }

    OAuth20Token refresh() {
        String refresh = "grant_type=refresh_token&refresh_token=" + this.refreshToken;
        if (this.scopes.length > 0) {
            refresh = refresh + "&scope=" + String.join((CharSequence)" ", this.scopes);
        }
        HttpClient client = null;
        try {
            client = HttpClient.create(new URL(this.oauthParameters.getAccessTokenUrl()), "POST");
            client.setRequestBody(refresh.getBytes(StandardCharsets.UTF_8));
            client.connect();
            HttpClient.Response response = client.getResponse();
            OAuth20Token oAuth20Token = new OAuth20Token(this.oauthParameters, response.getContentReader());
            return oAuth20Token;
        }
        catch (IOException | OAuth20Exception e) {
            throw new JosmRuntimeException(e);
        }
        finally {
            if (client != null) {
                client.disconnect();
            }
        }
    }
}

