/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.parser;

import net.sf.saxon.Controller;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.SequenceCollector;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.SuppliedParameterReference;
import net.sf.saxon.expr.TailExpression;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.ma.zeno.ZenoSequence;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerRange;
import net.sf.saxon.value.MemoClosure;

public abstract class Evaluator {
    public abstract int getCode();

    public abstract Sequence evaluate(Expression var1, XPathContext var2) throws XPathException;

    public static final class LazyTail
    extends Evaluator {
        public static final LazyTail INSTANCE = new LazyTail();

        @Override
        public int getCode() {
            return 10;
        }

        @Override
        public Sequence evaluate(Expression expr, XPathContext context) throws XPathException {
            TailExpression tail = (TailExpression)expr;
            VariableReference vr = (VariableReference)tail.getBaseExpression();
            Sequence base = Variable.INSTANCE.evaluate(vr, context);
            if (base instanceof MemoClosure) {
                SequenceIterator it = base.iterate();
                base = SequenceTool.toGroundedValue(it);
            }
            if (base instanceof IntegerRange) {
                long end;
                long step = ((IntegerRange)base).getStep();
                long start = ((IntegerRange)base).getStart() + (long)(tail.getStart() - 1) * step;
                if (start == (end = ((IntegerRange)base).getEnd())) {
                    return Int64Value.makeIntegerValue(end);
                }
                if (start > end) {
                    return EmptySequence.getInstance();
                }
                return new IntegerRange(start, step, end);
            }
            if (base instanceof GroundedValue) {
                GroundedValue baseSeq = (GroundedValue)base;
                return baseSeq.subsequence(tail.getStart() - 1, baseSeq.getLength() - tail.getStart() + 1);
            }
            return new MemoClosure(tail, context);
        }
    }

    public static final class Process
    extends Evaluator {
        public static final Process INSTANCE = new Process();

        @Override
        public int getCode() {
            return 9;
        }

        @Override
        public Sequence evaluate(Expression expr, XPathContext context) throws XPathException {
            Controller controller = context.getController();
            SequenceCollector seq = controller.allocateSequenceOutputter();
            ComplexContentOutputter out = new ComplexContentOutputter(seq);
            out.open();
            expr.process(out, context);
            out.close();
            Sequence val = seq.getSequence();
            seq.reset();
            return val;
        }
    }

    public static final class MakeIndexedVariable
    extends Evaluator {
        public static final MakeIndexedVariable INSTANCE = new MakeIndexedVariable();

        @Override
        public int getCode() {
            return 12;
        }

        @Override
        public Sequence evaluate(Expression expr, XPathContext context) throws XPathException {
            return context.getConfiguration().obtainOptimizer().makeIndexedValue(expr.iterate(context));
        }
    }

    public static final class StreamingArgument
    extends Evaluator {
        public static final StreamingArgument INSTANCE = new StreamingArgument();

        @Override
        public int getCode() {
            return 15;
        }

        @Override
        public Sequence evaluate(Expression expr, XPathContext context) throws XPathException {
            return context.getConfiguration().obtainOptimizer().evaluateStreamingArgument(expr, context);
        }
    }

    public static final class SharedAppend
    extends Evaluator {
        public static final SharedAppend INSTANCE = new SharedAppend();

        @Override
        public int getCode() {
            return 11;
        }

        @Override
        public Sequence evaluate(Expression expr, XPathContext context) throws XPathException {
            try {
                if (expr instanceof Block) {
                    Block block = (Block)expr;
                    Operand[] children = block.getOperanda();
                    ZenoSequence chain = new ZenoSequence();
                    for (Operand o : children) {
                        Item item;
                        Expression child = o.getChildExpression();
                        if (child instanceof VariableReference) {
                            GroundedValue seq = ((VariableReference)child).evaluateVariable(context).materialize();
                            chain = chain.appendSequence(seq);
                            continue;
                        }
                        SequenceIterator iter = child.iterate(context);
                        while ((item = iter.next()) != null) {
                            chain = chain.append(item);
                        }
                    }
                    return chain;
                }
                return SequenceTool.toGroundedValue(expr.iterate(context));
            }
            catch (UncheckedXPathException e) {
                throw e.getXPathException();
            }
        }
    }

    public static final class EagerSequence
    extends Evaluator {
        public static EagerSequence INSTANCE = new EagerSequence();

        @Override
        public int getCode() {
            return 8;
        }

        @Override
        public Sequence evaluate(Expression expr, XPathContext context) throws XPathException {
            try {
                SequenceIterator iter = expr.iterate(context);
                return SequenceTool.toGroundedValue(iter);
            }
            catch (UncheckedXPathException e) {
                throw e.getXPathException();
            }
        }
    }

    public static final class SingletonClosure
    extends Evaluator {
        public static final SingletonClosure INSTANCE = new SingletonClosure();

        @Override
        public int getCode() {
            return 13;
        }

        @Override
        public Sequence evaluate(Expression expr, XPathContext context) throws XPathException {
            return new net.sf.saxon.value.SingletonClosure(expr, context);
        }
    }

    public static final class MemoClosureEvaluator
    extends Evaluator {
        public static final MemoClosureEvaluator INSTANCE = new MemoClosureEvaluator();

        @Override
        public int getCode() {
            return 4;
        }

        @Override
        public Sequence evaluate(Expression expr, XPathContext context) throws XPathException {
            return new MemoClosure(expr, context);
        }
    }

    public static final class LazySequence
    extends Evaluator {
        public static final LazySequence INSTANCE = new LazySequence();

        @Override
        public int getCode() {
            return 3;
        }

        @Override
        public Sequence evaluate(Expression expr, XPathContext context) throws XPathException {
            SequenceIterator iter = expr.iterate(context);
            return new net.sf.saxon.om.LazySequence(iter);
        }
    }

    public static final class OptionalItem
    extends Evaluator {
        public static final OptionalItem INSTANCE = new OptionalItem();

        @Override
        public int getCode() {
            return 7;
        }

        @Override
        public Sequence evaluate(Expression expr, XPathContext context) throws XPathException {
            Item item = expr.evaluateItem(context);
            if (item == null) {
                return EmptySequence.getInstance();
            }
            return item;
        }
    }

    public static final class SingleItem
    extends Evaluator {
        public static final SingleItem INSTANCE = new SingleItem();

        private SingleItem() {
        }

        @Override
        public int getCode() {
            return 16;
        }

        @Override
        public Item evaluate(Expression expr, XPathContext context) throws XPathException {
            return expr.evaluateItem(context);
        }
    }

    public static final class SuppliedParameter
    extends Evaluator {
        public static final SuppliedParameter INSTANCE = new SuppliedParameter();

        private SuppliedParameter() {
        }

        @Override
        public int getCode() {
            return 14;
        }

        @Override
        public Sequence evaluate(Expression expr, XPathContext context) throws XPathException {
            try {
                return ((SuppliedParameterReference)expr).evaluateVariable(context);
            }
            catch (ClassCastException e) {
                assert (false);
                return LazySequence.INSTANCE.evaluate(expr, context);
            }
        }
    }

    public static final class Variable
    extends Evaluator {
        public static Variable INSTANCE = new Variable();

        private Variable() {
        }

        @Override
        public int getCode() {
            return 1;
        }

        @Override
        public Sequence evaluate(Expression expr, XPathContext context) throws XPathException {
            try {
                return ((VariableReference)expr).evaluateVariable(context);
            }
            catch (ClassCastException e) {
                assert (false);
                return LazySequence.INSTANCE.evaluate(expr, context);
            }
        }
    }

    public static final class Literal
    extends Evaluator {
        public static Literal INSTANCE = new Literal();

        private Literal() {
        }

        @Override
        public int getCode() {
            return 0;
        }

        @Override
        public Sequence evaluate(Expression expr, XPathContext context) {
            return ((net.sf.saxon.expr.Literal)expr).getGroundedValue();
        }
    }

    public static final class EmptySequenceEvaluator
    extends Evaluator {
        public static final EmptySequenceEvaluator INSTANCE = new EmptySequenceEvaluator();

        private EmptySequenceEvaluator() {
        }

        @Override
        public int getCode() {
            return 5;
        }

        @Override
        public Sequence evaluate(Expression expr, XPathContext context) {
            return EmptySequence.getInstance();
        }
    }
}

