/*
 * Decompiled with CFR 0.152.
 */
package pl.com.salsoft.sqlitestudioremote.internal;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Utils {
    public static String LOG_TAG = "SQLiteStudioRemote";
    protected static final char[] hexArray = "0123456789ABCDEF".toCharArray();

    public static String toBlobString(byte[] blob) {
        StringBuilder builder = new StringBuilder();
        builder.append("X'").append(Utils.bytesToHex(blob)).append("'");
        return builder.toString();
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    public static String createRegexFromGlob(String glob) {
        String out = "^";
        block6: for (int i = 0; i < glob.length(); ++i) {
            char c = glob.charAt(i);
            switch (c) {
                case '*': {
                    out = out + ".*";
                    continue block6;
                }
                case '?': {
                    out = out + '.';
                    continue block6;
                }
                case '.': {
                    out = out + "\\.";
                    continue block6;
                }
                case '\\': {
                    out = out + "\\\\";
                    continue block6;
                }
                default: {
                    out = out + c;
                }
            }
        }
        out = out + '$';
        return out;
    }

    public static byte[] md5(String s) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(s.getBytes());
            return digest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return new byte[0];
        }
    }
}

