% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R, R/methods_row.R
\name{colCollapse,xgCMatrix-method}
\alias{colCollapse,xgCMatrix-method}
\alias{rowCollapse,xgCMatrix-method}
\title{Extract one cell from each row (column) of a matrix-like object}
\usage{
\S4method{colCollapse}{xgCMatrix}(x, idxs, cols = NULL)

\S4method{rowCollapse}{xgCMatrix}(x, idxs, rows = NULL)
}
\arguments{
\item{x}{An NxK matrix-like object.}

\item{idxs}{An index \code{\link{vector}} with the position to extract.
It is recycled to match the number of rows (column)}

\item{cols}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{rows}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}
}
\value{
Returns a \code{\link{numeric}} \code{\link{vector}} of length N (K).
}
\description{
Extract one cell from each row (column) of a matrix-like object.
}
\details{
The S4 methods for \code{x} of type \code{\link{matrix}},
\code{\link{array}}, or \code{\link{numeric}} call
\code{matrixStats::rowCollapse}
/ \code{matrixStats::colCollapse}.
}
\examples{
mat <- matrix(rnorm(15), nrow = 5, ncol = 3)
  mat[2, 1] <- NA
  mat[3, 3] <- Inf
  mat[4, 1] <- 0
  
  print(mat)
  
  rowCollapse(mat, idxs = 2)
  rowCollapse(mat, idxs = c(1,1,2,3,2))
  
  colCollapse (mat, idxs = 4)
}
\seealso{
\itemize{
\item \code{matrixStats::\link[matrixStats:rowCollapse]{rowCollapse}()}
and \code{matrixStats::\link[matrixStats:rowCollapse]{colCollapse}()}
which are used when the input is a \code{matrix} or \code{numeric} vector.
}
}
