// Code generated by smithy-go-codegen DO NOT EDIT.

package rekognition

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/rekognition/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"math"
	"path"
)

type awsAwsjson11_serializeOpCompareFaces struct {
}

func (*awsAwsjson11_serializeOpCompareFaces) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCompareFaces) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CompareFacesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.CompareFaces")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCompareFacesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCopyProjectVersion struct {
}

func (*awsAwsjson11_serializeOpCopyProjectVersion) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCopyProjectVersion) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CopyProjectVersionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.CopyProjectVersion")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCopyProjectVersionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateCollection struct {
}

func (*awsAwsjson11_serializeOpCreateCollection) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateCollection) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateCollectionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.CreateCollection")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateCollectionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateDataset struct {
}

func (*awsAwsjson11_serializeOpCreateDataset) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateDataset) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateDatasetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.CreateDataset")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateDatasetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateProject struct {
}

func (*awsAwsjson11_serializeOpCreateProject) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateProject) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateProjectInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.CreateProject")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateProjectInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateProjectVersion struct {
}

func (*awsAwsjson11_serializeOpCreateProjectVersion) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateProjectVersion) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateProjectVersionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.CreateProjectVersion")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateProjectVersionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateStreamProcessor struct {
}

func (*awsAwsjson11_serializeOpCreateStreamProcessor) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateStreamProcessor) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateStreamProcessorInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.CreateStreamProcessor")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateStreamProcessorInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteCollection struct {
}

func (*awsAwsjson11_serializeOpDeleteCollection) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteCollection) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteCollectionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.DeleteCollection")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteCollectionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteDataset struct {
}

func (*awsAwsjson11_serializeOpDeleteDataset) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteDataset) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteDatasetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.DeleteDataset")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteDatasetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteFaces struct {
}

func (*awsAwsjson11_serializeOpDeleteFaces) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteFaces) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteFacesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.DeleteFaces")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteFacesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteProject struct {
}

func (*awsAwsjson11_serializeOpDeleteProject) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteProject) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteProjectInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.DeleteProject")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteProjectInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteProjectPolicy struct {
}

func (*awsAwsjson11_serializeOpDeleteProjectPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteProjectPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteProjectPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.DeleteProjectPolicy")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteProjectPolicyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteProjectVersion struct {
}

func (*awsAwsjson11_serializeOpDeleteProjectVersion) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteProjectVersion) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteProjectVersionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.DeleteProjectVersion")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteProjectVersionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteStreamProcessor struct {
}

func (*awsAwsjson11_serializeOpDeleteStreamProcessor) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteStreamProcessor) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteStreamProcessorInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.DeleteStreamProcessor")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteStreamProcessorInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeCollection struct {
}

func (*awsAwsjson11_serializeOpDescribeCollection) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeCollection) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeCollectionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.DescribeCollection")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeCollectionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeDataset struct {
}

func (*awsAwsjson11_serializeOpDescribeDataset) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeDataset) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeDatasetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.DescribeDataset")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeDatasetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeProjects struct {
}

func (*awsAwsjson11_serializeOpDescribeProjects) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeProjects) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeProjectsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.DescribeProjects")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeProjectsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeProjectVersions struct {
}

func (*awsAwsjson11_serializeOpDescribeProjectVersions) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeProjectVersions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeProjectVersionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.DescribeProjectVersions")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeProjectVersionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeStreamProcessor struct {
}

func (*awsAwsjson11_serializeOpDescribeStreamProcessor) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeStreamProcessor) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeStreamProcessorInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.DescribeStreamProcessor")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeStreamProcessorInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDetectCustomLabels struct {
}

func (*awsAwsjson11_serializeOpDetectCustomLabels) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDetectCustomLabels) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DetectCustomLabelsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.DetectCustomLabels")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDetectCustomLabelsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDetectFaces struct {
}

func (*awsAwsjson11_serializeOpDetectFaces) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDetectFaces) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DetectFacesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.DetectFaces")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDetectFacesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDetectLabels struct {
}

func (*awsAwsjson11_serializeOpDetectLabels) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDetectLabels) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DetectLabelsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.DetectLabels")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDetectLabelsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDetectModerationLabels struct {
}

func (*awsAwsjson11_serializeOpDetectModerationLabels) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDetectModerationLabels) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DetectModerationLabelsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.DetectModerationLabels")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDetectModerationLabelsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDetectProtectiveEquipment struct {
}

func (*awsAwsjson11_serializeOpDetectProtectiveEquipment) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDetectProtectiveEquipment) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DetectProtectiveEquipmentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.DetectProtectiveEquipment")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDetectProtectiveEquipmentInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDetectText struct {
}

func (*awsAwsjson11_serializeOpDetectText) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDetectText) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DetectTextInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.DetectText")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDetectTextInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDistributeDatasetEntries struct {
}

func (*awsAwsjson11_serializeOpDistributeDatasetEntries) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDistributeDatasetEntries) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DistributeDatasetEntriesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.DistributeDatasetEntries")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDistributeDatasetEntriesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetCelebrityInfo struct {
}

func (*awsAwsjson11_serializeOpGetCelebrityInfo) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetCelebrityInfo) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetCelebrityInfoInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.GetCelebrityInfo")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetCelebrityInfoInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetCelebrityRecognition struct {
}

func (*awsAwsjson11_serializeOpGetCelebrityRecognition) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetCelebrityRecognition) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetCelebrityRecognitionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.GetCelebrityRecognition")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetCelebrityRecognitionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetContentModeration struct {
}

func (*awsAwsjson11_serializeOpGetContentModeration) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetContentModeration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetContentModerationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.GetContentModeration")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetContentModerationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetFaceDetection struct {
}

func (*awsAwsjson11_serializeOpGetFaceDetection) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetFaceDetection) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetFaceDetectionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.GetFaceDetection")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetFaceDetectionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetFaceSearch struct {
}

func (*awsAwsjson11_serializeOpGetFaceSearch) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetFaceSearch) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetFaceSearchInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.GetFaceSearch")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetFaceSearchInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetLabelDetection struct {
}

func (*awsAwsjson11_serializeOpGetLabelDetection) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetLabelDetection) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetLabelDetectionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.GetLabelDetection")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetLabelDetectionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetPersonTracking struct {
}

func (*awsAwsjson11_serializeOpGetPersonTracking) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetPersonTracking) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetPersonTrackingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.GetPersonTracking")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetPersonTrackingInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetSegmentDetection struct {
}

func (*awsAwsjson11_serializeOpGetSegmentDetection) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetSegmentDetection) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetSegmentDetectionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.GetSegmentDetection")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetSegmentDetectionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetTextDetection struct {
}

func (*awsAwsjson11_serializeOpGetTextDetection) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetTextDetection) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetTextDetectionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.GetTextDetection")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetTextDetectionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpIndexFaces struct {
}

func (*awsAwsjson11_serializeOpIndexFaces) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpIndexFaces) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*IndexFacesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.IndexFaces")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentIndexFacesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListCollections struct {
}

func (*awsAwsjson11_serializeOpListCollections) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListCollections) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListCollectionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.ListCollections")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListCollectionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListDatasetEntries struct {
}

func (*awsAwsjson11_serializeOpListDatasetEntries) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListDatasetEntries) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDatasetEntriesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.ListDatasetEntries")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListDatasetEntriesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListDatasetLabels struct {
}

func (*awsAwsjson11_serializeOpListDatasetLabels) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListDatasetLabels) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDatasetLabelsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.ListDatasetLabels")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListDatasetLabelsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListFaces struct {
}

func (*awsAwsjson11_serializeOpListFaces) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListFaces) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListFacesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.ListFaces")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListFacesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListProjectPolicies struct {
}

func (*awsAwsjson11_serializeOpListProjectPolicies) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListProjectPolicies) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListProjectPoliciesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.ListProjectPolicies")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListProjectPoliciesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListStreamProcessors struct {
}

func (*awsAwsjson11_serializeOpListStreamProcessors) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListStreamProcessors) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListStreamProcessorsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.ListStreamProcessors")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListStreamProcessorsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListTagsForResource struct {
}

func (*awsAwsjson11_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.ListTagsForResource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListTagsForResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpPutProjectPolicy struct {
}

func (*awsAwsjson11_serializeOpPutProjectPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpPutProjectPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutProjectPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.PutProjectPolicy")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentPutProjectPolicyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpRecognizeCelebrities struct {
}

func (*awsAwsjson11_serializeOpRecognizeCelebrities) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpRecognizeCelebrities) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RecognizeCelebritiesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.RecognizeCelebrities")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentRecognizeCelebritiesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpSearchFaces struct {
}

func (*awsAwsjson11_serializeOpSearchFaces) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpSearchFaces) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SearchFacesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.SearchFaces")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentSearchFacesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpSearchFacesByImage struct {
}

func (*awsAwsjson11_serializeOpSearchFacesByImage) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpSearchFacesByImage) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SearchFacesByImageInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.SearchFacesByImage")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentSearchFacesByImageInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpStartCelebrityRecognition struct {
}

func (*awsAwsjson11_serializeOpStartCelebrityRecognition) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpStartCelebrityRecognition) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartCelebrityRecognitionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.StartCelebrityRecognition")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentStartCelebrityRecognitionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpStartContentModeration struct {
}

func (*awsAwsjson11_serializeOpStartContentModeration) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpStartContentModeration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartContentModerationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.StartContentModeration")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentStartContentModerationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpStartFaceDetection struct {
}

func (*awsAwsjson11_serializeOpStartFaceDetection) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpStartFaceDetection) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartFaceDetectionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.StartFaceDetection")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentStartFaceDetectionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpStartFaceSearch struct {
}

func (*awsAwsjson11_serializeOpStartFaceSearch) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpStartFaceSearch) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartFaceSearchInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.StartFaceSearch")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentStartFaceSearchInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpStartLabelDetection struct {
}

func (*awsAwsjson11_serializeOpStartLabelDetection) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpStartLabelDetection) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartLabelDetectionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.StartLabelDetection")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentStartLabelDetectionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpStartPersonTracking struct {
}

func (*awsAwsjson11_serializeOpStartPersonTracking) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpStartPersonTracking) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartPersonTrackingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.StartPersonTracking")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentStartPersonTrackingInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpStartProjectVersion struct {
}

func (*awsAwsjson11_serializeOpStartProjectVersion) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpStartProjectVersion) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartProjectVersionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.StartProjectVersion")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentStartProjectVersionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpStartSegmentDetection struct {
}

func (*awsAwsjson11_serializeOpStartSegmentDetection) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpStartSegmentDetection) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartSegmentDetectionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.StartSegmentDetection")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentStartSegmentDetectionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpStartStreamProcessor struct {
}

func (*awsAwsjson11_serializeOpStartStreamProcessor) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpStartStreamProcessor) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartStreamProcessorInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.StartStreamProcessor")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentStartStreamProcessorInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpStartTextDetection struct {
}

func (*awsAwsjson11_serializeOpStartTextDetection) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpStartTextDetection) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartTextDetectionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.StartTextDetection")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentStartTextDetectionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpStopProjectVersion struct {
}

func (*awsAwsjson11_serializeOpStopProjectVersion) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpStopProjectVersion) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StopProjectVersionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.StopProjectVersion")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentStopProjectVersionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpStopStreamProcessor struct {
}

func (*awsAwsjson11_serializeOpStopStreamProcessor) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpStopStreamProcessor) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StopStreamProcessorInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.StopStreamProcessor")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentStopStreamProcessorInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpTagResource struct {
}

func (*awsAwsjson11_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.TagResource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUntagResource struct {
}

func (*awsAwsjson11_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.UntagResource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUntagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateDatasetEntries struct {
}

func (*awsAwsjson11_serializeOpUpdateDatasetEntries) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateDatasetEntries) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateDatasetEntriesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.UpdateDatasetEntries")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateDatasetEntriesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateStreamProcessor struct {
}

func (*awsAwsjson11_serializeOpUpdateStreamProcessor) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateStreamProcessor) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateStreamProcessorInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("RekognitionService.UpdateStreamProcessor")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateStreamProcessorInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsAwsjson11_serializeDocumentAsset(v *types.Asset, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GroundTruthManifest != nil {
		ok := object.Key("GroundTruthManifest")
		if err := awsAwsjson11_serializeDocumentGroundTruthManifest(v.GroundTruthManifest, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentAssets(v []types.Asset, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentAsset(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentAttributes(v []types.Attribute, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsjson11_serializeDocumentBlackFrame(v *types.BlackFrame, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxPixelThreshold != nil {
		ok := object.Key("MaxPixelThreshold")
		switch {
		case math.IsNaN(float64(*v.MaxPixelThreshold)):
			ok.String("NaN")

		case math.IsInf(float64(*v.MaxPixelThreshold), 1):
			ok.String("Infinity")

		case math.IsInf(float64(*v.MaxPixelThreshold), -1):
			ok.String("-Infinity")

		default:
			ok.Float(*v.MaxPixelThreshold)

		}
	}

	if v.MinCoveragePercentage != nil {
		ok := object.Key("MinCoveragePercentage")
		switch {
		case math.IsNaN(float64(*v.MinCoveragePercentage)):
			ok.String("NaN")

		case math.IsInf(float64(*v.MinCoveragePercentage), 1):
			ok.String("Infinity")

		case math.IsInf(float64(*v.MinCoveragePercentage), -1):
			ok.String("-Infinity")

		default:
			ok.Float(*v.MinCoveragePercentage)

		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentBoundingBox(v *types.BoundingBox, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Height != nil {
		ok := object.Key("Height")
		switch {
		case math.IsNaN(float64(*v.Height)):
			ok.String("NaN")

		case math.IsInf(float64(*v.Height), 1):
			ok.String("Infinity")

		case math.IsInf(float64(*v.Height), -1):
			ok.String("-Infinity")

		default:
			ok.Float(*v.Height)

		}
	}

	if v.Left != nil {
		ok := object.Key("Left")
		switch {
		case math.IsNaN(float64(*v.Left)):
			ok.String("NaN")

		case math.IsInf(float64(*v.Left), 1):
			ok.String("Infinity")

		case math.IsInf(float64(*v.Left), -1):
			ok.String("-Infinity")

		default:
			ok.Float(*v.Left)

		}
	}

	if v.Top != nil {
		ok := object.Key("Top")
		switch {
		case math.IsNaN(float64(*v.Top)):
			ok.String("NaN")

		case math.IsInf(float64(*v.Top), 1):
			ok.String("Infinity")

		case math.IsInf(float64(*v.Top), -1):
			ok.String("-Infinity")

		default:
			ok.Float(*v.Top)

		}
	}

	if v.Width != nil {
		ok := object.Key("Width")
		switch {
		case math.IsNaN(float64(*v.Width)):
			ok.String("NaN")

		case math.IsInf(float64(*v.Width), 1):
			ok.String("Infinity")

		case math.IsInf(float64(*v.Width), -1):
			ok.String("-Infinity")

		default:
			ok.Float(*v.Width)

		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentConnectedHomeLabels(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentConnectedHomeSettings(v *types.ConnectedHomeSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Labels != nil {
		ok := object.Key("Labels")
		if err := awsAwsjson11_serializeDocumentConnectedHomeLabels(v.Labels, ok); err != nil {
			return err
		}
	}

	if v.MinConfidence != nil {
		ok := object.Key("MinConfidence")
		switch {
		case math.IsNaN(float64(*v.MinConfidence)):
			ok.String("NaN")

		case math.IsInf(float64(*v.MinConfidence), 1):
			ok.String("Infinity")

		case math.IsInf(float64(*v.MinConfidence), -1):
			ok.String("-Infinity")

		default:
			ok.Float(*v.MinConfidence)

		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentConnectedHomeSettingsForUpdate(v *types.ConnectedHomeSettingsForUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Labels != nil {
		ok := object.Key("Labels")
		if err := awsAwsjson11_serializeDocumentConnectedHomeLabels(v.Labels, ok); err != nil {
			return err
		}
	}

	if v.MinConfidence != nil {
		ok := object.Key("MinConfidence")
		switch {
		case math.IsNaN(float64(*v.MinConfidence)):
			ok.String("NaN")

		case math.IsInf(float64(*v.MinConfidence), 1):
			ok.String("Infinity")

		case math.IsInf(float64(*v.MinConfidence), -1):
			ok.String("-Infinity")

		default:
			ok.Float(*v.MinConfidence)

		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentContentClassifiers(v []types.ContentClassifier, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsjson11_serializeDocumentDatasetChanges(v *types.DatasetChanges, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GroundTruth != nil {
		ok := object.Key("GroundTruth")
		ok.Base64EncodeBytes(v.GroundTruth)
	}

	return nil
}

func awsAwsjson11_serializeDocumentDatasetLabels(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentDatasetSource(v *types.DatasetSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DatasetArn != nil {
		ok := object.Key("DatasetArn")
		ok.String(*v.DatasetArn)
	}

	if v.GroundTruthManifest != nil {
		ok := object.Key("GroundTruthManifest")
		if err := awsAwsjson11_serializeDocumentGroundTruthManifest(v.GroundTruthManifest, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentDetectionFilter(v *types.DetectionFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MinBoundingBoxHeight != nil {
		ok := object.Key("MinBoundingBoxHeight")
		switch {
		case math.IsNaN(float64(*v.MinBoundingBoxHeight)):
			ok.String("NaN")

		case math.IsInf(float64(*v.MinBoundingBoxHeight), 1):
			ok.String("Infinity")

		case math.IsInf(float64(*v.MinBoundingBoxHeight), -1):
			ok.String("-Infinity")

		default:
			ok.Float(*v.MinBoundingBoxHeight)

		}
	}

	if v.MinBoundingBoxWidth != nil {
		ok := object.Key("MinBoundingBoxWidth")
		switch {
		case math.IsNaN(float64(*v.MinBoundingBoxWidth)):
			ok.String("NaN")

		case math.IsInf(float64(*v.MinBoundingBoxWidth), 1):
			ok.String("Infinity")

		case math.IsInf(float64(*v.MinBoundingBoxWidth), -1):
			ok.String("-Infinity")

		default:
			ok.Float(*v.MinBoundingBoxWidth)

		}
	}

	if v.MinConfidence != nil {
		ok := object.Key("MinConfidence")
		switch {
		case math.IsNaN(float64(*v.MinConfidence)):
			ok.String("NaN")

		case math.IsInf(float64(*v.MinConfidence), 1):
			ok.String("Infinity")

		case math.IsInf(float64(*v.MinConfidence), -1):
			ok.String("-Infinity")

		default:
			ok.Float(*v.MinConfidence)

		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentDetectTextFilters(v *types.DetectTextFilters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RegionsOfInterest != nil {
		ok := object.Key("RegionsOfInterest")
		if err := awsAwsjson11_serializeDocumentRegionsOfInterest(v.RegionsOfInterest, ok); err != nil {
			return err
		}
	}

	if v.WordFilter != nil {
		ok := object.Key("WordFilter")
		if err := awsAwsjson11_serializeDocumentDetectionFilter(v.WordFilter, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentDistributeDataset(v *types.DistributeDataset, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Arn != nil {
		ok := object.Key("Arn")
		ok.String(*v.Arn)
	}

	return nil
}

func awsAwsjson11_serializeDocumentDistributeDatasetMetadataList(v []types.DistributeDataset, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentDistributeDataset(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentFaceIdList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentFaceSearchSettings(v *types.FaceSearchSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CollectionId != nil {
		ok := object.Key("CollectionId")
		ok.String(*v.CollectionId)
	}

	if v.FaceMatchThreshold != nil {
		ok := object.Key("FaceMatchThreshold")
		switch {
		case math.IsNaN(float64(*v.FaceMatchThreshold)):
			ok.String("NaN")

		case math.IsInf(float64(*v.FaceMatchThreshold), 1):
			ok.String("Infinity")

		case math.IsInf(float64(*v.FaceMatchThreshold), -1):
			ok.String("-Infinity")

		default:
			ok.Float(*v.FaceMatchThreshold)

		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentGroundTruthManifest(v *types.GroundTruthManifest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.S3Object != nil {
		ok := object.Key("S3Object")
		if err := awsAwsjson11_serializeDocumentS3Object(v.S3Object, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentHumanLoopConfig(v *types.HumanLoopConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataAttributes != nil {
		ok := object.Key("DataAttributes")
		if err := awsAwsjson11_serializeDocumentHumanLoopDataAttributes(v.DataAttributes, ok); err != nil {
			return err
		}
	}

	if v.FlowDefinitionArn != nil {
		ok := object.Key("FlowDefinitionArn")
		ok.String(*v.FlowDefinitionArn)
	}

	if v.HumanLoopName != nil {
		ok := object.Key("HumanLoopName")
		ok.String(*v.HumanLoopName)
	}

	return nil
}

func awsAwsjson11_serializeDocumentHumanLoopDataAttributes(v *types.HumanLoopDataAttributes, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ContentClassifiers != nil {
		ok := object.Key("ContentClassifiers")
		if err := awsAwsjson11_serializeDocumentContentClassifiers(v.ContentClassifiers, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentImage(v *types.Image, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Bytes != nil {
		ok := object.Key("Bytes")
		ok.Base64EncodeBytes(v.Bytes)
	}

	if v.S3Object != nil {
		ok := object.Key("S3Object")
		if err := awsAwsjson11_serializeDocumentS3Object(v.S3Object, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentKinesisDataStream(v *types.KinesisDataStream, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Arn != nil {
		ok := object.Key("Arn")
		ok.String(*v.Arn)
	}

	return nil
}

func awsAwsjson11_serializeDocumentKinesisVideoStream(v *types.KinesisVideoStream, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Arn != nil {
		ok := object.Key("Arn")
		ok.String(*v.Arn)
	}

	return nil
}

func awsAwsjson11_serializeDocumentKinesisVideoStreamStartSelector(v *types.KinesisVideoStreamStartSelector, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FragmentNumber != nil {
		ok := object.Key("FragmentNumber")
		ok.String(*v.FragmentNumber)
	}

	if v.ProducerTimestamp != nil {
		ok := object.Key("ProducerTimestamp")
		ok.Long(*v.ProducerTimestamp)
	}

	return nil
}

func awsAwsjson11_serializeDocumentNotificationChannel(v *types.NotificationChannel, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RoleArn != nil {
		ok := object.Key("RoleArn")
		ok.String(*v.RoleArn)
	}

	if v.SNSTopicArn != nil {
		ok := object.Key("SNSTopicArn")
		ok.String(*v.SNSTopicArn)
	}

	return nil
}

func awsAwsjson11_serializeDocumentOutputConfig(v *types.OutputConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.S3Bucket != nil {
		ok := object.Key("S3Bucket")
		ok.String(*v.S3Bucket)
	}

	if v.S3KeyPrefix != nil {
		ok := object.Key("S3KeyPrefix")
		ok.String(*v.S3KeyPrefix)
	}

	return nil
}

func awsAwsjson11_serializeDocumentPoint(v *types.Point, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.X != nil {
		ok := object.Key("X")
		switch {
		case math.IsNaN(float64(*v.X)):
			ok.String("NaN")

		case math.IsInf(float64(*v.X), 1):
			ok.String("Infinity")

		case math.IsInf(float64(*v.X), -1):
			ok.String("-Infinity")

		default:
			ok.Float(*v.X)

		}
	}

	if v.Y != nil {
		ok := object.Key("Y")
		switch {
		case math.IsNaN(float64(*v.Y)):
			ok.String("NaN")

		case math.IsInf(float64(*v.Y), 1):
			ok.String("Infinity")

		case math.IsInf(float64(*v.Y), -1):
			ok.String("-Infinity")

		default:
			ok.Float(*v.Y)

		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentPolygon(v []types.Point, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentPoint(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentProjectNames(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentProtectiveEquipmentSummarizationAttributes(v *types.ProtectiveEquipmentSummarizationAttributes, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MinConfidence != nil {
		ok := object.Key("MinConfidence")
		switch {
		case math.IsNaN(float64(*v.MinConfidence)):
			ok.String("NaN")

		case math.IsInf(float64(*v.MinConfidence), 1):
			ok.String("Infinity")

		case math.IsInf(float64(*v.MinConfidence), -1):
			ok.String("-Infinity")

		default:
			ok.Float(*v.MinConfidence)

		}
	}

	if v.RequiredEquipmentTypes != nil {
		ok := object.Key("RequiredEquipmentTypes")
		if err := awsAwsjson11_serializeDocumentProtectiveEquipmentTypes(v.RequiredEquipmentTypes, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentProtectiveEquipmentTypes(v []types.ProtectiveEquipmentType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsjson11_serializeDocumentRegionOfInterest(v *types.RegionOfInterest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BoundingBox != nil {
		ok := object.Key("BoundingBox")
		if err := awsAwsjson11_serializeDocumentBoundingBox(v.BoundingBox, ok); err != nil {
			return err
		}
	}

	if v.Polygon != nil {
		ok := object.Key("Polygon")
		if err := awsAwsjson11_serializeDocumentPolygon(v.Polygon, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentRegionsOfInterest(v []types.RegionOfInterest, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentRegionOfInterest(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentS3Destination(v *types.S3Destination, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Bucket != nil {
		ok := object.Key("Bucket")
		ok.String(*v.Bucket)
	}

	if v.KeyPrefix != nil {
		ok := object.Key("KeyPrefix")
		ok.String(*v.KeyPrefix)
	}

	return nil
}

func awsAwsjson11_serializeDocumentS3Object(v *types.S3Object, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Bucket != nil {
		ok := object.Key("Bucket")
		ok.String(*v.Bucket)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Version != nil {
		ok := object.Key("Version")
		ok.String(*v.Version)
	}

	return nil
}

func awsAwsjson11_serializeDocumentSegmentTypes(v []types.SegmentType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsjson11_serializeDocumentStartSegmentDetectionFilters(v *types.StartSegmentDetectionFilters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ShotFilter != nil {
		ok := object.Key("ShotFilter")
		if err := awsAwsjson11_serializeDocumentStartShotDetectionFilter(v.ShotFilter, ok); err != nil {
			return err
		}
	}

	if v.TechnicalCueFilter != nil {
		ok := object.Key("TechnicalCueFilter")
		if err := awsAwsjson11_serializeDocumentStartTechnicalCueDetectionFilter(v.TechnicalCueFilter, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentStartShotDetectionFilter(v *types.StartShotDetectionFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MinSegmentConfidence != nil {
		ok := object.Key("MinSegmentConfidence")
		switch {
		case math.IsNaN(float64(*v.MinSegmentConfidence)):
			ok.String("NaN")

		case math.IsInf(float64(*v.MinSegmentConfidence), 1):
			ok.String("Infinity")

		case math.IsInf(float64(*v.MinSegmentConfidence), -1):
			ok.String("-Infinity")

		default:
			ok.Float(*v.MinSegmentConfidence)

		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentStartTechnicalCueDetectionFilter(v *types.StartTechnicalCueDetectionFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BlackFrame != nil {
		ok := object.Key("BlackFrame")
		if err := awsAwsjson11_serializeDocumentBlackFrame(v.BlackFrame, ok); err != nil {
			return err
		}
	}

	if v.MinSegmentConfidence != nil {
		ok := object.Key("MinSegmentConfidence")
		switch {
		case math.IsNaN(float64(*v.MinSegmentConfidence)):
			ok.String("NaN")

		case math.IsInf(float64(*v.MinSegmentConfidence), 1):
			ok.String("Infinity")

		case math.IsInf(float64(*v.MinSegmentConfidence), -1):
			ok.String("-Infinity")

		default:
			ok.Float(*v.MinSegmentConfidence)

		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentStartTextDetectionFilters(v *types.StartTextDetectionFilters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RegionsOfInterest != nil {
		ok := object.Key("RegionsOfInterest")
		if err := awsAwsjson11_serializeDocumentRegionsOfInterest(v.RegionsOfInterest, ok); err != nil {
			return err
		}
	}

	if v.WordFilter != nil {
		ok := object.Key("WordFilter")
		if err := awsAwsjson11_serializeDocumentDetectionFilter(v.WordFilter, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentStreamProcessingStartSelector(v *types.StreamProcessingStartSelector, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.KVSStreamStartSelector != nil {
		ok := object.Key("KVSStreamStartSelector")
		if err := awsAwsjson11_serializeDocumentKinesisVideoStreamStartSelector(v.KVSStreamStartSelector, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentStreamProcessingStopSelector(v *types.StreamProcessingStopSelector, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxDurationInSeconds != nil {
		ok := object.Key("MaxDurationInSeconds")
		ok.Long(*v.MaxDurationInSeconds)
	}

	return nil
}

func awsAwsjson11_serializeDocumentStreamProcessorDataSharingPreference(v *types.StreamProcessorDataSharingPreference, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("OptIn")
		ok.Boolean(v.OptIn)
	}

	return nil
}

func awsAwsjson11_serializeDocumentStreamProcessorInput(v *types.StreamProcessorInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.KinesisVideoStream != nil {
		ok := object.Key("KinesisVideoStream")
		if err := awsAwsjson11_serializeDocumentKinesisVideoStream(v.KinesisVideoStream, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentStreamProcessorNotificationChannel(v *types.StreamProcessorNotificationChannel, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SNSTopicArn != nil {
		ok := object.Key("SNSTopicArn")
		ok.String(*v.SNSTopicArn)
	}

	return nil
}

func awsAwsjson11_serializeDocumentStreamProcessorOutput(v *types.StreamProcessorOutput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.KinesisDataStream != nil {
		ok := object.Key("KinesisDataStream")
		if err := awsAwsjson11_serializeDocumentKinesisDataStream(v.KinesisDataStream, ok); err != nil {
			return err
		}
	}

	if v.S3Destination != nil {
		ok := object.Key("S3Destination")
		if err := awsAwsjson11_serializeDocumentS3Destination(v.S3Destination, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentStreamProcessorParametersToDelete(v []types.StreamProcessorParameterToDelete, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsjson11_serializeDocumentStreamProcessorSettings(v *types.StreamProcessorSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConnectedHome != nil {
		ok := object.Key("ConnectedHome")
		if err := awsAwsjson11_serializeDocumentConnectedHomeSettings(v.ConnectedHome, ok); err != nil {
			return err
		}
	}

	if v.FaceSearch != nil {
		ok := object.Key("FaceSearch")
		if err := awsAwsjson11_serializeDocumentFaceSearchSettings(v.FaceSearch, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentStreamProcessorSettingsForUpdate(v *types.StreamProcessorSettingsForUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConnectedHomeForUpdate != nil {
		ok := object.Key("ConnectedHomeForUpdate")
		if err := awsAwsjson11_serializeDocumentConnectedHomeSettingsForUpdate(v.ConnectedHomeForUpdate, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentTagKeyList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentTagMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsAwsjson11_serializeDocumentTestingData(v *types.TestingData, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Assets != nil {
		ok := object.Key("Assets")
		if err := awsAwsjson11_serializeDocumentAssets(v.Assets, ok); err != nil {
			return err
		}
	}

	if v.AutoCreate {
		ok := object.Key("AutoCreate")
		ok.Boolean(v.AutoCreate)
	}

	return nil
}

func awsAwsjson11_serializeDocumentTrainingData(v *types.TrainingData, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Assets != nil {
		ok := object.Key("Assets")
		if err := awsAwsjson11_serializeDocumentAssets(v.Assets, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentVersionNames(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentVideo(v *types.Video, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.S3Object != nil {
		ok := object.Key("S3Object")
		if err := awsAwsjson11_serializeDocumentS3Object(v.S3Object, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCompareFacesInput(v *CompareFacesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.QualityFilter) > 0 {
		ok := object.Key("QualityFilter")
		ok.String(string(v.QualityFilter))
	}

	if v.SimilarityThreshold != nil {
		ok := object.Key("SimilarityThreshold")
		switch {
		case math.IsNaN(float64(*v.SimilarityThreshold)):
			ok.String("NaN")

		case math.IsInf(float64(*v.SimilarityThreshold), 1):
			ok.String("Infinity")

		case math.IsInf(float64(*v.SimilarityThreshold), -1):
			ok.String("-Infinity")

		default:
			ok.Float(*v.SimilarityThreshold)

		}
	}

	if v.SourceImage != nil {
		ok := object.Key("SourceImage")
		if err := awsAwsjson11_serializeDocumentImage(v.SourceImage, ok); err != nil {
			return err
		}
	}

	if v.TargetImage != nil {
		ok := object.Key("TargetImage")
		if err := awsAwsjson11_serializeDocumentImage(v.TargetImage, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCopyProjectVersionInput(v *CopyProjectVersionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DestinationProjectArn != nil {
		ok := object.Key("DestinationProjectArn")
		ok.String(*v.DestinationProjectArn)
	}

	if v.KmsKeyId != nil {
		ok := object.Key("KmsKeyId")
		ok.String(*v.KmsKeyId)
	}

	if v.OutputConfig != nil {
		ok := object.Key("OutputConfig")
		if err := awsAwsjson11_serializeDocumentOutputConfig(v.OutputConfig, ok); err != nil {
			return err
		}
	}

	if v.SourceProjectArn != nil {
		ok := object.Key("SourceProjectArn")
		ok.String(*v.SourceProjectArn)
	}

	if v.SourceProjectVersionArn != nil {
		ok := object.Key("SourceProjectVersionArn")
		ok.String(*v.SourceProjectVersionArn)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.VersionName != nil {
		ok := object.Key("VersionName")
		ok.String(*v.VersionName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateCollectionInput(v *CreateCollectionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CollectionId != nil {
		ok := object.Key("CollectionId")
		ok.String(*v.CollectionId)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateDatasetInput(v *CreateDatasetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DatasetSource != nil {
		ok := object.Key("DatasetSource")
		if err := awsAwsjson11_serializeDocumentDatasetSource(v.DatasetSource, ok); err != nil {
			return err
		}
	}

	if len(v.DatasetType) > 0 {
		ok := object.Key("DatasetType")
		ok.String(string(v.DatasetType))
	}

	if v.ProjectArn != nil {
		ok := object.Key("ProjectArn")
		ok.String(*v.ProjectArn)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateProjectInput(v *CreateProjectInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ProjectName != nil {
		ok := object.Key("ProjectName")
		ok.String(*v.ProjectName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateProjectVersionInput(v *CreateProjectVersionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.KmsKeyId != nil {
		ok := object.Key("KmsKeyId")
		ok.String(*v.KmsKeyId)
	}

	if v.OutputConfig != nil {
		ok := object.Key("OutputConfig")
		if err := awsAwsjson11_serializeDocumentOutputConfig(v.OutputConfig, ok); err != nil {
			return err
		}
	}

	if v.ProjectArn != nil {
		ok := object.Key("ProjectArn")
		ok.String(*v.ProjectArn)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.TestingData != nil {
		ok := object.Key("TestingData")
		if err := awsAwsjson11_serializeDocumentTestingData(v.TestingData, ok); err != nil {
			return err
		}
	}

	if v.TrainingData != nil {
		ok := object.Key("TrainingData")
		if err := awsAwsjson11_serializeDocumentTrainingData(v.TrainingData, ok); err != nil {
			return err
		}
	}

	if v.VersionName != nil {
		ok := object.Key("VersionName")
		ok.String(*v.VersionName)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateStreamProcessorInput(v *CreateStreamProcessorInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataSharingPreference != nil {
		ok := object.Key("DataSharingPreference")
		if err := awsAwsjson11_serializeDocumentStreamProcessorDataSharingPreference(v.DataSharingPreference, ok); err != nil {
			return err
		}
	}

	if v.Input != nil {
		ok := object.Key("Input")
		if err := awsAwsjson11_serializeDocumentStreamProcessorInput(v.Input, ok); err != nil {
			return err
		}
	}

	if v.KmsKeyId != nil {
		ok := object.Key("KmsKeyId")
		ok.String(*v.KmsKeyId)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.NotificationChannel != nil {
		ok := object.Key("NotificationChannel")
		if err := awsAwsjson11_serializeDocumentStreamProcessorNotificationChannel(v.NotificationChannel, ok); err != nil {
			return err
		}
	}

	if v.Output != nil {
		ok := object.Key("Output")
		if err := awsAwsjson11_serializeDocumentStreamProcessorOutput(v.Output, ok); err != nil {
			return err
		}
	}

	if v.RegionsOfInterest != nil {
		ok := object.Key("RegionsOfInterest")
		if err := awsAwsjson11_serializeDocumentRegionsOfInterest(v.RegionsOfInterest, ok); err != nil {
			return err
		}
	}

	if v.RoleArn != nil {
		ok := object.Key("RoleArn")
		ok.String(*v.RoleArn)
	}

	if v.Settings != nil {
		ok := object.Key("Settings")
		if err := awsAwsjson11_serializeDocumentStreamProcessorSettings(v.Settings, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteCollectionInput(v *DeleteCollectionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CollectionId != nil {
		ok := object.Key("CollectionId")
		ok.String(*v.CollectionId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteDatasetInput(v *DeleteDatasetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DatasetArn != nil {
		ok := object.Key("DatasetArn")
		ok.String(*v.DatasetArn)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteFacesInput(v *DeleteFacesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CollectionId != nil {
		ok := object.Key("CollectionId")
		ok.String(*v.CollectionId)
	}

	if v.FaceIds != nil {
		ok := object.Key("FaceIds")
		if err := awsAwsjson11_serializeDocumentFaceIdList(v.FaceIds, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteProjectInput(v *DeleteProjectInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ProjectArn != nil {
		ok := object.Key("ProjectArn")
		ok.String(*v.ProjectArn)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteProjectPolicyInput(v *DeleteProjectPolicyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PolicyName != nil {
		ok := object.Key("PolicyName")
		ok.String(*v.PolicyName)
	}

	if v.PolicyRevisionId != nil {
		ok := object.Key("PolicyRevisionId")
		ok.String(*v.PolicyRevisionId)
	}

	if v.ProjectArn != nil {
		ok := object.Key("ProjectArn")
		ok.String(*v.ProjectArn)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteProjectVersionInput(v *DeleteProjectVersionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ProjectVersionArn != nil {
		ok := object.Key("ProjectVersionArn")
		ok.String(*v.ProjectVersionArn)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteStreamProcessorInput(v *DeleteStreamProcessorInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeCollectionInput(v *DescribeCollectionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CollectionId != nil {
		ok := object.Key("CollectionId")
		ok.String(*v.CollectionId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeDatasetInput(v *DescribeDatasetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DatasetArn != nil {
		ok := object.Key("DatasetArn")
		ok.String(*v.DatasetArn)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeProjectsInput(v *DescribeProjectsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.ProjectNames != nil {
		ok := object.Key("ProjectNames")
		if err := awsAwsjson11_serializeDocumentProjectNames(v.ProjectNames, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeProjectVersionsInput(v *DescribeProjectVersionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.ProjectArn != nil {
		ok := object.Key("ProjectArn")
		ok.String(*v.ProjectArn)
	}

	if v.VersionNames != nil {
		ok := object.Key("VersionNames")
		if err := awsAwsjson11_serializeDocumentVersionNames(v.VersionNames, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeStreamProcessorInput(v *DescribeStreamProcessorInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDetectCustomLabelsInput(v *DetectCustomLabelsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Image != nil {
		ok := object.Key("Image")
		if err := awsAwsjson11_serializeDocumentImage(v.Image, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.MinConfidence != nil {
		ok := object.Key("MinConfidence")
		switch {
		case math.IsNaN(float64(*v.MinConfidence)):
			ok.String("NaN")

		case math.IsInf(float64(*v.MinConfidence), 1):
			ok.String("Infinity")

		case math.IsInf(float64(*v.MinConfidence), -1):
			ok.String("-Infinity")

		default:
			ok.Float(*v.MinConfidence)

		}
	}

	if v.ProjectVersionArn != nil {
		ok := object.Key("ProjectVersionArn")
		ok.String(*v.ProjectVersionArn)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDetectFacesInput(v *DetectFacesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Attributes != nil {
		ok := object.Key("Attributes")
		if err := awsAwsjson11_serializeDocumentAttributes(v.Attributes, ok); err != nil {
			return err
		}
	}

	if v.Image != nil {
		ok := object.Key("Image")
		if err := awsAwsjson11_serializeDocumentImage(v.Image, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDetectLabelsInput(v *DetectLabelsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Image != nil {
		ok := object.Key("Image")
		if err := awsAwsjson11_serializeDocumentImage(v.Image, ok); err != nil {
			return err
		}
	}

	if v.MaxLabels != nil {
		ok := object.Key("MaxLabels")
		ok.Integer(*v.MaxLabels)
	}

	if v.MinConfidence != nil {
		ok := object.Key("MinConfidence")
		switch {
		case math.IsNaN(float64(*v.MinConfidence)):
			ok.String("NaN")

		case math.IsInf(float64(*v.MinConfidence), 1):
			ok.String("Infinity")

		case math.IsInf(float64(*v.MinConfidence), -1):
			ok.String("-Infinity")

		default:
			ok.Float(*v.MinConfidence)

		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDetectModerationLabelsInput(v *DetectModerationLabelsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.HumanLoopConfig != nil {
		ok := object.Key("HumanLoopConfig")
		if err := awsAwsjson11_serializeDocumentHumanLoopConfig(v.HumanLoopConfig, ok); err != nil {
			return err
		}
	}

	if v.Image != nil {
		ok := object.Key("Image")
		if err := awsAwsjson11_serializeDocumentImage(v.Image, ok); err != nil {
			return err
		}
	}

	if v.MinConfidence != nil {
		ok := object.Key("MinConfidence")
		switch {
		case math.IsNaN(float64(*v.MinConfidence)):
			ok.String("NaN")

		case math.IsInf(float64(*v.MinConfidence), 1):
			ok.String("Infinity")

		case math.IsInf(float64(*v.MinConfidence), -1):
			ok.String("-Infinity")

		default:
			ok.Float(*v.MinConfidence)

		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDetectProtectiveEquipmentInput(v *DetectProtectiveEquipmentInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Image != nil {
		ok := object.Key("Image")
		if err := awsAwsjson11_serializeDocumentImage(v.Image, ok); err != nil {
			return err
		}
	}

	if v.SummarizationAttributes != nil {
		ok := object.Key("SummarizationAttributes")
		if err := awsAwsjson11_serializeDocumentProtectiveEquipmentSummarizationAttributes(v.SummarizationAttributes, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDetectTextInput(v *DetectTextInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Filters != nil {
		ok := object.Key("Filters")
		if err := awsAwsjson11_serializeDocumentDetectTextFilters(v.Filters, ok); err != nil {
			return err
		}
	}

	if v.Image != nil {
		ok := object.Key("Image")
		if err := awsAwsjson11_serializeDocumentImage(v.Image, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDistributeDatasetEntriesInput(v *DistributeDatasetEntriesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Datasets != nil {
		ok := object.Key("Datasets")
		if err := awsAwsjson11_serializeDocumentDistributeDatasetMetadataList(v.Datasets, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetCelebrityInfoInput(v *GetCelebrityInfoInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Id != nil {
		ok := object.Key("Id")
		ok.String(*v.Id)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetCelebrityRecognitionInput(v *GetCelebrityRecognitionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JobId != nil {
		ok := object.Key("JobId")
		ok.String(*v.JobId)
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if len(v.SortBy) > 0 {
		ok := object.Key("SortBy")
		ok.String(string(v.SortBy))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetContentModerationInput(v *GetContentModerationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JobId != nil {
		ok := object.Key("JobId")
		ok.String(*v.JobId)
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if len(v.SortBy) > 0 {
		ok := object.Key("SortBy")
		ok.String(string(v.SortBy))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetFaceDetectionInput(v *GetFaceDetectionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JobId != nil {
		ok := object.Key("JobId")
		ok.String(*v.JobId)
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetFaceSearchInput(v *GetFaceSearchInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JobId != nil {
		ok := object.Key("JobId")
		ok.String(*v.JobId)
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if len(v.SortBy) > 0 {
		ok := object.Key("SortBy")
		ok.String(string(v.SortBy))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetLabelDetectionInput(v *GetLabelDetectionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JobId != nil {
		ok := object.Key("JobId")
		ok.String(*v.JobId)
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if len(v.SortBy) > 0 {
		ok := object.Key("SortBy")
		ok.String(string(v.SortBy))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetPersonTrackingInput(v *GetPersonTrackingInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JobId != nil {
		ok := object.Key("JobId")
		ok.String(*v.JobId)
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if len(v.SortBy) > 0 {
		ok := object.Key("SortBy")
		ok.String(string(v.SortBy))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetSegmentDetectionInput(v *GetSegmentDetectionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JobId != nil {
		ok := object.Key("JobId")
		ok.String(*v.JobId)
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetTextDetectionInput(v *GetTextDetectionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JobId != nil {
		ok := object.Key("JobId")
		ok.String(*v.JobId)
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentIndexFacesInput(v *IndexFacesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CollectionId != nil {
		ok := object.Key("CollectionId")
		ok.String(*v.CollectionId)
	}

	if v.DetectionAttributes != nil {
		ok := object.Key("DetectionAttributes")
		if err := awsAwsjson11_serializeDocumentAttributes(v.DetectionAttributes, ok); err != nil {
			return err
		}
	}

	if v.ExternalImageId != nil {
		ok := object.Key("ExternalImageId")
		ok.String(*v.ExternalImageId)
	}

	if v.Image != nil {
		ok := object.Key("Image")
		if err := awsAwsjson11_serializeDocumentImage(v.Image, ok); err != nil {
			return err
		}
	}

	if v.MaxFaces != nil {
		ok := object.Key("MaxFaces")
		ok.Integer(*v.MaxFaces)
	}

	if len(v.QualityFilter) > 0 {
		ok := object.Key("QualityFilter")
		ok.String(string(v.QualityFilter))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListCollectionsInput(v *ListCollectionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListDatasetEntriesInput(v *ListDatasetEntriesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ContainsLabels != nil {
		ok := object.Key("ContainsLabels")
		if err := awsAwsjson11_serializeDocumentDatasetLabels(v.ContainsLabels, ok); err != nil {
			return err
		}
	}

	if v.DatasetArn != nil {
		ok := object.Key("DatasetArn")
		ok.String(*v.DatasetArn)
	}

	if v.HasErrors != nil {
		ok := object.Key("HasErrors")
		ok.Boolean(*v.HasErrors)
	}

	if v.Labeled != nil {
		ok := object.Key("Labeled")
		ok.Boolean(*v.Labeled)
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.SourceRefContains != nil {
		ok := object.Key("SourceRefContains")
		ok.String(*v.SourceRefContains)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListDatasetLabelsInput(v *ListDatasetLabelsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DatasetArn != nil {
		ok := object.Key("DatasetArn")
		ok.String(*v.DatasetArn)
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListFacesInput(v *ListFacesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CollectionId != nil {
		ok := object.Key("CollectionId")
		ok.String(*v.CollectionId)
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListProjectPoliciesInput(v *ListProjectPoliciesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.ProjectArn != nil {
		ok := object.Key("ProjectArn")
		ok.String(*v.ProjectArn)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListStreamProcessorsInput(v *ListStreamProcessorsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListTagsForResourceInput(v *ListTagsForResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceArn != nil {
		ok := object.Key("ResourceArn")
		ok.String(*v.ResourceArn)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentPutProjectPolicyInput(v *PutProjectPolicyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PolicyDocument != nil {
		ok := object.Key("PolicyDocument")
		ok.String(*v.PolicyDocument)
	}

	if v.PolicyName != nil {
		ok := object.Key("PolicyName")
		ok.String(*v.PolicyName)
	}

	if v.PolicyRevisionId != nil {
		ok := object.Key("PolicyRevisionId")
		ok.String(*v.PolicyRevisionId)
	}

	if v.ProjectArn != nil {
		ok := object.Key("ProjectArn")
		ok.String(*v.ProjectArn)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentRecognizeCelebritiesInput(v *RecognizeCelebritiesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Image != nil {
		ok := object.Key("Image")
		if err := awsAwsjson11_serializeDocumentImage(v.Image, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentSearchFacesByImageInput(v *SearchFacesByImageInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CollectionId != nil {
		ok := object.Key("CollectionId")
		ok.String(*v.CollectionId)
	}

	if v.FaceMatchThreshold != nil {
		ok := object.Key("FaceMatchThreshold")
		switch {
		case math.IsNaN(float64(*v.FaceMatchThreshold)):
			ok.String("NaN")

		case math.IsInf(float64(*v.FaceMatchThreshold), 1):
			ok.String("Infinity")

		case math.IsInf(float64(*v.FaceMatchThreshold), -1):
			ok.String("-Infinity")

		default:
			ok.Float(*v.FaceMatchThreshold)

		}
	}

	if v.Image != nil {
		ok := object.Key("Image")
		if err := awsAwsjson11_serializeDocumentImage(v.Image, ok); err != nil {
			return err
		}
	}

	if v.MaxFaces != nil {
		ok := object.Key("MaxFaces")
		ok.Integer(*v.MaxFaces)
	}

	if len(v.QualityFilter) > 0 {
		ok := object.Key("QualityFilter")
		ok.String(string(v.QualityFilter))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentSearchFacesInput(v *SearchFacesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CollectionId != nil {
		ok := object.Key("CollectionId")
		ok.String(*v.CollectionId)
	}

	if v.FaceId != nil {
		ok := object.Key("FaceId")
		ok.String(*v.FaceId)
	}

	if v.FaceMatchThreshold != nil {
		ok := object.Key("FaceMatchThreshold")
		switch {
		case math.IsNaN(float64(*v.FaceMatchThreshold)):
			ok.String("NaN")

		case math.IsInf(float64(*v.FaceMatchThreshold), 1):
			ok.String("Infinity")

		case math.IsInf(float64(*v.FaceMatchThreshold), -1):
			ok.String("-Infinity")

		default:
			ok.Float(*v.FaceMatchThreshold)

		}
	}

	if v.MaxFaces != nil {
		ok := object.Key("MaxFaces")
		ok.Integer(*v.MaxFaces)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentStartCelebrityRecognitionInput(v *StartCelebrityRecognitionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("ClientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.JobTag != nil {
		ok := object.Key("JobTag")
		ok.String(*v.JobTag)
	}

	if v.NotificationChannel != nil {
		ok := object.Key("NotificationChannel")
		if err := awsAwsjson11_serializeDocumentNotificationChannel(v.NotificationChannel, ok); err != nil {
			return err
		}
	}

	if v.Video != nil {
		ok := object.Key("Video")
		if err := awsAwsjson11_serializeDocumentVideo(v.Video, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentStartContentModerationInput(v *StartContentModerationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("ClientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.JobTag != nil {
		ok := object.Key("JobTag")
		ok.String(*v.JobTag)
	}

	if v.MinConfidence != nil {
		ok := object.Key("MinConfidence")
		switch {
		case math.IsNaN(float64(*v.MinConfidence)):
			ok.String("NaN")

		case math.IsInf(float64(*v.MinConfidence), 1):
			ok.String("Infinity")

		case math.IsInf(float64(*v.MinConfidence), -1):
			ok.String("-Infinity")

		default:
			ok.Float(*v.MinConfidence)

		}
	}

	if v.NotificationChannel != nil {
		ok := object.Key("NotificationChannel")
		if err := awsAwsjson11_serializeDocumentNotificationChannel(v.NotificationChannel, ok); err != nil {
			return err
		}
	}

	if v.Video != nil {
		ok := object.Key("Video")
		if err := awsAwsjson11_serializeDocumentVideo(v.Video, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentStartFaceDetectionInput(v *StartFaceDetectionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("ClientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if len(v.FaceAttributes) > 0 {
		ok := object.Key("FaceAttributes")
		ok.String(string(v.FaceAttributes))
	}

	if v.JobTag != nil {
		ok := object.Key("JobTag")
		ok.String(*v.JobTag)
	}

	if v.NotificationChannel != nil {
		ok := object.Key("NotificationChannel")
		if err := awsAwsjson11_serializeDocumentNotificationChannel(v.NotificationChannel, ok); err != nil {
			return err
		}
	}

	if v.Video != nil {
		ok := object.Key("Video")
		if err := awsAwsjson11_serializeDocumentVideo(v.Video, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentStartFaceSearchInput(v *StartFaceSearchInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("ClientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.CollectionId != nil {
		ok := object.Key("CollectionId")
		ok.String(*v.CollectionId)
	}

	if v.FaceMatchThreshold != nil {
		ok := object.Key("FaceMatchThreshold")
		switch {
		case math.IsNaN(float64(*v.FaceMatchThreshold)):
			ok.String("NaN")

		case math.IsInf(float64(*v.FaceMatchThreshold), 1):
			ok.String("Infinity")

		case math.IsInf(float64(*v.FaceMatchThreshold), -1):
			ok.String("-Infinity")

		default:
			ok.Float(*v.FaceMatchThreshold)

		}
	}

	if v.JobTag != nil {
		ok := object.Key("JobTag")
		ok.String(*v.JobTag)
	}

	if v.NotificationChannel != nil {
		ok := object.Key("NotificationChannel")
		if err := awsAwsjson11_serializeDocumentNotificationChannel(v.NotificationChannel, ok); err != nil {
			return err
		}
	}

	if v.Video != nil {
		ok := object.Key("Video")
		if err := awsAwsjson11_serializeDocumentVideo(v.Video, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentStartLabelDetectionInput(v *StartLabelDetectionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("ClientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.JobTag != nil {
		ok := object.Key("JobTag")
		ok.String(*v.JobTag)
	}

	if v.MinConfidence != nil {
		ok := object.Key("MinConfidence")
		switch {
		case math.IsNaN(float64(*v.MinConfidence)):
			ok.String("NaN")

		case math.IsInf(float64(*v.MinConfidence), 1):
			ok.String("Infinity")

		case math.IsInf(float64(*v.MinConfidence), -1):
			ok.String("-Infinity")

		default:
			ok.Float(*v.MinConfidence)

		}
	}

	if v.NotificationChannel != nil {
		ok := object.Key("NotificationChannel")
		if err := awsAwsjson11_serializeDocumentNotificationChannel(v.NotificationChannel, ok); err != nil {
			return err
		}
	}

	if v.Video != nil {
		ok := object.Key("Video")
		if err := awsAwsjson11_serializeDocumentVideo(v.Video, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentStartPersonTrackingInput(v *StartPersonTrackingInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("ClientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.JobTag != nil {
		ok := object.Key("JobTag")
		ok.String(*v.JobTag)
	}

	if v.NotificationChannel != nil {
		ok := object.Key("NotificationChannel")
		if err := awsAwsjson11_serializeDocumentNotificationChannel(v.NotificationChannel, ok); err != nil {
			return err
		}
	}

	if v.Video != nil {
		ok := object.Key("Video")
		if err := awsAwsjson11_serializeDocumentVideo(v.Video, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentStartProjectVersionInput(v *StartProjectVersionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxInferenceUnits != nil {
		ok := object.Key("MaxInferenceUnits")
		ok.Integer(*v.MaxInferenceUnits)
	}

	if v.MinInferenceUnits != nil {
		ok := object.Key("MinInferenceUnits")
		ok.Integer(*v.MinInferenceUnits)
	}

	if v.ProjectVersionArn != nil {
		ok := object.Key("ProjectVersionArn")
		ok.String(*v.ProjectVersionArn)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentStartSegmentDetectionInput(v *StartSegmentDetectionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("ClientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.Filters != nil {
		ok := object.Key("Filters")
		if err := awsAwsjson11_serializeDocumentStartSegmentDetectionFilters(v.Filters, ok); err != nil {
			return err
		}
	}

	if v.JobTag != nil {
		ok := object.Key("JobTag")
		ok.String(*v.JobTag)
	}

	if v.NotificationChannel != nil {
		ok := object.Key("NotificationChannel")
		if err := awsAwsjson11_serializeDocumentNotificationChannel(v.NotificationChannel, ok); err != nil {
			return err
		}
	}

	if v.SegmentTypes != nil {
		ok := object.Key("SegmentTypes")
		if err := awsAwsjson11_serializeDocumentSegmentTypes(v.SegmentTypes, ok); err != nil {
			return err
		}
	}

	if v.Video != nil {
		ok := object.Key("Video")
		if err := awsAwsjson11_serializeDocumentVideo(v.Video, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentStartStreamProcessorInput(v *StartStreamProcessorInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.StartSelector != nil {
		ok := object.Key("StartSelector")
		if err := awsAwsjson11_serializeDocumentStreamProcessingStartSelector(v.StartSelector, ok); err != nil {
			return err
		}
	}

	if v.StopSelector != nil {
		ok := object.Key("StopSelector")
		if err := awsAwsjson11_serializeDocumentStreamProcessingStopSelector(v.StopSelector, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentStartTextDetectionInput(v *StartTextDetectionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("ClientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.Filters != nil {
		ok := object.Key("Filters")
		if err := awsAwsjson11_serializeDocumentStartTextDetectionFilters(v.Filters, ok); err != nil {
			return err
		}
	}

	if v.JobTag != nil {
		ok := object.Key("JobTag")
		ok.String(*v.JobTag)
	}

	if v.NotificationChannel != nil {
		ok := object.Key("NotificationChannel")
		if err := awsAwsjson11_serializeDocumentNotificationChannel(v.NotificationChannel, ok); err != nil {
			return err
		}
	}

	if v.Video != nil {
		ok := object.Key("Video")
		if err := awsAwsjson11_serializeDocumentVideo(v.Video, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentStopProjectVersionInput(v *StopProjectVersionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ProjectVersionArn != nil {
		ok := object.Key("ProjectVersionArn")
		ok.String(*v.ProjectVersionArn)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentStopStreamProcessorInput(v *StopStreamProcessorInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceArn != nil {
		ok := object.Key("ResourceArn")
		ok.String(*v.ResourceArn)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUntagResourceInput(v *UntagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceArn != nil {
		ok := object.Key("ResourceArn")
		ok.String(*v.ResourceArn)
	}

	if v.TagKeys != nil {
		ok := object.Key("TagKeys")
		if err := awsAwsjson11_serializeDocumentTagKeyList(v.TagKeys, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateDatasetEntriesInput(v *UpdateDatasetEntriesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Changes != nil {
		ok := object.Key("Changes")
		if err := awsAwsjson11_serializeDocumentDatasetChanges(v.Changes, ok); err != nil {
			return err
		}
	}

	if v.DatasetArn != nil {
		ok := object.Key("DatasetArn")
		ok.String(*v.DatasetArn)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateStreamProcessorInput(v *UpdateStreamProcessorInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataSharingPreferenceForUpdate != nil {
		ok := object.Key("DataSharingPreferenceForUpdate")
		if err := awsAwsjson11_serializeDocumentStreamProcessorDataSharingPreference(v.DataSharingPreferenceForUpdate, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.ParametersToDelete != nil {
		ok := object.Key("ParametersToDelete")
		if err := awsAwsjson11_serializeDocumentStreamProcessorParametersToDelete(v.ParametersToDelete, ok); err != nil {
			return err
		}
	}

	if v.RegionsOfInterestForUpdate != nil {
		ok := object.Key("RegionsOfInterestForUpdate")
		if err := awsAwsjson11_serializeDocumentRegionsOfInterest(v.RegionsOfInterestForUpdate, ok); err != nil {
			return err
		}
	}

	if v.SettingsForUpdate != nil {
		ok := object.Key("SettingsForUpdate")
		if err := awsAwsjson11_serializeDocumentStreamProcessorSettingsForUpdate(v.SettingsForUpdate, ok); err != nil {
			return err
		}
	}

	return nil
}
